.onLoad <- function(libname, pkgname)
{
    options(DelayedArray.simplify=TRUE)
    options(DelayedArray.block.size=DEFAULT_BLOCK_SIZE)
    ## By default bplapply() uses the SnowParam() backend on Windows, which
    ## introduces **a lot** of overhead in the context of block processing.
    ## See https://github.com/Bioconductor/BiocParallel/issues/78
    ## So we disable parallel evaluation by default on this platform, by
    ## setting the default backend to SerialParam().
    if (.Platform$OS.type == "windows")
        BiocParallel::register(SerialParam())
}

.test <- function()
{
    setRealizationBackend("RleArray")
    BiocGenerics:::testPackage("DelayedArray")
}

