\name{make_layout-HeatmapList-method}
\alias{make_layout,HeatmapList-method}
\title{
Make Layout for the Heatmap List
}
\description{
Make Layout for the Heatmap List
}
\usage{
\S4method{make_layout}{HeatmapList}(object,
    
    row_title = character(0),
    row_title_side = c("left", "right"),
    row_title_gp = gpar(fontsize = 14),
    column_title = character(0),
    column_title_side = c("top", "bottom"),
    column_title_gp = gpar(fontsize = 14),
    
    heatmap_legend_side = c("right", "left", "bottom", "top"),
    merge_legends = FALSE,
    show_heatmap_legend = TRUE,
    heatmap_legend_list = list(),
    annotation_legend_side = c("right", "left", "bottom", "top"),
    show_annotation_legend = TRUE,
    annotation_legend_list = list(),
    
    ht_gap = unit(2, "mm"),
    
    main_heatmap = which(sapply(object@ht_list, inherits, "Heatmap"))[1],
    padding = GLOBAL_PADDING,
    
    auto_adjust = TRUE,
    row_dend_side = c("original", "left", "right"),
    row_sub_title_side = c("original", "left", "right"),
    column_dend_side = c("original", "top", "bottom"),
    column_sub_title_side = c("original", "top", "bottom"),
    
    row_gap = NULL,
    cluster_rows = NULL,
    cluster_row_slices = NULL,
    clustering_distance_rows = NULL,
    clustering_method_rows = NULL,
    row_dend_width = NULL,
    show_row_dend = NULL,
    row_dend_reorder = NULL,
    row_dend_gp = NULL,
    row_order = NULL,
    row_km = NULL,
    row_km_repeats = NULL,
    row_split = NULL,
    height = NULL,
    heatmap_height = NULL,
    
    column_gap = NULL,
    cluster_columns = NULL,
    cluster_column_slices = NULL,
    clustering_distance_columns = NULL,
    clustering_method_columns = NULL,
    column_dend_width = NULL,
    show_column_dend = NULL,
    column_dend_reorder = NULL,
    column_dend_gp = NULL,
    column_order = NULL,
    column_km = NULL,
    column_km_repeats = NULL,
    column_split = NULL,
    width = NULL,
    heatmap_width = NULL,
    
    use_raster = NULL,
    raster_device = NULL,
    raster_quality = NULL,
    raster_device_param = NULL,
    raster_resize = NULL)
}
\arguments{

  \item{object}{A \code{\link{HeatmapList-class}} object.}
  \item{row_title}{Title on the row.}
  \item{row_title_side}{Will the title be put on the left or right of the heatmap list?}
  \item{row_title_gp}{Graphic parameters for the row title.}
  \item{column_title}{Title on the column.}
  \item{column_title_side}{Will the title be put on the top or bottom of the heatmap?}
  \item{column_title_gp}{Graphic parameters for the column title.}
  \item{heatmap_legend_side}{Side of the heatmap legends.}
  \item{merge_legends}{Whether to put heatmap legends and annotation legends together. By default they are put in different viewports.}
  \item{show_heatmap_legend}{Whether show heatmap legends.}
  \item{heatmap_legend_list}{A list of self-defined legends, should be wrapped into a list of \code{\link[grid:grid.grob]{grob}} objects. Normally they are constructed by \code{\link{Legend}}. }
  \item{annotation_legend_side}{Side of annotation legends.}
  \item{show_annotation_legend}{Whether show annotation legends.}
  \item{annotation_legend_list}{A list of self-defined legends, should be wrapped into a list of \code{\link[grid:grid.grob]{grob}} objects. Normally they are constructed by \code{\link{Legend}}.}
  \item{ht_gap}{Gap between heatmaps, should be a \code{\link[grid]{unit}} object. It can be a vector of length 1 or the number of heamtaps/annotations.}
  \item{main_heatmap}{Name or index for the main heatmap.}
  \item{padding}{Padding of the whole plot. The four values correspond to the bottom, left, top and right paddings.}
  \item{auto_adjust}{whether apply automatic adjustment? The auto-adjustment includes turning off dendrograms, titles and row/columns for non-main heatmaps.}
  \item{row_dend_side}{If auto-adjustment is on, to put the row dendrograms of the main heatmap to the most left side of the heatmap list or the most right side?}
  \item{row_sub_title_side}{There can be sub titles generated by the splitting of heatmaps. Similar setting as \code{row_dend_side}.}
  \item{column_dend_side}{Similar setting as \code{row_dend_side}.}
  \item{column_sub_title_side}{Similar setting as \code{row_sub_title_side}.}
  \item{row_gap}{Overwrite the corresponding setting in the main heatmap.}
  \item{cluster_rows}{Overwrite the corresponding setting in the main heatmap.}
  \item{cluster_row_slices}{Overwrite the corresponding setting in the main heatmap.}
  \item{clustering_distance_rows}{Overwrite the corresponding setting in the main heatmap.}
  \item{clustering_method_rows}{Overwrite the corresponding setting in the main heatmap.same setting as in \code{\link{Heatmap}}, if it is specified, \code{clustering_method_rows} in main heatmap is ignored.}
  \item{row_dend_width}{Overwrite the corresponding setting in the main heatmap.}
  \item{show_row_dend}{same Overwrite the corresponding setting in the main heatmap.}
  \item{row_dend_reorder}{Overwrite the corresponding setting in the main heatmap.}
  \item{row_dend_gp}{Overwrite the corresponding setting in the main heatmap.}
  \item{row_order}{Overwrite the corresponding setting in the main heatmap.}
  \item{row_km}{Overwrite the corresponding setting in the main heatmap.}
  \item{row_km_repeats}{Overwrite the corresponding setting in the main heatmap.}
  \item{row_split}{Overwrite the corresponding setting in the main heatmap.}
  \item{height}{Overwrite the corresponding setting in the main heatmap.}
  \item{heatmap_height}{Overwrite the corresponding setting in the main heatmap.}
  \item{column_gap}{Overwrite the corresponding setting in the main heatmap.}
  \item{cluster_columns}{Overwrite the corresponding setting in the main heatmap.}
  \item{cluster_column_slices}{Overwrite the corresponding setting in the main heatmap.}
  \item{clustering_distance_columns}{Overwrite the corresponding setting in the main heatmap.}
  \item{clustering_method_columns}{Overwrite the corresponding setting in the main heatmap.}
  \item{column_dend_width}{column Overwrite the corresponding setting in the main heatmap.}
  \item{show_column_dend}{Overwrite the corresponding setting in the main heatmap.}
  \item{column_dend_reorder}{Overwrite the corresponding setting in the main heatmap.}
  \item{column_dend_gp}{Overwrite the corresponding setting in the main heatmap.}
  \item{column_order}{Overwrite the corresponding setting in the main heatmap.}
  \item{column_km}{Overwrite the corresponding setting in the main heatmap.}
  \item{column_km_repeats}{Overwrite the corresponding setting in the main heatmap.}
  \item{column_split}{Overwrite the corresponding setting in the main heatmap.}
  \item{width}{Overwrite the corresponding setting in the main heatmap.}
  \item{heatmap_width}{Overwrite the corresponding setting in the main heatmap.}
  \item{use_raster}{Overwrite the corresponding setting in every heatmap.}
  \item{raster_device}{Overwrite the corresponding setting in every heatmap.}
  \item{raster_quality}{Overwrite the corresponding setting in every heatmap.}
  \item{raster_device_param}{Overwrite the corresponding setting in every heatmap.}
  \item{raster_resize}{Overwrite the corresponding setting in every heatmap.}

}
\details{
It sets the size of each component of the heatmap list and adjusts graphic
parameters for each heatmap if necessary.

This function is only for internal use.
}
\value{
A \code{\link{HeatmapList-class}} object in which settings for all heatmap are adjusted.
}
\author{
Zuguang Gu <z.gu@dkfz.de>
}
\examples{
# There is no example
NULL

}
