% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ballgown-get-methods.R
\docType{methods}
\name{geneNames}
\alias{geneNames}
\alias{geneNames}
\alias{geneNames,ballgown-method}
\title{get gene names from a ballgown object}
\usage{
geneNames(x)

\S4method{geneNames}{ballgown}(x)
}
\arguments{
\item{x}{a ballgown object}
}
\value{
named vector of gene names included in the ballgown object, named
and ordered by corresponding numeric transcript ID.
}
\description{
get gene names from a ballgown object
}
\details{
This vector differs from that produced by geneIDs in that geneNames produces
*annotated* gene names that correspond to assembled transcripts. The
return will be empty/blank/NA if the transcriptome assembly is de novo 
(i.e., was not compared to an annotation before the ballgown object was
created). See \code{\link{getGenes}} for matching transcripts to gene names.
Some entries of this vector will be empty/blank/NA if the corresponding 
transcript did not overlap any annotated genes.
}
\examples{
data(bg)
# this is a de novo assembly, so it does not contain gene info as it stands
# but we can add it:
annot = system.file('extdata', 'annot.gtf.gz', package='ballgown')
gnames = getGenes(annot, structure(bg)$trans, UCSC=FALSE)
gnames_first = lapply(gnames, function(x) x[1]) #just take 1 overlapping gene
expr(bg)$trans$gene_name = gnames_first

# now we can extract these gene names:
geneNames(bg)

}
\seealso{
\code{\link{geneIDs}}
}
