% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapseTranscripts.R
\name{collapseTranscripts}
\alias{collapseTranscripts}
\title{cluster a gene's transcripts and calculate cluster-level expression}
\usage{
collapseTranscripts(gene, gown, meas = "FPKM", method = c("hclust",
  "kmeans"), k = NULL)
}
\arguments{
\item{gene}{which gene's transcripts should be clustered}

\item{gown}{ballgown object}

\item{meas}{which transcript-level expression measurement to use 
(\code{'cov'}, average per-base coverage, or \code{'FPKM'})}

\item{method}{which clustering method to use: \code{'hclust'} (hierarchical
clustering) or \code{'kmeans'} (k-means clustering).}

\item{k}{how many clusters to use.}
}
\value{
list with two elements:
\itemize{
  \item \code{tab}, a cluster-by-sample table of expression measurements
    (\code{meas}, either cov or FPKM), where the expression measurement for 
    each cluster is the mean (for \code{'cov'}) or aggregate (for 
    \code{'FPKM'}, as in \code{\link{gexpr}}) expression measurement for all
    the transcripts in that cluster. This table can be used as the 
    \code{gowntable} argument to \code{\link{stattest}}, if differential
    expression results for transcript *clusters* are desired. 
  \item \code{cl} output from \code{\link{clusterTranscripts}} that was run 
    to produce \code{tab}, for reference. Cluster IDs in the \code{cluster} 
    component correspond to row names of \code{tab}
}
}
\description{
cluster a gene's transcripts and calculate cluster-level expression
}
\examples{
data(bg)
collapseTranscripts(bg, gene='XLOC_000454', meas='FPKM', method='kmeans')

}
\seealso{
\code{\link{hclust}}, \code{\link{kmeans}}, 
   \code{\link{clusterTranscripts}}, \code{\link{plotLatentTranscripts}}
}
\author{
Alyssa Frazee
}
