% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructor.R
\name{ballgown-constructor}
\alias{ballgown-constructor}
\alias{ballgown}
\title{constructor function for ballgown objects}
\usage{
ballgown(samples = NULL, dataDir = NULL, samplePattern = NULL,
  bamfiles = NULL, pData = NULL, verbose = TRUE, meas = "all")
}
\arguments{
\item{samples}{vector of file paths to folders containing sample-specific 
ballgown data (generated by \code{tablemaker}).  If \code{samples} is 
provided, \code{dataDir} and \code{samplePattern} are not used.}

\item{dataDir}{file path to top-level directory containing sample-specific
folders with ballgown data in them.  Only used if \code{samples} is NULL.}

\item{samplePattern}{regular expression identifying the subdirectories of\
\code{dataDir} containing data to be loaded into the ballgown object (and 
only those subdirectories).  Only used if \code{samples} is NULL.}

\item{bamfiles}{optional vector of file paths to read alignment files for
each sample.  If provided, make sure to sort properly (e.g., in the same
order as \code{samples}).  Default NULL.}

\item{pData}{optional \code{data.frame} with rows corresponding to samples and 
columns corresponding to phenotypic variables.}

\item{verbose}{if \code{TRUE}, print status messages and timing information
as the object is constructed.}

\item{meas}{character vector containing either "all" or one or more of: 
"rcount", "ucount", "mrcount", "cov", "cov_sd", "mcov", "mcov_sd", or 
"FPKM". The resulting ballgown object will only contain the specified
expression measurements, for the appropriate features. See vignette for 
which expression measurements are available for which features. "all" 
creates the full object.}
}
\value{
an object of class \code{ballgown}
}
\description{
constructor function for ballgown objects
}
\details{
Because experimental data is recorded so variably, it is the user's
  responsibility to format \code{pData} correctly.  In particular, it's 
  really important that the rows of \code{pData} (corresponding to samples) 
  are ordered the same way as \code{samples} or the 
  \code{dataDir}/\code{samplePattern} combo. You can run 
  \code{file.path(path = dataDir, pattern = samplePattern)} to see the sample
  order if \code{samples} was not used.

If you are creating a ballgown object for a large experiment, this function 
may run slowly and use a large amount of RAM. We recommend running this 
constructor as a batch job and saving the resulting ballgown object as an rda
file.  The rda file usually has reasonable size on disk, and the object in it
shouldn't take up too much RAM when loaded, so the time and memory use in 
creating the object is a one-time cost.
}
\examples{
bg = ballgown(dataDir=system.file('extdata', package='ballgown'), 
    samplePattern='sample')
pData(bg) = data.frame(id=sampleNames(bg), group=rep(c(1,0), each=10))
}
\seealso{
\code{\link{ballgownrsem}}, for loading RSEM output into a ballgown
  object
}
\author{
Leonardo Collado-Torres, Alyssa Frazee
}
