/*
    treeBuddyItem

    Copyright (c) 2008 by Rustam Chakin <qutim.develop@gmail.com>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/


#include "treebuddyitem.h"

treeBuddyItem::treeBuddyItem(const QString &pUin, QIcon offlineIcon, contactListTree *p, QTreeWidgetItem *parent) : QTreeWidgetItem(parent, 2), par(p), parentUin(pUin)
{
//	statusIcon = QIcon(":/icons/icq/offline.png");
	avatarMd5Hash.clear();
	statusIcon = offlineIcon;
	setIcon(0,statusIcon);
	setText(3,QString::number(12));
	status = contactOffline;
	isOffline = true;
	groupID = 0;
	messageIcon = false;
	UTF8 = false;
	statusChanged = true;
	underline = true;
	notAutho = false;
	birth = false;
	authorizeMe = false;
	externalIP = 0;
	internalIP = 0;
	onlineTime = 0;
	signonTime = 0;
	regTime = 0;
	clientId = "-";
	fileTransferSupport = false;
	xStatusPresent = false;
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+parentUin, "account");	
	iconPath = settings.fileName().section('/', 0, -2) + "/icqicons/";
}

treeBuddyItem::~treeBuddyItem()
{
	
}
void treeBuddyItem::setBuddyUin(const QString &text)
{
	buddyUin = text;
	buddyName = text;
	updateBuddyText();
}
void treeBuddyItem::readData(icqBuffer *socket, quint16 length)
{
	notAutho = false;
	for ( ;length > 0; )
	{
		tlv tmpTlv;
		tmpTlv.readData(socket);
		takeTlv(tmpTlv);
		length -= tmpTlv.getLength();
	}
	updateBuddyText();
}

void treeBuddyItem::takeTlv(tlv &newTlv)
{
	switch(newTlv.getTlvType())
	{
	case 0x0131:
		buddyName = QString::fromUtf8(newTlv.getTlvData());
		updateBuddyText();
		break;
		
	case 0x0066:
		notAutho = true;
		updateBuddyText();
		break;

	default:
		break;
	}
}

void treeBuddyItem::updateBuddyText()
{
	
	setText(1,buddyName);
	QFont tmpFont = font(1);
	if ( underline )
	{		
		tmpFont.setUnderline(notAutho);	
	} else {
		tmpFont.setUnderline(false);
	}
	
	if ( birth )
	{
		if ( birthDay == QDate::currentDate() )
			tmpFont.setWeight(QFont::Bold);
	} else {
		tmpFont.setWeight(QFont::Normal);
	}
	
	setFont(1, tmpFont);
	
	createToolTip();
}

void treeBuddyItem::oncoming(icqBuffer *socket, quint16 length)
{
	socket->read(2);
	length -= 4;
	quint16 arraySize = byteArrayToInt16(socket->read(2));
	for ( int i = 0; i < arraySize; i++ )
	{
		tlv tmpTlv;
		tmpTlv.readData(socket);
		takeOncomingTlv(tmpTlv);
		length -= tmpTlv.getLength();
	}
	
	if ( status == contactOffline )
	{
		QByteArray tmp;
		tmp.append(0x10);
		tmp.append((char)0x00);
		tmp.append((char)0x00);
		tmp.append((char)0x00);
		changeStatus(tmp);
		
	}
	if ( length )
		socket->read(length);
}

void treeBuddyItem::takeOncomingTlv(tlv &newTlv)
{
	switch(newTlv.getTlvType())
	{
	case 0x0006:
		changeStatus(newTlv.getTlvData());
		break;
		
	case 0x000d:
		setCapabilities(newTlv.getTlvData());
		break;
	case 0x001d:
		readAvailableMessTlv(newTlv.getTlvData());
		break;
	case 0x000a:
		setExtIp(newTlv.getTlvData());
		break;
	case 0x000c:
		setIntIp(newTlv.getTlvData());
		break;
	case 0x000f:
		setOnlTime(newTlv.getTlvData());
		break;
	case 0x0003:
		setSignOn(newTlv.getTlvData());
		break;
	case 0x0005:
		setregTime(newTlv.getTlvData());
		break;
	default:
		break;
	}
}

quint16 treeBuddyItem::byteArrayToInt16(const QByteArray &array)
{
	bool ok;
	return array.toHex().toUInt(&ok,16);	
}

void treeBuddyItem::changeStatus(const QByteArray &userStatus)
{
	if ( userStatus.size() == 4 )
	{
		isOffline = false;
		quint16 userstatus = userStatus.at(2) * 0x100 + userStatus.at(3);
		quint16 userFlags = userStatus.at(0) * 0x100 + userStatus.at(1);
		if ( userFlags & 0x0008 )
		{
			birthDay = QDate::currentDate();
			updateBuddyText();
		}
		contactStatus tmpStatus = status;
		switch ( userstatus )
		{
		case 0x0000:
			statusIcon = *onlineIcon;
			status = contactOnline;
			break;
		case 0x0001:
			statusIcon = *awayIcon;
			status = contactAway;
			break;
		case 0x0002:
		case 0x0013:
			statusIcon = *dndIcon;
			status = contactDnd;
			break;
		case 0x0004:
		case 0x0005:
			statusIcon = *naIcon;
			status = contactNa;
			break;
		case 0x0010:
		case 0x0011:
			statusIcon = *occupiedIcon;
			status = contactOccupied;
			break;
		case 0x0020:
			statusIcon = *ffcIcon;
			status = contactFfc;
			break;
		case 0x0100:
			statusIcon = *invisibleIcon;
			status = contactInvisible;
			break;
		case 0x2001:
			statusIcon = *lunchIcon;
			status = contactLunch;
			break;
		case 0x3000:
			statusIcon = *evilIcon;
			status = contactEvil;
			break;		
		case 0x4000:
			statusIcon = *depressionIcon;
			status = contactDepression;
			break;
		case 0x5000:
			statusIcon = *atHomeIcon;
			status = contactAtHome;
			break;
		case 0x6000:
			statusIcon = *atWorkIcon;
			status = contactAtWork;
			break;
		default:
			statusIcon = *onlineIcon;
			status = contactOnline;
		}
		if ( status != tmpStatus )
		{
			setIcon(0, statusIcon);
			setText(3,QString::number(status));
			statusChanged = true;
		} else
			statusChanged = false;
		createToolTip();
	}
}

void treeBuddyItem::buddyOffline()
{
	statusIcon = *offlineIcon;
	setIcon(0,statusIcon);	
	isOffline = true;
	status = contactOffline;
	setText(3,QString::number(contactOffline));
	createToolTip();
	waitingForAuth(authorizeMe);
	xStatusPresent = false;
}

void treeBuddyItem::readMessage()
{
//	par->readMessageStack();
}

void treeBuddyItem::setCapabilities(QByteArray capList)
{
	capabilitiesList.clear();
	int size = capList.length() / 16;
	for ( int i = 0; i < size; i++)
	{
		QByteArray capability = capList.right(16);
		
		capabilitiesList.append(capability);
		
		if (isUtf8Cap(capability))
		{
			UTF8 = true;
		}
		
		if ( capability == QByteArray::fromHex("094613434c7f11d18222444553540000"))
			fileTransferSupport = true;
		capList = capList.left(capList.length() - 16);
	}
}

bool treeBuddyItem::isUtf8Cap(const QByteArray &utf8Cap)
{
	bool ok;
	if ( utf8Cap.left(4).toHex().toUInt(&ok,16) == 0x0946134e )
	{
		return true;
	}
	else
		return false;
}


bool treeBuddyItem::operator< ( const QTreeWidgetItem & other ) const  
{

			int column = treeWidget()->model()->headerData(0,Qt::Horizontal).toInt();
			if ( isOffline )
			{
				QString myText = text(1).toUpper();
				QString otherText = other.text(1).toUpper();
				return myText < otherText;
			}
			else 
			{
			if ( column == 3 )
			{
				int myNumber = text(3).toInt();
				int otherNumber = other.text(3).toInt();
				return myNumber < otherNumber;				
			} else{
				QString myText = text(1).toUpper();
				QString otherText = other.text(1).toUpper();
				return myText < otherText;
			}
				}
			
}

void treeBuddyItem::setCustomFont(const QString &f, int s, const QColor &c)
{
	QFont cfont = font(1);
	cfont.setFamily(f);
	cfont.setPointSize(s);
	setFont(1, cfont);
	setForeground(1, c);
}

quint8 treeBuddyItem::byteArrayToInt8(const QByteArray &array)
{
	bool ok;
	return array.toHex().toUInt(&ok,16);
}

void treeBuddyItem::readAvailableMessTlv(QByteArray avTlv)
{
	for ( ;avTlv.size(); )
	{
		quint16 id = byteArrayToInt16(avTlv.left(2));
		avTlv = avTlv.right(avTlv.size() - 2);
		picFlags = byteArrayToInt8(avTlv.left(1));
		avTlv = avTlv.right(avTlv.size() - 1);
		quint8 length = byteArrayToInt8(avTlv.left(1));
		avTlv = avTlv.right(avTlv.size() - 1);
		
		if ( length == 16 )
		{
			avatarMd5Hash = avTlv.left(length);
		}
		avTlv = avTlv.right(avTlv.size() - length);
		
	}
}

void treeBuddyItem::waitingForAuth(bool wait)
{
	authorizeMe = wait;
	
	if ( wait )
		setIcon(1, QIcon(":/icons/icq/auth.png"));
	else
	{
		setIcon(1, QIcon());
		authMessage.clear();
	}
}

void treeBuddyItem::createToolTip()
{
	QString customToolTip;
	
	
	if ( avatarMd5Hash.length() == 16 )
	{
	QString avatarPath = iconPath + avatarMd5Hash.toHex();
	if ( QFile::exists(avatarPath))
		customToolTip.append("<img src='"+ avatarPath+"' align='left'>");
	}
	
	
	customToolTip.append("<b>" + buddyName + "</b>(" + buddyUin + ")<br clear='all'><hr>");
	
	if ( externalIP )
	{
		customToolTip.append(QObject::tr("<font size='2'><b>External ip:</b> %1.%2.%3.%4<br></font>").arg(externalIP / 0x1000000).arg(
				externalIP % 0x1000000 / 0x10000).arg( externalIP % 0x10000 / 0x100).arg(externalIP % 0x100));
	}
	
	if ( internalIP )
	{
		customToolTip.append(QObject::tr("<font size='2'><b>Internal ip:</b> %1.%2.%3.%4<br></font>").arg(internalIP / 0x1000000).arg(
				internalIP % 0x1000000 / 0x10000).arg( internalIP % 0x10000 / 0x100).arg(internalIP % 0x100));
	}
	
	if ( status != contactOffline )
	{
		QDateTime time;
		time.setTime_t(0);
		time = time.addSecs(onlineTime);
		
		customToolTip.append(QObject::tr("<font size='2'><b>Online time:</b> %1d %2h %3m %4s<br>").arg(time.date().day() - 1).arg(
				time.time().hour()).arg(time.time().minute()).arg(time.time().second()));
		
		time.setTime_t(signonTime);
		customToolTip.append(QObject::tr("<b>Signed on:</b> %1<br>").arg(time.toString()));
		time.setTime_t(regTime);
		
		customToolTip.append(QObject::tr("<b>Reg. date:</b> %1<br>").arg(time.toString()));
		customToolTip.append(QObject::tr("<b>Possible client:</b> %1</font>").arg(clientId));
	}
	
	
	setToolTip(1, customToolTip);
}

quint32 treeBuddyItem::convertToInt32(const QByteArray &array)
{
	bool ok;
	return array.toHex().toULong(&ok,16);
}

void treeBuddyItem::setExtIp(const QByteArray &array)
{
	externalIP = convertToInt32(array);

}

void treeBuddyItem::setIntIp(const QByteArray &array)
{
	internalIP = convertToInt32(array.left(4));
}

void treeBuddyItem::setOnlTime(const QByteArray &array)
{
	onlineTime = convertToInt32(array);
}

void treeBuddyItem::setSignOn(const QByteArray &array)
{
	signonTime = convertToInt32(array);

}

void treeBuddyItem::setregTime(const QByteArray &array)
{
	regTime = convertToInt32(array);

}
