/*
    trayMessageTextField

    Copyright (c) 2008 by Rustam Chakin <qutim.develop@gmail.com>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/


#include "traymessagetextfield.h"

trayMessageTextField::trayMessageTextField(QWidget *parent): QTextBrowser(parent)
{
	setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
}

trayMessageTextField::~trayMessageTextField()
{
	
}

void trayMessageTextField::mousePressEvent ( QMouseEvent * event )
{
	if ( event->button() == Qt::LeftButton )
		emit closeWindow();
	else if (event->button() == Qt::RightButton )
		emit startChat();
		
	QTextBrowser::mousePressEvent(event);
}

void trayMessageTextField::setData(const QString &from, 
		const QString &picturePath, const QString &msg)
{
	QString picture;
	if ( QFile::exists(picturePath) )
		picture = picturePath;
	else
		picture = QString(":/icons/crystal_project/noavatar.png");
		
	
	QString message = tr("<b>%1</b><br /> <img align='left'  height='64' width='64' src='%2' hspace='4' vspace='4'> %3").arg(Qt::escape(from)).arg(picture).arg(Qt::escape(msg));
	append(message);
	
	moveCursor(QTextCursor::Start);
	ensureCursorVisible();
}

void trayMessageTextField::setSystemData(const QString &msg)
{
	QString message = tr("<b>%1</b>").arg(msg);
	append(message);
		
		moveCursor(QTextCursor::Start);
		ensureCursorVisible();
}
