/*
    emoticonSettings

    Copyright (c) 2008 by Rustam Chakin <qutim.develop@gmail.com>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/


#include "emoticonsettings.h"

emoticonSettings::emoticonSettings(QWidget *parent)
    : QWidget(parent)
{
	ui.setupUi(this);
		connect (ui.themeBox , SIGNAL(currentIndexChanged ( int )),
													this, SLOT(widgetStateChanged()));
}

emoticonSettings::~emoticonSettings()
{

}

void emoticonSettings::loadSettings(const QString &account)
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+account, "account");
//	findEmoticonThemes(settings.fileName().section('/', 0, -2) + "/emoticons");
	findEmoticonThemes("emoticons");
	ui.themeBox->setCurrentIndex(0);
	settings.beginGroup("emoticons");
	
	ui.themeBox->setCurrentIndex(settings.value("current",0).toUInt());

	settings.endGroup();
}

void emoticonSettings::saveSettings(const QString &account)
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+account, "account");
	settings.beginGroup("emoticons");
	settings.setValue("current", ui.themeBox->currentIndex());
	settings.setValue("path", ui.themeBox->itemData(ui.themeBox->currentIndex()));
	settings.endGroup();
	
	if ( changed )
			emit settingsSaved();
	changed = false;
}

void emoticonSettings::findEmoticonThemes(const QString &path)
{
	QDir emoticonPath = path;
	QStringList themes = emoticonPath.entryList(QDir::AllDirs | QDir::NoDotAndDotDot);
	
	foreach(QString dirName, themes)
	{
		QDir dir(path + "/" + dirName);
		QStringList filter;
		filter<<"*.xml";
		
		QStringList fileXML = dir.entryList(filter,QDir::Files);
		if ( fileXML.count() )
			ui.themeBox->addItem(dirName, path + "/" + dirName +"/" + fileXML.at(0));
	}
	
}

void emoticonSettings::on_themeBox_currentIndexChanged ( int index )
{
	
	ui.emoticonList->clear();
	QFile file(ui.themeBox->itemData(index).toString());
	
	QString dirPath = ui.themeBox->itemData(index).toString().section('/', 0, -2);
	QDir dir ( dirPath );
	
	QStringList fileList = dir.entryList(QDir::Files);
	
	if (file.open(QIODevice::ReadOnly) )
	{
		QDomDocument doc;
		if ( doc.setContent(&file) )
		{
			QDomElement rootElement = doc.documentElement();
			int emoticonCount = rootElement.childNodes().count();
			
			QDomElement emoticon = rootElement.firstChild().toElement();
			
			for ( int i = 0; i < emoticonCount ; i++ )
			{
				
				if ( emoticon.tagName() == "emoticon")
				{
					
					QStringList fileName = fileList.filter(emoticon.attribute("file"));
					if ( !fileName.isEmpty())
					{
					
						QListWidgetItem *item = new QListWidgetItem(ui.emoticonList);
						item->setIcon(QIcon(dirPath + "/" + fileName.at(0)));
					
					}
					
				}
				emoticon = emoticon.nextSibling().toElement();
					
			}
			
		}
	}
	
	
}
