/*
    readAwayDialog

    Copyright (c) 2008 by Rustam Chakin <qutim.develop@gmail.com>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/


#include "readawaydialog.h"

readAwayDialog::readAwayDialog(QWidget *parent)
    : QWidget(parent)
{
	ui.setupUi(this);
	setFixedSize(size());
	move(desktopCenter());
}

readAwayDialog::~readAwayDialog()
{

}

QPoint readAwayDialog::desktopCenter()
{
	QDesktopWidget desktop;
	return QPoint(desktop.width() / 2 - size().width() / 2, desktop.height() / 2 - size().height() / 2);
}

void readAwayDialog::addMessage(QString &t)
{
	ui.awayMessage->setPlainText(t.replace("\n", "<br>"));
}

void readAwayDialog::addXstatusMessage(QByteArray &msg)
{
	msg = msg.right(msg.length() - 98);
	msg.chop(13);
	QString title = findTitle(QString::fromUtf8(msg));
	QString message = findMessage(QString::fromUtf8(msg));
	ui.awayMessage->setHtml("<b>" + title +"</b><br>" + message.replace("\n", "<br>"));
}

QString readAwayDialog::findTitle(QString _givenText) 
{ 
	QRegExp regExp("[&][l][t][;][t][i][t][l][e][&][g][t][;](.+)[&][l][t][;][/][t][i][t][l][e][&][g][t][;]"); 
	int pos = 0; 
	regExp.indexIn(_givenText, pos); 
	QString rez = regExp.cap(0); 
	return rez.mid(13, rez.length() - 27);
}

QString readAwayDialog::findMessage(QString _givenText) 
{ 
	QRegExp regExp("[&][l][t][;][d][e][s][c][&][g][t][;](.+)[&][l][t][;][/][d][e][s][c][&][g][t][;]"); 
	int pos = 0; 
	regExp.indexIn(_givenText, pos); 
	QString rez = regExp.cap(0); 
	return rez.mid(12, rez.length() - 25);
}
