#include "cryptosettings.h"

cryptoSettings::cryptoSettings(QWidget *parent)
	: QWidget(parent)
{
	ui.setupUi(this);
}

cryptoSettings::~cryptoSettings()
{

}


void cryptoSettings::saveSettings(const QString &account)
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+account, "account");
	if(ui.modeDES->isChecked())
	{
		settings.setValue("encryption/pass3DES", false);
	}
	settings.setValue("encryption/history", ui.historyBox->isChecked());	
}

void cryptoSettings::loadSettings(const QString &account)
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+account, "account");
	ui.modeDES->setChecked(!(settings.value("encryption/pass3DES", false).toBool()));
	ui.mode3DES->setChecked((settings.value("encryption/pass3DES", true).toBool()));
	ui.historyBox->setChecked(!(settings.value("encryption/history", false).toBool()));
}
