/*
    clientIdentify

    Copyright (c) 2008 by Rustam Chakin <qutim.develop@gmail.com>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/


#include "clientidentify.h"

clientIdentify::clientIdentify()
{
	
}

clientIdentify::~clientIdentify()
{
	
}

void clientIdentify::addContactClientId(treeBuddyItem *buddy)
{
	if ( identifyQip2005(buddy->capabilitiesList) )
	{
		buddy->clientId = "QIP 2005";
		buddy->setIcon(2, QIcon(":/icons/clients/qip.png"));
		buddy->updateBuddyText();
	} else if ( identifyQipInf(buddy->capabilitiesList))
	{
		buddy->clientId = "QIP Infium";
		buddy->setIcon(2, QIcon(":/icons/clients/qip.png"));
		buddy->updateBuddyText();
	} else if ( identifyICQ6(buddy->capabilitiesList))
	{
		buddy->clientId = "ICQ 6";
		buddy->setIcon(2, QIcon(":/icons/clients/icq6.png"));
		buddy->updateBuddyText();
	}else if ( identifyICQ51(buddy->capabilitiesList))
	{
		buddy->clientId = "ICQ 5.1";
		buddy->setIcon(2, QIcon(":/icons/clients/icql5.png"));
		buddy->updateBuddyText();
	}else if ( identifyMiranda0804(buddy->capabilitiesList))
	{
		buddy->clientId = "Miranda IM 0.8.0.4 alpha Unicode";
		buddy->setIcon(2, QIcon(":/icons/clients/miranda.png"));
		buddy->updateBuddyText();
	}else if ( identifySim(buddy->capabilitiesList))
	{
		buddy->clientId = "SIM";
		buddy->setIcon(2, QIcon(":/icons/clients/sim.png"));
		buddy->updateBuddyText();
	}else if ( identifyICQ2003b(buddy->capabilitiesList))
	{
		buddy->clientId = "ICQ 2003b";
		buddy->setIcon(2, QIcon(":/icons/clients/icq2003.png"));
		buddy->updateBuddyText();
	}else if ( identifyICQ41(buddy->capabilitiesList))
	{
		buddy->clientId = "ICQ 4.1";
		buddy->setIcon(2, QIcon(":/icons/clients/icql4.png"));
		buddy->updateBuddyText();
	}else  if ( identyfiqutim01(buddy->capabilitiesList))
	{
		buddy->clientId = "qutIM 0.1";
		buddy->setIcon(2, QIcon(":/icons/qutim.png"));
		buddy->updateBuddyText();
	}else {
		buddy->clientId = "-";
		buddy->setIcon(2, QIcon(":/icons/clients/unknown.png"));
		buddy->updateBuddyText();
	}
}

bool clientIdentify::identifyQip2005(const QList<QByteArray> &capList)
{
	
	bool cap1 = false;
	bool cap2 = false;
	QByteArray cap1Array = QByteArray::fromHex("563fc8090b6f41bd9f79422609dfa2f3");
	QByteArray cap2Array = QByteArray::fromHex("563fc8090b6f41514950203230303561");
	
	for ( int i = 0; i < capList.count(); i++)
	{
		if ( cap1Array == capList.at(i))
			cap1 = true;
		if ( cap2Array == capList.at(i))
			cap2 = true;
	}
	
	return (cap1 & cap2);
//	return cap1;
}

bool clientIdentify::identifyQipInf(const QList<QByteArray> &capList)
{
	
	bool cap1 = false;
	bool cap2 = false;
	bool cap3 = false;
	bool cap4 = false;
	QByteArray cap1Array = QByteArray::fromHex("563fc8090b6f41bd9f79422609dfa2f3");
	QByteArray cap2Array = QByteArray::fromHex("7c737502c3be4f3ea69f015313431e1a");
	QByteArray cap3Array = QByteArray::fromHex("1a093c6cd7fd4ec59d51a6474e34f5a0");
	QByteArray cap4Array = QByteArray::fromHex("7c533ffa68004f21bcfbc7d2439aad31");
	
	
	for ( int i = 0; i < capList.count(); i++)
	{
		if ( cap1Array == capList.at(i))
			cap1 = true;
		if ( cap2Array == capList.at(i))
			cap2 = true;
		if ( cap3Array == capList.at(i))
			cap3 = true;
		if ( cap4Array == capList.at(i))
			cap4 = true;
	}
	
	return (cap1 & cap2 & cap3 & cap4);
}

bool clientIdentify::identifyICQ6(const QList<QByteArray> &capList)
{
	
	bool cap1 = false;
	bool cap2 = false;
	bool cap3 = false;
	bool cap4 = false;
	bool cap5 = false;
	bool cap6 = false;
	bool cap7 = false;
	bool cap8 = false;
	bool cap9 = false;

	QByteArray cap1Array = QByteArray::fromHex("0138ca7b769a491588f213fc00979ea8");
	QByteArray cap2Array = QByteArray::fromHex("67361515612d4c078f3dbde6408ea041");
	QByteArray cap3Array = QByteArray::fromHex("1a093c6cd7fd4ec59d51a6474e34f5a0");
	QByteArray cap4Array = QByteArray::fromHex("b2ec8f167c6f451bbd79dc58497888b9");
	QByteArray cap5Array = QByteArray::fromHex("178c2d9bdaa545bb8ddbf3bdbd53a10a");
	QByteArray cap6Array = QByteArray::fromHex("094613494c7f11d18222444553540000");
	QByteArray cap7Array = QByteArray::fromHex("0946134e4c7f11d18222444553540000");
	QByteArray cap8Array = QByteArray::fromHex("094613434c7f11d18222444553540000");
	QByteArray cap9Array = QByteArray::fromHex("563fc8090b6f41bd9f79422609dfa2f3");
	
	for ( int i = 0; i < capList.count(); i++)
	{
		if ( cap1Array == capList.at(i))
			cap1 = true;
		if ( cap2Array == capList.at(i))
			cap2 = true;
		if ( cap3Array == capList.at(i))
			cap3 = true;
		if ( cap4Array == capList.at(i))
			cap4 = true;
		if ( cap5Array == capList.at(i))
			cap5 = true;
		if ( cap6Array == capList.at(i))
			cap6 = true;
		if ( cap7Array == capList.at(i))
			cap7 = true;
		if ( cap8Array == capList.at(i))
			cap8 = true;
		if ( cap9Array == capList.at(i))
			cap9 = true;

	}
	
	return (cap1 & cap2 & cap3 & cap4 & cap5 & cap6 & cap7 & cap8 & cap9);
}

bool clientIdentify::identifyICQ51(const QList<QByteArray> &capList)
{
	
	bool cap1 = false;
	bool cap2 = false;
	bool cap3 = false;
	bool cap4 = false;
	bool cap5 = false;
	bool cap6 = false;
	bool cap7 = false;
	bool cap8 = false;
	bool cap9 = false;
	bool cap10 = false;
	bool cap11 = false;
	bool cap12 = false;

	QByteArray cap1Array = QByteArray::fromHex("094613444c7f11d18222444553540000");
	QByteArray cap2Array = QByteArray::fromHex("094613434c7f11d18222444553540000");
	QByteArray cap3Array = QByteArray::fromHex("0946134c4c7f11d18222444553540000");
	QByteArray cap4Array = QByteArray::fromHex("094613494c7f11d18222444553540000");
	QByteArray cap5Array = QByteArray::fromHex("1a093c6cd7fd4ec59d51a6474e34f5a0");
	QByteArray cap6Array = QByteArray::fromHex("b99708b53a924202b069f1e757bb2e17");
	QByteArray cap7Array = QByteArray::fromHex("67361515612d4c078f3dbde6408ea041");
	QByteArray cap8Array = QByteArray::fromHex("97b12751243c4334ad22d6abf73f1492");
	QByteArray cap9Array = QByteArray::fromHex("178c2d9bdaa545bb8ddbf3bdbd53a10a");
	QByteArray cap10Array = QByteArray::fromHex("e362c1e9121a4b94a6267a74de24270d");
	QByteArray cap11Array = QByteArray::fromHex("563fc8090b6f41bd9f79422609dfa2f3");
	QByteArray cap12Array = QByteArray::fromHex("b2ec8f167c6f451bbd79dc58497888b9");
	
	for ( int i = 0; i < capList.count(); i++)
	{
		if ( cap1Array == capList.at(i))
			cap1 = true;
		if ( cap2Array == capList.at(i))
			cap2 = true;
		if ( cap3Array == capList.at(i))
			cap3 = true;
		if ( cap4Array == capList.at(i))
			cap4 = true;
		if ( cap5Array == capList.at(i))
			cap5 = true;
		if ( cap6Array == capList.at(i))
			cap6 = true;
		if ( cap7Array == capList.at(i))
			cap7 = true;
		if ( cap8Array == capList.at(i))
			cap8 = true;
		if ( cap9Array == capList.at(i))
			cap9 = true;
		if ( cap10Array == capList.at(i))
			cap10 = true;
		if ( cap11Array == capList.at(i))
			cap11 = true;
		if ( cap12Array == capList.at(i))
			cap12 = true;

	}
	
	return (cap1 & cap2 & cap3 & cap4 & cap5 & cap6 & cap7 & cap8 & cap9 & cap10 & cap11 & cap12);
}

bool clientIdentify::identifyICQ2003b(const QList<QByteArray> &capList)
{
	bool cap1 = false;
	bool cap2 = false;
	bool cap3 = false;
	bool cap4 = false;
	bool cap5 = false;
	if ( capList.count() == 5)
	{
		if ( capList.at(0) == QByteArray::fromHex("094613444c7f11d18222444553540000"))
			cap1 = true;
		if ( capList.at(1) == QByteArray::fromHex("97b12751243c4334ad22d6abf73f1492"))
			cap2 = true;
		if ( capList.at(2) == QByteArray::fromHex("0946134e4c7f11d18222444553540000"))
			cap3 = true;
		if ( capList.at(3) == QByteArray::fromHex("094613494c7f11d18222444553540000"))
			cap4 = true;
		if ( capList.at(4) == QByteArray::fromHex("563fc8090b6f41bd9f79422609dfa2f3"))
			cap5 = true;
	}
	return (cap1 & cap2 & cap3 & cap4 & cap5);
}

bool clientIdentify::identifyMiranda0804(const QList<QByteArray> &capList)
{
	bool cap1 = false;
	bool cap2 = false;
	bool cap3 = false;
	bool cap4 = false;
	bool cap5 = false;
	bool cap6 = false;
	bool cap7 = false;
	bool cap8 = false;
	bool cap9 = false;
	if ( capList.count() == 9)
	{
		if ( capList.at(0) == QByteArray::fromHex("4d6972616e64614d8008000480030a07"))
			cap1 = true;
		if ( capList.at(1) == QByteArray::fromHex("094613444c7f11d18222444553540000"))
			cap2 = true;
		if ( capList.at(2) == QByteArray::fromHex("785e8c4840d34c65886f04cf3f3f43df"))
			cap3 = true;
		if ( capList.at(3) == QByteArray::fromHex("094613434c7f11d18222444553540000"))
			cap4 = true;
		if ( capList.at(4) == QByteArray::fromHex("0946134c4c7f11d18222444553540000"))
			cap5 = true;
		if ( capList.at(5) == QByteArray::fromHex("1a093c6cd7fd4ec59d51a6474e34f5a0"))
			cap6 = true;
		if ( capList.at(6) == QByteArray::fromHex("0946134e4c7f11d18222444553540000"))
			cap7 = true;
		if ( capList.at(7) == QByteArray::fromHex("094613494c7f11d18222444553540000"))
			cap8 = true;
		if ( capList.at(8) == QByteArray::fromHex("563fc8090b6f41bd9f79422609dfa2f3"))
			cap9 = true;
	}
	return (cap1 & cap2 & cap3 & cap4 & cap5 & cap6 & cap7 & cap8 & cap9);
}

bool clientIdentify::identifySim(const QList<QByteArray> &capList)
{
	bool cap1 = false;
	QByteArray cap1Array = QByteArray::fromHex("53494D20636C69656E74202000090480");
	
	for ( int i = 0; i < capList.count(); i++)
	{
		if ( cap1Array == capList.at(i))
			cap1 = true;
	}
	
	return cap1;
}

bool clientIdentify::identifyICQ41(const QList<QByteArray> &capList)
{
	bool cap1 = false;
	bool cap2 = false;
	bool cap3 = false;
	bool cap4 = false;
	bool cap5 = false;
	bool cap6 = false;
	bool cap7 = false;
	bool cap8 = false;
	
	if ( capList.contains(QByteArray::fromHex("1a093c6cd7fd4ec59d51a6474e34f5a0")))
		cap1 = true;
	if ( capList.contains(QByteArray::fromHex("094613444c7f11d18222444553540000")))
		cap2 = true;
	if ( capList.contains(QByteArray::fromHex("97b12751243c4334ad22d6abf73f1492")))
		cap3 = true;
	if ( capList.contains(QByteArray::fromHex("0946134e4c7f11d18222444553540000")))
		cap4 = true;
	if ( capList.contains(QByteArray::fromHex("178c2d9bdaa545bb8ddbf3bdbd53a10a")))
		cap5 = true;
	if ( capList.contains(QByteArray::fromHex("0946134c4c7f11d18222444553540000")))
		cap6 = true;
	if ( capList.contains(QByteArray::fromHex("094613494c7f11d18222444553540000")))
		cap7 = true;
	if ( capList.contains(QByteArray::fromHex("563fc8090b6f41bd9f79422609dfa2f3")))
		cap8 = true;
	return (cap1 & cap2 & cap3 & cap4 & cap5 & cap6 & cap7 & cap8);
}

bool clientIdentify::identyfiqutim01(const QList<QByteArray> &capList)
{
	return capList.contains(QByteArray::fromHex("717574696d302e310000000000000000"));

}
