/*
    chatWindow

    Copyright (c) 2008 by Rustam Chakin <qutim.develop@gmail.com>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/



#ifndef CHATWINDOW_H
#define CHATWINDOW_H

#include <QtGui>
#include <QtXml>
#include "ui_chatwindow.h"
#include "icqmessage.h"
#include "icqtextedit.h"
#include "emoticonmenu.h"






class chatWindow : public QWidget
{
    Q_OBJECT

public:
    chatWindow(QWidget *parent = 0);
    ~chatWindow();
    void setMessage(const QString &, const QString &, const QDateTime &, bool in = true);
    void setUin(const QString u) { uin = u; }
    void setContactUin(const QString u) { chatWith = u; }
    QString getUin() { return uin; }
    QString contactName;
    void setOnline(bool);
    bool showNames;
    quint8 timestamp;
    void setOnEnter(bool);
    void focusEditMessage();
    bool closeOnSend;  
    bool sendTyping;
    void restoreState();
    void typingIcon(bool);
    QString accountNickName;
    QString chatWith;
    void setAvatars(const QString &);
    void setOwnerAvatar(const QString &);
    void setServiceMessage(const QString &, const QString &, const QDateTime &);
    void setEmoticonPath(const QString &path);
private slots:
	void on_messageEdit_textChanged();
	void on_sendButton_clicked();
	void tst() { emit windowFocused(chatWith);}
	void typingNow();
	void on_historyButton_clicked();
	void on_infoButton_clicked();
	void insertSmile(const QString &);
	void on_imageButton_clicked();
signals:
	void sendMessage(const messageFormat &);
	void windowFocused(const QString &);
	void sendTypingNotification(const QString &, quint16);
	void showHistory(const QString &);
	void openInfoWindow(const QString &);
	void sendImage(const QString &, const QString &);
	
protected:
	void focusInEvent( QFocusEvent * event );

	void keyPressEvent ( QKeyEvent * event);
	void showEvent ( QShowEvent * event );
private:
	bool typingChanged;
    Ui::chatWindowClass ui;
    QString uin;
    
    bool online;//		if ( movie->frameCount())
    //		{
    QString generateTime();
    bool sendOnEnter;
    QShortcut *sendShortCut;
    icqTextEdit *messageEdit;
    QByteArray saveState;
    bool textChanged;
    QString contactAvatarPath;
    QString findUrls(const QString &);
    QString ownerAvatarPath;
    
    QHash<QString, QString> emoticonList;
    
    QMenu *emoticMenu;
    QWidgetAction *emoticonAction;
    emoticonMenu *emoticonWidget;
    
    QHash<QString, QStringList> regExpList;
    QHash<QString, QString> urls;
    
    QString checkForEmoticons(const QString &);
    
};

#endif // CHATWINDOW_H
