/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "GtkQuteComLogger.h"

#include "GtkQuteCom.h"
#include "control/CQuteCom.h"

GtkQuteComLogger::GtkQuteComLogger(CQuteComLogger * cQuteComLogger) {
	_cQuteComLogger = cQuteComLogger;

	initThreadSafe();
}

void GtkQuteComLogger::initThreadSafe() {
	_loggerWidget = WidgetFactory::create(":/forms/QuteComLoggerWidget.ui", NULL);

	QtQuteCom * qtQuteCom = (QtQuteCom *) _cQuteComLogger->getCQuteCom()->getPresentation();
	qtQuteCom->setLogger(this);
}

void GtkQuteComLogger::addMessage(const std::string & message) {
	typedef PostEvent1<void (const std::string &), std::string> MyPostEvent;
	MyPostEvent * event = new MyPostEvent(boost::bind(&QtQuteComLogger::addMessageThreadSafe, this, _1), message);
	postEvent(event);
}

void GtkQuteComLogger::addMessageThreadSafe(std::string message) {
	static QListWidget * listWidget = Object::findChild<QListWidget *>(_loggerWidget, "listWidget");

	listWidget->addItem(message.c_str());
	listWidget->scrollToItem(listWidget->item(listWidget->count() - 1));
}

void GtkQuteComLogger::updatePresentation() {
}

void GtkQuteComLogger::updatePresentationThreadSafe() {
}
