/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef PURPLEACCOUNTMNGR_H
#define PURPLEACCOUNTMNGR_H

#include <imwrapper/IMAccount.h>
#include <imwrapper/IMAccountList.h>

#include <thread/RecursiveMutex.h>

#include <util/Trackable.h>

#include <list>

extern "C" {
#include <libpurple/account.h>
}

void *purple_wg_get_handle();

class PurplePresenceMngr;
class PurpleChatMngr;
class PurpleConnectMngr;
class PurpleContactListMngr;

/**
 *
 * @ingroup model
 * @author Julien Bossart
 */
class PurpleAccountMngr
{
public:

	static PurpleAccountMngr *getInstance();

	void Init();

	void reset();
	
	void AddIMAccount(IMAccount &account);

	void RemoveIMAccount(IMAccount &account);
	void UpdateIMAccount(IMAccount &account);

	static bool removeIMAccountCbk(void * data);
	static bool updateIMAccountCbk(void * data);

	static IMAccount *FindIMAccount(const char *login, EnumIMProtocol::IMProtocol protocol);
	static IMAccount *GetFirstIMAccount();

	/* ********** PurpleAccountCallback *********** */
	static void NotifyAddedCbk(PurpleAccount *account, const char *remote_user,
							const char *id, const char *alias, const char *message);

	static void RequestAddCbk(PurpleAccount *account, const char *remote_user,
							const char *id, const char *alias, const char *message);

	static void AuthRequestCbk(PurpleAccount *account, const char *remote_user,
							const char *id, const char *alias,
							const char *message, gboolean on_list,
							void *authorize_cb, void *deny_cb, void *user_data);
	/* ****************************************** */

	static RecursiveMutex _mutex;

private:

	PurpleAccountMngr();
	static PurpleAccountMngr *_staticInstance;
	static PurplePresenceMngr *_presenceMngr;
	static PurpleChatMngr *_chatMngr;
	static PurpleConnectMngr *_connectMngr;
	static PurpleContactListMngr *_clistMngr;

	static IMAccountList _purpleIMAccountList;
};

#endif	//PURPLEACCOUNTMNGR_H
