/************************************************************************
**qprocess_unix.h  23 Jan 2001
**splitted qprocess_unix.cpp in qprocess_unix.h and qprocess_unix.cpp
**Michael Herder crapsite@gmx.net
************************************************************************/
/****************************************************************************
** $Id: qprocess_unix.h,v 1.4 2002/11/27 12:59:17 dermichel Exp $
**
** Implementation of QProcess class for Unix
**
** Created : 20000905
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the kernel module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef USE_QT3

#include "qprocess.h"

#include <qapplication.h>
#include <qqueue.h>
#include <qlist.h>
#include <qsocketnotifier.h>
#include <qtimer.h>
#include "qcleanuphandler.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <sys/types.h>

#ifdef __MIPSEL__
#ifndef SOCK_DGRAM
#define SOCK_DGRAM 1
#endif
#ifndef SOCK_STREAM
#define SOCK_STREAM 2
#endif
#endif

extern "C" {
#define qt_C_sigign SIG_IGN
static void qt_C_sigchldHnd( int );
}

class QProcBackport;
class QProcessBackportManager;
class QProcessBackportPrivate
{
public:
    QProcessBackportPrivate();
    ~QProcessBackportPrivate();

    void closeOpenSocketsForChild();
    void newProc( pid_t pid, QProcessBackport *process );

    QQueue<QByteArray> stdinBuf;

    QSocketNotifier *notifierStdin;
    QSocketNotifier *notifierStdout;
    QSocketNotifier *notifierStderr;
    int socketStdin[2];
    int socketStdout[2];
    int socketStderr[2];

    ssize_t stdinBufRead;
    QProcBackport *proc;

    bool exitValuesCalculated;

    static QProcessBackportManager *procManager;
};


class QProcBackport
{
public:
    QProcBackport( pid_t p, QProcessBackport *proc=0 ) : pid(p), process(proc)
    {
    }
    ~QProcBackport()
    {
	if ( process != 0 )
	    process->d->proc = 0;
    }

    pid_t pid;
    QProcessBackport *process;
};

class QProcessBackportManager : public QObject
{
    Q_OBJECT

public:
    QProcessBackportManager();
    ~QProcessBackportManager();

    void append( QProcBackport *p );
    void remove( QProcBackport *p );

public slots:
    void removeMe();
    void sigchldHnd( int );

public:
    struct sigaction oldactChld;
    struct sigaction oldactPipe;
    QList<QProcBackport> *procList;
    int sigchldFd[2];
};
#endif //USE_QT3
