/*
  Quickplot - an interactive 2D plotter

  Copyright (C) 1998-2011  Lance Arsenault


  This file is part of Quickplot.

  Quickplot is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License,
  or (at your option) any later version.

  Quickplot is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Quickplot.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifdef HAVE_LIBREADLINE
#  if defined(HAVE_READLINE_READLINE_H)
#    include <readline/readline.h>
#  elif defined(HAVE_READLINE_H)
#    include <readline.h>
#  else /* !defined(HAVE_READLINE_H) */
#    undef HAVE_LIBREADLINE
#  endif
#endif

#ifdef HAVE_READLINE_HISTORY
#  if defined(HAVE_READLINE_HISTORY_H)
#    include <readline/history.h>
#  elif defined(HAVE_HISTORY_H)
#    include <history.h>
#  else /* !defined(HAVE_HISTORY_H) */
#    undef HAVE_READLINE_HISTORY
#  endif
#endif /* HAVE_READLINE_HISTORY */

#define FIFO_PATH_LEN (128)


static inline
char *set_to_qp_fifo_path(char *str,
    pid_t qp_pid, pid_t shell_pid)
{
  snprintf(str, FIFO_PATH_LEN, "/tmp/quickplot_to_%d_%d",
      qp_pid, shell_pid);
  return str;
}

static inline
char *set_from_qp_fifo_path(char *str,
    pid_t qp_pid, pid_t shell_pid)
{
  snprintf(str, FIFO_PATH_LEN, "/tmp/quickplot_from_%d_%d",
      qp_pid, shell_pid);
  return str;
}

/* returns 1 if there is data to read
 * returns 0 if not */
static inline
int check_file_in(FILE *file, long sec, long usec)
{
  fd_set rfds;
  struct timeval tv;
  int ret;
  tv.tv_sec = sec;
  tv.tv_usec = usec;

  FD_ZERO(&rfds);
  FD_SET(fileno(file), &rfds);
  ret = select(fileno(file)+1, &rfds, NULL, NULL, &tv);
  //DEBUG("select(,fd=%d,)=%d\n", fileno(file), ret);
  if(ret > 0)
    return 1;

  VASSERT(ret != -1, "select(,fd=%d,,) failed\n", fileno(file));

  if(ret == -1)
    QP_EERROR("reading input failed\n");

  return 0;
}

