/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998, 1999  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Or look at http://www.gnu.org/copyleft/gpl.html .

**********************************************************************/
/* $Id: data.h,v 1.6 1999/02/28 01:58:50 lance Exp $ */
/**************************************************
*** this file is the guts of LANCEMAN's quickplot
*** if you understand this you understand
*** LANCEMAN's quickplot
**************************************************/

#ifndef NULL
#ifdef __cplusplus
#define NULL 0
#else
#define NULL ( (void*)0 )
#endif /* #ifdef __cplusplus */
#endif /* #ifndef NULL */

#define X 0 /* don't change this */
#define Y 1 /* don't change this */
#define DATA_LABEL_SIZE  14  /* number of chars in label[] - 1 for '\0' */
#define DEFAULT_NUM_ZOOM 10  /* the starting value of num_zoom */
#define FRACTION_WINDOW_USE 0.95
#define MIN_NUM_POINTS  2UL /* the mininum number of points that are needed */
#define DEFAULT_LABEL_SEPERATOR  040  /* <space> = ' ' = 040 */

/** global flags for all plots in flag       **/
/** the default has all of these flags unset **/
#define SAME_SCALE     01  /* opt -s plot all plots on the same scale */
#define PIPE_IN        02  /* opt -P pipe in data from standard in */
#define BINARY_DATA    04  /* opt -b read in data for binary data format */
#define VERBOSE       010  /* opt -v verbose print info to standard error */
#define LABELS        020  /* opt -l "label1 label2 ..." labels for fields */
#define READ_LABELS   040  /* opt -R read in labels from the files */
#define NO_PIXMAP0   0100  /* opt -X don't load a pixmap of the first view of plots */
#define COUNT_FIELD  0200  /* a count field was added to the data */
#define NO_PIPE_IN   0400  /* opt -N  no pipe in, over rides opt -P */
#define NO_AXES     01000  /* opt -a */

/* I haven't activated alot of this stuff yet */
/** flags for each plot in plot_opt[num_plots]    **/
/** And global flags for all plots in flag too    **/
/** the default plot has all of these flags unset **/
#define NO_LINES        010000  /* plot with no lines **/
#define FAT_LINES       020000  /* with fat lines if LINES */
#define NO_POINTS       040000
#define PHASE_PLOT     0100000  /* phase plot instead of function plot */
#define BLACK_WHITE    0200000


struct Data
{                        /* a linked list */
  struct Data *prev;     /* pointer to previous Data, NULL is the first one */
  double val;            /* the data value */
  struct Data *next;     /* pointer to next Date, NULL is the last one */
};                       /* struct size 16 bytes on Linux GNU gcc version 2.7.2 */


typedef struct
{
  int flag;                   /* global flag for configuring all plots  */
  int dim;                    /* number of data fields : example 4 */
  char **infiles;             /* the input files terminate with NULL */
  int skip_lines;             /* number of lines to skip when reading data */
  unsigned long *num_points;  /* number of points: example 100000 
                                 num_points[dim]                   */
  double *max;                /* max of data[].x: max[dim] */
  double *min;                /* min of data[].x: min[dim] */
  struct Data **data;         /* the array of pointers to data data[dim] */
  char *labels;               /* all the labels before label is built */
  char label_seperator;       /* char that seperates field labels in labels */
  char **label;               /* data field label: label[dim][DATA_LABEL_SIZE] */
  int num_plots;              /* the number of plots */
  int *plot_opt;              /* option flags to tell how plot
				 each plot: plot_opt[num_plots]  */
  unsigned long *point_color; /* color:  point_color[num_plots] */
  unsigned long *line_color;  /* color:  line_color[num_plots] */
  int **list;                 /* plot list 2-D plots data
				 list[num_plots][2]    2= X or Y */
  double **scale;             /* plot scale data: scale[num_plots][2]*Data.val */
  double **shift;             /* then shift data: + shift[num_plots][2] 2= X or Y*/
                              /* for zoom clipping in function plotting  */
  struct Data ****start;      /* clip all data before 
				 start[num_zoom][num_plots][2]  2= X or Y */
  struct Data ****end;        /* clip all data after 
				 end[num_zoom][num_plots][2]  2= X or Y */
  int zoom_count;             /* current zoom-in count start at 0 */
  int num_zoom;               /* you can zoom back num_zoom times */
                              /* after that it zooms all the way out */
                              /* the zoom scale and shift is applied
				 after the data scale and shift      */
  double **z_scale;           /* zoom scale z_scale[num_zoom][2]   2= X or Y*/
  double **z_shift;           /* zoom shift z_shift[num_zoom][2]   2= X or Y*/

} Plot;   /* struct size 80 bytes Linux2.0.27 GNU gcc2.7.2 on Intel PentPro */

