/***************************************************************************
 *            plugin.c
 *
 *  Sun Sep 24 12:12:57 2006
 *  Copyright  2006-2007  Neil Williams
 *  linux@codehelp.co.uk
 ****************************************************************************/
/** @file plugin.c
	@brief GModule Plugin system
	@author Copyright 2006-2007  Neil Williams <linux@codehelp.co.uk>
	@author Copyright 1999  Sam Phillips <sam@usaworks.com> 
*/
/*
    This package is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <gmodule.h>
#include <string.h>
#include <stdlib.h>
#include <dirent.h>
#include "plugin.h"

typedef struct _PluginData PluginData;

struct _PluginData
{
	GModule *handle;
	gchar *title;
	
	gint (*init) (PluginData *);
};

static GList *plugin_list = NULL;

static void
load_plugin (const gchar * file)
{
	PluginData *pd;
	gpointer g;
	GList *t;

	pd = g_new0 (PluginData, 1);
	pd->handle = g_module_open (file, 0);
	if (!pd->handle)
	{
		g_free (pd);
		return;
	}
	g = &pd->init;
	g_module_symbol (pd->handle, "init_plugin", g);
	pd->init (pd);
	t = g_list_append (plugin_list, pd);
}

static void
load_plugin_directory (gchar * directory)
{
	const gchar *filename;
	GError *qlerr;
	GDir *d;

	qlerr = NULL;
	d = g_dir_open (directory, 0, &qlerr);
	if (qlerr != NULL)
		return;
	while ((filename = g_dir_read_name (d)) != NULL)
	{
		gchar *plugin_name = g_module_build_path (directory, filename);
		if (plugin_name)
		{
			load_plugin (plugin_name);
			g_free (plugin_name);
		}
	}
	g_dir_close (d);
}

gboolean
init_plugins (void)
{
	gchar *plugin_dir;
	const gchar *home_dir = g_get_home_dir ();

	if (!g_module_supported ())
		return FALSE;
	/* Load the user plugins */
	plugin_dir = g_strconcat (home_dir, "/.quicklist/plugins/", NULL);
	load_plugin_directory (plugin_dir);
	g_free (plugin_dir);

	return TRUE;
}
