/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.2
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */


#ifndef SWIGJAVA
#define SWIGJAVA
#endif

#define SWIG_DIRECTORS


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1,
  SWIG_JavaIOException,
  SWIG_JavaRuntimeException,
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError,
  SWIG_JavaIllegalStateException,
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { SWIG_JavaIllegalStateException, "java/lang/IllegalStateException" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1
#define  SWIG_IOError        	   -2
#define  SWIG_RuntimeError   	   -3
#define  SWIG_IndexError     	   -4
#define  SWIG_TypeError      	   -5
#define  SWIG_DivisionByZero 	   -6
#define  SWIG_OverflowError  	   -7
#define  SWIG_SyntaxError    	   -8
#define  SWIG_ValueError     	   -9
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12
#define  SWIG_NullReferenceError   -13



/* -----------------------------------------------------------------------------
 * director_common.swg
 *
 * This file contains support for director classes which is common between
 * languages.
 * ----------------------------------------------------------------------------- */

/*
  Use -DSWIG_DIRECTOR_STATIC if you prefer to avoid the use of the
  'Swig' namespace. This could be useful for multi-modules projects.
*/
#ifdef SWIG_DIRECTOR_STATIC
/* Force anonymous (static) namespace */
#define Swig
#endif
/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes so that Java proxy
 * methods can be called from C++.
 * ----------------------------------------------------------------------------- */

#if defined(DEBUG_DIRECTOR_OWNED) || defined(DEBUG_DIRECTOR_EXCEPTION) || defined(DEBUG_DIRECTOR_THREAD_NAME)
#include <iostream>
#endif

#include <exception>

#if defined(SWIG_JAVA_USE_THREAD_NAME)

#if !defined(SWIG_JAVA_GET_THREAD_NAME)
namespace Swig {
  SWIGINTERN int GetThreadName(char *name, size_t len);
}

#if defined(__linux__)

#include <sys/prctl.h>
SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  (void)len;
#if defined(PR_GET_NAME)
  return prctl(PR_GET_NAME, (unsigned long)name, 0, 0, 0);
#else
  (void)name;
  return 1;
#endif
}

#elif defined(__unix__) || defined(__APPLE__)

#include <pthread.h>
SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  return pthread_getname_np(pthread_self(), name, len);
}

#else

SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  (void)len;
  (void)name;
  return 1;
}
#endif

#endif

#endif

namespace Swig {

  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = weak_global || !mem_own; // hold as weak global if explicitly requested or not owned
        if (jobj)
          jthis_ = weak_global_ ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    /* Only call peek if you know what you are doing wrt to weak/global references */
    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else {
	/* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

  /* Local JNI reference deleter */
  class LocalRefGuard {
    JNIEnv *jenv_;
    jobject jobj_;

    // non-copyable
    LocalRefGuard(const LocalRefGuard &);
    LocalRefGuard &operator=(const LocalRefGuard &);
  public:
    LocalRefGuard(JNIEnv *jenv, jobject jobj): jenv_(jenv), jobj_(jobj) {}
    ~LocalRefGuard() {
      if (jobj_)
        jenv_->DeleteLocalRef(jobj_);
    }
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
      int env_status;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(0), env_status(0) {
#if defined(__ANDROID__)
        JNIEnv **jenv = &jenv_;
#else
        void **jenv = (void **)&jenv_;
#endif
        env_status = director_->swig_jvm_->GetEnv((void **)&jenv_, JNI_VERSION_1_2);
        JavaVMAttachArgs args;
        args.version = JNI_VERSION_1_2;
        args.group = NULL;
        args.name = NULL;
#if defined(SWIG_JAVA_USE_THREAD_NAME)
        char thread_name[64];  // MAX_TASK_COMM_LEN=16 is hard-coded in the Linux kernel and MacOS has MAXTHREADNAMESIZE=64.
        if (Swig::GetThreadName(thread_name, sizeof(thread_name)) == 0) {
          args.name = thread_name;
#if defined(DEBUG_DIRECTOR_THREAD_NAME)
          std::cout << "JNIEnvWrapper: thread name: " << thread_name << std::endl;
        } else {
          std::cout << "JNIEnvWrapper: Couldn't set Java thread name" << std::endl;
#endif
        }
#endif
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon(jenv, &args);
#else
        director_->swig_jvm_->AttachCurrentThread(jenv, &args);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        if (env_status == JNI_EDETACHED)
          director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.get(jenv);
      LocalRefGuard ref_deleter(jenv, jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };

  // Zero initialized bool array
  template<size_t N> class BoolArray {
    bool array_[N];
  public:
    BoolArray() {
      memset(array_, 0, sizeof(array_));
    }
    bool& operator[](size_t n) {
      return array_[n];
    }
    bool operator[](size_t n) const {
      return array_[n];
    }
  };

  // Utility classes and functions for exception handling.

  // Simple holder for a Java string during exception handling, providing access to a c-style string
  class JavaString {
  public:
    JavaString(JNIEnv *jenv, jstring jstr) : jenv_(jenv), jstr_(jstr), cstr_(0) {
      if (jenv_ && jstr_)
	cstr_ = (const char *) jenv_->GetStringUTFChars(jstr_, NULL);
    }

    ~JavaString() {
      if (jenv_ && jstr_ && cstr_)
	jenv_->ReleaseStringUTFChars(jstr_, cstr_);
    }

    const char *c_str(const char *null_string = "null JavaString") const {
      return cstr_ ? cstr_ : null_string;
    }

  private:
    // non-copyable
    JavaString(const JavaString &);
    JavaString &operator=(const JavaString &);

    JNIEnv *jenv_;
    jstring jstr_;
    const char *cstr_;
  };

  // Helper class to extract the exception message from a Java throwable
  class JavaExceptionMessage {
  public:
    JavaExceptionMessage(JNIEnv *jenv, jthrowable throwable) : message_(jenv, exceptionMessageFromThrowable(jenv, throwable)) {
    }

    // Return a C string of the exception message in the jthrowable passed in the constructor
    // If no message is available, null_string is return instead
    const char *message(const char *null_string = "Could not get exception message in JavaExceptionMessage") const {
      return message_.c_str(null_string);
    }

  private:
    // non-copyable
    JavaExceptionMessage(const JavaExceptionMessage &);
    JavaExceptionMessage &operator=(const JavaExceptionMessage &);

    // Get exception message by calling Java method Throwable.getMessage()
    static jstring exceptionMessageFromThrowable(JNIEnv *jenv, jthrowable throwable) {
      jstring jmsg = NULL;
      if (jenv && throwable) {
	jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  // All Throwable classes have a getMessage() method, so call it to extract the exception message
	  jmethodID getMessageMethodID = jenv->GetMethodID(throwclz, "getMessage", "()Ljava/lang/String;");
	  if (getMessageMethodID)
	    jmsg = (jstring)jenv->CallObjectMethod(throwable, getMessageMethodID);
	}
	if (jmsg == NULL && jenv->ExceptionCheck())
	  jenv->ExceptionClear();
      }
      return jmsg;
    }

    JavaString message_;
  };

  // C++ Exception class for handling Java exceptions thrown during a director method Java upcall
  class DirectorException : public std::exception {
  public:

    // Construct exception from a Java throwable
    DirectorException(JNIEnv *jenv, jthrowable throwable) : jenv_(jenv), throwable_(throwable), classname_(0), msg_(0) {

      // Call Java method Object.getClass().getName() to obtain the throwable's class name (delimited by '/')
      if (jenv && throwable) {
	jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  jclass clzclz = jenv->GetObjectClass(throwclz);
	  if (clzclz) {
	    jmethodID getNameMethodID = jenv->GetMethodID(clzclz, "getName", "()Ljava/lang/String;");
	    if (getNameMethodID) {
	      jstring jstr_classname = (jstring)(jenv->CallObjectMethod(throwclz, getNameMethodID));
              // Copy strings, since there is no guarantee that jenv will be active when handled
              if (jstr_classname) {
                JavaString jsclassname(jenv, jstr_classname);
                const char *classname = jsclassname.c_str(0);
                if (classname)
                  classname_ = copypath(classname);
              }
	    }
	  }
	}
      }

      JavaExceptionMessage exceptionmsg(jenv, throwable);
      msg_ = copystr(exceptionmsg.message(0));
    }

    // More general constructor for handling as a java.lang.RuntimeException
    DirectorException(const char *msg) : jenv_(0), throwable_(0), classname_(0), msg_(msg ? copystr(msg) : 0) {
    }

    ~DirectorException() throw() {
      delete[] classname_;
      delete[] msg_;
    }

    const char *what() const throw() {
      return msg_ ? msg_ : "Unspecified DirectorException message";
    }

    // Reconstruct and raise/throw the Java Exception that caused the DirectorException
    // Note that any error in the JNI exception handling results in a Java RuntimeException
    void throwException(JNIEnv *jenv) const {
      if (jenv) {
        if (jenv == jenv_ && throwable_) {
          // Throw original exception if not already pending
          jthrowable throwable = jenv->ExceptionOccurred();
          if (throwable && jenv->IsSameObject(throwable, throwable_) == JNI_FALSE) {
            jenv->ExceptionClear();
            throwable = 0;
          }
          if (!throwable)
            jenv->Throw(throwable_);
        } else {
          // Try and reconstruct original exception, but original stacktrace is not reconstructed
          jenv->ExceptionClear();

          jmethodID ctorMethodID = 0;
          jclass throwableclass = 0;
          if (classname_) {
            throwableclass = jenv->FindClass(classname_);
            if (throwableclass)
              ctorMethodID = jenv->GetMethodID(throwableclass, "<init>", "(Ljava/lang/String;)V");
          }

          if (ctorMethodID) {
            jenv->ThrowNew(throwableclass, what());
          } else {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, what());
          }
        }
      }
    }

    // Deprecated - use throwException
    void raiseJavaException(JNIEnv *jenv) const {
      throwException(jenv);
    }

    // Create and throw the DirectorException
    static void raise(JNIEnv *jenv, jthrowable throwable) {
      throw DirectorException(jenv, throwable);
    }

  private:
    static char *copypath(const char *srcmsg) {
      char *target = copystr(srcmsg);
      for (char *c=target; *c; ++c) {
        if ('.' == *c)
          *c = '/';
      }
      return target;
    }

    static char *copystr(const char *srcmsg) {
      char *target = 0;
      if (srcmsg) {
	size_t msglen = strlen(srcmsg) + 1;
	target = new char[msglen];
	strncpy(target, srcmsg, msglen);
      }
      return target;
    }

    JNIEnv *jenv_;
    jthrowable throwable_;
    const char *classname_;
    const char *msg_;
  };

  // Helper method to determine if a Java throwable matches a particular Java class type
  // Note side effect of clearing any pending exceptions
  SWIGINTERN bool ExceptionMatches(JNIEnv *jenv, jthrowable throwable, const char *classname) {
    bool matches = false;

    if (throwable && jenv && classname) {
      // Exceptions need to be cleared for correct behavior.
      // The caller of ExceptionMatches should restore pending exceptions if desired -
      // the caller already has the throwable.
      jenv->ExceptionClear();

      jclass clz = jenv->FindClass(classname);
      if (clz) {
	jclass classclz = jenv->GetObjectClass(clz);
	jmethodID isInstanceMethodID = jenv->GetMethodID(classclz, "isInstance", "(Ljava/lang/Object;)Z");
	if (isInstanceMethodID) {
	  matches = jenv->CallBooleanMethod(clz, isInstanceMethodID, throwable) != 0;
	}
      }

#if defined(DEBUG_DIRECTOR_EXCEPTION)
      if (jenv->ExceptionCheck()) {
        // Typically occurs when an invalid classname argument is passed resulting in a ClassNotFoundException
        JavaExceptionMessage exc(jenv, jenv->ExceptionOccurred());
        std::cout << "Error: ExceptionMatches: class '" << classname << "' : " << exc.message() << std::endl;
      }
#endif
    }
    return matches;
  }
}

namespace Swig {
  namespace {
    jclass jclass_QuantLibJNI = NULL;
    jmethodID director_method_ids[15];
  }
}

SWIGINTERN void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}


#include <typeinfo>
#include <stdexcept>


#include <typeinfo>
#include <stdexcept>


#include <string>


#include <vector>
#include <stdexcept>


#include <map>
#include <stdexcept>


#include <utility>


#include <ql/quantlib.hpp>

#if QL_HEX_VERSION < 0x01260000
    #error using an old version of QuantLib, please update
#endif

#ifdef BOOST_MSVC
#ifdef QL_ENABLE_THREAD_SAFE_OBSERVER_PATTERN
#define BOOST_LIB_NAME boost_thread
#include <boost/config/auto_link.hpp>
#undef BOOST_LIB_NAME
#define BOOST_LIB_NAME boost_system
#include <boost/config/auto_link.hpp>
#undef BOOST_LIB_NAME
#endif
#endif

#if defined (SWIGJAVA) || defined (SWIGCSHARP) 
  #ifndef QL_ENABLE_THREAD_SAFE_OBSERVER_PATTERN
    #ifdef BOOST_MSVC
      #pragma message(\
          "Quantlib has not been compiled with the thread-safe "           \
          "observer pattern being enabled. This can lead to spurious "     \
          "crashes or pure virtual function call within the JVM or .NET "  \
          "ecosystem due to the async garbage collector. Please consider " \
          "enabling QL_ENABLE_THREAD_SAFE_OBSERVER_PATTERN "               \
          "in ql/userconfig.hpp.")
    #else
      #warning \
          Quantlib has not been compiled with the thread-safe           \
          observer pattern being enabled. This can lead to spurious     \
          crashes or pure virtual function call within the JVM or .NET  \
          ecosystem due to the async garbage collector. Please consider \
          passing --enable-thread-safe-observer-pattern when using the  \
          GNU autoconf configure script.
    #endif
  #endif
#endif


// add here SWIG version check

#if defined(_MSC_VER)         // Microsoft Visual C++ 6.0
// disable Swig-dependent warnings

// 'identifier1' has C-linkage specified,
// but returns UDT 'identifier2' which is incompatible with C
#pragma warning(disable: 4190)

// 'int' : forcing value to bool 'true' or 'false' (performance warning)
#pragma warning(disable: 4800)

// debug info too long etc etc
#pragma warning(disable: 4786)
#endif


// we do not want to see the deprecated warnings here
QL_DEPRECATED_DISABLE_WARNING


    namespace QuantLib { namespace ext {} }
    namespace ext = QuantLib::ext;


// This is necessary to avoid compile failures on 
// GCC 4
// see http://svn.boost.org/trac/boost/ticket/1793

#if defined(NDEBUG)
#define BOOST_DISABLE_ASSERTS 1
#endif

#include <boost/algorithm/string/case_conv.hpp>


// generally useful classes
using QuantLib::Error;
using QuantLib::Handle;
using QuantLib::RelinkableHandle;


using QuantLib::Integer;
using QuantLib::BigInteger;
using QuantLib::Natural;
using QuantLib::BigNatural;
using QuantLib::Real;
using QuantLib::Decimal;
using QuantLib::Time;
using QuantLib::Rate;
using QuantLib::Spread;
using QuantLib::DiscountFactor;
using QuantLib::Volatility;
using QuantLib::Probability;
using QuantLib::Size;


#ifndef QL_HIGH_RESOLUTION_DATE
    // They are not defined in the library, so we define them here
    namespace QuantLib {
        typedef int Hour;
        typedef int Minute;
        typedef int Second;
        typedef int Millisecond;
        typedef int Microsecond;
    }
#endif

using QuantLib::Day;
using QuantLib::Year;
using QuantLib::Hour;
using QuantLib::Minute;
using QuantLib::Second;
using QuantLib::Millisecond;
using QuantLib::Microsecond;


using QuantLib::Weekday;
using QuantLib::Sunday;
using QuantLib::Monday;
using QuantLib::Tuesday;
using QuantLib::Wednesday;
using QuantLib::Thursday;
using QuantLib::Friday;
using QuantLib::Saturday;


using QuantLib::Month;
using QuantLib::January;
using QuantLib::February;
using QuantLib::March;
using QuantLib::April;
using QuantLib::May;
using QuantLib::June;
using QuantLib::July;
using QuantLib::August;
using QuantLib::September;
using QuantLib::October;
using QuantLib::November;
using QuantLib::December;


using QuantLib::TimeUnit;
using QuantLib::Days;
using QuantLib::Weeks;
using QuantLib::Months;
using QuantLib::Years;
using QuantLib::Hours;
using QuantLib::Minutes;
using QuantLib::Seconds;
using QuantLib::Milliseconds;
using QuantLib::Microseconds;


using QuantLib::Frequency;
using QuantLib::NoFrequency;
using QuantLib::Once;
using QuantLib::Annual;
using QuantLib::Semiannual;
using QuantLib::EveryFourthMonth;
using QuantLib::Quarterly;
using QuantLib::Bimonthly;
using QuantLib::Monthly;
using QuantLib::EveryFourthWeek;
using QuantLib::Biweekly;
using QuantLib::Weekly;
using QuantLib::Daily;
using QuantLib::OtherFrequency;


using QuantLib::Period;
using QuantLib::PeriodParser;

SWIGINTERN Period *new_Period__SWIG_3(std::string const &str){
            return new Period(PeriodParser::parse(str));
        }
SWIGINTERN std::string Period___str__(Period *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN std::string Period___repr__(Period *self){
            std::ostringstream out;
            out << "Period(\"" << QuantLib::io::short_period(*self) << "\")";
            return out.str();
        }

/* Check for overflow converting to Java int (always signed 32-bit) from (unsigned variable-bit) size_t */
SWIGINTERN jint SWIG_JavaIntFromSize_t(size_t size) {
  static const jint JINT_MAX = 0x7FFFFFFF;
  return (size > (size_t)JINT_MAX) ? -1 : (jint)size;
}


SWIGINTERN jint SWIG_VectorSize(size_t size) {
  jint sz = SWIG_JavaIntFromSize_t(size);
  if (sz == -1)
    throw std::out_of_range("vector size is too large to fit into a Java int");
  return sz;
}

SWIGINTERN std::vector< Period > *new_std_vector_Sl_Period_Sg___SWIG_2(jint count,Period const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< Period >(static_cast<std::vector< Period >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_Period_Sg__doSize(std::vector< Period > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_Period_Sg__doAdd__SWIG_0(std::vector< Period > *self,std::vector< Period >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_Period_Sg__doAdd__SWIG_1(std::vector< Period > *self,jint index,std::vector< Period >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< Period >::value_type std_vector_Sl_Period_Sg__doRemove(std::vector< Period > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          Period const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< Period >::value_type const &std_vector_Sl_Period_Sg__doGet(std::vector< Period > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< Period >::value_type std_vector_Sl_Period_Sg__doSet(std::vector< Period > *self,jint index,std::vector< Period >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          Period const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_Period_Sg__doRemoveRange(std::vector< Period > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

using QuantLib::Date;
using QuantLib::DateParser;


    // used in Date(string, string) defined below
    void _replace_format(std::string& s, const std::string& old_format,
                         const std::string& new_format) {
        std::string::size_type i = s.find(old_format);
        if (i != std::string::npos)
            s.replace(i, old_format.length(), new_format);
    }

SWIGINTERN Date *new_Date__SWIG_2(Day d,Month m,Year y,Hour hours,Minute minutes,Second seconds,Millisecond millisec=0,Microsecond microsec=0){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return new Date(d, m, y, hours, minutes, seconds,
                            millisec, microsec);
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Hour Date_hours(Date *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->hours();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Minute Date_minutes(Date *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->minutes();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Second Date_seconds(Date *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->seconds();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Millisecond Date_milliseconds(Date *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->milliseconds();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Microsecond Date_microseconds(Date *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->microseconds();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Time Date_fractionOfDay(Date const *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->fractionOfDay();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Time Date_fractionOfSecond(Date const *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->fractionOfSecond();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Date Date_localDateTime(){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return Date::localDateTime();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Date Date_universalDateTime(){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return Date::universalDateTime();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
         }
SWIGINTERN Date *new_Date__SWIG_6(std::string const &str,std::string fmt){
            // convert our old format into the corresponding Boost one
            _replace_format(fmt, "YYYY", "%Y");
            _replace_format(fmt, "yyyy", "%Y");
            _replace_format(fmt, "YY", "%y");
            _replace_format(fmt, "yy", "%y");
            _replace_format(fmt, "MM", "%m");
            _replace_format(fmt, "mm", "%m");
            _replace_format(fmt, "DD", "%d");
            _replace_format(fmt, "dd", "%d");
            return new Date(DateParser::parseFormatted(str,fmt));
        }
SWIGINTERN Integer Date_weekdayNumber(Date *self){
            return int(self->weekday());
        }
SWIGINTERN std::string Date___str__(Date *self){
            std::ostringstream out;
        #ifdef QL_HIGH_RESOLUTION_DATE
            out << QuantLib::io::iso_datetime(*self);
        #else
            out << *self;
        #endif
            return out.str();
        }
SWIGINTERN std::string Date___repr__(Date *self){
            std::ostringstream out;
            if (*self == Date())
                out << "Date()";
            else
        #ifdef QL_HIGH_RESOLUTION_DATE
                out << "Date(" << self->dayOfMonth() << ","
                    << int(self->month()) << "," << self->year() << ","
                    << self->hours() << "," << self->minutes() << ","
                    << self->seconds() << "," << self->milliseconds() << ","
                    << self->microseconds() << ")";
        #else
                out << "Date(" << self->dayOfMonth() << ","
                    << int(self->month()) << "," << self->year() << ")";
        #endif
            return out.str();
        }
SWIGINTERN std::string Date_ISO(Date *self){
            std::ostringstream out;
            out << QuantLib::io::iso_date(*self);
            return out.str();
        }
SWIGINTERN Date DateParser_parse(std::string const &str,std::string fmt){
            // convert our old format into the corresponding Boost one
            _replace_format(fmt, "YYYY", "%Y");
            _replace_format(fmt, "yyyy", "%Y");
            _replace_format(fmt, "YY", "%y");
            _replace_format(fmt, "yy", "%y");
            _replace_format(fmt, "MM", "%m");
            _replace_format(fmt, "mm", "%m");
            _replace_format(fmt, "DD", "%d");
            _replace_format(fmt, "dd", "%d");
            return DateParser::parseFormatted(str,fmt);
        }
SWIGINTERN std::vector< Date > *new_std_vector_Sl_Date_Sg___SWIG_2(jint count,Date const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< Date >(static_cast<std::vector< Date >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_Date_Sg__doSize(std::vector< Date > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_Date_Sg__doAdd__SWIG_0(std::vector< Date > *self,std::vector< Date >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_Date_Sg__doAdd__SWIG_1(std::vector< Date > *self,jint index,std::vector< Date >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< Date >::value_type std_vector_Sl_Date_Sg__doRemove(std::vector< Date > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          Date const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< Date >::value_type const &std_vector_Sl_Date_Sg__doGet(std::vector< Date > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< Date >::value_type std_vector_Sl_Date_Sg__doSet(std::vector< Date > *self,jint index,std::vector< Date >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          Date const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_Date_Sg__doRemoveRange(std::vector< Date > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

using QuantLib::IMM;


using QuantLib::ASX;


template <class T, class U>
std::vector<T> to_vector(const std::vector<U>& v) {
    std::vector<T> out(v.size());
    std::copy(v.begin(), v.end(), out.begin());
    return out;
}

SWIGINTERN std::vector< int > *new_std_vector_Sl_int_Sg___SWIG_2(jint count,int const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< int >(static_cast<std::vector< int >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_int_Sg__doSize(std::vector< int > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_int_Sg__doAdd__SWIG_0(std::vector< int > *self,std::vector< int >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_int_Sg__doAdd__SWIG_1(std::vector< int > *self,jint index,std::vector< int >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< int >::value_type std_vector_Sl_int_Sg__doRemove(std::vector< int > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          int const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< int >::value_type const &std_vector_Sl_int_Sg__doGet(std::vector< int > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< int >::value_type std_vector_Sl_int_Sg__doSet(std::vector< int > *self,jint index,std::vector< int >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          int const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_int_Sg__doRemoveRange(std::vector< int > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< unsigned int > *new_std_vector_Sl_unsigned_SS_int_Sg___SWIG_2(jint count,unsigned int const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< unsigned int >(static_cast<std::vector< unsigned int >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_unsigned_SS_int_Sg__doSize(std::vector< unsigned int > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_unsigned_SS_int_Sg__doAdd__SWIG_0(std::vector< unsigned int > *self,std::vector< unsigned int >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_unsigned_SS_int_Sg__doAdd__SWIG_1(std::vector< unsigned int > *self,jint index,std::vector< unsigned int >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< unsigned int >::value_type std_vector_Sl_unsigned_SS_int_Sg__doRemove(std::vector< unsigned int > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          unsigned int const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< unsigned int >::value_type const &std_vector_Sl_unsigned_SS_int_Sg__doGet(std::vector< unsigned int > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< unsigned int >::value_type std_vector_Sl_unsigned_SS_int_Sg__doSet(std::vector< unsigned int > *self,jint index,std::vector< unsigned int >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          unsigned int const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_unsigned_SS_int_Sg__doRemoveRange(std::vector< unsigned int > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< double > *new_std_vector_Sl_double_Sg___SWIG_2(jint count,double const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< double >(static_cast<std::vector< double >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_double_Sg__doSize(std::vector< double > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_double_Sg__doAdd__SWIG_0(std::vector< double > *self,std::vector< double >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_double_Sg__doAdd__SWIG_1(std::vector< double > *self,jint index,std::vector< double >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< double >::value_type std_vector_Sl_double_Sg__doRemove(std::vector< double > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          double const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< double >::value_type const &std_vector_Sl_double_Sg__doGet(std::vector< double > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< double >::value_type std_vector_Sl_double_Sg__doSet(std::vector< double > *self,jint index,std::vector< double >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          double const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_double_Sg__doRemoveRange(std::vector< double > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::string > *new_std_vector_Sl_std_string_Sg___SWIG_2(jint count,std::string const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::string >(static_cast<std::vector< std::string >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_string_Sg__doSize(std::vector< std::string > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__doAdd__SWIG_0(std::vector< std::string > *self,std::vector< std::string >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__doAdd__SWIG_1(std::vector< std::string > *self,jint index,std::vector< std::string >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::string >::value_type std_vector_Sl_std_string_Sg__doRemove(std::vector< std::string > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::string const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::string >::value_type const &std_vector_Sl_std_string_Sg__doGet(std::vector< std::string > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::string >::value_type std_vector_Sl_std_string_Sg__doSet(std::vector< std::string > *self,jint index,std::vector< std::string >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::string const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__doRemoveRange(std::vector< std::string > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< bool > *new_std_vector_Sl_bool_Sg___SWIG_2(jint count,bool const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< bool >(static_cast<std::vector< bool >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_bool_Sg__doSize(std::vector< bool > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_bool_Sg__doAdd__SWIG_0(std::vector< bool > *self,std::vector< bool >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_bool_Sg__doAdd__SWIG_1(std::vector< bool > *self,jint index,std::vector< bool >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< bool >::value_type std_vector_Sl_bool_Sg__doRemove(std::vector< bool > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          bool const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN bool std_vector_Sl_bool_Sg__doGet(std::vector< bool > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< bool >::value_type std_vector_Sl_bool_Sg__doSet(std::vector< bool > *self,jint index,std::vector< bool >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          bool const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_bool_Sg__doRemoveRange(std::vector< bool > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::pair< double,double > > *new_std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg___SWIG_2(jint count,std::pair< double,double > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::pair< double,double > >(static_cast<std::vector< std::pair< double,double > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__doSize(std::vector< std::pair< double,double > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__doAdd__SWIG_0(std::vector< std::pair< double,double > > *self,std::vector< std::pair< double,double > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__doAdd__SWIG_1(std::vector< std::pair< double,double > > *self,jint index,std::vector< std::pair< double,double > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::pair< double,double > >::value_type std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__doRemove(std::vector< std::pair< double,double > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::pair< double,double > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::pair< double,double > >::value_type const &std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__doGet(std::vector< std::pair< double,double > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::pair< double,double > >::value_type std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__doSet(std::vector< std::pair< double,double > > *self,jint index,std::vector< std::pair< double,double > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::pair< double,double > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__doRemoveRange(std::vector< std::pair< double,double > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::pair< Date,double > > *new_std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg___SWIG_2(jint count,std::pair< Date,double > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::pair< Date,double > >(static_cast<std::vector< std::pair< Date,double > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__doSize(std::vector< std::pair< Date,double > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__doAdd__SWIG_0(std::vector< std::pair< Date,double > > *self,std::vector< std::pair< Date,double > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__doAdd__SWIG_1(std::vector< std::pair< Date,double > > *self,jint index,std::vector< std::pair< Date,double > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::pair< Date,double > >::value_type std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__doRemove(std::vector< std::pair< Date,double > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::pair< Date,double > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::pair< Date,double > >::value_type const &std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__doGet(std::vector< std::pair< Date,double > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::pair< Date,double > >::value_type std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__doSet(std::vector< std::pair< Date,double > > *self,jint index,std::vector< std::pair< Date,double > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::pair< Date,double > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__doRemoveRange(std::vector< std::pair< Date,double > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

using QuantLib::Exercise;


struct SWIG_null_deleter {
  void operator() (void const *) const {
  }
};
#define SWIG_NO_NULL_DELETER_0 , SWIG_null_deleter()
#define SWIG_NO_NULL_DELETER_1
#define SWIG_NO_NULL_DELETER_SWIG_POINTER_NEW
#define SWIG_NO_NULL_DELETER_SWIG_POINTER_OWN

SWIGINTERN Exercise::Type Exercise_exerciseType(Exercise *self){
            return self->type();
        }

using QuantLib::EuropeanExercise;
using QuantLib::AmericanExercise;
using QuantLib::BermudanExercise;
using QuantLib::RebatedExercise;
using QuantLib::SwingExercise;


using QuantLib::BusinessDayConvention;
using QuantLib::Calendar;
using QuantLib::Following;
using QuantLib::NullCalendar;


using QuantLib::Observer;
using QuantLib::Observable;


using QuantLib::Array;
using QuantLib::Matrix;
using QuantLib::SampledCurve;

SWIGINTERN std::string Array___str__(Array *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN Real Array_get(Array *self,Size i){
            if (i<self->size())
                return (*self)[i];
            else
                throw std::out_of_range("array index out of range");
        }
SWIGINTERN void Array_set(Array *self,Size i,Real x){
            if (i<self->size())
                (*self)[i] = x;
            else
                throw std::out_of_range("array index out of range");
        }

typedef QuantLib::LexicographicalView<Array::iterator>
    DefaultLexicographicalView;
typedef QuantLib::LexicographicalView<Array::iterator>::y_iterator
    DefaultLexicographicalViewColumn;

SWIGINTERN DefaultLexicographicalView *new_DefaultLexicographicalView(Array &a,Size xSize){
            return new DefaultLexicographicalView(a.begin(),a.end(),xSize);
        }
SWIGINTERN std::string DefaultLexicographicalView___str__(DefaultLexicographicalView *self){
            std::ostringstream s;
            for (Size j=0; j<self->ySize(); j++) {
                s << "\n";
                for (Size i=0; i<self->xSize(); i++) {
                    if (i != 0)
                        s << ",";
                    Array::value_type value = (*self)[i][j];
                    s << value;
                }
            }
            s << "\n";
            return s.str();
        }

typedef QuantLib::Matrix::row_iterator MatrixRow;
using QuantLib::outerProduct;
using QuantLib::transpose;
using QuantLib::SVD;

SWIGINTERN std::string Matrix___str__(Matrix *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN Real Matrix_get(Matrix *self,Size i,Size j){
            return (*self)[i][j];
        }
SWIGINTERN void Matrix_set(Matrix *self,Size i,Size j,Real x){
            (*self)[i][j] = x;
        }

using QuantLib::inverse;
using QuantLib::pseudoSqrt;
using QuantLib::SalvagingAlgorithm;


using QuantLib::BiCGstab;
using QuantLib::GMRES;


class MatrixMultiplicationDelegate {
  public:
    virtual ~MatrixMultiplicationDelegate() {}
      
    virtual Array apply(const Array& x) const {
        QL_FAIL("implementation of MatrixMultiplicationDelegate.apply is missing");        
    }
};

class MatrixMultiplicationProxy {
  public:
    MatrixMultiplicationProxy(MatrixMultiplicationDelegate* delegate)
    : delegate_(delegate) {}
    
    Array operator()(const Array& x) const {
        Array retVal = delegate_->apply(x);        
        return retVal;
    }
               
  private:
      MatrixMultiplicationDelegate* const delegate_; 
};

SWIGINTERN Array BiCGstab_solve__SWIG_0(BiCGstab const *self,Array const &b,Array const &x0=Array()){
                return self->solve(b, x0).x; 
        }
SWIGINTERN BiCGstab *new_BiCGstab__SWIG_0(MatrixMultiplicationDelegate *delegate,Size maxIter,Real relTol){
        	MatrixMultiplicationProxy proxy(delegate);          
            return new BiCGstab(BiCGstab::MatrixMult(proxy), maxIter, relTol);                       
        }
SWIGINTERN BiCGstab *new_BiCGstab__SWIG_1(MatrixMultiplicationDelegate *delegate,Size maxIter,Real relTol,MatrixMultiplicationDelegate *preconditioner){              
        	MatrixMultiplicationProxy p1(delegate); 
        	MatrixMultiplicationProxy p2(preconditioner);
            return new BiCGstab(
                BiCGstab::MatrixMult(p1), maxIter, relTol, BiCGstab::MatrixMult(p2));                       
        }
SWIGINTERN Array GMRES_solve__SWIG_0(GMRES const *self,Array const &b,Array const &x0=Array()){
            return self->solve(b, x0).x;
        }
SWIGINTERN Array GMRES_solveWithRestart__SWIG_0(GMRES const *self,Size restart,Array const &b,Array const &x0=Array()){
            return self->solveWithRestart(restart, b, x0).x;
        }
SWIGINTERN GMRES *new_GMRES__SWIG_0(MatrixMultiplicationDelegate *delegate,Size maxIter,Real relTol){
        	MatrixMultiplicationProxy proxy(delegate);              
            return new GMRES(GMRES::MatrixMult(proxy), maxIter, relTol);                       
        }
SWIGINTERN GMRES *new_GMRES__SWIG_1(MatrixMultiplicationDelegate *delegate,Size maxIter,Real relTol,MatrixMultiplicationProxy const &preconditioner){
        	MatrixMultiplicationProxy p1(delegate); 
        	MatrixMultiplicationProxy p2(preconditioner);                                      
            return new GMRES(
                GMRES::MatrixMult(p1), maxIter, relTol, GMRES::MatrixMult(p2));                       
        }

using QuantLib::close;
using QuantLib::close_enough;


using QuantLib::CostFunction;


class UnaryFunctionDelegate {
  public:
    virtual ~UnaryFunctionDelegate() {}
    virtual Real value(Real x) const {
        QL_FAIL("implementation of UnaryFunctionDelegate.value is missing");
    }
};

class UnaryFunction {
  public:
    UnaryFunction(UnaryFunctionDelegate* delegate)
    : delegate_(delegate) { }

    virtual ~UnaryFunction() { }

    Real operator()(Real x) const {
        return delegate_->value(x);
    }

  private:
    UnaryFunctionDelegate* delegate_;
};


class BinaryFunctionDelegate {
  public:
    virtual ~BinaryFunctionDelegate() {}
    virtual Real value(Real x, Real y) const {
    	QL_FAIL("implementation of BinaryFunctionDelegate.value is missing");
    }	
};

class BinaryFunction {
  public:
    BinaryFunction(BinaryFunctionDelegate* delegate)
    : delegate_(delegate) {}
    
    virtual ~BinaryFunction() {}
    
    Real operator()(Real x, Real y) const {
    	return delegate_->value(x, y);
    }
    
  private:
    BinaryFunctionDelegate* delegate_; 
};


class CostFunctionDelegate {
  public:
    virtual ~CostFunctionDelegate() {}
    virtual Real value(const Array& x) const {
      QL_FAIL("implementation of CostFunctionDelegate.value is missing");
    }

    virtual Array values(const Array& x) const {
      QL_FAIL("implementation of CostFunctionDelegate.values is missing");
    }
};

class JavaCostFunction : public CostFunction {
  public:
    JavaCostFunction(CostFunctionDelegate* delegate)
    : delegate_(delegate) { }

    virtual ~JavaCostFunction(){ }

    virtual Real value(const Array& x ) const{
      return delegate_->value(x);
    }

    virtual Array values(const Array& x) const {
      Array retVal = delegate_->values(x);
      return retVal;
    }

  private:
    CostFunctionDelegate* delegate_;
};


using QuantLib::Quote;

SWIGINTERN ext::shared_ptr< Observable > Handle_Sl_Quote_Sg__asObservable(Handle< Quote > *self){
        return ext::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_Quote_Sg__reset(RelinkableHandle< Quote > *self){
            self->linkTo(ext::shared_ptr<Quote>());
        }

using QuantLib::SimpleQuote;

SWIGINTERN std::vector< ext::shared_ptr< Quote > > *new_std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg___SWIG_2(jint count,ext::shared_ptr< Quote > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< Quote > >(static_cast<std::vector< ext::shared_ptr< Quote > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__doSize(std::vector< ext::shared_ptr< Quote > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< Quote > > *self,std::vector< ext::shared_ptr< Quote > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< Quote > > *self,jint index,std::vector< ext::shared_ptr< Quote > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< Quote > >::value_type std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__doRemove(std::vector< ext::shared_ptr< Quote > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< Quote > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< Quote > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__doGet(std::vector< ext::shared_ptr< Quote > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< Quote > >::value_type std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__doSet(std::vector< ext::shared_ptr< Quote > > *self,jint index,std::vector< ext::shared_ptr< Quote > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< Quote > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< Quote > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::vector< ext::shared_ptr< Quote > > > *new_std_vector_Sl_std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg___SWIG_2(jint count,std::vector< ext::shared_ptr< Quote > > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::vector< ext::shared_ptr< Quote > > >(static_cast<std::vector< std::vector< ext::shared_ptr< Quote > > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doSize(std::vector< std::vector< ext::shared_ptr< Quote > > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doAdd__SWIG_0(std::vector< std::vector< ext::shared_ptr< Quote > > > *self,std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doAdd__SWIG_1(std::vector< std::vector< ext::shared_ptr< Quote > > > *self,jint index,std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type std_vector_Sl_std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doRemove(std::vector< std::vector< ext::shared_ptr< Quote > > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::vector< ext::shared_ptr< Quote > > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type const &std_vector_Sl_std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doGet(std::vector< std::vector< ext::shared_ptr< Quote > > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type std_vector_Sl_std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doSet(std::vector< std::vector< ext::shared_ptr< Quote > > > *self,jint index,std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::vector< ext::shared_ptr< Quote > > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doRemoveRange(std::vector< std::vector< ext::shared_ptr< Quote > > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< Handle< Quote > > *new_std_vector_Sl_Handle_Sl_Quote_Sg__Sg___SWIG_2(jint count,Handle< Quote > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< Handle< Quote > >(static_cast<std::vector< Handle< Quote > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_Handle_Sl_Quote_Sg__Sg__doSize(std::vector< Handle< Quote > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__doAdd__SWIG_0(std::vector< Handle< Quote > > *self,std::vector< Handle< Quote > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__doAdd__SWIG_1(std::vector< Handle< Quote > > *self,jint index,std::vector< Handle< Quote > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< Handle< Quote > >::value_type std_vector_Sl_Handle_Sl_Quote_Sg__Sg__doRemove(std::vector< Handle< Quote > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          Handle< Quote > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< Handle< Quote > >::value_type const &std_vector_Sl_Handle_Sl_Quote_Sg__Sg__doGet(std::vector< Handle< Quote > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< Handle< Quote > >::value_type std_vector_Sl_Handle_Sl_Quote_Sg__Sg__doSet(std::vector< Handle< Quote > > *self,jint index,std::vector< Handle< Quote > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          Handle< Quote > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__doRemoveRange(std::vector< Handle< Quote > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::vector< Handle< Quote > > > *new_std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg___SWIG_2(jint count,std::vector< Handle< Quote > > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::vector< Handle< Quote > > >(static_cast<std::vector< std::vector< Handle< Quote > > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__doSize(std::vector< std::vector< Handle< Quote > > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__doAdd__SWIG_0(std::vector< std::vector< Handle< Quote > > > *self,std::vector< std::vector< Handle< Quote > > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__doAdd__SWIG_1(std::vector< std::vector< Handle< Quote > > > *self,jint index,std::vector< std::vector< Handle< Quote > > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::vector< Handle< Quote > > >::value_type std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__doRemove(std::vector< std::vector< Handle< Quote > > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::vector< Handle< Quote > > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::vector< Handle< Quote > > >::value_type const &std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__doGet(std::vector< std::vector< Handle< Quote > > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::vector< Handle< Quote > > >::value_type std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__doSet(std::vector< std::vector< Handle< Quote > > > *self,jint index,std::vector< std::vector< Handle< Quote > > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::vector< Handle< Quote > > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__doRemoveRange(std::vector< std::vector< Handle< Quote > > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RelinkableHandle< Quote > > *new_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg___SWIG_2(jint count,RelinkableHandle< Quote > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< RelinkableHandle< Quote > >(static_cast<std::vector< RelinkableHandle< Quote > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__doSize(std::vector< RelinkableHandle< Quote > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__doAdd__SWIG_0(std::vector< RelinkableHandle< Quote > > *self,std::vector< RelinkableHandle< Quote > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__doAdd__SWIG_1(std::vector< RelinkableHandle< Quote > > *self,jint index,std::vector< RelinkableHandle< Quote > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RelinkableHandle< Quote > >::value_type std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__doRemove(std::vector< RelinkableHandle< Quote > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          RelinkableHandle< Quote > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RelinkableHandle< Quote > >::value_type const &std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__doGet(std::vector< RelinkableHandle< Quote > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< RelinkableHandle< Quote > >::value_type std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__doSet(std::vector< RelinkableHandle< Quote > > *self,jint index,std::vector< RelinkableHandle< Quote > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          RelinkableHandle< Quote > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__doRemoveRange(std::vector< RelinkableHandle< Quote > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::vector< RelinkableHandle< Quote > > > *new_std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg___SWIG_2(jint count,std::vector< RelinkableHandle< Quote > > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::vector< RelinkableHandle< Quote > > >(static_cast<std::vector< std::vector< RelinkableHandle< Quote > > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__doSize(std::vector< std::vector< RelinkableHandle< Quote > > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__doAdd__SWIG_0(std::vector< std::vector< RelinkableHandle< Quote > > > *self,std::vector< std::vector< RelinkableHandle< Quote > > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__doAdd__SWIG_1(std::vector< std::vector< RelinkableHandle< Quote > > > *self,jint index,std::vector< std::vector< RelinkableHandle< Quote > > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::vector< RelinkableHandle< Quote > > >::value_type std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__doRemove(std::vector< std::vector< RelinkableHandle< Quote > > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::vector< RelinkableHandle< Quote > > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::vector< RelinkableHandle< Quote > > >::value_type const &std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__doGet(std::vector< std::vector< RelinkableHandle< Quote > > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::vector< RelinkableHandle< Quote > > >::value_type std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__doSet(std::vector< std::vector< RelinkableHandle< Quote > > > *self,jint index,std::vector< std::vector< RelinkableHandle< Quote > > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::vector< RelinkableHandle< Quote > > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__doRemoveRange(std::vector< std::vector< RelinkableHandle< Quote > > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

using QuantLib::Calendar;


using QuantLib::BusinessDayConvention;
using QuantLib::Following;
using QuantLib::ModifiedFollowing;
using QuantLib::Preceding;
using QuantLib::ModifiedPreceding;
using QuantLib::Unadjusted;
using QuantLib::HalfMonthModifiedFollowing;


using QuantLib::JointCalendarRule;
using QuantLib::JoinHolidays;
using QuantLib::JoinBusinessDays;

SWIGINTERN std::string Calendar___str__(Calendar *self){
            return self->name()+" calendar";
        }
SWIGINTERN bool Calendar___eq__(Calendar *self,Calendar const &other){
            return (*self) == other;
        }
SWIGINTERN bool Calendar___ne__(Calendar *self,Calendar const &other){
            return (*self) != other;
        }

using QuantLib::Null;
typedef int intOrNull;
typedef double doubleOrNull;


int nullInt() { return Null<int>(); }
double nullDouble() { return Null<double>(); }


using QuantLib::DayCounter;

SWIGINTERN std::string DayCounter___str__(DayCounter *self){
            return self->name()+" day counter";
        }
SWIGINTERN bool DayCounter___eq__(DayCounter *self,DayCounter const &other){
            return (*self) == other;
        }
SWIGINTERN bool DayCounter___ne__(DayCounter *self,DayCounter const &other){
            return (*self) != other;
        }

using QuantLib::Compounding;
using QuantLib::Simple;
using QuantLib::Compounded;
using QuantLib::Continuous;
using QuantLib::SimpleThenCompounded;
using QuantLib::CompoundedThenSimple;


using QuantLib::InterestRate;

SWIGINTERN std::string InterestRate___str__(InterestRate *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN std::vector< InterestRate > *new_std_vector_Sl_InterestRate_Sg___SWIG_2(jint count,InterestRate const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< InterestRate >(static_cast<std::vector< InterestRate >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_InterestRate_Sg__doSize(std::vector< InterestRate > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_InterestRate_Sg__doAdd__SWIG_0(std::vector< InterestRate > *self,std::vector< InterestRate >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_InterestRate_Sg__doAdd__SWIG_1(std::vector< InterestRate > *self,jint index,std::vector< InterestRate >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< InterestRate >::value_type std_vector_Sl_InterestRate_Sg__doRemove(std::vector< InterestRate > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          InterestRate const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< InterestRate >::value_type const &std_vector_Sl_InterestRate_Sg__doGet(std::vector< InterestRate > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< InterestRate >::value_type std_vector_Sl_InterestRate_Sg__doSet(std::vector< InterestRate > *self,jint index,std::vector< InterestRate >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          InterestRate const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_InterestRate_Sg__doRemoveRange(std::vector< InterestRate > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

using QuantLib::Rounding;
using QuantLib::UpRounding;
using QuantLib::DownRounding;
using QuantLib::ClosestRounding;
using QuantLib::CeilingTruncation;
using QuantLib::FloorTruncation;


using QuantLib::Currency;
using QuantLib::Money;

SWIGINTERN std::string Currency___str__(Currency *self){
            return self->name();
        }
SWIGINTERN bool Currency___eq__(Currency *self,Currency const &other){
            return (*self) == other;
        }
SWIGINTERN bool Currency___ne__(Currency *self,Currency const &other){
            return (*self) != other;
        }

using QuantLib::Bisection;
using QuantLib::Brent;
using QuantLib::FalsePosition;
using QuantLib::Newton;
using QuantLib::NewtonSafe;
using QuantLib::Ridder;
using QuantLib::Secant;

SWIGINTERN Real Brent_solve__SWIG_0(Brent *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, step);
        }
SWIGINTERN Real Brent_solve__SWIG_1(Brent *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }
SWIGINTERN Real Bisection_solve__SWIG_0(Bisection *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, step);
        }
SWIGINTERN Real Bisection_solve__SWIG_1(Bisection *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }
SWIGINTERN Real FalsePosition_solve__SWIG_0(FalsePosition *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, step);
        }
SWIGINTERN Real FalsePosition_solve__SWIG_1(FalsePosition *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }
SWIGINTERN Real Ridder_solve__SWIG_0(Ridder *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, step);
        }
SWIGINTERN Real Ridder_solve__SWIG_1(Ridder *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }
SWIGINTERN Real Secant_solve__SWIG_0(Secant *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, step);
        }
SWIGINTERN Real Secant_solve__SWIG_1(Secant *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }

class NFunctAndDer {
  public:
    NFunctAndDer(const UnaryFunction& function,
                 const UnaryFunction& derivative)
    : f_(function), d_(derivative) {}
           
    Real operator()(Real x) const { return f_(x); }
    Real derivative(Real x) const { return d_(x); }
  private:          
    UnaryFunction f_, d_;
};

SWIGINTERN Real Newton_solve__SWIG_0(Newton *self,UnaryFunctionDelegate *function,UnaryFunctionDelegate *derivative,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function), d(derivative);            
            return self->solve(NFunctAndDer(f, d), xAccuracy, guess, step);
        }
SWIGINTERN Real Newton_solve__SWIG_1(Newton *self,UnaryFunctionDelegate *function,UnaryFunctionDelegate *derivative,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function), d(derivative);            
            return self->solve(NFunctAndDer(f, d), xAccuracy, guess, xMin, xMax);
        }
SWIGINTERN Real NewtonSafe_solve__SWIG_0(NewtonSafe *self,UnaryFunctionDelegate *function,UnaryFunctionDelegate *derivative,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function), d(derivative);            
            return self->solve(NFunctAndDer(f, d), xAccuracy, guess, step);
        }
SWIGINTERN Real NewtonSafe_solve__SWIG_1(NewtonSafe *self,UnaryFunctionDelegate *function,UnaryFunctionDelegate *derivative,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function), d(derivative);            
            return self->solve(NFunctAndDer(f, d), xAccuracy, guess, xMin, xMax);
        }

using QuantLib::Constraint;
using QuantLib::BoundaryConstraint;
using QuantLib::NoConstraint;
using QuantLib::PositiveConstraint;
using QuantLib::CompositeConstraint;
using QuantLib::NonhomogeneousBoundaryConstraint;


using QuantLib::EndCriteria;


using QuantLib::OptimizationMethod;
using QuantLib::ConjugateGradient;
using QuantLib::Simplex;
using QuantLib::SteepestDescent;
using QuantLib::BFGS;
using QuantLib::LevenbergMarquardt;
using QuantLib::DifferentialEvolution;
using QuantLib::SamplerGaussian;
using QuantLib::SamplerLogNormal;
using QuantLib::SamplerMirrorGaussian;
using QuantLib::ProbabilityBoltzmannDownhill;
using QuantLib::TemperatureExponential;
using QuantLib::ReannealingTrivial;
using QuantLib::GaussianSimulatedAnnealing;
using QuantLib::MirrorGaussianSimulatedAnnealing;
using QuantLib::LogNormalSimulatedAnnealing;



using QuantLib::Problem;


    class Optimizer {};

SWIGINTERN Array Optimizer_solve(Optimizer *self,CostFunctionDelegate *function,Constraint &c,OptimizationMethod &m,EndCriteria &e,Array &iv){
        JavaCostFunction f(function);
        Problem p(f,c,iv);
        m.minimize(p, e);
        return p.currentValue();
    }

// safe versions which copy their arguments
template <class I>
class SafeInterpolation {
  public:
    SafeInterpolation(const Array& x, const Array& y)
    : x_(x), y_(y), f_(x_.begin(),x_.end(),y_.begin()) {}
    Real operator()(Real x, bool allowExtrapolation=false) {
        return f_(x, allowExtrapolation);
    }
    Array x_, y_;
    I f_;
};


typedef SafeInterpolation<QuantLib::LinearInterpolation> SafeLinearInterpolation;


typedef SafeInterpolation<QuantLib::LogLinearInterpolation> SafeLogLinearInterpolation;


typedef SafeInterpolation<QuantLib::BackwardFlatInterpolation> SafeBackwardFlatInterpolation;


typedef SafeInterpolation<QuantLib::ForwardFlatInterpolation> SafeForwardFlatInterpolation;


typedef SafeInterpolation<QuantLib::CubicNaturalSpline> SafeCubicNaturalSpline;

SWIGINTERN Real SafeCubicNaturalSpline_derivative__SWIG_0(SafeCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeCubicNaturalSpline_secondDerivative__SWIG_0(SafeCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeCubicNaturalSpline_primitive__SWIG_0(SafeCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::LogCubicNaturalSpline> SafeLogCubicNaturalSpline;

SWIGINTERN Real SafeLogCubicNaturalSpline_derivative__SWIG_0(SafeLogCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeLogCubicNaturalSpline_secondDerivative__SWIG_0(SafeLogCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeLogCubicNaturalSpline_primitive__SWIG_0(SafeLogCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::MonotonicCubicNaturalSpline> SafeMonotonicCubicNaturalSpline;

SWIGINTERN Real SafeMonotonicCubicNaturalSpline_derivative__SWIG_0(SafeMonotonicCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicCubicNaturalSpline_secondDerivative__SWIG_0(SafeMonotonicCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicCubicNaturalSpline_primitive__SWIG_0(SafeMonotonicCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::MonotonicLogCubicNaturalSpline> SafeMonotonicLogCubicNaturalSpline;

SWIGINTERN Real SafeMonotonicLogCubicNaturalSpline_derivative__SWIG_0(SafeMonotonicLogCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicLogCubicNaturalSpline_secondDerivative__SWIG_0(SafeMonotonicLogCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicLogCubicNaturalSpline_primitive__SWIG_0(SafeMonotonicLogCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::KrugerCubic> SafeKrugerCubic;

SWIGINTERN Real SafeKrugerCubic_derivative__SWIG_0(SafeKrugerCubic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeKrugerCubic_secondDerivative__SWIG_0(SafeKrugerCubic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeKrugerCubic_primitive__SWIG_0(SafeKrugerCubic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::KrugerLogCubic> SafeKrugerLogCubic;

SWIGINTERN Real SafeKrugerLogCubic_derivative__SWIG_0(SafeKrugerLogCubic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeKrugerLogCubic_secondDerivative__SWIG_0(SafeKrugerLogCubic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeKrugerLogCubic_primitive__SWIG_0(SafeKrugerLogCubic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::FritschButlandCubic> SafeFritschButlandCubic;

SWIGINTERN Real SafeFritschButlandCubic_derivative__SWIG_0(SafeFritschButlandCubic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeFritschButlandCubic_secondDerivative__SWIG_0(SafeFritschButlandCubic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeFritschButlandCubic_primitive__SWIG_0(SafeFritschButlandCubic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::FritschButlandLogCubic> SafeFritschButlandLogCubic;

SWIGINTERN Real SafeFritschButlandLogCubic_derivative__SWIG_0(SafeFritschButlandLogCubic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeFritschButlandLogCubic_secondDerivative__SWIG_0(SafeFritschButlandLogCubic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeFritschButlandLogCubic_primitive__SWIG_0(SafeFritschButlandLogCubic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::Parabolic> SafeParabolic;

SWIGINTERN Real SafeParabolic_derivative__SWIG_0(SafeParabolic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeParabolic_secondDerivative__SWIG_0(SafeParabolic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeParabolic_primitive__SWIG_0(SafeParabolic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::LogParabolic> SafeLogParabolic;

SWIGINTERN Real SafeLogParabolic_derivative__SWIG_0(SafeLogParabolic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeLogParabolic_secondDerivative__SWIG_0(SafeLogParabolic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeLogParabolic_primitive__SWIG_0(SafeLogParabolic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::MonotonicParabolic> SafeMonotonicParabolic;

SWIGINTERN Real SafeMonotonicParabolic_derivative__SWIG_0(SafeMonotonicParabolic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicParabolic_secondDerivative__SWIG_0(SafeMonotonicParabolic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicParabolic_primitive__SWIG_0(SafeMonotonicParabolic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::MonotonicLogParabolic> SafeMonotonicLogParabolic;

SWIGINTERN Real SafeMonotonicLogParabolic_derivative__SWIG_0(SafeMonotonicLogParabolic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicLogParabolic_secondDerivative__SWIG_0(SafeMonotonicLogParabolic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicLogParabolic_primitive__SWIG_0(SafeMonotonicLogParabolic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

// safe versions which copy their arguments
template <class I>
class SafeInterpolation2D {
  public:
    SafeInterpolation2D(const Array& x, const Array& y, const Matrix& m)
    : x_(x), y_(y), m_(m), f_(x_.begin(),x_.end(),y_.begin(),y_.end(),m_) {}
    Real operator()(Real x, Real y, bool allowExtrapolation=false) {
        return f_(x,y, allowExtrapolation);
    }
  protected:
    Array x_, y_;
    Matrix m_;
    I f_;
};


typedef SafeInterpolation2D<QuantLib::BilinearInterpolation> SafeBilinearInterpolation;


typedef SafeInterpolation2D<QuantLib::BicubicSpline> SafeBicubicSpline;


using QuantLib::BackwardFlat;
using QuantLib::ForwardFlat;
using QuantLib::Linear;
using QuantLib::LogLinear;
using QuantLib::Cubic;
using QuantLib::Bicubic;
using QuantLib::ConvexMonotone;

class MonotonicCubic : public Cubic {
  public:
    MonotonicCubic()
    : Cubic(QuantLib::CubicInterpolation::Spline, true,
            QuantLib::CubicInterpolation::SecondDerivative, 0.0,
            QuantLib::CubicInterpolation::SecondDerivative, 0.0) {}
};

class SplineCubic : public Cubic {
  public:
    SplineCubic()
    : Cubic(QuantLib::CubicInterpolation::Spline, false,
            QuantLib::CubicInterpolation::SecondDerivative, 0.0,
            QuantLib::CubicInterpolation::SecondDerivative, 0.0) {}
};

class Kruger : public Cubic {
  public:
    Kruger()
    : Cubic(QuantLib::CubicInterpolation::Kruger) {}
};

class DefaultLogCubic : public QuantLib::LogCubic {
  public:
    DefaultLogCubic()
    : QuantLib::LogCubic(QuantLib::CubicInterpolation::Kruger) {}
};

class MonotonicLogCubic : public QuantLib::LogCubic {
  public:
    MonotonicLogCubic()
    : QuantLib::LogCubic(QuantLib::CubicInterpolation::Spline, true,
                         QuantLib::CubicInterpolation::SecondDerivative, 0.0,
                         QuantLib::CubicInterpolation::SecondDerivative, 0.0) {}
};

class KrugerLog : public QuantLib::LogCubic {
  public:
    KrugerLog()
    : QuantLib::LogCubic(QuantLib::CubicInterpolation::Kruger, false,
                         QuantLib::CubicInterpolation::SecondDerivative, 0.0,
                         QuantLib::CubicInterpolation::SecondDerivative, 0.0) {}
};

class SplineLogCubic : public QuantLib::LogCubic {
  public:
    SplineLogCubic()
    : QuantLib::LogCubic(QuantLib::CubicInterpolation::Spline, false,
                         QuantLib::CubicInterpolation::SecondDerivative, 0.0,
                         QuantLib::CubicInterpolation::SecondDerivative, 0.0) {}
};


// safe version which copies its arguments
class SafeSABRInterpolation {
  public:
    SafeSABRInterpolation(const Array& x, const Array& y,
                          Time t,
                          Real forward,
                          Real alpha,
                          Real beta,
                          Real nu,
                          Real rho,
                          bool alphaIsFixed,
                          bool betaIsFixed,
                          bool nuIsFixed,
                          bool rhoIsFixed,
                          bool vegaWeighted = true,
                          const ext::shared_ptr<EndCriteria>& endCriteria
                                  = ext::shared_ptr<EndCriteria>(),
                          const ext::shared_ptr<OptimizationMethod>& optMethod
                                  = ext::shared_ptr<OptimizationMethod>(),
                          const Real errorAccept=0.0020,
                          const bool useMaxError=false,
                          const Size maxGuesses=50,
			  const Real shift = 0.0)
    : x_(x), y_(y), forward_(forward),
      f_(x_.begin(),x_.end(),y_.begin(),
         t, forward_, alpha, beta, nu, rho,
         alphaIsFixed, betaIsFixed,
         nuIsFixed, rhoIsFixed,
         vegaWeighted, endCriteria, optMethod,
         errorAccept, useMaxError, maxGuesses, shift) {f_.update();}
    Real operator()(Real x, bool allowExtrapolation=false) const {
        return f_(x, allowExtrapolation);
    }
    Real alpha() const {return f_.alpha();}
    Real beta() const {return f_.beta();}
    Real rho() const {return f_.rho();}
    Real nu() const {return f_.nu();}
    
  private:
    Array x_, y_;  // passed via iterators, need to stay alive
    Real forward_; // passed by reference, same
    QuantLib::SABRInterpolation f_;
};


using QuantLib::RichardsonExtrapolation;

SWIGINTERN RichardsonExtrapolation *new_RichardsonExtrapolation__SWIG_0(UnaryFunctionDelegate *fct,Real delta_h,Real n=Null< Real >()){
        
            UnaryFunction f(fct);
            return new RichardsonExtrapolation(f, delta_h, n); 
        }

class SafeConvexMonotoneInterpolation {
  public:
    SafeConvexMonotoneInterpolation(const Array& x, const Array& y,
                                    Real quadraticity = 0.3,
                                    Real monotonicity = 0.7,
                                    bool forcePositive = true)
    : x_(x), y_(y), f_(x_.begin(), x_.end(), y_.begin(),
                       quadraticity, monotonicity, forcePositive) {}
    Real operator()(Real x, bool allowExtrapolation=false) {
        return f_(x, allowExtrapolation);
    }
    Array x_, y_;
    QuantLib::ConvexMonotoneInterpolation<Array::const_iterator, Array::const_iterator> f_;
};


using QuantLib::TermStructure;


using QuantLib::YieldTermStructure;

SWIGINTERN ext::shared_ptr< Observable > Handle_Sl_YieldTermStructure_Sg__asObservable(Handle< YieldTermStructure > *self){
        return ext::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_YieldTermStructure_Sg__reset(RelinkableHandle< YieldTermStructure > *self){
            self->linkTo(ext::shared_ptr<YieldTermStructure>());
        }

using QuantLib::ImpliedTermStructure;


using QuantLib::ZeroSpreadedTermStructure;
using QuantLib::ForwardSpreadedTermStructure;


using QuantLib::InterpolatedPiecewiseZeroSpreadedTermStructure;


using QuantLib::FlatForward;


using QuantLib::UltimateForwardTermStructure;


using QuantLib::QuantoTermStructure;


using QuantLib::TimeSeries;
using QuantLib::IntervalPrice;

SWIGINTERN TimeSeries< Real > *new_TimeSeries_Sl_Real_Sg___SWIG_1(std::vector< Date > const &d,std::vector< double > const &v){
            return new TimeSeries<double>(d.begin(), d.end(), v.begin());
        }
SWIGINTERN TimeSeries< IntervalPrice > *new_TimeSeries_Sl_IntervalPrice_Sg___SWIG_1(std::vector< Date > const &d,std::vector< IntervalPrice > const &v){
            return new TimeSeries<IntervalPrice>(d.begin(), d.end(), v.begin());
        }
SWIGINTERN std::vector< IntervalPrice > *new_std_vector_Sl_IntervalPrice_Sg___SWIG_2(jint count,IntervalPrice const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< IntervalPrice >(static_cast<std::vector< IntervalPrice >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_IntervalPrice_Sg__doSize(std::vector< IntervalPrice > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__doAdd__SWIG_0(std::vector< IntervalPrice > *self,std::vector< IntervalPrice >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__doAdd__SWIG_1(std::vector< IntervalPrice > *self,jint index,std::vector< IntervalPrice >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< IntervalPrice >::value_type std_vector_Sl_IntervalPrice_Sg__doRemove(std::vector< IntervalPrice > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          IntervalPrice const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< IntervalPrice >::value_type const &std_vector_Sl_IntervalPrice_Sg__doGet(std::vector< IntervalPrice > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< IntervalPrice >::value_type std_vector_Sl_IntervalPrice_Sg__doSet(std::vector< IntervalPrice > *self,jint index,std::vector< IntervalPrice >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          IntervalPrice const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__doRemoveRange(std::vector< IntervalPrice > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

using QuantLib::IndexManager;


using QuantLib::Index;

SWIGINTERN void Index_addFixings__SWIG_0(Index *self,std::vector< Date > const &fixingDates,std::vector< Rate > const &fixings,bool forceOverwrite=false){
            self->addFixings(fixingDates.begin(),fixingDates.end(),
                             fixings.begin(),
                             forceOverwrite);
        }
SWIGINTERN std::string Index___str__(Index *self){
            return self->name()+" index";
        }

using QuantLib::InterestRateIndex;


using QuantLib::IborIndex;
using QuantLib::OvernightIndex;


    ext::shared_ptr<IborIndex> as_iborindex(
                          const ext::shared_ptr<InterestRateIndex>& index) {
        return ext::dynamic_pointer_cast<IborIndex>(index);
    }

SWIGINTERN ext::shared_ptr< OvernightIndex > OvernightIndex_clone(OvernightIndex const *self,Handle< YieldTermStructure > const &h){
            return ext::dynamic_pointer_cast<OvernightIndex>(self->clone(h));
        }

using QuantLib::Libor;
using QuantLib::DailyTenorLibor;


using QuantLib::SwapIndex;

SWIGINTERN std::vector< ext::shared_ptr< SwapIndex > > *new_std_vector_Sl_ext_shared_ptr_Sl_SwapIndex_Sg__Sg___SWIG_2(jint count,ext::shared_ptr< SwapIndex > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< SwapIndex > >(static_cast<std::vector< ext::shared_ptr< SwapIndex > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_SwapIndex_Sg__Sg__doSize(std::vector< ext::shared_ptr< SwapIndex > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_SwapIndex_Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< SwapIndex > > *self,std::vector< ext::shared_ptr< SwapIndex > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_SwapIndex_Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< SwapIndex > > *self,jint index,std::vector< ext::shared_ptr< SwapIndex > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< SwapIndex > >::value_type std_vector_Sl_ext_shared_ptr_Sl_SwapIndex_Sg__Sg__doRemove(std::vector< ext::shared_ptr< SwapIndex > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< SwapIndex > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< SwapIndex > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_SwapIndex_Sg__Sg__doGet(std::vector< ext::shared_ptr< SwapIndex > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< SwapIndex > >::value_type std_vector_Sl_ext_shared_ptr_Sl_SwapIndex_Sg__Sg__doSet(std::vector< ext::shared_ptr< SwapIndex > > *self,jint index,std::vector< ext::shared_ptr< SwapIndex > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< SwapIndex > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_SwapIndex_Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< SwapIndex > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

    ext::shared_ptr<SwapIndex> as_swap_index(
                          const ext::shared_ptr<InterestRateIndex>& index) {
        return ext::dynamic_pointer_cast<SwapIndex>(index);
    }


using QuantLib::SwapSpreadIndex;


using QuantLib::AUDLibor;


using QuantLib::CADLibor;


using QuantLib::CADLiborON;


using QuantLib::Cdor;


using QuantLib::CHFLibor;


using QuantLib::DKKLibor;


using QuantLib::Bbsw;


using QuantLib::Bbsw1M;


using QuantLib::Bbsw2M;


using QuantLib::Bbsw3M;


using QuantLib::Bbsw4M;


using QuantLib::Bbsw5M;


using QuantLib::Bbsw6M;


using QuantLib::Bkbm;


using QuantLib::Bkbm1M;


using QuantLib::Bkbm2M;


using QuantLib::Bkbm3M;


using QuantLib::Bkbm4M;


using QuantLib::Bkbm5M;


using QuantLib::Bkbm6M;


using QuantLib::Euribor;


using QuantLib::EuriborSW;


using QuantLib::Euribor2W;


using QuantLib::Euribor3W;


using QuantLib::Euribor1M;


using QuantLib::Euribor2M;


using QuantLib::Euribor3M;


using QuantLib::Euribor4M;


using QuantLib::Euribor5M;


using QuantLib::Euribor6M;


using QuantLib::Euribor7M;


using QuantLib::Euribor8M;


using QuantLib::Euribor9M;


using QuantLib::Euribor10M;


using QuantLib::Euribor11M;


using QuantLib::Euribor1Y;


using QuantLib::Euribor365;


using QuantLib::Euribor365_SW;


using QuantLib::Euribor365_2W;


using QuantLib::Euribor365_3W;


using QuantLib::Euribor365_1M;


using QuantLib::Euribor365_2M;


using QuantLib::Euribor365_3M;


using QuantLib::Euribor365_4M;


using QuantLib::Euribor365_5M;


using QuantLib::Euribor365_6M;


using QuantLib::Euribor365_7M;


using QuantLib::Euribor365_8M;


using QuantLib::Euribor365_9M;


using QuantLib::Euribor365_10M;


using QuantLib::Euribor365_11M;


using QuantLib::Euribor365_1Y;


using QuantLib::EURLibor;


using QuantLib::EURLiborSW;


using QuantLib::EURLibor2W;


using QuantLib::EURLibor1M;


using QuantLib::EURLibor2M;


using QuantLib::EURLibor3M;


using QuantLib::EURLibor4M;


using QuantLib::EURLibor5M;


using QuantLib::EURLibor6M;


using QuantLib::EURLibor7M;


using QuantLib::EURLibor8M;


using QuantLib::EURLibor9M;


using QuantLib::EURLibor10M;


using QuantLib::EURLibor11M;


using QuantLib::EURLibor1Y;


using QuantLib::GBPLibor;


using QuantLib::GBPLiborON;


using QuantLib::Jibar;


using QuantLib::JPYLibor;


using QuantLib::Mosprime;


using QuantLib::NZDLibor;


using QuantLib::Pribor;


using QuantLib::Robor;


using QuantLib::SEKLibor;


using QuantLib::Shibor;


using QuantLib::Tibor;


using QuantLib::THBFIX;


using QuantLib::TRLibor;


using QuantLib::USDLibor;


using QuantLib::USDLiborON;


using QuantLib::Wibor;


using QuantLib::Zibor;


using QuantLib::Aonia;


using QuantLib::Eonia;


using QuantLib::Sonia;


using QuantLib::FedFunds;


using QuantLib::Nzocr;


using QuantLib::Sofr;


using QuantLib::Estr;


using QuantLib::EuriborSwapIsdaFixA;


using QuantLib::EuriborSwapIsdaFixB;


using QuantLib::EuriborSwapIfrFix;


using QuantLib::EurLiborSwapIsdaFixA;


using QuantLib::EurLiborSwapIsdaFixB;


using QuantLib::EurLiborSwapIfrFix;


using QuantLib::ChfLiborSwapIsdaFix;


using QuantLib::GbpLiborSwapIsdaFix;


using QuantLib::JpyLiborSwapIsdaFixAm;


using QuantLib::JpyLiborSwapIsdaFixPm;


using QuantLib::UsdLiborSwapIsdaFixAm;


using QuantLib::UsdLiborSwapIsdaFixPm;


using QuantLib::Bibor;


using QuantLib::BiborSW;


using QuantLib::Bibor1M;


using QuantLib::Bibor2M;


using QuantLib::Bibor3M;


using QuantLib::Bibor6M;


using QuantLib::Bibor9M;


using QuantLib::Bibor1Y;


using QuantLib::VolatilityType;
using QuantLib::ShiftedLognormal;
using QuantLib::Normal;


using QuantLib::VolatilityTermStructure;
using QuantLib::BlackVolTermStructure;
using QuantLib::LocalVolTermStructure;
using QuantLib::OptionletVolatilityStructure;
using QuantLib::SwaptionVolatilityStructure;
using QuantLib::YoYOptionletVolatilitySurface;

SWIGINTERN ext::shared_ptr< Observable > Handle_Sl_BlackVolTermStructure_Sg__asObservable(Handle< BlackVolTermStructure > *self){
        return ext::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_BlackVolTermStructure_Sg__reset(RelinkableHandle< BlackVolTermStructure > *self){
            self->linkTo(ext::shared_ptr<BlackVolTermStructure>());
        }
SWIGINTERN ext::shared_ptr< Observable > Handle_Sl_LocalVolTermStructure_Sg__asObservable(Handle< LocalVolTermStructure > *self){
        return ext::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_LocalVolTermStructure_Sg__reset(RelinkableHandle< LocalVolTermStructure > *self){
            self->linkTo(ext::shared_ptr<LocalVolTermStructure>());
        }
SWIGINTERN ext::shared_ptr< Observable > Handle_Sl_OptionletVolatilityStructure_Sg__asObservable(Handle< OptionletVolatilityStructure > *self){
        return ext::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_OptionletVolatilityStructure_Sg__reset(RelinkableHandle< OptionletVolatilityStructure > *self){
            self->linkTo(ext::shared_ptr<OptionletVolatilityStructure>());
        }
SWIGINTERN ext::shared_ptr< Observable > Handle_Sl_YoYOptionletVolatilitySurface_Sg__asObservable(Handle< YoYOptionletVolatilitySurface > *self){
        return ext::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_YoYOptionletVolatilitySurface_Sg__reset(RelinkableHandle< YoYOptionletVolatilitySurface > *self){
            self->linkTo(ext::shared_ptr<YoYOptionletVolatilitySurface>());
        }

using QuantLib::SmileSection;

SWIGINTERN std::vector< ext::shared_ptr< SmileSection > > *new_std_vector_Sl_ext_shared_ptr_Sl_SmileSection_Sg__Sg___SWIG_2(jint count,ext::shared_ptr< SmileSection > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< SmileSection > >(static_cast<std::vector< ext::shared_ptr< SmileSection > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_SmileSection_Sg__Sg__doSize(std::vector< ext::shared_ptr< SmileSection > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_SmileSection_Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< SmileSection > > *self,std::vector< ext::shared_ptr< SmileSection > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_SmileSection_Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< SmileSection > > *self,jint index,std::vector< ext::shared_ptr< SmileSection > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< SmileSection > >::value_type std_vector_Sl_ext_shared_ptr_Sl_SmileSection_Sg__Sg__doRemove(std::vector< ext::shared_ptr< SmileSection > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< SmileSection > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< SmileSection > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_SmileSection_Sg__Sg__doGet(std::vector< ext::shared_ptr< SmileSection > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< SmileSection > >::value_type std_vector_Sl_ext_shared_ptr_Sl_SmileSection_Sg__Sg__doSet(std::vector< ext::shared_ptr< SmileSection > > *self,jint index,std::vector< ext::shared_ptr< SmileSection > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< SmileSection > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_SmileSection_Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< SmileSection > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

using QuantLib::SwaptionVolatilityStructure;

SWIGINTERN ext::shared_ptr< Observable > Handle_Sl_SwaptionVolatilityStructure_Sg__asObservable(Handle< SwaptionVolatilityStructure > *self){
        return ext::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_SwaptionVolatilityStructure_Sg__reset(RelinkableHandle< SwaptionVolatilityStructure > *self){
            self->linkTo(ext::shared_ptr<SwaptionVolatilityStructure>());
        }

using QuantLib::BlackConstantVol;


using QuantLib::BlackVarianceCurve;


using QuantLib::BlackVarianceSurface;

SWIGINTERN BlackVarianceSurface *new_BlackVarianceSurface__SWIG_0(Date const &referenceDate,Calendar const &cal,std::vector< Date > const &dates,std::vector< Real > const &strikes,Matrix const &blackVols,DayCounter const &dayCounter,BlackVarianceSurface::Extrapolation lower=BlackVarianceSurface::InterpolatorDefaultExtrapolation,BlackVarianceSurface::Extrapolation upper=BlackVarianceSurface::InterpolatorDefaultExtrapolation,std::string const &interpolator=""){
            BlackVarianceSurface* surface =
                new BlackVarianceSurface(referenceDate,cal,
                                         dates,strikes,
                                         blackVols,dayCounter,lower,upper);
            std::string s = boost::to_lower_copy(interpolator);
            if (s == "" || s == "bilinear") {
                surface->setInterpolation<QuantLib::Bilinear>();
            } else if (s == "bicubic") {
                surface->setInterpolation<QuantLib::Bicubic>();
            } else {
                QL_FAIL("Unknown interpolator: " << interpolator);
            }
            return surface;
        }
SWIGINTERN void BlackVarianceSurface_setInterpolation__SWIG_0(BlackVarianceSurface *self,std::string const &interpolator=""){
            std::string s = boost::to_lower_copy(interpolator);
            if (s == "" || s == "bilinear") {
                self->setInterpolation<QuantLib::Bilinear>();
            } else if (s == "bicubic") {
                self->setInterpolation<QuantLib::Bicubic>();
            } else {
                QL_FAIL("Unknown interpolator: " << interpolator);
            }
        }

using QuantLib::LocalConstantVol;


using QuantLib::LocalVolSurface;


using QuantLib::NoExceptLocalVolSurface;


using QuantLib::ConstantOptionletVolatility;


using QuantLib::ConstantSwaptionVolatility;


using QuantLib::SwaptionVolatilityMatrix;
using QuantLib::SwaptionVolatilityDiscrete;

SWIGINTERN SwaptionVolatilityMatrix *new_SwaptionVolatilityMatrix__SWIG_12(Date const &referenceDate,std::vector< Date > const &dates,std::vector< Period > const &lengths,Matrix const &vols,DayCounter const &dayCounter,bool const flatExtrapolation=false,VolatilityType const type=ShiftedLognormal,Matrix const &shifts=Matrix()){
            return new SwaptionVolatilityMatrix(referenceDate, NullCalendar(), Following,
                                                dates, lengths, vols, dayCounter,
                                                flatExtrapolation, type, shifts);
        }
SWIGINTERN std::pair< unsigned int,unsigned int > SwaptionVolatilityMatrix_locate__SWIG_0(SwaptionVolatilityMatrix const *self,Date const &optionDate,Period const &swapTenor){
            auto sizes = self->locate(optionDate, swapTenor);
            return { (unsigned int)sizes.first, (unsigned int)sizes.second };
        }
SWIGINTERN std::pair< unsigned int,unsigned int > SwaptionVolatilityMatrix_locate__SWIG_1(SwaptionVolatilityMatrix const *self,Time optionTime,Time swapLength){
            auto sizes = self->locate(optionTime, swapLength);
            return { (unsigned int)sizes.first, (unsigned int)sizes.second };
        }

using QuantLib::SabrSmileSection;


using QuantLib::SviSmileSection;


using QuantLib::SviInterpolatedSmileSection;


using QuantLib::SwaptionVolatilityCube;
using QuantLib::SwaptionVolCube1;
using QuantLib::SwaptionVolCube2;

SWIGINTERN ext::shared_ptr< SabrSmileSection > SwaptionVolCube1_smileSection__SWIG_0(SwaptionVolCube1 const *self,Time optionTime,Time swapLength,bool extr=false){
            auto base = dynamic_cast<const SwaptionVolatilityStructure*>(self);
            return ext::dynamic_pointer_cast<SabrSmileSection>(base->smileSection(optionTime, swapLength, extr));
        }
SWIGINTERN ext::shared_ptr< SabrSmileSection > SwaptionVolCube1_smileSection__SWIG_2(SwaptionVolCube1 const *self,Period const &optionTenor,Period const &swapTenor,bool extr=false){
            auto base = dynamic_cast<const SwaptionVolatilityStructure*>(self);
            return ext::dynamic_pointer_cast<SabrSmileSection>(base->smileSection(optionTenor, swapTenor, extr));
        }

using QuantLib::ConstantYoYOptionletVolatility;


using QuantLib::FlatSmileSection;


using QuantLib::InterpolatedSmileSection;
using QuantLib::Actual365Fixed;


using QuantLib::KahaleSmileSection;


using QuantLib::ZabrShortMaturityLognormal;
using QuantLib::ZabrShortMaturityNormal;
using QuantLib::ZabrLocalVolatility;
using QuantLib::ZabrFullFd;
using QuantLib::ZabrSmileSection;
using QuantLib::ZabrInterpolatedSmileSection;
using QuantLib::NoArbSabrSmileSection;
using QuantLib::NoArbSabrInterpolatedSmileSection;
using QuantLib::Option;


using QuantLib::sabrVolatility;
using QuantLib::shiftedSabrVolatility;
using QuantLib::sabrFlochKennedyVolatility;


using QuantLib::AndreasenHugeVolatilityInterpl;
using QuantLib::AndreasenHugeVolatilityAdapter;
using QuantLib::AndreasenHugeLocalVolAdapter;
using QuantLib::HestonBlackVolSurface;

SWIGINTERN double ext_tuple_Sl_Real_Sc_Real_Sc_Real_Sg__first(ext::tuple< Real,Real,Real > const *self){
        return ext::get<0>(*self);
      }
SWIGINTERN double ext_tuple_Sl_Real_Sc_Real_Sc_Real_Sg__second(ext::tuple< Real,Real,Real > const *self){
        return ext::get<1>(*self);
      }
SWIGINTERN double ext_tuple_Sl_Real_Sc_Real_Sc_Real_Sg__third(ext::tuple< Real,Real,Real > const *self){
        return ext::get<2>(*self);
      }

using QuantLib::CmsMarket;


using QuantLib::CmsMarketCalibration;


using QuantLib::StochasticProcess;

SWIGINTERN std::vector< ext::shared_ptr< StochasticProcess > > *new_std_vector_Sl_ext_shared_ptr_Sl_StochasticProcess_Sg__Sg___SWIG_2(jint count,ext::shared_ptr< StochasticProcess > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< StochasticProcess > >(static_cast<std::vector< ext::shared_ptr< StochasticProcess > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_StochasticProcess_Sg__Sg__doSize(std::vector< ext::shared_ptr< StochasticProcess > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_StochasticProcess_Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< StochasticProcess > > *self,std::vector< ext::shared_ptr< StochasticProcess > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_StochasticProcess_Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< StochasticProcess > > *self,jint index,std::vector< ext::shared_ptr< StochasticProcess > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< StochasticProcess > >::value_type std_vector_Sl_ext_shared_ptr_Sl_StochasticProcess_Sg__Sg__doRemove(std::vector< ext::shared_ptr< StochasticProcess > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< StochasticProcess > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< StochasticProcess > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_StochasticProcess_Sg__Sg__doGet(std::vector< ext::shared_ptr< StochasticProcess > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< StochasticProcess > >::value_type std_vector_Sl_ext_shared_ptr_Sl_StochasticProcess_Sg__Sg__doSet(std::vector< ext::shared_ptr< StochasticProcess > > *self,jint index,std::vector< ext::shared_ptr< StochasticProcess > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< StochasticProcess > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_StochasticProcess_Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< StochasticProcess > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

using QuantLib::StochasticProcess1D;

SWIGINTERN std::vector< ext::shared_ptr< StochasticProcess1D > > *new_std_vector_Sl_ext_shared_ptr_Sl_StochasticProcess1D_Sg__Sg___SWIG_2(jint count,ext::shared_ptr< StochasticProcess1D > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< StochasticProcess1D > >(static_cast<std::vector< ext::shared_ptr< StochasticProcess1D > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__doSize(std::vector< ext::shared_ptr< StochasticProcess1D > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< StochasticProcess1D > > *self,std::vector< ext::shared_ptr< StochasticProcess1D > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< StochasticProcess1D > > *self,jint index,std::vector< ext::shared_ptr< StochasticProcess1D > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< StochasticProcess1D > >::value_type std_vector_Sl_ext_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__doRemove(std::vector< ext::shared_ptr< StochasticProcess1D > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< StochasticProcess1D > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< StochasticProcess1D > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__doGet(std::vector< ext::shared_ptr< StochasticProcess1D > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< StochasticProcess1D > >::value_type std_vector_Sl_ext_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__doSet(std::vector< ext::shared_ptr< StochasticProcess1D > > *self,jint index,std::vector< ext::shared_ptr< StochasticProcess1D > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< StochasticProcess1D > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< StochasticProcess1D > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

using QuantLib::GeneralizedBlackScholesProcess;


using QuantLib::BlackScholesProcess;


using QuantLib::BlackScholesMertonProcess;


using QuantLib::BlackProcess;


using QuantLib::GarmanKohlagenProcess;


using QuantLib::Merton76Process;


using QuantLib::StochasticProcessArray;


using QuantLib::GeometricBrownianMotionProcess;


using QuantLib::VarianceGammaProcess;


using QuantLib::HestonProcess;


using QuantLib::BatesProcess;


using QuantLib::HullWhiteProcess;


using QuantLib::HullWhiteForwardProcess;


using QuantLib::G2Process;


using QuantLib::G2ForwardProcess;


using QuantLib::GsrProcess;


    const ext::shared_ptr<GsrProcess> as_gsr_process(
                           const ext::shared_ptr<StochasticProcess>& proc) {
        return ext::dynamic_pointer_cast<GsrProcess>(proc);
    }


using QuantLib::OrnsteinUhlenbeckProcess;


using QuantLib::KlugeExtOUProcess;
using QuantLib::ExtendedOrnsteinUhlenbeckProcess;
using QuantLib::ExtOUWithJumpsProcess;

SWIGINTERN ExtendedOrnsteinUhlenbeckProcess *new_ExtendedOrnsteinUhlenbeckProcess__SWIG_3(Real speed,Volatility sigma,Real x0,UnaryFunctionDelegate *function,Real intEps=1e-4){
            
            const UnaryFunction f(function);
            return new ExtendedOrnsteinUhlenbeckProcess(
            	    speed, sigma, x0, f, 
            	    ExtendedOrnsteinUhlenbeckProcess::MidPoint, intEps);
        }

using QuantLib::GJRGARCHProcess;


using QuantLib::PricingEngine;


using QuantLib::Instrument;

SWIGINTERN std::vector< ext::shared_ptr< Instrument > > *new_std_vector_Sl_ext_shared_ptr_Sl_Instrument_Sg__Sg___SWIG_2(jint count,ext::shared_ptr< Instrument > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< Instrument > >(static_cast<std::vector< ext::shared_ptr< Instrument > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_Instrument_Sg__Sg__doSize(std::vector< ext::shared_ptr< Instrument > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_Instrument_Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< Instrument > > *self,std::vector< ext::shared_ptr< Instrument > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_Instrument_Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< Instrument > > *self,jint index,std::vector< ext::shared_ptr< Instrument > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< Instrument > >::value_type std_vector_Sl_ext_shared_ptr_Sl_Instrument_Sg__Sg__doRemove(std::vector< ext::shared_ptr< Instrument > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< Instrument > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< Instrument > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_Instrument_Sg__Sg__doGet(std::vector< ext::shared_ptr< Instrument > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< Instrument > >::value_type std_vector_Sl_ext_shared_ptr_Sl_Instrument_Sg__Sg__doSet(std::vector< ext::shared_ptr< Instrument > > *self,jint index,std::vector< ext::shared_ptr< Instrument > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< Instrument > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_Instrument_Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< Instrument > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

using QuantLib::Stock;


using QuantLib::CompositeInstrument;


using QuantLib::Schedule;
using QuantLib::DateGeneration;
using QuantLib::MakeSchedule;

SWIGINTERN Schedule MakeSchedule_schedule(MakeSchedule *self){
        return (Schedule)(* self);
      }

using QuantLib::CashFlow;
using QuantLib::Leg;

SWIGINTERN std::vector< ext::shared_ptr< CashFlow > > *new_std_vector_Sl_ext_shared_ptr_Sl_CashFlow_Sg__Sg___SWIG_2(jint count,ext::shared_ptr< CashFlow > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< CashFlow > >(static_cast<std::vector< ext::shared_ptr< CashFlow > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_CashFlow_Sg__Sg__doSize(std::vector< ext::shared_ptr< CashFlow > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_CashFlow_Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< CashFlow > > *self,std::vector< ext::shared_ptr< CashFlow > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_CashFlow_Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< CashFlow > > *self,jint index,std::vector< ext::shared_ptr< CashFlow > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< CashFlow > >::value_type std_vector_Sl_ext_shared_ptr_Sl_CashFlow_Sg__Sg__doRemove(std::vector< ext::shared_ptr< CashFlow > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< CashFlow > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< CashFlow > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_CashFlow_Sg__Sg__doGet(std::vector< ext::shared_ptr< CashFlow > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< CashFlow > >::value_type std_vector_Sl_ext_shared_ptr_Sl_CashFlow_Sg__Sg__doSet(std::vector< ext::shared_ptr< CashFlow > > *self,jint index,std::vector< ext::shared_ptr< CashFlow > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< CashFlow > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_CashFlow_Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< CashFlow > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< Leg > *new_std_vector_Sl_Leg_Sg___SWIG_2(jint count,std::vector< ext::shared_ptr< CashFlow > > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::vector< ext::shared_ptr< CashFlow > > >(static_cast<std::vector< std::vector< ext::shared_ptr< CashFlow > > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_Leg_Sg__doSize(std::vector< Leg > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_Leg_Sg__doAdd__SWIG_0(std::vector< Leg > *self,std::vector< std::vector< ext::shared_ptr< CashFlow > > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_Leg_Sg__doAdd__SWIG_1(std::vector< Leg > *self,jint index,std::vector< std::vector< ext::shared_ptr< CashFlow > > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::vector< ext::shared_ptr< CashFlow > > >::value_type std_vector_Sl_Leg_Sg__doRemove(std::vector< Leg > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::vector< ext::shared_ptr< CashFlow > > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::vector< ext::shared_ptr< CashFlow > > >::value_type const &std_vector_Sl_Leg_Sg__doGet(std::vector< Leg > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::vector< ext::shared_ptr< CashFlow > > >::value_type std_vector_Sl_Leg_Sg__doSet(std::vector< Leg > *self,jint index,std::vector< std::vector< ext::shared_ptr< CashFlow > > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::vector< ext::shared_ptr< CashFlow > > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_Leg_Sg__doRemoveRange(std::vector< Leg > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

using QuantLib::SimpleCashFlow;
using QuantLib::IndexedCashFlow;
using QuantLib::Redemption;
using QuantLib::AmortizingPayment;
using QuantLib::Coupon;
using QuantLib::FixedRateCoupon;
using QuantLib::FloatingRateCoupon;
using QuantLib::RateAveraging;
using QuantLib::OvernightIndexedCoupon;


    ext::shared_ptr<IndexedCashFlow> as_indexed_cashflow(const ext::shared_ptr<CashFlow>& cf) {
        return ext::dynamic_pointer_cast<IndexedCashFlow>(cf);
    }


    ext::shared_ptr<Coupon> as_coupon(const ext::shared_ptr<CashFlow>& cf) {
        return ext::dynamic_pointer_cast<Coupon>(cf);
    }


    ext::shared_ptr<FixedRateCoupon> as_fixed_rate_coupon(
                                      const ext::shared_ptr<CashFlow>& cf) {
        return ext::dynamic_pointer_cast<FixedRateCoupon>(cf);
    }


using QuantLib::FloatingRateCouponPricer;


    ext::shared_ptr<FloatingRateCoupon> as_floating_rate_coupon(
                                      const ext::shared_ptr<CashFlow>& cf) {
        return ext::dynamic_pointer_cast<FloatingRateCoupon>(cf);
    }


    ext::shared_ptr<OvernightIndexedCoupon> as_overnight_indexed_coupon(
                                      const ext::shared_ptr<CashFlow>& cf) {
        return ext::dynamic_pointer_cast<OvernightIndexedCoupon>(cf);
    }


using QuantLib::CappedFlooredCoupon;


using QuantLib::IborCoupon;
using QuantLib::CappedFlooredIborCoupon;
using QuantLib::SubPeriodsCoupon;

SWIGINTERN void IborCoupon_createAtParCoupons(){
            IborCoupon::Settings::instance().createAtParCoupons();
        }
SWIGINTERN void IborCoupon_createIndexedCoupons(){
            IborCoupon::Settings::instance().createIndexedCoupons();
        }
SWIGINTERN bool IborCoupon_usingAtParCoupons(){
            return IborCoupon::Settings::instance().usingAtParCoupons();
        }

    ext::shared_ptr<SubPeriodsCoupon> as_sub_periods_coupon(
      const ext::shared_ptr<CashFlow>& cf) {
        return ext::dynamic_pointer_cast<SubPeriodsCoupon>(cf);
    }


using QuantLib::IborCouponPricer;
using QuantLib::BlackIborCouponPricer;
using QuantLib::SubPeriodsPricer;
using QuantLib::CompoundingRatePricer;
using QuantLib::AveragingRatePricer;


using QuantLib::CmsCoupon;
using QuantLib::CappedFlooredCmsCoupon;
using QuantLib::CmsSpreadCoupon;
using QuantLib::CappedFlooredCmsSpreadCoupon;


using QuantLib::CmsCouponPricer;
using QuantLib::AnalyticHaganPricer;
using QuantLib::NumericHaganPricer;
using QuantLib::GFunctionFactory;
using QuantLib::LinearTsrPricer;
using QuantLib::CmsSpreadCouponPricer;
using QuantLib::LognormalCmsSpreadPricer;

SWIGINTERN std::vector< ext::shared_ptr< CmsCouponPricer > > *new_std_vector_Sl_ext_shared_ptr_Sl_CmsCouponPricer_Sg__Sg___SWIG_2(jint count,ext::shared_ptr< CmsCouponPricer > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< CmsCouponPricer > >(static_cast<std::vector< ext::shared_ptr< CmsCouponPricer > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_CmsCouponPricer_Sg__Sg__doSize(std::vector< ext::shared_ptr< CmsCouponPricer > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_CmsCouponPricer_Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< CmsCouponPricer > > *self,std::vector< ext::shared_ptr< CmsCouponPricer > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_CmsCouponPricer_Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< CmsCouponPricer > > *self,jint index,std::vector< ext::shared_ptr< CmsCouponPricer > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< CmsCouponPricer > >::value_type std_vector_Sl_ext_shared_ptr_Sl_CmsCouponPricer_Sg__Sg__doRemove(std::vector< ext::shared_ptr< CmsCouponPricer > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< CmsCouponPricer > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< CmsCouponPricer > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_CmsCouponPricer_Sg__Sg__doGet(std::vector< ext::shared_ptr< CmsCouponPricer > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< CmsCouponPricer > >::value_type std_vector_Sl_ext_shared_ptr_Sl_CmsCouponPricer_Sg__Sg__doSet(std::vector< ext::shared_ptr< CmsCouponPricer > > *self,jint index,std::vector< ext::shared_ptr< CmsCouponPricer > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< CmsCouponPricer > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_CmsCouponPricer_Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< CmsCouponPricer > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

Leg _FixedRateLeg(const Schedule& schedule,
                  const DayCounter& dayCount,
                  const std::vector<Real>& nominals,
                  const std::vector<Rate>& couponRates,
                  BusinessDayConvention paymentAdjustment = Following,
                  const DayCounter& firstPeriodDayCount = DayCounter(),
                  const Period& exCouponPeriod = Period(),
                  const Calendar& exCouponCalendar = Calendar(),
                  BusinessDayConvention exCouponConvention = Unadjusted,
                  bool exCouponEndOfMonth = false,
                  const Calendar& paymentCalendar = Calendar(),
                  const Natural paymentLag = 0) {
    return QuantLib::FixedRateLeg(schedule)
        .withNotionals(nominals)
        .withCouponRates(couponRates,dayCount)
        .withPaymentAdjustment(paymentAdjustment)
        .withPaymentCalendar(paymentCalendar.empty() ? schedule.calendar() : paymentCalendar)
        .withPaymentLag(paymentLag)
        .withFirstPeriodDayCounter(firstPeriodDayCount)
        .withExCouponPeriod(exCouponPeriod,
                            exCouponCalendar,
                            exCouponConvention,
                            exCouponEndOfMonth);
}


Leg _IborLeg(const std::vector<Real>& nominals,
             const Schedule& schedule,
             const ext::shared_ptr<IborIndex>& index,
             const DayCounter& paymentDayCounter = DayCounter(),
             const BusinessDayConvention paymentConvention = Following,
             const std::vector<Natural>& fixingDays = std::vector<Natural>(),
             const std::vector<Real>& gearings = std::vector<Real>(),
             const std::vector<Spread>& spreads = std::vector<Spread>(),
             const std::vector<Rate>& caps = std::vector<Rate>(),
             const std::vector<Rate>& floors = std::vector<Rate>(),
             bool isInArrears = false,
             const Period& exCouponPeriod = Period(),
             const Calendar& exCouponCalendar = Calendar(),
             BusinessDayConvention exCouponConvention = Unadjusted,
             bool exCouponEndOfMonth = false,
             const Calendar& paymentCalendar = Calendar(),
             const Natural paymentLag = 0,
             boost::optional<bool> withIndexedCoupons = boost::none) {
    return QuantLib::IborLeg(schedule, index)
        .withNotionals(nominals)
        .withPaymentDayCounter(paymentDayCounter)
        .withPaymentAdjustment(paymentConvention)
        .withPaymentCalendar(paymentCalendar.empty() ? schedule.calendar() : paymentCalendar)
        .withPaymentLag(paymentLag)
        .withFixingDays(fixingDays)
        .withGearings(gearings)
        .withSpreads(spreads)
        .withCaps(caps)
        .withFloors(floors)
        .inArrears(isInArrears)
        .withExCouponPeriod(exCouponPeriod,
                            exCouponCalendar,
                            exCouponConvention,
                            exCouponEndOfMonth)
        .withIndexedCoupons(withIndexedCoupons);
}


Leg _OvernightLeg(const std::vector<Real>& nominals,
                  const Schedule& schedule,
                  const ext::shared_ptr<OvernightIndex>& index,
                  const DayCounter& paymentDayCounter = DayCounter(),
                  const BusinessDayConvention paymentConvention = Following,
                  const std::vector<Real>& gearings = std::vector<Real>(),
                  const std::vector<Spread>& spreads = std::vector<Spread>(),
                  bool telescopicValueDates = false,
                  RateAveraging::Type averagingMethod = RateAveraging::Compound,
                  const Calendar& paymentCalendar = Calendar(),
                  const Natural paymentLag = 0) {
    return QuantLib::OvernightLeg(schedule, index)
        .withNotionals(nominals)
        .withPaymentDayCounter(paymentDayCounter)
        .withPaymentAdjustment(paymentConvention)
        .withPaymentCalendar(paymentCalendar.empty() ? schedule.calendar() : paymentCalendar)
        .withPaymentLag(paymentLag)
        .withGearings(gearings)
        .withSpreads(spreads)
        .withTelescopicValueDates(telescopicValueDates)
        .withAveragingMethod(averagingMethod);
}


Leg _CmsLeg(const std::vector<Real>& nominals,
            const Schedule& schedule,
            const ext::shared_ptr<SwapIndex>& index,
            const DayCounter& paymentDayCounter = DayCounter(),
            const BusinessDayConvention paymentConvention = Following,
            const std::vector<Natural>& fixingDays = std::vector<Natural>(),
            const std::vector<Real>& gearings = std::vector<Real>(),
            const std::vector<Spread>& spreads = std::vector<Spread>(),
            const std::vector<Rate>& caps = std::vector<Rate>(),
            const std::vector<Rate>& floors = std::vector<Rate>(),
            bool isInArrears = false,
            const Period& exCouponPeriod = Period(),
            const Calendar& exCouponCalendar = Calendar(),
            const BusinessDayConvention exCouponConvention = Unadjusted,
            bool exCouponEndOfMonth = false) {
    return QuantLib::CmsLeg(schedule, index)
        .withNotionals(nominals)
        .withPaymentDayCounter(paymentDayCounter)
        .withPaymentAdjustment(paymentConvention)
        .withFixingDays(fixingDays)
        .withGearings(gearings)
        .withSpreads(spreads)
        .withCaps(caps)
        .withFloors(floors)
        .withExCouponPeriod(exCouponPeriod, exCouponCalendar,
                            exCouponConvention, exCouponEndOfMonth)
        .inArrears(isInArrears);
}


Leg _CmsZeroLeg(const std::vector<Real>& nominals,
                const Schedule& schedule,
                const ext::shared_ptr<SwapIndex>& index,
                const DayCounter& paymentDayCounter = DayCounter(),
                const BusinessDayConvention paymentConvention = Following,
                const std::vector<Natural>& fixingDays = std::vector<Natural>(),
                const std::vector<Real>& gearings = std::vector<Real>(),
                const std::vector<Spread>& spreads = std::vector<Spread>(),
                const std::vector<Rate>& caps = std::vector<Rate>(),
                const std::vector<Rate>& floors = std::vector<Rate>(),
                const Period& exCouponPeriod = Period(),
                const Calendar& exCouponCalendar = Calendar(),
                const BusinessDayConvention exCouponConvention = Unadjusted,
                bool exCouponEndOfMonth = false) {
    return QuantLib::CmsLeg(schedule, index)
        .withNotionals(nominals)
        .withPaymentDayCounter(paymentDayCounter)
        .withPaymentAdjustment(paymentConvention)
        .withFixingDays(fixingDays)
        .withGearings(gearings)
        .withSpreads(spreads)
        .withCaps(caps)
        .withFloors(floors)
        .withExCouponPeriod(exCouponPeriod, exCouponCalendar,
                            exCouponConvention, exCouponEndOfMonth)
        .withZeroPayments();
}


Leg _CmsSpreadLeg(const std::vector<Real>& nominals,
            const Schedule& schedule,
            const ext::shared_ptr<SwapSpreadIndex>& index,
            const DayCounter& paymentDayCounter = DayCounter(),
            const BusinessDayConvention paymentConvention = Following,
            const std::vector<Natural>& fixingDays = std::vector<Natural>(),
            const std::vector<Real>& gearings = std::vector<Real>(),
            const std::vector<Spread>& spreads = std::vector<Spread>(),
            const std::vector<Rate>& caps = std::vector<Rate>(),
            const std::vector<Rate>& floors = std::vector<Rate>(),
            bool isInArrears = false) {
    return QuantLib::CmsSpreadLeg(schedule, index)
        .withNotionals(nominals)
        .withPaymentDayCounter(paymentDayCounter)
        .withPaymentAdjustment(paymentConvention)
        .withFixingDays(fixingDays)
        .withGearings(gearings)
        .withSpreads(spreads)
        .withCaps(caps)
        .withFloors(floors)
        .inArrears(isInArrears);
}


Leg _SubPeriodsLeg(const std::vector<Real>& nominals,
                   const Schedule& schedule,
                   const ext::shared_ptr<IborIndex>& index,
                   const DayCounter& paymentDayCounter = DayCounter(),
                   const BusinessDayConvention paymentConvention = Following,
                   const Calendar& paymentCalendar = Calendar(),
                   Natural paymentLag = 0,
                   const std::vector<Natural>& fixingDays = std::vector<Natural>(),
                   const std::vector<Real>& gearings = std::vector<Real>(),
                   const std::vector<Spread>& couponSpreads = std::vector<Spread>(),
                   const std::vector<Spread>& rateSpreads = std::vector<Spread>(),
                   const Period& exCouponPeriod = Period(),
                   const Calendar& exCouponCalendar = Calendar(),
                   BusinessDayConvention exCouponConvention = Unadjusted,
                   bool exCouponEndOfMonth = false,
                   RateAveraging::Type averagingMethod = RateAveraging::Compound) {
    return QuantLib::SubPeriodsLeg(schedule, index)
        .withNotionals(nominals)
        .withPaymentDayCounter(paymentDayCounter)
        .withPaymentAdjustment(paymentConvention)
        .withPaymentCalendar(paymentCalendar.empty() ? schedule.calendar() : paymentCalendar)
        .withPaymentLag(paymentLag)
        .withFixingDays(fixingDays)
        .withGearings(gearings)
        .withCouponSpreads(couponSpreads)
        .withRateSpreads(rateSpreads)
        .withExCouponPeriod(exCouponPeriod,
                            exCouponCalendar,
                            exCouponConvention,
                            exCouponEndOfMonth)
        .withAveragingMethod(averagingMethod);
}


using QuantLib::CashFlows;
using QuantLib::Duration;

SWIGINTERN ext::shared_ptr< CashFlow > CashFlows_previousCashFlow__SWIG_0(Leg const &leg,bool includeSettlementDateFlows,Date settlementDate=Date()){
            Leg::const_reverse_iterator i =
                QuantLib::CashFlows::previousCashFlow(
                    leg, includeSettlementDateFlows, settlementDate);

            if (i == leg.rend())
                return ext::shared_ptr<CashFlow>();
            else
                return *i;
        }
SWIGINTERN ext::shared_ptr< CashFlow > CashFlows_nextCashFlow__SWIG_0(Leg const &leg,bool includeSettlementDateFlows,Date settlementDate=Date()){
            Leg::const_iterator i =
                QuantLib::CashFlows::nextCashFlow(
                    leg, includeSettlementDateFlows, settlementDate);

            if (i == leg.end())
                return ext::shared_ptr<CashFlow>();
            else
                return *i;
        }
SWIGINTERN Real CashFlows_npv__SWIG_0(Leg const &leg,ext::shared_ptr< YieldTermStructure > const &discountCurve,Spread zSpread,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,bool includeSettlementDateFlows,Date const &settlementDate=Date(),Date const &npvDate=Date()){
            return QuantLib::CashFlows::npv(leg, discountCurve,
                                            zSpread,
                                            dayCounter,
                                            compounding,
                                            frequency,
                                            includeSettlementDateFlows,
                                            settlementDate,
                                            npvDate);
        }
SWIGINTERN Real CashFlows_npv__SWIG_3(Leg const &leg,Handle< YieldTermStructure > const &discountCurve,bool includeSettlementDateFlows,Date const &settlementDate=Date(),Date const &npvDate=Date()){
            return QuantLib::CashFlows::npv(leg, **discountCurve,
                                            includeSettlementDateFlows,
                                            settlementDate, npvDate);
        }
SWIGINTERN Real CashFlows_bps__SWIG_0(Leg const &leg,ext::shared_ptr< YieldTermStructure > const &discountCurve,bool includeSettlementDateFlows,Date const &settlementDate=Date(),Date const &npvDate=Date()){
            return QuantLib::CashFlows::bps(leg, *discountCurve,
                                            includeSettlementDateFlows,
                                            settlementDate, npvDate);
        }
SWIGINTERN Real CashFlows_bps__SWIG_3(Leg const &leg,Handle< YieldTermStructure > const &discountCurve,bool includeSettlementDateFlows,Date const &settlementDate=Date(),Date const &npvDate=Date()){
            return QuantLib::CashFlows::bps(leg, **discountCurve,
                                            includeSettlementDateFlows,
                                            settlementDate, npvDate);
        }
SWIGINTERN Rate CashFlows_atmRate__SWIG_0(Leg const &leg,ext::shared_ptr< YieldTermStructure > const &discountCurve,bool includeSettlementDateFlows,Date const &settlementDate=Date(),Date const &npvDate=Date(),Real npv=Null< Real >()){
            return QuantLib::CashFlows::atmRate(leg, *discountCurve,
                                                includeSettlementDateFlows,
                                                settlementDate, npvDate,
                                                npv);
        }

using QuantLib::VanillaSwap;
using QuantLib::Swaption;
using QuantLib::CalibrationHelper;
using QuantLib::BlackCalibrationHelper;
using QuantLib::SwaptionHelper;
using QuantLib::CapHelper;
using QuantLib::HestonModelHelper;


    ext::shared_ptr<BlackCalibrationHelper> as_black_helper(const ext::shared_ptr<CalibrationHelper>& h) {
        return ext::dynamic_pointer_cast<BlackCalibrationHelper>(h);
    }
    ext::shared_ptr<SwaptionHelper> as_swaption_helper(const ext::shared_ptr<BlackCalibrationHelper>& h) {
        return ext::dynamic_pointer_cast<SwaptionHelper>(h);
    }

SWIGINTERN std::vector< Time > SwaptionHelper_times(SwaptionHelper *self){
            std::list<Time> l;
            self->addTimesTo(l);
            std::vector<Time> v;
            std::copy(l.begin(),l.end(),std::back_inserter(v));
            return v;
        }
SWIGINTERN Date SwaptionHelper_swaptionExpiryDate(SwaptionHelper *self){
            return self->swaption()->exercise()->date(0);
        }
SWIGINTERN Real SwaptionHelper_swaptionStrike(SwaptionHelper *self){
            return self->swaption()->underlyingSwap()->fixedRate();
        }
SWIGINTERN Real SwaptionHelper_swaptionNominal(SwaptionHelper *self){
            return self->swaption()->underlyingSwap()->nominal();
        }
SWIGINTERN Date SwaptionHelper_swaptionMaturityDate(SwaptionHelper *self){
            return self->swaption()->underlyingSwap()->fixedSchedule().dates().back();
        }
SWIGINTERN std::vector< Time > CapHelper_times(CapHelper *self){
            std::list<Time> l;
            self->addTimesTo(l);
            std::vector<Time> v;
            std::copy(l.begin(),l.end(),std::back_inserter(v));
            return v;
        }
SWIGINTERN std::vector< ext::shared_ptr< CalibrationHelper > > *new_std_vector_Sl_ext_shared_ptr_Sl_CalibrationHelper_Sg__Sg___SWIG_2(jint count,ext::shared_ptr< CalibrationHelper > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< CalibrationHelper > >(static_cast<std::vector< ext::shared_ptr< CalibrationHelper > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_CalibrationHelper_Sg__Sg__doSize(std::vector< ext::shared_ptr< CalibrationHelper > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_CalibrationHelper_Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< CalibrationHelper > > *self,std::vector< ext::shared_ptr< CalibrationHelper > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_CalibrationHelper_Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< CalibrationHelper > > *self,jint index,std::vector< ext::shared_ptr< CalibrationHelper > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< CalibrationHelper > >::value_type std_vector_Sl_ext_shared_ptr_Sl_CalibrationHelper_Sg__Sg__doRemove(std::vector< ext::shared_ptr< CalibrationHelper > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< CalibrationHelper > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< CalibrationHelper > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_CalibrationHelper_Sg__Sg__doGet(std::vector< ext::shared_ptr< CalibrationHelper > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< CalibrationHelper > >::value_type std_vector_Sl_ext_shared_ptr_Sl_CalibrationHelper_Sg__Sg__doSet(std::vector< ext::shared_ptr< CalibrationHelper > > *self,jint index,std::vector< ext::shared_ptr< CalibrationHelper > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< CalibrationHelper > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_CalibrationHelper_Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< CalibrationHelper > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< BlackCalibrationHelper > > *new_std_vector_Sl_ext_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg___SWIG_2(jint count,ext::shared_ptr< BlackCalibrationHelper > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< BlackCalibrationHelper > >(static_cast<std::vector< ext::shared_ptr< BlackCalibrationHelper > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__doSize(std::vector< ext::shared_ptr< BlackCalibrationHelper > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< BlackCalibrationHelper > > *self,std::vector< ext::shared_ptr< BlackCalibrationHelper > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< BlackCalibrationHelper > > *self,jint index,std::vector< ext::shared_ptr< BlackCalibrationHelper > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< BlackCalibrationHelper > >::value_type std_vector_Sl_ext_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__doRemove(std::vector< ext::shared_ptr< BlackCalibrationHelper > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< BlackCalibrationHelper > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< BlackCalibrationHelper > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__doGet(std::vector< ext::shared_ptr< BlackCalibrationHelper > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< BlackCalibrationHelper > >::value_type std_vector_Sl_ext_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__doSet(std::vector< ext::shared_ptr< BlackCalibrationHelper > > *self,jint index,std::vector< ext::shared_ptr< BlackCalibrationHelper > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< BlackCalibrationHelper > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< BlackCalibrationHelper > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

using QuantLib::CalibratedModel;
using QuantLib::TermStructureConsistentModel;

SWIGINTERN ext::shared_ptr< Observable > Handle_Sl_CalibratedModel_Sg__asObservable(Handle< CalibratedModel > *self){
        return ext::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_CalibratedModel_Sg__reset(RelinkableHandle< CalibratedModel > *self){
            self->linkTo(ext::shared_ptr<CalibratedModel>());
        }

using QuantLib::TimeGrid;

SWIGINTERN TimeGrid *new_TimeGrid__SWIG_2(std::vector< Time > const &times){
            return new TimeGrid(times.begin(), times.end());
        }
SWIGINTERN TimeGrid *new_TimeGrid__SWIG_3(std::vector< Time > const &times,Size steps){
            return new TimeGrid(times.begin(), times.end(), steps);
        }
SWIGINTERN Time TimeGrid_ref(TimeGrid *self,Size i){
            if (i<self->size())
                return (*self)[i];
            else
                throw std::out_of_range("time-grid index out of range");
        }
SWIGINTERN Time TimeGrid_dt(TimeGrid *self,Size i){
            if (i<self->size())
                return self->dt(i);
            else
                throw std::out_of_range("time-grid index out of range");
        }

using QuantLib::Parameter;
using QuantLib::ConstantParameter;
using QuantLib::NullParameter;
using QuantLib::PiecewiseConstantParameter;


using QuantLib::Payoff;


using QuantLib::Option;


using QuantLib::TypePayoff;
using QuantLib::FloatingTypePayoff;
using QuantLib::StrikedTypePayoff;


using QuantLib::DeltaVolQuote;

SWIGINTERN ext::shared_ptr< Observable > Handle_Sl_DeltaVolQuote_Sg__asObservable(Handle< DeltaVolQuote > *self){
        return ext::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_DeltaVolQuote_Sg__reset(RelinkableHandle< DeltaVolQuote > *self){
            self->linkTo(ext::shared_ptr<DeltaVolQuote>());
        }

using QuantLib::OneAssetOption;
using QuantLib::VanillaOption;
using QuantLib::ForwardVanillaOption;

SWIGINTERN SampledCurve VanillaOption_priceCurve(VanillaOption *self){
            return self->result<SampledCurve>("priceCurve");
        }
SWIGINTERN std::vector< std::pair< ext::shared_ptr< VanillaOption >,ext::shared_ptr< Quote > > > *new_std_vector_Sl_std_pair_Sl_ext_shared_ptr_Sl_VanillaOption_Sg__Sc_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg___SWIG_2(jint count,std::pair< ext::shared_ptr< VanillaOption >,ext::shared_ptr< Quote > > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::pair< ext::shared_ptr< VanillaOption >,ext::shared_ptr< Quote > > >(static_cast<std::vector< std::pair< ext::shared_ptr< VanillaOption >,ext::shared_ptr< Quote > > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_pair_Sl_ext_shared_ptr_Sl_VanillaOption_Sg__Sc_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doSize(std::vector< std::pair< ext::shared_ptr< VanillaOption >,ext::shared_ptr< Quote > > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_ext_shared_ptr_Sl_VanillaOption_Sg__Sc_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doAdd__SWIG_0(std::vector< std::pair< ext::shared_ptr< VanillaOption >,ext::shared_ptr< Quote > > > *self,std::vector< std::pair< ext::shared_ptr< VanillaOption >,ext::shared_ptr< Quote > > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_ext_shared_ptr_Sl_VanillaOption_Sg__Sc_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doAdd__SWIG_1(std::vector< std::pair< ext::shared_ptr< VanillaOption >,ext::shared_ptr< Quote > > > *self,jint index,std::vector< std::pair< ext::shared_ptr< VanillaOption >,ext::shared_ptr< Quote > > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::pair< ext::shared_ptr< VanillaOption >,ext::shared_ptr< Quote > > >::value_type std_vector_Sl_std_pair_Sl_ext_shared_ptr_Sl_VanillaOption_Sg__Sc_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doRemove(std::vector< std::pair< ext::shared_ptr< VanillaOption >,ext::shared_ptr< Quote > > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::pair< ext::shared_ptr< VanillaOption >,ext::shared_ptr< Quote > > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::pair< ext::shared_ptr< VanillaOption >,ext::shared_ptr< Quote > > >::value_type const &std_vector_Sl_std_pair_Sl_ext_shared_ptr_Sl_VanillaOption_Sg__Sc_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doGet(std::vector< std::pair< ext::shared_ptr< VanillaOption >,ext::shared_ptr< Quote > > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::pair< ext::shared_ptr< VanillaOption >,ext::shared_ptr< Quote > > >::value_type std_vector_Sl_std_pair_Sl_ext_shared_ptr_Sl_VanillaOption_Sg__Sc_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doSet(std::vector< std::pair< ext::shared_ptr< VanillaOption >,ext::shared_ptr< Quote > > > *self,jint index,std::vector< std::pair< ext::shared_ptr< VanillaOption >,ext::shared_ptr< Quote > > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::pair< ext::shared_ptr< VanillaOption >,ext::shared_ptr< Quote > > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_ext_shared_ptr_Sl_VanillaOption_Sg__Sc_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doRemoveRange(std::vector< std::pair< ext::shared_ptr< VanillaOption >,ext::shared_ptr< Quote > > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

using QuantLib::EuropeanOption;


using QuantLib::ForwardVanillaOption;


using QuantLib::QuantoVanillaOption;


using QuantLib::QuantoForwardVanillaOption;


using QuantLib::MultiAssetOption;


using QuantLib::AnalyticEuropeanEngine;


using QuantLib::HestonModel;

SWIGINTERN ext::shared_ptr< Observable > Handle_Sl_HestonModel_Sg__asObservable(Handle< HestonModel > *self){
        return ext::shared_ptr<Observable>(*self);
    }

using QuantLib::PiecewiseTimeDependentHestonModel;


using QuantLib::AnalyticHestonEngine;

SWIGINTERN std::pair< Real,Real > AnalyticHestonEngine_chF(AnalyticHestonEngine const *self,Real real,Real imag,Time t){
            const std::complex<Real> tmp 
                = self->chF(std::complex<Real>(real, imag), t);
            return std::pair<Real, Real>(tmp.real(), tmp.imag());
        }

using QuantLib::COSHestonEngine;


using QuantLib::ExponentialFittingHestonEngine;


using QuantLib::AnalyticPTDHestonEngine;


using QuantLib::BatesModel;


using QuantLib::BatesEngine;


using QuantLib::IntegralEngine;


using QuantLib::BinomialVanillaEngine;
using QuantLib::CoxRossRubinstein;
using QuantLib::JarrowRudd;
using QuantLib::AdditiveEQPBinomialTree;
using QuantLib::Trigeorgis;
using QuantLib::Tian;
using QuantLib::LeisenReimer;
using QuantLib::Joshi4;


using QuantLib::MCEuropeanEngine;
using QuantLib::MCEuropeanHestonEngine;
using QuantLib::MCAmericanEngine;
using QuantLib::MCDigitalEngine;
using QuantLib::PseudoRandom;
using QuantLib::LowDiscrepancy;
using QuantLib::LsmBasisSystem;

SWIGINTERN MCEuropeanEngine< PseudoRandom > *new_MCEuropeanEngine_Sl_PseudoRandom_Sg___SWIG_0(ext::shared_ptr< GeneralizedBlackScholesProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            QL_REQUIRE(Size(timeSteps) != Null<Size>() ||
                       Size(timeStepsPerYear) != Null<Size>(),
                       "number of steps not specified");
            return new MCEuropeanEngine<PseudoRandom>(process,
                                             timeSteps,
                                             timeStepsPerYear,
                                             brownianBridge,
                                             antitheticVariate,
                                             requiredSamples,
                                             requiredTolerance,
                                             maxSamples,
                                             seed);
        }
SWIGINTERN MCEuropeanEngine< LowDiscrepancy > *new_MCEuropeanEngine_Sl_LowDiscrepancy_Sg___SWIG_0(ext::shared_ptr< GeneralizedBlackScholesProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            QL_REQUIRE(Size(timeSteps) != Null<Size>() ||
                       Size(timeStepsPerYear) != Null<Size>(),
                       "number of steps not specified");
            return new MCEuropeanEngine<LowDiscrepancy>(process,
                                             timeSteps,
                                             timeStepsPerYear,
                                             brownianBridge,
                                             antitheticVariate,
                                             requiredSamples,
                                             requiredTolerance,
                                             maxSamples,
                                             seed);
        }
SWIGINTERN MCAmericanEngine< PseudoRandom > *new_MCAmericanEngine_Sl_PseudoRandom_Sg___SWIG_0(ext::shared_ptr< GeneralizedBlackScholesProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0,intOrNull polynomOrder=2,LsmBasisSystem::PolynomType polynomType=LsmBasisSystem::Monomial,int nCalibrationSamples=2048,boost::optional< bool > antitheticVariateCalibration=boost::none,BigNatural seedCalibration=Null< Size >()){
            return new MCAmericanEngine<PseudoRandom>(process,
                                             timeSteps,
                                             timeStepsPerYear,
                                             antitheticVariate,
                                             controlVariate,
                                             requiredSamples,
                                             requiredTolerance,
                                             maxSamples,
                                             seed,
                                             polynomOrder,
                                             polynomType,
                                             nCalibrationSamples,
                                             antitheticVariateCalibration,
                                             seedCalibration);
        }
SWIGINTERN MCAmericanEngine< LowDiscrepancy > *new_MCAmericanEngine_Sl_LowDiscrepancy_Sg___SWIG_0(ext::shared_ptr< GeneralizedBlackScholesProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0,intOrNull polynomOrder=2,LsmBasisSystem::PolynomType polynomType=LsmBasisSystem::Monomial,int nCalibrationSamples=2048,boost::optional< bool > antitheticVariateCalibration=boost::none,BigNatural seedCalibration=Null< Size >()){
            return new MCAmericanEngine<LowDiscrepancy>(process,
                                             timeSteps,
                                             timeStepsPerYear,
                                             antitheticVariate,
                                             controlVariate,
                                             requiredSamples,
                                             requiredTolerance,
                                             maxSamples,
                                             seed,
                                             polynomOrder,
                                             polynomType,
                                             nCalibrationSamples,
                                             antitheticVariateCalibration,
                                             seedCalibration);
        }
SWIGINTERN MCEuropeanHestonEngine< PseudoRandom > *new_MCEuropeanHestonEngine_Sl_PseudoRandom_Sg___SWIG_0(ext::shared_ptr< HestonProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            QL_REQUIRE(Size(timeSteps) != Null<Size>() ||
                       Size(timeStepsPerYear) != Null<Size>(),
                       "number of steps not specified");
            return new MCEuropeanHestonEngine<PseudoRandom>(process,
                                                   timeSteps,
                                                   timeStepsPerYear,
                                                   antitheticVariate,
                                                   requiredSamples,
                                                   requiredTolerance,
                                                   maxSamples,
                                                   seed);
        }
SWIGINTERN MCEuropeanHestonEngine< LowDiscrepancy > *new_MCEuropeanHestonEngine_Sl_LowDiscrepancy_Sg___SWIG_0(ext::shared_ptr< HestonProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            QL_REQUIRE(Size(timeSteps) != Null<Size>() ||
                       Size(timeStepsPerYear) != Null<Size>(),
                       "number of steps not specified");
            return new MCEuropeanHestonEngine<LowDiscrepancy>(process,
                                                   timeSteps,
                                                   timeStepsPerYear,
                                                   antitheticVariate,
                                                   requiredSamples,
                                                   requiredTolerance,
                                                   maxSamples,
                                                   seed);
        }
SWIGINTERN MCDigitalEngine< PseudoRandom > *new_MCDigitalEngine_Sl_PseudoRandom_Sg___SWIG_0(ext::shared_ptr< GeneralizedBlackScholesProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            QL_REQUIRE(Size(timeSteps) != Null<Size>() ||
                       Size(timeStepsPerYear) != Null<Size>(),
                       "number of steps not specified");
            return new MCDigitalEngine<PseudoRandom>(process,
                                            timeSteps,
                                            timeStepsPerYear,
                                            brownianBridge,
                                            antitheticVariate,
                                            requiredSamples,
                                            requiredTolerance,
                                            maxSamples,
                                            seed);
        }
SWIGINTERN MCDigitalEngine< LowDiscrepancy > *new_MCDigitalEngine_Sl_LowDiscrepancy_Sg___SWIG_0(ext::shared_ptr< GeneralizedBlackScholesProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            QL_REQUIRE(Size(timeSteps) != Null<Size>() ||
                       Size(timeStepsPerYear) != Null<Size>(),
                       "number of steps not specified");
            return new MCDigitalEngine<LowDiscrepancy>(process,
                                            timeSteps,
                                            timeStepsPerYear,
                                            brownianBridge,
                                            antitheticVariate,
                                            requiredSamples,
                                            requiredTolerance,
                                            maxSamples,
                                            seed);
        }

using QuantLib::BaroneAdesiWhaleyApproximationEngine;


using QuantLib::BjerksundStenslandApproximationEngine;


using QuantLib::JuQuadraticApproximationEngine;


using QuantLib::AnalyticDigitalAmericanEngine;


using QuantLib::AnalyticDigitalAmericanKOEngine;


using QuantLib::DividendVanillaOption;


using QuantLib::AnalyticDividendEuropeanEngine;


using QuantLib::FdmSchemeDesc;


using QuantLib::FdmQuantoHelper;


using QuantLib::LocalVolTermStructure;
using QuantLib::FdBlackScholesVanillaEngine;
using QuantLib::FdBlackScholesShoutEngine;
using QuantLib::FdOrnsteinUhlenbeckVanillaEngine;
using QuantLib::FdBatesVanillaEngine;
using QuantLib::FdHestonVanillaEngine;


using QuantLib::AnalyticCEVEngine;
using QuantLib::FdCEVVanillaEngine;


using QuantLib::FdSabrVanillaEngine;


using QuantLib::FdHestonHullWhiteVanillaEngine;


using QuantLib::AnalyticHestonHullWhiteEngine;


using QuantLib::AnalyticH1HWEngine;


using QuantLib::ForwardVanillaEngine;
using QuantLib::QuantoEngine;
typedef ForwardVanillaEngine<AnalyticEuropeanEngine> ForwardEuropeanEngine;
typedef QuantoEngine<VanillaOption,AnalyticEuropeanEngine> QuantoEuropeanEngine;
typedef QuantoEngine<ForwardVanillaOption,AnalyticEuropeanEngine> QuantoForwardEuropeanEngine;


using QuantLib::AnalyticHestonForwardEuropeanEngine;
using QuantLib::MCForwardEuropeanBSEngine;
using QuantLib::MCForwardEuropeanHestonEngine;

SWIGINTERN MCForwardEuropeanBSEngine< PseudoRandom > *new_MCForwardEuropeanBSEngine_Sl_PseudoRandom_Sg___SWIG_0(ext::shared_ptr< GeneralizedBlackScholesProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCForwardEuropeanBSEngine<PseudoRandom>(process,
                                                      timeSteps,
                                                      timeStepsPerYear,
                                                      brownianBridge,
                                                      antitheticVariate,
                                                      requiredSamples,
                                                      requiredTolerance,
                                                      maxSamples,
                                                      seed);
        }
SWIGINTERN MCForwardEuropeanBSEngine< LowDiscrepancy > *new_MCForwardEuropeanBSEngine_Sl_LowDiscrepancy_Sg___SWIG_0(ext::shared_ptr< GeneralizedBlackScholesProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCForwardEuropeanBSEngine<LowDiscrepancy>(process,
                                                      timeSteps,
                                                      timeStepsPerYear,
                                                      brownianBridge,
                                                      antitheticVariate,
                                                      requiredSamples,
                                                      requiredTolerance,
                                                      maxSamples,
                                                      seed);
        }
SWIGINTERN MCForwardEuropeanHestonEngine< PseudoRandom > *new_MCForwardEuropeanHestonEngine_Sl_PseudoRandom_Sg___SWIG_0(ext::shared_ptr< HestonProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0,bool controlVariate=false){
            return new MCForwardEuropeanHestonEngine<PseudoRandom>(process,
                                                          timeSteps,
                                                          timeStepsPerYear,
                                                          antitheticVariate,
                                                          requiredSamples,
                                                          requiredTolerance,
                                                          maxSamples,
                                                          seed,
                                                          controlVariate);
        }
SWIGINTERN MCForwardEuropeanHestonEngine< LowDiscrepancy > *new_MCForwardEuropeanHestonEngine_Sl_LowDiscrepancy_Sg___SWIG_0(ext::shared_ptr< HestonProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0,bool controlVariate=false){
            return new MCForwardEuropeanHestonEngine<LowDiscrepancy>(process,
                                                          timeSteps,
                                                          timeStepsPerYear,
                                                          antitheticVariate,
                                                          requiredSamples,
                                                          requiredTolerance,
                                                          maxSamples,
                                                          seed,
                                                          controlVariate);
        }

using QuantLib::BlackCalculator;


using QuantLib::VarianceGammaEngine;


using QuantLib::FFTVarianceGammaEngine;


using QuantLib::GJRGARCHModel;


using QuantLib::AnalyticGJRGARCHEngine;


using QuantLib::MCEuropeanGJRGARCHEngine;

SWIGINTERN MCEuropeanGJRGARCHEngine< PseudoRandom > *new_MCEuropeanGJRGARCHEngine_Sl_PseudoRandom_Sg___SWIG_0(ext::shared_ptr< GJRGARCHProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            QL_REQUIRE(Size(timeSteps) != Null<Size>() ||
                       Size(timeStepsPerYear) != Null<Size>(),
                       "number of steps not specified");
            return new MCEuropeanGJRGARCHEngine<PseudoRandom>(process,
                                                     timeSteps,
                                                     timeStepsPerYear,
                                                     antitheticVariate,
                                                     requiredSamples,
                                                     requiredTolerance,
                                                     maxSamples,
                                                     seed);
        }
SWIGINTERN MCEuropeanGJRGARCHEngine< LowDiscrepancy > *new_MCEuropeanGJRGARCHEngine_Sl_LowDiscrepancy_Sg___SWIG_0(ext::shared_ptr< GJRGARCHProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            QL_REQUIRE(Size(timeSteps) != Null<Size>() ||
                       Size(timeStepsPerYear) != Null<Size>(),
                       "number of steps not specified");
            return new MCEuropeanGJRGARCHEngine<LowDiscrepancy>(process,
                                                     timeSteps,
                                                     timeStepsPerYear,
                                                     antitheticVariate,
                                                     requiredSamples,
                                                     requiredTolerance,
                                                     maxSamples,
                                                     seed);
        }

using QuantLib::Average;
using QuantLib::ContinuousAveragingAsianOption;
using QuantLib::DiscreteAveragingAsianOption;

SWIGINTERN TimeGrid DiscreteAveragingAsianOption_timeGrid(DiscreteAveragingAsianOption *self){
            return self->result<TimeGrid>("TimeGrid");
        }

using QuantLib::AnalyticContinuousGeometricAveragePriceAsianEngine;
using QuantLib::AnalyticContinuousGeometricAveragePriceAsianHestonEngine;
using QuantLib::AnalyticDiscreteGeometricAveragePriceAsianEngine;
using QuantLib::AnalyticDiscreteGeometricAveragePriceAsianHestonEngine;
using QuantLib::AnalyticDiscreteGeometricAverageStrikeAsianEngine;


using QuantLib::MCDiscreteArithmeticAPEngine;
using QuantLib::MCDiscreteArithmeticAPHestonEngine;
using QuantLib::MCDiscreteArithmeticASEngine;
using QuantLib::MCDiscreteGeometricAPEngine;
using QuantLib::MCDiscreteGeometricAPHestonEngine;

SWIGINTERN MCDiscreteArithmeticAPEngine< PseudoRandom > *new_MCDiscreteArithmeticAPEngine_Sl_PseudoRandom_Sg___SWIG_0(ext::shared_ptr< GeneralizedBlackScholesProcess > const &process,bool brownianBridge=false,bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCDiscreteArithmeticAPEngine<PseudoRandom>(process,
                                                         brownianBridge,
                                                         antitheticVariate,
                                                         controlVariate,
                                                         requiredSamples,
                                                         requiredTolerance,
                                                         maxSamples,
                                                         seed);
        }
SWIGINTERN MCDiscreteArithmeticAPEngine< LowDiscrepancy > *new_MCDiscreteArithmeticAPEngine_Sl_LowDiscrepancy_Sg___SWIG_0(ext::shared_ptr< GeneralizedBlackScholesProcess > const &process,bool brownianBridge=false,bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCDiscreteArithmeticAPEngine<LowDiscrepancy>(process,
                                                         brownianBridge,
                                                         antitheticVariate,
                                                         controlVariate,
                                                         requiredSamples,
                                                         requiredTolerance,
                                                         maxSamples,
                                                         seed);
        }
SWIGINTERN MCDiscreteArithmeticAPHestonEngine< PseudoRandom > *new_MCDiscreteArithmeticAPHestonEngine_Sl_PseudoRandom_Sg___SWIG_0(ext::shared_ptr< HestonProcess > const &process,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool controlVariate=false){
            return new MCDiscreteArithmeticAPHestonEngine<PseudoRandom>(process,
                                                               antitheticVariate,
                                                               requiredSamples,
                                                               requiredTolerance,
                                                               maxSamples,
                                                               seed,
                                                               timeSteps,
                                                               timeStepsPerYear,
                                                               controlVariate);
        }
SWIGINTERN MCDiscreteArithmeticAPHestonEngine< LowDiscrepancy > *new_MCDiscreteArithmeticAPHestonEngine_Sl_LowDiscrepancy_Sg___SWIG_0(ext::shared_ptr< HestonProcess > const &process,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool controlVariate=false){
            return new MCDiscreteArithmeticAPHestonEngine<LowDiscrepancy>(process,
                                                               antitheticVariate,
                                                               requiredSamples,
                                                               requiredTolerance,
                                                               maxSamples,
                                                               seed,
                                                               timeSteps,
                                                               timeStepsPerYear,
                                                               controlVariate);
        }
SWIGINTERN MCDiscreteArithmeticASEngine< PseudoRandom > *new_MCDiscreteArithmeticASEngine_Sl_PseudoRandom_Sg___SWIG_0(ext::shared_ptr< GeneralizedBlackScholesProcess > const &process,bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCDiscreteArithmeticASEngine<PseudoRandom>(process,
                                                         brownianBridge,
                                                         antitheticVariate,
                                                         requiredSamples,
                                                         requiredTolerance,
                                                         maxSamples,
                                                         seed);
        }
SWIGINTERN MCDiscreteArithmeticASEngine< LowDiscrepancy > *new_MCDiscreteArithmeticASEngine_Sl_LowDiscrepancy_Sg___SWIG_0(ext::shared_ptr< GeneralizedBlackScholesProcess > const &process,bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCDiscreteArithmeticASEngine<LowDiscrepancy>(process,
                                                         brownianBridge,
                                                         antitheticVariate,
                                                         requiredSamples,
                                                         requiredTolerance,
                                                         maxSamples,
                                                         seed);
        }
SWIGINTERN MCDiscreteGeometricAPEngine< PseudoRandom > *new_MCDiscreteGeometricAPEngine_Sl_PseudoRandom_Sg___SWIG_0(ext::shared_ptr< GeneralizedBlackScholesProcess > const &process,bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCDiscreteGeometricAPEngine<PseudoRandom>(process,
                                                        brownianBridge,
                                                        antitheticVariate,
                                                        requiredSamples,
                                                        requiredTolerance,
                                                        maxSamples,
                                                        seed);
        }
SWIGINTERN MCDiscreteGeometricAPEngine< LowDiscrepancy > *new_MCDiscreteGeometricAPEngine_Sl_LowDiscrepancy_Sg___SWIG_0(ext::shared_ptr< GeneralizedBlackScholesProcess > const &process,bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCDiscreteGeometricAPEngine<LowDiscrepancy>(process,
                                                        brownianBridge,
                                                        antitheticVariate,
                                                        requiredSamples,
                                                        requiredTolerance,
                                                        maxSamples,
                                                        seed);
        }
SWIGINTERN MCDiscreteGeometricAPHestonEngine< PseudoRandom > *new_MCDiscreteGeometricAPHestonEngine_Sl_PseudoRandom_Sg___SWIG_0(ext::shared_ptr< HestonProcess > const &process,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >()){
            return new MCDiscreteGeometricAPHestonEngine<PseudoRandom>(process,
                                                              antitheticVariate,
                                                              requiredSamples,
                                                              requiredTolerance,
                                                              maxSamples,
                                                              seed,
                                                              timeSteps,
                                                              timeStepsPerYear);
        }
SWIGINTERN MCDiscreteGeometricAPHestonEngine< LowDiscrepancy > *new_MCDiscreteGeometricAPHestonEngine_Sl_LowDiscrepancy_Sg___SWIG_0(ext::shared_ptr< HestonProcess > const &process,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >()){
            return new MCDiscreteGeometricAPHestonEngine<LowDiscrepancy>(process,
                                                              antitheticVariate,
                                                              requiredSamples,
                                                              requiredTolerance,
                                                              maxSamples,
                                                              seed,
                                                              timeSteps,
                                                              timeStepsPerYear);
        }

using QuantLib::ContinuousArithmeticAsianLevyEngine;


using QuantLib::FdBlackScholesAsianEngine;


using QuantLib::TurnbullWakemanAsianEngine;


using QuantLib::Barrier;


using QuantLib::BarrierOption;
using QuantLib::DividendBarrierOption;


using QuantLib::AnalyticBarrierEngine;
using QuantLib::MCBarrierEngine;

SWIGINTERN MCBarrierEngine< PseudoRandom > *new_MCBarrierEngine_Sl_PseudoRandom_Sg___SWIG_0(ext::shared_ptr< GeneralizedBlackScholesProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),bool isBiased=false,BigInteger seed=0){
            return new MCBarrierEngine<PseudoRandom>(process,
                                            timeSteps,
                                            timeStepsPerYear,
                                            brownianBridge,
                                            antitheticVariate,
                                            requiredSamples,
                                            requiredTolerance,
                                            maxSamples,
                                            isBiased,
                                            seed);
        }
SWIGINTERN MCBarrierEngine< LowDiscrepancy > *new_MCBarrierEngine_Sl_LowDiscrepancy_Sg___SWIG_0(ext::shared_ptr< GeneralizedBlackScholesProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),bool isBiased=false,BigInteger seed=0){
            return new MCBarrierEngine<LowDiscrepancy>(process,
                                            timeSteps,
                                            timeStepsPerYear,
                                            brownianBridge,
                                            antitheticVariate,
                                            requiredSamples,
                                            requiredTolerance,
                                            maxSamples,
                                            isBiased,
                                            seed);
        }

using QuantLib::FdBlackScholesBarrierEngine;
using QuantLib::FdBlackScholesRebateEngine;
using QuantLib::FdHestonBarrierEngine;
using QuantLib::FdHestonRebateEngine;


using QuantLib::AnalyticBinaryBarrierEngine;


using QuantLib::BinomialBarrierEngine;
using QuantLib::DiscretizedDermanKaniBarrierOption;


using QuantLib::VannaVolgaBarrierEngine;


using QuantLib::DoubleBarrierOption;
using QuantLib::DoubleBarrier;


using QuantLib::QuantoDoubleBarrierOption;


using QuantLib::AnalyticDoubleBarrierEngine;


using QuantLib::FdHestonDoubleBarrierEngine;


using QuantLib::SuoWangDoubleBarrierEngine;


using QuantLib::VannaVolgaDoubleBarrierEngine;


using QuantLib::AnalyticDoubleBarrierBinaryEngine;


using QuantLib::BinomialDoubleBarrierEngine;
using QuantLib::DiscretizedDermanKaniDoubleBarrierOption;


using QuantLib::PlainVanillaPayoff;
using QuantLib::PercentageStrikePayoff;
using QuantLib::CashOrNothingPayoff;
using QuantLib::AssetOrNothingPayoff;
using QuantLib::SuperSharePayoff;
using QuantLib::GapPayoff;
using QuantLib::VanillaForwardPayoff;


    const ext::shared_ptr<PlainVanillaPayoff> as_plain_vanilla_payoff(
                           const ext::shared_ptr<Payoff>& payoff) {
        return ext::dynamic_pointer_cast<PlainVanillaPayoff>(payoff);
    }


using QuantLib::BasketOption;
using QuantLib::BasketPayoff;
using QuantLib::MinBasketPayoff;
using QuantLib::MaxBasketPayoff;
using QuantLib::AverageBasketPayoff;
using QuantLib::SpreadBasketPayoff;


using QuantLib::MCEuropeanBasketEngine;
using QuantLib::MCAmericanBasketEngine;

SWIGINTERN MCEuropeanBasketEngine< PseudoRandom > *new_MCEuropeanBasketEngine_Sl_PseudoRandom_Sg___SWIG_0(ext::shared_ptr< StochasticProcessArray > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCEuropeanBasketEngine<PseudoRandom>(process,
                                                   timeSteps,
                                                   timeStepsPerYear,
                                                   brownianBridge,
                                                   antitheticVariate,
                                                   requiredSamples,
                                                   requiredTolerance,
                                                   maxSamples,
                                                   seed);
        }
SWIGINTERN MCEuropeanBasketEngine< LowDiscrepancy > *new_MCEuropeanBasketEngine_Sl_LowDiscrepancy_Sg___SWIG_0(ext::shared_ptr< StochasticProcessArray > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCEuropeanBasketEngine<LowDiscrepancy>(process,
                                                   timeSteps,
                                                   timeStepsPerYear,
                                                   brownianBridge,
                                                   antitheticVariate,
                                                   requiredSamples,
                                                   requiredTolerance,
                                                   maxSamples,
                                                   seed);
        }
SWIGINTERN MCAmericanBasketEngine< PseudoRandom > *new_MCAmericanBasketEngine_Sl_PseudoRandom_Sg___SWIG_0(ext::shared_ptr< StochasticProcessArray > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0,Size nCalibrationSamples=Null< Size >(),Size polynomOrder=2,LsmBasisSystem::PolynomType polynomType=LsmBasisSystem::Monomial){
            return new MCAmericanBasketEngine<PseudoRandom>(process,
                                                   timeSteps,
                                                   timeStepsPerYear,
                                                   brownianBridge,
                                                   antitheticVariate,
                                                   requiredSamples,
                                                   requiredTolerance,
                                                   maxSamples,
                                                   seed,
                                                   nCalibrationSamples,
                                                   polynomOrder,
                                                   polynomType);
        }
SWIGINTERN MCAmericanBasketEngine< LowDiscrepancy > *new_MCAmericanBasketEngine_Sl_LowDiscrepancy_Sg___SWIG_0(ext::shared_ptr< StochasticProcessArray > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0,Size nCalibrationSamples=Null< Size >(),Size polynomOrder=2,LsmBasisSystem::PolynomType polynomType=LsmBasisSystem::Monomial){
            return new MCAmericanBasketEngine<LowDiscrepancy>(process,
                                                   timeSteps,
                                                   timeStepsPerYear,
                                                   brownianBridge,
                                                   antitheticVariate,
                                                   requiredSamples,
                                                   requiredTolerance,
                                                   maxSamples,
                                                   seed,
                                                   nCalibrationSamples,
                                                   polynomOrder,
                                                   polynomType);
        }

using QuantLib::StulzEngine;
using QuantLib::KirkEngine;
using QuantLib::Fd2dBlackScholesVanillaEngine;


using QuantLib::EverestOption;
using QuantLib::MCEverestEngine;

SWIGINTERN MCEverestEngine< PseudoRandom > *new_MCEverestEngine_Sl_PseudoRandom_Sg___SWIG_0(ext::shared_ptr< StochasticProcessArray > const &process,Size timeSteps=Null< Size >(),Size timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCEverestEngine<PseudoRandom>(process,
                                            timeSteps,
                                            timeStepsPerYear,
                                            brownianBridge,
                                            antitheticVariate,
                                            requiredSamples,
                                            requiredTolerance,
                                            maxSamples,
                                            seed);
        }
SWIGINTERN MCEverestEngine< LowDiscrepancy > *new_MCEverestEngine_Sl_LowDiscrepancy_Sg___SWIG_0(ext::shared_ptr< StochasticProcessArray > const &process,Size timeSteps=Null< Size >(),Size timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCEverestEngine<LowDiscrepancy>(process,
                                            timeSteps,
                                            timeStepsPerYear,
                                            brownianBridge,
                                            antitheticVariate,
                                            requiredSamples,
                                            requiredTolerance,
                                            maxSamples,
                                            seed);
        }

using QuantLib::HimalayaOption;
using QuantLib::MCHimalayaEngine;

SWIGINTERN MCHimalayaEngine< PseudoRandom > *new_MCHimalayaEngine_Sl_PseudoRandom_Sg___SWIG_0(ext::shared_ptr< StochasticProcessArray > const &process,bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCHimalayaEngine<PseudoRandom>(process,
                                             brownianBridge,
                                             antitheticVariate,
                                             requiredSamples,
                                             requiredTolerance,
                                             maxSamples,
                                             seed);
        }
SWIGINTERN MCHimalayaEngine< LowDiscrepancy > *new_MCHimalayaEngine_Sl_LowDiscrepancy_Sg___SWIG_0(ext::shared_ptr< StochasticProcessArray > const &process,bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCHimalayaEngine<LowDiscrepancy>(process,
                                             brownianBridge,
                                             antitheticVariate,
                                             requiredSamples,
                                             requiredTolerance,
                                             maxSamples,
                                             seed);
        }

using QuantLib::blackFormula;
using QuantLib::blackFormulaImpliedStdDev;
using QuantLib::blackFormulaImpliedStdDevLiRS;
using QuantLib::blackFormulaCashItmProbability;
using QuantLib::blackFormulaAssetItmProbability;
using QuantLib::bachelierBlackFormula;
using QuantLib::bachelierBlackFormulaImpliedVol;
using QuantLib::bachelierBlackFormulaAssetItmProbability;


using QuantLib::BlackDeltaCalculator;


using QuantLib::TimeBasket;


using QuantLib::Swap;
using QuantLib::VanillaSwap;
using QuantLib::MakeVanillaSwap;
using QuantLib::NonstandardSwap;
using QuantLib::DiscountingSwapEngine;
using QuantLib::FloatFloatSwap;
using QuantLib::OvernightIndexedSwap;
using QuantLib::MakeOIS;
using QuantLib::ZeroCouponSwap;

SWIGINTERN VanillaSwap *new_VanillaSwap__SWIG_0(Swap::Type type,Real nominal,Schedule const &fixedSchedule,Rate fixedRate,DayCounter const &fixedDayCount,Schedule const &floatSchedule,ext::shared_ptr< IborIndex > const &index,Spread spread,DayCounter const &floatingDayCount,boost::optional< bool > withIndexedCoupons=boost::none){
            // work around the lack of typemap for this argument
            boost::optional<BusinessDayConvention> paymentConvention = boost::none;

            return new VanillaSwap(type, nominal, fixedSchedule, fixedRate, fixedDayCount,
                                   floatSchedule, index, spread, floatingDayCount,
                                   paymentConvention, withIndexedCoupons);
        }
SWIGINTERN ext::shared_ptr< VanillaSwap > MakeVanillaSwap_makeVanillaSwap(MakeVanillaSwap *self){
                return (ext::shared_ptr<VanillaSwap>)(* self);
            }
SWIGINTERN DiscountingSwapEngine *new_DiscountingSwapEngine__SWIG_3(Handle< YieldTermStructure > const &discountCurve,Date const &settlementDate=Date(),Date const &npvDate=Date()){
            return new DiscountingSwapEngine(discountCurve,
                                             boost::none,
                                             settlementDate,
                                             npvDate);
        }

using QuantLib::AssetSwap;
using QuantLib::OvernightIndexedSwapIndex;

SWIGINTERN ext::shared_ptr< OvernightIndexedSwap > MakeOIS_makeOIS(MakeOIS *self){
                return (ext::shared_ptr<OvernightIndexedSwap>)(* self);
            }

    ext::shared_ptr<OvernightIndexedSwap> as_overnight_swap_index(
                          const ext::shared_ptr<InterestRateIndex>& index) {
        return ext::dynamic_pointer_cast<OvernightIndexedSwap>(index);
    }


  using QuantLib::InflationTermStructure;
  using QuantLib::Seasonality;
  using QuantLib::MultiplicativePriceSeasonality;
  using QuantLib::KerkhofSeasonality;


  using QuantLib::InflationTermStructure;
  using QuantLib::YoYInflationTermStructure;
  using QuantLib::ZeroInflationTermStructure;

SWIGINTERN ext::shared_ptr< Observable > Handle_Sl_YoYInflationTermStructure_Sg__asObservable(Handle< YoYInflationTermStructure > *self){
        return ext::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_YoYInflationTermStructure_Sg__reset(RelinkableHandle< YoYInflationTermStructure > *self){
            self->linkTo(ext::shared_ptr<YoYInflationTermStructure>());
        }
SWIGINTERN ext::shared_ptr< Observable > Handle_Sl_ZeroInflationTermStructure_Sg__asObservable(Handle< ZeroInflationTermStructure > *self){
        return ext::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_ZeroInflationTermStructure_Sg__reset(RelinkableHandle< ZeroInflationTermStructure > *self){
            self->linkTo(ext::shared_ptr<ZeroInflationTermStructure>());
        }

using QuantLib::Region;
using QuantLib::CustomRegion;
using QuantLib::InflationIndex;
using QuantLib::ZeroInflationIndex;
using QuantLib::YoYInflationIndex;


using QuantLib::EUHICP;


using QuantLib::EUHICPXT;


using QuantLib::FRHICP;


using QuantLib::UKRPI;


using QuantLib::USCPI;


using QuantLib::ZACPI;


using QuantLib::YYEUHICP;


using QuantLib::YYEUHICPXT;


using QuantLib::YYEUHICPr;


using QuantLib::YYFRHICP;


using QuantLib::YYFRHICPr;


using QuantLib::YYUKRPI;


using QuantLib::YYUKRPIr;


using QuantLib::YYUSCPI;


using QuantLib::YYUSCPIr;


using QuantLib::YYZACPI;


using QuantLib::YYZACPIr;


using QuantLib::AUCPI;


using QuantLib::CPI;


using QuantLib::InflationCoupon;
using QuantLib::CPICoupon;
using QuantLib::CPICouponPricer;
using QuantLib::CPICashFlow;
using QuantLib::ZeroInflationCashFlow;


    ext::shared_ptr<InflationCoupon> as_inflation_coupon(
                                      const ext::shared_ptr<CashFlow>& cf) {
        return ext::dynamic_pointer_cast<InflationCoupon>(cf);
    }


    ext::shared_ptr<CPICoupon> as_cpi_coupon(
                                      const ext::shared_ptr<CashFlow>& cf) {
        return ext::dynamic_pointer_cast<CPICoupon>(cf);
    }


    ext::shared_ptr<CPICashFlow> as_cpi_cashflow(
                                      const ext::shared_ptr<CashFlow>& cf) {
        return ext::dynamic_pointer_cast<CPICashFlow>(cf);
    }


Leg _CPILeg(const std::vector<Real>& nominals,
            const Schedule& schedule,
            const ext::shared_ptr<ZeroInflationIndex>& index,
            Real baseCPI,
            const Period& observationLag,
            const DayCounter& paymentDayCounter = DayCounter(),
            const BusinessDayConvention paymentConvention = Following,
            const std::vector<Real>& fixedRates = std::vector<Real>(),
            const std::vector<Spread>& spreads = std::vector<Spread>(),
            const std::vector<Natural>& fixingDays = std::vector<Natural>(),
            const std::vector<Rate>& caps = std::vector<Rate>(),
            const std::vector<Rate>& floors = std::vector<Rate>(),
            const Period& exCouponPeriod = Period(),
            const Calendar& exCouponCalendar = Calendar(),
            BusinessDayConvention exCouponConvention = Unadjusted,
            bool exCouponEndOfMonth = false,
            const Calendar& paymentCalendar = Calendar(),
            bool growthOnly = true,
            CPI::InterpolationType observationInterpolation = CPI::AsIndex) {
    return QuantLib::CPILeg(schedule, index, baseCPI, observationLag)
        .withNotionals(nominals)
        .withPaymentDayCounter(paymentDayCounter)
        .withPaymentAdjustment(paymentConvention)
        .withPaymentCalendar(paymentCalendar.empty() ? schedule.calendar() : paymentCalendar)
        .withFixingDays(fixingDays)
        .withFixedRates(fixedRates)
        .withSpreads(spreads)
        .withCaps(caps)
        .withFloors(floors)
        .withExCouponPeriod(exCouponPeriod,
                            exCouponCalendar,
                            exCouponConvention,
                            exCouponEndOfMonth)
        .withSubtractInflationNominal(growthOnly)
        .withObservationInterpolation(observationInterpolation);
}


    ext::shared_ptr<ZeroInflationCashFlow> as_zero_inflation_cash_flow(
                                      const ext::shared_ptr<CashFlow>& cf) {
        return ext::dynamic_pointer_cast<ZeroInflationCashFlow>(cf);
    }


using QuantLib::BootstrapHelper;
using QuantLib::ZeroCouponInflationSwapHelper;
using QuantLib::YearOnYearInflationSwapHelper;
using QuantLib::YoYOptionletHelper;

SWIGINTERN std::vector< ext::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *new_std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg___SWIG_2(jint count,ext::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > >(static_cast<std::vector< ext::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__doSize(std::vector< ext::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,std::vector< ext::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,jint index,std::vector< ext::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > >::value_type std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__doRemove(std::vector< ext::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__doGet(std::vector< ext::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > >::value_type std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__doSet(std::vector< ext::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,jint index,std::vector< ext::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *new_std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg___SWIG_2(jint count,ext::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > >(static_cast<std::vector< ext::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__doSize(std::vector< ext::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,std::vector< ext::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,jint index,std::vector< ext::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > >::value_type std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__doRemove(std::vector< ext::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__doGet(std::vector< ext::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > >::value_type std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__doSet(std::vector< ext::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,jint index,std::vector< ext::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< BootstrapHelper< YoYOptionletVolatilitySurface > > > *new_std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_YoYOptionletVolatilitySurface_Sg__Sg__Sg___SWIG_2(jint count,ext::shared_ptr< BootstrapHelper< YoYOptionletVolatilitySurface > > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< BootstrapHelper< YoYOptionletVolatilitySurface > > >(static_cast<std::vector< ext::shared_ptr< BootstrapHelper< YoYOptionletVolatilitySurface > > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_YoYOptionletVolatilitySurface_Sg__Sg__Sg__doSize(std::vector< ext::shared_ptr< BootstrapHelper< YoYOptionletVolatilitySurface > > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_YoYOptionletVolatilitySurface_Sg__Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< BootstrapHelper< YoYOptionletVolatilitySurface > > > *self,std::vector< ext::shared_ptr< BootstrapHelper< YoYOptionletVolatilitySurface > > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_YoYOptionletVolatilitySurface_Sg__Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< BootstrapHelper< YoYOptionletVolatilitySurface > > > *self,jint index,std::vector< ext::shared_ptr< BootstrapHelper< YoYOptionletVolatilitySurface > > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< BootstrapHelper< YoYOptionletVolatilitySurface > > >::value_type std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_YoYOptionletVolatilitySurface_Sg__Sg__Sg__doRemove(std::vector< ext::shared_ptr< BootstrapHelper< YoYOptionletVolatilitySurface > > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< BootstrapHelper< YoYOptionletVolatilitySurface > > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< BootstrapHelper< YoYOptionletVolatilitySurface > > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_YoYOptionletVolatilitySurface_Sg__Sg__Sg__doGet(std::vector< ext::shared_ptr< BootstrapHelper< YoYOptionletVolatilitySurface > > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< BootstrapHelper< YoYOptionletVolatilitySurface > > >::value_type std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_YoYOptionletVolatilitySurface_Sg__Sg__Sg__doSet(std::vector< ext::shared_ptr< BootstrapHelper< YoYOptionletVolatilitySurface > > > *self,jint index,std::vector< ext::shared_ptr< BootstrapHelper< YoYOptionletVolatilitySurface > > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< BootstrapHelper< YoYOptionletVolatilitySurface > > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_BootstrapHelper_Sl_YoYOptionletVolatilitySurface_Sg__Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< BootstrapHelper< YoYOptionletVolatilitySurface > > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

using QuantLib::PiecewiseZeroInflationCurve;
using QuantLib::PiecewiseYoYInflationCurve;



    Date inflationBaseDate(const Date& referenceDate,
                           const Period& observationLag,
                           Frequency frequency,
                           bool indexIsInterpolated) {
        if (indexIsInterpolated) {
            return referenceDate - observationLag;
        } else {
            return QuantLib::inflationPeriod(referenceDate - observationLag,
                                             frequency).first;
        }
    }



Leg _yoyInflationLeg(const Schedule& schedule,
                     const Calendar& calendar,
                     const ext::shared_ptr<YoYInflationIndex>& index,
                     const Period& observationLag,
                     const std::vector<Real>& notionals,
                     const DayCounter& paymentDayCounter,
                     BusinessDayConvention paymentAdjustment = Following,
                     Natural fixingDays = 0,
                     const std::vector<Real>& gearings = std::vector<Real>(),
                     const std::vector<Spread>& spreads = std::vector<Spread>(),
                     const std::vector<Rate>& caps = std::vector<Rate>(),
                     const std::vector<Rate>& floors = std::vector<Rate>()) {
        return QuantLib::yoyInflationLeg(schedule, calendar, index, observationLag)
            .withNotionals(notionals)
            .withPaymentDayCounter(paymentDayCounter)
            .withPaymentAdjustment(paymentAdjustment)
            .withFixingDays(fixingDays)
            .withGearings(gearings)
            .withSpreads(spreads)
            .withCaps(caps)
            .withFloors(floors);
}


using QuantLib::ZeroCouponInflationSwap;
using QuantLib::YearOnYearInflationSwap;
using QuantLib::CPISwap;


using QuantLib::YoYInflationCapFloor;
using QuantLib::YoYInflationCap;
using QuantLib::YoYInflationFloor;
using QuantLib::YoYInflationCollar;

SWIGINTERN std::vector< Real > YoYInflationCapFloor_optionletPrices(YoYInflationCapFloor *self){
             return self->result<std::vector<Real> >("optionletsPrice");
         }

using QuantLib::InterpolatedZeroInflationCurve;
using QuantLib::InterpolatedYoYInflationCurve;


using QuantLib::YoYCapFloorTermPriceSurface;
using QuantLib::InterpolatedYoYCapFloorTermPriceSurface;


typedef InterpolatedYoYCapFloorTermPriceSurface<Bicubic, Cubic> YoYInflationCapFloorTermPriceSurface;

SWIGINTERN YoYInflationCapFloorTermPriceSurface *new_YoYInflationCapFloorTermPriceSurface__SWIG_0(Natural fixingDays,Period const &yyLag,ext::shared_ptr< YoYInflationIndex > const &yii,Rate baseRate,Handle< YieldTermStructure > const &nominal,DayCounter const &dc,Calendar const &cal,BusinessDayConvention const &bdc,std::vector< Rate > const &cStrikes,std::vector< Rate > const &fStrikes,std::vector< Period > const &cfMaturities,Matrix const &cPrice,Matrix const &fPrice,Bicubic const &interpolator2d=Bicubic(),Cubic const &interpolator1d=Cubic()){
            return new YoYInflationCapFloorTermPriceSurface(fixingDays, yyLag, yii, baseRate, nominal,
                            dc, cal, bdc, cStrikes, fStrikes, cfMaturities,
                            cPrice, fPrice);
        }

using QuantLib::YoYInflationCapFloorEngine;
using QuantLib::YoYInflationBlackCapFloorEngine;
using QuantLib::YoYInflationUnitDisplacedBlackCapFloorEngine;
using QuantLib::YoYInflationBachelierCapFloorEngine;

SWIGINTERN YoYOptionletHelper *new_YoYOptionletHelper(Handle< Quote > const &price,Real notional,YoYInflationCapFloor::Type capFloorType,Period &lag,DayCounter const &yoyDayCounter,Calendar const &paymentCalendar,Natural fixingDays,ext::shared_ptr< YoYInflationIndex > const &index,Rate strike,Size n,ext::shared_ptr< PricingEngine > const &pricer){
            ext::shared_ptr<QuantLib::YoYInflationCapFloorEngine> engine = ext::dynamic_pointer_cast<YoYInflationCapFloorEngine>(pricer);
            return new YoYOptionletHelper(price, notional, capFloorType, lag, yoyDayCounter, paymentCalendar, fixingDays, index, strike, n, engine);
         }

using QuantLib::YoYOptionletStripper;
using QuantLib::InterpolatedYoYOptionletStripper;

SWIGINTERN void YoYOptionletStripper_initialize(YoYOptionletStripper const *self,ext::shared_ptr< YoYCapFloorTermPriceSurface > const &surf,ext::shared_ptr< PricingEngine > const &pricer,Real slope){
            ext::shared_ptr<QuantLib::YoYInflationCapFloorEngine> engine = ext::dynamic_pointer_cast<YoYInflationCapFloorEngine>(pricer);
            return (self)->initialize(surf, engine, slope);
        }

using QuantLib::InterpolatedYoYOptionletVolatilityCurve;
using QuantLib::KInterpolatedYoYOptionletVolatilitySurface;
using QuantLib::YoYInflationCapFloorEngine;

SWIGINTERN KInterpolatedYoYOptionletVolatilitySurface< Linear > *new_KInterpolatedYoYOptionletVolatilitySurface_Sl_Linear_Sg___SWIG_0(Natural settlementDays,Calendar const &calendar,BusinessDayConvention bdc,DayCounter const &dc,Period const &lag,ext::shared_ptr< YoYCapFloorTermPriceSurface > const &capFloorPrices,ext::shared_ptr< PricingEngine > const &pricer,ext::shared_ptr< YoYOptionletStripper > const &yoyOptionletStripper,Real slope,Linear const &interpolator=Linear()){
                 ext::shared_ptr<QuantLib::YoYInflationCapFloorEngine> engine = ext::dynamic_pointer_cast<YoYInflationCapFloorEngine>(pricer);
                     return new KInterpolatedYoYOptionletVolatilitySurface<Linear>(settlementDays,
                                 calendar, bdc, dc, lag, capFloorPrices, engine, yoyOptionletStripper,
                                 slope, interpolator);
        }

using QuantLib::ShortRateModel;

SWIGINTERN ext::shared_ptr< Observable > Handle_Sl_ShortRateModel_Sg__asObservable(Handle< ShortRateModel > *self){
        return ext::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_ShortRateModel_Sg__reset(RelinkableHandle< ShortRateModel > *self){
            self->linkTo(ext::shared_ptr<ShortRateModel>());
        }

using QuantLib::OneFactorAffineModel;
using QuantLib::Vasicek;
using QuantLib::HullWhite;
using QuantLib::BlackKarasinski;
using QuantLib::G2;
using QuantLib::CoxIngersollRoss;
using QuantLib::ExtendedCoxIngersollRoss;


using QuantLib::JamshidianSwaptionEngine;
using QuantLib::TreeSwaptionEngine;
using QuantLib::AnalyticCapFloorEngine;
using QuantLib::TreeCapFloorEngine;
using QuantLib::G2SwaptionEngine;
using QuantLib::FdG2SwaptionEngine;
using QuantLib::FdHullWhiteSwaptionEngine;


using QuantLib::AnalyticBSMHullWhiteEngine;


using QuantLib::Bond;
typedef Bond::Price BondPrice;
using QuantLib::ZeroCouponBond;
using QuantLib::FixedRateBond;
using QuantLib::AmortizingFixedRateBond;
using QuantLib::FloatingRateBond;
using QuantLib::AmortizingFloatingRateBond;
using QuantLib::DiscountingBondEngine;


    Real cleanPriceFromZSpread(
                   const Bond& bond,
                   const ext::shared_ptr<YieldTermStructure>& discountCurve,
                   Spread zSpread,
                   const DayCounter& dc,
                   Compounding compounding,
                   Frequency freq,
                   const Date& settlementDate = Date()) {
        return QuantLib::BondFunctions::cleanPrice(
                                  bond,
                                  discountCurve,
                                  zSpread, dc, compounding,
                                  freq, settlementDate);
    }


SWIGINTERN ext::shared_ptr< FixedRateBond > FixedRateBond_from_rates__SWIG_0(Integer settlementDays,Real faceAmount,Schedule const &schedule,std::vector< Rate > const &coupons,DayCounter const &paymentDayCounter,BusinessDayConvention paymentConvention=QuantLib::Following,Real redemption=100.0,Date issueDate=Date(),Calendar const &paymentCalendar=Calendar(),Period const &exCouponPeriod=Period(),Calendar const &exCouponCalendar=Calendar(),BusinessDayConvention exCouponConvention=Unadjusted,bool exCouponEndOfMonth=false){
            return ext::shared_ptr<FixedRateBond>(
                new FixedRateBond(settlementDays, faceAmount, schedule, coupons,
                                  paymentDayCounter, paymentConvention,
                                  redemption, issueDate, paymentCalendar,
                                  exCouponPeriod, exCouponCalendar,
                                  exCouponConvention, exCouponEndOfMonth));
        }
SWIGINTERN ext::shared_ptr< FixedRateBond > FixedRateBond_from_interest_rates__SWIG_0(Integer settlementDays,Real faceAmount,Schedule const &schedule,std::vector< InterestRate > const &coupons,BusinessDayConvention paymentConvention=Following,Real redemption=100.0,Date const &issueDate=Date(),Calendar const &paymentCalendar=Calendar(),Period const &exCouponPeriod=Period(),Calendar const &exCouponCalendar=Calendar(),BusinessDayConvention exCouponConvention=Unadjusted,bool exCouponEndOfMonth=false){
            return ext::shared_ptr<FixedRateBond>(
                new FixedRateBond(settlementDays, faceAmount, schedule, coupons,
                                  paymentConvention, redemption,
                                  issueDate, paymentCalendar,
                                  exCouponPeriod, exCouponCalendar,
                                  exCouponConvention, exCouponEndOfMonth));
        }
SWIGINTERN ext::shared_ptr< FixedRateBond > FixedRateBond_from_date_info__SWIG_0(Integer settlementDays,Calendar const &couponCalendar,Real faceAmount,Date const &startDate,Date const &maturityDate,Period const &tenor,std::vector< Rate > const &coupons,DayCounter const &accrualDayCounter,BusinessDayConvention accrualConvention=QuantLib::Following,BusinessDayConvention paymentConvention=QuantLib::Following,Real redemption=100.0,Date const &issueDate=Date(),Date const &stubDate=Date(),DateGeneration::Rule rule=QuantLib::DateGeneration::Backward,bool endOfMonth=false,Calendar const &paymentCalendar=Calendar(),Period const &exCouponPeriod=Period(),Calendar const &exCouponCalendar=Calendar(),BusinessDayConvention const exCouponConvention=Unadjusted,bool exCouponEndOfMonth=false){
            return ext::shared_ptr<FixedRateBond>(
                new FixedRateBond(settlementDays, couponCalendar, faceAmount,
                                  startDate, maturityDate, tenor,
                                  coupons, accrualDayCounter, accrualConvention,
                                  paymentConvention, redemption, issueDate,
                                  stubDate, rule, endOfMonth, paymentCalendar,
                                  exCouponPeriod, exCouponCalendar,
                                  exCouponConvention, exCouponEndOfMonth));
        }

using QuantLib::CmsRateBond;


using QuantLib::CallableBond;
using QuantLib::Callability;
using QuantLib::SoftCallability;
using QuantLib::CallabilitySchedule;

using QuantLib::CallableFixedRateBond;
using QuantLib::CallableZeroCouponBond;
using QuantLib::TreeCallableFixedRateBondEngine;
using QuantLib::BlackCallableFixedRateBondEngine;

SWIGINTERN std::vector< ext::shared_ptr< Callability > > *new_std_vector_Sl_ext_shared_ptr_Sl_Callability_Sg__Sg___SWIG_2(jint count,ext::shared_ptr< Callability > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< Callability > >(static_cast<std::vector< ext::shared_ptr< Callability > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_Callability_Sg__Sg__doSize(std::vector< ext::shared_ptr< Callability > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_Callability_Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< Callability > > *self,std::vector< ext::shared_ptr< Callability > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_Callability_Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< Callability > > *self,jint index,std::vector< ext::shared_ptr< Callability > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< Callability > >::value_type std_vector_Sl_ext_shared_ptr_Sl_Callability_Sg__Sg__doRemove(std::vector< ext::shared_ptr< Callability > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< Callability > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< Callability > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_Callability_Sg__Sg__doGet(std::vector< ext::shared_ptr< Callability > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< Callability > >::value_type std_vector_Sl_ext_shared_ptr_Sl_Callability_Sg__Sg__doSet(std::vector< ext::shared_ptr< Callability > > *self,jint index,std::vector< ext::shared_ptr< Callability > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< Callability > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_Callability_Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< Callability > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

using QuantLib::CPIBond;


using QuantLib::BondFunctions;

SWIGINTERN Rate BondFunctions_yieldBrent__SWIG_0(Brent solver,Bond const &bond,Real cleanPrice,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date(),Real accuracy=1.0e-10,Rate guess=0.05){
            return QuantLib::BondFunctions::yield<Brent>(
                        solver,
                        bond,
                        cleanPrice,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate,
                        accuracy,
                        guess);
        }
SWIGINTERN Rate BondFunctions_yieldBisection__SWIG_0(Bisection solver,Bond const &bond,Real cleanPrice,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date(),Real accuracy=1.0e-10,Rate guess=0.05){
            return QuantLib::BondFunctions::yield<Bisection>(
                        solver,
                        bond,
                        cleanPrice,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate,
                        accuracy,
                        guess);
        }
SWIGINTERN Rate BondFunctions_yieldFalsePosition__SWIG_0(FalsePosition solver,Bond const &bond,Real cleanPrice,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date(),Real accuracy=1.0e-10,Rate guess=0.05){
            return QuantLib::BondFunctions::yield<FalsePosition>(
                        solver,
                        bond,
                        cleanPrice,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate,
                        accuracy,
                        guess);
        }
SWIGINTERN Rate BondFunctions_yieldRidder__SWIG_0(Ridder solver,Bond const &bond,Real cleanPrice,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date(),Real accuracy=1.0e-10,Rate guess=0.05){
            return QuantLib::BondFunctions::yield<Ridder>(
                        solver,
                        bond,
                        cleanPrice,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate,
                        accuracy,
                        guess);
        }
SWIGINTERN Rate BondFunctions_yieldSecant__SWIG_0(Secant solver,Bond const &bond,Real cleanPrice,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date(),Real accuracy=1.0e-10,Rate guess=0.05){
            return QuantLib::BondFunctions::yield<Secant>(
                        solver,
                        bond,
                        cleanPrice,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate,
                        accuracy,
                        guess);
        }

using QuantLib::CapFloor;
using QuantLib::Cap;
using QuantLib::Floor;
using QuantLib::Collar;

SWIGINTERN Real const CapFloor_vega(CapFloor *self){
        return self->result<Real>("vega");
      }
SWIGINTERN std::vector< Real > const CapFloor_optionletsPrice(CapFloor *self){
        return self->result<std::vector<Real> >("optionletsPrice");
      }
SWIGINTERN std::vector< Real > const CapFloor_optionletsVega(CapFloor *self){
        return self->result<std::vector<Real> >("optionletsVega");
      }
SWIGINTERN std::vector< Real > const CapFloor_optionletsDelta(CapFloor *self){
        return self->result<std::vector<Real> >("optionletsDelta");
      }
SWIGINTERN std::vector< DiscountFactor > const CapFloor_optionletsDiscountFactor(CapFloor *self){
        return self->result<std::vector<DiscountFactor> >("optionletsDiscountFactor");
      }
SWIGINTERN std::vector< Rate > const CapFloor_optionletsAtmForward(CapFloor *self){
        return self->result<std::vector<Real> >("optionletsAtmForward");
      }
SWIGINTERN std::vector< Rate > const CapFloor_optionletsStdDev(CapFloor *self){
        return self->result<std::vector<Real> >("optionletsStdDev");
      }

using QuantLib::BlackCapFloorEngine;


using QuantLib::BachelierCapFloorEngine;


using QuantLib::CliquetOption;


using QuantLib::AnalyticCliquetEngine;
using QuantLib::AnalyticPerformanceEngine;
using QuantLib::MCPerformanceEngine;

SWIGINTERN MCPerformanceEngine< PseudoRandom > *new_MCPerformanceEngine_Sl_PseudoRandom_Sg___SWIG_0(ext::shared_ptr< GeneralizedBlackScholesProcess > process,bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCPerformanceEngine<PseudoRandom>(process,
                                                brownianBridge,
                                                antitheticVariate,
                                                requiredSamples,
                                                requiredTolerance,
                                                maxSamples,
                                                seed);
        }
SWIGINTERN MCPerformanceEngine< LowDiscrepancy > *new_MCPerformanceEngine_Sl_LowDiscrepancy_Sg___SWIG_0(ext::shared_ptr< GeneralizedBlackScholesProcess > process,bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCPerformanceEngine<LowDiscrepancy>(process,
                                                brownianBridge,
                                                antitheticVariate,
                                                requiredSamples,
                                                requiredTolerance,
                                                maxSamples,
                                                seed);
        }

using QuantLib::Dividend;


using QuantLib::FixedDividend;
using QuantLib::FractionalDividend;

SWIGINTERN std::vector< ext::shared_ptr< Dividend > > *new_std_vector_Sl_ext_shared_ptr_Sl_Dividend_Sg__Sg___SWIG_2(jint count,ext::shared_ptr< Dividend > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< Dividend > >(static_cast<std::vector< ext::shared_ptr< Dividend > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_Dividend_Sg__Sg__doSize(std::vector< ext::shared_ptr< Dividend > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_Dividend_Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< Dividend > > *self,std::vector< ext::shared_ptr< Dividend > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_Dividend_Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< Dividend > > *self,jint index,std::vector< ext::shared_ptr< Dividend > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< Dividend > >::value_type std_vector_Sl_ext_shared_ptr_Sl_Dividend_Sg__Sg__doRemove(std::vector< ext::shared_ptr< Dividend > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< Dividend > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< Dividend > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_Dividend_Sg__Sg__doGet(std::vector< ext::shared_ptr< Dividend > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< Dividend > >::value_type std_vector_Sl_ext_shared_ptr_Sl_Dividend_Sg__Sg__doSet(std::vector< ext::shared_ptr< Dividend > > *self,jint index,std::vector< ext::shared_ptr< Dividend > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< Dividend > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_Dividend_Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< Dividend > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

using QuantLib::ConvertibleZeroCouponBond;
using QuantLib::ConvertibleFixedCouponBond;
using QuantLib::ConvertibleFloatingRateBond;
using QuantLib::BinomialConvertibleEngine;


using QuantLib::Forward;


using QuantLib::BondForward;
using QuantLib::FixedRateBondForward;
using QuantLib::FixedRateBond;
using QuantLib::BusinessDayConvention;
using QuantLib::Position;


using QuantLib::Futures;
using QuantLib::OvernightIndexFuture;


using QuantLib::Pillar;
using QuantLib::RateHelper;
using QuantLib::DepositRateHelper;
using QuantLib::FraRateHelper;
using QuantLib::FuturesRateHelper;
using QuantLib::SwapRateHelper;
using QuantLib::BondHelper;
using QuantLib::FixedRateBondHelper;
using QuantLib::OISRateHelper;
using QuantLib::DatedOISRateHelper;
using QuantLib::FxSwapRateHelper;
using QuantLib::OvernightIndexFutureRateHelper;
using QuantLib::SofrFutureRateHelper;
using QuantLib::CrossCurrencyBasisSwapRateHelper;
using QuantLib::ConstNotionalCrossCurrencyBasisSwapRateHelper;
using QuantLib::MtMCrossCurrencyBasisSwapRateHelper;
using QuantLib::IborIborBasisSwapRateHelper;
using QuantLib::OvernightIborBasisSwapRateHelper;

SWIGINTERN std::vector< ext::shared_ptr< RateHelper > > *new_std_vector_Sl_ext_shared_ptr_Sl_RateHelper_Sg__Sg___SWIG_2(jint count,ext::shared_ptr< RateHelper > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< RateHelper > >(static_cast<std::vector< ext::shared_ptr< RateHelper > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_RateHelper_Sg__Sg__doSize(std::vector< ext::shared_ptr< RateHelper > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_RateHelper_Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< RateHelper > > *self,std::vector< ext::shared_ptr< RateHelper > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_RateHelper_Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< RateHelper > > *self,jint index,std::vector< ext::shared_ptr< RateHelper > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< RateHelper > >::value_type std_vector_Sl_ext_shared_ptr_Sl_RateHelper_Sg__Sg__doRemove(std::vector< ext::shared_ptr< RateHelper > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< RateHelper > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< RateHelper > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_RateHelper_Sg__Sg__doGet(std::vector< ext::shared_ptr< RateHelper > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< RateHelper > >::value_type std_vector_Sl_ext_shared_ptr_Sl_RateHelper_Sg__Sg__doSet(std::vector< ext::shared_ptr< RateHelper > > *self,jint index,std::vector< ext::shared_ptr< RateHelper > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< RateHelper > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_RateHelper_Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< RateHelper > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< BondHelper > > *new_std_vector_Sl_ext_shared_ptr_Sl_BondHelper_Sg__Sg___SWIG_2(jint count,ext::shared_ptr< BondHelper > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< BondHelper > >(static_cast<std::vector< ext::shared_ptr< BondHelper > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_BondHelper_Sg__Sg__doSize(std::vector< ext::shared_ptr< BondHelper > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_BondHelper_Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< BondHelper > > *self,std::vector< ext::shared_ptr< BondHelper > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_BondHelper_Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< BondHelper > > *self,jint index,std::vector< ext::shared_ptr< BondHelper > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< BondHelper > >::value_type std_vector_Sl_ext_shared_ptr_Sl_BondHelper_Sg__Sg__doRemove(std::vector< ext::shared_ptr< BondHelper > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< BondHelper > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< BondHelper > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_BondHelper_Sg__Sg__doGet(std::vector< ext::shared_ptr< BondHelper > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< BondHelper > >::value_type std_vector_Sl_ext_shared_ptr_Sl_BondHelper_Sg__Sg__doSet(std::vector< ext::shared_ptr< BondHelper > > *self,jint index,std::vector< ext::shared_ptr< BondHelper > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< BondHelper > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_BondHelper_Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< BondHelper > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

    const ext::shared_ptr<DepositRateHelper> as_depositratehelper(const ext::shared_ptr<RateHelper> helper) {
        return ext::dynamic_pointer_cast<DepositRateHelper>(helper);
    }
	const ext::shared_ptr<FraRateHelper> as_fraratehelper(const ext::shared_ptr<RateHelper> helper) {
        return ext::dynamic_pointer_cast<FraRateHelper>(helper);
    }
    const ext::shared_ptr<SwapRateHelper> as_swapratehelper(const ext::shared_ptr<RateHelper> helper) {
        return ext::dynamic_pointer_cast<SwapRateHelper>(helper);
    }
    const ext::shared_ptr<OISRateHelper> as_oisratehelper(const ext::shared_ptr<RateHelper> helper) {
        return ext::dynamic_pointer_cast<OISRateHelper>(helper);
    }
    const ext::shared_ptr<CrossCurrencyBasisSwapRateHelper> as_crosscurrencybasisswapratehelper(
            const ext::shared_ptr<RateHelper> helper) {
        return ext::dynamic_pointer_cast<CrossCurrencyBasisSwapRateHelper>(helper);
    }
    const ext::shared_ptr<ConstNotionalCrossCurrencyBasisSwapRateHelper> as_constnotionalcrosscurrencybasisswapratehelper(
            const ext::shared_ptr<RateHelper> helper) {
        return ext::dynamic_pointer_cast<ConstNotionalCrossCurrencyBasisSwapRateHelper>(helper);
    }
    const ext::shared_ptr<MtMCrossCurrencyBasisSwapRateHelper> as_mtmcrosscurrencybasisswapratehelper(
            const ext::shared_ptr<RateHelper> helper) {
        return ext::dynamic_pointer_cast<MtMCrossCurrencyBasisSwapRateHelper>(helper);
    }


using QuantLib::Discount;
using QuantLib::ZeroYield;
using QuantLib::ForwardRate;


using QuantLib::PiecewiseYieldCurve;


struct _IterativeBootstrap {
    double accuracy, minValue, maxValue;
    _IterativeBootstrap(double accuracy = Null<double>(),
                        double minValue = Null<double>(),
                        double maxValue = Null<double>())
    : accuracy(accuracy), minValue(minValue), maxValue(maxValue) {}
};


typedef PiecewiseYieldCurve<ForwardRate, BackwardFlat> PiecewiseFlatForward;

SWIGINTERN PiecewiseFlatForward *new_PiecewiseFlatForward__SWIG_0(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),BackwardFlat const &i=BackwardFlat(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseFlatForward(referenceDate, instruments, dayCounter, jumps, jumpDates,
                            i, PiecewiseFlatForward::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseFlatForward *new_PiecewiseFlatForward__SWIG_5(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),BackwardFlat const &i=BackwardFlat(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseFlatForward(settlementDays, calendar, instruments, dayCounter,
                            jumps, jumpDates, BackwardFlat(),
                            PiecewiseFlatForward::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseFlatForward *new_PiecewiseFlatForward__SWIG_10(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseFlatForward(referenceDate, instruments, dayCounter, BackwardFlat(),
                            PiecewiseFlatForward::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseFlatForward *new_PiecewiseFlatForward__SWIG_11(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseFlatForward(settlementDays, calendar, instruments, dayCounter,
                            BackwardFlat(), PiecewiseFlatForward::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }

typedef PiecewiseYieldCurve<Discount, LogLinear> PiecewiseLogLinearDiscount;

SWIGINTERN PiecewiseLogLinearDiscount *new_PiecewiseLogLinearDiscount__SWIG_0(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),LogLinear const &i=LogLinear(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseLogLinearDiscount(referenceDate, instruments, dayCounter, jumps, jumpDates,
                            i, PiecewiseLogLinearDiscount::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseLogLinearDiscount *new_PiecewiseLogLinearDiscount__SWIG_5(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),LogLinear const &i=LogLinear(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseLogLinearDiscount(settlementDays, calendar, instruments, dayCounter,
                            jumps, jumpDates, LogLinear(),
                            PiecewiseLogLinearDiscount::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseLogLinearDiscount *new_PiecewiseLogLinearDiscount__SWIG_10(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseLogLinearDiscount(referenceDate, instruments, dayCounter, LogLinear(),
                            PiecewiseLogLinearDiscount::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseLogLinearDiscount *new_PiecewiseLogLinearDiscount__SWIG_11(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseLogLinearDiscount(settlementDays, calendar, instruments, dayCounter,
                            LogLinear(), PiecewiseLogLinearDiscount::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }

typedef PiecewiseYieldCurve<ForwardRate, Linear> PiecewiseLinearForward;

SWIGINTERN PiecewiseLinearForward *new_PiecewiseLinearForward__SWIG_0(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),Linear const &i=Linear(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseLinearForward(referenceDate, instruments, dayCounter, jumps, jumpDates,
                            i, PiecewiseLinearForward::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseLinearForward *new_PiecewiseLinearForward__SWIG_5(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),Linear const &i=Linear(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseLinearForward(settlementDays, calendar, instruments, dayCounter,
                            jumps, jumpDates, Linear(),
                            PiecewiseLinearForward::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseLinearForward *new_PiecewiseLinearForward__SWIG_10(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseLinearForward(referenceDate, instruments, dayCounter, Linear(),
                            PiecewiseLinearForward::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseLinearForward *new_PiecewiseLinearForward__SWIG_11(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseLinearForward(settlementDays, calendar, instruments, dayCounter,
                            Linear(), PiecewiseLinearForward::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }

typedef PiecewiseYieldCurve<ZeroYield, Linear> PiecewiseLinearZero;

SWIGINTERN PiecewiseLinearZero *new_PiecewiseLinearZero__SWIG_0(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),Linear const &i=Linear(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseLinearZero(referenceDate, instruments, dayCounter, jumps, jumpDates,
                            i, PiecewiseLinearZero::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseLinearZero *new_PiecewiseLinearZero__SWIG_5(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),Linear const &i=Linear(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseLinearZero(settlementDays, calendar, instruments, dayCounter,
                            jumps, jumpDates, Linear(),
                            PiecewiseLinearZero::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseLinearZero *new_PiecewiseLinearZero__SWIG_10(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseLinearZero(referenceDate, instruments, dayCounter, Linear(),
                            PiecewiseLinearZero::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseLinearZero *new_PiecewiseLinearZero__SWIG_11(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseLinearZero(settlementDays, calendar, instruments, dayCounter,
                            Linear(), PiecewiseLinearZero::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }

typedef PiecewiseYieldCurve<ZeroYield, Cubic> PiecewiseCubicZero;

SWIGINTERN PiecewiseCubicZero *new_PiecewiseCubicZero__SWIG_0(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),Cubic const &i=Cubic(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseCubicZero(referenceDate, instruments, dayCounter, jumps, jumpDates,
                            i, PiecewiseCubicZero::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseCubicZero *new_PiecewiseCubicZero__SWIG_5(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),Cubic const &i=Cubic(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseCubicZero(settlementDays, calendar, instruments, dayCounter,
                            jumps, jumpDates, Cubic(),
                            PiecewiseCubicZero::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseCubicZero *new_PiecewiseCubicZero__SWIG_10(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseCubicZero(referenceDate, instruments, dayCounter, Cubic(),
                            PiecewiseCubicZero::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseCubicZero *new_PiecewiseCubicZero__SWIG_11(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseCubicZero(settlementDays, calendar, instruments, dayCounter,
                            Cubic(), PiecewiseCubicZero::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }

typedef PiecewiseYieldCurve<Discount, MonotonicLogCubic> PiecewiseLogCubicDiscount;

SWIGINTERN PiecewiseLogCubicDiscount *new_PiecewiseLogCubicDiscount__SWIG_0(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),MonotonicLogCubic const &i=MonotonicLogCubic(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseLogCubicDiscount(referenceDate, instruments, dayCounter, jumps, jumpDates,
                            i, PiecewiseLogCubicDiscount::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseLogCubicDiscount *new_PiecewiseLogCubicDiscount__SWIG_5(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),MonotonicLogCubic const &i=MonotonicLogCubic(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseLogCubicDiscount(settlementDays, calendar, instruments, dayCounter,
                            jumps, jumpDates, MonotonicLogCubic(),
                            PiecewiseLogCubicDiscount::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseLogCubicDiscount *new_PiecewiseLogCubicDiscount__SWIG_10(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseLogCubicDiscount(referenceDate, instruments, dayCounter, MonotonicLogCubic(),
                            PiecewiseLogCubicDiscount::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseLogCubicDiscount *new_PiecewiseLogCubicDiscount__SWIG_11(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseLogCubicDiscount(settlementDays, calendar, instruments, dayCounter,
                            MonotonicLogCubic(), PiecewiseLogCubicDiscount::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }

typedef PiecewiseYieldCurve<Discount, SplineCubic> PiecewiseSplineCubicDiscount;

SWIGINTERN PiecewiseSplineCubicDiscount *new_PiecewiseSplineCubicDiscount__SWIG_0(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),SplineCubic const &i=SplineCubic(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseSplineCubicDiscount(referenceDate, instruments, dayCounter, jumps, jumpDates,
                            i, PiecewiseSplineCubicDiscount::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseSplineCubicDiscount *new_PiecewiseSplineCubicDiscount__SWIG_5(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),SplineCubic const &i=SplineCubic(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseSplineCubicDiscount(settlementDays, calendar, instruments, dayCounter,
                            jumps, jumpDates, SplineCubic(),
                            PiecewiseSplineCubicDiscount::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseSplineCubicDiscount *new_PiecewiseSplineCubicDiscount__SWIG_10(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseSplineCubicDiscount(referenceDate, instruments, dayCounter, SplineCubic(),
                            PiecewiseSplineCubicDiscount::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseSplineCubicDiscount *new_PiecewiseSplineCubicDiscount__SWIG_11(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseSplineCubicDiscount(settlementDays, calendar, instruments, dayCounter,
                            SplineCubic(), PiecewiseSplineCubicDiscount::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }

typedef PiecewiseYieldCurve<ZeroYield, Kruger> PiecewiseKrugerZero;

SWIGINTERN PiecewiseKrugerZero *new_PiecewiseKrugerZero__SWIG_0(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),Kruger const &i=Kruger(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseKrugerZero(referenceDate, instruments, dayCounter, jumps, jumpDates,
                            i, PiecewiseKrugerZero::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseKrugerZero *new_PiecewiseKrugerZero__SWIG_5(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),Kruger const &i=Kruger(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseKrugerZero(settlementDays, calendar, instruments, dayCounter,
                            jumps, jumpDates, Kruger(),
                            PiecewiseKrugerZero::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseKrugerZero *new_PiecewiseKrugerZero__SWIG_10(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseKrugerZero(referenceDate, instruments, dayCounter, Kruger(),
                            PiecewiseKrugerZero::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseKrugerZero *new_PiecewiseKrugerZero__SWIG_11(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseKrugerZero(settlementDays, calendar, instruments, dayCounter,
                            Kruger(), PiecewiseKrugerZero::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }

typedef PiecewiseYieldCurve<Discount, KrugerLog> PiecewiseKrugerLogDiscount;

SWIGINTERN PiecewiseKrugerLogDiscount *new_PiecewiseKrugerLogDiscount__SWIG_0(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),KrugerLog const &i=KrugerLog(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseKrugerLogDiscount(referenceDate, instruments, dayCounter, jumps, jumpDates,
                            i, PiecewiseKrugerLogDiscount::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseKrugerLogDiscount *new_PiecewiseKrugerLogDiscount__SWIG_5(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),KrugerLog const &i=KrugerLog(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseKrugerLogDiscount(settlementDays, calendar, instruments, dayCounter,
                            jumps, jumpDates, KrugerLog(),
                            PiecewiseKrugerLogDiscount::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseKrugerLogDiscount *new_PiecewiseKrugerLogDiscount__SWIG_10(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseKrugerLogDiscount(referenceDate, instruments, dayCounter, KrugerLog(),
                            PiecewiseKrugerLogDiscount::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseKrugerLogDiscount *new_PiecewiseKrugerLogDiscount__SWIG_11(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseKrugerLogDiscount(settlementDays, calendar, instruments, dayCounter,
                            KrugerLog(), PiecewiseKrugerLogDiscount::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }

typedef PiecewiseYieldCurve<ZeroYield, ConvexMonotone> PiecewiseConvexMonotoneZero;

SWIGINTERN PiecewiseConvexMonotoneZero *new_PiecewiseConvexMonotoneZero__SWIG_0(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),ConvexMonotone const &i=ConvexMonotone(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseConvexMonotoneZero(referenceDate, instruments, dayCounter, jumps, jumpDates,
                            i, PiecewiseConvexMonotoneZero::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseConvexMonotoneZero *new_PiecewiseConvexMonotoneZero__SWIG_5(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),ConvexMonotone const &i=ConvexMonotone(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseConvexMonotoneZero(settlementDays, calendar, instruments, dayCounter,
                            jumps, jumpDates, ConvexMonotone(),
                            PiecewiseConvexMonotoneZero::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseConvexMonotoneZero *new_PiecewiseConvexMonotoneZero__SWIG_10(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseConvexMonotoneZero(referenceDate, instruments, dayCounter, ConvexMonotone(),
                            PiecewiseConvexMonotoneZero::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseConvexMonotoneZero *new_PiecewiseConvexMonotoneZero__SWIG_11(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseConvexMonotoneZero(settlementDays, calendar, instruments, dayCounter,
                            ConvexMonotone(), PiecewiseConvexMonotoneZero::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }

typedef PiecewiseYieldCurve<ZeroYield, SplineCubic> PiecewiseNaturalCubicZero;

SWIGINTERN PiecewiseNaturalCubicZero *new_PiecewiseNaturalCubicZero__SWIG_0(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),SplineCubic const &i=SplineCubic(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseNaturalCubicZero(referenceDate, instruments, dayCounter, jumps, jumpDates,
                            i, PiecewiseNaturalCubicZero::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseNaturalCubicZero *new_PiecewiseNaturalCubicZero__SWIG_5(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),SplineCubic const &i=SplineCubic(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseNaturalCubicZero(settlementDays, calendar, instruments, dayCounter,
                            jumps, jumpDates, SplineCubic(),
                            PiecewiseNaturalCubicZero::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseNaturalCubicZero *new_PiecewiseNaturalCubicZero__SWIG_10(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseNaturalCubicZero(referenceDate, instruments, dayCounter, SplineCubic(),
                            PiecewiseNaturalCubicZero::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseNaturalCubicZero *new_PiecewiseNaturalCubicZero__SWIG_11(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseNaturalCubicZero(settlementDays, calendar, instruments, dayCounter,
                            SplineCubic(), PiecewiseNaturalCubicZero::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }

typedef PiecewiseYieldCurve<Discount, SplineLogCubic> PiecewiseNaturalLogCubicDiscount;

SWIGINTERN PiecewiseNaturalLogCubicDiscount *new_PiecewiseNaturalLogCubicDiscount__SWIG_0(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),SplineLogCubic const &i=SplineLogCubic(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseNaturalLogCubicDiscount(referenceDate, instruments, dayCounter, jumps, jumpDates,
                            i, PiecewiseNaturalLogCubicDiscount::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseNaturalLogCubicDiscount *new_PiecewiseNaturalLogCubicDiscount__SWIG_5(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),SplineLogCubic const &i=SplineLogCubic(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseNaturalLogCubicDiscount(settlementDays, calendar, instruments, dayCounter,
                            jumps, jumpDates, SplineLogCubic(),
                            PiecewiseNaturalLogCubicDiscount::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseNaturalLogCubicDiscount *new_PiecewiseNaturalLogCubicDiscount__SWIG_10(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseNaturalLogCubicDiscount(referenceDate, instruments, dayCounter, SplineLogCubic(),
                            PiecewiseNaturalLogCubicDiscount::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseNaturalLogCubicDiscount *new_PiecewiseNaturalLogCubicDiscount__SWIG_11(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseNaturalLogCubicDiscount(settlementDays, calendar, instruments, dayCounter,
                            SplineLogCubic(), PiecewiseNaturalLogCubicDiscount::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }

class AdditionalErrors {
    std::vector<ext::shared_ptr<RateHelper> > additionalHelpers_;
  public:
    AdditionalErrors(const std::vector<ext::shared_ptr<RateHelper> >& additionalHelpers)
    : additionalHelpers_(additionalHelpers) {}
    Array operator()() const {
        Array errors(additionalHelpers_.size() - 2);
        Real a = additionalHelpers_.front()->impliedQuote();
        Real b = additionalHelpers_.back()->impliedQuote();
        for (Size k = 0; k < errors.size(); ++k) {
            errors[k] = (static_cast<Real>(errors.size()-k) * a + static_cast<Real>(1+k) * b) / static_cast<Real>(errors.size()+1)
                - additionalHelpers_.at(1+k)->impliedQuote();
        }
        return errors;
    }
};

class AdditionalDates {
    std::vector<Date> additionalDates_;
  public:
    AdditionalDates(const std::vector<Date>& additionalDates)
    : additionalDates_(additionalDates) {}
    std::vector<Date> operator()() const {
        return additionalDates_;
    }
};

struct _GlobalBootstrap {
    std::vector<ext::shared_ptr<RateHelper> > additionalHelpers;
    std::vector<Date> additionalDates;
    double accuracy;
    _GlobalBootstrap(double accuracy = Null<double>())
    : accuracy(accuracy) {}
   _GlobalBootstrap(const std::vector<ext::shared_ptr<RateHelper> >& additionalHelpers,
                     const std::vector<Date>& additionalDates,
                     double accuracy = Null<double>())
    : additionalHelpers(additionalHelpers), additionalDates(additionalDates), accuracy(accuracy) {}
};


using QuantLib::SimpleZeroYield;
typedef PiecewiseYieldCurve<SimpleZeroYield, Linear, QuantLib::GlobalBootstrap>
    GlobalLinearSimpleZeroCurve;

SWIGINTERN GlobalLinearSimpleZeroCurve *new_GlobalLinearSimpleZeroCurve(Date const &referenceDate,std::vector< ext::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,_GlobalBootstrap const &b){
            if (b.additionalHelpers.empty()) {
                return new GlobalLinearSimpleZeroCurve(
                    referenceDate, instruments, dayCounter, Linear(),
                    GlobalLinearSimpleZeroCurve::bootstrap_type(b.accuracy));
            } else {
                return new GlobalLinearSimpleZeroCurve(
                    referenceDate, instruments, dayCounter, Linear(),
                    GlobalLinearSimpleZeroCurve::bootstrap_type(b.additionalHelpers,
                                                                AdditionalDates(b.additionalDates),
                                                                AdditionalErrors(b.additionalHelpers),
                                                                b.accuracy));
            }
        }

using QuantLib::DefaultProbabilityTermStructure;

SWIGINTERN ext::shared_ptr< Observable > Handle_Sl_DefaultProbabilityTermStructure_Sg__asObservable(Handle< DefaultProbabilityTermStructure > *self){
        return ext::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_DefaultProbabilityTermStructure_Sg__reset(RelinkableHandle< DefaultProbabilityTermStructure > *self){
            self->linkTo(ext::shared_ptr<DefaultProbabilityTermStructure>());
        }

using QuantLib::FlatHazardRate;


using QuantLib::InterpolatedHazardRateCurve;


using QuantLib::InterpolatedDefaultDensityCurve;


using QuantLib::InterpolatedSurvivalProbabilityCurve;


using QuantLib::DefaultProbabilityHelper;
using QuantLib::SpreadCdsHelper;
using QuantLib::UpfrontCdsHelper;

SWIGINTERN std::vector< ext::shared_ptr< DefaultProbabilityHelper > > *new_std_vector_Sl_ext_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg___SWIG_2(jint count,ext::shared_ptr< DefaultProbabilityHelper > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< DefaultProbabilityHelper > >(static_cast<std::vector< ext::shared_ptr< DefaultProbabilityHelper > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__doSize(std::vector< ext::shared_ptr< DefaultProbabilityHelper > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< DefaultProbabilityHelper > > *self,std::vector< ext::shared_ptr< DefaultProbabilityHelper > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< DefaultProbabilityHelper > > *self,jint index,std::vector< ext::shared_ptr< DefaultProbabilityHelper > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< DefaultProbabilityHelper > >::value_type std_vector_Sl_ext_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__doRemove(std::vector< ext::shared_ptr< DefaultProbabilityHelper > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< DefaultProbabilityHelper > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< DefaultProbabilityHelper > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__doGet(std::vector< ext::shared_ptr< DefaultProbabilityHelper > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< DefaultProbabilityHelper > >::value_type std_vector_Sl_ext_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__doSet(std::vector< ext::shared_ptr< DefaultProbabilityHelper > > *self,jint index,std::vector< ext::shared_ptr< DefaultProbabilityHelper > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< DefaultProbabilityHelper > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< DefaultProbabilityHelper > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

using QuantLib::HazardRate;
using QuantLib::DefaultDensity;


using QuantLib::PiecewiseDefaultCurve;


typedef PiecewiseDefaultCurve<HazardRate, BackwardFlat> PiecewiseFlatHazardRate;

SWIGINTERN PiecewiseFlatHazardRate *new_PiecewiseFlatHazardRate__SWIG_0(Date const &referenceDate,std::vector< ext::shared_ptr< DefaultProbabilityHelper > > const &instruments,DayCounter const &dayCounter,BackwardFlat const &i=BackwardFlat(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseFlatHazardRate(referenceDate, instruments, dayCounter,
                            i, PiecewiseFlatHazardRate::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseFlatHazardRate *new_PiecewiseFlatHazardRate__SWIG_3(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< DefaultProbabilityHelper > > const &instruments,DayCounter const &dayCounter,BackwardFlat const &i=BackwardFlat(),_IterativeBootstrap const &b=_IterativeBootstrap()){
            return new PiecewiseFlatHazardRate(settlementDays, calendar, instruments, dayCounter,
                            i, PiecewiseFlatHazardRate::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseFlatHazardRate *new_PiecewiseFlatHazardRate__SWIG_6(Date const &referenceDate,std::vector< ext::shared_ptr< DefaultProbabilityHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseFlatHazardRate(referenceDate, instruments, dayCounter,
                            BackwardFlat(), PiecewiseFlatHazardRate::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }
SWIGINTERN PiecewiseFlatHazardRate *new_PiecewiseFlatHazardRate__SWIG_7(Integer settlementDays,Calendar const &calendar,std::vector< ext::shared_ptr< DefaultProbabilityHelper > > const &instruments,DayCounter const &dayCounter,_IterativeBootstrap const &b){
            return new PiecewiseFlatHazardRate(settlementDays, calendar, instruments, dayCounter,
                            BackwardFlat(), PiecewiseFlatHazardRate::bootstrap_type(b.accuracy, b.minValue, b.maxValue));
        }

using QuantLib::RiskyBondEngine;


using QuantLib::Protection;


using QuantLib::CreditDefaultSwap;
using QuantLib::MidPointCdsEngine;
using QuantLib::IntegralCdsEngine;
using QuantLib::IsdaCdsEngine;
using QuantLib::Claim;
using QuantLib::FaceValueClaim;
using QuantLib::FaceValueAccrualClaim;
using QuantLib::CdsOption;
using QuantLib::BlackCdsOptionEngine;

SWIGINTERN doubleOrNull CreditDefaultSwap_upfront(CreditDefaultSwap const *self){
            boost::optional<Rate> result =
                self->upfront();
            if (result)
                return *result;
            else
                return Null<double>();
        }

using QuantLib::InterpolatedDiscountCurve;


using QuantLib::NormalDistribution;
using QuantLib::CumulativeNormalDistribution;
using QuantLib::MoroInverseCumulativeNormal;
using QuantLib::InverseCumulativeNormal;
using QuantLib::BivariateCumulativeNormalDistribution;
using QuantLib::BinomialDistribution;
using QuantLib::CumulativeBinomialDistribution;
using QuantLib::BivariateCumulativeNormalDistributionDr78;
using QuantLib::BivariateCumulativeNormalDistributionWe04DP;
using QuantLib::CumulativeChiSquareDistribution;
using QuantLib::NonCentralCumulativeChiSquareDistribution;
using QuantLib::InverseNonCentralCumulativeChiSquareDistribution;
using QuantLib::CumulativeGammaDistribution;
using QuantLib::GammaFunction;
using QuantLib::PoissonDistribution;
using QuantLib::CumulativePoissonDistribution;
using QuantLib::InverseCumulativePoisson;
using QuantLib::StudentDistribution;
using QuantLib::CumulativeStudentDistribution;
using QuantLib::InverseCumulativeStudent;


using QuantLib::Money;

SWIGINTERN Money Money_operator_Sa___SWIG_1(Money *self,Money const &m){ return *self+m; }
SWIGINTERN Money Money_operator_Ss___SWIG_1(Money *self,Money const &m){ return *self-m; }
SWIGINTERN Money Money_operator_Sm_(Money *self,Decimal x){ return *self*x; }
SWIGINTERN Money Money_operator_Sd___SWIG_0(Money *self,Decimal x){ return *self/x; }
SWIGINTERN Decimal Money_operator_Sd___SWIG_1(Money *self,Money const &m){ return *self/m; }
SWIGINTERN int Money___cmp__(Money *self,Money const &other){
            if (*self < other)
                return -1;
            else if (*self == other)
                return 0;
            else
                return 1;
        }
SWIGINTERN std::string Money___str__(Money *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN void Money_setConversionType(Money::ConversionType type){
            Money::Settings::instance().conversionType() = type;
        }
SWIGINTERN void Money_setBaseCurrency(Currency const &c){
            Money::Settings::instance().baseCurrency() = c;
        }

using QuantLib::ExchangeRate;
using QuantLib::ExchangeRateManager;


using QuantLib::Settings;

SWIGINTERN Date Settings_getEvaluationDate(Settings *self){
            return self->evaluationDate();
        }
SWIGINTERN void Settings_setEvaluationDate(Settings *self,Date const &d){
            self->evaluationDate() = d;
        }
SWIGINTERN void Settings_includeReferenceDateEvents(Settings *self,bool b){
            self->includeReferenceDateEvents() = b;
        }
SWIGINTERN void Settings_includeTodaysCashFlows(Settings *self,bool b){
            self->includeTodaysCashFlows() = b;
        }
SWIGINTERN void Settings_setEnforcesTodaysHistoricFixings(Settings *self,bool b){
            self->enforcesTodaysHistoricFixings() = b;
        }
SWIGINTERN bool Settings_getEnforcesTodaysHistoricFixings(Settings *self){
            return self->enforcesTodaysHistoricFixings();
        }

using QuantLib::Fdm1dMesher;
using QuantLib::FdmBlackScholesMesher;
using QuantLib::Concentrating1dMesher;
using QuantLib::ExponentialJump1dMesher;
using QuantLib::FdmQuantoHelper;
using QuantLib::FdmCEV1dMesher;
using QuantLib::FdmHestonVarianceMesher;
using QuantLib::FdmHestonLocalVolatilityVarianceMesher;
using QuantLib::Uniform1dMesher;
using QuantLib::FdmSimpleProcess1dMesher;
using QuantLib::Predefined1dMesher;
using QuantLib::Glued1dMesher;

SWIGINTERN std::vector< ext::shared_ptr< Fdm1dMesher > > *new_std_vector_Sl_ext_shared_ptr_Sl_Fdm1dMesher_Sg__Sg___SWIG_2(jint count,ext::shared_ptr< Fdm1dMesher > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< Fdm1dMesher > >(static_cast<std::vector< ext::shared_ptr< Fdm1dMesher > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_Fdm1dMesher_Sg__Sg__doSize(std::vector< ext::shared_ptr< Fdm1dMesher > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_Fdm1dMesher_Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< Fdm1dMesher > > *self,std::vector< ext::shared_ptr< Fdm1dMesher > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_Fdm1dMesher_Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< Fdm1dMesher > > *self,jint index,std::vector< ext::shared_ptr< Fdm1dMesher > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< Fdm1dMesher > >::value_type std_vector_Sl_ext_shared_ptr_Sl_Fdm1dMesher_Sg__Sg__doRemove(std::vector< ext::shared_ptr< Fdm1dMesher > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< Fdm1dMesher > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< Fdm1dMesher > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_Fdm1dMesher_Sg__Sg__doGet(std::vector< ext::shared_ptr< Fdm1dMesher > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< Fdm1dMesher > >::value_type std_vector_Sl_ext_shared_ptr_Sl_Fdm1dMesher_Sg__Sg__doSet(std::vector< ext::shared_ptr< Fdm1dMesher > > *self,jint index,std::vector< ext::shared_ptr< Fdm1dMesher > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< Fdm1dMesher > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_Fdm1dMesher_Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< Fdm1dMesher > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN double ext_tuple_Sl_Real_Sc_Real_Sc_bool_Sg__first(ext::tuple< Real,Real,bool > const *self){
        return ext::get<0>(*self);
      }
SWIGINTERN double ext_tuple_Sl_Real_Sc_Real_Sc_bool_Sg__second(ext::tuple< Real,Real,bool > const *self){
        return ext::get<1>(*self);
      }
SWIGINTERN bool ext_tuple_Sl_Real_Sc_Real_Sc_bool_Sg__third(ext::tuple< Real,Real,bool > const *self){
        return ext::get<2>(*self);
      }
SWIGINTERN std::vector< ext::tuple< Real,Real,bool > > *new_std_vector_Sl_ext_tuple_Sl_Real_Sc_Real_Sc_bool_Sg__Sg___SWIG_2(jint count,ext::tuple< Real,Real,bool > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::tuple< Real,Real,bool > >(static_cast<std::vector< ext::tuple< Real,Real,bool > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_tuple_Sl_Real_Sc_Real_Sc_bool_Sg__Sg__doSize(std::vector< ext::tuple< Real,Real,bool > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_tuple_Sl_Real_Sc_Real_Sc_bool_Sg__Sg__doAdd__SWIG_0(std::vector< ext::tuple< Real,Real,bool > > *self,std::vector< ext::tuple< double,double,bool > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_tuple_Sl_Real_Sc_Real_Sc_bool_Sg__Sg__doAdd__SWIG_1(std::vector< ext::tuple< Real,Real,bool > > *self,jint index,std::vector< ext::tuple< double,double,bool > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::tuple< double,double,bool > >::value_type std_vector_Sl_ext_tuple_Sl_Real_Sc_Real_Sc_bool_Sg__Sg__doRemove(std::vector< ext::tuple< Real,Real,bool > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::tuple< Real,Real,bool > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::tuple< double,double,bool > >::value_type const &std_vector_Sl_ext_tuple_Sl_Real_Sc_Real_Sc_bool_Sg__Sg__doGet(std::vector< ext::tuple< Real,Real,bool > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::tuple< double,double,bool > >::value_type std_vector_Sl_ext_tuple_Sl_Real_Sc_Real_Sc_bool_Sg__Sg__doSet(std::vector< ext::tuple< Real,Real,bool > > *self,jint index,std::vector< ext::tuple< double,double,bool > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::tuple< Real,Real,bool > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_tuple_Sl_Real_Sc_Real_Sc_bool_Sg__Sg__doRemoveRange(std::vector< ext::tuple< Real,Real,bool > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

using QuantLib::FdmLinearOpIterator;
using QuantLib::FdmLinearOpLayout;
using QuantLib::FdmMesher;
using QuantLib::FdmMesherComposite;

SWIGINTERN FdmLinearOpIterator *new_FdmLinearOpIterator__SWIG_0(std::vector< unsigned int > const &dim){
            return new FdmLinearOpIterator(to_vector<Size>(dim));
        }
SWIGINTERN FdmLinearOpIterator *new_FdmLinearOpIterator__SWIG_1(std::vector< unsigned int > const &dim,std::vector< unsigned int > const &coordinates,Size index){
            return new FdmLinearOpIterator(to_vector<Size>(dim),
                                           to_vector<Size>(coordinates),
                                           index);
        }
SWIGINTERN std::vector< unsigned int > FdmLinearOpIterator_coordinates(FdmLinearOpIterator *self){
            return to_vector<unsigned int>(self->coordinates());
        }
SWIGINTERN void FdmLinearOpIterator_increment(FdmLinearOpIterator *self){
            ++(*self);
        }
SWIGINTERN bool FdmLinearOpIterator_notEqual(FdmLinearOpIterator *self,FdmLinearOpIterator const &iterator){
            return self->operator!=(iterator);
        }
SWIGINTERN FdmLinearOpLayout *new_FdmLinearOpLayout(std::vector< unsigned int > const &dim){
            return new FdmLinearOpLayout(to_vector<Size>(dim));
        }
SWIGINTERN std::vector< unsigned int > FdmLinearOpLayout_spacing(FdmLinearOpLayout *self){
            return to_vector<unsigned int>(self->spacing());
        }
SWIGINTERN std::vector< unsigned int > FdmLinearOpLayout_dim(FdmLinearOpLayout const *self){
            return to_vector<unsigned int>(self->dim());
        }
SWIGINTERN Size FdmLinearOpLayout_index(FdmLinearOpLayout const *self,std::vector< unsigned int > const &coordinates){
            return self->index(to_vector<Size>(coordinates));
        }

using QuantLib::FdmLinearOp;
using QuantLib::FdmLinearOpComposite;


class SparseMatrix {
  public:
    std::vector<unsigned int> row_idx, col_idx;
    std::vector<Real> data;    
};

SWIGINTERN ext::shared_ptr< SparseMatrix > FdmLinearOpComposite_to_sparse_matrix(FdmLinearOpComposite const *self){
            
            ext::shared_ptr<SparseMatrix> a = ext::make_shared<SparseMatrix>();
            
            const QuantLib::SparseMatrix m = self->toMatrix(); 
            
            Size entries(0);
            for (auto iter1 = m.begin1(); iter1 != m.end1(); ++iter1)
                entries+=std::distance(iter1.begin(), iter1.end());
        
            a->row_idx.reserve(entries);
            a->col_idx.reserve(entries);
            a->data.reserve(entries);
            
            for (auto iter1 = m.begin1(); iter1 != m.end1(); ++iter1)
                for (auto iter2 = iter1.begin(); iter2 != iter1.end(); ++iter2) {
                    a->row_idx.push_back(iter1.index1());
                    a->col_idx.push_back(iter2.index2());
                    a->data.push_back(*iter2);
                }
    
            return a;
        }

class FdmLinearOpCompositeDelegate {
  public:
    virtual ~FdmLinearOpCompositeDelegate() {}

    virtual Size size() const {
        QL_FAIL("implementation of FdmLinearOpCompositeDelegate.size is missing");        
    }

    virtual void setTime(Time t1, Time t2) {
        QL_FAIL("implementation of FdmLinearOpCompositeDelegate.setTime is missing");    
    }

    virtual Array apply(const Array& r) const {
        QL_FAIL("implementation of FdmLinearOpCompositeDelegate.apply is missing");    
    }

    virtual Array apply_mixed(const Array& r) const {
        QL_FAIL("implementation of FdmLinearOpCompositeDelegate.apply_mixed is missing");    
    }    
    
    virtual Array apply_direction(Size direction, const Array& r) const {
        QL_FAIL("implementation of FdmLinearOpCompositeDelegate.apply_direction is missing");    
    }

    virtual Array solve_splitting(Size direction, const Array& r, Real s) const {
        QL_FAIL("implementation of FdmLinearOpCompositeDelegate.solve_splitting is missing");        
    }    
    
    virtual Array preconditioner(const Array& r, Real dt) const {
        return solve_splitting(0, r, dt);
    }
};

class FdmLinearOpCompositeProxy : public FdmLinearOpComposite {
  public:
    FdmLinearOpCompositeProxy(FdmLinearOpCompositeDelegate* delegate)
    : delegate_(delegate) {}

    Size size() const { return delegate_->size(); }
    void setTime(Time t1, Time t2) { delegate_->setTime(t1, t2); }

    Array apply(const Array& r) const {
        Array retVal = delegate_->apply(r);
        return retVal;
    }
    Array apply_mixed(const Array& r) const {
        Array retVal = delegate_->apply_mixed(r);
        return retVal;
    }        
    Array apply_direction(Size direction, const Array& r) const {
        Array retVal = delegate_->apply_direction(direction, r);
        return retVal;
    }
    Array solve_splitting(Size direction, const Array& r, Real s) const {
        Array retVal = delegate_->solve_splitting(direction, r, s);
        return retVal;
    }
    Array preconditioner(const Array& r, Real s) const {
        Array retVal = delegate_->preconditioner(r, s);
        return retVal;
    }
               
  private:
      FdmLinearOpCompositeDelegate* const delegate_; 
};


using QuantLib::FdmDiscountDirichletBoundary;
using QuantLib::FdmDirichletBoundary;
using QuantLib::BoundaryCondition;
using QuantLib::FdmTimeDepDirichletBoundary;
using QuantLib::FdmBlackScholesOp;
using QuantLib::Fdm2dBlackScholesOp;
using QuantLib::FdmBatesOp;
using QuantLib::FdmCEVOp;
using QuantLib::FdmG2Op;
using QuantLib::FdmHestonHullWhiteOp;
using QuantLib::FdmHestonOp;
using QuantLib::FdmHullWhiteOp;
using QuantLib::FdmLocalVolFwdOp;
using QuantLib::FdmOrnsteinUhlenbeckOp;
using QuantLib::FdmSabrOp;
using QuantLib::FdmZabrOp;
using QuantLib::FdmDupire1dOp;
using QuantLib::FdmBlackScholesFwdOp;
using QuantLib::FdmHestonFwdOp;
using QuantLib::FdmSquareRootFwdOp;

typedef BoundaryCondition<FdmLinearOp> FdmBoundaryCondition;
typedef std::vector<ext::shared_ptr<FdmBoundaryCondition> > FdmBoundaryConditionSet;

SWIGINTERN std::vector< ext::shared_ptr< FdmBoundaryCondition > > *new_std_vector_Sl_ext_shared_ptr_Sl_FdmBoundaryCondition_Sg__Sg___SWIG_2(jint count,ext::shared_ptr< FdmBoundaryCondition > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< FdmBoundaryCondition > >(static_cast<std::vector< ext::shared_ptr< FdmBoundaryCondition > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_FdmBoundaryCondition_Sg__Sg__doSize(std::vector< ext::shared_ptr< FdmBoundaryCondition > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_FdmBoundaryCondition_Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< FdmBoundaryCondition > > *self,std::vector< ext::shared_ptr< FdmBoundaryCondition > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_FdmBoundaryCondition_Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< FdmBoundaryCondition > > *self,jint index,std::vector< ext::shared_ptr< FdmBoundaryCondition > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< FdmBoundaryCondition > >::value_type std_vector_Sl_ext_shared_ptr_Sl_FdmBoundaryCondition_Sg__Sg__doRemove(std::vector< ext::shared_ptr< FdmBoundaryCondition > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< FdmBoundaryCondition > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< FdmBoundaryCondition > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_FdmBoundaryCondition_Sg__Sg__doGet(std::vector< ext::shared_ptr< FdmBoundaryCondition > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< FdmBoundaryCondition > >::value_type std_vector_Sl_ext_shared_ptr_Sl_FdmBoundaryCondition_Sg__Sg__doSet(std::vector< ext::shared_ptr< FdmBoundaryCondition > > *self,jint index,std::vector< ext::shared_ptr< FdmBoundaryCondition > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< FdmBoundaryCondition > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_FdmBoundaryCondition_Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< FdmBoundaryCondition > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN FdmTimeDepDirichletBoundary *new_FdmTimeDepDirichletBoundary(ext::shared_ptr< FdmMesher > const &mesher,UnaryFunctionDelegate *function,Size direction,FdmTimeDepDirichletBoundary::Side side){

            const ext::function<Real(Real)> f = UnaryFunction(function);
            return new FdmTimeDepDirichletBoundary(
                mesher, f, direction, side);        
         }

using QuantLib::TripleBandLinearOp;
using QuantLib::FirstDerivativeOp;
using QuantLib::SecondDerivativeOp;
using QuantLib::NinePointLinearOp;
using QuantLib::SecondOrderMixedDerivativeOp;
using QuantLib::NthOrderDerivativeOp;


using QuantLib::CraigSneydScheme;
using QuantLib::CrankNicolsonScheme;
using QuantLib::ImplicitEulerScheme;
using QuantLib::DouglasScheme;
using QuantLib::ExplicitEulerScheme;
using QuantLib::HundsdorferScheme;
using QuantLib::MethodOfLinesScheme;
using QuantLib::ModifiedCraigSneydScheme;


using QuantLib::StepCondition;
using QuantLib::FdmSnapshotCondition;
using QuantLib::FdmAmericanStepCondition;
using QuantLib::FdmArithmeticAverageCondition;
using QuantLib::FdmSimpleSwingCondition;
using QuantLib::FdmBermudanStepCondition;
using QuantLib::FdmSimpleStorageCondition;
using QuantLib::FdmSimpleSwingCondition;
using QuantLib::FdmDividendHandler;
using QuantLib::FdmInnerValueCalculator;
using QuantLib::FdmCellAveragingInnerValue;
using QuantLib::FdmLogInnerValue;
using QuantLib::FdmLogBasketInnerValue;
using QuantLib::FdmZeroInnerValue;
using QuantLib::FdmAffineModelSwapInnerValue;
using QuantLib::FdmStepConditionComposite;


class FdmStepConditionDelegate {
  public:
    virtual ~FdmStepConditionDelegate() {}

    virtual void applyTo(Array& a, Time t) const {
        QL_FAIL("implementation of FdmStepCondition.applyTo is missing");        
    }
};

class FdmStepConditionProxy : public StepCondition<Array> {
  public:
    FdmStepConditionProxy(FdmStepConditionDelegate* delegate)
    : delegate_(delegate) {}

    void applyTo(Array& a, Time t) const {
        delegate_->applyTo(a, t);
    }
    
  private:  
      FdmStepConditionDelegate* const delegate_; 
};


class FdmInnerValueCalculatorDelegate {
  public:
    virtual ~FdmInnerValueCalculatorDelegate() {}
      
    virtual Real innerValue(const FdmLinearOpIterator& iter, Time t) {
        QL_FAIL("implementation of FdmInnerValueCalculatorDelegate.innerValue is missing");        
    }
    virtual Real avgInnerValue(const FdmLinearOpIterator& iter, Time t) {
        QL_FAIL("implementation of FdmInnerValueCalculatorDelegate.avgInnerValue is missing");            
    }
};

class FdmInnerValueCalculatorProxy : public FdmInnerValueCalculator {
  public:
    FdmInnerValueCalculatorProxy(FdmInnerValueCalculatorDelegate* delegate)
    : delegate_(delegate) {}

    Real innerValue(const FdmLinearOpIterator& iter, Time t) {
        return delegate_->innerValue(iter, t);
    }
    Real avgInnerValue(const FdmLinearOpIterator& iter, Time t) {
        return delegate_->avgInnerValue(iter, t);
    }
    
  private:  
      FdmInnerValueCalculatorDelegate* const delegate_; 
};

SWIGINTERN FdmCellAveragingInnerValue *new_FdmCellAveragingInnerValue__SWIG_0(ext::shared_ptr< Payoff > const &payoff,ext::shared_ptr< FdmMesher > const &mesher,Size direction,UnaryFunctionDelegate *gridMapping){
            
                UnaryFunction f(gridMapping);
                return new FdmCellAveragingInnerValue(payoff, mesher, direction, f);            
        }
SWIGINTERN FdmCellAveragingInnerValue *new_FdmCellAveragingInnerValue__SWIG_1(ext::shared_ptr< Payoff > const &payoff,ext::shared_ptr< FdmMesher > const &mesher,Size direction){
                return new FdmCellAveragingInnerValue(payoff, mesher, direction);            
        }
SWIGINTERN FdmAffineModelSwapInnerValue< G2 > *new_FdmAffineModelSwapInnerValue_Sl_G2_Sg_(ext::shared_ptr< G2 > const &disModel,ext::shared_ptr< G2 > const &fwdModel,ext::shared_ptr< VanillaSwap > const &swap,std::vector< Time > const &exerciseTimes,std::vector< Date > const &exerciseDates,ext::shared_ptr< FdmMesher > const &mesher,Size direction){

            QL_REQUIRE(exerciseTimes.size() == exerciseDates.size(),
                "different exercise dates and times length");

            std::map<Time, Date> t2d;
            for (Size i=0; i < exerciseTimes.size(); ++i) 
                t2d[ exerciseTimes[i] ] = exerciseDates[i];

            return new FdmAffineModelSwapInnerValue<G2>(
                disModel, fwdModel, swap, t2d, mesher, direction);
        }
SWIGINTERN FdmAffineModelSwapInnerValue< HullWhite > *new_FdmAffineModelSwapInnerValue_Sl_HullWhite_Sg_(ext::shared_ptr< HullWhite > const &disModel,ext::shared_ptr< HullWhite > const &fwdModel,ext::shared_ptr< VanillaSwap > const &swap,std::vector< Time > const &exerciseTimes,std::vector< Date > const &exerciseDates,ext::shared_ptr< FdmMesher > const &mesher,Size direction){

            QL_REQUIRE(exerciseTimes.size() == exerciseDates.size(),
                "different exercise dates and times length");

            std::map<Time, Date> t2d;
            for (Size i=0; i < exerciseTimes.size(); ++i) 
                t2d[ exerciseTimes[i] ] = exerciseDates[i];

            return new FdmAffineModelSwapInnerValue<HullWhite>(
                disModel, fwdModel, swap, t2d, mesher, direction);
        }
SWIGINTERN std::vector< ext::shared_ptr< StepCondition< Array > > > *new_std_vector_Sl_ext_shared_ptr_Sl_StepCondition_Sl_Array_Sg__Sg__Sg___SWIG_2(jint count,ext::shared_ptr< StepCondition< Array > > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< ext::shared_ptr< StepCondition< Array > > >(static_cast<std::vector< ext::shared_ptr< StepCondition< Array > > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_ext_shared_ptr_Sl_StepCondition_Sl_Array_Sg__Sg__Sg__doSize(std::vector< ext::shared_ptr< StepCondition< Array > > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_StepCondition_Sl_Array_Sg__Sg__Sg__doAdd__SWIG_0(std::vector< ext::shared_ptr< StepCondition< Array > > > *self,std::vector< ext::shared_ptr< StepCondition< Array > > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_StepCondition_Sl_Array_Sg__Sg__Sg__doAdd__SWIG_1(std::vector< ext::shared_ptr< StepCondition< Array > > > *self,jint index,std::vector< ext::shared_ptr< StepCondition< Array > > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< StepCondition< Array > > >::value_type std_vector_Sl_ext_shared_ptr_Sl_StepCondition_Sl_Array_Sg__Sg__Sg__doRemove(std::vector< ext::shared_ptr< StepCondition< Array > > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          ext::shared_ptr< StepCondition< Array > > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< ext::shared_ptr< StepCondition< Array > > >::value_type const &std_vector_Sl_ext_shared_ptr_Sl_StepCondition_Sl_Array_Sg__Sg__Sg__doGet(std::vector< ext::shared_ptr< StepCondition< Array > > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< ext::shared_ptr< StepCondition< Array > > >::value_type std_vector_Sl_ext_shared_ptr_Sl_StepCondition_Sl_Array_Sg__Sg__Sg__doSet(std::vector< ext::shared_ptr< StepCondition< Array > > > *self,jint index,std::vector< ext::shared_ptr< StepCondition< Array > > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          ext::shared_ptr< StepCondition< Array > > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_ext_shared_ptr_Sl_StepCondition_Sl_Array_Sg__Sg__Sg__doRemoveRange(std::vector< ext::shared_ptr< StepCondition< Array > > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN FdmStepConditionComposite *new_FdmStepConditionComposite(std::vector< Time > const &stoppingTimes,std::vector< ext::shared_ptr< StepCondition< Array > > > const &conditions){
            return new FdmStepConditionComposite(
                std::list<std::vector<Time> >(1, stoppingTimes), 
                std::list<ext::shared_ptr<StepCondition<Array> > >(
                    conditions.begin(), conditions.end()));
        }

using QuantLib::FdmSolverDesc;
using QuantLib::Fdm1DimSolver;
using QuantLib::FdmBackwardSolver;
using QuantLib::Fdm2dBlackScholesSolver;
using QuantLib::Fdm2DimSolver;
using QuantLib::Fdm3DimSolver;
using QuantLib::FdmG2Solver;
using QuantLib::FdmHestonHullWhiteSolver;
using QuantLib::FdmHestonSolver;
using QuantLib::FdmHullWhiteSolver;
using QuantLib::FdmNdimSolver;

SWIGINTERN FdmSolverDesc *new_FdmSolverDesc(ext::shared_ptr< FdmMesher > const &mesher,FdmBoundaryConditionSet const &bcSet,ext::shared_ptr< FdmStepConditionComposite > const &condition,ext::shared_ptr< FdmInnerValueCalculator > const &calculator,Time maturity,Size timeSteps,Size dampingSteps){
            
            const FdmSolverDesc desc = { 
                mesher, bcSet, condition, calculator, 
                maturity, timeSteps, dampingSteps };
            
            return new FdmSolverDesc(desc);            
        }
SWIGINTERN ext::shared_ptr< FdmMesher > FdmSolverDesc_getMesher(FdmSolverDesc const *self){ return self->mesher; }
SWIGINTERN FdmBoundaryConditionSet const &FdmSolverDesc_getBcSet(FdmSolverDesc const *self){ return self->bcSet; }
SWIGINTERN ext::shared_ptr< FdmStepConditionComposite > FdmSolverDesc_getStepConditions(FdmSolverDesc const *self){ return self->condition; }
SWIGINTERN ext::shared_ptr< FdmInnerValueCalculator > FdmSolverDesc_getCalculator(FdmSolverDesc const *self){ return self->calculator; }
SWIGINTERN Time FdmSolverDesc_getMaturity(FdmSolverDesc const *self){ return self->maturity; }
SWIGINTERN Size FdmSolverDesc_getTimeSteps(FdmSolverDesc const *self){ return self->timeSteps; }
SWIGINTERN Size FdmSolverDesc_getDampingSteps(FdmSolverDesc const *self){ return self->dampingSteps; }
SWIGINTERN Fdm2dBlackScholesSolver *new_Fdm2dBlackScholesSolver__SWIG_0(ext::shared_ptr< GeneralizedBlackScholesProcess > const &p1,ext::shared_ptr< GeneralizedBlackScholesProcess > const &p2,Real const correlation,FdmSolverDesc const &solverDesc,FdmSchemeDesc const &schemeDesc=FdmSchemeDesc::Hundsdorfer(),bool localVol=false,Real illegalLocalVolOverwrite=-Null< Real >()){
                return new Fdm2dBlackScholesSolver(
                    Handle<GeneralizedBlackScholesProcess>(p1), 
                    Handle<GeneralizedBlackScholesProcess>(p2), 
                    correlation, solverDesc, schemeDesc, 
                    localVol, illegalLocalVolOverwrite); 
        }
SWIGINTERN FdmG2Solver *new_FdmG2Solver__SWIG_0(ext::shared_ptr< G2 > const &model,FdmSolverDesc const &solverDesc,FdmSchemeDesc const &schemeDesc=FdmSchemeDesc::Hundsdorfer()){
                return new FdmG2Solver(Handle<G2>(model), solverDesc, schemeDesc);            
        }
SWIGINTERN FdmHestonHullWhiteSolver *new_FdmHestonHullWhiteSolver__SWIG_0(ext::shared_ptr< HestonProcess > const &hestonProcess,ext::shared_ptr< HullWhiteProcess > const &hwProcess,Rate corrEquityShortRate,FdmSolverDesc const &solverDesc,FdmSchemeDesc const &schemeDesc=FdmSchemeDesc::Hundsdorfer()){
                return new FdmHestonHullWhiteSolver(
                    Handle<HestonProcess>(hestonProcess),
                    Handle<HullWhiteProcess>(hwProcess),
                    corrEquityShortRate, solverDesc, schemeDesc);                    
        }
SWIGINTERN FdmHestonSolver *new_FdmHestonSolver__SWIG_0(ext::shared_ptr< HestonProcess > const &process,FdmSolverDesc const &solverDesc,FdmSchemeDesc const &schemeDesc=FdmSchemeDesc::Hundsdorfer(),ext::shared_ptr< FdmQuantoHelper > const &quantoHelper=ext::shared_ptr< FdmQuantoHelper >(),ext::shared_ptr< LocalVolTermStructure > const &leverageFct=ext::shared_ptr< LocalVolTermStructure >()){

                return new FdmHestonSolver(
                    Handle<HestonProcess>(process),
                    solverDesc, schemeDesc, 
                    Handle<FdmQuantoHelper>(quantoHelper), 
                    leverageFct);
        }
SWIGINTERN FdmHullWhiteSolver *new_FdmHullWhiteSolver__SWIG_0(ext::shared_ptr< HullWhite > const &model,FdmSolverDesc const &solverDesc,FdmSchemeDesc const &schemeDesc=FdmSchemeDesc::Hundsdorfer()){
                return new FdmHullWhiteSolver(
                    Handle<HullWhite>(model), solverDesc, schemeDesc);
        }

using QuantLib::FdmIndicesOnBoundary;
using QuantLib::RiskNeutralDensityCalculator;
using QuantLib::BSMRNDCalculator;
using QuantLib::CEVRNDCalculator;
using QuantLib::GBSMRNDCalculator;
using QuantLib::HestonRNDCalculator;
using QuantLib::LocalVolRNDCalculator;
using QuantLib::SquareRootProcessRNDCalculator;

SWIGINTERN std::vector< unsigned int > FdmIndicesOnBoundary_getIndices(FdmIndicesOnBoundary const *self){
            return to_vector<unsigned int>(self->getIndices());
        }
SWIGINTERN std::vector< unsigned int > LocalVolRNDCalculator_rescaleTimeSteps(LocalVolRNDCalculator const *self){
            return to_vector<unsigned int>(self->rescaleTimeSteps());
        }

using QuantLib::FittedBondDiscountCurve;

typedef ext::shared_ptr<YieldTermStructure> FittedBondDiscountCurvePtr;
typedef QuantLib::FittedBondDiscountCurve::FittingMethod FittingMethod;

std::vector<ext::shared_ptr<BondHelper> > convert_bond_helpers(
                 const std::vector<ext::shared_ptr<RateHelper> >& helpers) {
    std::vector<ext::shared_ptr<BondHelper> > result(helpers.size());
    for (Size i=0; i<helpers.size(); ++i)
        result[i] = ext::dynamic_pointer_cast<BondHelper>(helpers[i]);
    return result;
}


using QuantLib::ExponentialSplinesFitting;
using QuantLib::NelsonSiegelFitting;
using QuantLib::SvenssonFitting;
using QuantLib::CubicBSplinesFitting;
using QuantLib::SimplePolynomialFitting;
using QuantLib::SpreadFittingMethod;


using QuantLib::InterpolatedForwardCurve;


using QuantLib::Position;
using QuantLib::ForwardRateAgreement;


using QuantLib::Gaussian1dModel;


using QuantLib::Gsr;
using QuantLib::MarkovFunctional;


using QuantLib::Gaussian1dSwaptionEngine;
using QuantLib::Gaussian1dJamshidianSwaptionEngine;
using QuantLib::Gaussian1dNonstandardSwaptionEngine;
using QuantLib::Gaussian1dFloatFloatSwaptionEngine;


using QuantLib::SegmentIntegral;
using QuantLib::TrapezoidIntegral;
using QuantLib::Default;
using QuantLib::MidPoint;
using QuantLib::SimpsonIntegral;
using QuantLib::GaussKronrodAdaptive;
using QuantLib::GaussKronrodNonAdaptive;
using QuantLib::GaussLobattoIntegral;
using QuantLib::GaussLaguerreIntegration;
using QuantLib::GaussHermiteIntegration;
using QuantLib::GaussJacobiIntegration;
using QuantLib::GaussHyperbolicIntegration;
using QuantLib::GaussLegendreIntegration;
using QuantLib::GaussChebyshevIntegration;
using QuantLib::GaussChebyshev2ndIntegration;
using QuantLib::GaussGegenbauerIntegration;

SWIGINTERN Real SegmentIntegral_calculate(SegmentIntegral *self,UnaryFunctionDelegate *f,Real a,Real b){
            return (*self)(UnaryFunction(f), a, b);		
        }
SWIGINTERN Real TrapezoidIntegral_Sl_Default_Sg__calculate(TrapezoidIntegral< Default > *self,UnaryFunctionDelegate *f,Real a,Real b){
            return (*self)(UnaryFunction(f), a, b);		
        }
SWIGINTERN Real TrapezoidIntegral_Sl_MidPoint_Sg__calculate(TrapezoidIntegral< MidPoint > *self,UnaryFunctionDelegate *f,Real a,Real b){
            return (*self)(UnaryFunction(f), a, b);		
        }
SWIGINTERN Real SimpsonIntegral_calculate(SimpsonIntegral *self,UnaryFunctionDelegate *f,Real a,Real b){
            return (*self)(UnaryFunction(f), a, b);		
        }
SWIGINTERN Real GaussKronrodAdaptive_calculate(GaussKronrodAdaptive *self,UnaryFunctionDelegate *f,Real a,Real b){
            return (*self)(UnaryFunction(f), a, b);		
        }
SWIGINTERN Real GaussKronrodNonAdaptive_calculate(GaussKronrodNonAdaptive *self,UnaryFunctionDelegate *f,Real a,Real b){
            return (*self)(UnaryFunction(f), a, b);		
        }
SWIGINTERN Real GaussLobattoIntegral_calculate(GaussLobattoIntegral *self,UnaryFunctionDelegate *f,Real a,Real b){
            return (*self)(UnaryFunction(f), a, b);		
        }
SWIGINTERN Real GaussLaguerreIntegration_calculate(GaussLaguerreIntegration *self,UnaryFunctionDelegate *f){
            return (*self)(UnaryFunction(f));		
        }
SWIGINTERN Real GaussHermiteIntegration_calculate(GaussHermiteIntegration *self,UnaryFunctionDelegate *f){
            return (*self)(UnaryFunction(f));		
        }
SWIGINTERN Real GaussJacobiIntegration_calculate(GaussJacobiIntegration *self,UnaryFunctionDelegate *f){
            return (*self)(UnaryFunction(f));		
        }
SWIGINTERN Real GaussHyperbolicIntegration_calculate(GaussHyperbolicIntegration *self,UnaryFunctionDelegate *f){
            return (*self)(UnaryFunction(f));		
        }
SWIGINTERN Real GaussLegendreIntegration_calculate(GaussLegendreIntegration *self,UnaryFunctionDelegate *f){
            return (*self)(UnaryFunction(f));		
        }
SWIGINTERN Real GaussChebyshevIntegration_calculate(GaussChebyshevIntegration *self,UnaryFunctionDelegate *f){
            return (*self)(UnaryFunction(f));		
        }
SWIGINTERN Real GaussChebyshev2ndIntegration_calculate(GaussChebyshev2ndIntegration *self,UnaryFunctionDelegate *f){
            return (*self)(UnaryFunction(f));		
        }
SWIGINTERN Real GaussGegenbauerIntegration_calculate(GaussGegenbauerIntegration *self,UnaryFunctionDelegate *f){
            return (*self)(UnaryFunction(f));		
        }

using QuantLib::ContinuousFloatingLookbackOption;
using QuantLib::ContinuousFixedLookbackOption;
using QuantLib::ContinuousPartialFloatingLookbackOption;
using QuantLib::ContinuousPartialFixedLookbackOption;


using QuantLib::AnalyticContinuousFloatingLookbackEngine;
using QuantLib::AnalyticContinuousFixedLookbackEngine;
using QuantLib::AnalyticContinuousPartialFloatingLookbackEngine;
using QuantLib::AnalyticContinuousPartialFixedLookbackEngine;


using QuantLib::Sample;

using QuantLib::LecuyerUniformRng;
using QuantLib::KnuthUniformRng;
using QuantLib::MersenneTwisterUniformRng;

typedef QuantLib::PseudoRandom::urng_type UniformRandomGenerator;

using QuantLib::CLGaussianRng;
using QuantLib::BoxMullerGaussianRng;
using QuantLib::InverseCumulativeRng;

typedef QuantLib::PseudoRandom::rng_type GaussianRandomGenerator;

using QuantLib::RandomSequenceGenerator;

typedef QuantLib::PseudoRandom::ursg_type UniformRandomSequenceGenerator;
using QuantLib::SobolBrownianGenerator;

using QuantLib::HaltonRsg;
using QuantLib::SobolRsg;
using QuantLib::SobolBrownianBridgeRsg;

typedef QuantLib::LowDiscrepancy::ursg_type
    UniformLowDiscrepancySequenceGenerator;

using QuantLib::InverseCumulativeRsg;

typedef QuantLib::PseudoRandom::rsg_type GaussianRandomSequenceGenerator;
typedef QuantLib::LowDiscrepancy::rsg_type
    GaussianLowDiscrepancySequenceGenerator;

SWIGINTERN double const &Sample_Sl_Real_Sg__value(Sample< Real > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_Real_Sg__weight(Sample< Real > *self){ return self->weight; }
SWIGINTERN Array const &Sample_Sl_Array_Sg__value(Sample< Array > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_Array_Sg__weight(Sample< Array > *self){ return self->weight; }
SWIGINTERN std::vector< double > const &Sample_Sl_std_vector_Sl_Real_Sg__Sg__value(Sample< std::vector< Real > > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_std_vector_Sl_Real_Sg__Sg__weight(Sample< std::vector< Real > > *self){ return self->weight; }
SWIGINTERN Real UniformRandomGenerator_nextValue(UniformRandomGenerator const *self){
			return (*self).next().value;
		}
SWIGINTERN Real GaussianRandomGenerator_nextValue(GaussianRandomGenerator const *self){
			return (*self).next().value;
		}
SWIGINTERN std::vector< unsigned int > SobolRsg_nextInt32Sequence(SobolRsg *self){
          return to_vector<unsigned int>(self->nextInt32Sequence());
      }

Matrix getCovariance(const Array& volatilities, const Matrix& correlations) {
    return QuantLib::getCovariance(volatilities.begin(),
                                   volatilities.end(),
                                   correlations);
}


using QuantLib::Path;

SWIGINTERN Path const &Sample_Sl_Path_Sg__value(Sample< Path > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_Path_Sg__weight(Sample< Path > *self){ return self->weight; }

using QuantLib::PathGenerator;


using QuantLib::MultiPath;

SWIGINTERN MultiPath const &Sample_Sl_MultiPath_Sg__value(Sample< MultiPath > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_MultiPath_Sg__weight(Sample< MultiPath > *self){ return self->weight; }

using QuantLib::MultiPathGenerator;

SWIGINTERN MultiPathGenerator< GaussianRandomSequenceGenerator > *new_MultiPathGenerator_Sl_GaussianRandomSequenceGenerator_Sg___SWIG_2(ext::shared_ptr< StochasticProcess > const &process,std::vector< Time > const &times,GaussianRandomSequenceGenerator const &generator,bool brownianBridge=false){
          return new MultiPathGenerator<GaussianRandomSequenceGenerator>(process,
                                             TimeGrid(
                                                 times.begin(),
                                                 times.end()),
                                             generator,
                                             brownianBridge);
      }
SWIGINTERN MultiPathGenerator< GaussianLowDiscrepancySequenceGenerator > *new_MultiPathGenerator_Sl_GaussianLowDiscrepancySequenceGenerator_Sg___SWIG_2(ext::shared_ptr< StochasticProcess > const &process,std::vector< Time > const &times,GaussianLowDiscrepancySequenceGenerator const &generator,bool brownianBridge=false){
          return new MultiPathGenerator<GaussianLowDiscrepancySequenceGenerator>(process,
                                             TimeGrid(
                                                 times.begin(),
                                                 times.end()),
                                             generator,
                                             brownianBridge);
      }

using QuantLib::BrownianBridge;

SWIGINTERN std::vector< Real > BrownianBridge_transform(BrownianBridge *self,std::vector< Real > const &input){
      std::vector<Real> outp(input.size());
      self->transform(input.begin(),input.end(),outp.begin());
      return outp;
    }
SWIGINTERN std::vector< unsigned int > BrownianBridge_bridgeIndex(BrownianBridge const *self){
        return to_vector<unsigned int>(self->bridgeIndex());
    }
SWIGINTERN std::vector< unsigned int > BrownianBridge_leftIndex(BrownianBridge const *self){
        return to_vector<unsigned int>(self->leftIndex());
    }
SWIGINTERN std::vector< unsigned int > BrownianBridge_rightIndex(BrownianBridge const *self){
        return to_vector<unsigned int>(self->rightIndex());
    }

class OdeFctDelegate {
  public:
    virtual ~OdeFctDelegate() {}
    virtual std::vector<Real> value(
        Real x, const std::vector<Real>& y) const {
                
        QL_FAIL("implementation of OdeFctDelegate.value is missing");
    }
};

class OdeFct {
  public:
    OdeFct(OdeFctDelegate* delegate)
    : delegate_(delegate) { }

    virtual ~OdeFct() { }

    const std::vector<Real> operator()(Real x, const std::vector<Real>& y) const {
        std::vector<Real> retVal = delegate_->value(x, y);
        return retVal;
    }

  private:
    OdeFctDelegate* delegate_;
};


using QuantLib::AdaptiveRungeKutta;

SWIGINTERN double AdaptiveRungeKutta_Sl_Real_Sg__operator_Sp__SP___SWIG_0(AdaptiveRungeKutta< Real > *self,BinaryFunctionDelegate *fct,double y1,Real x1,Real x2){
            BinaryFunction f(fct);
            return self->operator()(f, y1, x1, x2);         
        }
SWIGINTERN std::vector< double > AdaptiveRungeKutta_Sl_Real_Sg__operator_Sp__SP___SWIG_1(AdaptiveRungeKutta< Real > *self,OdeFctDelegate *fct,std::vector< double > const &y1,Real x1,Real x2){            
            OdeFct f(fct);
            return self->operator()(f, y1, x1, x2);
        }

typedef QuantLib::BoundaryCondition<QuantLib::TridiagonalOperator>
        DefaultBoundaryCondition;


using QuantLib::NeumannBC;
using QuantLib::DirichletBC;


using QuantLib::TridiagonalOperator;


using QuantLib::DPlus;
using QuantLib::DMinus;
using QuantLib::DZero;
using QuantLib::DPlusDMinus;


using QuantLib::HestonSLVProcess;


using QuantLib::HestonSLVMCModel;
using QuantLib::BrownianGeneratorFactory;
using QuantLib::MTBrownianGeneratorFactory;
using QuantLib::SobolBrownianGeneratorFactory;

SWIGINTERN HestonSLVMCModel *new_HestonSLVMCModel__SWIG_0(ext::shared_ptr< LocalVolTermStructure > const &localVol,ext::shared_ptr< HestonModel > const &model,ext::shared_ptr< BrownianGeneratorFactory > const &brownianGeneratorFactory,Date const &endDate,Size timeStepsPerYear=365,Size nBins=201,Size calibrationPaths=(1 << 15),std::vector< Date > const &mandatoryDates=std::vector< Date >(),Real mixingFactor=1.0){
            return new HestonSLVMCModel(
                Handle<LocalVolTermStructure>(localVol), Handle<HestonModel>(model),
                brownianGeneratorFactory, endDate, timeStepsPerYear,
                nBins, calibrationPaths, mandatoryDates, mixingFactor);
        }

using QuantLib::FdmHestonGreensFct;
using QuantLib::HestonSLVFDMModel;
using QuantLib::HestonSLVFokkerPlanckFdmParams;

SWIGINTERN HestonSLVFokkerPlanckFdmParams *new_HestonSLVFokkerPlanckFdmParams(Size xGrid,Size vGrid,Size tMaxStepsPerYear,Size tMinStepsPerYear,Real tStepNumberDecay,Size nRannacherTimeSteps,Size predictionCorretionSteps,Real x0Density,Real localVolEpsProb,Size maxIntegrationIterations,Real vLowerEps,Real vUpperEps,Real vMin,Real v0Density,Real vLowerBoundDensity,Real vUpperBoundDensity,Real leverageFctPropEps,FdmHestonGreensFct::Algorithm greensAlgorithm,FdmSquareRootFwdOp::TransformationType trafoType,FdmSchemeDesc schemeDesc){
            
                const HestonSLVFokkerPlanckFdmParams params = {
                    xGrid, vGrid,
                    tMaxStepsPerYear, tMinStepsPerYear,
                    tStepNumberDecay,
                    nRannacherTimeSteps,
                    predictionCorretionSteps,
                    x0Density,
                    localVolEpsProb,
                    maxIntegrationIterations,
                    vLowerEps, vUpperEps, vMin,
                    v0Density, vLowerBoundDensity, vUpperBoundDensity,
                    leverageFctPropEps,
                    greensAlgorithm,
                    trafoType,
                    schemeDesc };

                return new HestonSLVFokkerPlanckFdmParams(params);
        }
SWIGINTERN HestonSLVFDMModel *new_HestonSLVFDMModel__SWIG_0(ext::shared_ptr< LocalVolTermStructure > const &localVol,ext::shared_ptr< HestonModel > const &model,Date const &endDate,HestonSLVFokkerPlanckFdmParams const &params,bool const logging=false,std::vector< Date > const &mandatoryDates=std::vector< Date >(),Real mixingFactor=1.0){
            return new HestonSLVFDMModel(
                Handle<LocalVolTermStructure>(localVol), Handle<HestonModel>(model),
                endDate, params, logging, mandatoryDates, mixingFactor);
        }

using QuantLib::SpreadOption;
using QuantLib::KirkSpreadOptionEngine;


using QuantLib::Statistics;
using QuantLib::IncrementalStatistics;
using QuantLib::RiskStatistics;
using QuantLib::GenericSequenceStatistics;

SWIGINTERN void Statistics_add__SWIG_2(Statistics *self,std::vector< Real > const &values){
            self->addSequence(values.begin(), values.end());
        }
SWIGINTERN void Statistics_add__SWIG_3(Statistics *self,std::vector< Real > const &values,std::vector< Real > const &weights){
            self->addSequence(values.begin(), values.end(), weights.begin());
        }
SWIGINTERN void IncrementalStatistics_add__SWIG_2(IncrementalStatistics *self,std::vector< Real > const &values){
            self->addSequence(values.begin(), values.end());
        }
SWIGINTERN void IncrementalStatistics_add__SWIG_3(IncrementalStatistics *self,std::vector< Real > const &values,std::vector< Real > const &weights){
            self->addSequence(values.begin(), values.end(), weights.begin());
        }

using QuantLib::CapFloorTermVolatilityStructure;

SWIGINTERN ext::shared_ptr< Observable > Handle_Sl_CapFloorTermVolatilityStructure_Sg__asObservable(Handle< CapFloorTermVolatilityStructure > *self){
        return ext::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_CapFloorTermVolatilityStructure_Sg__reset(RelinkableHandle< CapFloorTermVolatilityStructure > *self){
            self->linkTo(ext::shared_ptr<CapFloorTermVolatilityStructure>());
        }

using QuantLib::CapFloorTermVolCurve;


using QuantLib::CapFloorTermVolSurface;


using QuantLib::StrippedOptionletBase;
using QuantLib::VolatilityType;


using QuantLib::StrippedOptionlet;


using QuantLib::OptionletStripper1;


using QuantLib::StrippedOptionletAdapter;


using QuantLib::Actual365Fixed;
using QuantLib::Swaption;
using QuantLib::NonstandardSwaption;
using QuantLib::Settlement;
using QuantLib::FloatFloatSwaption;

SWIGINTERN Real Swaption_vega(Swaption *self){
            return self->result<Real>("vega");
        }
SWIGINTERN Real Swaption_delta(Swaption *self){
            return self->result<Real>("delta");
        }
SWIGINTERN Real Swaption_annuity(Swaption *self){
            return self->result<Real>("annuity");
        }

using QuantLib::BasketGeneratingEngine;

SWIGINTERN std::vector< ext::shared_ptr< BlackCalibrationHelper > > NonstandardSwaption_calibrationBasket(NonstandardSwaption *self,ext::shared_ptr< SwapIndex > swapIndex,ext::shared_ptr< SwaptionVolatilityStructure > swaptionVolatility,std::string typeStr){

            BasketGeneratingEngine::CalibrationBasketType type;
            if(typeStr == "Naive")
                type = BasketGeneratingEngine::Naive;
            else if(typeStr == "MaturityStrikeByDeltaGamma")
                type = BasketGeneratingEngine::MaturityStrikeByDeltaGamma;
            else
                QL_FAIL("type " << typeStr << "unknown.");

            std::vector<ext::shared_ptr<BlackCalibrationHelper> > hs =
                self->calibrationBasket(swapIndex, swaptionVolatility, type);
            std::vector<ext::shared_ptr<BlackCalibrationHelper> > helpers(hs.size());
            for (Size i=0; i<hs.size(); ++i)
                helpers[i] = hs[i];
            return helpers;
        }
SWIGINTERN std::vector< Real > NonstandardSwaption_probabilities(NonstandardSwaption *self){
            return self->result<std::vector<Real> >("probabilities");
        }
SWIGINTERN std::vector< ext::shared_ptr< BlackCalibrationHelper > > FloatFloatSwaption_calibrationBasket(FloatFloatSwaption *self,ext::shared_ptr< SwapIndex > swapIndex,ext::shared_ptr< SwaptionVolatilityStructure > swaptionVolatility,std::string typeStr){

        BasketGeneratingEngine::CalibrationBasketType type;
        if(typeStr == "Naive")
            type = BasketGeneratingEngine::Naive;
        else if(typeStr == "MaturityStrikeByDeltaGamma")
            type = BasketGeneratingEngine::MaturityStrikeByDeltaGamma;
        else
            QL_FAIL("type " << typeStr << "unknown.");

        std::vector<ext::shared_ptr<BlackCalibrationHelper> > hs =
            self->calibrationBasket(swapIndex, swaptionVolatility, type);
        std::vector<ext::shared_ptr<BlackCalibrationHelper> > helpers(hs.size());
        for (Size i=0; i<hs.size(); ++i)
            helpers[i] = hs[i];
        return helpers;
        }
SWIGINTERN Real FloatFloatSwaption_underlyingValue(FloatFloatSwaption *self){
            return self->result<Real>("underlyingValue");
        }
SWIGINTERN std::vector< Real > FloatFloatSwaption_probabilities(FloatFloatSwaption *self){
            return self->result<std::vector<Real> >("probabilities");
        }

using QuantLib::BlackSwaptionEngine;
using QuantLib::BachelierSwaptionEngine;


using QuantLib::VanillaSwingOption;


using QuantLib::FdSimpleBSSwingEngine;
using QuantLib::FdSimpleExtOUJumpSwingEngine;

SWIGINTERN FdSimpleExtOUJumpSwingEngine *new_FdSimpleExtOUJumpSwingEngine__SWIG_0(ext::shared_ptr< ExtOUWithJumpsProcess > const &process,ext::shared_ptr< YieldTermStructure > const &rTS,Size tGrid=50,Size xGrid=200,Size yGrid=50,std::vector< std::pair< Time,Real > > const &shape=std::vector< std::pair< Time,Real > >(),FdmSchemeDesc const &schemeDesc=FdmSchemeDesc::Hundsdorfer()){

            ext::shared_ptr<FdSimpleExtOUJumpSwingEngine::Shape> curve(
                              new FdSimpleExtOUJumpSwingEngine::Shape(shape));

            return new FdSimpleExtOUJumpSwingEngine(
                    process, rTS, tGrid, xGrid, yGrid,
                    curve, schemeDesc);
        }


void enableTracing() { 
    QL_TRACE_ENABLE;
}

void disableTracing() {
    QL_TRACE_DISABLE;
}



using QuantLib::ConstantEstimator;
using QuantLib::SimpleLocalEstimator;
using QuantLib::GarmanKlassSigma1;
using QuantLib::ParkinsonSigma;
using QuantLib::GarmanKlassSigma3;
using QuantLib::GarmanKlassSigma4;
using QuantLib::GarmanKlassSigma5;
using QuantLib::GarmanKlassSigma6;


using QuantLib::InterpolatedZeroCurve;



/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "quantlib_wrap.h"

SwigDirector_UnaryFunctionDelegate::SwigDirector_UnaryFunctionDelegate(JNIEnv *jenv) : UnaryFunctionDelegate(), Swig::Director(jenv) {
}

SwigDirector_UnaryFunctionDelegate::~SwigDirector_UnaryFunctionDelegate() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


Real SwigDirector_UnaryFunctionDelegate::value(Real x) const {
  Real c_result = SwigValueInit< Real >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jdouble jx  ;
  
  if (!swig_override[0]) {
    return UnaryFunctionDelegate::value(x);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jx = (jdouble) x;
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_QuantLibJNI, Swig::director_method_ids[0], swigjobj, jx);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (Real)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in UnaryFunctionDelegate::value ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_UnaryFunctionDelegate::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "value", "(D)D", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/quantlib/UnaryFunctionDelegate");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_BinaryFunctionDelegate::SwigDirector_BinaryFunctionDelegate(JNIEnv *jenv) : BinaryFunctionDelegate(), Swig::Director(jenv) {
}

SwigDirector_BinaryFunctionDelegate::~SwigDirector_BinaryFunctionDelegate() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


Real SwigDirector_BinaryFunctionDelegate::value(Real arg0, Real arg1) const {
  Real c_result = SwigValueInit< Real >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jdouble jarg0  ;
  jdouble jarg1  ;
  
  if (!swig_override[0]) {
    return BinaryFunctionDelegate::value(arg0,arg1);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jarg0 = (jdouble) arg0;
    jarg1 = (jdouble) arg1;
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_QuantLibJNI, Swig::director_method_ids[1], swigjobj, jarg0, jarg1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (Real)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in BinaryFunctionDelegate::value ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_BinaryFunctionDelegate::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "value", "(DD)D", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/quantlib/BinaryFunctionDelegate");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_CostFunctionDelegate::SwigDirector_CostFunctionDelegate(JNIEnv *jenv) : CostFunctionDelegate(), Swig::Director(jenv) {
}

SwigDirector_CostFunctionDelegate::~SwigDirector_CostFunctionDelegate() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


Real SwigDirector_CostFunctionDelegate::value(Array const &x) const {
  Real c_result = SwigValueInit< Real >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jx = 0 ;
  
  if (!swig_override[0]) {
    return CostFunctionDelegate::value(x);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(Array **)&jx = (Array *) &x; 
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_QuantLibJNI, Swig::director_method_ids[2], swigjobj, jx);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (Real)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in CostFunctionDelegate::value ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Array SwigDirector_CostFunctionDelegate::values(Array const &x) const {
  Array c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jx = 0 ;
  Array *argp ;
  
  if (!swig_override[1]) {
    return CostFunctionDelegate::values(x);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(Array **)&jx = (Array *) &x; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_QuantLibJNI, Swig::director_method_ids[3], swigjobj, jx);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    argp = *(Array **)&jresult; 
    if (!argp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Unexpected null return for type Array");
      return c_result;
    }
    c_result = *argp; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in CostFunctionDelegate::values ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_CostFunctionDelegate::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "value", "(Lorg/quantlib/Array;)D", NULL 
    },
    {
      "values", "(Lorg/quantlib/Array;)Lorg/quantlib/Array;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/quantlib/CostFunctionDelegate");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_FdmLinearOpCompositeDelegate::SwigDirector_FdmLinearOpCompositeDelegate(JNIEnv *jenv) : FdmLinearOpCompositeDelegate(), Swig::Director(jenv) {
}

SwigDirector_FdmLinearOpCompositeDelegate::~SwigDirector_FdmLinearOpCompositeDelegate() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


Size SwigDirector_FdmLinearOpCompositeDelegate::size() const {
  Size c_result = SwigValueInit< Size >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    return FdmLinearOpCompositeDelegate::size();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_QuantLibJNI, Swig::director_method_ids[4], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (Size)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in FdmLinearOpCompositeDelegate::size ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_FdmLinearOpCompositeDelegate::setTime(Time t1, Time t2) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jdouble jt1  ;
  jdouble jt2  ;
  
  if (!swig_override[1]) {
    FdmLinearOpCompositeDelegate::setTime(t1,t2);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jt1 = (jdouble) t1;
    jt2 = (jdouble) t2;
    jenv->CallStaticVoidMethod(Swig::jclass_QuantLibJNI, Swig::director_method_ids[5], swigjobj, jt1, jt2);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in FdmLinearOpCompositeDelegate::setTime ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

Array SwigDirector_FdmLinearOpCompositeDelegate::apply(Array const &r) const {
  Array c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jr = 0 ;
  Array *argp ;
  
  if (!swig_override[2]) {
    return FdmLinearOpCompositeDelegate::apply(r);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(Array **)&jr = (Array *) &r; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_QuantLibJNI, Swig::director_method_ids[6], swigjobj, jr);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    argp = *(Array **)&jresult; 
    if (!argp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Unexpected null return for type Array");
      return c_result;
    }
    c_result = *argp; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in FdmLinearOpCompositeDelegate::apply ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Array SwigDirector_FdmLinearOpCompositeDelegate::apply_mixed(Array const &r) const {
  Array c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jr = 0 ;
  Array *argp ;
  
  if (!swig_override[3]) {
    return FdmLinearOpCompositeDelegate::apply_mixed(r);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(Array **)&jr = (Array *) &r; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_QuantLibJNI, Swig::director_method_ids[7], swigjobj, jr);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    argp = *(Array **)&jresult; 
    if (!argp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Unexpected null return for type Array");
      return c_result;
    }
    c_result = *argp; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in FdmLinearOpCompositeDelegate::apply_mixed ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Array SwigDirector_FdmLinearOpCompositeDelegate::apply_direction(Size direction, Array const &r) const {
  Array c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdirection  ;
  jlong jr = 0 ;
  Array *argp ;
  
  if (!swig_override[4]) {
    return FdmLinearOpCompositeDelegate::apply_direction(direction,r);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jdirection = (jlong) direction;
    *(Array **)&jr = (Array *) &r; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_QuantLibJNI, Swig::director_method_ids[8], swigjobj, jdirection, jr);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    argp = *(Array **)&jresult; 
    if (!argp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Unexpected null return for type Array");
      return c_result;
    }
    c_result = *argp; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in FdmLinearOpCompositeDelegate::apply_direction ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Array SwigDirector_FdmLinearOpCompositeDelegate::solve_splitting(Size direction, Array const &r, Real s) const {
  Array c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdirection  ;
  jlong jr = 0 ;
  jdouble js  ;
  Array *argp ;
  
  if (!swig_override[5]) {
    return FdmLinearOpCompositeDelegate::solve_splitting(direction,r,s);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jdirection = (jlong) direction;
    *(Array **)&jr = (Array *) &r; 
    js = (jdouble) s;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_QuantLibJNI, Swig::director_method_ids[9], swigjobj, jdirection, jr, js);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    argp = *(Array **)&jresult; 
    if (!argp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Unexpected null return for type Array");
      return c_result;
    }
    c_result = *argp; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in FdmLinearOpCompositeDelegate::solve_splitting ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Array SwigDirector_FdmLinearOpCompositeDelegate::preconditioner(Array const &r, Real dt) const {
  Array c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jr = 0 ;
  jdouble jdt  ;
  Array *argp ;
  
  if (!swig_override[6]) {
    return FdmLinearOpCompositeDelegate::preconditioner(r,dt);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(Array **)&jr = (Array *) &r; 
    jdt = (jdouble) dt;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_QuantLibJNI, Swig::director_method_ids[10], swigjobj, jr, jdt);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    argp = *(Array **)&jresult; 
    if (!argp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Unexpected null return for type Array");
      return c_result;
    }
    c_result = *argp; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in FdmLinearOpCompositeDelegate::preconditioner ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_FdmLinearOpCompositeDelegate::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "size", "()J", NULL 
    },
    {
      "setTime", "(DD)V", NULL 
    },
    {
      "apply", "(Lorg/quantlib/Array;)Lorg/quantlib/Array;", NULL 
    },
    {
      "apply_mixed", "(Lorg/quantlib/Array;)Lorg/quantlib/Array;", NULL 
    },
    {
      "apply_direction", "(JLorg/quantlib/Array;)Lorg/quantlib/Array;", NULL 
    },
    {
      "solve_splitting", "(JLorg/quantlib/Array;D)Lorg/quantlib/Array;", NULL 
    },
    {
      "preconditioner", "(Lorg/quantlib/Array;D)Lorg/quantlib/Array;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/quantlib/FdmLinearOpCompositeDelegate");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 7; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_FdmStepConditionDelegate::SwigDirector_FdmStepConditionDelegate(JNIEnv *jenv) : FdmStepConditionDelegate(), Swig::Director(jenv) {
}

SwigDirector_FdmStepConditionDelegate::~SwigDirector_FdmStepConditionDelegate() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_FdmStepConditionDelegate::applyTo(Array &a, Time t) const {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong ja = 0 ;
  jdouble jt  ;
  
  if (!swig_override[0]) {
    FdmStepConditionDelegate::applyTo(a,t);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(Array **)&ja = (Array *) &a; 
    jt = (jdouble) t;
    jenv->CallStaticVoidMethod(Swig::jclass_QuantLibJNI, Swig::director_method_ids[11], swigjobj, ja, jt);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in FdmStepConditionDelegate::applyTo ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_FdmStepConditionDelegate::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "applyTo", "(Lorg/quantlib/Array;D)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/quantlib/FdmStepConditionDelegate");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_FdmInnerValueCalculatorDelegate::SwigDirector_FdmInnerValueCalculatorDelegate(JNIEnv *jenv) : FdmInnerValueCalculatorDelegate(), Swig::Director(jenv) {
}

SwigDirector_FdmInnerValueCalculatorDelegate::~SwigDirector_FdmInnerValueCalculatorDelegate() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


Real SwigDirector_FdmInnerValueCalculatorDelegate::innerValue(FdmLinearOpIterator const &iter, Time t) {
  Real c_result = SwigValueInit< Real >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jiter = 0 ;
  jdouble jt  ;
  
  if (!swig_override[0]) {
    return FdmInnerValueCalculatorDelegate::innerValue(iter,t);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(FdmLinearOpIterator **)&jiter = (FdmLinearOpIterator *) &iter; 
    jt = (jdouble) t;
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_QuantLibJNI, Swig::director_method_ids[12], swigjobj, jiter, jt);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (Real)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in FdmInnerValueCalculatorDelegate::innerValue ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Real SwigDirector_FdmInnerValueCalculatorDelegate::avgInnerValue(FdmLinearOpIterator const &iter, Time t) {
  Real c_result = SwigValueInit< Real >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jiter = 0 ;
  jdouble jt  ;
  
  if (!swig_override[1]) {
    return FdmInnerValueCalculatorDelegate::avgInnerValue(iter,t);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(FdmLinearOpIterator **)&jiter = (FdmLinearOpIterator *) &iter; 
    jt = (jdouble) t;
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_QuantLibJNI, Swig::director_method_ids[13], swigjobj, jiter, jt);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (Real)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in FdmInnerValueCalculatorDelegate::avgInnerValue ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_FdmInnerValueCalculatorDelegate::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "innerValue", "(Lorg/quantlib/FdmLinearOpIterator;D)D", NULL 
    },
    {
      "avgInnerValue", "(Lorg/quantlib/FdmLinearOpIterator;D)D", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/quantlib/FdmInnerValueCalculatorDelegate");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_OdeFctDelegate::SwigDirector_OdeFctDelegate(JNIEnv *jenv) : OdeFctDelegate(), Swig::Director(jenv) {
}

SwigDirector_OdeFctDelegate::~SwigDirector_OdeFctDelegate() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::vector< Real > SwigDirector_OdeFctDelegate::value(Real x, std::vector< Real > const &y) const {
  std::vector< Real > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jdouble jx  ;
  jlong jy = 0 ;
  std::vector< Real > *argp ;
  
  if (!swig_override[0]) {
    return OdeFctDelegate::value(x,y);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jx = (jdouble) x;
    *(std::vector< Real > **)&jy = (std::vector< Real > *) &y; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_QuantLibJNI, Swig::director_method_ids[14], swigjobj, jx, jy);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    argp = *(std::vector< Real > **)&jresult; 
    if (!argp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Unexpected null return for type std::vector< Real >");
      return c_result;
    }
    c_result = *argp; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in OdeFctDelegate::value ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_OdeFctDelegate::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "value", "(DLorg/quantlib/DoubleVector;)Lorg/quantlib/DoubleVector;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/quantlib/OdeFctDelegate");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Period_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Period *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Period *)new Period();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Period **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Period_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Period *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  {
    try {
      result = (Period *)new Period(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Period **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Period_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Frequency arg1 ;
  Period *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Frequency)jarg1; 
  {
    try {
      result = (Period *)new Period(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Period **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Period_1length(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Period *arg1 = (Period *) 0 ;
  Integer result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Period **)&jarg1; 
  {
    try {
      result = (Integer)((Period const *)arg1)->length();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Period_1units(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Period *arg1 = (Period *) 0 ;
  TimeUnit result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Period **)&jarg1; 
  {
    try {
      result = (TimeUnit)((Period const *)arg1)->units();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Period_1frequency(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Period *arg1 = (Period *) 0 ;
  Frequency result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Period **)&jarg1; 
  {
    try {
      result = (Frequency)((Period const *)arg1)->frequency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Period_1normalized(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Period *arg1 = (Period *) 0 ;
  Period result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Period **)&jarg1; 
  {
    try {
      result = ((Period const *)arg1)->normalized();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Period **)&jresult = new Period((const Period &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Period_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Period *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (Period *)new_Period__SWIG_3((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Period **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Period_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Period *arg1 = (Period *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Period **)&jarg1; 
  {
    try {
      result = Period___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Period_1repr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Period *arg1 = (Period *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Period **)&jarg1; 
  {
    try {
      result = Period___repr__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Period(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Period *arg1 = (Period *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Period **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PeriodVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< Period > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< Period > *)new std::vector< Period >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Period > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PeriodVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< Period > *arg1 = 0 ;
  std::vector< Period > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Period > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Period > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< Period > *)new std::vector< Period >((std::vector< Period > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Period > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  std::vector< Period >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Period > **)&jarg1; 
  {
    try {
      result = ((std::vector< Period > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  std::vector< Period >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Period > **)&jarg1; 
  arg2 = (std::vector< Period >::size_type)jarg2; 
  {
    try {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Period > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< Period > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Period > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PeriodVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  Period *arg2 = 0 ;
  std::vector< Period > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = *(Period **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
    return 0;
  } 
  {
    try {
      try {
        result = (std::vector< Period > *)new_std_vector_Sl_Period_Sg___SWIG_2(arg1,(Period const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Period > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Period > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_Period_Sg__doSize((std::vector< Period > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  std::vector< Period >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< Period > **)&jarg1; 
  arg2 = *(std::vector< Period >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Period >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      std_vector_Sl_Period_Sg__doAdd__SWIG_0(arg1,(Period const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  jint arg2 ;
  std::vector< Period >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< Period > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< Period >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Period >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Period_Sg__doAdd__SWIG_1(arg1,arg2,(Period const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  jint arg2 ;
  std::vector< Period >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Period > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_Period_Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Period >::value_type **)&jresult = new std::vector< Period >::value_type((const std::vector< Period >::value_type &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  jint arg2 ;
  std::vector< Period >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Period > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< Period >::value_type *) &std_vector_Sl_Period_Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Period >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  jint arg2 ;
  std::vector< Period >::value_type *arg3 = 0 ;
  std::vector< Period >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< Period > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< Period >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Period >::value_type const & reference is null");
    return 0;
  } 
  {
    try {
      try {
        result = std_vector_Sl_Period_Sg__doSet(arg1,arg2,(Period const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Period >::value_type **)&jresult = new std::vector< Period >::value_type((const std::vector< Period >::value_type &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Period > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_Period_Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1PeriodVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< Period > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Date *)new Date();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  Day arg1 ;
  Month arg2 ;
  Year arg3 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Day)jarg1; 
  arg2 = (Month)jarg2; 
  arg3 = (Year)jarg3; 
  {
    try {
      result = (Date *)new Date(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6, jint jarg7, jint jarg8) {
  jlong jresult = 0 ;
  Day arg1 ;
  Month arg2 ;
  Year arg3 ;
  Hour arg4 ;
  Minute arg5 ;
  Second arg6 ;
  Millisecond arg7 ;
  Microsecond arg8 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Day)jarg1; 
  arg2 = (Month)jarg2; 
  arg3 = (Year)jarg3; 
  arg4 = (Hour)jarg4; 
  arg5 = (Minute)jarg5; 
  arg6 = (Second)jarg6; 
  arg7 = (Millisecond)jarg7; 
  arg8 = (Microsecond)jarg8; 
  {
    try {
      result = (Date *)new_Date__SWIG_2(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6, jint jarg7) {
  jlong jresult = 0 ;
  Day arg1 ;
  Month arg2 ;
  Year arg3 ;
  Hour arg4 ;
  Minute arg5 ;
  Second arg6 ;
  Millisecond arg7 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Day)jarg1; 
  arg2 = (Month)jarg2; 
  arg3 = (Year)jarg3; 
  arg4 = (Hour)jarg4; 
  arg5 = (Minute)jarg5; 
  arg6 = (Second)jarg6; 
  arg7 = (Millisecond)jarg7; 
  {
    try {
      result = (Date *)new_Date__SWIG_2(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6) {
  jlong jresult = 0 ;
  Day arg1 ;
  Month arg2 ;
  Year arg3 ;
  Hour arg4 ;
  Minute arg5 ;
  Second arg6 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Day)jarg1; 
  arg2 = (Month)jarg2; 
  arg3 = (Year)jarg3; 
  arg4 = (Hour)jarg4; 
  arg5 = (Minute)jarg5; 
  arg6 = (Second)jarg6; 
  {
    try {
      result = (Date *)new_Date__SWIG_2(arg1,arg2,arg3,arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  BigInteger arg1 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (BigInteger)jarg1; 
  {
    try {
      result = (Date *)new Date(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1weekday(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Weekday result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Weekday)((Date const *)arg1)->weekday();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1dayOfMonth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Day result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Day)((Date const *)arg1)->dayOfMonth();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1dayOfYear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Day result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Day)((Date const *)arg1)->dayOfYear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1month(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Month result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Month)((Date const *)arg1)->month();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1year(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Year result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Year)((Date const *)arg1)->year();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1hours(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Hour result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Hour)Date_hours(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1minutes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Minute result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Minute)Date_minutes(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1seconds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Second result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Second)Date_seconds(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1milliseconds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Millisecond result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Millisecond)Date_milliseconds(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1microseconds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Microsecond result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Microsecond)Date_microseconds(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_Date_1fractionOfDay(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Time result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Time)Date_fractionOfDay((Date const *)arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_Date_1fractionOfSecond(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Time result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Time)Date_fractionOfSecond((Date const *)arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1serialNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  BigInteger result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (BigInteger)((Date const *)arg1)->serialNumber();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Date_1isLeap(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  Year arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Year)jarg1; 
  {
    try {
      result = (bool)Date::isLeap(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1minDate(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = Date::minDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1maxDate(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = Date::maxDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1todaysDate(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = Date::todaysDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1localDateTime(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = Date_localDateTime();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1universalDateTime(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = Date_universalDateTime();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1endOfMonth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = Date::endOfMonth((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Date_1isEndOfMonth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Date *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Date::isEndOfMonth((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1nextWeekday(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Weekday arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = (Weekday)jarg2; 
  {
    try {
      result = Date::nextWeekday((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1nthWeekday(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  Size arg1 ;
  Weekday arg2 ;
  Month arg3 ;
  Year arg4 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Size)jarg1; 
  arg2 = (Weekday)jarg2; 
  arg3 = (Month)jarg3; 
  arg4 = (Year)jarg4; 
  {
    try {
      result = Date::nthWeekday(arg1,arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1add_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  BigInteger arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  arg2 = (BigInteger)jarg2; 
  {
    try {
      result = ((Date const *)arg1)->operator +(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1subtract_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  BigInteger arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  arg2 = (BigInteger)jarg2; 
  {
    try {
      result = ((Date const *)arg1)->operator -(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1add_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Period *arg2 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Date **)&jarg1; 
  arg2 = *(Period **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((Date const *)arg1)->operator +((Period const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1subtract_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Period *arg2 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Date **)&jarg1; 
  arg2 = *(Period **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((Date const *)arg1)->operator -((Period const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string arg2 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Date *)new_Date__SWIG_6((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1weekdayNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Integer result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Integer)Date_weekdayNumber(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Date_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = Date___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Date_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = Date___repr__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Date_1ISO(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = Date_ISO(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Date(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Date *arg1 = (Date *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DateParser_1parseFormatted(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = DateParser::parseFormatted((std::string const &)*arg1,(std::string const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DateParser_1parseISO(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = DateParser::parseISO((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DateParser_1parse(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = DateParser_parse((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DateParser(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  DateParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (DateParser *)new DateParser();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(DateParser **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DateParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  DateParser *arg1 = (DateParser *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DateParser **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_PeriodParser_1parse(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Period result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = PeriodParser::parse((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Period **)&jresult = new Period((const Period &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PeriodParser(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  PeriodParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (PeriodParser *)new PeriodParser();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(PeriodParser **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1PeriodParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  PeriodParser *arg1 = (PeriodParser *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(PeriodParser **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DateVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< Date > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< Date > *)new std::vector< Date >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Date > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DateVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< Date > *arg1 = 0 ;
  std::vector< Date > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Date > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Date > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< Date > *)new std::vector< Date >((std::vector< Date > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Date > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  std::vector< Date >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Date > **)&jarg1; 
  {
    try {
      result = ((std::vector< Date > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  std::vector< Date >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Date > **)&jarg1; 
  arg2 = (std::vector< Date >::size_type)jarg2; 
  {
    try {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Date > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< Date > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Date > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DateVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  Date *arg2 = 0 ;
  std::vector< Date > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      try {
        result = (std::vector< Date > *)new_std_vector_Sl_Date_Sg___SWIG_2(arg1,(Date const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Date > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Date > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_Date_Sg__doSize((std::vector< Date > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  std::vector< Date >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< Date > **)&jarg1; 
  arg2 = *(std::vector< Date >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Date >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      std_vector_Sl_Date_Sg__doAdd__SWIG_0(arg1,(Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  jint arg2 ;
  std::vector< Date >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< Date > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< Date >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Date >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Date_Sg__doAdd__SWIG_1(arg1,arg2,(Date const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  jint arg2 ;
  std::vector< Date >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Date > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_Date_Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Date >::value_type **)&jresult = new std::vector< Date >::value_type((const std::vector< Date >::value_type &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  jint arg2 ;
  std::vector< Date >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Date > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< Date >::value_type *) &std_vector_Sl_Date_Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Date >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  jint arg2 ;
  std::vector< Date >::value_type *arg3 = 0 ;
  std::vector< Date >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< Date > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< Date >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Date >::value_type const & reference is null");
    return 0;
  } 
  {
    try {
      try {
        result = std_vector_Sl_Date_Sg__doSet(arg1,arg2,(Date const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Date >::value_type **)&jresult = new std::vector< Date >::value_type((const std::vector< Date >::value_type &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Date > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_Date_Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DateVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< Date > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_daysBetween(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jdouble jresult = 0 ;
  Date *arg1 = 0 ;
  Date *arg2 = 0 ;
  Time result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Time)daysBetween((Date const &)*arg1,(Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1F_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::F;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1G_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::G;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1H_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::H;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1J_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::J;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1K_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::K;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1M_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::M;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1N_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::N;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1Q_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::Q;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1U_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::U;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1V_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::V;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1X_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::X;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1Z_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::Z;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_IMM_1isIMMdate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  Date *arg1 = 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (bool)IMM::isIMMdate((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_IMM_1isIMMdate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Date *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)IMM::isIMMdate((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_IMM_1isIMMcode_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jboolean jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (bool)IMM::isIMMcode((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_IMM_1isIMMcode_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jboolean jresult = 0 ;
  std::string *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (bool)IMM::isIMMcode((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1code(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Date *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = IMM::code((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1date_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Date *arg2 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = IMM::date((std::string const &)*arg1,(Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1date_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = IMM::date((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextDate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  bool arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = IMM::nextDate((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextDate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = IMM::nextDate((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextDate_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = IMM::nextDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextDate_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date *arg3 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = IMM::nextDate((std::string const &)*arg1,arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextDate_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = IMM::nextDate((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextDate_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = IMM::nextDate((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextCode_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jstring jresult = 0 ;
  Date *arg1 = 0 ;
  bool arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = IMM::nextCode((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextCode_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Date *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = IMM::nextCode((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextCode_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = IMM::nextCode();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextCode_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2, jlong jarg3, jobject jarg3_) {
  jstring jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date *arg3 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = IMM::nextCode((std::string const &)*arg1,arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextCode_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jstring jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = IMM::nextCode((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextCode_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jstring jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = IMM::nextCode((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1IMM(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  IMM *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (IMM *)new IMM();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(IMM **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1IMM(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  IMM *arg1 = (IMM *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(IMM **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1F_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::F;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1G_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::G;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1H_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::H;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1J_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::J;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1K_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::K;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1M_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::M;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1N_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::N;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1Q_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::Q;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1U_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::U;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1V_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::V;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1X_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::X;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1Z_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::Z;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_ASX_1isASXdate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  Date *arg1 = 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (bool)ASX::isASXdate((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_ASX_1isASXdate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Date *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)ASX::isASXdate((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_ASX_1isASXcode_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jboolean jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (bool)ASX::isASXcode((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_ASX_1isASXcode_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jboolean jresult = 0 ;
  std::string *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (bool)ASX::isASXcode((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_ASX_1code(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Date *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = ASX::code((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_ASX_1date_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Date *arg2 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = ASX::date((std::string const &)*arg1,(Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_ASX_1date_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = ASX::date((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextDate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  bool arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = ASX::nextDate((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextDate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = ASX::nextDate((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextDate_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = ASX::nextDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextDate_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date *arg3 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = ASX::nextDate((std::string const &)*arg1,arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextDate_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = ASX::nextDate((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextDate_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = ASX::nextDate((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextCode_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jstring jresult = 0 ;
  Date *arg1 = 0 ;
  bool arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = ASX::nextCode((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextCode_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Date *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = ASX::nextCode((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextCode_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = ASX::nextCode();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextCode_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2, jlong jarg3, jobject jarg3_) {
  jstring jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date *arg3 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = ASX::nextCode((std::string const &)*arg1,arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextCode_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jstring jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = ASX::nextCode((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextCode_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jstring jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = ASX::nextCode((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ASX(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ASX *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (ASX *)new ASX();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(ASX **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ASX(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ASX *arg1 = (ASX *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ASX **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1IntVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< int > *)new std::vector< int >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1IntVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< int > *arg1 = 0 ;
  std::vector< int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< int > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< int > *)new std::vector< int >((std::vector< int > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  {
    try {
      result = ((std::vector< int > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  arg2 = (std::vector< int >::size_type)jarg2; 
  {
    try {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< int > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1IntVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  int *arg2 = 0 ;
  int temp2 ;
  std::vector< int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  {
    try {
      try {
        result = (std::vector< int > *)new_std_vector_Sl_int_Sg___SWIG_2(arg1,(int const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_int_Sg__doSize((std::vector< int > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int >::value_type *arg2 = 0 ;
  std::vector< int >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  temp2 = (std::vector< int >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      std_vector_Sl_int_Sg__doAdd__SWIG_0(arg1,(int const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  jint arg2 ;
  std::vector< int >::value_type *arg3 = 0 ;
  std::vector< int >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< int >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_int_Sg__doAdd__SWIG_1(arg1,arg2,(int const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  jint arg2 ;
  std::vector< int >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< int >::value_type)std_vector_Sl_int_Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  jint arg2 ;
  std::vector< int >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< int >::value_type *) &std_vector_Sl_int_Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)*result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jint jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  jint arg2 ;
  std::vector< int >::value_type *arg3 = 0 ;
  std::vector< int >::value_type temp3 ;
  std::vector< int >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< int >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        result = (std::vector< int >::value_type)std_vector_Sl_int_Sg__doSet(arg1,arg2,(int const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_int_Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1IntVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< int > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnsignedIntVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< unsigned int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< unsigned int > *)new std::vector< unsigned int >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< unsigned int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnsignedIntVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< unsigned int > *arg1 = 0 ;
  std::vector< unsigned int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< unsigned int > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< unsigned int > *)new std::vector< unsigned int >((std::vector< unsigned int > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< unsigned int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  std::vector< unsigned int >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  {
    try {
      result = ((std::vector< unsigned int > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  std::vector< unsigned int >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  arg2 = (std::vector< unsigned int >::size_type)jarg2; 
  {
    try {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< unsigned int > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnsignedIntVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  unsigned int *arg2 = 0 ;
  unsigned int temp2 ;
  std::vector< unsigned int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = (unsigned int)jarg2; 
  arg2 = &temp2; 
  {
    try {
      try {
        result = (std::vector< unsigned int > *)new_std_vector_Sl_unsigned_SS_int_Sg___SWIG_2(arg1,(unsigned int const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< unsigned int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_unsigned_SS_int_Sg__doSize((std::vector< unsigned int > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  std::vector< unsigned int >::value_type *arg2 = 0 ;
  std::vector< unsigned int >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  temp2 = (std::vector< unsigned int >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      std_vector_Sl_unsigned_SS_int_Sg__doAdd__SWIG_0(arg1,(unsigned int const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  jint arg2 ;
  std::vector< unsigned int >::value_type *arg3 = 0 ;
  std::vector< unsigned int >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< unsigned int >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_unsigned_SS_int_Sg__doAdd__SWIG_1(arg1,arg2,(unsigned int const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  jint arg2 ;
  std::vector< unsigned int >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< unsigned int >::value_type)std_vector_Sl_unsigned_SS_int_Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  jint arg2 ;
  std::vector< unsigned int >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< unsigned int >::value_type *) &std_vector_Sl_unsigned_SS_int_Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)*result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  jint arg2 ;
  std::vector< unsigned int >::value_type *arg3 = 0 ;
  std::vector< unsigned int >::value_type temp3 ;
  std::vector< unsigned int >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< unsigned int >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        result = (std::vector< unsigned int >::value_type)std_vector_Sl_unsigned_SS_int_Sg__doSet(arg1,arg2,(unsigned int const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_unsigned_SS_int_Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1UnsignedIntVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DoubleVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< double > *)new std::vector< double >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DoubleVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< double > *)new std::vector< double >((std::vector< double > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  std::vector< double >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  {
    try {
      result = ((std::vector< double > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  std::vector< double >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = (std::vector< double >::size_type)jarg2; 
  {
    try {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< double > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DoubleVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jdouble jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  double *arg2 = 0 ;
  double temp2 ;
  std::vector< double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = (double)jarg2; 
  arg2 = &temp2; 
  {
    try {
      try {
        result = (std::vector< double > *)new_std_vector_Sl_double_Sg___SWIG_2(arg1,(double const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_double_Sg__doSize((std::vector< double > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  std::vector< double >::value_type *arg2 = 0 ;
  std::vector< double >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  temp2 = (std::vector< double >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      std_vector_Sl_double_Sg__doAdd__SWIG_0(arg1,(double const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  jint arg2 ;
  std::vector< double >::value_type *arg3 = 0 ;
  std::vector< double >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< double >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_double_Sg__doAdd__SWIG_1(arg1,arg2,(double const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  jint arg2 ;
  std::vector< double >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< double >::value_type)std_vector_Sl_double_Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  jint arg2 ;
  std::vector< double >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< double >::value_type *) &std_vector_Sl_double_Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)*result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3) {
  jdouble jresult = 0 ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  jint arg2 ;
  std::vector< double >::value_type *arg3 = 0 ;
  std::vector< double >::value_type temp3 ;
  std::vector< double >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< double >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        result = (std::vector< double >::value_type)std_vector_Sl_double_Sg__doSet(arg1,arg2,(double const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_double_Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DoubleVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< double > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1StrVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< std::string > *)new std::vector< std::string >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1StrVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::string > *arg1 = 0 ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::string > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< std::string > *)new std::vector< std::string >((std::vector< std::string > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try {
      result = ((std::vector< std::string > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = (std::vector< std::string >::size_type)jarg2; 
  {
    try {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< std::string > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1StrVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::string *arg2 = 0 ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      try {
        result = (std::vector< std::string > *)new_std_vector_Sl_std_string_Sg___SWIG_2(arg1,(std::string const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_std_string_Sg__doSize((std::vector< std::string > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::vector< std::string >::value_type arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      std_vector_Sl_std_string_Sg__doAdd__SWIG_0(arg1,(std::string const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  jint arg2 ;
  std::vector< std::string >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::vector< std::string >::value_type arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__doAdd__SWIG_1(arg1,arg2,(std::string const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  jint arg2 ;
  std::vector< std::string >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_std_string_Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  jint arg2 ;
  std::vector< std::string >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< std::string >::value_type *) &std_vector_Sl_std_string_Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  jstring jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  jint arg2 ;
  std::vector< std::string >::value_type *arg3 = 0 ;
  std::vector< std::string >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::vector< std::string >::value_type arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      try {
        result = std_vector_Sl_std_string_Sg__doSet(arg1,arg2,(std::string const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1StrVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BoolVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< bool > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< bool > *)new std::vector< bool >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< bool > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BoolVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< bool > *arg1 = 0 ;
  std::vector< bool > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< bool > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< bool > *)new std::vector< bool >((std::vector< bool > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< bool > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_BoolVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  std::vector< bool >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  {
    try {
      result = ((std::vector< bool > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_BoolVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  std::vector< bool >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  arg2 = (std::vector< bool >::size_type)jarg2; 
  {
    try {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_BoolVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< bool > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_BoolVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BoolVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jboolean jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  bool *arg2 = 0 ;
  bool temp2 ;
  std::vector< bool > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = jarg2 ? true : false; 
  arg2 = &temp2; 
  {
    try {
      try {
        result = (std::vector< bool > *)new_std_vector_Sl_bool_Sg___SWIG_2(arg1,(bool const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< bool > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_BoolVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_bool_Sg__doSize((std::vector< bool > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_BoolVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  std::vector< bool >::value_type *arg2 = 0 ;
  std::vector< bool >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  temp2 = jarg2 ? true : false; 
  arg2 = &temp2; 
  {
    try {
      std_vector_Sl_bool_Sg__doAdd__SWIG_0(arg1,(bool const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_BoolVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  jint arg2 ;
  std::vector< bool >::value_type *arg3 = 0 ;
  std::vector< bool >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = jarg3 ? true : false; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_bool_Sg__doAdd__SWIG_1(arg1,arg2,(bool const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_BoolVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  jint arg2 ;
  std::vector< bool >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< bool >::value_type)std_vector_Sl_bool_Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_BoolVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  jint arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (bool)std_vector_Sl_bool_Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_BoolVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  jboolean jresult = 0 ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  jint arg2 ;
  std::vector< bool >::value_type *arg3 = 0 ;
  std::vector< bool >::value_type temp3 ;
  std::vector< bool >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = jarg3 ? true : false; 
  arg3 = &temp3; 
  {
    try {
      try {
        result = (std::vector< bool >::value_type)std_vector_Sl_bool_Sg__doSet(arg1,arg2,(bool const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_BoolVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_bool_Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BoolVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< bool > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DoublePair_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::pair< double,double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::pair< double,double > *)new std::pair< double,double >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::pair< double,double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DoublePair_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2) {
  jlong jresult = 0 ;
  double arg1 ;
  double arg2 ;
  std::pair< double,double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      result = (std::pair< double,double > *)new std::pair< double,double >(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::pair< double,double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DoublePair_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::pair< double,double > *arg1 = 0 ;
  std::pair< double,double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< double,double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::pair< double,double > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::pair< double,double > *)new std::pair< double,double >((std::pair< double,double > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::pair< double,double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoublePair_1first_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  std::pair< double,double > *arg1 = (std::pair< double,double > *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< double,double > **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->first = arg2;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_DoublePair_1first_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  std::pair< double,double > *arg1 = (std::pair< double,double > *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< double,double > **)&jarg1; 
  result = (double) ((arg1)->first);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoublePair_1second_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  std::pair< double,double > *arg1 = (std::pair< double,double > *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< double,double > **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->second = arg2;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_DoublePair_1second_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  std::pair< double,double > *arg1 = (std::pair< double,double > *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< double,double > **)&jarg1; 
  result = (double) ((arg1)->second);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DoublePair(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::pair< double,double > *arg1 = (std::pair< double,double > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::pair< double,double > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DoublePairVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::pair< double,double > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< std::pair< double,double > > *)new std::vector< std::pair< double,double > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::pair< double,double > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DoublePairVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::pair< double,double > > *arg1 = 0 ;
  std::vector< std::pair< double,double > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< double,double > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::pair< double,double > > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< std::pair< double,double > > *)new std::vector< std::pair< double,double > >((std::vector< std::pair< double,double > > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::pair< double,double > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DoublePairVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  std::vector< std::pair< double,double > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< double,double > > **)&jarg1; 
  {
    try {
      result = ((std::vector< std::pair< double,double > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoublePairVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  std::vector< std::pair< double,double > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< double,double > > **)&jarg1; 
  arg2 = (std::vector< std::pair< double,double > >::size_type)jarg2; 
  {
    try {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_DoublePairVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< double,double > > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< std::pair< double,double > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoublePairVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< double,double > > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DoublePairVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::pair< double,double > *arg2 = 0 ;
  std::vector< std::pair< double,double > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = *(std::pair< double,double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::pair< double,double > const & reference is null");
    return 0;
  } 
  {
    try {
      try {
        result = (std::vector< std::pair< double,double > > *)new_std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg___SWIG_2(arg1,(std::pair< double,double > const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::pair< double,double > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_DoublePairVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< double,double > > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__doSize((std::vector< std::pair< double,double > > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoublePairVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  std::vector< std::pair< double,double > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::pair< double,double > > **)&jarg1; 
  arg2 = *(std::vector< std::pair< double,double > >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::pair< double,double > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__doAdd__SWIG_0(arg1,(std::pair< double,double > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoublePairVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  jint arg2 ;
  std::vector< std::pair< double,double > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::pair< double,double > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< std::pair< double,double > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::pair< double,double > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::pair< double,double > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DoublePairVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  jint arg2 ;
  std::vector< std::pair< double,double > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< double,double > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::pair< double,double > >::value_type **)&jresult = new std::vector< std::pair< double,double > >::value_type((const std::vector< std::pair< double,double > >::value_type &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DoublePairVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  jint arg2 ;
  std::vector< std::pair< double,double > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< double,double > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< std::pair< double,double > >::value_type *) &std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::pair< double,double > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DoublePairVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  jint arg2 ;
  std::vector< std::pair< double,double > >::value_type *arg3 = 0 ;
  std::vector< std::pair< double,double > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::pair< double,double > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< std::pair< double,double > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::pair< double,double > >::value_type const & reference is null");
    return 0;
  } 
  {
    try {
      try {
        result = std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__doSet(arg1,arg2,(std::pair< double,double > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::pair< double,double > >::value_type **)&jresult = new std::vector< std::pair< double,double > >::value_type((const std::vector< std::pair< double,double > >::value_type &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoublePairVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< double,double > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DoublePairVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::pair< double,double > > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PairDoubleVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::pair< std::vector< double >,std::vector< double > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::pair< std::vector< double >,std::vector< double > > *)new std::pair< std::vector< double >,std::vector< double > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::pair< std::vector< double >,std::vector< double > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PairDoubleVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  std::vector< double > arg1 ;
  std::vector< double > arg2 ;
  std::vector< double > *argp1 ;
  std::vector< double > *argp2 ;
  std::pair< std::vector< double >,std::vector< double > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  argp1 = *(std::vector< double > **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< double >");
    return 0;
  }
  arg1 = *argp1; 
  argp2 = *(std::vector< double > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< double >");
    return 0;
  }
  arg2 = *argp2; 
  {
    try {
      result = (std::pair< std::vector< double >,std::vector< double > > *)new std::pair< std::vector< double >,std::vector< double > >(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::pair< std::vector< double >,std::vector< double > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PairDoubleVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::pair< std::vector< double >,std::vector< double > > *arg1 = 0 ;
  std::pair< std::vector< double >,std::vector< double > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< std::vector< double >,std::vector< double > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::pair< std::vector< double >,std::vector< double > > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::pair< std::vector< double >,std::vector< double > > *)new std::pair< std::vector< double >,std::vector< double > >((std::pair< std::vector< double >,std::vector< double > > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::pair< std::vector< double >,std::vector< double > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_PairDoubleVector_1first_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::pair< std::vector< double >,std::vector< double > > *arg1 = (std::pair< std::vector< double >,std::vector< double > > *) 0 ;
  std::vector< double > *arg2 = (std::vector< double > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::pair< std::vector< double >,std::vector< double > > **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2; 
  if (arg1) (arg1)->first = *arg2;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_PairDoubleVector_1first_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::pair< std::vector< double >,std::vector< double > > *arg1 = (std::pair< std::vector< double >,std::vector< double > > *) 0 ;
  std::vector< double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< std::vector< double >,std::vector< double > > **)&jarg1; 
  result = (std::vector< double > *)& ((arg1)->first);
  *(std::vector< double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_PairDoubleVector_1second_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::pair< std::vector< double >,std::vector< double > > *arg1 = (std::pair< std::vector< double >,std::vector< double > > *) 0 ;
  std::vector< double > *arg2 = (std::vector< double > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::pair< std::vector< double >,std::vector< double > > **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2; 
  if (arg1) (arg1)->second = *arg2;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_PairDoubleVector_1second_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::pair< std::vector< double >,std::vector< double > > *arg1 = (std::pair< std::vector< double >,std::vector< double > > *) 0 ;
  std::vector< double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< std::vector< double >,std::vector< double > > **)&jarg1; 
  result = (std::vector< double > *)& ((arg1)->second);
  *(std::vector< double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1PairDoubleVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::pair< std::vector< double >,std::vector< double > > *arg1 = (std::pair< std::vector< double >,std::vector< double > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::pair< std::vector< double >,std::vector< double > > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnsignedIntPair_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::pair< unsigned int,unsigned int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::pair< unsigned int,unsigned int > *)new std::pair< unsigned int,unsigned int >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::pair< unsigned int,unsigned int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnsignedIntPair_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  unsigned int arg1 ;
  unsigned int arg2 ;
  std::pair< unsigned int,unsigned int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      result = (std::pair< unsigned int,unsigned int > *)new std::pair< unsigned int,unsigned int >(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::pair< unsigned int,unsigned int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnsignedIntPair_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::pair< unsigned int,unsigned int > *arg1 = 0 ;
  std::pair< unsigned int,unsigned int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< unsigned int,unsigned int > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::pair< unsigned int,unsigned int > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::pair< unsigned int,unsigned int > *)new std::pair< unsigned int,unsigned int >((std::pair< unsigned int,unsigned int > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::pair< unsigned int,unsigned int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntPair_1first_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::pair< unsigned int,unsigned int > *arg1 = (std::pair< unsigned int,unsigned int > *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< unsigned int,unsigned int > **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->first = arg2;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntPair_1first_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::pair< unsigned int,unsigned int > *arg1 = (std::pair< unsigned int,unsigned int > *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< unsigned int,unsigned int > **)&jarg1; 
  result = (unsigned int) ((arg1)->first);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntPair_1second_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::pair< unsigned int,unsigned int > *arg1 = (std::pair< unsigned int,unsigned int > *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< unsigned int,unsigned int > **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->second = arg2;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntPair_1second_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::pair< unsigned int,unsigned int > *arg1 = (std::pair< unsigned int,unsigned int > *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< unsigned int,unsigned int > **)&jarg1; 
  result = (unsigned int) ((arg1)->second);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1UnsignedIntPair(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::pair< unsigned int,unsigned int > *arg1 = (std::pair< unsigned int,unsigned int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::pair< unsigned int,unsigned int > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NodePair_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::pair< Date,double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::pair< Date,double > *)new std::pair< Date,double >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::pair< Date,double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NodePair_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jlong jresult = 0 ;
  Date arg1 ;
  double arg2 ;
  Date *argp1 ;
  std::pair< Date,double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  argp1 = *(Date **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null Date");
    return 0;
  }
  arg1 = *argp1; 
  arg2 = (double)jarg2; 
  {
    try {
      result = (std::pair< Date,double > *)new std::pair< Date,double >(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::pair< Date,double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NodePair_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::pair< Date,double > *arg1 = 0 ;
  std::pair< Date,double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< Date,double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::pair< Date,double > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::pair< Date,double > *)new std::pair< Date,double >((std::pair< Date,double > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::pair< Date,double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_NodePair_1first_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::pair< Date,double > *arg1 = (std::pair< Date,double > *) 0 ;
  Date *arg2 = (Date *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::pair< Date,double > **)&jarg1; 
  arg2 = *(Date **)&jarg2; 
  if (arg1) (arg1)->first = *arg2;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_NodePair_1first_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::pair< Date,double > *arg1 = (std::pair< Date,double > *) 0 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< Date,double > **)&jarg1; 
  result = (Date *)& ((arg1)->first);
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_NodePair_1second_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  std::pair< Date,double > *arg1 = (std::pair< Date,double > *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< Date,double > **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->second = arg2;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_NodePair_1second_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  std::pair< Date,double > *arg1 = (std::pair< Date,double > *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< Date,double > **)&jarg1; 
  result = (double) ((arg1)->second);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1NodePair(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::pair< Date,double > *arg1 = (std::pair< Date,double > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::pair< Date,double > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NodeVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::pair< Date,double > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< std::pair< Date,double > > *)new std::vector< std::pair< Date,double > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::pair< Date,double > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NodeVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::pair< Date,double > > *arg1 = 0 ;
  std::vector< std::pair< Date,double > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::pair< Date,double > > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< std::pair< Date,double > > *)new std::vector< std::pair< Date,double > >((std::vector< std::pair< Date,double > > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::pair< Date,double > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  std::vector< std::pair< Date,double > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  {
    try {
      result = ((std::vector< std::pair< Date,double > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  std::vector< std::pair< Date,double > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  arg2 = (std::vector< std::pair< Date,double > >::size_type)jarg2; 
  {
    try {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< std::pair< Date,double > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NodeVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::pair< Date,double > *arg2 = 0 ;
  std::vector< std::pair< Date,double > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = *(std::pair< Date,double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::pair< Date,double > const & reference is null");
    return 0;
  } 
  {
    try {
      try {
        result = (std::vector< std::pair< Date,double > > *)new_std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg___SWIG_2(arg1,(std::pair< Date,double > const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::pair< Date,double > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__doSize((std::vector< std::pair< Date,double > > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  std::vector< std::pair< Date,double > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  arg2 = *(std::vector< std::pair< Date,double > >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::pair< Date,double > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__doAdd__SWIG_0(arg1,(std::pair< Date,double > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  jint arg2 ;
  std::vector< std::pair< Date,double > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< std::pair< Date,double > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::pair< Date,double > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::pair< Date,double > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  jint arg2 ;
  std::vector< std::pair< Date,double > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::pair< Date,double > >::value_type **)&jresult = new std::vector< std::pair< Date,double > >::value_type((const std::vector< std::pair< Date,double > >::value_type &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  jint arg2 ;
  std::vector< std::pair< Date,double > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< std::pair< Date,double > >::value_type *) &std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::pair< Date,double > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  jint arg2 ;
  std::vector< std::pair< Date,double > >::value_type *arg3 = 0 ;
  std::vector< std::pair< Date,double > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< std::pair< Date,double > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::pair< Date,double > >::value_type const & reference is null");
    return 0;
  } 
  {
    try {
      try {
        result = std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__doSet(arg1,arg2,(std::pair< Date,double > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::pair< Date,double > >::value_type **)&jresult = new std::vector< std::pair< Date,double > >::value_type((const std::vector< std::pair< Date,double > >::value_type &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1NodeVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Exercise(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Exercise::Type arg1 ;
  Exercise *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Exercise::Type)jarg1; 
  {
    try {
      result = (Exercise *)new Exercise(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  *(ext::shared_ptr<  Exercise > **)&jresult = result ? new ext::shared_ptr<  Exercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1type(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Exercise *arg1 = (Exercise *) 0 ;
  ext::shared_ptr< Exercise const > *smartarg1 = 0 ;
  Exercise::Type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(ext::shared_ptr< const Exercise > **)&jarg1;
  arg1 = (Exercise *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      result = (Exercise::Type)((Exercise const *)arg1)->type();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1date(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Exercise *arg1 = (Exercise *) 0 ;
  Size arg2 ;
  ext::shared_ptr< Exercise > *smartarg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(ext::shared_ptr<  Exercise > **)&jarg1;
  arg1 = (Exercise *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (Size)jarg2; 
  {
    try {
      result = (arg1)->date(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1dateAt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Exercise *arg1 = (Exercise *) 0 ;
  Size arg2 ;
  ext::shared_ptr< Exercise > *smartarg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(ext::shared_ptr<  Exercise > **)&jarg1;
  arg1 = (Exercise *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (Size)jarg2; 
  {
    try {
      result = (arg1)->dateAt(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1dates(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Exercise *arg1 = (Exercise *) 0 ;
  ext::shared_ptr< Exercise > *smartarg1 = 0 ;
  std::vector< Date > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(ext::shared_ptr<  Exercise > **)&jarg1;
  arg1 = (Exercise *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      result = (std::vector< Date > *) &(arg1)->dates();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Date > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1lastDate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Exercise *arg1 = (Exercise *) 0 ;
  ext::shared_ptr< Exercise const > *smartarg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(ext::shared_ptr< const Exercise > **)&jarg1;
  arg1 = (Exercise *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      result = ((Exercise const *)arg1)->lastDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1exerciseType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Exercise *arg1 = (Exercise *) 0 ;
  ext::shared_ptr< Exercise > *smartarg1 = 0 ;
  Exercise::Type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(ext::shared_ptr<  Exercise > **)&jarg1;
  arg1 = (Exercise *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      result = (Exercise::Type)Exercise_exerciseType(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Exercise(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Exercise *arg1 = (Exercise *) 0 ;
  ext::shared_ptr< Exercise > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(ext::shared_ptr<  Exercise > **)&jarg1;
  arg1 = (Exercise *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      (void)arg1; delete smartarg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1EuropeanExercise(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  EuropeanExercise *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (EuropeanExercise *)new EuropeanExercise((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  *(ext::shared_ptr<  EuropeanExercise > **)&jresult = result ? new ext::shared_ptr<  EuropeanExercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1EuropeanExercise(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  EuropeanExercise *arg1 = (EuropeanExercise *) 0 ;
  ext::shared_ptr< EuropeanExercise > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(ext::shared_ptr<  EuropeanExercise > **)&jarg1;
  arg1 = (EuropeanExercise *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      (void)arg1; delete smartarg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1AmericanExercise_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Date *arg2 = 0 ;
  bool arg3 ;
  AmericanExercise *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (AmericanExercise *)new AmericanExercise((Date const &)*arg1,(Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  *(ext::shared_ptr<  AmericanExercise > **)&jresult = result ? new ext::shared_ptr<  AmericanExercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1AmericanExercise_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Date *arg2 = 0 ;
  AmericanExercise *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (AmericanExercise *)new AmericanExercise((Date const &)*arg1,(Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  *(ext::shared_ptr<  AmericanExercise > **)&jresult = result ? new ext::shared_ptr<  AmericanExercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1AmericanExercise(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AmericanExercise *arg1 = (AmericanExercise *) 0 ;
  ext::shared_ptr< AmericanExercise > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(ext::shared_ptr<  AmericanExercise > **)&jarg1;
  arg1 = (AmericanExercise *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      (void)arg1; delete smartarg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BermudanExercise_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jlong jresult = 0 ;
  std::vector< Date > *arg1 = 0 ;
  bool arg2 ;
  BermudanExercise *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Date > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Date > const & reference is null");
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (BermudanExercise *)new BermudanExercise((std::vector< Date > const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  *(ext::shared_ptr<  BermudanExercise > **)&jresult = result ? new ext::shared_ptr<  BermudanExercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BermudanExercise_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< Date > *arg1 = 0 ;
  BermudanExercise *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Date > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Date > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (BermudanExercise *)new BermudanExercise((std::vector< Date > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  *(ext::shared_ptr<  BermudanExercise > **)&jresult = result ? new ext::shared_ptr<  BermudanExercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BermudanExercise(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  BermudanExercise *arg1 = (BermudanExercise *) 0 ;
  ext::shared_ptr< BermudanExercise > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(ext::shared_ptr<  BermudanExercise > **)&jarg1;
  arg1 = (BermudanExercise *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      (void)arg1; delete smartarg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RebatedExercise_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jobject jarg4_, jint jarg5) {
  jlong jresult = 0 ;
  Exercise *arg1 = 0 ;
  std::vector< Real > arg2 ;
  Natural arg3 ;
  Calendar *arg4 = 0 ;
  BusinessDayConvention arg5 ;
  std::vector< Real > const *argp2 ;
  RebatedExercise *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  
  arg1 = (Exercise *)((*(ext::shared_ptr< const Exercise > **)&jarg1) ? (*(ext::shared_ptr< const Exercise > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Exercise const & reference is null");
    return 0;
  } 
  argp2 = *(std::vector< Real > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< Real > const");
    return 0;
  }
  arg2 = *argp2; 
  arg3 = (Natural)jarg3; 
  arg4 = *(Calendar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg5 = (BusinessDayConvention)jarg5; 
  {
    try {
      result = (RebatedExercise *)new RebatedExercise((Exercise const &)*arg1,arg2,arg3,(Calendar const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  *(ext::shared_ptr<  RebatedExercise > **)&jresult = result ? new ext::shared_ptr<  RebatedExercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RebatedExercise_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  Exercise *arg1 = 0 ;
  std::vector< Real > arg2 ;
  Natural arg3 ;
  Calendar *arg4 = 0 ;
  std::vector< Real > const *argp2 ;
  RebatedExercise *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  
  arg1 = (Exercise *)((*(ext::shared_ptr< const Exercise > **)&jarg1) ? (*(ext::shared_ptr< const Exercise > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Exercise const & reference is null");
    return 0;
  } 
  argp2 = *(std::vector< Real > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< Real > const");
    return 0;
  }
  arg2 = *argp2; 
  arg3 = (Natural)jarg3; 
  arg4 = *(Calendar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  {
    try {
      result = (RebatedExercise *)new RebatedExercise((Exercise const &)*arg1,arg2,arg3,(Calendar const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  *(ext::shared_ptr<  RebatedExercise > **)&jresult = result ? new ext::shared_ptr<  RebatedExercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RebatedExercise_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  Exercise *arg1 = 0 ;
  std::vector< Real > arg2 ;
  Natural arg3 ;
  std::vector< Real > const *argp2 ;
  RebatedExercise *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  arg1 = (Exercise *)((*(ext::shared_ptr< const Exercise > **)&jarg1) ? (*(ext::shared_ptr< const Exercise > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Exercise const & reference is null");
    return 0;
  } 
  argp2 = *(std::vector< Real > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< Real > const");
    return 0;
  }
  arg2 = *argp2; 
  arg3 = (Natural)jarg3; 
  {
    try {
      result = (RebatedExercise *)new RebatedExercise((Exercise const &)*arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  *(ext::shared_ptr<  RebatedExercise > **)&jresult = result ? new ext::shared_ptr<  RebatedExercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RebatedExercise_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Exercise *arg1 = 0 ;
  std::vector< Real > arg2 ;
  std::vector< Real > const *argp2 ;
  RebatedExercise *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  arg1 = (Exercise *)((*(ext::shared_ptr< const Exercise > **)&jarg1) ? (*(ext::shared_ptr< const Exercise > **)&jarg1)->get() : 0);
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Exercise const & reference is null");
    return 0;
  } 
  argp2 = *(std::vector< Real > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< Real > const");
    return 0;
  }
  arg2 = *argp2; 
  {
    try {
      result = (RebatedExercise *)new RebatedExercise((Exercise const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  *(ext::shared_ptr<  RebatedExercise > **)&jresult = result ? new ext::shared_ptr<  RebatedExercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1RebatedExercise(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RebatedExercise *arg1 = (RebatedExercise *) 0 ;
  ext::shared_ptr< RebatedExercise > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(ext::shared_ptr<  RebatedExercise > **)&jarg1;
  arg1 = (RebatedExercise *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      (void)arg1; delete smartarg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SwingExercise(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< Date > *arg1 = 0 ;
  SwingExercise *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Date > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Date > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (SwingExercise *)new SwingExercise((std::vector< Date > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  *(ext::shared_ptr<  SwingExercise > **)&jresult = result ? new ext::shared_ptr<  SwingExercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SwingExercise(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SwingExercise *arg1 = (SwingExercise *) 0 ;
  ext::shared_ptr< SwingExercise > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(ext::shared_ptr<  SwingExercise > **)&jarg1;
  arg1 = (SwingExercise *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      (void)arg1; delete smartarg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Observable(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Observable *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Observable *)new Observable();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  *(ext::shared_ptr<  Observable > **)&jresult = result ? new ext::shared_ptr<  Observable >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Observable(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Observable *arg1 = (Observable *) 0 ;
  ext::shared_ptr< Observable > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(ext::shared_ptr<  Observable > **)&jarg1;
  arg1 = (Observable *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      (void)arg1; delete smartarg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Array_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Array *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Array *)new Array();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Array_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  jlong jresult = 0 ;
  Size arg1 ;
  Real arg2 ;
  Array *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Size)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Array *)new Array(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Array_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  Size arg1 ;
  Array *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Size)jarg1; 
  {
    try {
      result = (Array *)new Array(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Array_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Array *arg1 = 0 ;
  Array *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Array **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Array *)new Array((Array const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Array_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Array *arg1 = (Array *) 0 ;
  Size result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Array **)&jarg1; 
  {
    try {
      result = ((Array const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Array_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Array *arg1 = (Array *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Array **)&jarg1; 
  {
    try {
      result = Array___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_Array_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jdouble jresult = 0 ;
  Array *arg1 = (Array *) 0 ;
  Size arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Array **)&jarg1; 
  arg2 = (Size)jarg2; 
  {
    try {
      result = (Real)Array_get(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_Array_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  Array *arg1 = (Array *) 0 ;
  Size arg2 ;
  Real arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Array **)&jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      Array_set(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Array(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Array *arg1 = (Array *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Array **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_LexicographicalView_1xSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  DefaultLexicographicalView *arg1 = (DefaultLexicographicalView *) 0 ;
  Size result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DefaultLexicographicalView **)&jarg1; 
  {
    try {
      result = ((DefaultLexicographicalView const *)arg1)->xSize();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_LexicographicalView_1ySize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  DefaultLexicographicalView *arg1 = (DefaultLexicographicalView *) 0 ;
  Size result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DefaultLexicographicalView **)&jarg1; 
  {
    try {
      result = ((DefaultLexicographicalView const *)arg1)->ySize();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1LexicographicalView(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Array *arg1 = 0 ;
  Size arg2 ;
  DefaultLexicographicalView *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Array **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array & reference is null");
    return 0;
  } 
  arg2 = (Size)jarg2; 
  {
    try {
      result = (DefaultLexicographicalView *)new_DefaultLexicographicalView(*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(DefaultLexicographicalView **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_LexicographicalView_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  DefaultLexicographicalView *arg1 = (DefaultLexicographicalView *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DefaultLexicographicalView **)&jarg1; 
  {
    try {
      result = DefaultLexicographicalView___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1LexicographicalView(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  DefaultLexicographicalView *arg1 = (DefaultLexicographicalView *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DefaultLexicographicalView **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Matrix_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Matrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Matrix *)new Matrix();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Matrix_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jdouble jarg3) {
  jlong jresult = 0 ;
  Size arg1 ;
  Size arg2 ;
  Real arg3 ;
  Matrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Size)jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Matrix *)new Matrix(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Matrix_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  Size arg1 ;
  Size arg2 ;
  Matrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Size)jarg1; 
  arg2 = (Size)jarg2; 
  {
    try {
      result = (Matrix *)new Matrix(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Matrix_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Matrix *arg1 = 0 ;
  Matrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Matrix *)new Matrix((Matrix const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Matrix_1rows(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Matrix *arg1 = (Matrix *) 0 ;
  Size result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1; 
  {
    try {
      result = ((Matrix const *)arg1)->rows();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Matrix_1columns(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Matrix *arg1 = (Matrix *) 0 ;
  Size result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1; 
  {
    try {
      result = ((Matrix const *)arg1)->columns();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Matrix_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Matrix *arg1 = (Matrix *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1; 
  {
    try {
      result = Matrix___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_Matrix_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Matrix *arg1 = (Matrix *) 0 ;
  Size arg2 ;
  Size arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Size)jarg3; 
  {
    try {
      result = (Real)Matrix_get(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_Matrix_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jdouble jarg4) {
  Matrix *arg1 = (Matrix *) 0 ;
  Size arg2 ;
  Size arg3 ;
  Real arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Size)jarg3; 
  arg4 = (Real)jarg4; 
  {
    try {
      Matrix_set(arg1,arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Matrix(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Matrix *arg1 = (Matrix *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Matrix **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SalvagingAlgorithm(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SalvagingAlgorithm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (SalvagingAlgorithm *)new SalvagingAlgorithm();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(SalvagingAlgorithm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SalvagingAlgorithm(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SalvagingAlgorithm *arg1 = (SalvagingAlgorithm *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SalvagingAlgorithm **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_inverse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Matrix *arg1 = 0 ;
  Matrix result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
    return 0;
  } 
  {
    try {
      result = inverse((Matrix const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = new Matrix((const Matrix &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_transpose(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Matrix *arg1 = 0 ;
  Matrix result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
    return 0;
  } 
  {
    try {
      result = transpose((Matrix const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = new Matrix((const Matrix &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_outerProduct(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  Matrix result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Array **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  arg2 = *(Array **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = outerProduct((Array const &)*arg1,(Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = new Matrix((const Matrix &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_pseudoSqrt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  Matrix *arg1 = 0 ;
  SalvagingAlgorithm::Type arg2 ;
  Matrix result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
    return 0;
  } 
  arg2 = (SalvagingAlgorithm::Type)jarg2; 
  {
    try {
      result = pseudoSqrt((Matrix const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = new Matrix((const Matrix &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SVD(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Matrix *arg1 = 0 ;
  SVD *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
    return 0;
  } 
  {
    try {
      result = (SVD *)new SVD((Matrix const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(SVD **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_SVD_1U(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SVD *arg1 = (SVD *) 0 ;
  Matrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SVD **)&jarg1; 
  {
    try {
      result = (Matrix *) &((SVD const *)arg1)->U();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_SVD_1V(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SVD *arg1 = (SVD *) 0 ;
  Matrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SVD **)&jarg1; 
  {
    try {
      result = (Matrix *) &((SVD const *)arg1)->V();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_SVD_1S(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SVD *arg1 = (SVD *) 0 ;
  Matrix result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SVD **)&jarg1; 
  {
    try {
      result = ((SVD const *)arg1)->S();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = new Matrix((const Matrix &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_SVD_1singularValues(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SVD *arg1 = (SVD *) 0 ;
  Array *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SVD **)&jarg1; 
  {
    try {
      result = (Array *) &((SVD const *)arg1)->singularValues();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SVD(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SVD *arg1 = (SVD *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SVD **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1MatrixMultiplicationDelegate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  MatrixMultiplicationDelegate *arg1 = (MatrixMultiplicationDelegate *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MatrixMultiplicationDelegate **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_MatrixMultiplicationDelegate_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  MatrixMultiplicationDelegate *arg1 = (MatrixMultiplicationDelegate *) 0 ;
  Array *arg2 = 0 ;
  Array result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(MatrixMultiplicationDelegate **)&jarg1; 
  arg2 = *(Array **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((MatrixMultiplicationDelegate const *)arg1)->apply((Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = new Array((const Array &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1MatrixMultiplicationDelegate(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  MatrixMultiplicationDelegate *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (MatrixMultiplicationDelegate *)new MatrixMultiplicationDelegate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(MatrixMultiplicationDelegate **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_BiCGstab_1solve_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  BiCGstab *arg1 = (BiCGstab *) 0 ;
  Array *arg2 = 0 ;
  Array *arg3 = 0 ;
  ext::shared_ptr< BiCGstab const > *smartarg1 = 0 ;
  Array result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(ext::shared_ptr< const BiCGstab > **)&jarg1;
  arg1 = (BiCGstab *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(Array **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  arg3 = *(Array **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = BiCGstab_solve__SWIG_0((BiCGstab const *)arg1,(Array const &)*arg2,(Array const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = new Array((const Array &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_BiCGstab_1solve_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  BiCGstab *arg1 = (BiCGstab *) 0 ;
  Array *arg2 = 0 ;
  ext::shared_ptr< BiCGstab const > *smartarg1 = 0 ;
  Array result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(ext::shared_ptr< const BiCGstab > **)&jarg1;
  arg1 = (BiCGstab *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(Array **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = BiCGstab_solve__SWIG_0((BiCGstab const *)arg1,(Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = new Array((const Array &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BiCGstab_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  jlong jresult = 0 ;
  MatrixMultiplicationDelegate *arg1 = (MatrixMultiplicationDelegate *) 0 ;
  Size arg2 ;
  Real arg3 ;
  BiCGstab *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MatrixMultiplicationDelegate **)&jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (BiCGstab *)new_BiCGstab__SWIG_0(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  *(ext::shared_ptr<  BiCGstab > **)&jresult = result ? new ext::shared_ptr<  BiCGstab >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BiCGstab_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  MatrixMultiplicationDelegate *arg1 = (MatrixMultiplicationDelegate *) 0 ;
  Size arg2 ;
  Real arg3 ;
  MatrixMultiplicationDelegate *arg4 = (MatrixMultiplicationDelegate *) 0 ;
  BiCGstab *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(MatrixMultiplicationDelegate **)&jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Real)jarg3; 
  arg4 = *(MatrixMultiplicationDelegate **)&jarg4; 
  {
    try {
      result = (BiCGstab *)new_BiCGstab__SWIG_1(arg1,arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  *(ext::shared_ptr<  BiCGstab > **)&jresult = result ? new ext::shared_ptr<  BiCGstab >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BiCGstab(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  BiCGstab *arg1 = (BiCGstab *) 0 ;
  ext::shared_ptr< BiCGstab > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(ext::shared_ptr<  BiCGstab > **)&jarg1;
  arg1 = (BiCGstab *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      (void)arg1; delete smartarg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_GMRES_1solve_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  GMRES *arg1 = (GMRES *) 0 ;
  Array *arg2 = 0 ;
  Array *arg3 = 0 ;
  ext::shared_ptr< GMRES const > *smartarg1 = 0 ;
  Array result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  
  smartarg1 = *(ext::shared_ptr< const GMRES > **)&jarg1;
  arg1 = (GMRES *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(Array **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  arg3 = *(Array **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = GMRES_solve__SWIG_0((GMRES const *)arg1,(Array const &)*arg2,(Array const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = new Array((const Array &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_GMRES_1solve_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  GMRES *arg1 = (GMRES *) 0 ;
  Array *arg2 = 0 ;
  ext::shared_ptr< GMRES const > *smartarg1 = 0 ;
  Array result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(ext::shared_ptr< const GMRES > **)&jarg1;
  arg1 = (GMRES *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = *(Array **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = GMRES_solve__SWIG_0((GMRES const *)arg1,(Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = new Array((const Array &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_GMRES_1solveWithRestart_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  GMRES *arg1 = (GMRES *) 0 ;
  Size arg2 ;
  Array *arg3 = 0 ;
  Array *arg4 = 0 ;
  ext::shared_ptr< GMRES const > *smartarg1 = 0 ;
  Array result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  
  smartarg1 = *(ext::shared_ptr< const GMRES > **)&jarg1;
  arg1 = (GMRES *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (Size)jarg2; 
  arg3 = *(Array **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  arg4 = *(Array **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = GMRES_solveWithRestart__SWIG_0((GMRES const *)arg1,arg2,(Array const &)*arg3,(Array const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = new Array((const Array &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_GMRES_1solveWithRestart_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  GMRES *arg1 = (GMRES *) 0 ;
  Size arg2 ;
  Array *arg3 = 0 ;
  ext::shared_ptr< GMRES const > *smartarg1 = 0 ;
  Array result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  
  smartarg1 = *(ext::shared_ptr< const GMRES > **)&jarg1;
  arg1 = (GMRES *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (Size)jarg2; 
  arg3 = *(Array **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = GMRES_solveWithRestart__SWIG_0((GMRES const *)arg1,arg2,(Array const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = new Array((const Array &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1GMRES_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  jlong jresult = 0 ;
  MatrixMultiplicationDelegate *arg1 = (MatrixMultiplicationDelegate *) 0 ;
  Size arg2 ;
  Real arg3 ;
  GMRES *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MatrixMultiplicationDelegate **)&jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (GMRES *)new_GMRES__SWIG_0(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  *(ext::shared_ptr<  GMRES > **)&jresult = result ? new ext::shared_ptr<  GMRES >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1GMRES_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  MatrixMultiplicationDelegate *arg1 = (MatrixMultiplicationDelegate *) 0 ;
  Size arg2 ;
  Real arg3 ;
  MatrixMultiplicationProxy *arg4 = 0 ;
  GMRES *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(MatrixMultiplicationDelegate **)&jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Real)jarg3; 
  arg4 = *(MatrixMultiplicationProxy **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "MatrixMultiplicationProxy const & reference is null");
    return 0;
  } 
  {
    try {
      result = (GMRES *)new_GMRES__SWIG_1(arg1,arg2,arg3,(MatrixMultiplicationProxy const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  *(ext::shared_ptr<  GMRES > **)&jresult = result ? new ext::shared_ptr<  GMRES >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1GMRES(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GMRES *arg1 = (GMRES *) 0 ;
  ext::shared_ptr< GMRES > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(ext::shared_ptr<  GMRES > **)&jarg1;
  arg1 = (GMRES *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      (void)arg1; delete smartarg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_close_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2) {
  jboolean jresult = 0 ;
  Real arg1 ;
  Real arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Real)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (bool)close(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_close_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  Real arg1 ;
  Real arg2 ;
  Size arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Real)jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = (Size)jarg3; 
  {
    try {
      result = (bool)close(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_close_1enough_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2) {
  jboolean jresult = 0 ;
  Real arg1 ;
  Real arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Real)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (bool)close_enough(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_close_1enough_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  Real arg1 ;
  Real arg2 ;
  Size arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Real)jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = (Size)jarg3; 
  {
    try {
      result = (bool)close_enough(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnaryFunction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  UnaryFunctionDelegate *arg1 = (UnaryFunctionDelegate *) 0 ;
  UnaryFunction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(UnaryFunctionDelegate **)&jarg1; 
  {
    try {
      result = (UnaryFunction *)new UnaryFunction(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(UnaryFunction **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_UnaryFunction_1getValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  UnaryFunction *arg1 = (UnaryFunction *) 0 ;
  Real arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(UnaryFunction **)&jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)((UnaryFunction const *)arg1)->operator ()(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1UnaryFunction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  UnaryFunction *arg1 = (UnaryFunction *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(UnaryFunction **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1UnaryFunctionDelegate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  UnaryFunctionDelegate *arg1 = (UnaryFunctionDelegate *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(UnaryFunctionDelegate **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_UnaryFunctionDelegate_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  UnaryFunctionDelegate *arg1 = (UnaryFunctionDelegate *) 0 ;
  Real arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(UnaryFunctionDelegate **)&jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)((UnaryFunctionDelegate const *)arg1)->value(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_UnaryFunctionDelegate_1valueSwigExplicitUnaryFunctionDelegate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  UnaryFunctionDelegate *arg1 = (UnaryFunctionDelegate *) 0 ;
  Real arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(UnaryFunctionDelegate **)&jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)((UnaryFunctionDelegate const *)arg1)->UnaryFunctionDelegate::value(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnaryFunctionDelegate(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  UnaryFunctionDelegate *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (UnaryFunctionDelegate *)new SwigDirector_UnaryFunctionDelegate(jenv);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(UnaryFunctionDelegate **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_UnaryFunctionDelegate_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  UnaryFunctionDelegate *obj = *((UnaryFunctionDelegate **)&objarg);
  (void)jcls;
  SwigDirector_UnaryFunctionDelegate *director = static_cast<SwigDirector_UnaryFunctionDelegate *>(obj);
  director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_UnaryFunctionDelegate_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  UnaryFunctionDelegate *obj = *((UnaryFunctionDelegate **)&objarg);
  SwigDirector_UnaryFunctionDelegate *director = dynamic_cast<SwigDirector_UnaryFunctionDelegate *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BinaryFunction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  BinaryFunctionDelegate *arg1 = (BinaryFunctionDelegate *) 0 ;
  BinaryFunction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(BinaryFunctionDelegate **)&jarg1; 
  {
    try {
      result = (BinaryFunction *)new BinaryFunction(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(BinaryFunction **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BinaryFunction_1getValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  jdouble jresult = 0 ;
  BinaryFunction *arg1 = (BinaryFunction *) 0 ;
  Real arg2 ;
  Real arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(BinaryFunction **)&jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Real)((BinaryFunction const *)arg1)->operator ()(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BinaryFunction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  BinaryFunction *arg1 = (BinaryFunction *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BinaryFunction **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BinaryFunctionDelegate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  BinaryFunctionDelegate *arg1 = (BinaryFunctionDelegate *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BinaryFunctionDelegate **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BinaryFunctionDelegate_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  jdouble jresult = 0 ;
  BinaryFunctionDelegate *arg1 = (BinaryFunctionDelegate *) 0 ;
  Real arg2 ;
  Real arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(BinaryFunctionDelegate **)&jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Real)((BinaryFunctionDelegate const *)arg1)->value(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BinaryFunctionDelegate_1valueSwigExplicitBinaryFunctionDelegate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  jdouble jresult = 0 ;
  BinaryFunctionDelegate *arg1 = (BinaryFunctionDelegate *) 0 ;
  Real arg2 ;
  Real arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(BinaryFunctionDelegate **)&jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Real)((BinaryFunctionDelegate const *)arg1)->BinaryFunctionDelegate::value(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BinaryFunctionDelegate(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  BinaryFunctionDelegate *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (BinaryFunctionDelegate *)new SwigDirector_BinaryFunctionDelegate(jenv);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(BinaryFunctionDelegate **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_BinaryFunctionDelegate_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  BinaryFunctionDelegate *obj = *((BinaryFunctionDelegate **)&objarg);
  (void)jcls;
  SwigDirector_BinaryFunctionDelegate *director = static_cast<SwigDirector_BinaryFunctionDelegate *>(obj);
  director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_BinaryFunctionDelegate_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  BinaryFunctionDelegate *obj = *((BinaryFunctionDelegate **)&objarg);
  SwigDirector_BinaryFunctionDelegate *director = dynamic_cast<SwigDirector_BinaryFunctionDelegate *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JavaCostFunction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  CostFunctionDelegate *arg1 = (CostFunctionDelegate *) 0 ;
  JavaCostFunction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CostFunctionDelegate **)&jarg1; 
  {
    try {
      result = (JavaCostFunction *)new JavaCostFunction(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(JavaCostFunction **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1JavaCostFunction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  JavaCostFunction *arg1 = (JavaCostFunction *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(JavaCostFunction **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_JavaCostFunction_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jdouble jresult = 0 ;
  JavaCostFunction *arg1 = (JavaCostFunction *) 0 ;
  Array *arg2 = 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(JavaCostFunction **)&jarg1; 
  arg2 = *(Array **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Real)((JavaCostFunction const *)arg1)->value((Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_JavaCostFunction_1values(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  JavaCostFunction *arg1 = (JavaCostFunction *) 0 ;
  Array *arg2 = 0 ;
  Array result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(JavaCostFunction **)&jarg1; 
  arg2 = *(Array **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((JavaCostFunction const *)arg1)->values((Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = new Array((const Array &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CostFunctionDelegate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CostFunctionDelegate *arg1 = (CostFunctionDelegate *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CostFunctionDelegate **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_CostFunctionDelegate_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jdouble jresult = 0 ;
  CostFunctionDelegate *arg1 = (CostFunctionDelegate *) 0 ;
  Array *arg2 = 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CostFunctionDelegate **)&jarg1; 
  arg2 = *(Array **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Real)((CostFunctionDelegate const *)arg1)->value((Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_CostFunctionDelegate_1valueSwigExplicitCostFunctionDelegate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jdouble jresult = 0 ;
  CostFunctionDelegate *arg1 = (CostFunctionDelegate *) 0 ;
  Array *arg2 = 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CostFunctionDelegate **)&jarg1; 
  arg2 = *(Array **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Real)((CostFunctionDelegate const *)arg1)->CostFunctionDelegate::value((Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_CostFunctionDelegate_1values(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  CostFunctionDelegate *arg1 = (CostFunctionDelegate *) 0 ;
  Array *arg2 = 0 ;
  Array result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CostFunctionDelegate **)&jarg1; 
  arg2 = *(Array **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((CostFunctionDelegate const *)arg1)->values((Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = new Array((const Array &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_CostFunctionDelegate_1valuesSwigExplicitCostFunctionDelegate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  CostFunctionDelegate *arg1 = (CostFunctionDelegate *) 0 ;
  Array *arg2 = 0 ;
  Array result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CostFunctionDelegate **)&jarg1; 
  arg2 = *(Array **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((CostFunctionDelegate const *)arg1)->CostFunctionDelegate::values((Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = new Array((const Array &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CostFunctionDelegate(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  CostFunctionDelegate *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (CostFunctionDelegate *)new SwigDirector_CostFunctionDelegate(jenv);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(CostFunctionDelegate **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_CostFunctionDelegate_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  CostFunctionDelegate *obj = *((CostFunctionDelegate **)&objarg);
  (void)jcls;
  SwigDirector_CostFunctionDelegate *director = static_cast<SwigDirector_CostFunctionDelegate *>(obj);
  director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_CostFunctionDelegate_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  CostFunctionDelegate *obj = *((CostFunctionDelegate **)&objarg);
  SwigDirector_CostFunctionDelegate *director = dynamic_cast<SwigDirector_CostFunctionDelegate *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_Quote_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Quote *arg1 = (Quote *) 0 ;
  ext::shared_ptr< Quote const > *smartarg1 = 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(ext::shared_ptr< const Quote > **)&jarg1;
  arg1 = (Quote *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      result = (Real)((Quote const *)arg1)->value();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Quote_1isValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Quote *arg1 = (Quote *) 0 ;
  ext::shared_ptr< Quote const > *smartarg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(ext::shared_ptr< const Quote > **)&jarg1;
  arg1 = (Quote *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      result = (bool)((Quote const *)arg1)->isValid();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Quote(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Quote *arg1 = (Quote *) 0 ;
  ext::shared_ptr< Quote > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(ext::shared_ptr<  Quote > **)&jarg1;
  arg1 = (Quote *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      (void)arg1; delete smartarg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ext::shared_ptr< Quote > *arg1 = 0 ;
  ext::shared_ptr< Quote > tempnull1 ;
  Handle< Quote > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = jarg1 ? *(ext::shared_ptr< Quote > **)&jarg1 : &tempnull1; 
  {
    try {
      result = (Handle< Quote > *)new Handle< Quote >((ext::shared_ptr< Quote > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Handle< Quote > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandle_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Handle< Quote > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Handle< Quote > *)new Handle< Quote >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Handle< Quote > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandle_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle< Quote > *arg1 = (Handle< Quote > *) 0 ;
  ext::shared_ptr< Quote > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle< Quote > **)&jarg1; 
  {
    try {
      result = (arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(ext::shared_ptr< Quote > **)&jresult = result ? new ext::shared_ptr< Quote >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandle_1currentLink(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle< Quote > *arg1 = (Handle< Quote > *) 0 ;
  ext::shared_ptr< Quote > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle< Quote > **)&jarg1; 
  {
    try {
      result = (arg1)->currentLink();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(ext::shared_ptr< Quote > **)&jresult = result ? new ext::shared_ptr< Quote >(result) : 0; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandle_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Handle< Quote > *arg1 = (Handle< Quote > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle< Quote > **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandle_1asObservable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle< Quote > *arg1 = (Handle< Quote > *) 0 ;
  ext::shared_ptr< Observable > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle< Quote > **)&jarg1; 
  {
    try {
      result = Handle_Sl_Quote_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(ext::shared_ptr< Observable > **)&jresult = result ? new ext::shared_ptr< Observable >(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1QuoteHandle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Handle< Quote > *arg1 = (Handle< Quote > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Handle< Quote > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandle_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Handle< Quote > *arg1 = (Handle< Quote > *) 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle< Quote > **)&jarg1; 
  {
    try {
      result = (Real)(*arg1)->value();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandle_1isValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Handle< Quote > *arg1 = (Handle< Quote > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle< Quote > **)&jarg1; 
  {
    try {
      result = (bool)(*arg1)->isValid();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableQuoteHandle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ext::shared_ptr< Quote > *arg1 = 0 ;
  ext::shared_ptr< Quote > tempnull1 ;
  RelinkableHandle< Quote > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = jarg1 ? *(ext::shared_ptr< Quote > **)&jarg1 : &tempnull1; 
  {
    try {
      result = (RelinkableHandle< Quote > *)new RelinkableHandle< Quote >((ext::shared_ptr< Quote > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(RelinkableHandle< Quote > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableQuoteHandle_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  RelinkableHandle< Quote > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (RelinkableHandle< Quote > *)new RelinkableHandle< Quote >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(RelinkableHandle< Quote > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandle_1linkTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  RelinkableHandle< Quote > *arg1 = (RelinkableHandle< Quote > *) 0 ;
  ext::shared_ptr< Quote > *arg2 = 0 ;
  ext::shared_ptr< Quote > tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(RelinkableHandle< Quote > **)&jarg1; 
  arg2 = jarg2 ? *(ext::shared_ptr< Quote > **)&jarg2 : &tempnull2; 
  {
    try {
      (arg1)->linkTo((ext::shared_ptr< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandle_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  RelinkableHandle< Quote > *arg1 = (RelinkableHandle< Quote > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RelinkableHandle< Quote > **)&jarg1; 
  {
    try {
      RelinkableHandle_Sl_Quote_Sg__reset(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1RelinkableQuoteHandle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RelinkableHandle< Quote > *arg1 = (RelinkableHandle< Quote > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(RelinkableHandle< Quote > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SimpleQuote(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jlong jresult = 0 ;
  Real arg1 ;
  SimpleQuote *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Real)jarg1; 
  {
    try {
      result = (SimpleQuote *)new SimpleQuote(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  *(ext::shared_ptr<  SimpleQuote > **)&jresult = result ? new ext::shared_ptr<  SimpleQuote >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_SimpleQuote_1setValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  SimpleQuote *arg1 = (SimpleQuote *) 0 ;
  Real arg2 ;
  ext::shared_ptr< SimpleQuote > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(ext::shared_ptr<  SimpleQuote > **)&jarg1;
  arg1 = (SimpleQuote *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (Real)jarg2; 
  {
    try {
      (arg1)->setValue(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SimpleQuote(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SimpleQuote *arg1 = (SimpleQuote *) 0 ;
  ext::shared_ptr< SimpleQuote > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(ext::shared_ptr<  SimpleQuote > **)&jarg1;
  arg1 = (SimpleQuote *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      (void)arg1; delete smartarg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< ext::shared_ptr< Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< ext::shared_ptr< Quote > > *)new std::vector< ext::shared_ptr< Quote > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< ext::shared_ptr< Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< ext::shared_ptr< Quote > > *arg1 = 0 ;
  std::vector< ext::shared_ptr< Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< ext::shared_ptr< Quote > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< ext::shared_ptr< Quote > > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< ext::shared_ptr< Quote > > *)new std::vector< ext::shared_ptr< Quote > >((std::vector< ext::shared_ptr< Quote > > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< ext::shared_ptr< Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< ext::shared_ptr< Quote > > *arg1 = (std::vector< ext::shared_ptr< Quote > > *) 0 ;
  std::vector< ext::shared_ptr< Quote > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< ext::shared_ptr< Quote > > **)&jarg1; 
  {
    try {
      result = ((std::vector< ext::shared_ptr< Quote > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< ext::shared_ptr< Quote > > *arg1 = (std::vector< ext::shared_ptr< Quote > > *) 0 ;
  std::vector< ext::shared_ptr< Quote > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< ext::shared_ptr< Quote > > **)&jarg1; 
  arg2 = (std::vector< ext::shared_ptr< Quote > >::size_type)jarg2; 
  {
    try {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< ext::shared_ptr< Quote > > *arg1 = (std::vector< ext::shared_ptr< Quote > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< ext::shared_ptr< Quote > > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< ext::shared_ptr< Quote > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< ext::shared_ptr< Quote > > *arg1 = (std::vector< ext::shared_ptr< Quote > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< ext::shared_ptr< Quote > > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  ext::shared_ptr< Quote > *arg2 = 0 ;
  ext::shared_ptr< Quote > tempnull2 ;
  std::vector< ext::shared_ptr< Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(ext::shared_ptr< Quote > **)&jarg2 : &tempnull2; 
  {
    try {
      try {
        result = (std::vector< ext::shared_ptr< Quote > > *)new_std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg___SWIG_2(arg1,(ext::shared_ptr< Quote > const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< ext::shared_ptr< Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< ext::shared_ptr< Quote > > *arg1 = (std::vector< ext::shared_ptr< Quote > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< ext::shared_ptr< Quote > > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__doSize((std::vector< ext::shared_ptr< Quote > > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< ext::shared_ptr< Quote > > *arg1 = (std::vector< ext::shared_ptr< Quote > > *) 0 ;
  std::vector< ext::shared_ptr< Quote > >::value_type *arg2 = 0 ;
  std::vector< ext::shared_ptr< Quote > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< ext::shared_ptr< Quote > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< ext::shared_ptr< Quote > >::value_type **)&jarg2 : &tempnull2; 
  {
    try {
      std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__doAdd__SWIG_0(arg1,(ext::shared_ptr< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< ext::shared_ptr< Quote > > *arg1 = (std::vector< ext::shared_ptr< Quote > > *) 0 ;
  jint arg2 ;
  std::vector< ext::shared_ptr< Quote > >::value_type *arg3 = 0 ;
  std::vector< ext::shared_ptr< Quote > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< ext::shared_ptr< Quote > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< ext::shared_ptr< Quote > >::value_type **)&jarg3 : &tempnull3; 
  {
    try {
      try {
        std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(ext::shared_ptr< Quote > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< ext::shared_ptr< Quote > > *arg1 = (std::vector< ext::shared_ptr< Quote > > *) 0 ;
  jint arg2 ;
  std::vector< ext::shared_ptr< Quote > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< ext::shared_ptr< Quote > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< ext::shared_ptr< Quote > >::value_type **)&jresult = result ? new std::vector< ext::shared_ptr< Quote > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< ext::shared_ptr< Quote > > *arg1 = (std::vector< ext::shared_ptr< Quote > > *) 0 ;
  jint arg2 ;
  std::vector< ext::shared_ptr< Quote > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< ext::shared_ptr< Quote > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< ext::shared_ptr< Quote > >::value_type *) &std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< ext::shared_ptr< Quote > >::value_type **)&jresult = *result ? new std::vector< ext::shared_ptr< Quote > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< ext::shared_ptr< Quote > > *arg1 = (std::vector< ext::shared_ptr< Quote > > *) 0 ;
  jint arg2 ;
  std::vector< ext::shared_ptr< Quote > >::value_type *arg3 = 0 ;
  std::vector< ext::shared_ptr< Quote > >::value_type tempnull3 ;
  std::vector< ext::shared_ptr< Quote > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< ext::shared_ptr< Quote > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< ext::shared_ptr< Quote > >::value_type **)&jarg3 : &tempnull3; 
  {
    try {
      try {
        result = std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__doSet(arg1,arg2,(ext::shared_ptr< Quote > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< ext::shared_ptr< Quote > >::value_type **)&jresult = result ? new std::vector< ext::shared_ptr< Quote > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< ext::shared_ptr< Quote > > *arg1 = (std::vector< ext::shared_ptr< Quote > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< ext::shared_ptr< Quote > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1QuoteVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< ext::shared_ptr< Quote > > *arg1 = (std::vector< ext::shared_ptr< Quote > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< ext::shared_ptr< Quote > > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteVectorVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::vector< ext::shared_ptr< Quote > > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< std::vector< ext::shared_ptr< Quote > > > *)new std::vector< std::vector< ext::shared_ptr< Quote > > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< ext::shared_ptr< Quote > > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteVectorVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::vector< ext::shared_ptr< Quote > > > *arg1 = 0 ;
  std::vector< std::vector< ext::shared_ptr< Quote > > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< ext::shared_ptr< Quote > > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< ext::shared_ptr< Quote > > > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< std::vector< ext::shared_ptr< Quote > > > *)new std::vector< std::vector< ext::shared_ptr< Quote > > >((std::vector< std::vector< ext::shared_ptr< Quote > > > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< ext::shared_ptr< Quote > > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteVectorVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::vector< ext::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< ext::shared_ptr< Quote > > > *) 0 ;
  std::vector< std::vector< ext::shared_ptr< Quote > > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< ext::shared_ptr< Quote > > > **)&jarg1; 
  {
    try {
      result = ((std::vector< std::vector< ext::shared_ptr< Quote > > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVectorVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::vector< ext::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< ext::shared_ptr< Quote > > > *) 0 ;
  std::vector< std::vector< ext::shared_ptr< Quote > > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< ext::shared_ptr< Quote > > > **)&jarg1; 
  arg2 = (std::vector< std::vector< ext::shared_ptr< Quote > > >::size_type)jarg2; 
  {
    try {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_QuoteVectorVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::vector< ext::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< ext::shared_ptr< Quote > > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< ext::shared_ptr< Quote > > > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< std::vector< ext::shared_ptr< Quote > > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVectorVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::vector< ext::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< ext::shared_ptr< Quote > > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< ext::shared_ptr< Quote > > > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteVectorVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::vector< ext::shared_ptr< Quote > > *arg2 = 0 ;
  std::vector< std::vector< ext::shared_ptr< Quote > > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = *(std::vector< ext::shared_ptr< Quote > > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< ext::shared_ptr< Quote > > const & reference is null");
    return 0;
  } 
  {
    try {
      try {
        result = (std::vector< std::vector< ext::shared_ptr< Quote > > > *)new_std_vector_Sl_std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg___SWIG_2(arg1,(std::vector< ext::shared_ptr< Quote > > const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< ext::shared_ptr< Quote > > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_QuoteVectorVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::vector< ext::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< ext::shared_ptr< Quote > > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< ext::shared_ptr< Quote > > > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doSize((std::vector< std::vector< ext::shared_ptr< Quote > > > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVectorVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::vector< ext::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< ext::shared_ptr< Quote > > > *) 0 ;
  std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::vector< ext::shared_ptr< Quote > > > **)&jarg1; 
  arg2 = *(std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      std_vector_Sl_std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doAdd__SWIG_0(arg1,(std::vector< ext::shared_ptr< Quote > > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVectorVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::vector< ext::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< ext::shared_ptr< Quote > > > *) 0 ;
  jint arg2 ;
  std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::vector< ext::shared_ptr< Quote > > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::vector< ext::shared_ptr< Quote > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteVectorVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::vector< ext::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< ext::shared_ptr< Quote > > > *) 0 ;
  jint arg2 ;
  std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< ext::shared_ptr< Quote > > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type **)&jresult = new std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type((const std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteVectorVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::vector< ext::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< ext::shared_ptr< Quote > > > *) 0 ;
  jint arg2 ;
  std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< ext::shared_ptr< Quote > > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type *) &std_vector_Sl_std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteVectorVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::vector< ext::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< ext::shared_ptr< Quote > > > *) 0 ;
  jint arg2 ;
  std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type *arg3 = 0 ;
  std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::vector< ext::shared_ptr< Quote > > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type const & reference is null");
    return 0;
  } 
  {
    try {
      try {
        result = std_vector_Sl_std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doSet(arg1,arg2,(std::vector< ext::shared_ptr< Quote > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type **)&jresult = new std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type((const std::vector< std::vector< ext::shared_ptr< Quote > > >::value_type &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVectorVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::vector< ext::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< ext::shared_ptr< Quote > > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< ext::shared_ptr< Quote > > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_ext_shared_ptr_Sl_Quote_Sg__Sg__Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1QuoteVectorVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::vector< ext::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< ext::shared_ptr< Quote > > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::vector< ext::shared_ptr< Quote > > > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandleVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< Handle< Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< Handle< Quote > > *)new std::vector< Handle< Quote > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Handle< Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandleVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< Handle< Quote > > *arg1 = 0 ;
  std::vector< Handle< Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Handle< Quote > > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< Handle< Quote > > *)new std::vector< Handle< Quote > >((std::vector< Handle< Quote > > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Handle< Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  std::vector< Handle< Quote > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  {
    try {
      result = ((std::vector< Handle< Quote > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  std::vector< Handle< Quote > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  arg2 = (std::vector< Handle< Quote > >::size_type)jarg2; 
  {
    try {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< Handle< Quote > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandleVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  Handle< Quote > *arg2 = 0 ;
  std::vector< Handle< Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = *(Handle< Quote > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle< Quote > const & reference is null");
    return 0;
  } 
  {
    try {
      try {
        result = (std::vector< Handle< Quote > > *)new_std_vector_Sl_Handle_Sl_Quote_Sg__Sg___SWIG_2(arg1,(Handle< Quote > const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Handle< Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_Handle_Sl_Quote_Sg__Sg__doSize((std::vector< Handle< Quote > > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  std::vector< Handle< Quote > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  arg2 = *(std::vector< Handle< Quote > >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Handle< Quote > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      std_vector_Sl_Handle_Sl_Quote_Sg__Sg__doAdd__SWIG_0(arg1,(Handle< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  jint arg2 ;
  std::vector< Handle< Quote > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< Handle< Quote > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Handle< Quote > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Handle_Sl_Quote_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(Handle< Quote > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  jint arg2 ;
  std::vector< Handle< Quote > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_Handle_Sl_Quote_Sg__Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Handle< Quote > >::value_type **)&jresult = new std::vector< Handle< Quote > >::value_type((const std::vector< Handle< Quote > >::value_type &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  jint arg2 ;
  std::vector< Handle< Quote > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< Handle< Quote > >::value_type *) &std_vector_Sl_Handle_Sl_Quote_Sg__Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Handle< Quote > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  jint arg2 ;
  std::vector< Handle< Quote > >::value_type *arg3 = 0 ;
  std::vector< Handle< Quote > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< Handle< Quote > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Handle< Quote > >::value_type const & reference is null");
    return 0;
  } 
  {
    try {
      try {
        result = std_vector_Sl_Handle_Sl_Quote_Sg__Sg__doSet(arg1,arg2,(Handle< Quote > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Handle< Quote > >::value_type **)&jresult = new std::vector< Handle< Quote > >::value_type((const std::vector< Handle< Quote > >::value_type &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_Handle_Sl_Quote_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1QuoteHandleVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandleVectorVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::vector< Handle< Quote > > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< std::vector< Handle< Quote > > > *)new std::vector< std::vector< Handle< Quote > > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< Handle< Quote > > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandleVectorVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::vector< Handle< Quote > > > *arg1 = 0 ;
  std::vector< std::vector< Handle< Quote > > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< Handle< Quote > > > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< std::vector< Handle< Quote > > > *)new std::vector< std::vector< Handle< Quote > > >((std::vector< std::vector< Handle< Quote > > > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< Handle< Quote > > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVectorVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  std::vector< std::vector< Handle< Quote > > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  {
    try {
      result = ((std::vector< std::vector< Handle< Quote > > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVectorVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  std::vector< std::vector< Handle< Quote > > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  arg2 = (std::vector< std::vector< Handle< Quote > > >::size_type)jarg2; 
  {
    try {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVectorVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< std::vector< Handle< Quote > > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVectorVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandleVectorVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::vector< Handle< Quote > > *arg2 = 0 ;
  std::vector< std::vector< Handle< Quote > > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = *(std::vector< Handle< Quote > > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Handle< Quote > > const & reference is null");
    return 0;
  } 
  {
    try {
      try {
        result = (std::vector< std::vector< Handle< Quote > > > *)new_std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg___SWIG_2(arg1,(std::vector< Handle< Quote > > const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< Handle< Quote > > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVectorVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__doSize((std::vector< std::vector< Handle< Quote > > > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVectorVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  std::vector< std::vector< Handle< Quote > > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  arg2 = *(std::vector< std::vector< Handle< Quote > > >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< Handle< Quote > > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__doAdd__SWIG_0(arg1,(std::vector< Handle< Quote > > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVectorVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  jint arg2 ;
  std::vector< std::vector< Handle< Quote > > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< std::vector< Handle< Quote > > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< Handle< Quote > > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::vector< Handle< Quote > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVectorVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  jint arg2 ;
  std::vector< std::vector< Handle< Quote > > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< Handle< Quote > > >::value_type **)&jresult = new std::vector< std::vector< Handle< Quote > > >::value_type((const std::vector< std::vector< Handle< Quote > > >::value_type &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVectorVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  jint arg2 ;
  std::vector< std::vector< Handle< Quote > > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< std::vector< Handle< Quote > > >::value_type *) &std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< Handle< Quote > > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVectorVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  jint arg2 ;
  std::vector< std::vector< Handle< Quote > > >::value_type *arg3 = 0 ;
  std::vector< std::vector< Handle< Quote > > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< std::vector< Handle< Quote > > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< Handle< Quote > > >::value_type const & reference is null");
    return 0;
  } 
  {
    try {
      try {
        result = std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__doSet(arg1,arg2,(std::vector< Handle< Quote > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< Handle< Quote > > >::value_type **)&jresult = new std::vector< std::vector< Handle< Quote > > >::value_type((const std::vector< std::vector< Handle< Quote > > >::value_type &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVectorVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1QuoteHandleVectorVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableQuoteHandleVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< RelinkableHandle< Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< RelinkableHandle< Quote > > *)new std::vector< RelinkableHandle< Quote > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< RelinkableHandle< Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableQuoteHandleVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< RelinkableHandle< Quote > > *arg1 = 0 ;
  std::vector< RelinkableHandle< Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< RelinkableHandle< Quote > > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< RelinkableHandle< Quote > > *)new std::vector< RelinkableHandle< Quote > >((std::vector< RelinkableHandle< Quote > > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< RelinkableHandle< Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  std::vector< RelinkableHandle< Quote > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  {
    try {
      result = ((std::vector< RelinkableHandle< Quote > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  std::vector< RelinkableHandle< Quote > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  arg2 = (std::vector< RelinkableHandle< Quote > >::size_type)jarg2; 
  {
    try {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< RelinkableHandle< Quote > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableQuoteHandleVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  RelinkableHandle< Quote > *arg2 = 0 ;
  std::vector< RelinkableHandle< Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = *(RelinkableHandle< Quote > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "RelinkableHandle< Quote > const & reference is null");
    return 0;
  } 
  {
    try {
      try {
        result = (std::vector< RelinkableHandle< Quote > > *)new_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg___SWIG_2(arg1,(RelinkableHandle< Quote > const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< RelinkableHandle< Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__doSize((std::vector< RelinkableHandle< Quote > > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  std::vector< RelinkableHandle< Quote > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  arg2 = *(std::vector< RelinkableHandle< Quote > >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< RelinkableHandle< Quote > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__doAdd__SWIG_0(arg1,(RelinkableHandle< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  jint arg2 ;
  std::vector< RelinkableHandle< Quote > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< RelinkableHandle< Quote > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< RelinkableHandle< Quote > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(RelinkableHandle< Quote > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  jint arg2 ;
  std::vector< RelinkableHandle< Quote > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< RelinkableHandle< Quote > >::value_type **)&jresult = new std::vector< RelinkableHandle< Quote > >::value_type((const std::vector< RelinkableHandle< Quote > >::value_type &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  jint arg2 ;
  std::vector< RelinkableHandle< Quote > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< RelinkableHandle< Quote > >::value_type *) &std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< RelinkableHandle< Quote > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  jint arg2 ;
  std::vector< RelinkableHandle< Quote > >::value_type *arg3 = 0 ;
  std::vector< RelinkableHandle< Quote > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< RelinkableHandle< Quote > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< RelinkableHandle< Quote > >::value_type const & reference is null");
    return 0;
  } 
  {
    try {
      try {
        result = std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__doSet(arg1,arg2,(RelinkableHandle< Quote > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< RelinkableHandle< Quote > >::value_type **)&jresult = new std::vector< RelinkableHandle< Quote > >::value_type((const std::vector< RelinkableHandle< Quote > >::value_type &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1RelinkableQuoteHandleVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableQuoteHandleVectorVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< std::vector< RelinkableHandle< Quote > > > *)new std::vector< std::vector< RelinkableHandle< Quote > > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableQuoteHandleVectorVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< RelinkableHandle< Quote > > > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< std::vector< RelinkableHandle< Quote > > > *)new std::vector< std::vector< RelinkableHandle< Quote > > >((std::vector< std::vector< RelinkableHandle< Quote > > > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVectorVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  {
    try {
      result = ((std::vector< std::vector< RelinkableHandle< Quote > > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVectorVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  arg2 = (std::vector< std::vector< RelinkableHandle< Quote > > >::size_type)jarg2; 
  {
    try {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVectorVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< std::vector< RelinkableHandle< Quote > > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVectorVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableQuoteHandleVectorVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::vector< RelinkableHandle< Quote > > *arg2 = 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = *(std::vector< RelinkableHandle< Quote > > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< RelinkableHandle< Quote > > const & reference is null");
    return 0;
  } 
  {
    try {
      try {
        result = (std::vector< std::vector< RelinkableHandle< Quote > > > *)new_std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg___SWIG_2(arg1,(std::vector< RelinkableHandle< Quote > > const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVectorVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__doSize((std::vector< std::vector< RelinkableHandle< Quote > > > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVectorVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  arg2 = *(std::vector< std::vector< RelinkableHandle< Quote > > >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< RelinkableHandle< Quote > > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__doAdd__SWIG_0(arg1,(std::vector< RelinkableHandle< Quote > > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVectorVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  jint arg2 ;
  std::vector< std::vector< RelinkableHandle< Quote > > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< std::vector< RelinkableHandle< Quote > > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< RelinkableHandle< Quote > > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::vector< RelinkableHandle< Quote > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVectorVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  jint arg2 ;
  std::vector< std::vector< RelinkableHandle< Quote > > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< RelinkableHandle< Quote > > >::value_type **)&jresult = new std::vector< std::vector< RelinkableHandle< Quote > > >::value_type((const std::vector< std::vector< RelinkableHandle< Quote > > >::value_type &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVectorVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  jint arg2 ;
  std::vector< std::vector< RelinkableHandle< Quote > > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< std::vector< RelinkableHandle< Quote > > >::value_type *) &std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< RelinkableHandle< Quote > > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVectorVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  jint arg2 ;
  std::vector< std::vector< RelinkableHandle< Quote > > >::value_type *arg3 = 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< std::vector< RelinkableHandle< Quote > > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< RelinkableHandle< Quote > > >::value_type const & reference is null");
    return 0;
  } 
  {
    try {
      try {
        result = std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__doSet(arg1,arg2,(std::vector< RelinkableHandle< Quote > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< RelinkableHandle< Quote > > >::value_type **)&jresult = new std::vector< std::vector< RelinkableHandle< Quote > > >::value_type((const std::vector< std::vector< RelinkableHandle< Quote > > >::value_type &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVectorVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1RelinkableQuoteHandleVectorVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1isWeekend(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Weekday arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = (Weekday)jarg2; 
  {
    try {
      result = (bool)(arg1)->isWeekend(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1endOfMonth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (arg1)->endOfMonth((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1isBusinessDay(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)(arg1)->isBusinessDay((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1isHoliday(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)(arg1)->isHoliday((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1isEndOfMonth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)(arg1)->isEndOfMonth((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1addHoliday(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->addHoliday((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1removeHoliday(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->removeHoliday((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1adjust_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  BusinessDayConvention arg3 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (BusinessDayConvention)jarg3; 
  {
    try {
      result = (arg1)->adjust((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1adjust_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (arg1)->adjust((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4, jint jarg5, jboolean jarg6) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Integer arg3 ;
  TimeUnit arg4 ;
  BusinessDayConvention arg5 ;
  bool arg6 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Integer)jarg3; 
  arg4 = (TimeUnit)jarg4; 
  arg5 = (BusinessDayConvention)jarg5; 
  arg6 = jarg6 ? true : false; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,arg3,arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Integer arg3 ;
  TimeUnit arg4 ;
  BusinessDayConvention arg5 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Integer)jarg3; 
  arg4 = (TimeUnit)jarg4; 
  arg5 = (BusinessDayConvention)jarg5; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Integer arg3 ;
  TimeUnit arg4 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Integer)jarg3; 
  arg4 = (TimeUnit)jarg4; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jint jarg4, jboolean jarg5) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Period *arg3 = 0 ;
  BusinessDayConvention arg4 ;
  bool arg5 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Period **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
    return 0;
  } 
  arg4 = (BusinessDayConvention)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jint jarg4) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Period *arg3 = 0 ;
  BusinessDayConvention arg4 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Period **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
    return 0;
  } 
  arg4 = (BusinessDayConvention)jarg4; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Period *arg3 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Period **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
    return 0;
  } 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1businessDaysBetween_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jboolean jarg4, jboolean jarg5) {
  jint jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  bool arg4 ;
  bool arg5 ;
  BigInteger result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = jarg4 ? true : false; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (BigInteger)(arg1)->businessDaysBetween((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1businessDaysBetween_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jboolean jarg4) {
  jint jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  bool arg4 ;
  BigInteger result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (BigInteger)(arg1)->businessDaysBetween((Date const &)*arg2,(Date const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1businessDaysBetween_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  BigInteger result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (BigInteger)(arg1)->businessDaysBetween((Date const &)*arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1holidayList_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jboolean jarg4) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  bool arg4 ;
  std::vector< Date > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (arg1)->holidayList((Date const &)*arg2,(Date const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Date > **)&jresult = new std::vector< Date >((const std::vector< Date > &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1holidayList_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  std::vector< Date > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (arg1)->holidayList((Date const &)*arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Date > **)&jresult = new std::vector< Date >((const std::vector< Date > &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1businessDayList(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  std::vector< Date > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (arg1)->businessDayList((Date const &)*arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Date > **)&jresult = new std::vector< Date >((const std::vector< Date > &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Calendar **)&jarg1; 
  {
    try {
      result = (arg1)->name();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Calendar **)&jarg1; 
  {
    try {
      result = Calendar___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Calendar *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Calendar **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Calendar___eq__(arg1,(Calendar const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1unEquals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Calendar *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Calendar **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Calendar___ne__(arg1,(Calendar const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Calendar(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Calendar *arg1 = (Calendar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Calendar **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Argentina_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Argentina::Market arg1 ;
  QuantLib::Argentina *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Argentina::Market)jarg1; 
  {
    try {
      result = (QuantLib::Argentina *)new QuantLib::Argentina(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Argentina **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Argentina_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Argentina *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Argentina *)new QuantLib::Argentina();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Argentina **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Argentina(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Argentina *arg1 = (QuantLib::Argentina *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Argentina **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Australia(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Australia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Australia *)new QuantLib::Australia();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Australia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Australia(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Australia *arg1 = (QuantLib::Australia *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Australia **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Brazil_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Brazil::Market arg1 ;
  QuantLib::Brazil *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Brazil::Market)jarg1; 
  {
    try {
      result = (QuantLib::Brazil *)new QuantLib::Brazil(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Brazil **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Brazil_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Brazil *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Brazil *)new QuantLib::Brazil();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Brazil **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Brazil(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Brazil *arg1 = (QuantLib::Brazil *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Brazil **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Canada_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Canada::Market arg1 ;
  QuantLib::Canada *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Canada::Market)jarg1; 
  {
    try {
      result = (QuantLib::Canada *)new QuantLib::Canada(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Canada **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Canada_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Canada *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Canada *)new QuantLib::Canada();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Canada **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Canada(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Canada *arg1 = (QuantLib::Canada *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Canada **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Chile_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Chile::Market arg1 ;
  QuantLib::Chile *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Chile::Market)jarg1; 
  {
    try {
      result = (QuantLib::Chile *)new QuantLib::Chile(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Chile **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Chile_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Chile *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Chile *)new QuantLib::Chile();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Chile **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Chile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Chile *arg1 = (QuantLib::Chile *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Chile **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1China_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::China::Market arg1 ;
  QuantLib::China *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::China::Market)jarg1; 
  {
    try {
      result = (QuantLib::China *)new QuantLib::China(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::China **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1China_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::China *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::China *)new QuantLib::China();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::China **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1China(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::China *arg1 = (QuantLib::China *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::China **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CzechRepublic_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::CzechRepublic::Market arg1 ;
  QuantLib::CzechRepublic *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::CzechRepublic::Market)jarg1; 
  {
    try {
      result = (QuantLib::CzechRepublic *)new QuantLib::CzechRepublic(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::CzechRepublic **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CzechRepublic_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::CzechRepublic *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::CzechRepublic *)new QuantLib::CzechRepublic();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::CzechRepublic **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CzechRepublic(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::CzechRepublic *arg1 = (QuantLib::CzechRepublic *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::CzechRepublic **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Denmark(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Denmark *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Denmark *)new QuantLib::Denmark();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Denmark **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Denmark(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Denmark *arg1 = (QuantLib::Denmark *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Denmark **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Finland(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Finland *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Finland *)new QuantLib::Finland();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Finland **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Finland(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Finland *arg1 = (QuantLib::Finland *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Finland **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1France_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::France::Market arg1 ;
  QuantLib::France *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::France::Market)jarg1; 
  {
    try {
      result = (QuantLib::France *)new QuantLib::France(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::France **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1France_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::France *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::France *)new QuantLib::France();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::France **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1France(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::France *arg1 = (QuantLib::France *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::France **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Germany_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Germany::Market arg1 ;
  QuantLib::Germany *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Germany::Market)jarg1; 
  {
    try {
      result = (QuantLib::Germany *)new QuantLib::Germany(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Germany **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Germany_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Germany *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Germany *)new QuantLib::Germany();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Germany **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Germany(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Germany *arg1 = (QuantLib::Germany *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Germany **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1HongKong_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::HongKong::Market arg1 ;
  QuantLib::HongKong *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::HongKong::Market)jarg1; 
  {
    try {
      result = (QuantLib::HongKong *)new QuantLib::HongKong(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::HongKong **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1HongKong_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::HongKong *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::HongKong *)new QuantLib::HongKong();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::HongKong **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1HongKong(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::HongKong *arg1 = (QuantLib::HongKong *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::HongKong **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Hungary(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Hungary *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Hungary *)new QuantLib::Hungary();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Hungary **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Hungary(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Hungary *arg1 = (QuantLib::Hungary *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Hungary **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Iceland_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Iceland::Market arg1 ;
  QuantLib::Iceland *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Iceland::Market)jarg1; 
  {
    try {
      result = (QuantLib::Iceland *)new QuantLib::Iceland(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Iceland **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Iceland_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Iceland *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Iceland *)new QuantLib::Iceland();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Iceland **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Iceland(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Iceland *arg1 = (QuantLib::Iceland *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Iceland **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1India_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::India::Market arg1 ;
  QuantLib::India *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::India::Market)jarg1; 
  {
    try {
      result = (QuantLib::India *)new QuantLib::India(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::India **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1India_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::India *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::India *)new QuantLib::India();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::India **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1India(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::India *arg1 = (QuantLib::India *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::India **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Indonesia_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Indonesia::Market arg1 ;
  QuantLib::Indonesia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Indonesia::Market)jarg1; 
  {
    try {
      result = (QuantLib::Indonesia *)new QuantLib::Indonesia(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Indonesia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Indonesia_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Indonesia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Indonesia *)new QuantLib::Indonesia();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Indonesia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Indonesia(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Indonesia *arg1 = (QuantLib::Indonesia *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Indonesia **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Israel_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Israel::Market arg1 ;
  QuantLib::Israel *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Israel::Market)jarg1; 
  {
    try {
      result = (QuantLib::Israel *)new QuantLib::Israel(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Israel **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Israel_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Israel *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Israel *)new QuantLib::Israel();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Israel **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Israel(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Israel *arg1 = (QuantLib::Israel *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Israel **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Italy_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Italy::Market arg1 ;
  QuantLib::Italy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Italy::Market)jarg1; 
  {
    try {
      result = (QuantLib::Italy *)new QuantLib::Italy(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Italy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Italy_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Italy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Italy *)new QuantLib::Italy();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Italy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Italy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Italy *arg1 = (QuantLib::Italy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Italy **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Japan(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Japan *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Japan *)new QuantLib::Japan();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Japan **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Japan(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Japan *arg1 = (QuantLib::Japan *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Japan **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Mexico_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Mexico::Market arg1 ;
  QuantLib::Mexico *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Mexico::Market)jarg1; 
  {
    try {
      result = (QuantLib::Mexico *)new QuantLib::Mexico(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Mexico **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Mexico_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Mexico *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Mexico *)new QuantLib::Mexico();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Mexico **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Mexico(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Mexico *arg1 = (QuantLib::Mexico *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Mexico **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NewZealand(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::NewZealand *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::NewZealand *)new QuantLib::NewZealand();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::NewZealand **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1NewZealand(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::NewZealand *arg1 = (QuantLib::NewZealand *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::NewZealand **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Norway(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Norway *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Norway *)new QuantLib::Norway();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Norway **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Norway(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Norway *arg1 = (QuantLib::Norway *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Norway **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Poland(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Poland *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Poland *)new QuantLib::Poland();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Poland **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Poland(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Poland *arg1 = (QuantLib::Poland *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Poland **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Russia_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Russia::Market arg1 ;
  QuantLib::Russia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Russia::Market)jarg1; 
  {
    try {
      result = (QuantLib::Russia *)new QuantLib::Russia(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Russia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Russia_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Russia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Russia *)new QuantLib::Russia();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Russia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Russia(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Russia *arg1 = (QuantLib::Russia *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Russia **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Romania(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Romania *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Romania *)new QuantLib::Romania();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Romania **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Romania(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Romania *arg1 = (QuantLib::Romania *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Romania **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SaudiArabia_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::SaudiArabia::Market arg1 ;
  QuantLib::SaudiArabia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::SaudiArabia::Market)jarg1; 
  {
    try {
      result = (QuantLib::SaudiArabia *)new QuantLib::SaudiArabia(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SaudiArabia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SaudiArabia_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::SaudiArabia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::SaudiArabia *)new QuantLib::SaudiArabia();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SaudiArabia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SaudiArabia(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::SaudiArabia *arg1 = (QuantLib::SaudiArabia *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::SaudiArabia **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Singapore_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Singapore::Market arg1 ;
  QuantLib::Singapore *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Singapore::Market)jarg1; 
  {
    try {
      result = (QuantLib::Singapore *)new QuantLib::Singapore(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Singapore **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Singapore_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Singapore *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Singapore *)new QuantLib::Singapore();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Singapore **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Singapore(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Singapore *arg1 = (QuantLib::Singapore *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Singapore **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Slovakia_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Slovakia::Market arg1 ;
  QuantLib::Slovakia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Slovakia::Market)jarg1; 
  {
    try {
      result = (QuantLib::Slovakia *)new QuantLib::Slovakia(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Slovakia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Slovakia_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Slovakia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Slovakia *)new QuantLib::Slovakia();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Slovakia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Slovakia(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Slovakia *arg1 = (QuantLib::Slovakia *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Slovakia **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SouthAfrica(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::SouthAfrica *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::SouthAfrica *)new QuantLib::SouthAfrica();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SouthAfrica **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SouthAfrica(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::SouthAfrica *arg1 = (QuantLib::SouthAfrica *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::SouthAfrica **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SouthKorea_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::SouthKorea::Market arg1 ;
  QuantLib::SouthKorea *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::SouthKorea::Market)jarg1; 
  {
    try {
      result = (QuantLib::SouthKorea *)new QuantLib::SouthKorea(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SouthKorea **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SouthKorea_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::SouthKorea *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::SouthKorea *)new QuantLib::SouthKorea();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SouthKorea **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SouthKorea(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::SouthKorea *arg1 = (QuantLib::SouthKorea *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::SouthKorea **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Sweden(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Sweden *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Sweden *)new QuantLib::Sweden();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Sweden **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Sweden(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Sweden *arg1 = (QuantLib::Sweden *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Sweden **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Switzerland(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Switzerland *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Switzerland *)new QuantLib::Switzerland();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Switzerland **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Switzerland(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Switzerland *arg1 = (QuantLib::Switzerland *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Switzerland **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
