/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.0
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */


#ifndef SWIGCSHARP
#define SWIGCSHARP
#endif

#define SWIG_DIRECTORS


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


#include <stdlib.h>
#include <string.h>
#include <stdio.h>


/* Support for throwing C# exceptions from C/C++. There are two types: 
 * Exceptions that take a message and ArgumentExceptions that take a message and a parameter name. */
typedef enum {
  SWIG_CSharpApplicationException,
  SWIG_CSharpArithmeticException,
  SWIG_CSharpDivideByZeroException,
  SWIG_CSharpIndexOutOfRangeException,
  SWIG_CSharpInvalidCastException,
  SWIG_CSharpInvalidOperationException,
  SWIG_CSharpIOException,
  SWIG_CSharpNullReferenceException,
  SWIG_CSharpOutOfMemoryException,
  SWIG_CSharpOverflowException,
  SWIG_CSharpSystemException
} SWIG_CSharpExceptionCodes;

typedef enum {
  SWIG_CSharpArgumentException,
  SWIG_CSharpArgumentNullException,
  SWIG_CSharpArgumentOutOfRangeException
} SWIG_CSharpExceptionArgumentCodes;

typedef void (SWIGSTDCALL* SWIG_CSharpExceptionCallback_t)(const char *);
typedef void (SWIGSTDCALL* SWIG_CSharpExceptionArgumentCallback_t)(const char *, const char *);

typedef struct {
  SWIG_CSharpExceptionCodes code;
  SWIG_CSharpExceptionCallback_t callback;
} SWIG_CSharpException_t;

typedef struct {
  SWIG_CSharpExceptionArgumentCodes code;
  SWIG_CSharpExceptionArgumentCallback_t callback;
} SWIG_CSharpExceptionArgument_t;

static SWIG_CSharpException_t SWIG_csharp_exceptions[] = {
  { SWIG_CSharpApplicationException, NULL },
  { SWIG_CSharpArithmeticException, NULL },
  { SWIG_CSharpDivideByZeroException, NULL },
  { SWIG_CSharpIndexOutOfRangeException, NULL },
  { SWIG_CSharpInvalidCastException, NULL },
  { SWIG_CSharpInvalidOperationException, NULL },
  { SWIG_CSharpIOException, NULL },
  { SWIG_CSharpNullReferenceException, NULL },
  { SWIG_CSharpOutOfMemoryException, NULL },
  { SWIG_CSharpOverflowException, NULL },
  { SWIG_CSharpSystemException, NULL }
};

static SWIG_CSharpExceptionArgument_t SWIG_csharp_exceptions_argument[] = {
  { SWIG_CSharpArgumentException, NULL },
  { SWIG_CSharpArgumentNullException, NULL },
  { SWIG_CSharpArgumentOutOfRangeException, NULL }
};

static void SWIGUNUSED SWIG_CSharpSetPendingException(SWIG_CSharpExceptionCodes code, const char *msg) {
  SWIG_CSharpExceptionCallback_t callback = SWIG_csharp_exceptions[SWIG_CSharpApplicationException].callback;
  if ((size_t)code < sizeof(SWIG_csharp_exceptions)/sizeof(SWIG_CSharpException_t)) {
    callback = SWIG_csharp_exceptions[code].callback;
  }
  callback(msg);
}

static void SWIGUNUSED SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpExceptionArgumentCodes code, const char *msg, const char *param_name) {
  SWIG_CSharpExceptionArgumentCallback_t callback = SWIG_csharp_exceptions_argument[SWIG_CSharpArgumentException].callback;
  if ((size_t)code < sizeof(SWIG_csharp_exceptions_argument)/sizeof(SWIG_CSharpExceptionArgument_t)) {
    callback = SWIG_csharp_exceptions_argument[code].callback;
  }
  callback(msg, param_name);
}


#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT void SWIGSTDCALL SWIGRegisterExceptionCallbacks_NQuantLibc(
                                                SWIG_CSharpExceptionCallback_t applicationCallback,
                                                SWIG_CSharpExceptionCallback_t arithmeticCallback,
                                                SWIG_CSharpExceptionCallback_t divideByZeroCallback, 
                                                SWIG_CSharpExceptionCallback_t indexOutOfRangeCallback, 
                                                SWIG_CSharpExceptionCallback_t invalidCastCallback,
                                                SWIG_CSharpExceptionCallback_t invalidOperationCallback,
                                                SWIG_CSharpExceptionCallback_t ioCallback,
                                                SWIG_CSharpExceptionCallback_t nullReferenceCallback,
                                                SWIG_CSharpExceptionCallback_t outOfMemoryCallback, 
                                                SWIG_CSharpExceptionCallback_t overflowCallback, 
                                                SWIG_CSharpExceptionCallback_t systemCallback) {
  SWIG_csharp_exceptions[SWIG_CSharpApplicationException].callback = applicationCallback;
  SWIG_csharp_exceptions[SWIG_CSharpArithmeticException].callback = arithmeticCallback;
  SWIG_csharp_exceptions[SWIG_CSharpDivideByZeroException].callback = divideByZeroCallback;
  SWIG_csharp_exceptions[SWIG_CSharpIndexOutOfRangeException].callback = indexOutOfRangeCallback;
  SWIG_csharp_exceptions[SWIG_CSharpInvalidCastException].callback = invalidCastCallback;
  SWIG_csharp_exceptions[SWIG_CSharpInvalidOperationException].callback = invalidOperationCallback;
  SWIG_csharp_exceptions[SWIG_CSharpIOException].callback = ioCallback;
  SWIG_csharp_exceptions[SWIG_CSharpNullReferenceException].callback = nullReferenceCallback;
  SWIG_csharp_exceptions[SWIG_CSharpOutOfMemoryException].callback = outOfMemoryCallback;
  SWIG_csharp_exceptions[SWIG_CSharpOverflowException].callback = overflowCallback;
  SWIG_csharp_exceptions[SWIG_CSharpSystemException].callback = systemCallback;
}

#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT void SWIGSTDCALL SWIGRegisterExceptionArgumentCallbacks_NQuantLibc(
                                                SWIG_CSharpExceptionArgumentCallback_t argumentCallback,
                                                SWIG_CSharpExceptionArgumentCallback_t argumentNullCallback,
                                                SWIG_CSharpExceptionArgumentCallback_t argumentOutOfRangeCallback) {
  SWIG_csharp_exceptions_argument[SWIG_CSharpArgumentException].callback = argumentCallback;
  SWIG_csharp_exceptions_argument[SWIG_CSharpArgumentNullException].callback = argumentNullCallback;
  SWIG_csharp_exceptions_argument[SWIG_CSharpArgumentOutOfRangeException].callback = argumentOutOfRangeCallback;
}


/* Callback for returning strings to C# without leaking memory */
typedef char * (SWIGSTDCALL* SWIG_CSharpStringHelperCallback)(const char *);
static SWIG_CSharpStringHelperCallback SWIG_csharp_string_callback = NULL;


#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT void SWIGSTDCALL SWIGRegisterStringCallback_NQuantLibc(SWIG_CSharpStringHelperCallback callback) {
  SWIG_csharp_string_callback = callback;
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, msg, ""); return nullreturn; } else

/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1
#define  SWIG_IOError        	   -2
#define  SWIG_RuntimeError   	   -3
#define  SWIG_IndexError     	   -4
#define  SWIG_TypeError      	   -5
#define  SWIG_DivisionByZero 	   -6
#define  SWIG_OverflowError  	   -7
#define  SWIG_SyntaxError    	   -8
#define  SWIG_ValueError     	   -9
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12
#define  SWIG_NullReferenceError   -13



/* -----------------------------------------------------------------------------
 * director_common.swg
 *
 * This file contains support for director classes which is common between
 * languages.
 * ----------------------------------------------------------------------------- */

/*
  Use -DSWIG_DIRECTOR_STATIC if you prefer to avoid the use of the
  'Swig' namespace. This could be useful for multi-modules projects.
*/
#ifdef SWIG_DIRECTOR_STATIC
/* Force anonymous (static) namespace */
#define Swig
#endif
/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes so that C# proxy
 * methods can be called from C++.
 * ----------------------------------------------------------------------------- */

#if defined(DEBUG_DIRECTOR_OWNED)
#include <iostream>
#endif
#include <string>
#include <exception>

namespace Swig {
  /* Director base class - not currently used in C# directors */
  class Director {
  };

  /* Base class for director exceptions */
  class DirectorException : public std::exception {
  protected:
    std::string swig_msg;

  public:
    DirectorException(const char *msg) : swig_msg(msg) {
    }

    DirectorException(const std::string &msg) : swig_msg(msg) {
    }

    virtual ~DirectorException() throw() {
    }

    const char *what() const throw() {
      return swig_msg.c_str();
    }
  };

  /* Pure virtual method exception */
  class DirectorPureVirtualException : public DirectorException {
  public:
    DirectorPureVirtualException(const char *msg) : DirectorException(std::string("Attempt to invoke pure virtual method ") + msg) {
    }

    static void raise(const char *msg) {
      throw DirectorPureVirtualException(msg);
    }
  };
}


SWIGINTERN void SWIG_CSharpException(int code, const char *msg) {
  if (code == SWIG_ValueError) {
    SWIG_CSharpExceptionArgumentCodes exception_code = SWIG_CSharpArgumentOutOfRangeException;
    SWIG_CSharpSetPendingExceptionArgument(exception_code, msg, 0);
  } else {
    SWIG_CSharpExceptionCodes exception_code = SWIG_CSharpApplicationException;
    switch(code) {
    case SWIG_MemoryError:
      exception_code = SWIG_CSharpOutOfMemoryException;
      break;
    case SWIG_IndexError:
      exception_code = SWIG_CSharpIndexOutOfRangeException;
      break;
    case SWIG_DivisionByZero:
      exception_code = SWIG_CSharpDivideByZeroException;
      break;
    case SWIG_IOError:
      exception_code = SWIG_CSharpIOException;
      break;
    case SWIG_OverflowError:
      exception_code = SWIG_CSharpOverflowException;
      break;
    case SWIG_RuntimeError:
    case SWIG_TypeError:
    case SWIG_SyntaxError:
    case SWIG_SystemError:
    case SWIG_UnknownError:
    default:
      exception_code = SWIG_CSharpApplicationException;
      break;
    }
    SWIG_CSharpSetPendingException(exception_code, msg);
  }
}


#include <typeinfo>
#include <stdexcept>


#include <ql/quantlib.hpp>

#if QL_HEX_VERSION < 0x011600f0
    #error using an old version of QuantLib, please update
#endif

#ifdef BOOST_MSVC
#ifdef QL_ENABLE_THREAD_SAFE_OBSERVER_PATTERN
#define BOOST_LIB_NAME boost_thread
#include <boost/config/auto_link.hpp>
#undef BOOST_LIB_NAME
#define BOOST_LIB_NAME boost_system
#include <boost/config/auto_link.hpp>
#undef BOOST_LIB_NAME
#endif
#endif

#if defined (SWIGJAVA) || defined (SWIGCSHARP) 
  #ifndef QL_ENABLE_THREAD_SAFE_OBSERVER_PATTERN
    #ifdef BOOST_MSVC
      #pragma message(\
          "Quantlib has not been compiled with the thread-safe "           \
          "observer pattern being enabled. This can lead to spurious "     \
          "crashes or pure virtual function call within the JVM or .NET "  \
          "ecosystem due to the async garbage collector. Please consider " \
          "enabling QL_ENABLE_THREAD_SAFE_OBSERVER_PATTERN "               \
          "in ql/userconfig.hpp.")
    #else
      #warning \
          Quantlib has not been compiled with the thread-safe           \
          observer pattern being enabled. This can lead to spurious     \
          crashes or pure virtual function call within the JVM or .NET  \
          ecosystem due to the async garbage collector. Please consider \
          passing --enable-thread-safe-observer-pattern when using the  \
          GNU autoconf configure script.
    #endif
  #endif
#endif


// add here SWIG version check

#if defined(_MSC_VER)         // Microsoft Visual C++ 6.0
// disable Swig-dependent warnings

// 'identifier1' has C-linkage specified,
// but returns UDT 'identifier2' which is incompatible with C
#pragma warning(disable: 4190)

// 'int' : forcing value to bool 'true' or 'false' (performance warning)
#pragma warning(disable: 4800)

// debug info too long etc etc
#pragma warning(disable: 4786)
#endif


#include <typeinfo>
#include <stdexcept>


#include <string>


#include <vector>
#include <algorithm>
#include <stdexcept>


#include <map>
#include <algorithm>
#include <stdexcept>


#include <utility>


// This is necessary to avoid compile failures on 
// GCC 4
// see http://svn.boost.org/trac/boost/ticket/1793

#if defined(NDEBUG)
#define BOOST_DISABLE_ASSERTS 1
#endif

#include <boost/algorithm/string/case_conv.hpp>


// generally useful classes
using QuantLib::Error;
using QuantLib::Handle;
using QuantLib::RelinkableHandle;


using QuantLib::Integer;
using QuantLib::BigInteger;
using QuantLib::Natural;
using QuantLib::BigNatural;
using QuantLib::Real;
using QuantLib::Decimal;
using QuantLib::Time;
using QuantLib::Rate;
using QuantLib::Spread;
using QuantLib::DiscountFactor;
using QuantLib::Volatility;
using QuantLib::Probability;
using QuantLib::Size;


#ifndef QL_HIGH_RESOLUTION_DATE
    // They are not defined in the library, so we define them here
    namespace QuantLib {
        typedef int Hour;
        typedef int Minute;
        typedef int Second;
        typedef int Millisecond;
        typedef int Microsecond;
    }
#endif

using QuantLib::Day;
using QuantLib::Year;
using QuantLib::Hour;
using QuantLib::Minute;
using QuantLib::Second;
using QuantLib::Millisecond;
using QuantLib::Microsecond;


using QuantLib::Weekday;
using QuantLib::Sunday;
using QuantLib::Monday;
using QuantLib::Tuesday;
using QuantLib::Wednesday;
using QuantLib::Thursday;
using QuantLib::Friday;
using QuantLib::Saturday;


using QuantLib::Month;
using QuantLib::January;
using QuantLib::February;
using QuantLib::March;
using QuantLib::April;
using QuantLib::May;
using QuantLib::June;
using QuantLib::July;
using QuantLib::August;
using QuantLib::September;
using QuantLib::October;
using QuantLib::November;
using QuantLib::December;


using QuantLib::TimeUnit;
using QuantLib::Days;
using QuantLib::Weeks;
using QuantLib::Months;
using QuantLib::Years;
using QuantLib::Hours;
using QuantLib::Minutes;
using QuantLib::Seconds;
using QuantLib::Milliseconds;
using QuantLib::Microseconds;


using QuantLib::Frequency;
using QuantLib::NoFrequency;
using QuantLib::Once;
using QuantLib::Annual;
using QuantLib::Semiannual;
using QuantLib::EveryFourthMonth;
using QuantLib::Quarterly;
using QuantLib::Bimonthly;
using QuantLib::Monthly;
using QuantLib::EveryFourthWeek;
using QuantLib::Biweekly;
using QuantLib::Weekly;
using QuantLib::Daily;
using QuantLib::OtherFrequency;


using QuantLib::Period;
using QuantLib::PeriodParser;

SWIGINTERN Period *new_Period__SWIG_3(std::string const &str){
            return new Period(PeriodParser::parse(str));
        }
SWIGINTERN std::string Period___str__(Period *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN std::string Period___repr__(Period *self){
            std::ostringstream out;
            out << "Period(\"" << QuantLib::io::short_period(*self) << "\")";
            return out.str();
        }
SWIGINTERN std::vector< Period > *new_std_vector_Sl_Period_Sg___SWIG_2(int capacity){
        std::vector< Period >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< Period >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN Period std_vector_Sl_Period_Sg__getitemcopy(std::vector< Period > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< Period >::value_type const &std_vector_Sl_Period_Sg__getitem(std::vector< Period > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Period_Sg__setitem(std::vector< Period > *self,int index,Period const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Period_Sg__AddRange(std::vector< Period > *self,std::vector< Period > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< Period > *std_vector_Sl_Period_Sg__GetRange(std::vector< Period > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< Period >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_Period_Sg__Insert(std::vector< Period > *self,int index,Period const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Period_Sg__InsertRange(std::vector< Period > *self,int index,std::vector< Period > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Period_Sg__RemoveAt(std::vector< Period > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Period_Sg__RemoveRange(std::vector< Period > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< Period > *std_vector_Sl_Period_Sg__Repeat(Period const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< Period >(count, value);
      }
SWIGINTERN void std_vector_Sl_Period_Sg__Reverse__SWIG_0(std::vector< Period > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_Period_Sg__Reverse__SWIG_1(std::vector< Period > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_Period_Sg__SetRange(std::vector< Period > *self,int index,std::vector< Period > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }

using QuantLib::Date;
using QuantLib::DateParser;


    // used in Date(string, string) defined below
    void _replace_format(std::string& s, const std::string& old_format,
                         const std::string& new_format) {
        std::string::size_type i = s.find(old_format);
        if (i != std::string::npos)
            s.replace(i, old_format.length(), new_format);
    }

SWIGINTERN Date *new_Date__SWIG_2(Day d,Month m,Year y,Hour hours,Minute minutes,Second seconds,Millisecond millisec=0,Microsecond microsec=0){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return new Date(d, m, y, hours, minutes, seconds,
                            millisec, microsec);
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Hour Date_hours(Date *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->hours();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Minute Date_minutes(Date *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->minutes();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Second Date_seconds(Date *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->seconds();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Millisecond Date_milliseconds(Date *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->milliseconds();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Microsecond Date_microseconds(Date *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->microseconds();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Time Date_fractionOfDay(Date const *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->fractionOfDay();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Time Date_fractionOfSecond(Date const *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->fractionOfSecond();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Date Date_localDateTime(){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return Date::localDateTime();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Date Date_universalDateTime(){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return Date::universalDateTime();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
         }
SWIGINTERN Date *new_Date__SWIG_6(std::string const &str,std::string fmt){
            // convert our old format into the corresponding Boost one
            _replace_format(fmt, "YYYY", "%Y");
            _replace_format(fmt, "yyyy", "%Y");
            _replace_format(fmt, "YY", "%y");
            _replace_format(fmt, "yy", "%y");
            _replace_format(fmt, "MM", "%m");
            _replace_format(fmt, "mm", "%m");
            _replace_format(fmt, "DD", "%d");
            _replace_format(fmt, "dd", "%d");
            return new Date(DateParser::parseFormatted(str,fmt));
        }
SWIGINTERN Integer Date_weekdayNumber(Date *self){
            return int(self->weekday());
        }
SWIGINTERN std::string Date___str__(Date *self){
            std::ostringstream out;
        #ifdef QL_HIGH_RESOLUTION_DATE
            out << QuantLib::io::iso_datetime(*self);
        #else
            out << *self;
        #endif
            return out.str();
        }
SWIGINTERN std::string Date___repr__(Date *self){
            std::ostringstream out;
            if (*self == Date())
                out << "Date()";
            else
        #ifdef QL_HIGH_RESOLUTION_DATE
                out << "Date(" << self->dayOfMonth() << ","
                    << int(self->month()) << "," << self->year() << ","
                    << self->hours() << "," << self->minutes() << ","
                    << self->seconds() << "," << self->milliseconds() << ","
                    << self->microseconds() << ")";
        #else
                out << "Date(" << self->dayOfMonth() << ","
                    << int(self->month()) << "," << self->year() << ")";
        #endif
            return out.str();
        }
SWIGINTERN std::string Date_ISO(Date *self){
            std::ostringstream out;
            out << QuantLib::io::iso_date(*self);
            return out.str();
        }
SWIGINTERN Date DateParser_parse(std::string const &str,std::string fmt){
            // convert our old format into the corresponding Boost one
            _replace_format(fmt, "YYYY", "%Y");
            _replace_format(fmt, "yyyy", "%Y");
            _replace_format(fmt, "YY", "%y");
            _replace_format(fmt, "yy", "%y");
            _replace_format(fmt, "MM", "%m");
            _replace_format(fmt, "mm", "%m");
            _replace_format(fmt, "DD", "%d");
            _replace_format(fmt, "dd", "%d");
            return DateParser::parseFormatted(str,fmt);
        }
SWIGINTERN std::vector< Date > *new_std_vector_Sl_Date_Sg___SWIG_2(int capacity){
        std::vector< Date >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< Date >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN Date std_vector_Sl_Date_Sg__getitemcopy(std::vector< Date > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< Date >::value_type const &std_vector_Sl_Date_Sg__getitem(std::vector< Date > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Date_Sg__setitem(std::vector< Date > *self,int index,Date const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Date_Sg__AddRange(std::vector< Date > *self,std::vector< Date > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< Date > *std_vector_Sl_Date_Sg__GetRange(std::vector< Date > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< Date >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_Date_Sg__Insert(std::vector< Date > *self,int index,Date const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Date_Sg__InsertRange(std::vector< Date > *self,int index,std::vector< Date > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Date_Sg__RemoveAt(std::vector< Date > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Date_Sg__RemoveRange(std::vector< Date > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< Date > *std_vector_Sl_Date_Sg__Repeat(Date const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< Date >(count, value);
      }
SWIGINTERN void std_vector_Sl_Date_Sg__Reverse__SWIG_0(std::vector< Date > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_Date_Sg__Reverse__SWIG_1(std::vector< Date > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_Date_Sg__SetRange(std::vector< Date > *self,int index,std::vector< Date > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }

using QuantLib::IMM;


using QuantLib::ASX;

SWIGINTERN std::vector< int > *new_std_vector_Sl_int_Sg___SWIG_2(int capacity){
        std::vector< int >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< int >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN int std_vector_Sl_int_Sg__getitemcopy(std::vector< int > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< int >::value_type const &std_vector_Sl_int_Sg__getitem(std::vector< int > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_int_Sg__setitem(std::vector< int > *self,int index,int const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_int_Sg__AddRange(std::vector< int > *self,std::vector< int > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< int > *std_vector_Sl_int_Sg__GetRange(std::vector< int > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< int >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_int_Sg__Insert(std::vector< int > *self,int index,int const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_int_Sg__InsertRange(std::vector< int > *self,int index,std::vector< int > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_int_Sg__RemoveAt(std::vector< int > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_int_Sg__RemoveRange(std::vector< int > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< int > *std_vector_Sl_int_Sg__Repeat(int const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< int >(count, value);
      }
SWIGINTERN void std_vector_Sl_int_Sg__Reverse__SWIG_0(std::vector< int > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_int_Sg__Reverse__SWIG_1(std::vector< int > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_int_Sg__SetRange(std::vector< int > *self,int index,std::vector< int > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_int_Sg__Contains(std::vector< int > *self,int const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_int_Sg__IndexOf(std::vector< int > *self,int const &value){
        int index = -1;
        std::vector< int >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_int_Sg__LastIndexOf(std::vector< int > *self,int const &value){
        int index = -1;
        std::vector< int >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_int_Sg__Remove(std::vector< int > *self,int const &value){
        std::vector< int >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }
SWIGINTERN std::vector< unsigned int > *new_std_vector_Sl_unsigned_SS_int_Sg___SWIG_2(int capacity){
        std::vector< unsigned int >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< unsigned int >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN unsigned int std_vector_Sl_unsigned_SS_int_Sg__getitemcopy(std::vector< unsigned int > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< unsigned int >::value_type const &std_vector_Sl_unsigned_SS_int_Sg__getitem(std::vector< unsigned int > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_unsigned_SS_int_Sg__setitem(std::vector< unsigned int > *self,int index,unsigned int const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_unsigned_SS_int_Sg__AddRange(std::vector< unsigned int > *self,std::vector< unsigned int > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< unsigned int > *std_vector_Sl_unsigned_SS_int_Sg__GetRange(std::vector< unsigned int > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< unsigned int >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_unsigned_SS_int_Sg__Insert(std::vector< unsigned int > *self,int index,unsigned int const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_unsigned_SS_int_Sg__InsertRange(std::vector< unsigned int > *self,int index,std::vector< unsigned int > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_unsigned_SS_int_Sg__RemoveAt(std::vector< unsigned int > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_unsigned_SS_int_Sg__RemoveRange(std::vector< unsigned int > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< unsigned int > *std_vector_Sl_unsigned_SS_int_Sg__Repeat(unsigned int const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< unsigned int >(count, value);
      }
SWIGINTERN void std_vector_Sl_unsigned_SS_int_Sg__Reverse__SWIG_0(std::vector< unsigned int > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_unsigned_SS_int_Sg__Reverse__SWIG_1(std::vector< unsigned int > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_unsigned_SS_int_Sg__SetRange(std::vector< unsigned int > *self,int index,std::vector< unsigned int > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_unsigned_SS_int_Sg__Contains(std::vector< unsigned int > *self,unsigned int const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_unsigned_SS_int_Sg__IndexOf(std::vector< unsigned int > *self,unsigned int const &value){
        int index = -1;
        std::vector< unsigned int >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_unsigned_SS_int_Sg__LastIndexOf(std::vector< unsigned int > *self,unsigned int const &value){
        int index = -1;
        std::vector< unsigned int >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_unsigned_SS_int_Sg__Remove(std::vector< unsigned int > *self,unsigned int const &value){
        std::vector< unsigned int >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }
SWIGINTERN std::vector< double > *new_std_vector_Sl_double_Sg___SWIG_2(int capacity){
        std::vector< double >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< double >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN double std_vector_Sl_double_Sg__getitemcopy(std::vector< double > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< double >::value_type const &std_vector_Sl_double_Sg__getitem(std::vector< double > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_double_Sg__setitem(std::vector< double > *self,int index,double const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_double_Sg__AddRange(std::vector< double > *self,std::vector< double > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< double > *std_vector_Sl_double_Sg__GetRange(std::vector< double > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< double >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_double_Sg__Insert(std::vector< double > *self,int index,double const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_double_Sg__InsertRange(std::vector< double > *self,int index,std::vector< double > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_double_Sg__RemoveAt(std::vector< double > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_double_Sg__RemoveRange(std::vector< double > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< double > *std_vector_Sl_double_Sg__Repeat(double const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< double >(count, value);
      }
SWIGINTERN void std_vector_Sl_double_Sg__Reverse__SWIG_0(std::vector< double > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_double_Sg__Reverse__SWIG_1(std::vector< double > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_double_Sg__SetRange(std::vector< double > *self,int index,std::vector< double > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_double_Sg__Contains(std::vector< double > *self,double const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_double_Sg__IndexOf(std::vector< double > *self,double const &value){
        int index = -1;
        std::vector< double >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_double_Sg__LastIndexOf(std::vector< double > *self,double const &value){
        int index = -1;
        std::vector< double >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_double_Sg__Remove(std::vector< double > *self,double const &value){
        std::vector< double >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }
SWIGINTERN std::vector< std::string > *new_std_vector_Sl_std_string_Sg___SWIG_2(int capacity){
        std::vector< std::string >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< std::string >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN std::string std_vector_Sl_std_string_Sg__getitemcopy(std::vector< std::string > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< std::string >::value_type const &std_vector_Sl_std_string_Sg__getitem(std::vector< std::string > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__setitem(std::vector< std::string > *self,int index,std::string const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__AddRange(std::vector< std::string > *self,std::vector< std::string > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< std::string > *std_vector_Sl_std_string_Sg__GetRange(std::vector< std::string > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< std::string >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__Insert(std::vector< std::string > *self,int index,std::string const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__InsertRange(std::vector< std::string > *self,int index,std::vector< std::string > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__RemoveAt(std::vector< std::string > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__RemoveRange(std::vector< std::string > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< std::string > *std_vector_Sl_std_string_Sg__Repeat(std::string const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< std::string >(count, value);
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__Reverse__SWIG_0(std::vector< std::string > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__Reverse__SWIG_1(std::vector< std::string > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__SetRange(std::vector< std::string > *self,int index,std::vector< std::string > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_std_string_Sg__Contains(std::vector< std::string > *self,std::string const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_std_string_Sg__IndexOf(std::vector< std::string > *self,std::string const &value){
        int index = -1;
        std::vector< std::string >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_std_string_Sg__LastIndexOf(std::vector< std::string > *self,std::string const &value){
        int index = -1;
        std::vector< std::string >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_std_string_Sg__Remove(std::vector< std::string > *self,std::string const &value){
        std::vector< std::string >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }
SWIGINTERN std::vector< bool > *new_std_vector_Sl_bool_Sg___SWIG_2(int capacity){
        std::vector< bool >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< bool >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN bool std_vector_Sl_bool_Sg__getitemcopy(std::vector< bool > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN bool std_vector_Sl_bool_Sg__getitem(std::vector< bool > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_bool_Sg__setitem(std::vector< bool > *self,int index,bool const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_bool_Sg__AddRange(std::vector< bool > *self,std::vector< bool > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< bool > *std_vector_Sl_bool_Sg__GetRange(std::vector< bool > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< bool >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_bool_Sg__Insert(std::vector< bool > *self,int index,bool const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_bool_Sg__InsertRange(std::vector< bool > *self,int index,std::vector< bool > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_bool_Sg__RemoveAt(std::vector< bool > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_bool_Sg__RemoveRange(std::vector< bool > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< bool > *std_vector_Sl_bool_Sg__Repeat(bool const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< bool >(count, value);
      }
SWIGINTERN void std_vector_Sl_bool_Sg__Reverse__SWIG_0(std::vector< bool > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_bool_Sg__Reverse__SWIG_1(std::vector< bool > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_bool_Sg__SetRange(std::vector< bool > *self,int index,std::vector< bool > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_bool_Sg__Contains(std::vector< bool > *self,bool const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_bool_Sg__IndexOf(std::vector< bool > *self,bool const &value){
        int index = -1;
        std::vector< bool >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_bool_Sg__LastIndexOf(std::vector< bool > *self,bool const &value){
        int index = -1;
        std::vector< bool >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_bool_Sg__Remove(std::vector< bool > *self,bool const &value){
        std::vector< bool >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }
SWIGINTERN std::vector< std::pair< double,double > > *new_std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg___SWIG_2(int capacity){
        std::vector< std::pair< double,double > >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< std::pair< double,double > >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN std::pair< double,double > std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__getitemcopy(std::vector< std::pair< double,double > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< std::pair< double,double > >::value_type const &std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__getitem(std::vector< std::pair< double,double > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__setitem(std::vector< std::pair< double,double > > *self,int index,std::pair< double,double > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__AddRange(std::vector< std::pair< double,double > > *self,std::vector< std::pair< double,double > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< std::pair< double,double > > *std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__GetRange(std::vector< std::pair< double,double > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< std::pair< double,double > >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__Insert(std::vector< std::pair< double,double > > *self,int index,std::pair< double,double > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__InsertRange(std::vector< std::pair< double,double > > *self,int index,std::vector< std::pair< double,double > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__RemoveAt(std::vector< std::pair< double,double > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__RemoveRange(std::vector< std::pair< double,double > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< std::pair< double,double > > *std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__Repeat(std::pair< double,double > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< std::pair< double,double > >(count, value);
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__Reverse__SWIG_0(std::vector< std::pair< double,double > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__Reverse__SWIG_1(std::vector< std::pair< double,double > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__SetRange(std::vector< std::pair< double,double > > *self,int index,std::vector< std::pair< double,double > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN std::vector< std::pair< Date,double > > *new_std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg___SWIG_2(int capacity){
        std::vector< std::pair<Date,double> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< std::pair<Date,double> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN std::pair< Date,double > std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__getitemcopy(std::vector< std::pair< Date,double > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< std::pair< Date,double > >::value_type const &std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__getitem(std::vector< std::pair< Date,double > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__setitem(std::vector< std::pair< Date,double > > *self,int index,std::pair< Date,double > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__AddRange(std::vector< std::pair< Date,double > > *self,std::vector< std::pair< Date,double > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< std::pair< Date,double > > *std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__GetRange(std::vector< std::pair< Date,double > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< std::pair<Date,double> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Insert(std::vector< std::pair< Date,double > > *self,int index,std::pair< Date,double > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__InsertRange(std::vector< std::pair< Date,double > > *self,int index,std::vector< std::pair< Date,double > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__RemoveAt(std::vector< std::pair< Date,double > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__RemoveRange(std::vector< std::pair< Date,double > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< std::pair< Date,double > > *std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Repeat(std::pair< Date,double > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< std::pair<Date,double> >(count, value);
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Reverse__SWIG_0(std::vector< std::pair< Date,double > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Reverse__SWIG_1(std::vector< std::pair< Date,double > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__SetRange(std::vector< std::pair< Date,double > > *self,int index,std::vector< std::pair< Date,double > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Contains(std::vector< std::pair< Date,double > > *self,std::pair< Date,double > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__IndexOf(std::vector< std::pair< Date,double > > *self,std::pair< Date,double > const &value){
        int index = -1;
        std::vector< std::pair<Date,double> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__LastIndexOf(std::vector< std::pair< Date,double > > *self,std::pair< Date,double > const &value){
        int index = -1;
        std::vector< std::pair<Date,double> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Remove(std::vector< std::pair< Date,double > > *self,std::pair< Date,double > const &value){
        std::vector< std::pair<Date,double> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }

#include <boost/tuple/tuple.hpp>


using QuantLib::Exercise;


struct SWIG_null_deleter {
  void operator() (void const *) const {
  }
};
#define SWIG_NO_NULL_DELETER_0 , SWIG_null_deleter()
#define SWIG_NO_NULL_DELETER_1
#define SWIG_NO_NULL_DELETER_SWIG_POINTER_NEW
#define SWIG_NO_NULL_DELETER_SWIG_POINTER_OWN


using QuantLib::EuropeanExercise;
using QuantLib::AmericanExercise;
using QuantLib::BermudanExercise;
using QuantLib::RebatedExercise;
using QuantLib::SwingExercise;


using QuantLib::BusinessDayConvention;
using QuantLib::Calendar;
using QuantLib::Following;
using QuantLib::NullCalendar;


using QuantLib::Observer;
using QuantLib::Observable;


using QuantLib::Array;
using QuantLib::Matrix;
using QuantLib::SampledCurve;

SWIGINTERN std::string Array___str__(Array *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN Real Array_get(Array *self,Size i){
            if (i<self->size())
                return (*self)[i];
            else
                throw std::out_of_range("array index out of range");
        }
SWIGINTERN void Array_set(Array *self,Size i,Real x){
            if (i<self->size())
                (*self)[i] = x;
            else
                throw std::out_of_range("array index out of range");
        }

typedef QuantLib::LexicographicalView<Array::iterator>
    DefaultLexicographicalView;
typedef QuantLib::LexicographicalView<Array::iterator>::y_iterator
    DefaultLexicographicalViewColumn;

SWIGINTERN DefaultLexicographicalView *new_DefaultLexicographicalView(Array &a,Size xSize){
            return new DefaultLexicographicalView(a.begin(),a.end(),xSize);
        }
SWIGINTERN std::string DefaultLexicographicalView___str__(DefaultLexicographicalView *self){
            std::ostringstream s;
            for (Size j=0; j<self->ySize(); j++) {
                s << "\n";
                for (Size i=0; i<self->xSize(); i++) {
                    if (i != 0)
                        s << ",";
                    Array::value_type value = (*self)[i][j];
                    s << value;
                }
            }
            s << "\n";
            return s.str();
        }

typedef QuantLib::Matrix::row_iterator MatrixRow;
using QuantLib::outerProduct;
using QuantLib::transpose;
using QuantLib::SVD;

SWIGINTERN std::string Matrix___str__(Matrix *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN Real Matrix_get(Matrix *self,Size i,Size j){
            return (*self)[i][j];
        }
SWIGINTERN void Matrix_set(Matrix *self,Size i,Size j,Real x){
            (*self)[i][j] = x;
        }

using QuantLib::pseudoSqrt;
using QuantLib::SalvagingAlgorithm;


using QuantLib::CostFunction;
using QuantLib::Disposable;


class UnaryFunctionDelegate {
  public:
    virtual ~UnaryFunctionDelegate() {}
    virtual Real value(Real x) const {
        QL_FAIL("implementation of UnaryFunctionDelegate.value is missing");
    };
};

class UnaryFunction : public std::unary_function<Real, Real> {
  public:
    UnaryFunction(UnaryFunctionDelegate* delegate)
    : delegate_(delegate) { }

    virtual ~UnaryFunction() { }

    Real operator()(Real x) const {
        return delegate_->value(x);
    }

  private:
    UnaryFunctionDelegate* delegate_;
};


class CostFunctionDelegate {
  public:
    virtual ~CostFunctionDelegate() {}
    virtual Real value(const Array& x) const {
      QL_FAIL("implementation of CostFunctionDelegate.value is missing");
    }

    virtual Array values(const Array& x) const {
      QL_FAIL("implementation of CostFunctionDelegate.values is missing");
    }
};

class DotNetCostFunction : public CostFunction {
  public:
    DotNetCostFunction(CostFunctionDelegate* delegate)
    : delegate_(delegate) { }

    virtual ~DotNetCostFunction(){ }

    virtual Real value(const Array& x ) const{
      return delegate_->value(x);
    }

    virtual Disposable<Array> values(const Array& x) const {
      Array retVal = delegate_->values(x);
      return retVal;
    }

  private:
    CostFunctionDelegate* delegate_;
};


using QuantLib::Quote;

SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_Quote_Sg__asObservable(Handle< Quote > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_Quote_Sg__reset(RelinkableHandle< Quote > *self){
            self->linkTo(boost::shared_ptr<Quote>());
        }

using QuantLib::SimpleQuote;

SWIGINTERN std::vector< boost::shared_ptr< Quote > > *new_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg___SWIG_2(int capacity){
        std::vector< boost::shared_ptr<Quote> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< boost::shared_ptr<Quote> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN boost::shared_ptr< Quote > std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__getitemcopy(std::vector< boost::shared_ptr< Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< boost::shared_ptr< Quote > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__getitem(std::vector< boost::shared_ptr< Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__setitem(std::vector< boost::shared_ptr< Quote > > *self,int index,boost::shared_ptr< Quote > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__AddRange(std::vector< boost::shared_ptr< Quote > > *self,std::vector< boost::shared_ptr< Quote > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< boost::shared_ptr< Quote > > *std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__GetRange(std::vector< boost::shared_ptr< Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< boost::shared_ptr<Quote> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Insert(std::vector< boost::shared_ptr< Quote > > *self,int index,boost::shared_ptr< Quote > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__InsertRange(std::vector< boost::shared_ptr< Quote > > *self,int index,std::vector< boost::shared_ptr< Quote > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__RemoveAt(std::vector< boost::shared_ptr< Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__RemoveRange(std::vector< boost::shared_ptr< Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< boost::shared_ptr< Quote > > *std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Repeat(boost::shared_ptr< Quote > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< boost::shared_ptr<Quote> >(count, value);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Reverse__SWIG_0(std::vector< boost::shared_ptr< Quote > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Reverse__SWIG_1(std::vector< boost::shared_ptr< Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__SetRange(std::vector< boost::shared_ptr< Quote > > *self,int index,std::vector< boost::shared_ptr< Quote > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Contains(std::vector< boost::shared_ptr< Quote > > *self,boost::shared_ptr< Quote > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__IndexOf(std::vector< boost::shared_ptr< Quote > > *self,boost::shared_ptr< Quote > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<Quote> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__LastIndexOf(std::vector< boost::shared_ptr< Quote > > *self,boost::shared_ptr< Quote > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<Quote> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Remove(std::vector< boost::shared_ptr< Quote > > *self,boost::shared_ptr< Quote > const &value){
        std::vector< boost::shared_ptr<Quote> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }
SWIGINTERN std::vector< std::vector< boost::shared_ptr< Quote > > > *new_std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg___SWIG_2(int capacity){
        std::vector< std::vector< boost::shared_ptr< Quote > > >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< std::vector< boost::shared_ptr< Quote > > >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN std::vector< boost::shared_ptr< Quote > > std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__getitemcopy(std::vector< std::vector< boost::shared_ptr< Quote > > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< std::vector< boost::shared_ptr< Quote > > >::value_type const &std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__getitem(std::vector< std::vector< boost::shared_ptr< Quote > > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__setitem(std::vector< std::vector< boost::shared_ptr< Quote > > > *self,int index,std::vector< boost::shared_ptr< Quote > > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__AddRange(std::vector< std::vector< boost::shared_ptr< Quote > > > *self,std::vector< std::vector< boost::shared_ptr< Quote > > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< std::vector< boost::shared_ptr< Quote > > > *std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__GetRange(std::vector< std::vector< boost::shared_ptr< Quote > > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< std::vector< boost::shared_ptr< Quote > > >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__Insert(std::vector< std::vector< boost::shared_ptr< Quote > > > *self,int index,std::vector< boost::shared_ptr< Quote > > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__InsertRange(std::vector< std::vector< boost::shared_ptr< Quote > > > *self,int index,std::vector< std::vector< boost::shared_ptr< Quote > > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__RemoveAt(std::vector< std::vector< boost::shared_ptr< Quote > > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__RemoveRange(std::vector< std::vector< boost::shared_ptr< Quote > > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< std::vector< boost::shared_ptr< Quote > > > *std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__Repeat(std::vector< boost::shared_ptr< Quote > > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< std::vector< boost::shared_ptr< Quote > > >(count, value);
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__Reverse__SWIG_0(std::vector< std::vector< boost::shared_ptr< Quote > > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__Reverse__SWIG_1(std::vector< std::vector< boost::shared_ptr< Quote > > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__SetRange(std::vector< std::vector< boost::shared_ptr< Quote > > > *self,int index,std::vector< std::vector< boost::shared_ptr< Quote > > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN std::vector< Handle< Quote > > *new_std_vector_Sl_Handle_Sl_Quote_Sg__Sg___SWIG_2(int capacity){
        std::vector< Handle<Quote> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< Handle<Quote> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN Handle< Quote > std_vector_Sl_Handle_Sl_Quote_Sg__Sg__getitemcopy(std::vector< Handle< Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< Handle< Quote > >::value_type const &std_vector_Sl_Handle_Sl_Quote_Sg__Sg__getitem(std::vector< Handle< Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__setitem(std::vector< Handle< Quote > > *self,int index,Handle< Quote > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__AddRange(std::vector< Handle< Quote > > *self,std::vector< Handle< Quote > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< Handle< Quote > > *std_vector_Sl_Handle_Sl_Quote_Sg__Sg__GetRange(std::vector< Handle< Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< Handle<Quote> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Insert(std::vector< Handle< Quote > > *self,int index,Handle< Quote > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__InsertRange(std::vector< Handle< Quote > > *self,int index,std::vector< Handle< Quote > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__RemoveAt(std::vector< Handle< Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__RemoveRange(std::vector< Handle< Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< Handle< Quote > > *std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Repeat(Handle< Quote > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< Handle<Quote> >(count, value);
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Reverse__SWIG_0(std::vector< Handle< Quote > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Reverse__SWIG_1(std::vector< Handle< Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__SetRange(std::vector< Handle< Quote > > *self,int index,std::vector< Handle< Quote > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Contains(std::vector< Handle< Quote > > *self,Handle< Quote > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_Handle_Sl_Quote_Sg__Sg__IndexOf(std::vector< Handle< Quote > > *self,Handle< Quote > const &value){
        int index = -1;
        std::vector< Handle<Quote> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_Handle_Sl_Quote_Sg__Sg__LastIndexOf(std::vector< Handle< Quote > > *self,Handle< Quote > const &value){
        int index = -1;
        std::vector< Handle<Quote> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Remove(std::vector< Handle< Quote > > *self,Handle< Quote > const &value){
        std::vector< Handle<Quote> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }
SWIGINTERN std::vector< std::vector< Handle< Quote > > > *new_std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg___SWIG_2(int capacity){
        std::vector< std::vector< Handle< Quote > > >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< std::vector< Handle< Quote > > >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN std::vector< Handle< Quote > > std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__getitemcopy(std::vector< std::vector< Handle< Quote > > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< std::vector< Handle< Quote > > >::value_type const &std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__getitem(std::vector< std::vector< Handle< Quote > > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__setitem(std::vector< std::vector< Handle< Quote > > > *self,int index,std::vector< Handle< Quote > > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__AddRange(std::vector< std::vector< Handle< Quote > > > *self,std::vector< std::vector< Handle< Quote > > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< std::vector< Handle< Quote > > > *std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__GetRange(std::vector< std::vector< Handle< Quote > > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< std::vector< Handle< Quote > > >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__Insert(std::vector< std::vector< Handle< Quote > > > *self,int index,std::vector< Handle< Quote > > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__InsertRange(std::vector< std::vector< Handle< Quote > > > *self,int index,std::vector< std::vector< Handle< Quote > > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__RemoveAt(std::vector< std::vector< Handle< Quote > > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__RemoveRange(std::vector< std::vector< Handle< Quote > > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< std::vector< Handle< Quote > > > *std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__Repeat(std::vector< Handle< Quote > > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< std::vector< Handle< Quote > > >(count, value);
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__Reverse__SWIG_0(std::vector< std::vector< Handle< Quote > > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__Reverse__SWIG_1(std::vector< std::vector< Handle< Quote > > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__SetRange(std::vector< std::vector< Handle< Quote > > > *self,int index,std::vector< std::vector< Handle< Quote > > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN std::vector< RelinkableHandle< Quote > > *new_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg___SWIG_2(int capacity){
        std::vector< RelinkableHandle<Quote> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< RelinkableHandle<Quote> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN RelinkableHandle< Quote > std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__getitemcopy(std::vector< RelinkableHandle< Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< RelinkableHandle< Quote > >::value_type const &std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__getitem(std::vector< RelinkableHandle< Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__setitem(std::vector< RelinkableHandle< Quote > > *self,int index,RelinkableHandle< Quote > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__AddRange(std::vector< RelinkableHandle< Quote > > *self,std::vector< RelinkableHandle< Quote > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< RelinkableHandle< Quote > > *std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__GetRange(std::vector< RelinkableHandle< Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< RelinkableHandle<Quote> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Insert(std::vector< RelinkableHandle< Quote > > *self,int index,RelinkableHandle< Quote > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__InsertRange(std::vector< RelinkableHandle< Quote > > *self,int index,std::vector< RelinkableHandle< Quote > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__RemoveAt(std::vector< RelinkableHandle< Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__RemoveRange(std::vector< RelinkableHandle< Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< RelinkableHandle< Quote > > *std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Repeat(RelinkableHandle< Quote > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< RelinkableHandle<Quote> >(count, value);
      }
SWIGINTERN void std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Reverse__SWIG_0(std::vector< RelinkableHandle< Quote > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Reverse__SWIG_1(std::vector< RelinkableHandle< Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__SetRange(std::vector< RelinkableHandle< Quote > > *self,int index,std::vector< RelinkableHandle< Quote > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Contains(std::vector< RelinkableHandle< Quote > > *self,RelinkableHandle< Quote > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__IndexOf(std::vector< RelinkableHandle< Quote > > *self,RelinkableHandle< Quote > const &value){
        int index = -1;
        std::vector< RelinkableHandle<Quote> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__LastIndexOf(std::vector< RelinkableHandle< Quote > > *self,RelinkableHandle< Quote > const &value){
        int index = -1;
        std::vector< RelinkableHandle<Quote> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Remove(std::vector< RelinkableHandle< Quote > > *self,RelinkableHandle< Quote > const &value){
        std::vector< RelinkableHandle<Quote> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }
SWIGINTERN std::vector< std::vector< RelinkableHandle< Quote > > > *new_std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg___SWIG_2(int capacity){
        std::vector< std::vector< RelinkableHandle< Quote > > >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< std::vector< RelinkableHandle< Quote > > >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN std::vector< RelinkableHandle< Quote > > std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__getitemcopy(std::vector< std::vector< RelinkableHandle< Quote > > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< std::vector< RelinkableHandle< Quote > > >::value_type const &std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__getitem(std::vector< std::vector< RelinkableHandle< Quote > > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__setitem(std::vector< std::vector< RelinkableHandle< Quote > > > *self,int index,std::vector< RelinkableHandle< Quote > > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__AddRange(std::vector< std::vector< RelinkableHandle< Quote > > > *self,std::vector< std::vector< RelinkableHandle< Quote > > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< std::vector< RelinkableHandle< Quote > > > *std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__GetRange(std::vector< std::vector< RelinkableHandle< Quote > > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< std::vector< RelinkableHandle< Quote > > >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__Insert(std::vector< std::vector< RelinkableHandle< Quote > > > *self,int index,std::vector< RelinkableHandle< Quote > > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__InsertRange(std::vector< std::vector< RelinkableHandle< Quote > > > *self,int index,std::vector< std::vector< RelinkableHandle< Quote > > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__RemoveAt(std::vector< std::vector< RelinkableHandle< Quote > > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__RemoveRange(std::vector< std::vector< RelinkableHandle< Quote > > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< std::vector< RelinkableHandle< Quote > > > *std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__Repeat(std::vector< RelinkableHandle< Quote > > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< std::vector< RelinkableHandle< Quote > > >(count, value);
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__Reverse__SWIG_0(std::vector< std::vector< RelinkableHandle< Quote > > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__Reverse__SWIG_1(std::vector< std::vector< RelinkableHandle< Quote > > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__SetRange(std::vector< std::vector< RelinkableHandle< Quote > > > *self,int index,std::vector< std::vector< RelinkableHandle< Quote > > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }

using QuantLib::Calendar;


using QuantLib::BusinessDayConvention;
using QuantLib::Following;
using QuantLib::ModifiedFollowing;
using QuantLib::Preceding;
using QuantLib::ModifiedPreceding;
using QuantLib::Unadjusted;
using QuantLib::HalfMonthModifiedFollowing;


using QuantLib::JointCalendarRule;
using QuantLib::JoinHolidays;
using QuantLib::JoinBusinessDays;

SWIGINTERN std::string Calendar___str__(Calendar *self){
            return self->name()+" calendar";
        }

using QuantLib::Null;
typedef int intOrNull;
typedef double doubleOrNull;


int nullInt() { return Null<int>(); }
double nullDouble() { return Null<double>(); }


using QuantLib::DayCounter;

SWIGINTERN std::string DayCounter___str__(DayCounter *self){
            return self->name()+" day counter";
        }

    /* avoid deprecation warnings */
    DayCounter Actual365NoLeap() {
        return QuantLib::Actual365Fixed(QuantLib::Actual365Fixed::NoLeap);
    }


using QuantLib::Compounding;
using QuantLib::Simple;
using QuantLib::Compounded;
using QuantLib::Continuous;
using QuantLib::SimpleThenCompounded;
using QuantLib::CompoundedThenSimple;


using QuantLib::InterestRate;

SWIGINTERN std::string InterestRate___str__(InterestRate *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN std::vector< InterestRate > *new_std_vector_Sl_InterestRate_Sg___SWIG_2(int capacity){
        std::vector< InterestRate >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< InterestRate >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN InterestRate std_vector_Sl_InterestRate_Sg__getitemcopy(std::vector< InterestRate > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< InterestRate >::value_type const &std_vector_Sl_InterestRate_Sg__getitem(std::vector< InterestRate > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_InterestRate_Sg__setitem(std::vector< InterestRate > *self,int index,InterestRate const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_InterestRate_Sg__AddRange(std::vector< InterestRate > *self,std::vector< InterestRate > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< InterestRate > *std_vector_Sl_InterestRate_Sg__GetRange(std::vector< InterestRate > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< InterestRate >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_InterestRate_Sg__Insert(std::vector< InterestRate > *self,int index,InterestRate const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_InterestRate_Sg__InsertRange(std::vector< InterestRate > *self,int index,std::vector< InterestRate > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_InterestRate_Sg__RemoveAt(std::vector< InterestRate > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_InterestRate_Sg__RemoveRange(std::vector< InterestRate > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< InterestRate > *std_vector_Sl_InterestRate_Sg__Repeat(InterestRate const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< InterestRate >(count, value);
      }
SWIGINTERN void std_vector_Sl_InterestRate_Sg__Reverse__SWIG_0(std::vector< InterestRate > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_InterestRate_Sg__Reverse__SWIG_1(std::vector< InterestRate > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_InterestRate_Sg__SetRange(std::vector< InterestRate > *self,int index,std::vector< InterestRate > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }

using QuantLib::Rounding;
using QuantLib::UpRounding;
using QuantLib::DownRounding;
using QuantLib::ClosestRounding;
using QuantLib::CeilingTruncation;
using QuantLib::FloorTruncation;


using QuantLib::Currency;
using QuantLib::Money;

SWIGINTERN std::string Currency___str__(Currency *self){
            return self->name();
        }

// safe versions which copy their arguments
template <class I>
class SafeInterpolation {
  public:
    SafeInterpolation(const Array& x, const Array& y)
    : x_(x), y_(y), f_(x_.begin(),x_.end(),y_.begin()) {}
    Real operator()(Real x, bool allowExtrapolation=false) {
        return f_(x, allowExtrapolation);
    }
    Array x_, y_;
    I f_;
};


typedef SafeInterpolation<QuantLib::LinearInterpolation> SafeLinearInterpolation;


typedef SafeInterpolation<QuantLib::LogLinearInterpolation> SafeLogLinearInterpolation;


typedef SafeInterpolation<QuantLib::BackwardFlatInterpolation> SafeBackwardFlatInterpolation;


typedef SafeInterpolation<QuantLib::ForwardFlatInterpolation> SafeForwardFlatInterpolation;


typedef SafeInterpolation<QuantLib::CubicNaturalSpline> SafeCubicNaturalSpline;

SWIGINTERN Real SafeCubicNaturalSpline_derivative__SWIG_0(SafeCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeCubicNaturalSpline_secondDerivative__SWIG_0(SafeCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeCubicNaturalSpline_primitive__SWIG_0(SafeCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::LogCubicNaturalSpline> SafeLogCubicNaturalSpline;

SWIGINTERN Real SafeLogCubicNaturalSpline_derivative__SWIG_0(SafeLogCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeLogCubicNaturalSpline_secondDerivative__SWIG_0(SafeLogCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeLogCubicNaturalSpline_primitive__SWIG_0(SafeLogCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::MonotonicCubicNaturalSpline> SafeMonotonicCubicNaturalSpline;

SWIGINTERN Real SafeMonotonicCubicNaturalSpline_derivative__SWIG_0(SafeMonotonicCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicCubicNaturalSpline_secondDerivative__SWIG_0(SafeMonotonicCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicCubicNaturalSpline_primitive__SWIG_0(SafeMonotonicCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::MonotonicLogCubicNaturalSpline> SafeMonotonicLogCubicNaturalSpline;

SWIGINTERN Real SafeMonotonicLogCubicNaturalSpline_derivative__SWIG_0(SafeMonotonicLogCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicLogCubicNaturalSpline_secondDerivative__SWIG_0(SafeMonotonicLogCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicLogCubicNaturalSpline_primitive__SWIG_0(SafeMonotonicLogCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::KrugerCubic> SafeKrugerCubic;

SWIGINTERN Real SafeKrugerCubic_derivative__SWIG_0(SafeKrugerCubic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeKrugerCubic_secondDerivative__SWIG_0(SafeKrugerCubic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeKrugerCubic_primitive__SWIG_0(SafeKrugerCubic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::KrugerLogCubic> SafeKrugerLogCubic;

SWIGINTERN Real SafeKrugerLogCubic_derivative__SWIG_0(SafeKrugerLogCubic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeKrugerLogCubic_secondDerivative__SWIG_0(SafeKrugerLogCubic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeKrugerLogCubic_primitive__SWIG_0(SafeKrugerLogCubic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::FritschButlandCubic> SafeFritschButlandCubic;

SWIGINTERN Real SafeFritschButlandCubic_derivative__SWIG_0(SafeFritschButlandCubic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeFritschButlandCubic_secondDerivative__SWIG_0(SafeFritschButlandCubic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeFritschButlandCubic_primitive__SWIG_0(SafeFritschButlandCubic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::FritschButlandLogCubic> SafeFritschButlandLogCubic;

SWIGINTERN Real SafeFritschButlandLogCubic_derivative__SWIG_0(SafeFritschButlandLogCubic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeFritschButlandLogCubic_secondDerivative__SWIG_0(SafeFritschButlandLogCubic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeFritschButlandLogCubic_primitive__SWIG_0(SafeFritschButlandLogCubic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::Parabolic> SafeParabolic;

SWIGINTERN Real SafeParabolic_derivative__SWIG_0(SafeParabolic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeParabolic_secondDerivative__SWIG_0(SafeParabolic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeParabolic_primitive__SWIG_0(SafeParabolic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::LogParabolic> SafeLogParabolic;

SWIGINTERN Real SafeLogParabolic_derivative__SWIG_0(SafeLogParabolic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeLogParabolic_secondDerivative__SWIG_0(SafeLogParabolic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeLogParabolic_primitive__SWIG_0(SafeLogParabolic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::MonotonicParabolic> SafeMonotonicParabolic;

SWIGINTERN Real SafeMonotonicParabolic_derivative__SWIG_0(SafeMonotonicParabolic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicParabolic_secondDerivative__SWIG_0(SafeMonotonicParabolic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicParabolic_primitive__SWIG_0(SafeMonotonicParabolic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::MonotonicLogParabolic> SafeMonotonicLogParabolic;

SWIGINTERN Real SafeMonotonicLogParabolic_derivative__SWIG_0(SafeMonotonicLogParabolic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicLogParabolic_secondDerivative__SWIG_0(SafeMonotonicLogParabolic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicLogParabolic_primitive__SWIG_0(SafeMonotonicLogParabolic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

// safe versions which copy their arguments
template <class I>
class SafeInterpolation2D {
  public:
    SafeInterpolation2D(const Array& x, const Array& y, const Matrix& m)
    : x_(x), y_(y), m_(m), f_(x_.begin(),x_.end(),y_.begin(),y_.end(),m_) {}
    Real operator()(Real x, Real y, bool allowExtrapolation=false) {
        return f_(x,y, allowExtrapolation);
    }
  protected:
    Array x_, y_;
    Matrix m_;
    I f_;
};


typedef SafeInterpolation2D<QuantLib::BilinearInterpolation> SafeBilinearInterpolation;


typedef SafeInterpolation2D<QuantLib::BicubicSpline> SafeBicubicSpline;


using QuantLib::BackwardFlat;
using QuantLib::ForwardFlat;
using QuantLib::Linear;
using QuantLib::LogLinear;
using QuantLib::Cubic;

class MonotonicCubic : public Cubic {
  public:
    MonotonicCubic()
    : Cubic(QuantLib::CubicInterpolation::Spline, true,
            QuantLib::CubicInterpolation::SecondDerivative, 0.0,
            QuantLib::CubicInterpolation::SecondDerivative, 0.0) {}
};

class SplineCubic : public Cubic {
  public:
    SplineCubic()
    : Cubic(QuantLib::CubicInterpolation::Spline, false,
            QuantLib::CubicInterpolation::SecondDerivative, 0.0,
            QuantLib::CubicInterpolation::SecondDerivative, 0.0) {}
};

class DefaultLogCubic : public QuantLib::LogCubic {
  public:
    DefaultLogCubic()
    : QuantLib::LogCubic(QuantLib::CubicInterpolation::Kruger) {}
};

class MonotonicLogCubic : public QuantLib::LogCubic {
  public:
    MonotonicLogCubic()
    : QuantLib::LogCubic(QuantLib::CubicInterpolation::Spline, true,
                         QuantLib::CubicInterpolation::SecondDerivative, 0.0,
                         QuantLib::CubicInterpolation::SecondDerivative, 0.0) {}
};


using QuantLib::TermStructure;


using QuantLib::YieldTermStructure;

SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_YieldTermStructure_Sg__asObservable(Handle< YieldTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_YieldTermStructure_Sg__reset(RelinkableHandle< YieldTermStructure > *self){
            self->linkTo(boost::shared_ptr<YieldTermStructure>());
        }

using QuantLib::ImpliedTermStructure;


using QuantLib::ZeroSpreadedTermStructure;
using QuantLib::ForwardSpreadedTermStructure;


using QuantLib::InterpolatedPiecewiseZeroSpreadedTermStructure;


using QuantLib::FlatForward;


using QuantLib::TimeSeries;
using QuantLib::IntervalPrice;

SWIGINTERN TimeSeries< Real > *new_TimeSeries_Sl_Real_Sg___SWIG_1(std::vector< Date > const &d,std::vector< double > const &v){
            return new TimeSeries<double>(d.begin(), d.end(), v.begin());
        }
SWIGINTERN TimeSeries< IntervalPrice > *new_TimeSeries_Sl_IntervalPrice_Sg___SWIG_1(std::vector< Date > const &d,std::vector< IntervalPrice > const &v){
            return new TimeSeries<IntervalPrice>(d.begin(), d.end(), v.begin());
        }
SWIGINTERN std::vector< IntervalPrice > *new_std_vector_Sl_IntervalPrice_Sg___SWIG_2(int capacity){
        std::vector< IntervalPrice >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< IntervalPrice >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN IntervalPrice std_vector_Sl_IntervalPrice_Sg__getitemcopy(std::vector< IntervalPrice > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< IntervalPrice >::value_type const &std_vector_Sl_IntervalPrice_Sg__getitem(std::vector< IntervalPrice > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__setitem(std::vector< IntervalPrice > *self,int index,IntervalPrice const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__AddRange(std::vector< IntervalPrice > *self,std::vector< IntervalPrice > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< IntervalPrice > *std_vector_Sl_IntervalPrice_Sg__GetRange(std::vector< IntervalPrice > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< IntervalPrice >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__Insert(std::vector< IntervalPrice > *self,int index,IntervalPrice const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__InsertRange(std::vector< IntervalPrice > *self,int index,std::vector< IntervalPrice > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__RemoveAt(std::vector< IntervalPrice > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__RemoveRange(std::vector< IntervalPrice > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< IntervalPrice > *std_vector_Sl_IntervalPrice_Sg__Repeat(IntervalPrice const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< IntervalPrice >(count, value);
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__Reverse__SWIG_0(std::vector< IntervalPrice > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__Reverse__SWIG_1(std::vector< IntervalPrice > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__SetRange(std::vector< IntervalPrice > *self,int index,std::vector< IntervalPrice > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }

using QuantLib::IndexManager;


using QuantLib::Index;

SWIGINTERN void Index_addFixings__SWIG_0(Index *self,std::vector< Date > const &fixingDates,std::vector< Rate > const &fixings,bool forceOverwrite=false){
            self->addFixings(fixingDates.begin(),fixingDates.end(),
                             fixings.begin(),
                             forceOverwrite);
        }
SWIGINTERN std::string Index___str__(Index *self){
            return self->name()+" index";
        }

using QuantLib::InterestRateIndex;


using QuantLib::IborIndex;
using QuantLib::OvernightIndex;


    boost::shared_ptr<IborIndex> as_iborindex(
                          const boost::shared_ptr<InterestRateIndex>& index) {
        return boost::dynamic_pointer_cast<IborIndex>(index);
    }


using QuantLib::Libor;


using QuantLib::SwapIndex;


    boost::shared_ptr<SwapIndex> as_swap_index(
                          const boost::shared_ptr<InterestRateIndex>& index) {
        return boost::dynamic_pointer_cast<SwapIndex>(index);
    }


using QuantLib::SwapSpreadIndex;


using QuantLib::AUDLibor;


using QuantLib::CADLibor;


using QuantLib::Cdor;


using QuantLib::CHFLibor;


using QuantLib::DKKLibor;


using QuantLib::Bbsw;


using QuantLib::Bbsw1M;


using QuantLib::Bbsw2M;


using QuantLib::Bbsw3M;


using QuantLib::Bbsw4M;


using QuantLib::Bbsw5M;


using QuantLib::Bbsw6M;


using QuantLib::Bkbm;


using QuantLib::Bkbm1M;


using QuantLib::Bkbm2M;


using QuantLib::Bkbm3M;


using QuantLib::Bkbm4M;


using QuantLib::Bkbm5M;


using QuantLib::Bkbm6M;


using QuantLib::Euribor;


using QuantLib::EuriborSW;


using QuantLib::Euribor2W;


using QuantLib::Euribor3W;


using QuantLib::Euribor1M;


using QuantLib::Euribor2M;


using QuantLib::Euribor3M;


using QuantLib::Euribor4M;


using QuantLib::Euribor5M;


using QuantLib::Euribor6M;


using QuantLib::Euribor7M;


using QuantLib::Euribor8M;


using QuantLib::Euribor9M;


using QuantLib::Euribor10M;


using QuantLib::Euribor11M;


using QuantLib::Euribor1Y;


using QuantLib::Euribor365;


using QuantLib::Euribor365_SW;


using QuantLib::Euribor365_2W;


using QuantLib::Euribor365_3W;


using QuantLib::Euribor365_1M;


using QuantLib::Euribor365_2M;


using QuantLib::Euribor365_3M;


using QuantLib::Euribor365_4M;


using QuantLib::Euribor365_5M;


using QuantLib::Euribor365_6M;


using QuantLib::Euribor365_7M;


using QuantLib::Euribor365_8M;


using QuantLib::Euribor365_9M;


using QuantLib::Euribor365_10M;


using QuantLib::Euribor365_11M;


using QuantLib::Euribor365_1Y;


using QuantLib::EURLibor;


using QuantLib::EURLiborSW;


using QuantLib::EURLibor2W;


using QuantLib::EURLibor1M;


using QuantLib::EURLibor2M;


using QuantLib::EURLibor3M;


using QuantLib::EURLibor4M;


using QuantLib::EURLibor5M;


using QuantLib::EURLibor6M;


using QuantLib::EURLibor7M;


using QuantLib::EURLibor8M;


using QuantLib::EURLibor9M;


using QuantLib::EURLibor10M;


using QuantLib::EURLibor11M;


using QuantLib::EURLibor1Y;


using QuantLib::GBPLibor;


using QuantLib::Jibar;


using QuantLib::JPYLibor;


using QuantLib::Mosprime;


using QuantLib::NZDLibor;


using QuantLib::Pribor;


using QuantLib::Robor;


using QuantLib::SEKLibor;


using QuantLib::Shibor;


using QuantLib::Tibor;


using QuantLib::THBFIX;


using QuantLib::TRLibor;


using QuantLib::USDLibor;


using QuantLib::Wibor;


using QuantLib::Zibor;


using QuantLib::Aonia;


using QuantLib::Eonia;


using QuantLib::Sonia;


using QuantLib::FedFunds;


using QuantLib::Nzocr;


using QuantLib::Sofr;


using QuantLib::EuriborSwapIsdaFixA;


using QuantLib::EuriborSwapIsdaFixB;


using QuantLib::EuriborSwapIfrFix;


using QuantLib::EurLiborSwapIsdaFixA;


using QuantLib::EurLiborSwapIsdaFixB;


using QuantLib::EurLiborSwapIfrFix;


using QuantLib::ChfLiborSwapIsdaFix;


using QuantLib::GbpLiborSwapIsdaFix;


using QuantLib::JpyLiborSwapIsdaFixAm;


using QuantLib::JpyLiborSwapIsdaFixPm;


using QuantLib::UsdLiborSwapIsdaFixAm;


using QuantLib::UsdLiborSwapIsdaFixPm;


using QuantLib::Bibor;


using QuantLib::BiborSW;


using QuantLib::Bibor1M;


using QuantLib::Bibor2M;


using QuantLib::Bibor3M;


using QuantLib::Bibor6M;


using QuantLib::Bibor9M;


using QuantLib::Bibor1Y;


using QuantLib::Bisection;
using QuantLib::Brent;
using QuantLib::FalsePosition;
using QuantLib::Newton;
using QuantLib::NewtonSafe;
using QuantLib::Ridder;
using QuantLib::Secant;

SWIGINTERN Real Brent_solve__SWIG_0(Brent *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, step);
        }
SWIGINTERN Real Brent_solve__SWIG_1(Brent *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }
SWIGINTERN Real Bisection_solve__SWIG_0(Bisection *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, step);
        }
SWIGINTERN Real Bisection_solve__SWIG_1(Bisection *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }
SWIGINTERN Real FalsePosition_solve__SWIG_0(FalsePosition *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, step);
        }
SWIGINTERN Real FalsePosition_solve__SWIG_1(FalsePosition *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }
SWIGINTERN Real Ridder_solve__SWIG_0(Ridder *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, step);
        }
SWIGINTERN Real Ridder_solve__SWIG_1(Ridder *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }
SWIGINTERN Real Secant_solve__SWIG_0(Secant *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, step);
        }
SWIGINTERN Real Secant_solve__SWIG_1(Secant *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }

using QuantLib::Constraint;
using QuantLib::BoundaryConstraint;
using QuantLib::NoConstraint;
using QuantLib::PositiveConstraint;
using QuantLib::CompositeConstraint;
using QuantLib::NonhomogeneousBoundaryConstraint;


using QuantLib::EndCriteria;


using QuantLib::OptimizationMethod;
using QuantLib::ConjugateGradient;
using QuantLib::Simplex;
using QuantLib::SteepestDescent;
using QuantLib::BFGS;
using QuantLib::LevenbergMarquardt;
using QuantLib::DifferentialEvolution;
using QuantLib::SamplerGaussian;
using QuantLib::SamplerLogNormal;
using QuantLib::SamplerMirrorGaussian;
using QuantLib::ProbabilityBoltzmannDownhill;
using QuantLib::TemperatureExponential;
using QuantLib::ReannealingTrivial;
using QuantLib::GaussianSimulatedAnnealing;
using QuantLib::MirrorGaussianSimulatedAnnealing;
using QuantLib::LogNormalSimulatedAnnealing;



using QuantLib::Problem;


    class Optimizer {};

SWIGINTERN Array Optimizer_solve(Optimizer *self,CostFunctionDelegate *function,Constraint &c,OptimizationMethod &m,EndCriteria &e,Array &iv){
        DotNetCostFunction f(function);
        Problem p(f,c,iv);
        m.minimize(p, e);
        return p.currentValue();
    }

using QuantLib::VolatilityType;
using QuantLib::ShiftedLognormal;
using QuantLib::Normal;


using QuantLib::VolatilityTermStructure;
using QuantLib::BlackVolTermStructure;
using QuantLib::LocalVolTermStructure;
using QuantLib::OptionletVolatilityStructure;
using QuantLib::SwaptionVolatilityStructure;

SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_BlackVolTermStructure_Sg__asObservable(Handle< BlackVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_BlackVolTermStructure_Sg__reset(RelinkableHandle< BlackVolTermStructure > *self){
            self->linkTo(boost::shared_ptr<BlackVolTermStructure>());
        }
SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_LocalVolTermStructure_Sg__asObservable(Handle< LocalVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_LocalVolTermStructure_Sg__reset(RelinkableHandle< LocalVolTermStructure > *self){
            self->linkTo(boost::shared_ptr<LocalVolTermStructure>());
        }
SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_OptionletVolatilityStructure_Sg__asObservable(Handle< OptionletVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_OptionletVolatilityStructure_Sg__reset(RelinkableHandle< OptionletVolatilityStructure > *self){
            self->linkTo(boost::shared_ptr<OptionletVolatilityStructure>());
        }

using QuantLib::SwaptionVolatilityStructure;

SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_SwaptionVolatilityStructure_Sg__asObservable(Handle< SwaptionVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_SwaptionVolatilityStructure_Sg__reset(RelinkableHandle< SwaptionVolatilityStructure > *self){
            self->linkTo(boost::shared_ptr<SwaptionVolatilityStructure>());
        }

using QuantLib::BlackConstantVol;


using QuantLib::BlackVarianceCurve;


using QuantLib::BlackVarianceSurface;

SWIGINTERN BlackVarianceSurface *new_BlackVarianceSurface__SWIG_0(Date const &referenceDate,Calendar const &cal,std::vector< Date > const &dates,std::vector< Real > const &strikes,Matrix const &blackVols,DayCounter const &dayCounter,BlackVarianceSurface::Extrapolation lower=BlackVarianceSurface::InterpolatorDefaultExtrapolation,BlackVarianceSurface::Extrapolation upper=BlackVarianceSurface::InterpolatorDefaultExtrapolation,std::string const &interpolator=""){
            BlackVarianceSurface* surface =
                new BlackVarianceSurface(referenceDate,cal,
                                         dates,strikes,
                                         blackVols,dayCounter,lower,upper);
            std::string s = boost::algorithm::to_lower_copy(interpolator);
            if (s == "" || s == "bilinear") {
                surface->setInterpolation<QuantLib::Bilinear>();
            } else if (s == "bicubic") {
                surface->setInterpolation<QuantLib::Bicubic>();
            } else {
                QL_FAIL("Unknown interpolator: " << interpolator);
            }
            return surface;
        }
SWIGINTERN void BlackVarianceSurface_setInterpolation__SWIG_0(BlackVarianceSurface *self,std::string const &interpolator=""){
            std::string s = boost::algorithm::to_lower_copy(interpolator);
            if (s == "" || s == "bilinear") {
                self->setInterpolation<QuantLib::Bilinear>();
            } else if (s == "bicubic") {
                self->setInterpolation<QuantLib::Bicubic>();
            } else {
                QL_FAIL("Unknown interpolator: " << interpolator);
            }
        }

using QuantLib::LocalConstantVol;


using QuantLib::LocalVolSurface;


using QuantLib::ConstantOptionletVolatility;


using QuantLib::ConstantSwaptionVolatility;


using QuantLib::SwaptionVolatilityMatrix;
using QuantLib::SwaptionVolatilityDiscrete;

SWIGINTERN SwaptionVolatilityMatrix *new_SwaptionVolatilityMatrix__SWIG_12(Date const &referenceDate,std::vector< Date > const &dates,std::vector< Period > const &lengths,Matrix const &vols,DayCounter const &dayCounter,bool const flatExtrapolation=false,VolatilityType const type=ShiftedLognormal,Matrix const &shifts=Matrix()){
            return new SwaptionVolatilityMatrix(referenceDate, NullCalendar(), Following,
                                                dates, lengths, vols, dayCounter,
                                                flatExtrapolation, type, shifts);
        }

using QuantLib::SwaptionVolCube1;
using QuantLib::SwaptionVolCube2;


using QuantLib::SmileSection;


using QuantLib::FlatSmileSection;


using QuantLib::InterpolatedSmileSection;
using QuantLib::Actual365Fixed;


using QuantLib::SabrSmileSection;


using QuantLib::KahaleSmileSection;


using QuantLib::ZabrShortMaturityLognormal;
using QuantLib::ZabrShortMaturityNormal;
using QuantLib::ZabrLocalVolatility;
using QuantLib::ZabrFullFd;
using QuantLib::ZabrSmileSection;
using QuantLib::ZabrInterpolatedSmileSection;
using QuantLib::NoArbSabrSmileSection;
using QuantLib::NoArbSabrInterpolatedSmileSection;
using QuantLib::Option;


using QuantLib::sabrVolatility;
using QuantLib::shiftedSabrVolatility;
using QuantLib::sabrFlochKennedyVolatility;


using QuantLib::AndreasenHugeVolatilityInterpl;
using QuantLib::AndreasenHugeVolatilityAdapter;
using QuantLib::AndreasenHugeLocalVolAdapter;
using QuantLib::HestonBlackVolSurface;

SWIGINTERN double boost_tuple_Sl_Real_Sc_Real_Sc_Real_Sg__first(boost::tuple< Real,Real,Real > const *self){
        return boost::get<0>(*self);
      }
SWIGINTERN double boost_tuple_Sl_Real_Sc_Real_Sc_Real_Sg__second(boost::tuple< Real,Real,Real > const *self){
        return boost::get<1>(*self);
      }
SWIGINTERN double boost_tuple_Sl_Real_Sc_Real_Sc_Real_Sg__third(boost::tuple< Real,Real,Real > const *self){
        return boost::get<2>(*self);
      }

using QuantLib::StochasticProcess;

SWIGINTERN std::vector< boost::shared_ptr< StochasticProcess > > *new_std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg___SWIG_2(int capacity){
        std::vector< boost::shared_ptr<StochasticProcess> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< boost::shared_ptr<StochasticProcess> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN boost::shared_ptr< StochasticProcess > std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__getitemcopy(std::vector< boost::shared_ptr< StochasticProcess > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< boost::shared_ptr< StochasticProcess > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__getitem(std::vector< boost::shared_ptr< StochasticProcess > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__setitem(std::vector< boost::shared_ptr< StochasticProcess > > *self,int index,boost::shared_ptr< StochasticProcess > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__AddRange(std::vector< boost::shared_ptr< StochasticProcess > > *self,std::vector< boost::shared_ptr< StochasticProcess > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< boost::shared_ptr< StochasticProcess > > *std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__GetRange(std::vector< boost::shared_ptr< StochasticProcess > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< boost::shared_ptr<StochasticProcess> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__Insert(std::vector< boost::shared_ptr< StochasticProcess > > *self,int index,boost::shared_ptr< StochasticProcess > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__InsertRange(std::vector< boost::shared_ptr< StochasticProcess > > *self,int index,std::vector< boost::shared_ptr< StochasticProcess > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__RemoveAt(std::vector< boost::shared_ptr< StochasticProcess > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__RemoveRange(std::vector< boost::shared_ptr< StochasticProcess > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< boost::shared_ptr< StochasticProcess > > *std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__Repeat(boost::shared_ptr< StochasticProcess > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< boost::shared_ptr<StochasticProcess> >(count, value);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__Reverse__SWIG_0(std::vector< boost::shared_ptr< StochasticProcess > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__Reverse__SWIG_1(std::vector< boost::shared_ptr< StochasticProcess > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__SetRange(std::vector< boost::shared_ptr< StochasticProcess > > *self,int index,std::vector< boost::shared_ptr< StochasticProcess > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__Contains(std::vector< boost::shared_ptr< StochasticProcess > > *self,boost::shared_ptr< StochasticProcess > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__IndexOf(std::vector< boost::shared_ptr< StochasticProcess > > *self,boost::shared_ptr< StochasticProcess > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<StochasticProcess> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__LastIndexOf(std::vector< boost::shared_ptr< StochasticProcess > > *self,boost::shared_ptr< StochasticProcess > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<StochasticProcess> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__Remove(std::vector< boost::shared_ptr< StochasticProcess > > *self,boost::shared_ptr< StochasticProcess > const &value){
        std::vector< boost::shared_ptr<StochasticProcess> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }

using QuantLib::StochasticProcess1D;

SWIGINTERN std::vector< boost::shared_ptr< StochasticProcess1D > > *new_std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess1D_Sg__Sg___SWIG_2(int capacity){
        std::vector< boost::shared_ptr<StochasticProcess1D> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< boost::shared_ptr<StochasticProcess1D> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN boost::shared_ptr< StochasticProcess1D > std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__getitemcopy(std::vector< boost::shared_ptr< StochasticProcess1D > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< boost::shared_ptr< StochasticProcess1D > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__getitem(std::vector< boost::shared_ptr< StochasticProcess1D > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__setitem(std::vector< boost::shared_ptr< StochasticProcess1D > > *self,int index,boost::shared_ptr< StochasticProcess1D > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__AddRange(std::vector< boost::shared_ptr< StochasticProcess1D > > *self,std::vector< boost::shared_ptr< StochasticProcess1D > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< boost::shared_ptr< StochasticProcess1D > > *std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__GetRange(std::vector< boost::shared_ptr< StochasticProcess1D > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< boost::shared_ptr<StochasticProcess1D> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__Insert(std::vector< boost::shared_ptr< StochasticProcess1D > > *self,int index,boost::shared_ptr< StochasticProcess1D > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__InsertRange(std::vector< boost::shared_ptr< StochasticProcess1D > > *self,int index,std::vector< boost::shared_ptr< StochasticProcess1D > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__RemoveAt(std::vector< boost::shared_ptr< StochasticProcess1D > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__RemoveRange(std::vector< boost::shared_ptr< StochasticProcess1D > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< boost::shared_ptr< StochasticProcess1D > > *std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__Repeat(boost::shared_ptr< StochasticProcess1D > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< boost::shared_ptr<StochasticProcess1D> >(count, value);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__Reverse__SWIG_0(std::vector< boost::shared_ptr< StochasticProcess1D > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__Reverse__SWIG_1(std::vector< boost::shared_ptr< StochasticProcess1D > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__SetRange(std::vector< boost::shared_ptr< StochasticProcess1D > > *self,int index,std::vector< boost::shared_ptr< StochasticProcess1D > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__Contains(std::vector< boost::shared_ptr< StochasticProcess1D > > *self,boost::shared_ptr< StochasticProcess1D > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__IndexOf(std::vector< boost::shared_ptr< StochasticProcess1D > > *self,boost::shared_ptr< StochasticProcess1D > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<StochasticProcess1D> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__LastIndexOf(std::vector< boost::shared_ptr< StochasticProcess1D > > *self,boost::shared_ptr< StochasticProcess1D > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<StochasticProcess1D> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess1D_Sg__Sg__Remove(std::vector< boost::shared_ptr< StochasticProcess1D > > *self,boost::shared_ptr< StochasticProcess1D > const &value){
        std::vector< boost::shared_ptr<StochasticProcess1D> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }

using QuantLib::GeneralizedBlackScholesProcess;


using QuantLib::BlackScholesProcess;


using QuantLib::BlackScholesMertonProcess;


using QuantLib::BlackProcess;


using QuantLib::GarmanKohlagenProcess;


using QuantLib::Merton76Process;


using QuantLib::StochasticProcessArray;


using QuantLib::GeometricBrownianMotionProcess;


using QuantLib::VarianceGammaProcess;


using QuantLib::HestonProcess;


using QuantLib::BatesProcess;


using QuantLib::HullWhiteProcess;


using QuantLib::HullWhiteForwardProcess;


using QuantLib::G2Process;


using QuantLib::G2ForwardProcess;


using QuantLib::GsrProcess;


    const boost::shared_ptr<GsrProcess> as_gsr_process(
                           const boost::shared_ptr<StochasticProcess>& proc) {
        return boost::dynamic_pointer_cast<GsrProcess>(proc);
    }


using QuantLib::KlugeExtOUProcess;
using QuantLib::ExtendedOrnsteinUhlenbeckProcess;
using QuantLib::ExtOUWithJumpsProcess;

SWIGINTERN ExtendedOrnsteinUhlenbeckProcess *new_ExtendedOrnsteinUhlenbeckProcess__SWIG_3(Real speed,Volatility sigma,Real x0,UnaryFunctionDelegate *function,Real intEps=1e-4){
            
            const UnaryFunction f(function);
            return new ExtendedOrnsteinUhlenbeckProcess(
            	    speed, sigma, x0, f, 
            	    ExtendedOrnsteinUhlenbeckProcess::MidPoint, intEps);
        }

using QuantLib::PricingEngine;


using QuantLib::Instrument;

SWIGINTERN std::vector< boost::shared_ptr< Instrument > > *new_std_vector_Sl_boost_shared_ptr_Sl_Instrument_Sg__Sg___SWIG_2(int capacity){
        std::vector< boost::shared_ptr<Instrument> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< boost::shared_ptr<Instrument> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN boost::shared_ptr< Instrument > std_vector_Sl_boost_shared_ptr_Sl_Instrument_Sg__Sg__getitemcopy(std::vector< boost::shared_ptr< Instrument > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< boost::shared_ptr< Instrument > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_Instrument_Sg__Sg__getitem(std::vector< boost::shared_ptr< Instrument > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Instrument_Sg__Sg__setitem(std::vector< boost::shared_ptr< Instrument > > *self,int index,boost::shared_ptr< Instrument > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Instrument_Sg__Sg__AddRange(std::vector< boost::shared_ptr< Instrument > > *self,std::vector< boost::shared_ptr< Instrument > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< boost::shared_ptr< Instrument > > *std_vector_Sl_boost_shared_ptr_Sl_Instrument_Sg__Sg__GetRange(std::vector< boost::shared_ptr< Instrument > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< boost::shared_ptr<Instrument> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Instrument_Sg__Sg__Insert(std::vector< boost::shared_ptr< Instrument > > *self,int index,boost::shared_ptr< Instrument > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Instrument_Sg__Sg__InsertRange(std::vector< boost::shared_ptr< Instrument > > *self,int index,std::vector< boost::shared_ptr< Instrument > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Instrument_Sg__Sg__RemoveAt(std::vector< boost::shared_ptr< Instrument > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Instrument_Sg__Sg__RemoveRange(std::vector< boost::shared_ptr< Instrument > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< boost::shared_ptr< Instrument > > *std_vector_Sl_boost_shared_ptr_Sl_Instrument_Sg__Sg__Repeat(boost::shared_ptr< Instrument > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< boost::shared_ptr<Instrument> >(count, value);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Instrument_Sg__Sg__Reverse__SWIG_0(std::vector< boost::shared_ptr< Instrument > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Instrument_Sg__Sg__Reverse__SWIG_1(std::vector< boost::shared_ptr< Instrument > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Instrument_Sg__Sg__SetRange(std::vector< boost::shared_ptr< Instrument > > *self,int index,std::vector< boost::shared_ptr< Instrument > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_Instrument_Sg__Sg__Contains(std::vector< boost::shared_ptr< Instrument > > *self,boost::shared_ptr< Instrument > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_Instrument_Sg__Sg__IndexOf(std::vector< boost::shared_ptr< Instrument > > *self,boost::shared_ptr< Instrument > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<Instrument> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_Instrument_Sg__Sg__LastIndexOf(std::vector< boost::shared_ptr< Instrument > > *self,boost::shared_ptr< Instrument > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<Instrument> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_Instrument_Sg__Sg__Remove(std::vector< boost::shared_ptr< Instrument > > *self,boost::shared_ptr< Instrument > const &value){
        std::vector< boost::shared_ptr<Instrument> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }

using QuantLib::Stock;


using QuantLib::CompositeInstrument;


using QuantLib::Schedule;
using QuantLib::DateGeneration;
using QuantLib::MakeSchedule;

SWIGINTERN Schedule MakeSchedule_schedule(MakeSchedule *self){
        return (Schedule)(* self);
      }

using QuantLib::CashFlow;

SWIGINTERN std::vector< boost::shared_ptr< CashFlow > > *new_std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg___SWIG_2(int capacity){
        std::vector< boost::shared_ptr<CashFlow> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< boost::shared_ptr<CashFlow> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN boost::shared_ptr< CashFlow > std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__getitemcopy(std::vector< boost::shared_ptr< CashFlow > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< boost::shared_ptr< CashFlow > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__getitem(std::vector< boost::shared_ptr< CashFlow > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__setitem(std::vector< boost::shared_ptr< CashFlow > > *self,int index,boost::shared_ptr< CashFlow > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__AddRange(std::vector< boost::shared_ptr< CashFlow > > *self,std::vector< boost::shared_ptr< CashFlow > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< boost::shared_ptr< CashFlow > > *std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__GetRange(std::vector< boost::shared_ptr< CashFlow > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< boost::shared_ptr<CashFlow> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__Insert(std::vector< boost::shared_ptr< CashFlow > > *self,int index,boost::shared_ptr< CashFlow > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__InsertRange(std::vector< boost::shared_ptr< CashFlow > > *self,int index,std::vector< boost::shared_ptr< CashFlow > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__RemoveAt(std::vector< boost::shared_ptr< CashFlow > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__RemoveRange(std::vector< boost::shared_ptr< CashFlow > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< boost::shared_ptr< CashFlow > > *std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__Repeat(boost::shared_ptr< CashFlow > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< boost::shared_ptr<CashFlow> >(count, value);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__Reverse__SWIG_0(std::vector< boost::shared_ptr< CashFlow > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__Reverse__SWIG_1(std::vector< boost::shared_ptr< CashFlow > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__SetRange(std::vector< boost::shared_ptr< CashFlow > > *self,int index,std::vector< boost::shared_ptr< CashFlow > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__Contains(std::vector< boost::shared_ptr< CashFlow > > *self,boost::shared_ptr< CashFlow > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__IndexOf(std::vector< boost::shared_ptr< CashFlow > > *self,boost::shared_ptr< CashFlow > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<CashFlow> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__LastIndexOf(std::vector< boost::shared_ptr< CashFlow > > *self,boost::shared_ptr< CashFlow > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<CashFlow> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__Remove(std::vector< boost::shared_ptr< CashFlow > > *self,boost::shared_ptr< CashFlow > const &value){
        std::vector< boost::shared_ptr<CashFlow> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }

using QuantLib::SimpleCashFlow;
using QuantLib::Redemption;
using QuantLib::AmortizingPayment;
using QuantLib::Coupon;
using QuantLib::FixedRateCoupon;
using QuantLib::IborCoupon;
using QuantLib::Leg;
using QuantLib::FloatingRateCoupon;


    boost::shared_ptr<Coupon> as_coupon(const boost::shared_ptr<CashFlow>& cf) {
        return boost::dynamic_pointer_cast<Coupon>(cf);
    }


    boost::shared_ptr<FixedRateCoupon> as_fixed_rate_coupon(
                                      const boost::shared_ptr<CashFlow>& cf) {
        return boost::dynamic_pointer_cast<FixedRateCoupon>(cf);
    }


using QuantLib::FloatingRateCouponPricer;


    boost::shared_ptr<FloatingRateCoupon> as_floating_rate_coupon(
                                      const boost::shared_ptr<CashFlow>& cf) {
        return boost::dynamic_pointer_cast<FloatingRateCoupon>(cf);
    }


using QuantLib::CappedFlooredCoupon;


using QuantLib::IborCouponPricer;
using QuantLib::BlackIborCouponPricer;


using QuantLib::CmsCoupon;
using QuantLib::CappedFlooredCmsCoupon;
using QuantLib::CmsSpreadCoupon;
using QuantLib::CappedFlooredCmsSpreadCoupon;


using QuantLib::CmsCouponPricer;
using QuantLib::AnalyticHaganPricer;
using QuantLib::NumericHaganPricer;
using QuantLib::GFunctionFactory;
using QuantLib::LinearTsrPricer;
using QuantLib::CmsSpreadCouponPricer;
using QuantLib::LognormalCmsSpreadPricer;


Leg _FixedRateLeg(const Schedule& schedule,
                  const DayCounter& dayCount,
                  const std::vector<Real>& nominals,
                  const std::vector<Rate>& couponRates,
                  BusinessDayConvention paymentAdjustment = Following,
                  const DayCounter& firstPeriodDayCount = DayCounter()) {
    return QuantLib::FixedRateLeg(schedule)
        .withNotionals(nominals)
        .withCouponRates(couponRates,dayCount)
        .withPaymentAdjustment(paymentAdjustment)
        .withFirstPeriodDayCounter(firstPeriodDayCount);
}


Leg _IborLeg(const std::vector<Real>& nominals,
             const Schedule& schedule,
             const boost::shared_ptr<Index>& index,
             const DayCounter& paymentDayCounter = DayCounter(),
             const BusinessDayConvention paymentConvention = Following,
             const std::vector<Natural>& fixingDays = std::vector<Natural>(),
             const std::vector<Real>& gearings = std::vector<Real>(),
             const std::vector<Spread>& spreads = std::vector<Spread>(),
             const std::vector<Rate>& caps = std::vector<Rate>(),
             const std::vector<Rate>& floors = std::vector<Rate>(),
             bool isInArrears = false) {
    boost::shared_ptr<IborIndex> libor =
        boost::dynamic_pointer_cast<IborIndex>(index);
    return QuantLib::IborLeg(schedule, libor)
        .withNotionals(nominals)
        .withPaymentDayCounter(paymentDayCounter)
        .withPaymentAdjustment(paymentConvention)
        .withFixingDays(fixingDays)
        .withGearings(gearings)
        .withSpreads(spreads)
        .withCaps(caps)
        .withFloors(floors)
        .inArrears(isInArrears);
}


Leg _CmsLeg(const std::vector<Real>& nominals,
            const Schedule& schedule,
            const boost::shared_ptr<Index>& index,
            const DayCounter& paymentDayCounter = DayCounter(),
            const BusinessDayConvention paymentConvention = Following,
            const std::vector<Natural>& fixingDays = std::vector<Natural>(),
            const std::vector<Real>& gearings = std::vector<Real>(),
            const std::vector<Spread>& spreads = std::vector<Spread>(),
            const std::vector<Rate>& caps = std::vector<Rate>(),
            const std::vector<Rate>& floors = std::vector<Rate>(),
            bool isInArrears = false) {
    boost::shared_ptr<SwapIndex> swapIndex =
        boost::dynamic_pointer_cast<SwapIndex>(index);
    return QuantLib::CmsLeg(schedule, swapIndex)
        .withNotionals(nominals)
        .withPaymentDayCounter(paymentDayCounter)
        .withPaymentAdjustment(paymentConvention)
        .withFixingDays(fixingDays)
        .withGearings(gearings)
        .withSpreads(spreads)
        .withCaps(caps)
        .withFloors(floors)
        .inArrears(isInArrears);
}


Leg _CmsZeroLeg(const std::vector<Real>& nominals,
                const Schedule& schedule,
                const boost::shared_ptr<Index>& index,
                const DayCounter& paymentDayCounter = DayCounter(),
                const BusinessDayConvention paymentConvention = Following,
                const std::vector<Natural>& fixingDays = std::vector<Natural>(),
                const std::vector<Real>& gearings = std::vector<Real>(),
                const std::vector<Spread>& spreads = std::vector<Spread>(),
                const std::vector<Rate>& caps = std::vector<Rate>(),
                const std::vector<Rate>& floors = std::vector<Rate>()) {
    boost::shared_ptr<SwapIndex> swapIndex =
        boost::dynamic_pointer_cast<SwapIndex>(index);
    return QuantLib::CmsLeg(schedule, swapIndex)
        .withNotionals(nominals)
        .withPaymentDayCounter(paymentDayCounter)
        .withPaymentAdjustment(paymentConvention)
        .withFixingDays(fixingDays)
        .withGearings(gearings)
        .withSpreads(spreads)
        .withCaps(caps)
        .withFloors(floors)
        .withZeroPayments();
}


Leg _CmsSpreadLeg(const std::vector<Real>& nominals,
            const Schedule& schedule,
            const boost::shared_ptr<Index>& index,
            const DayCounter& paymentDayCounter = DayCounter(),
            const BusinessDayConvention paymentConvention = Following,
            const std::vector<Natural>& fixingDays = std::vector<Natural>(),
            const std::vector<Real>& gearings = std::vector<Real>(),
            const std::vector<Spread>& spreads = std::vector<Spread>(),
            const std::vector<Rate>& caps = std::vector<Rate>(),
            const std::vector<Rate>& floors = std::vector<Rate>(),
            bool isInArrears = false) {
    boost::shared_ptr<SwapSpreadIndex> swapSpreadIndex =
        boost::dynamic_pointer_cast<SwapSpreadIndex>(index);
    return QuantLib::CmsSpreadLeg(schedule, swapSpreadIndex)
        .withNotionals(nominals)
        .withPaymentDayCounter(paymentDayCounter)
        .withPaymentAdjustment(paymentConvention)
        .withFixingDays(fixingDays)
        .withGearings(gearings)
        .withSpreads(spreads)
        .withCaps(caps)
        .withFloors(floors)
        .inArrears(isInArrears);
}


using QuantLib::CashFlows;
using QuantLib::Duration;

SWIGINTERN Real CashFlows_npv__SWIG_0(Leg const &leg,boost::shared_ptr< YieldTermStructure > const &discountCurve,Spread zSpread,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,bool includeSettlementDateFlows,Date const &settlementDate=Date(),Date const &npvDate=Date()){
            return QuantLib::CashFlows::npv(leg, discountCurve,
                                            zSpread,
                                            dayCounter,
                                            compounding,
                                            frequency,
                                            includeSettlementDateFlows,
                                            settlementDate,
                                            npvDate);
        }
SWIGINTERN Real CashFlows_npv__SWIG_3(Leg const &leg,Handle< YieldTermStructure > const &discountCurve,bool includeSettlementDateFlows,Date const &settlementDate=Date(),Date const &npvDate=Date()){
            return QuantLib::CashFlows::npv(leg, **discountCurve,
                                            includeSettlementDateFlows,
                                            settlementDate, npvDate);
        }
SWIGINTERN Real CashFlows_bps__SWIG_0(Leg const &leg,boost::shared_ptr< YieldTermStructure > const &discountCurve,bool includeSettlementDateFlows,Date const &settlementDate=Date(),Date const &npvDate=Date()){
            return QuantLib::CashFlows::bps(leg, *discountCurve,
                                            includeSettlementDateFlows,
                                            settlementDate, npvDate);
        }
SWIGINTERN Real CashFlows_bps__SWIG_3(Leg const &leg,Handle< YieldTermStructure > const &discountCurve,bool includeSettlementDateFlows,Date const &settlementDate=Date(),Date const &npvDate=Date()){
            return QuantLib::CashFlows::bps(leg, **discountCurve,
                                            includeSettlementDateFlows,
                                            settlementDate, npvDate);
        }
SWIGINTERN Rate CashFlows_atmRate__SWIG_0(Leg const &leg,boost::shared_ptr< YieldTermStructure > const &discountCurve,bool includeSettlementDateFlows,Date const &settlementDate=Date(),Date const &npvDate=Date(),Real npv=Null< Real >()){
            return QuantLib::CashFlows::atmRate(leg, *discountCurve,
                                                includeSettlementDateFlows,
                                                settlementDate, npvDate,
                                                npv);
        }

using QuantLib::CalibrationHelperBase;
using QuantLib::BlackCalibrationHelper;
using QuantLib::SwaptionHelper;
using QuantLib::CapHelper;
using QuantLib::HestonModelHelper;


    boost::shared_ptr<BlackCalibrationHelper> as_black_helper(const boost::shared_ptr<CalibrationHelperBase>& h) {
        return boost::dynamic_pointer_cast<BlackCalibrationHelper>(h);
    }
    boost::shared_ptr<SwaptionHelper> as_swaption_helper(const boost::shared_ptr<BlackCalibrationHelper>& h) {
        return boost::dynamic_pointer_cast<SwaptionHelper>(h);
    }

SWIGINTERN std::vector< Time > SwaptionHelper_times(SwaptionHelper *self){
            std::list<Time> l;
            self->addTimesTo(l);
            std::vector<Time> v;
            std::copy(l.begin(),l.end(),std::back_inserter(v));
            return v;
        }
SWIGINTERN Date SwaptionHelper_swaptionExpiryDate(SwaptionHelper *self){
            return self->swaption()->exercise()->date(0);
        }
SWIGINTERN Real SwaptionHelper_swaptionStrike(SwaptionHelper *self){
            return self->swaption()->underlyingSwap()->fixedRate();
        }
SWIGINTERN Real SwaptionHelper_swaptionNominal(SwaptionHelper *self){
            return self->swaption()->underlyingSwap()->nominal();
        }
SWIGINTERN Date SwaptionHelper_swaptionMaturityDate(SwaptionHelper *self){
            return self->swaption()->underlyingSwap()->fixedSchedule().dates().back();
        }
SWIGINTERN std::vector< Time > CapHelper_times(CapHelper *self){
            std::list<Time> l;
            self->addTimesTo(l);
            std::vector<Time> v;
            std::copy(l.begin(),l.end(),std::back_inserter(v));
            return v;
        }
SWIGINTERN std::vector< boost::shared_ptr< CalibrationHelperBase > > *new_std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelperBase_Sg__Sg___SWIG_2(int capacity){
        std::vector< boost::shared_ptr<CalibrationHelperBase> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< boost::shared_ptr<CalibrationHelperBase> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN boost::shared_ptr< CalibrationHelperBase > std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelperBase_Sg__Sg__getitemcopy(std::vector< boost::shared_ptr< CalibrationHelperBase > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< boost::shared_ptr< CalibrationHelperBase > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelperBase_Sg__Sg__getitem(std::vector< boost::shared_ptr< CalibrationHelperBase > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelperBase_Sg__Sg__setitem(std::vector< boost::shared_ptr< CalibrationHelperBase > > *self,int index,boost::shared_ptr< CalibrationHelperBase > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelperBase_Sg__Sg__AddRange(std::vector< boost::shared_ptr< CalibrationHelperBase > > *self,std::vector< boost::shared_ptr< CalibrationHelperBase > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< boost::shared_ptr< CalibrationHelperBase > > *std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelperBase_Sg__Sg__GetRange(std::vector< boost::shared_ptr< CalibrationHelperBase > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< boost::shared_ptr<CalibrationHelperBase> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelperBase_Sg__Sg__Insert(std::vector< boost::shared_ptr< CalibrationHelperBase > > *self,int index,boost::shared_ptr< CalibrationHelperBase > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelperBase_Sg__Sg__InsertRange(std::vector< boost::shared_ptr< CalibrationHelperBase > > *self,int index,std::vector< boost::shared_ptr< CalibrationHelperBase > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelperBase_Sg__Sg__RemoveAt(std::vector< boost::shared_ptr< CalibrationHelperBase > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelperBase_Sg__Sg__RemoveRange(std::vector< boost::shared_ptr< CalibrationHelperBase > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< boost::shared_ptr< CalibrationHelperBase > > *std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelperBase_Sg__Sg__Repeat(boost::shared_ptr< CalibrationHelperBase > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< boost::shared_ptr<CalibrationHelperBase> >(count, value);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelperBase_Sg__Sg__Reverse__SWIG_0(std::vector< boost::shared_ptr< CalibrationHelperBase > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelperBase_Sg__Sg__Reverse__SWIG_1(std::vector< boost::shared_ptr< CalibrationHelperBase > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelperBase_Sg__Sg__SetRange(std::vector< boost::shared_ptr< CalibrationHelperBase > > *self,int index,std::vector< boost::shared_ptr< CalibrationHelperBase > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelperBase_Sg__Sg__Contains(std::vector< boost::shared_ptr< CalibrationHelperBase > > *self,boost::shared_ptr< CalibrationHelperBase > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelperBase_Sg__Sg__IndexOf(std::vector< boost::shared_ptr< CalibrationHelperBase > > *self,boost::shared_ptr< CalibrationHelperBase > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<CalibrationHelperBase> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelperBase_Sg__Sg__LastIndexOf(std::vector< boost::shared_ptr< CalibrationHelperBase > > *self,boost::shared_ptr< CalibrationHelperBase > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<CalibrationHelperBase> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelperBase_Sg__Sg__Remove(std::vector< boost::shared_ptr< CalibrationHelperBase > > *self,boost::shared_ptr< CalibrationHelperBase > const &value){
        std::vector< boost::shared_ptr<CalibrationHelperBase> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }
SWIGINTERN std::vector< boost::shared_ptr< BlackCalibrationHelper > > *new_std_vector_Sl_boost_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg___SWIG_2(int capacity){
        std::vector< boost::shared_ptr<BlackCalibrationHelper> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< boost::shared_ptr<BlackCalibrationHelper> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN boost::shared_ptr< BlackCalibrationHelper > std_vector_Sl_boost_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__getitemcopy(std::vector< boost::shared_ptr< BlackCalibrationHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< boost::shared_ptr< BlackCalibrationHelper > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__getitem(std::vector< boost::shared_ptr< BlackCalibrationHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__setitem(std::vector< boost::shared_ptr< BlackCalibrationHelper > > *self,int index,boost::shared_ptr< BlackCalibrationHelper > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__AddRange(std::vector< boost::shared_ptr< BlackCalibrationHelper > > *self,std::vector< boost::shared_ptr< BlackCalibrationHelper > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< boost::shared_ptr< BlackCalibrationHelper > > *std_vector_Sl_boost_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__GetRange(std::vector< boost::shared_ptr< BlackCalibrationHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< boost::shared_ptr<BlackCalibrationHelper> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__Insert(std::vector< boost::shared_ptr< BlackCalibrationHelper > > *self,int index,boost::shared_ptr< BlackCalibrationHelper > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__InsertRange(std::vector< boost::shared_ptr< BlackCalibrationHelper > > *self,int index,std::vector< boost::shared_ptr< BlackCalibrationHelper > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__RemoveAt(std::vector< boost::shared_ptr< BlackCalibrationHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__RemoveRange(std::vector< boost::shared_ptr< BlackCalibrationHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< boost::shared_ptr< BlackCalibrationHelper > > *std_vector_Sl_boost_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__Repeat(boost::shared_ptr< BlackCalibrationHelper > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< boost::shared_ptr<BlackCalibrationHelper> >(count, value);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__Reverse__SWIG_0(std::vector< boost::shared_ptr< BlackCalibrationHelper > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__Reverse__SWIG_1(std::vector< boost::shared_ptr< BlackCalibrationHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__SetRange(std::vector< boost::shared_ptr< BlackCalibrationHelper > > *self,int index,std::vector< boost::shared_ptr< BlackCalibrationHelper > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__Contains(std::vector< boost::shared_ptr< BlackCalibrationHelper > > *self,boost::shared_ptr< BlackCalibrationHelper > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__IndexOf(std::vector< boost::shared_ptr< BlackCalibrationHelper > > *self,boost::shared_ptr< BlackCalibrationHelper > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<BlackCalibrationHelper> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__LastIndexOf(std::vector< boost::shared_ptr< BlackCalibrationHelper > > *self,boost::shared_ptr< BlackCalibrationHelper > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<BlackCalibrationHelper> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_BlackCalibrationHelper_Sg__Sg__Remove(std::vector< boost::shared_ptr< BlackCalibrationHelper > > *self,boost::shared_ptr< BlackCalibrationHelper > const &value){
        std::vector< boost::shared_ptr<BlackCalibrationHelper> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }

using QuantLib::CalibratedModel;
using QuantLib::TermStructureConsistentModel;

SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_CalibratedModel_Sg__asObservable(Handle< CalibratedModel > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_CalibratedModel_Sg__reset(RelinkableHandle< CalibratedModel > *self){
            self->linkTo(boost::shared_ptr<CalibratedModel>());
        }

using QuantLib::TimeGrid;

SWIGINTERN TimeGrid *new_TimeGrid__SWIG_2(std::vector< Time > const &times){
            return new TimeGrid(times.begin(), times.end());
        }
SWIGINTERN TimeGrid *new_TimeGrid__SWIG_3(std::vector< Time > const &times,Size steps){
            return new TimeGrid(times.begin(), times.end(), steps);
        }

using QuantLib::Parameter;
using QuantLib::ConstantParameter;
using QuantLib::NullParameter;
using QuantLib::PiecewiseConstantParameter;


using QuantLib::Payoff;
using QuantLib::TypePayoff;
using QuantLib::StrikedTypePayoff;


using QuantLib::Option;
using QuantLib::Barrier;


using QuantLib::OneAssetOption;
using QuantLib::VanillaOption;
using QuantLib::ForwardVanillaOption;

SWIGINTERN SampledCurve VanillaOption_priceCurve(VanillaOption *self){
            return self->result<SampledCurve>("priceCurve");
        }
SWIGINTERN std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > > *new_std_vector_Sl_std_pair_Sl_boost_shared_ptr_Sl_VanillaOption_Sg__Sc_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg___SWIG_2(int capacity){
        std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > std_vector_Sl_std_pair_Sl_boost_shared_ptr_Sl_VanillaOption_Sg__Sc_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__getitemcopy(std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > >::value_type const &std_vector_Sl_std_pair_Sl_boost_shared_ptr_Sl_VanillaOption_Sg__Sc_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__getitem(std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_boost_shared_ptr_Sl_VanillaOption_Sg__Sc_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__setitem(std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > > *self,int index,std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_boost_shared_ptr_Sl_VanillaOption_Sg__Sc_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__AddRange(std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > > *self,std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > > *std_vector_Sl_std_pair_Sl_boost_shared_ptr_Sl_VanillaOption_Sg__Sc_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__GetRange(std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_boost_shared_ptr_Sl_VanillaOption_Sg__Sc_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__Insert(std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > > *self,int index,std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_boost_shared_ptr_Sl_VanillaOption_Sg__Sc_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__InsertRange(std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > > *self,int index,std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_boost_shared_ptr_Sl_VanillaOption_Sg__Sc_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__RemoveAt(std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_boost_shared_ptr_Sl_VanillaOption_Sg__Sc_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__RemoveRange(std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > > *std_vector_Sl_std_pair_Sl_boost_shared_ptr_Sl_VanillaOption_Sg__Sc_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__Repeat(std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > >(count, value);
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_boost_shared_ptr_Sl_VanillaOption_Sg__Sc_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__Reverse__SWIG_0(std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_boost_shared_ptr_Sl_VanillaOption_Sg__Sc_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__Reverse__SWIG_1(std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_boost_shared_ptr_Sl_VanillaOption_Sg__Sc_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__SetRange(std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > > *self,int index,std::vector< std::pair< boost::shared_ptr< VanillaOption >,boost::shared_ptr< Quote > > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }

using QuantLib::EuropeanOption;


using QuantLib::ForwardVanillaOption;


using QuantLib::QuantoVanillaOption;


using QuantLib::QuantoForwardVanillaOption;


using QuantLib::MultiAssetOption;


using QuantLib::AnalyticEuropeanEngine;


using QuantLib::HestonModel;

SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_HestonModel_Sg__asObservable(Handle< HestonModel > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::PiecewiseTimeDependentHestonModel;


using QuantLib::AnalyticHestonEngine;


using QuantLib::COSHestonEngine;


using QuantLib::AnalyticPTDHestonEngine;


using QuantLib::BatesModel;


using QuantLib::BatesEngine;


using QuantLib::IntegralEngine;


using QuantLib::CrankNicolson;
typedef QuantLib::FDBermudanEngine<CrankNicolson> FDBermudanEngine;


typedef QuantLib::FDEuropeanEngine<CrankNicolson> FDEuropeanEngine;


using QuantLib::BinomialVanillaEngine;
using QuantLib::CoxRossRubinstein;
using QuantLib::JarrowRudd;
using QuantLib::AdditiveEQPBinomialTree;
using QuantLib::Trigeorgis;
using QuantLib::Tian;
using QuantLib::LeisenReimer;
using QuantLib::Joshi4;


using QuantLib::MCEuropeanEngine;
using QuantLib::MCEuropeanHestonEngine;
using QuantLib::MCAmericanEngine;
using QuantLib::PseudoRandom;
using QuantLib::LowDiscrepancy;
using QuantLib::LsmBasisSystem;

SWIGINTERN MCEuropeanEngine< PseudoRandom > *new_MCEuropeanEngine_Sl_PseudoRandom_Sg___SWIG_0(boost::shared_ptr< GeneralizedBlackScholesProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            QL_REQUIRE(Size(timeSteps) != Null<Size>() ||
                       Size(timeStepsPerYear) != Null<Size>(),
                       "number of steps not specified");
            return new MCEuropeanEngine<PseudoRandom>(process,
                                             timeSteps,
                                             timeStepsPerYear,
                                             brownianBridge,
                                             antitheticVariate,
                                             requiredSamples,
                                             requiredTolerance,
                                             maxSamples,
                                             seed);
        }
SWIGINTERN MCEuropeanEngine< LowDiscrepancy > *new_MCEuropeanEngine_Sl_LowDiscrepancy_Sg___SWIG_0(boost::shared_ptr< GeneralizedBlackScholesProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            QL_REQUIRE(Size(timeSteps) != Null<Size>() ||
                       Size(timeStepsPerYear) != Null<Size>(),
                       "number of steps not specified");
            return new MCEuropeanEngine<LowDiscrepancy>(process,
                                             timeSteps,
                                             timeStepsPerYear,
                                             brownianBridge,
                                             antitheticVariate,
                                             requiredSamples,
                                             requiredTolerance,
                                             maxSamples,
                                             seed);
        }
SWIGINTERN MCAmericanEngine< PseudoRandom > *new_MCAmericanEngine_Sl_PseudoRandom_Sg___SWIG_0(boost::shared_ptr< GeneralizedBlackScholesProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0,intOrNull polynomOrder=2,LsmBasisSystem::PolynomType polynomType=LsmBasisSystem::Monomial,int nCalibrationSamples=2048,boost::optional< bool > antitheticVariateCalibration=boost::none,BigNatural seedCalibration=Null< Size >()){
            return new MCAmericanEngine<PseudoRandom>(process,
                                             timeSteps,
                                             timeStepsPerYear,
                                             antitheticVariate,
                                             controlVariate,
                                             requiredSamples,
                                             requiredTolerance,
                                             maxSamples,
                                             seed,
                                             polynomOrder,
                                             polynomType,
                                             nCalibrationSamples,
                                             antitheticVariateCalibration,
                                             seedCalibration);
        }
SWIGINTERN MCAmericanEngine< LowDiscrepancy > *new_MCAmericanEngine_Sl_LowDiscrepancy_Sg___SWIG_0(boost::shared_ptr< GeneralizedBlackScholesProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0,intOrNull polynomOrder=2,LsmBasisSystem::PolynomType polynomType=LsmBasisSystem::Monomial,int nCalibrationSamples=2048,boost::optional< bool > antitheticVariateCalibration=boost::none,BigNatural seedCalibration=Null< Size >()){
            return new MCAmericanEngine<LowDiscrepancy>(process,
                                             timeSteps,
                                             timeStepsPerYear,
                                             antitheticVariate,
                                             controlVariate,
                                             requiredSamples,
                                             requiredTolerance,
                                             maxSamples,
                                             seed,
                                             polynomOrder,
                                             polynomType,
                                             nCalibrationSamples,
                                             antitheticVariateCalibration,
                                             seedCalibration);
        }
SWIGINTERN MCEuropeanHestonEngine< PseudoRandom > *new_MCEuropeanHestonEngine_Sl_PseudoRandom_Sg___SWIG_0(boost::shared_ptr< HestonProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            QL_REQUIRE(Size(timeSteps) != Null<Size>() ||
                       Size(timeStepsPerYear) != Null<Size>(),
                       "number of steps not specified");
            return new MCEuropeanHestonEngine<PseudoRandom>(process,
                                                   timeSteps,
                                                   timeStepsPerYear,
                                                   antitheticVariate,
                                                   requiredSamples,
                                                   requiredTolerance,
                                                   maxSamples,
                                                   seed);
        }
SWIGINTERN MCEuropeanHestonEngine< LowDiscrepancy > *new_MCEuropeanHestonEngine_Sl_LowDiscrepancy_Sg___SWIG_0(boost::shared_ptr< HestonProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            QL_REQUIRE(Size(timeSteps) != Null<Size>() ||
                       Size(timeStepsPerYear) != Null<Size>(),
                       "number of steps not specified");
            return new MCEuropeanHestonEngine<LowDiscrepancy>(process,
                                                   timeSteps,
                                                   timeStepsPerYear,
                                                   antitheticVariate,
                                                   requiredSamples,
                                                   requiredTolerance,
                                                   maxSamples,
                                                   seed);
        }

typedef QuantLib::FDAmericanEngine<CrankNicolson> FDAmericanEngine;
typedef QuantLib::FDShoutEngine<CrankNicolson> FDShoutEngine;


using QuantLib::ContinuousArithmeticAsianLevyEngine;


using QuantLib::FdBlackScholesAsianEngine;


using QuantLib::BaroneAdesiWhaleyApproximationEngine;


using QuantLib::BjerksundStenslandApproximationEngine;


using QuantLib::JuQuadraticApproximationEngine;


using QuantLib::AnalyticDigitalAmericanEngine;


using QuantLib::AnalyticDigitalAmericanKOEngine;


using QuantLib::DividendVanillaOption;


using QuantLib::AnalyticDividendEuropeanEngine;


using QuantLib::FDDividendEuropeanEngine;
using QuantLib::FDDividendAmericanEngine;


using QuantLib::BarrierOption;


using QuantLib::AnalyticBarrierEngine;
using QuantLib::MCBarrierEngine;

SWIGINTERN MCBarrierEngine< PseudoRandom > *new_MCBarrierEngine_Sl_PseudoRandom_Sg___SWIG_0(boost::shared_ptr< GeneralizedBlackScholesProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),bool isBiased=false,BigInteger seed=0){
            return new MCBarrierEngine<PseudoRandom>(process,
                                            timeSteps,
                                            timeStepsPerYear,
                                            brownianBridge,
                                            antitheticVariate,
                                            requiredSamples,
                                            requiredTolerance,
                                            maxSamples,
                                            isBiased,
                                            seed);
        }
SWIGINTERN MCBarrierEngine< LowDiscrepancy > *new_MCBarrierEngine_Sl_LowDiscrepancy_Sg___SWIG_0(boost::shared_ptr< GeneralizedBlackScholesProcess > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),bool isBiased=false,BigInteger seed=0){
            return new MCBarrierEngine<LowDiscrepancy>(process,
                                            timeSteps,
                                            timeStepsPerYear,
                                            brownianBridge,
                                            antitheticVariate,
                                            requiredSamples,
                                            requiredTolerance,
                                            maxSamples,
                                            isBiased,
                                            seed);
        }

using QuantLib::FdmSchemeDesc;


using QuantLib::FdBlackScholesVanillaEngine;
using QuantLib::FdBatesVanillaEngine;
using QuantLib::FdHestonVanillaEngine;


using QuantLib::AnalyticCEVEngine;
using QuantLib::FdCEVVanillaEngine;


using QuantLib::FdSabrVanillaEngine;


using QuantLib::FdBlackScholesBarrierEngine;


using QuantLib::AnalyticBinaryBarrierEngine;


using QuantLib::BinomialBarrierEngine;
using QuantLib::DiscretizedDermanKaniBarrierOption;


using QuantLib::ForwardVanillaEngine;
using QuantLib::QuantoEngine;
typedef ForwardVanillaEngine<AnalyticEuropeanEngine> ForwardEuropeanEngine;
typedef QuantoEngine<VanillaOption,AnalyticEuropeanEngine> QuantoEuropeanEngine;
typedef QuantoEngine<ForwardVanillaOption,AnalyticEuropeanEngine> QuantoForwardEuropeanEngine;


using QuantLib::BlackCalculator;


using QuantLib::Average;
using QuantLib::ContinuousAveragingAsianOption;
using QuantLib::DiscreteAveragingAsianOption;


using QuantLib::AnalyticContinuousGeometricAveragePriceAsianEngine;


using QuantLib::AnalyticDiscreteGeometricAveragePriceAsianEngine;


using QuantLib::AnalyticDiscreteGeometricAverageStrikeAsianEngine;


using QuantLib::MCDiscreteArithmeticAPEngine;
using QuantLib::MCDiscreteArithmeticASEngine;
using QuantLib::MCDiscreteGeometricAPEngine;

SWIGINTERN MCDiscreteArithmeticAPEngine< PseudoRandom > *new_MCDiscreteArithmeticAPEngine_Sl_PseudoRandom_Sg___SWIG_0(boost::shared_ptr< GeneralizedBlackScholesProcess > const &process,bool brownianBridge=false,bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCDiscreteArithmeticAPEngine<PseudoRandom>(process,
                                                         brownianBridge,
                                                         antitheticVariate,
                                                         controlVariate,
                                                         requiredSamples,
                                                         requiredTolerance,
                                                         maxSamples,
                                                         seed);
        }
SWIGINTERN MCDiscreteArithmeticAPEngine< LowDiscrepancy > *new_MCDiscreteArithmeticAPEngine_Sl_LowDiscrepancy_Sg___SWIG_0(boost::shared_ptr< GeneralizedBlackScholesProcess > const &process,bool brownianBridge=false,bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCDiscreteArithmeticAPEngine<LowDiscrepancy>(process,
                                                         brownianBridge,
                                                         antitheticVariate,
                                                         controlVariate,
                                                         requiredSamples,
                                                         requiredTolerance,
                                                         maxSamples,
                                                         seed);
        }
SWIGINTERN MCDiscreteArithmeticASEngine< PseudoRandom > *new_MCDiscreteArithmeticASEngine_Sl_PseudoRandom_Sg___SWIG_0(boost::shared_ptr< GeneralizedBlackScholesProcess > const &process,bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCDiscreteArithmeticASEngine<PseudoRandom>(process,
                                                         brownianBridge,
                                                         antitheticVariate,
                                                         requiredSamples,
                                                         requiredTolerance,
                                                         maxSamples,
                                                         seed);
        }
SWIGINTERN MCDiscreteArithmeticASEngine< LowDiscrepancy > *new_MCDiscreteArithmeticASEngine_Sl_LowDiscrepancy_Sg___SWIG_0(boost::shared_ptr< GeneralizedBlackScholesProcess > const &process,bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCDiscreteArithmeticASEngine<LowDiscrepancy>(process,
                                                         brownianBridge,
                                                         antitheticVariate,
                                                         requiredSamples,
                                                         requiredTolerance,
                                                         maxSamples,
                                                         seed);
        }
SWIGINTERN MCDiscreteGeometricAPEngine< PseudoRandom > *new_MCDiscreteGeometricAPEngine_Sl_PseudoRandom_Sg___SWIG_0(boost::shared_ptr< GeneralizedBlackScholesProcess > const &process,bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCDiscreteGeometricAPEngine<PseudoRandom>(process,
                                                        brownianBridge,
                                                        antitheticVariate,
                                                        requiredSamples,
                                                        requiredTolerance,
                                                        maxSamples,
                                                        seed);
        }
SWIGINTERN MCDiscreteGeometricAPEngine< LowDiscrepancy > *new_MCDiscreteGeometricAPEngine_Sl_LowDiscrepancy_Sg___SWIG_0(boost::shared_ptr< GeneralizedBlackScholesProcess > const &process,bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCDiscreteGeometricAPEngine<LowDiscrepancy>(process,
                                                        brownianBridge,
                                                        antitheticVariate,
                                                        requiredSamples,
                                                        requiredTolerance,
                                                        maxSamples,
                                                        seed);
        }

using QuantLib::VarianceGammaEngine;


using QuantLib::FFTVarianceGammaEngine;


using QuantLib::DoubleBarrierOption;
using QuantLib::DoubleBarrier;


using QuantLib::DoubleBarrierOption;


using QuantLib::QuantoDoubleBarrierOption;


using QuantLib::AnalyticDoubleBarrierEngine;


using QuantLib::WulinYongDoubleBarrierEngine;


using QuantLib::VannaVolgaBarrierEngine;
using QuantLib::DeltaVolQuote;

SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_DeltaVolQuote_Sg__asObservable(Handle< DeltaVolQuote > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_DeltaVolQuote_Sg__reset(RelinkableHandle< DeltaVolQuote > *self){
            self->linkTo(boost::shared_ptr<DeltaVolQuote>());
        }

using QuantLib::VannaVolgaDoubleBarrierEngine;


using QuantLib::AnalyticDoubleBarrierBinaryEngine;


using QuantLib::BinomialDoubleBarrierEngine;
using QuantLib::DiscretizedDermanKaniDoubleBarrierOption;


using QuantLib::VanillaSwingOption;


using QuantLib::FdSimpleBSSwingEngine;
using QuantLib::FdSimpleExtOUJumpSwingEngine;

SWIGINTERN FdSimpleExtOUJumpSwingEngine *new_FdSimpleExtOUJumpSwingEngine__SWIG_0(boost::shared_ptr< ExtOUWithJumpsProcess > const &process,boost::shared_ptr< YieldTermStructure > const &rTS,Size tGrid=50,Size xGrid=200,Size yGrid=50,std::vector< std::pair< Time,Real > > const &shape=std::vector< std::pair< Time,Real > >(),FdmSchemeDesc const &schemeDesc=FdmSchemeDesc::Hundsdorfer()){

            boost::shared_ptr<FdSimpleExtOUJumpSwingEngine::Shape> curve(
                              new FdSimpleExtOUJumpSwingEngine::Shape(shape));

            return new FdSimpleExtOUJumpSwingEngine(
                    process, rTS, tGrid, xGrid, yGrid,
                    curve, schemeDesc);
        }

using QuantLib::PlainVanillaPayoff;
using QuantLib::PercentageStrikePayoff;
using QuantLib::CashOrNothingPayoff;
using QuantLib::AssetOrNothingPayoff;
using QuantLib::SuperSharePayoff;
using QuantLib::GapPayoff;
using QuantLib::VanillaForwardPayoff;


    const boost::shared_ptr<PlainVanillaPayoff> as_plain_vanilla_payoff(
                           const boost::shared_ptr<Payoff>& payoff) {
        return boost::dynamic_pointer_cast<PlainVanillaPayoff>(payoff);
    }


using QuantLib::BasketOption;
using QuantLib::BasketPayoff;
using QuantLib::MinBasketPayoff;
using QuantLib::MaxBasketPayoff;
using QuantLib::AverageBasketPayoff;
using QuantLib::SpreadBasketPayoff;


using QuantLib::MCEuropeanBasketEngine;
using QuantLib::MCAmericanBasketEngine;

SWIGINTERN MCEuropeanBasketEngine< PseudoRandom > *new_MCEuropeanBasketEngine_Sl_PseudoRandom_Sg___SWIG_0(boost::shared_ptr< StochasticProcessArray > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCEuropeanBasketEngine<PseudoRandom>(process,
                                                   timeSteps,
                                                   timeStepsPerYear,
                                                   brownianBridge,
                                                   antitheticVariate,
                                                   requiredSamples,
                                                   requiredTolerance,
                                                   maxSamples,
                                                   seed);
        }
SWIGINTERN MCEuropeanBasketEngine< LowDiscrepancy > *new_MCEuropeanBasketEngine_Sl_LowDiscrepancy_Sg___SWIG_0(boost::shared_ptr< StochasticProcessArray > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCEuropeanBasketEngine<LowDiscrepancy>(process,
                                                   timeSteps,
                                                   timeStepsPerYear,
                                                   brownianBridge,
                                                   antitheticVariate,
                                                   requiredSamples,
                                                   requiredTolerance,
                                                   maxSamples,
                                                   seed);
        }
SWIGINTERN MCAmericanBasketEngine< PseudoRandom > *new_MCAmericanBasketEngine_Sl_PseudoRandom_Sg___SWIG_0(boost::shared_ptr< StochasticProcessArray > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0,Size nCalibrationSamples=Null< Size >(),Size polynomOrder=2,LsmBasisSystem::PolynomType polynomType=LsmBasisSystem::Monomial){
            return new MCAmericanBasketEngine<PseudoRandom>(process,
                                                   timeSteps,
                                                   timeStepsPerYear,
                                                   brownianBridge,
                                                   antitheticVariate,
                                                   requiredSamples,
                                                   requiredTolerance,
                                                   maxSamples,
                                                   seed,
                                                   nCalibrationSamples,
                                                   polynomOrder,
                                                   polynomType);
        }
SWIGINTERN MCAmericanBasketEngine< LowDiscrepancy > *new_MCAmericanBasketEngine_Sl_LowDiscrepancy_Sg___SWIG_0(boost::shared_ptr< StochasticProcessArray > const &process,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0,Size nCalibrationSamples=Null< Size >(),Size polynomOrder=2,LsmBasisSystem::PolynomType polynomType=LsmBasisSystem::Monomial){
            return new MCAmericanBasketEngine<LowDiscrepancy>(process,
                                                   timeSteps,
                                                   timeStepsPerYear,
                                                   brownianBridge,
                                                   antitheticVariate,
                                                   requiredSamples,
                                                   requiredTolerance,
                                                   maxSamples,
                                                   seed,
                                                   nCalibrationSamples,
                                                   polynomOrder,
                                                   polynomType);
        }

using QuantLib::StulzEngine;
using QuantLib::KirkEngine;
using QuantLib::Fd2dBlackScholesVanillaEngine;


using QuantLib::EverestOption;
using QuantLib::MCEverestEngine;

SWIGINTERN MCEverestEngine< PseudoRandom > *new_MCEverestEngine_Sl_PseudoRandom_Sg___SWIG_0(boost::shared_ptr< StochasticProcessArray > const &process,Size timeSteps=Null< Size >(),Size timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCEverestEngine<PseudoRandom>(process,
                                            timeSteps,
                                            timeStepsPerYear,
                                            brownianBridge,
                                            antitheticVariate,
                                            requiredSamples,
                                            requiredTolerance,
                                            maxSamples,
                                            seed);
        }
SWIGINTERN MCEverestEngine< LowDiscrepancy > *new_MCEverestEngine_Sl_LowDiscrepancy_Sg___SWIG_0(boost::shared_ptr< StochasticProcessArray > const &process,Size timeSteps=Null< Size >(),Size timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCEverestEngine<LowDiscrepancy>(process,
                                            timeSteps,
                                            timeStepsPerYear,
                                            brownianBridge,
                                            antitheticVariate,
                                            requiredSamples,
                                            requiredTolerance,
                                            maxSamples,
                                            seed);
        }

using QuantLib::HimalayaOption;
using QuantLib::MCHimalayaEngine;

SWIGINTERN MCHimalayaEngine< PseudoRandom > *new_MCHimalayaEngine_Sl_PseudoRandom_Sg___SWIG_0(boost::shared_ptr< StochasticProcessArray > const &process,bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCHimalayaEngine<PseudoRandom>(process,
                                             brownianBridge,
                                             antitheticVariate,
                                             requiredSamples,
                                             requiredTolerance,
                                             maxSamples,
                                             seed);
        }
SWIGINTERN MCHimalayaEngine< LowDiscrepancy > *new_MCHimalayaEngine_Sl_LowDiscrepancy_Sg___SWIG_0(boost::shared_ptr< StochasticProcessArray > const &process,bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            return new MCHimalayaEngine<LowDiscrepancy>(process,
                                             brownianBridge,
                                             antitheticVariate,
                                             requiredSamples,
                                             requiredTolerance,
                                             maxSamples,
                                             seed);
        }

using QuantLib::blackFormula;
using QuantLib::blackFormulaImpliedStdDev;
using QuantLib::blackFormulaImpliedStdDevLiRS;
using QuantLib::blackFormulaCashItmProbability;
using QuantLib::bachelierBlackFormula;
using QuantLib::bachelierBlackFormulaImpliedVol;


using QuantLib::BlackDeltaCalculator;


using QuantLib::Callability;
using QuantLib::SoftCallability;
typedef Callability::Price CallabilityPrice;
using QuantLib::CallabilitySchedule;

SWIGINTERN std::vector< boost::shared_ptr< Callability > > *new_std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg___SWIG_2(int capacity){
        std::vector< boost::shared_ptr<Callability> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< boost::shared_ptr<Callability> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN boost::shared_ptr< Callability > std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__getitemcopy(std::vector< boost::shared_ptr< Callability > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< boost::shared_ptr< Callability > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__getitem(std::vector< boost::shared_ptr< Callability > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__setitem(std::vector< boost::shared_ptr< Callability > > *self,int index,boost::shared_ptr< Callability > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__AddRange(std::vector< boost::shared_ptr< Callability > > *self,std::vector< boost::shared_ptr< Callability > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< boost::shared_ptr< Callability > > *std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__GetRange(std::vector< boost::shared_ptr< Callability > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< boost::shared_ptr<Callability> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__Insert(std::vector< boost::shared_ptr< Callability > > *self,int index,boost::shared_ptr< Callability > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__InsertRange(std::vector< boost::shared_ptr< Callability > > *self,int index,std::vector< boost::shared_ptr< Callability > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__RemoveAt(std::vector< boost::shared_ptr< Callability > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__RemoveRange(std::vector< boost::shared_ptr< Callability > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< boost::shared_ptr< Callability > > *std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__Repeat(boost::shared_ptr< Callability > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< boost::shared_ptr<Callability> >(count, value);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__Reverse__SWIG_0(std::vector< boost::shared_ptr< Callability > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__Reverse__SWIG_1(std::vector< boost::shared_ptr< Callability > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__SetRange(std::vector< boost::shared_ptr< Callability > > *self,int index,std::vector< boost::shared_ptr< Callability > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__Contains(std::vector< boost::shared_ptr< Callability > > *self,boost::shared_ptr< Callability > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__IndexOf(std::vector< boost::shared_ptr< Callability > > *self,boost::shared_ptr< Callability > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<Callability> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__LastIndexOf(std::vector< boost::shared_ptr< Callability > > *self,boost::shared_ptr< Callability > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<Callability> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__Remove(std::vector< boost::shared_ptr< Callability > > *self,boost::shared_ptr< Callability > const &value){
        std::vector< boost::shared_ptr<Callability> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }

using QuantLib::TimeBasket;


using QuantLib::Swap;
using QuantLib::VanillaSwap;
using QuantLib::MakeVanillaSwap;
using QuantLib::NonstandardSwap;
using QuantLib::DiscountingSwapEngine;
using QuantLib::FloatFloatSwap;
using QuantLib::OvernightIndexedSwap;

SWIGINTERN boost::shared_ptr< VanillaSwap > MakeVanillaSwap_makeVanillaSwap(MakeVanillaSwap *self){
                return (boost::shared_ptr<VanillaSwap>)(* self);
            }
SWIGINTERN DiscountingSwapEngine *new_DiscountingSwapEngine__SWIG_3(Handle< YieldTermStructure > const &discountCurve,Date const &settlementDate=Date(),Date const &npvDate=Date()){
            return new DiscountingSwapEngine(discountCurve,
                                             boost::none,
                                             settlementDate,
                                             npvDate);
        }

using QuantLib::AssetSwap;
using QuantLib::OvernightIndexedSwapIndex;


    boost::shared_ptr<OvernightIndexedSwap> as_overnight_swap_index(
                          const boost::shared_ptr<InterestRateIndex>& index) {
        return boost::dynamic_pointer_cast<OvernightIndexedSwap>(index);
    }


  using QuantLib::Seasonality;
  using QuantLib::MultiplicativePriceSeasonality;


  using QuantLib::InflationTermStructure;
  using QuantLib::YoYInflationTermStructure;
  using QuantLib::ZeroInflationTermStructure;

SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_YoYInflationTermStructure_Sg__asObservable(Handle< YoYInflationTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_YoYInflationTermStructure_Sg__reset(RelinkableHandle< YoYInflationTermStructure > *self){
            self->linkTo(boost::shared_ptr<YoYInflationTermStructure>());
        }
SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_ZeroInflationTermStructure_Sg__asObservable(Handle< ZeroInflationTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_ZeroInflationTermStructure_Sg__reset(RelinkableHandle< ZeroInflationTermStructure > *self){
            self->linkTo(boost::shared_ptr<ZeroInflationTermStructure>());
        }

#include <ql/indexes/inflationindex.hpp>
#include <ql/indexes/inflation/all.hpp>
using QuantLib::Region;
using QuantLib::CustomRegion;
using QuantLib::InflationIndex;
using QuantLib::ZeroInflationIndex;
using QuantLib::YoYInflationIndex;


using QuantLib::EUHICP;


using QuantLib::EUHICPXT;


using QuantLib::FRHICP;


using QuantLib::UKRPI;


using QuantLib::USCPI;


using QuantLib::ZACPI;


using QuantLib::YYEUHICP;


using QuantLib::YYEUHICPXT;


using QuantLib::YYFRHICP;


using QuantLib::YYUKRPI;


using QuantLib::YYUSCPI;


using QuantLib::YYZACPI;


    using QuantLib::CPI;



using QuantLib::BootstrapHelper;
using QuantLib::ZeroCouponInflationSwapHelper;
using QuantLib::YearOnYearInflationSwapHelper;

SWIGINTERN std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *new_std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg___SWIG_2(int capacity){
        std::vector< boost::shared_ptr<BootstrapHelper<ZeroInflationTermStructure> > >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< boost::shared_ptr<BootstrapHelper<ZeroInflationTermStructure> > >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__getitemcopy(std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__getitem(std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__setitem(std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,int index,boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__AddRange(std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__GetRange(std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< boost::shared_ptr<BootstrapHelper<ZeroInflationTermStructure> > >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__Insert(std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,int index,boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__InsertRange(std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,int index,std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__RemoveAt(std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__RemoveRange(std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__Repeat(boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< boost::shared_ptr<BootstrapHelper<ZeroInflationTermStructure> > >(count, value);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__Reverse__SWIG_0(std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__Reverse__SWIG_1(std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__SetRange(std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,int index,std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__Contains(std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__IndexOf(std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<BootstrapHelper<ZeroInflationTermStructure> > >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__LastIndexOf(std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<BootstrapHelper<ZeroInflationTermStructure> > >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_ZeroInflationTermStructure_Sg__Sg__Sg__Remove(std::vector< boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > > *self,boost::shared_ptr< BootstrapHelper< ZeroInflationTermStructure > > const &value){
        std::vector< boost::shared_ptr<BootstrapHelper<ZeroInflationTermStructure> > >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }
SWIGINTERN std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *new_std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg___SWIG_2(int capacity){
        std::vector< boost::shared_ptr<BootstrapHelper<YoYInflationTermStructure> > >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< boost::shared_ptr<BootstrapHelper<YoYInflationTermStructure> > >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__getitemcopy(std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__getitem(std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__setitem(std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,int index,boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__AddRange(std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__GetRange(std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< boost::shared_ptr<BootstrapHelper<YoYInflationTermStructure> > >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__Insert(std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,int index,boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__InsertRange(std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,int index,std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__RemoveAt(std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__RemoveRange(std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__Repeat(boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< boost::shared_ptr<BootstrapHelper<YoYInflationTermStructure> > >(count, value);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__Reverse__SWIG_0(std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__Reverse__SWIG_1(std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__SetRange(std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,int index,std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__Contains(std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__IndexOf(std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<BootstrapHelper<YoYInflationTermStructure> > >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__LastIndexOf(std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<BootstrapHelper<YoYInflationTermStructure> > >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_BootstrapHelper_Sl_YoYInflationTermStructure_Sg__Sg__Sg__Remove(std::vector< boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > > *self,boost::shared_ptr< BootstrapHelper< YoYInflationTermStructure > > const &value){
        std::vector< boost::shared_ptr<BootstrapHelper<YoYInflationTermStructure> > >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }
SWIGINTERN ZeroCouponInflationSwapHelper *new_ZeroCouponInflationSwapHelper__SWIG_0(Handle< Quote > const &quote,Period const &lag,Date const &maturity,Calendar const &calendar,BusinessDayConvention bcd,DayCounter const &dayCounter,boost::shared_ptr< ZeroInflationIndex > const &index,Handle< YieldTermStructure > const &nominalTS=Handle< YieldTermStructure >()){

            return new ZeroCouponInflationSwapHelper(quote,lag,maturity,
                                                     calendar,bcd,
                                                     dayCounter,index,
                                                     nominalTS);
        }
SWIGINTERN YearOnYearInflationSwapHelper *new_YearOnYearInflationSwapHelper__SWIG_0(Handle< Quote > const &quote,Period const &lag,Date const &maturity,Calendar const &calendar,BusinessDayConvention bdc,DayCounter const &dayCounter,boost::shared_ptr< YoYInflationIndex > const &index,Handle< YieldTermStructure > const &nominalTS=Handle< YieldTermStructure >()){
            return new YearOnYearInflationSwapHelper(quote,lag,maturity,
                                                     calendar,bdc,
                                                     dayCounter,index,
                                                     nominalTS);
        }

using QuantLib::PiecewiseZeroInflationCurve;
using QuantLib::PiecewiseYoYInflationCurve;



    Date inflationBaseDate(const Date& referenceDate,
                           const Period& observationLag,
                           Frequency frequency,
                           bool indexIsInterpolated) {
        if (indexIsInterpolated) {
            return referenceDate - observationLag;
        } else {
            return QuantLib::inflationPeriod(referenceDate - observationLag,
                                             frequency).first;
        }
    }



using QuantLib::ZeroCouponInflationSwap;
using QuantLib::YearOnYearInflationSwap;
using QuantLib::CPISwap;


using QuantLib::YoYInflationCapFloor;
using QuantLib::YoYInflationCap;
using QuantLib::YoYInflationFloor;
using QuantLib::YoYInflationCollar;


using QuantLib::ShortRateModel;

SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_ShortRateModel_Sg__asObservable(Handle< ShortRateModel > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_ShortRateModel_Sg__reset(RelinkableHandle< ShortRateModel > *self){
            self->linkTo(boost::shared_ptr<ShortRateModel>());
        }

using QuantLib::OneFactorAffineModel;
using QuantLib::Vasicek;
using QuantLib::HullWhite;
using QuantLib::BlackKarasinski;
using QuantLib::G2;


using QuantLib::JamshidianSwaptionEngine;
using QuantLib::TreeSwaptionEngine;
using QuantLib::AnalyticCapFloorEngine;
using QuantLib::TreeCapFloorEngine;
using QuantLib::G2SwaptionEngine;
using QuantLib::FdG2SwaptionEngine;
using QuantLib::FdHullWhiteSwaptionEngine;


using QuantLib::Bond;
using QuantLib::ZeroCouponBond;
using QuantLib::FixedRateBond;
using QuantLib::AmortizingFixedRateBond;
using QuantLib::FloatingRateBond;
using QuantLib::AmortizingFloatingRateBond;
using QuantLib::DiscountingBondEngine;


    Real cleanPriceFromZSpread(
                   const boost::shared_ptr<Bond>& bond,
                   const boost::shared_ptr<YieldTermStructure>& discountCurve,
                   Spread zSpread,
                   const DayCounter& dc,
                   Compounding compounding,
                   Frequency freq,
                   const Date& settlementDate = Date()) {
        return QuantLib::BondFunctions::cleanPrice(
                                  *(boost::dynamic_pointer_cast<Bond>(bond)),
                                  discountCurve,
                                  zSpread, dc, compounding,
                                  freq, settlementDate);
    }



using QuantLib::CmsRateBond;


using QuantLib::CallableBond;
using QuantLib::CallableFixedRateBond;
using QuantLib::TreeCallableFixedRateBondEngine;
using QuantLib::BlackCallableFixedRateBondEngine;


using QuantLib::CPIBond;


using QuantLib::BondFunctions;

SWIGINTERN Date BondFunctions_startDate(boost::shared_ptr< Bond > const &bond){
            return QuantLib::BondFunctions::startDate(
                    *(boost::dynamic_pointer_cast<Bond>(bond)));
        }
SWIGINTERN Date BondFunctions_maturityDate(boost::shared_ptr< Bond > const &bond){
            return QuantLib::BondFunctions::maturityDate(
                    *(boost::dynamic_pointer_cast<Bond>(bond)));
        }
SWIGINTERN bool BondFunctions_isTradable__SWIG_0(boost::shared_ptr< Bond > const &bond,Date settlementDate=Date()){
            return QuantLib::BondFunctions::isTradable(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    settlementDate);
        }
SWIGINTERN Date BondFunctions_previousCashFlowDate__SWIG_0(boost::shared_ptr< Bond > const &bond,Date refDate=Date()){
            return QuantLib::BondFunctions::previousCashFlowDate(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    refDate);
        }
SWIGINTERN Date BondFunctions_nextCashFlowDate__SWIG_0(boost::shared_ptr< Bond > const &bond,Date refDate=Date()){
            return QuantLib::BondFunctions::nextCashFlowDate(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    refDate);
        }
SWIGINTERN Real BondFunctions_previousCashFlowAmount__SWIG_0(boost::shared_ptr< Bond > const &bond,Date refDate=Date()){
            return QuantLib::BondFunctions::previousCashFlowAmount(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    refDate);
        }
SWIGINTERN Real BondFunctions_nextCashFlowAmount__SWIG_0(boost::shared_ptr< Bond > const &bond,Date refDate=Date()){
            return QuantLib::BondFunctions::nextCashFlowAmount(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    refDate);
        }
SWIGINTERN Rate BondFunctions_previousCouponRate__SWIG_0(boost::shared_ptr< Bond > const &bond,Date settlementDate=Date()){
            return QuantLib::BondFunctions::previousCouponRate(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    settlementDate);
        }
SWIGINTERN Rate BondFunctions_nextCouponRate__SWIG_0(boost::shared_ptr< Bond > const &bond,Date settlementDate=Date()){
            return QuantLib::BondFunctions::nextCouponRate(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    settlementDate);
        }
SWIGINTERN Date BondFunctions_accrualStartDate__SWIG_0(boost::shared_ptr< Bond > const &bond,Date settlementDate=Date()){
            return QuantLib::BondFunctions::accrualStartDate(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    settlementDate);
        }
SWIGINTERN Date BondFunctions_accrualEndDate__SWIG_0(boost::shared_ptr< Bond > const &bond,Date settlementDate=Date()){
            return QuantLib::BondFunctions::accrualEndDate(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    settlementDate);
        }
SWIGINTERN Time BondFunctions_accrualPeriod__SWIG_0(boost::shared_ptr< Bond > const &bond,Date settlementDate=Date()){
            return QuantLib::BondFunctions::accrualPeriod(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    settlementDate);
        }
SWIGINTERN BigInteger BondFunctions_accrualDays__SWIG_0(boost::shared_ptr< Bond > const &bond,Date settlementDate=Date()){
            return QuantLib::BondFunctions::accrualDays(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    settlementDate);
        }
SWIGINTERN Time BondFunctions_accruedPeriod__SWIG_0(boost::shared_ptr< Bond > const &bond,Date settlementDate=Date()){
            return QuantLib::BondFunctions::accruedPeriod(
                *(boost::dynamic_pointer_cast<Bond>(bond)),
                settlementDate);
        }
SWIGINTERN BigInteger BondFunctions_accruedDays__SWIG_0(boost::shared_ptr< Bond > const &bond,Date settlementDate=Date()){
            return QuantLib::BondFunctions::accruedDays(
                *(boost::dynamic_pointer_cast<Bond>(bond)),
                settlementDate);
        }
SWIGINTERN Real BondFunctions_accruedAmount__SWIG_0(boost::shared_ptr< Bond > const &bond,Date settlementDate=Date()){

            return QuantLib::BondFunctions::accruedAmount(
                *(boost::dynamic_pointer_cast<Bond>(bond)), 
                settlementDate);
        }
SWIGINTERN Real BondFunctions_cleanPrice__SWIG_0(boost::shared_ptr< Bond > const &bond,boost::shared_ptr< YieldTermStructure > const &discountCurve,Date settlementDate=Date()){
            return QuantLib::BondFunctions::cleanPrice(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    *discountCurve,
                    settlementDate);
        }
SWIGINTERN Real BondFunctions_bps__SWIG_0(boost::shared_ptr< Bond > const &bond,boost::shared_ptr< YieldTermStructure > const &discountCurve,Date settlementDate=Date()){
            return QuantLib::BondFunctions::bps(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    *discountCurve,
                    settlementDate);
        }
SWIGINTERN Rate BondFunctions_atmRate__SWIG_0(boost::shared_ptr< Bond > const &bond,boost::shared_ptr< YieldTermStructure > const &discountCurve,Date settlementDate=Date(),Real cleanPrice=Null< Real >()){
            return QuantLib::BondFunctions::atmRate(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    *discountCurve,
                    settlementDate,
                    cleanPrice);
        }
SWIGINTERN Real BondFunctions_cleanPrice__SWIG_2(boost::shared_ptr< Bond > const &bond,InterestRate const &yield,Date settlementDate=Date()){
            return QuantLib::BondFunctions::cleanPrice(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    yield,
                    settlementDate);
        }
SWIGINTERN Real BondFunctions_cleanPrice__SWIG_4(boost::shared_ptr< Bond > const &bond,Rate yield,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date()){
            return QuantLib::BondFunctions::cleanPrice(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    yield,
                    dayCounter,
                    compounding,
                    frequency,
                    settlementDate);
        }
SWIGINTERN Real BondFunctions_bps__SWIG_2(boost::shared_ptr< Bond > const &bond,InterestRate const &yield,Date settlementDate=Date()){
            return QuantLib::BondFunctions::bps(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        yield,
                        settlementDate);
        }
SWIGINTERN Real BondFunctions_bps__SWIG_4(boost::shared_ptr< Bond > const &bond,Rate yield,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date()){
            return QuantLib::BondFunctions::bps(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        yield,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate);
        }
SWIGINTERN Rate BondFunctions_yield__SWIG_0(boost::shared_ptr< Bond > const &bond,Real cleanPrice,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date(),Real accuracy=1.0e-10,Size maxIterations=100,Rate guess=0.05){
            return QuantLib::BondFunctions::yield(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        cleanPrice,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate,
                        accuracy,
                        maxIterations,
                        guess);
        }
SWIGINTERN Rate BondFunctions_yieldBrent__SWIG_0(Brent solver,boost::shared_ptr< Bond > const &bond,Real cleanPrice,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date(),Real accuracy=1.0e-10,Rate guess=0.05){
            return QuantLib::BondFunctions::yield<Brent>(
                        solver,
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        cleanPrice,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate,
                        accuracy,
                        guess);
        }
SWIGINTERN Rate BondFunctions_yieldBisection__SWIG_0(Bisection solver,boost::shared_ptr< Bond > const &bond,Real cleanPrice,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date(),Real accuracy=1.0e-10,Rate guess=0.05){
            return QuantLib::BondFunctions::yield<Bisection>(
                        solver,
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        cleanPrice,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate,
                        accuracy,
                        guess);
        }
SWIGINTERN Rate BondFunctions_yieldFalsePosition__SWIG_0(FalsePosition solver,boost::shared_ptr< Bond > const &bond,Real cleanPrice,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date(),Real accuracy=1.0e-10,Rate guess=0.05){
            return QuantLib::BondFunctions::yield<FalsePosition>(
                        solver,
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        cleanPrice,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate,
                        accuracy,
                        guess);
        }
SWIGINTERN Rate BondFunctions_yieldRidder__SWIG_0(Ridder solver,boost::shared_ptr< Bond > const &bond,Real cleanPrice,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date(),Real accuracy=1.0e-10,Rate guess=0.05){
            return QuantLib::BondFunctions::yield<Ridder>(
                        solver,
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        cleanPrice,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate,
                        accuracy,
                        guess);
        }
SWIGINTERN Rate BondFunctions_yieldSecant__SWIG_0(Secant solver,boost::shared_ptr< Bond > const &bond,Real cleanPrice,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date(),Real accuracy=1.0e-10,Rate guess=0.05){
            return QuantLib::BondFunctions::yield<Secant>(
                        solver,
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        cleanPrice,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate,
                        accuracy,
                        guess);
        }
SWIGINTERN Time BondFunctions_duration__SWIG_0(boost::shared_ptr< Bond > const &bond,InterestRate const &yield,Duration::Type type=Duration::Modified,Date settlementDate=Date()){
            return QuantLib::BondFunctions::duration(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        yield,
                        type,
                        settlementDate);
        }
SWIGINTERN Time BondFunctions_duration__SWIG_3(boost::shared_ptr< Bond > const &bond,Rate yield,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Duration::Type type=Duration::Modified,Date settlementDate=Date()){
            return QuantLib::BondFunctions::duration(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        yield,
                        dayCounter,
                        compounding,
                        frequency,
                        type,
                        settlementDate);
        }
SWIGINTERN Real BondFunctions_convexity__SWIG_0(boost::shared_ptr< Bond > const &bond,InterestRate const &yield,Date settlementDate=Date()){
            return QuantLib::BondFunctions::convexity(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        yield,
                        settlementDate);
        }
SWIGINTERN Real BondFunctions_convexity__SWIG_2(boost::shared_ptr< Bond > const &bond,Rate yield,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date()){
            return QuantLib::BondFunctions::convexity(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        yield,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate);
        }
SWIGINTERN Real BondFunctions_basisPointValue__SWIG_0(boost::shared_ptr< Bond > const &bond,InterestRate const &yield,Date settlementDate=Date()){
            return QuantLib::BondFunctions::basisPointValue(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        yield,
                        settlementDate);
        }
SWIGINTERN Real BondFunctions_basisPointValue__SWIG_2(boost::shared_ptr< Bond > const &bond,Rate yield,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date()){
            return QuantLib::BondFunctions::basisPointValue(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        yield,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate);
        }
SWIGINTERN Real BondFunctions_yieldValueBasisPoint__SWIG_0(boost::shared_ptr< Bond > const &bond,InterestRate const &yield,Date settlementDate=Date()){
            return QuantLib::BondFunctions::yieldValueBasisPoint(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        yield,
                        settlementDate);
        }
SWIGINTERN Real BondFunctions_yieldValueBasisPoint__SWIG_2(boost::shared_ptr< Bond > const &bond,Rate yield,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date()){
            return QuantLib::BondFunctions::yieldValueBasisPoint(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        yield,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate);
        }
SWIGINTERN Spread BondFunctions_zSpread__SWIG_0(boost::shared_ptr< Bond > const &bond,Real cleanPrice,boost::shared_ptr< YieldTermStructure > const &discountCurve,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date(),Real accuracy=1.0e-10,Size maxIterations=100,Rate guess=0.0){
            return QuantLib::BondFunctions::zSpread(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        cleanPrice,
                        discountCurve,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate,
                        accuracy,
                        maxIterations,
                        guess);

        }

using QuantLib::CapFloor;
using QuantLib::Cap;
using QuantLib::Floor;
using QuantLib::Collar;

SWIGINTERN Real const CapFloor_vega(CapFloor *self){
        return self->result<Real>("vega");
      }
SWIGINTERN std::vector< Real > const CapFloor_optionletsPrice(CapFloor *self){
        return self->result<std::vector<Real> >("optionletsPrice");
      }
SWIGINTERN std::vector< Real > const CapFloor_optionletsVega(CapFloor *self){
        return self->result<std::vector<Real> >("optionletsVega");
      }
SWIGINTERN std::vector< Rate > const CapFloor_optionletsAtmForward(CapFloor *self){
        return self->result<std::vector<Real> >("optionletsAtmForward");
      }
SWIGINTERN std::vector< Rate > const CapFloor_optionletsStdDev(CapFloor *self){
        return self->result<std::vector<Real> >("optionletsStdDev");
      }

using QuantLib::BlackCapFloorEngine;


using QuantLib::BachelierCapFloorEngine;


using QuantLib::Dividend;


using QuantLib::FixedDividend;
using QuantLib::FractionalDividend;

SWIGINTERN std::vector< boost::shared_ptr< Dividend > > *new_std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg___SWIG_2(int capacity){
        std::vector< boost::shared_ptr<Dividend> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< boost::shared_ptr<Dividend> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN boost::shared_ptr< Dividend > std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__getitemcopy(std::vector< boost::shared_ptr< Dividend > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< boost::shared_ptr< Dividend > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__getitem(std::vector< boost::shared_ptr< Dividend > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__setitem(std::vector< boost::shared_ptr< Dividend > > *self,int index,boost::shared_ptr< Dividend > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__AddRange(std::vector< boost::shared_ptr< Dividend > > *self,std::vector< boost::shared_ptr< Dividend > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< boost::shared_ptr< Dividend > > *std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__GetRange(std::vector< boost::shared_ptr< Dividend > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< boost::shared_ptr<Dividend> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__Insert(std::vector< boost::shared_ptr< Dividend > > *self,int index,boost::shared_ptr< Dividend > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__InsertRange(std::vector< boost::shared_ptr< Dividend > > *self,int index,std::vector< boost::shared_ptr< Dividend > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__RemoveAt(std::vector< boost::shared_ptr< Dividend > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__RemoveRange(std::vector< boost::shared_ptr< Dividend > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< boost::shared_ptr< Dividend > > *std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__Repeat(boost::shared_ptr< Dividend > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< boost::shared_ptr<Dividend> >(count, value);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__Reverse__SWIG_0(std::vector< boost::shared_ptr< Dividend > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__Reverse__SWIG_1(std::vector< boost::shared_ptr< Dividend > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__SetRange(std::vector< boost::shared_ptr< Dividend > > *self,int index,std::vector< boost::shared_ptr< Dividend > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__Contains(std::vector< boost::shared_ptr< Dividend > > *self,boost::shared_ptr< Dividend > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__IndexOf(std::vector< boost::shared_ptr< Dividend > > *self,boost::shared_ptr< Dividend > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<Dividend> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__LastIndexOf(std::vector< boost::shared_ptr< Dividend > > *self,boost::shared_ptr< Dividend > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<Dividend> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__Remove(std::vector< boost::shared_ptr< Dividend > > *self,boost::shared_ptr< Dividend > const &value){
        std::vector< boost::shared_ptr<Dividend> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }

using QuantLib::ConvertibleZeroCouponBond;
using QuantLib::ConvertibleFixedCouponBond;
using QuantLib::ConvertibleFloatingRateBond;
using QuantLib::BinomialConvertibleEngine;


using QuantLib::DefaultProbabilityTermStructure;

SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_DefaultProbabilityTermStructure_Sg__asObservable(Handle< DefaultProbabilityTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_DefaultProbabilityTermStructure_Sg__reset(RelinkableHandle< DefaultProbabilityTermStructure > *self){
            self->linkTo(boost::shared_ptr<DefaultProbabilityTermStructure>());
        }

using QuantLib::FlatHazardRate;


using QuantLib::InterpolatedHazardRateCurve;


using QuantLib::InterpolatedDefaultDensityCurve;


using QuantLib::InterpolatedSurvivalProbabilityCurve;


using QuantLib::DefaultProbabilityHelper;
using QuantLib::SpreadCdsHelper;
using QuantLib::UpfrontCdsHelper;

SWIGINTERN std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *new_std_vector_Sl_boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg___SWIG_2(int capacity){
        std::vector< boost::shared_ptr<DefaultProbabilityHelper> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< boost::shared_ptr<DefaultProbabilityHelper> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN boost::shared_ptr< DefaultProbabilityHelper > std_vector_Sl_boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__getitemcopy(std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< boost::shared_ptr< DefaultProbabilityHelper > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__getitem(std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__setitem(std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *self,int index,boost::shared_ptr< DefaultProbabilityHelper > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__AddRange(std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *self,std::vector< boost::shared_ptr< DefaultProbabilityHelper > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *std_vector_Sl_boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__GetRange(std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< boost::shared_ptr<DefaultProbabilityHelper> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__Insert(std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *self,int index,boost::shared_ptr< DefaultProbabilityHelper > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__InsertRange(std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *self,int index,std::vector< boost::shared_ptr< DefaultProbabilityHelper > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__RemoveAt(std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__RemoveRange(std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *std_vector_Sl_boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__Repeat(boost::shared_ptr< DefaultProbabilityHelper > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< boost::shared_ptr<DefaultProbabilityHelper> >(count, value);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__Reverse__SWIG_0(std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__Reverse__SWIG_1(std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__SetRange(std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *self,int index,std::vector< boost::shared_ptr< DefaultProbabilityHelper > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__Contains(std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *self,boost::shared_ptr< DefaultProbabilityHelper > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__IndexOf(std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *self,boost::shared_ptr< DefaultProbabilityHelper > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<DefaultProbabilityHelper> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__LastIndexOf(std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *self,boost::shared_ptr< DefaultProbabilityHelper > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<DefaultProbabilityHelper> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__Remove(std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *self,boost::shared_ptr< DefaultProbabilityHelper > const &value){
        std::vector< boost::shared_ptr<DefaultProbabilityHelper> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }

using QuantLib::HazardRate;
using QuantLib::DefaultDensity;


using QuantLib::PiecewiseDefaultCurve;


typedef PiecewiseDefaultCurve<HazardRate, BackwardFlat> PiecewiseFlatHazardRate;


using QuantLib::Protection;


using QuantLib::CreditDefaultSwap;
using QuantLib::MidPointCdsEngine;
using QuantLib::IntegralCdsEngine;
using QuantLib::IsdaCdsEngine;
using QuantLib::Claim;
using QuantLib::FaceValueClaim;
using QuantLib::FaceValueAccrualClaim;
using QuantLib::CdsOption;
using QuantLib::BlackCdsOptionEngine;

SWIGINTERN doubleOrNull CreditDefaultSwap_upfront(CreditDefaultSwap const *self){
            boost::optional<Rate> result =
                self->upfront();
            if (result)
                return *result;
            else
                return Null<double>();
        }

using QuantLib::InterpolatedDiscountCurve;


using QuantLib::NormalDistribution;
using QuantLib::CumulativeNormalDistribution;
using QuantLib::MoroInverseCumulativeNormal;
using QuantLib::InverseCumulativeNormal;
using QuantLib::BivariateCumulativeNormalDistribution;
using QuantLib::BinomialDistribution;
using QuantLib::CumulativeBinomialDistribution;
using QuantLib::BivariateCumulativeNormalDistributionDr78;
using QuantLib::BivariateCumulativeNormalDistributionWe04DP;
using QuantLib::CumulativeChiSquareDistribution;
using QuantLib::NonCentralCumulativeChiSquareDistribution;
using QuantLib::InverseNonCentralCumulativeChiSquareDistribution;
using QuantLib::CumulativeGammaDistribution;
using QuantLib::GammaFunction;
using QuantLib::PoissonDistribution;
using QuantLib::CumulativePoissonDistribution;
using QuantLib::InverseCumulativePoisson;
using QuantLib::StudentDistribution;
using QuantLib::CumulativeStudentDistribution;
using QuantLib::InverseCumulativeStudent;


using QuantLib::Money;

SWIGINTERN void Money_setConversionType(Money::ConversionType type){
            Money::conversionType = type;
        }
SWIGINTERN void Money_setBaseCurrency(Currency const &c){
            Money::baseCurrency = c;
        }

using QuantLib::ExchangeRate;
using QuantLib::ExchangeRateManager;


using QuantLib::Futures;


using QuantLib::Pillar;
using QuantLib::RateHelper;
using QuantLib::DepositRateHelper;
using QuantLib::FraRateHelper;
using QuantLib::FuturesRateHelper;
using QuantLib::SwapRateHelper;
using QuantLib::BondHelper;
using QuantLib::FixedRateBondHelper;
using QuantLib::OISRateHelper;
using QuantLib::DatedOISRateHelper;
using QuantLib::FxSwapRateHelper;

SWIGINTERN std::vector< boost::shared_ptr< RateHelper > > *new_std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg___SWIG_2(int capacity){
        std::vector< boost::shared_ptr<RateHelper> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< boost::shared_ptr<RateHelper> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN boost::shared_ptr< RateHelper > std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__getitemcopy(std::vector< boost::shared_ptr< RateHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< boost::shared_ptr< RateHelper > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__getitem(std::vector< boost::shared_ptr< RateHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__setitem(std::vector< boost::shared_ptr< RateHelper > > *self,int index,boost::shared_ptr< RateHelper > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__AddRange(std::vector< boost::shared_ptr< RateHelper > > *self,std::vector< boost::shared_ptr< RateHelper > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< boost::shared_ptr< RateHelper > > *std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__GetRange(std::vector< boost::shared_ptr< RateHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< boost::shared_ptr<RateHelper> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__Insert(std::vector< boost::shared_ptr< RateHelper > > *self,int index,boost::shared_ptr< RateHelper > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__InsertRange(std::vector< boost::shared_ptr< RateHelper > > *self,int index,std::vector< boost::shared_ptr< RateHelper > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__RemoveAt(std::vector< boost::shared_ptr< RateHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__RemoveRange(std::vector< boost::shared_ptr< RateHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< boost::shared_ptr< RateHelper > > *std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__Repeat(boost::shared_ptr< RateHelper > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< boost::shared_ptr<RateHelper> >(count, value);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__Reverse__SWIG_0(std::vector< boost::shared_ptr< RateHelper > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__Reverse__SWIG_1(std::vector< boost::shared_ptr< RateHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__SetRange(std::vector< boost::shared_ptr< RateHelper > > *self,int index,std::vector< boost::shared_ptr< RateHelper > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__Contains(std::vector< boost::shared_ptr< RateHelper > > *self,boost::shared_ptr< RateHelper > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__IndexOf(std::vector< boost::shared_ptr< RateHelper > > *self,boost::shared_ptr< RateHelper > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<RateHelper> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__LastIndexOf(std::vector< boost::shared_ptr< RateHelper > > *self,boost::shared_ptr< RateHelper > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<RateHelper> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__Remove(std::vector< boost::shared_ptr< RateHelper > > *self,boost::shared_ptr< RateHelper > const &value){
        std::vector< boost::shared_ptr<RateHelper> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }
SWIGINTERN std::vector< boost::shared_ptr< BondHelper > > *new_std_vector_Sl_boost_shared_ptr_Sl_BondHelper_Sg__Sg___SWIG_2(int capacity){
        std::vector< boost::shared_ptr<BondHelper> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector< boost::shared_ptr<BondHelper> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN boost::shared_ptr< BondHelper > std_vector_Sl_boost_shared_ptr_Sl_BondHelper_Sg__Sg__getitemcopy(std::vector< boost::shared_ptr< BondHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector< boost::shared_ptr< BondHelper > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_BondHelper_Sg__Sg__getitem(std::vector< boost::shared_ptr< BondHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BondHelper_Sg__Sg__setitem(std::vector< boost::shared_ptr< BondHelper > > *self,int index,boost::shared_ptr< BondHelper > const &val){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = val;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BondHelper_Sg__Sg__AddRange(std::vector< boost::shared_ptr< BondHelper > > *self,std::vector< boost::shared_ptr< BondHelper > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector< boost::shared_ptr< BondHelper > > *std_vector_Sl_boost_shared_ptr_Sl_BondHelper_Sg__Sg__GetRange(std::vector< boost::shared_ptr< BondHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector< boost::shared_ptr<BondHelper> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BondHelper_Sg__Sg__Insert(std::vector< boost::shared_ptr< BondHelper > > *self,int index,boost::shared_ptr< BondHelper > const &x){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, x);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BondHelper_Sg__Sg__InsertRange(std::vector< boost::shared_ptr< BondHelper > > *self,int index,std::vector< boost::shared_ptr< BondHelper > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BondHelper_Sg__Sg__RemoveAt(std::vector< boost::shared_ptr< BondHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BondHelper_Sg__Sg__RemoveRange(std::vector< boost::shared_ptr< BondHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector< boost::shared_ptr< BondHelper > > *std_vector_Sl_boost_shared_ptr_Sl_BondHelper_Sg__Sg__Repeat(boost::shared_ptr< BondHelper > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector< boost::shared_ptr<BondHelper> >(count, value);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BondHelper_Sg__Sg__Reverse__SWIG_0(std::vector< boost::shared_ptr< BondHelper > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BondHelper_Sg__Sg__Reverse__SWIG_1(std::vector< boost::shared_ptr< BondHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_BondHelper_Sg__Sg__SetRange(std::vector< boost::shared_ptr< BondHelper > > *self,int index,std::vector< boost::shared_ptr< BondHelper > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_BondHelper_Sg__Sg__Contains(std::vector< boost::shared_ptr< BondHelper > > *self,boost::shared_ptr< BondHelper > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_BondHelper_Sg__Sg__IndexOf(std::vector< boost::shared_ptr< BondHelper > > *self,boost::shared_ptr< BondHelper > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<BondHelper> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = (int)(it - self->begin());
        return index;
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_BondHelper_Sg__Sg__LastIndexOf(std::vector< boost::shared_ptr< BondHelper > > *self,boost::shared_ptr< BondHelper > const &value){
        int index = -1;
        std::vector< boost::shared_ptr<BondHelper> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = (int)(self->rend() - 1 - rit);
        return index;
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_BondHelper_Sg__Sg__Remove(std::vector< boost::shared_ptr< BondHelper > > *self,boost::shared_ptr< BondHelper > const &value){
        std::vector< boost::shared_ptr<BondHelper> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end()) {
          self->erase(it);
          return true;
        }
        return false;
      }

    const boost::shared_ptr<DepositRateHelper> as_depositratehelper(const boost::shared_ptr<RateHelper> helper) {
        return boost::dynamic_pointer_cast<DepositRateHelper>(helper);
    }
	const boost::shared_ptr<FraRateHelper> as_fraratehelper(const boost::shared_ptr<RateHelper> helper) {
        return boost::dynamic_pointer_cast<FraRateHelper>(helper);
    }
    const boost::shared_ptr<SwapRateHelper> as_swapratehelper(const boost::shared_ptr<RateHelper> helper) {
        return boost::dynamic_pointer_cast<SwapRateHelper>(helper);
    }
    const boost::shared_ptr<OISRateHelper> as_oisratehelper(const boost::shared_ptr<RateHelper> helper) {
        return boost::dynamic_pointer_cast<OISRateHelper>(helper);
    }


using QuantLib::FittedBondDiscountCurve;

typedef boost::shared_ptr<YieldTermStructure> FittedBondDiscountCurvePtr;
typedef QuantLib::FittedBondDiscountCurve::FittingMethod FittingMethod;

std::vector<boost::shared_ptr<BondHelper> > convert_bond_helpers(
                 const std::vector<boost::shared_ptr<RateHelper> >& helpers) {
    std::vector<boost::shared_ptr<BondHelper> > result(helpers.size());
    for (Size i=0; i<helpers.size(); ++i)
        result[i] = boost::dynamic_pointer_cast<BondHelper>(helpers[i]);
    return result;
}


using QuantLib::ExponentialSplinesFitting;
using QuantLib::NelsonSiegelFitting;
using QuantLib::SvenssonFitting;
using QuantLib::CubicBSplinesFitting;
using QuantLib::SimplePolynomialFitting;


using QuantLib::InterpolatedForwardCurve;


using QuantLib::Forward;


using QuantLib::FixedRateBondForward;
using QuantLib::FixedRateBond;
using QuantLib::BusinessDayConvention;
using QuantLib::Position;


using QuantLib::Position;
using QuantLib::ForwardRateAgreement;


using QuantLib::Gaussian1dModel;


using QuantLib::Gsr;
using QuantLib::MarkovFunctional;


using QuantLib::Gaussian1dSwaptionEngine;
using QuantLib::Gaussian1dJamshidianSwaptionEngine;
using QuantLib::Gaussian1dNonstandardSwaptionEngine;
using QuantLib::Gaussian1dFloatFloatSwaptionEngine;


using QuantLib::SegmentIntegral;
using QuantLib::TrapezoidIntegral;
using QuantLib::Default;
using QuantLib::MidPoint;
using QuantLib::SimpsonIntegral;
using QuantLib::GaussKronrodAdaptive;
using QuantLib::GaussKronrodNonAdaptive;
using QuantLib::GaussLobattoIntegral;
using QuantLib::GaussLaguerreIntegration;
using QuantLib::GaussHermiteIntegration;
using QuantLib::GaussJacobiIntegration;
using QuantLib::GaussHyperbolicIntegration;
using QuantLib::GaussLegendreIntegration;
using QuantLib::GaussChebyshevIntegration;
using QuantLib::GaussChebyshev2ndIntegration;
using QuantLib::GaussGegenbauerIntegration;


using QuantLib::Sample;

using QuantLib::LecuyerUniformRng;
using QuantLib::KnuthUniformRng;
using QuantLib::MersenneTwisterUniformRng;

typedef QuantLib::PseudoRandom::urng_type UniformRandomGenerator;

using QuantLib::CLGaussianRng;
using QuantLib::BoxMullerGaussianRng;
using QuantLib::InverseCumulativeRng;

typedef QuantLib::PseudoRandom::rng_type GaussianRandomGenerator;

using QuantLib::RandomSequenceGenerator;

typedef QuantLib::PseudoRandom::ursg_type UniformRandomSequenceGenerator;
using QuantLib::SobolBrownianGenerator;

using QuantLib::HaltonRsg;
using QuantLib::SobolRsg;
using QuantLib::SobolBrownianBridgeRsg;

typedef QuantLib::LowDiscrepancy::ursg_type
    UniformLowDiscrepancySequenceGenerator;

using QuantLib::InverseCumulativeRsg;

typedef QuantLib::PseudoRandom::rsg_type GaussianRandomSequenceGenerator;
typedef QuantLib::LowDiscrepancy::rsg_type
    GaussianLowDiscrepancySequenceGenerator;

SWIGINTERN double Sample_Sl_Real_Sg__value(Sample< Real > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_Real_Sg__weight(Sample< Real > *self){ return self->weight; }
SWIGINTERN Array Sample_Sl_Array_Sg__value(Sample< Array > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_Array_Sg__weight(Sample< Array > *self){ return self->weight; }
SWIGINTERN std::vector< double > Sample_Sl_std_vector_Sl_Real_Sg__Sg__value(Sample< std::vector< Real > > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_std_vector_Sl_Real_Sg__Sg__weight(Sample< std::vector< Real > > *self){ return self->weight; }
SWIGINTERN Real UniformRandomGenerator_nextValue(UniformRandomGenerator const *self){
			return (*self).next().value;
		}
SWIGINTERN Real GaussianRandomGenerator_nextValue(GaussianRandomGenerator const *self){
			return (*self).next().value;
		}
SWIGINTERN std::vector< unsigned int > SobolRsg_nextInt32Sequence(SobolRsg *self){
        const std::vector<boost::uint_least32_t> &tmp = self->nextInt32Sequence();
        std::vector<unsigned int> outp(tmp.size());
        std::copy(tmp.begin(),tmp.end(),outp.begin());
        return outp;
      }

Matrix getCovariance(const Array& volatilities, const Matrix& correlations) {
    return QuantLib::getCovariance(volatilities.begin(),
                                   volatilities.end(),
                                   correlations);
}


using QuantLib::Path;

SWIGINTERN Path Sample_Sl_Path_Sg__value(Sample< Path > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_Path_Sg__weight(Sample< Path > *self){ return self->weight; }

using QuantLib::PathGenerator;


using QuantLib::MultiPath;


typedef QuantLib::MultiPathGenerator<GaussianRandomSequenceGenerator>
    GaussianMultiPathGenerator;

SWIGINTERN MultiPath Sample_Sl_MultiPath_Sg__value(Sample< MultiPath > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_MultiPath_Sg__weight(Sample< MultiPath > *self){ return self->weight; }
SWIGINTERN GaussianMultiPathGenerator *new_GaussianMultiPathGenerator__SWIG_0(boost::shared_ptr< StochasticProcess > const &process,std::vector< Time > const &times,GaussianRandomSequenceGenerator const &generator,bool brownianBridge=false){
          return new GaussianMultiPathGenerator(process,
                                                QuantLib::TimeGrid(
                                                    times.begin(),
                                                    times.end()),
                                                generator,
                                                brownianBridge);
      }

using QuantLib::BrownianBridge;

SWIGINTERN std::vector< Real > BrownianBridge_transform(BrownianBridge *self,std::vector< Real > const &input){
      std::vector<Real> outp(input.size());
      self->transform(input.begin(),input.end(),outp.begin());
      return outp;
    }
SWIGINTERN std::vector< unsigned int > BrownianBridge_bridgeIndex(BrownianBridge const *self){
    	const std::vector<Size> &tmp = self->bridgeIndex();
    	std::vector<unsigned int> outp(tmp.size());
    	std::copy(tmp.begin(), tmp.end(), outp.begin());
    	return outp;
    }
SWIGINTERN std::vector< unsigned int > BrownianBridge_leftIndex(BrownianBridge const *self){
    	const std::vector<Size> &tmp = self->leftIndex();
    	std::vector<unsigned int> outp(tmp.size());
    	std::copy(tmp.begin(), tmp.end(), outp.begin());
    	return outp;
    }
SWIGINTERN std::vector< unsigned int > BrownianBridge_rightIndex(BrownianBridge const *self){
    	const std::vector<Size> &tmp = self->rightIndex();
    	std::vector<unsigned int> outp(tmp.size());
    	std::copy(tmp.begin(), tmp.end(), outp.begin());
    	return outp;
    }

typedef QuantLib::BoundaryCondition<QuantLib::TridiagonalOperator>
        DefaultBoundaryCondition;


using QuantLib::NeumannBC;
using QuantLib::DirichletBC;


using QuantLib::TridiagonalOperator;


using QuantLib::DPlus;
using QuantLib::DMinus;
using QuantLib::DZero;
using QuantLib::DPlusDMinus;


using QuantLib::Discount;
using QuantLib::ZeroYield;
using QuantLib::ForwardRate;


using QuantLib::PiecewiseYieldCurve;


typedef PiecewiseYieldCurve<ForwardRate, BackwardFlat> PiecewiseFlatForward;


typedef PiecewiseYieldCurve<Discount, LogLinear> PiecewiseLogLinearDiscount;


typedef PiecewiseYieldCurve<ForwardRate, Linear> PiecewiseLinearForward;


typedef PiecewiseYieldCurve<ZeroYield, Linear> PiecewiseLinearZero;


typedef PiecewiseYieldCurve<ZeroYield, Cubic> PiecewiseCubicZero;


typedef PiecewiseYieldCurve<Discount, MonotonicLogCubic> PiecewiseLogCubicDiscount;


using QuantLib::Settings;

SWIGINTERN Date Settings_getEvaluationDate(Settings *self){
            return self->evaluationDate();
        }
SWIGINTERN void Settings_setEvaluationDate(Settings *self,Date const &d){
            self->evaluationDate() = d;
        }
SWIGINTERN void Settings_includeReferenceDateEvents(Settings *self,bool b){
            self->includeReferenceDateEvents() = b;
        }
SWIGINTERN void Settings_includeTodaysCashFlows(Settings *self,bool b){
            self->includeTodaysCashFlows() = b;
        }

using QuantLib::HestonSLVProcess;


using QuantLib::HestonSLVMCModel;
using QuantLib::BrownianGeneratorFactory;
using QuantLib::MTBrownianGeneratorFactory;
using QuantLib::SobolBrownianGeneratorFactory;

SWIGINTERN HestonSLVMCModel *new_HestonSLVMCModel__SWIG_0(boost::shared_ptr< LocalVolTermStructure > const &localVol,boost::shared_ptr< HestonModel > const &model,boost::shared_ptr< BrownianGeneratorFactory > const &brownianGeneratorFactory,Date const &endDate,Size timeStepsPerYear=365,Size nBins=201,Size calibrationPaths=(1 << 15),std::vector< Date > const &mandatoryDates=std::vector< Date >()){
            return new HestonSLVMCModel(
                Handle<LocalVolTermStructure>(localVol), Handle<HestonModel>(model),
                brownianGeneratorFactory, endDate, timeStepsPerYear,
                nBins, calibrationPaths, mandatoryDates);
        }

using QuantLib::FdmSquareRootFwdOp;
using QuantLib::FdmHestonGreensFct;
using QuantLib::HestonSLVFDMModel;
using QuantLib::HestonSLVFokkerPlanckFdmParams;

SWIGINTERN HestonSLVFokkerPlanckFdmParams *new_HestonSLVFokkerPlanckFdmParams(Size xGrid,Size vGrid,Size tMaxStepsPerYear,Size tMinStepsPerYear,Real tStepNumberDecay,Size nRannacherTimeSteps,Size predictionCorretionSteps,Real x0Density,Real localVolEpsProb,Size maxIntegrationIterations,Real vLowerEps,Real vUpperEps,Real vMin,Real v0Density,Real vLowerBoundDensity,Real vUpperBoundDensity,Real leverageFctPropEps,FdmHestonGreensFct::Algorithm greensAlgorithm,FdmSquareRootFwdOp::TransformationType trafoType,FdmSchemeDesc schemeDesc){
            
                const HestonSLVFokkerPlanckFdmParams params = {
                    xGrid, vGrid,
                    tMaxStepsPerYear, tMinStepsPerYear,
                    tStepNumberDecay,
                    nRannacherTimeSteps,
                    predictionCorretionSteps,
                    x0Density,
                    localVolEpsProb,
                    maxIntegrationIterations,
                    vLowerEps, vUpperEps, vMin,
                    v0Density, vLowerBoundDensity, vUpperBoundDensity,
                    leverageFctPropEps,
                    greensAlgorithm,
                    trafoType,
                    schemeDesc };

                return new HestonSLVFokkerPlanckFdmParams(params);
        }
SWIGINTERN HestonSLVFDMModel *new_HestonSLVFDMModel__SWIG_0(boost::shared_ptr< LocalVolTermStructure > const &localVol,boost::shared_ptr< HestonModel > const &model,Date const &endDate,HestonSLVFokkerPlanckFdmParams const &params,bool const logging=false,std::vector< Date > const &mandatoryDates=std::vector< Date >()){
            return new HestonSLVFDMModel(
                Handle<LocalVolTermStructure>(localVol), Handle<HestonModel>(model),
                endDate, params, logging, mandatoryDates);
        }

using QuantLib::FdHestonBarrierEngine;
using QuantLib::FdHestonDoubleBarrierEngine;


using QuantLib::Statistics;
using QuantLib::IncrementalStatistics;
using QuantLib::RiskStatistics;
using QuantLib::GenericSequenceStatistics;

SWIGINTERN void Statistics_add__SWIG_2(Statistics *self,std::vector< Real > const &values){
            self->addSequence(values.begin(), values.end());
        }
SWIGINTERN void Statistics_add__SWIG_3(Statistics *self,std::vector< Real > const &values,std::vector< Real > const &weights){
            self->addSequence(values.begin(), values.end(), weights.begin());
        }
SWIGINTERN void IncrementalStatistics_add__SWIG_2(IncrementalStatistics *self,std::vector< Real > const &values){
            self->addSequence(values.begin(), values.end());
        }
SWIGINTERN void IncrementalStatistics_add__SWIG_3(IncrementalStatistics *self,std::vector< Real > const &values,std::vector< Real > const &weights){
            self->addSequence(values.begin(), values.end(), weights.begin());
        }

using QuantLib::CapFloorTermVolatilityStructure;

SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_CapFloorTermVolatilityStructure_Sg__asObservable(Handle< CapFloorTermVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN void RelinkableHandle_Sl_CapFloorTermVolatilityStructure_Sg__reset(RelinkableHandle< CapFloorTermVolatilityStructure > *self){
            self->linkTo(boost::shared_ptr<CapFloorTermVolatilityStructure>());
        }

using QuantLib::CapFloorTermVolCurve;


using QuantLib::CapFloorTermVolSurface;


using QuantLib::StrippedOptionletBase;
using QuantLib::VolatilityType;


using QuantLib::OptionletStripper1;


using QuantLib::StrippedOptionletAdapter;


using QuantLib::Actual365Fixed;
using QuantLib::Swaption;
using QuantLib::NonstandardSwaption;
using QuantLib::Settlement;
using QuantLib::FloatFloatSwaption;

SWIGINTERN Real Swaption_vega(Swaption *self){
            return self->result<Real>("vega");
        }

using QuantLib::BasketGeneratingEngine;

SWIGINTERN std::vector< boost::shared_ptr< BlackCalibrationHelper > > NonstandardSwaption_calibrationBasket(NonstandardSwaption *self,boost::shared_ptr< SwapIndex > swapIndex,boost::shared_ptr< SwaptionVolatilityStructure > swaptionVolatility,std::string typeStr){

            BasketGeneratingEngine::CalibrationBasketType type;
            if(typeStr == "Naive")
                type = BasketGeneratingEngine::Naive;
            else if(typeStr == "MaturityStrikeByDeltaGamma")
                type = BasketGeneratingEngine::MaturityStrikeByDeltaGamma;
            else
                QL_FAIL("type " << typeStr << "unknown.");

            std::vector<boost::shared_ptr<BlackCalibrationHelper> > hs =
                self->calibrationBasket(swapIndex, swaptionVolatility, type);
            std::vector<boost::shared_ptr<BlackCalibrationHelper> > helpers(hs.size());
            for (Size i=0; i<hs.size(); ++i)
                helpers[i] = hs[i];
            return helpers;
        }
SWIGINTERN std::vector< Real > NonstandardSwaption_probabilities(NonstandardSwaption *self){
            return self->result<std::vector<Real> >("probabilities");
        }
SWIGINTERN std::vector< boost::shared_ptr< BlackCalibrationHelper > > FloatFloatSwaption_calibrationBasket(FloatFloatSwaption *self,boost::shared_ptr< SwapIndex > swapIndex,boost::shared_ptr< SwaptionVolatilityStructure > swaptionVolatility,std::string typeStr){

        BasketGeneratingEngine::CalibrationBasketType type;
        if(typeStr == "Naive")
            type = BasketGeneratingEngine::Naive;
        else if(typeStr == "MaturityStrikeByDeltaGamma")
            type = BasketGeneratingEngine::MaturityStrikeByDeltaGamma;
        else
            QL_FAIL("type " << typeStr << "unknown.");

        std::vector<boost::shared_ptr<BlackCalibrationHelper> > hs =
            self->calibrationBasket(swapIndex, swaptionVolatility, type);
        std::vector<boost::shared_ptr<BlackCalibrationHelper> > helpers(hs.size());
        for (Size i=0; i<hs.size(); ++i)
            helpers[i] = hs[i];
        return helpers;
        }
SWIGINTERN Real FloatFloatSwaption_underlyingValue(FloatFloatSwaption *self){
            return self->result<Real>("underlyingValue");
        }
SWIGINTERN std::vector< Real > FloatFloatSwaption_probabilities(FloatFloatSwaption *self){
            return self->result<std::vector<Real> >("probabilities");
        }

using QuantLib::BlackSwaptionEngine;
using QuantLib::BachelierSwaptionEngine;



void enableTracing() { 
    QL_TRACE_ENABLE;
}

void disableTracing() {
    QL_TRACE_DISABLE;
}



using QuantLib::ConstantEstimator;
using QuantLib::SimpleLocalEstimator;
using QuantLib::GarmanKlassSigma1;
using QuantLib::ParkinsonSigma;
using QuantLib::GarmanKlassSigma3;
using QuantLib::GarmanKlassSigma4;
using QuantLib::GarmanKlassSigma5;
using QuantLib::GarmanKlassSigma6;


using QuantLib::InterpolatedZeroCurve;



/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "quantlib_wrap.h"

SwigDirector_UnaryFunctionDelegate::SwigDirector_UnaryFunctionDelegate() : UnaryFunctionDelegate(), Swig::Director() {
  swig_init_callbacks();
}

SwigDirector_UnaryFunctionDelegate::~SwigDirector_UnaryFunctionDelegate() {
  
}


Real SwigDirector_UnaryFunctionDelegate::value(Real x) const {
  Real c_result = SwigValueInit< Real >() ;
  double jresult = 0 ;
  double jx  ;
  
  if (!swig_callbackvalue) {
    return UnaryFunctionDelegate::value(x);
  } else {
    jx = x;
    jresult = (double) swig_callbackvalue(jx);
    c_result = (Real)jresult; 
  }
  return c_result;
}

void SwigDirector_UnaryFunctionDelegate::swig_connect_director(SWIG_Callback0_t callbackvalue) {
  swig_callbackvalue = callbackvalue;
}

void SwigDirector_UnaryFunctionDelegate::swig_init_callbacks() {
  swig_callbackvalue = 0;
}

SwigDirector_CostFunctionDelegate::SwigDirector_CostFunctionDelegate() : CostFunctionDelegate(), Swig::Director() {
  swig_init_callbacks();
}

SwigDirector_CostFunctionDelegate::~SwigDirector_CostFunctionDelegate() {
  
}


Real SwigDirector_CostFunctionDelegate::value(Array const &x) const {
  Real c_result = SwigValueInit< Real >() ;
  double jresult = 0 ;
  void * jx = 0 ;
  
  if (!swig_callbackvalue) {
    return CostFunctionDelegate::value(x);
  } else {
    jx = (Array *) &x; 
    jresult = (double) swig_callbackvalue(jx);
    c_result = (Real)jresult; 
  }
  return c_result;
}

Array SwigDirector_CostFunctionDelegate::values(Array const &x) const {
  Array c_result ;
  void * jresult = 0 ;
  void * jx = 0 ;
  
  if (!swig_callbackvalues) {
    return CostFunctionDelegate::values(x);
  } else {
    jx = (Array *) &x; 
    jresult = (void *) swig_callbackvalues(jx);
    if (!jresult) {
      SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Unexpected null return for type Array", 0);
      return c_result;
    }
    c_result = *(Array *)jresult; 
  }
  return c_result;
}

void SwigDirector_CostFunctionDelegate::swig_connect_director(SWIG_Callback0_t callbackvalue, SWIG_Callback1_t callbackvalues) {
  swig_callbackvalue = callbackvalue;
  swig_callbackvalues = callbackvalues;
}

void SwigDirector_CostFunctionDelegate::swig_init_callbacks() {
  swig_callbackvalue = 0;
  swig_callbackvalues = 0;
}


#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Period__SWIG_0() {
  void * jresult ;
  Period *result = 0 ;
  
  {
    try {
      result = (Period *)new Period();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Period__SWIG_1(int jarg1, int jarg2) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Period *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  {
    try {
      result = (Period *)new Period(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Period__SWIG_2(int jarg1) {
  void * jresult ;
  Frequency arg1 ;
  Period *result = 0 ;
  
  arg1 = (Frequency)jarg1; 
  {
    try {
      result = (Period *)new Period(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_Period_length(void * jarg1) {
  int jresult ;
  Period *arg1 = (Period *) 0 ;
  Integer result;
  
  arg1 = (Period *)jarg1; 
  {
    try {
      result = (Integer)((Period const *)arg1)->length();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_Period_units(void * jarg1) {
  int jresult ;
  Period *arg1 = (Period *) 0 ;
  TimeUnit result;
  
  arg1 = (Period *)jarg1; 
  {
    try {
      result = (TimeUnit)((Period const *)arg1)->units();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (int)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_Period_frequency(void * jarg1) {
  int jresult ;
  Period *arg1 = (Period *) 0 ;
  Frequency result;
  
  arg1 = (Period *)jarg1; 
  {
    try {
      result = (Frequency)((Period const *)arg1)->frequency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (int)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Period__SWIG_3(char * jarg1) {
  void * jresult ;
  std::string *arg1 = 0 ;
  Period *result = 0 ;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  {
    try {
      result = (Period *)new_Period__SWIG_3((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_Period___str__(void * jarg1) {
  char * jresult ;
  Period *arg1 = (Period *) 0 ;
  std::string result;
  
  arg1 = (Period *)jarg1; 
  {
    try {
      result = Period___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_Period___repr__(void * jarg1) {
  char * jresult ;
  Period *arg1 = (Period *) 0 ;
  std::string result;
  
  arg1 = (Period *)jarg1; 
  {
    try {
      result = Period___repr__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Period(void * jarg1) {
  Period *arg1 = (Period *) 0 ;
  
  arg1 = (Period *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_PeriodVector_Clear(void * jarg1) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  
  arg1 = (std::vector< Period > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_PeriodVector_Add(void * jarg1, void * jarg2) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  Period *arg2 = 0 ;
  
  arg1 = (std::vector< Period > *)jarg1; 
  arg2 = (Period *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Period const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->push_back((Period const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_PeriodVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  std::vector< Period >::size_type result;
  
  arg1 = (std::vector< Period > *)jarg1; 
  {
    try {
      result = ((std::vector< Period > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_PeriodVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  std::vector< Period >::size_type result;
  
  arg1 = (std::vector< Period > *)jarg1; 
  {
    try {
      result = ((std::vector< Period > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_PeriodVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  std::vector< Period >::size_type arg2 ;
  
  arg1 = (std::vector< Period > *)jarg1; 
  arg2 = (std::vector< Period >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_PeriodVector__SWIG_0() {
  void * jresult ;
  std::vector< Period > *result = 0 ;
  
  {
    try {
      result = (std::vector< Period > *)new std::vector< Period >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_PeriodVector__SWIG_1(void * jarg1) {
  void * jresult ;
  std::vector< Period > *arg1 = 0 ;
  std::vector< Period > *result = 0 ;
  
  arg1 = (std::vector< Period > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< Period > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (std::vector< Period > *)new std::vector< Period >((std::vector< Period > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_PeriodVector__SWIG_2(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector< Period > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector< Period > *)new_std_vector_Sl_Period_Sg___SWIG_2(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_PeriodVector_getitemcopy(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  int arg2 ;
  Period result;
  
  arg1 = (std::vector< Period > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_Period_Sg__getitemcopy(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Period((const Period &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_PeriodVector_getitem(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  int arg2 ;
  std::vector< Period >::value_type *result = 0 ;
  
  arg1 = (std::vector< Period > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< Period >::value_type *) &std_vector_Sl_Period_Sg__getitem(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_PeriodVector_setitem(void * jarg1, int jarg2, void * jarg3) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  int arg2 ;
  Period *arg3 = 0 ;
  
  arg1 = (std::vector< Period > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (Period *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Period const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Period_Sg__setitem(arg1,arg2,(Period const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_PeriodVector_AddRange(void * jarg1, void * jarg2) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  std::vector< Period > *arg2 = 0 ;
  
  arg1 = (std::vector< Period > *)jarg1; 
  arg2 = (std::vector< Period > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< Period > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_Period_Sg__AddRange(arg1,(std::vector< Period > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_PeriodVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector< Period > *result = 0 ;
  
  arg1 = (std::vector< Period > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector< Period > *)std_vector_Sl_Period_Sg__GetRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_PeriodVector_Insert(void * jarg1, int jarg2, void * jarg3) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  int arg2 ;
  Period *arg3 = 0 ;
  
  arg1 = (std::vector< Period > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (Period *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Period const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Period_Sg__Insert(arg1,arg2,(Period const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_PeriodVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  int arg2 ;
  std::vector< Period > *arg3 = 0 ;
  
  arg1 = (std::vector< Period > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< Period > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< Period > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Period_Sg__InsertRange(arg1,arg2,(std::vector< Period > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_PeriodVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector< Period > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_Period_Sg__RemoveAt(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_PeriodVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< Period > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_Period_Sg__RemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_PeriodVector_Repeat(void * jarg1, int jarg2) {
  void * jresult ;
  Period *arg1 = 0 ;
  int arg2 ;
  std::vector< Period > *result = 0 ;
  
  arg1 = (Period *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Period const & type is null", 0);
    return 0;
  } 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< Period > *)std_vector_Sl_Period_Sg__Repeat((Period const &)*arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_PeriodVector_Reverse__SWIG_0(void * jarg1) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  
  arg1 = (std::vector< Period > *)jarg1; 
  {
    try {
      std_vector_Sl_Period_Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_PeriodVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< Period > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_Period_Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_PeriodVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  int arg2 ;
  std::vector< Period > *arg3 = 0 ;
  
  arg1 = (std::vector< Period > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< Period > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< Period > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Period_Sg__SetRange(arg1,arg2,(std::vector< Period > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_PeriodVector(void * jarg1) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  
  arg1 = (std::vector< Period > *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Date__SWIG_0() {
  void * jresult ;
  Date *result = 0 ;
  
  {
    try {
      result = (Date *)new Date();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Date__SWIG_1(int jarg1, int jarg2, int jarg3) {
  void * jresult ;
  Day arg1 ;
  Month arg2 ;
  Year arg3 ;
  Date *result = 0 ;
  
  arg1 = (Day)jarg1; 
  arg2 = (Month)jarg2; 
  arg3 = (Year)jarg3; 
  {
    try {
      result = (Date *)new Date(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Date__SWIG_2(int jarg1, int jarg2, int jarg3, int jarg4, int jarg5, int jarg6, int jarg7, int jarg8) {
  void * jresult ;
  Day arg1 ;
  Month arg2 ;
  Year arg3 ;
  Hour arg4 ;
  Minute arg5 ;
  Second arg6 ;
  Millisecond arg7 ;
  Microsecond arg8 ;
  Date *result = 0 ;
  
  arg1 = (Day)jarg1; 
  arg2 = (Month)jarg2; 
  arg3 = (Year)jarg3; 
  arg4 = (Hour)jarg4; 
  arg5 = (Minute)jarg5; 
  arg6 = (Second)jarg6; 
  arg7 = (Millisecond)jarg7; 
  arg8 = (Microsecond)jarg8; 
  {
    try {
      result = (Date *)new_Date__SWIG_2(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Date__SWIG_3(int jarg1, int jarg2, int jarg3, int jarg4, int jarg5, int jarg6, int jarg7) {
  void * jresult ;
  Day arg1 ;
  Month arg2 ;
  Year arg3 ;
  Hour arg4 ;
  Minute arg5 ;
  Second arg6 ;
  Millisecond arg7 ;
  Date *result = 0 ;
  
  arg1 = (Day)jarg1; 
  arg2 = (Month)jarg2; 
  arg3 = (Year)jarg3; 
  arg4 = (Hour)jarg4; 
  arg5 = (Minute)jarg5; 
  arg6 = (Second)jarg6; 
  arg7 = (Millisecond)jarg7; 
  {
    try {
      result = (Date *)new_Date__SWIG_2(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Date__SWIG_4(int jarg1, int jarg2, int jarg3, int jarg4, int jarg5, int jarg6) {
  void * jresult ;
  Day arg1 ;
  Month arg2 ;
  Year arg3 ;
  Hour arg4 ;
  Minute arg5 ;
  Second arg6 ;
  Date *result = 0 ;
  
  arg1 = (Day)jarg1; 
  arg2 = (Month)jarg2; 
  arg3 = (Year)jarg3; 
  arg4 = (Hour)jarg4; 
  arg5 = (Minute)jarg5; 
  arg6 = (Second)jarg6; 
  {
    try {
      result = (Date *)new_Date__SWIG_2(arg1,arg2,arg3,arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Date__SWIG_5(long jarg1) {
  void * jresult ;
  BigInteger arg1 ;
  Date *result = 0 ;
  
  arg1 = (BigInteger)jarg1; 
  {
    try {
      result = (Date *)new Date(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_Date_weekday(void * jarg1) {
  int jresult ;
  Date *arg1 = (Date *) 0 ;
  Weekday result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (Weekday)((Date const *)arg1)->weekday();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (int)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_Date_dayOfMonth(void * jarg1) {
  int jresult ;
  Date *arg1 = (Date *) 0 ;
  Day result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (Day)((Date const *)arg1)->dayOfMonth();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_Date_dayOfYear(void * jarg1) {
  int jresult ;
  Date *arg1 = (Date *) 0 ;
  Day result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (Day)((Date const *)arg1)->dayOfYear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_Date_month(void * jarg1) {
  int jresult ;
  Date *arg1 = (Date *) 0 ;
  Month result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (Month)((Date const *)arg1)->month();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (int)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_Date_year(void * jarg1) {
  int jresult ;
  Date *arg1 = (Date *) 0 ;
  Year result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (Year)((Date const *)arg1)->year();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_Date_hours(void * jarg1) {
  int jresult ;
  Date *arg1 = (Date *) 0 ;
  Hour result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (Hour)Date_hours(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_Date_minutes(void * jarg1) {
  int jresult ;
  Date *arg1 = (Date *) 0 ;
  Minute result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (Minute)Date_minutes(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_Date_seconds(void * jarg1) {
  int jresult ;
  Date *arg1 = (Date *) 0 ;
  Second result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (Second)Date_seconds(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_Date_milliseconds(void * jarg1) {
  int jresult ;
  Date *arg1 = (Date *) 0 ;
  Millisecond result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (Millisecond)Date_milliseconds(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_Date_microseconds(void * jarg1) {
  int jresult ;
  Date *arg1 = (Date *) 0 ;
  Microsecond result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (Microsecond)Date_microseconds(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_Date_fractionOfDay(void * jarg1) {
  double jresult ;
  Date *arg1 = (Date *) 0 ;
  Time result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (Time)Date_fractionOfDay((Date const *)arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_Date_fractionOfSecond(void * jarg1) {
  double jresult ;
  Date *arg1 = (Date *) 0 ;
  Time result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (Time)Date_fractionOfSecond((Date const *)arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT long SWIGSTDCALL CSharp_QuantLib_Date_serialNumber(void * jarg1) {
  long jresult ;
  Date *arg1 = (Date *) 0 ;
  BigInteger result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (BigInteger)((Date const *)arg1)->serialNumber();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_Date_isLeap(int jarg1) {
  unsigned int jresult ;
  Year arg1 ;
  bool result;
  
  arg1 = (Year)jarg1; 
  {
    try {
      result = (bool)Date::isLeap(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Date_minDate() {
  void * jresult ;
  Date result;
  
  {
    try {
      result = Date::minDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Date_maxDate() {
  void * jresult ;
  Date result;
  
  {
    try {
      result = Date::maxDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Date_todaysDate() {
  void * jresult ;
  Date result;
  
  {
    try {
      result = Date::todaysDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Date_localDateTime() {
  void * jresult ;
  Date result;
  
  {
    try {
      result = Date_localDateTime();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Date_universalDateTime() {
  void * jresult ;
  Date result;
  
  {
    try {
      result = Date_universalDateTime();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Date_endOfMonth(void * jarg1) {
  void * jresult ;
  Date *arg1 = 0 ;
  Date result;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = Date::endOfMonth((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_Date_isEndOfMonth(void * jarg1) {
  unsigned int jresult ;
  Date *arg1 = 0 ;
  bool result;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (bool)Date::isEndOfMonth((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Date_nextWeekday(void * jarg1, int jarg2) {
  void * jresult ;
  Date *arg1 = 0 ;
  Weekday arg2 ;
  Date result;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg2 = (Weekday)jarg2; 
  {
    try {
      result = Date::nextWeekday((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Date_nthWeekday(unsigned long jarg1, int jarg2, int jarg3, int jarg4) {
  void * jresult ;
  Size arg1 ;
  Weekday arg2 ;
  Month arg3 ;
  Year arg4 ;
  Date result;
  
  arg1 = (Size)jarg1; 
  arg2 = (Weekday)jarg2; 
  arg3 = (Month)jarg3; 
  arg4 = (Year)jarg4; 
  {
    try {
      result = Date::nthWeekday(arg1,arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Date_Add__SWIG_0(void * jarg1, long jarg2) {
  void * jresult ;
  Date *arg1 = (Date *) 0 ;
  BigInteger arg2 ;
  Date result;
  
  arg1 = (Date *)jarg1; 
  arg2 = (BigInteger)jarg2; 
  {
    try {
      result = ((Date const *)arg1)->operator +(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Date_Subtract__SWIG_0(void * jarg1, long jarg2) {
  void * jresult ;
  Date *arg1 = (Date *) 0 ;
  BigInteger arg2 ;
  Date result;
  
  arg1 = (Date *)jarg1; 
  arg2 = (BigInteger)jarg2; 
  {
    try {
      result = ((Date const *)arg1)->operator -(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Date_Add__SWIG_1(void * jarg1, void * jarg2) {
  void * jresult ;
  Date *arg1 = (Date *) 0 ;
  Period *arg2 = 0 ;
  Date result;
  
  arg1 = (Date *)jarg1; 
  arg2 = (Period *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Period const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = ((Date const *)arg1)->operator +((Period const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Date_Subtract__SWIG_1(void * jarg1, void * jarg2) {
  void * jresult ;
  Date *arg1 = (Date *) 0 ;
  Period *arg2 = 0 ;
  Date result;
  
  arg1 = (Date *)jarg1; 
  arg2 = (Period *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Period const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = ((Date const *)arg1)->operator -((Period const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Date__SWIG_6(char * jarg1, char * jarg2) {
  void * jresult ;
  std::string *arg1 = 0 ;
  std::string arg2 ;
  Date *result = 0 ;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  if (!jarg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  (&arg2)->assign(jarg2); 
  {
    try {
      result = (Date *)new_Date__SWIG_6((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_Date_weekdayNumber(void * jarg1) {
  int jresult ;
  Date *arg1 = (Date *) 0 ;
  Integer result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (Integer)Date_weekdayNumber(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_Date___str__(void * jarg1) {
  char * jresult ;
  Date *arg1 = (Date *) 0 ;
  std::string result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = Date___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_Date___repr__(void * jarg1) {
  char * jresult ;
  Date *arg1 = (Date *) 0 ;
  std::string result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = Date___repr__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_Date_ISO(void * jarg1) {
  char * jresult ;
  Date *arg1 = (Date *) 0 ;
  std::string result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = Date_ISO(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Date(void * jarg1) {
  Date *arg1 = (Date *) 0 ;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_DateParser_parseFormatted(char * jarg1, char * jarg2) {
  void * jresult ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  Date result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  if (!jarg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg2_str(jarg2);
  arg2 = &arg2_str; 
  {
    try {
      result = DateParser::parseFormatted((std::string const &)*arg1,(std::string const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_DateParser_parseISO(char * jarg1) {
  void * jresult ;
  std::string *arg1 = 0 ;
  Date result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  {
    try {
      result = DateParser::parseISO((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_DateParser_parse(char * jarg1, char * jarg2) {
  void * jresult ;
  std::string *arg1 = 0 ;
  std::string arg2 ;
  Date result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  if (!jarg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  (&arg2)->assign(jarg2); 
  {
    try {
      result = DateParser_parse((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_DateParser() {
  void * jresult ;
  DateParser *result = 0 ;
  
  {
    try {
      result = (DateParser *)new DateParser();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_DateParser(void * jarg1) {
  DateParser *arg1 = (DateParser *) 0 ;
  
  arg1 = (DateParser *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_PeriodParser_parse(char * jarg1) {
  void * jresult ;
  std::string *arg1 = 0 ;
  Period result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  {
    try {
      result = PeriodParser::parse((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Period((const Period &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_PeriodParser() {
  void * jresult ;
  PeriodParser *result = 0 ;
  
  {
    try {
      result = (PeriodParser *)new PeriodParser();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_PeriodParser(void * jarg1) {
  PeriodParser *arg1 = (PeriodParser *) 0 ;
  
  arg1 = (PeriodParser *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DateVector_Clear(void * jarg1) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  
  arg1 = (std::vector< Date > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DateVector_Add(void * jarg1, void * jarg2) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  Date *arg2 = 0 ;
  
  arg1 = (std::vector< Date > *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->push_back((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_DateVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  std::vector< Date >::size_type result;
  
  arg1 = (std::vector< Date > *)jarg1; 
  {
    try {
      result = ((std::vector< Date > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_DateVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  std::vector< Date >::size_type result;
  
  arg1 = (std::vector< Date > *)jarg1; 
  {
    try {
      result = ((std::vector< Date > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DateVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  std::vector< Date >::size_type arg2 ;
  
  arg1 = (std::vector< Date > *)jarg1; 
  arg2 = (std::vector< Date >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_DateVector__SWIG_0() {
  void * jresult ;
  std::vector< Date > *result = 0 ;
  
  {
    try {
      result = (std::vector< Date > *)new std::vector< Date >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_DateVector__SWIG_1(void * jarg1) {
  void * jresult ;
  std::vector< Date > *arg1 = 0 ;
  std::vector< Date > *result = 0 ;
  
  arg1 = (std::vector< Date > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< Date > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (std::vector< Date > *)new std::vector< Date >((std::vector< Date > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_DateVector__SWIG_2(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector< Date > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector< Date > *)new_std_vector_Sl_Date_Sg___SWIG_2(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_DateVector_getitemcopy(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  int arg2 ;
  Date result;
  
  arg1 = (std::vector< Date > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_Date_Sg__getitemcopy(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_DateVector_getitem(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  int arg2 ;
  std::vector< Date >::value_type *result = 0 ;
  
  arg1 = (std::vector< Date > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< Date >::value_type *) &std_vector_Sl_Date_Sg__getitem(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DateVector_setitem(void * jarg1, int jarg2, void * jarg3) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  int arg2 ;
  Date *arg3 = 0 ;
  
  arg1 = (std::vector< Date > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (Date *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Date_Sg__setitem(arg1,arg2,(Date const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DateVector_AddRange(void * jarg1, void * jarg2) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  std::vector< Date > *arg2 = 0 ;
  
  arg1 = (std::vector< Date > *)jarg1; 
  arg2 = (std::vector< Date > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< Date > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_Date_Sg__AddRange(arg1,(std::vector< Date > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_DateVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector< Date > *result = 0 ;
  
  arg1 = (std::vector< Date > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector< Date > *)std_vector_Sl_Date_Sg__GetRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DateVector_Insert(void * jarg1, int jarg2, void * jarg3) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  int arg2 ;
  Date *arg3 = 0 ;
  
  arg1 = (std::vector< Date > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (Date *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Date_Sg__Insert(arg1,arg2,(Date const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DateVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  int arg2 ;
  std::vector< Date > *arg3 = 0 ;
  
  arg1 = (std::vector< Date > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< Date > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< Date > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Date_Sg__InsertRange(arg1,arg2,(std::vector< Date > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DateVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector< Date > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_Date_Sg__RemoveAt(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DateVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< Date > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_Date_Sg__RemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_DateVector_Repeat(void * jarg1, int jarg2) {
  void * jresult ;
  Date *arg1 = 0 ;
  int arg2 ;
  std::vector< Date > *result = 0 ;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< Date > *)std_vector_Sl_Date_Sg__Repeat((Date const &)*arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DateVector_Reverse__SWIG_0(void * jarg1) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  
  arg1 = (std::vector< Date > *)jarg1; 
  {
    try {
      std_vector_Sl_Date_Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DateVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< Date > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_Date_Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DateVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  int arg2 ;
  std::vector< Date > *arg3 = 0 ;
  
  arg1 = (std::vector< Date > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< Date > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< Date > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Date_Sg__SetRange(arg1,arg2,(std::vector< Date > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_DateVector(void * jarg1) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  
  arg1 = (std::vector< Date > *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_daysBetween(void * jarg1, void * jarg2) {
  double jresult ;
  Date *arg1 = 0 ;
  Date *arg2 = 0 ;
  Time result;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (Time)daysBetween((Date const &)*arg1,(Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_IMM_isIMMdate__SWIG_0(void * jarg1, unsigned int jarg2) {
  unsigned int jresult ;
  Date *arg1 = 0 ;
  bool arg2 ;
  bool result;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (bool)IMM::isIMMdate((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_IMM_isIMMdate__SWIG_1(void * jarg1) {
  unsigned int jresult ;
  Date *arg1 = 0 ;
  bool result;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (bool)IMM::isIMMdate((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_IMM_isIMMcode__SWIG_0(char * jarg1, unsigned int jarg2) {
  unsigned int jresult ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  bool result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (bool)IMM::isIMMcode((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_IMM_isIMMcode__SWIG_1(char * jarg1) {
  unsigned int jresult ;
  std::string *arg1 = 0 ;
  bool result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  {
    try {
      result = (bool)IMM::isIMMcode((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_IMM_code(void * jarg1) {
  char * jresult ;
  Date *arg1 = 0 ;
  std::string result;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = IMM::code((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_IMM_date__SWIG_0(char * jarg1, void * jarg2) {
  void * jresult ;
  std::string *arg1 = 0 ;
  Date *arg2 = 0 ;
  Date result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = IMM::date((std::string const &)*arg1,(Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_IMM_date__SWIG_1(char * jarg1) {
  void * jresult ;
  std::string *arg1 = 0 ;
  Date result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  {
    try {
      result = IMM::date((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_IMM_nextDate__SWIG_0(void * jarg1, unsigned int jarg2) {
  void * jresult ;
  Date *arg1 = 0 ;
  bool arg2 ;
  Date result;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = IMM::nextDate((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_IMM_nextDate__SWIG_1(void * jarg1) {
  void * jresult ;
  Date *arg1 = 0 ;
  Date result;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = IMM::nextDate((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_IMM_nextDate__SWIG_2() {
  void * jresult ;
  Date result;
  
  {
    try {
      result = IMM::nextDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_IMM_nextDate__SWIG_3(char * jarg1, unsigned int jarg2, void * jarg3) {
  void * jresult ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date *arg3 = 0 ;
  Date result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  arg2 = jarg2 ? true : false; 
  arg3 = (Date *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = IMM::nextDate((std::string const &)*arg1,arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_IMM_nextDate__SWIG_4(char * jarg1, unsigned int jarg2) {
  void * jresult ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = IMM::nextDate((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_IMM_nextDate__SWIG_5(char * jarg1) {
  void * jresult ;
  std::string *arg1 = 0 ;
  Date result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  {
    try {
      result = IMM::nextDate((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_IMM_nextCode__SWIG_0(void * jarg1, unsigned int jarg2) {
  char * jresult ;
  Date *arg1 = 0 ;
  bool arg2 ;
  std::string result;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = IMM::nextCode((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_IMM_nextCode__SWIG_1(void * jarg1) {
  char * jresult ;
  Date *arg1 = 0 ;
  std::string result;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = IMM::nextCode((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_IMM_nextCode__SWIG_2() {
  char * jresult ;
  std::string result;
  
  {
    try {
      result = IMM::nextCode();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_IMM_nextCode__SWIG_3(char * jarg1, unsigned int jarg2, void * jarg3) {
  char * jresult ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date *arg3 = 0 ;
  std::string result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  arg2 = jarg2 ? true : false; 
  arg3 = (Date *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = IMM::nextCode((std::string const &)*arg1,arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_IMM_nextCode__SWIG_4(char * jarg1, unsigned int jarg2) {
  char * jresult ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  std::string result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = IMM::nextCode((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_IMM_nextCode__SWIG_5(char * jarg1) {
  char * jresult ;
  std::string *arg1 = 0 ;
  std::string result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  {
    try {
      result = IMM::nextCode((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_IMM() {
  void * jresult ;
  IMM *result = 0 ;
  
  {
    try {
      result = (IMM *)new IMM();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_IMM(void * jarg1) {
  IMM *arg1 = (IMM *) 0 ;
  
  arg1 = (IMM *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_ASX_isASXdate__SWIG_0(void * jarg1, unsigned int jarg2) {
  unsigned int jresult ;
  Date *arg1 = 0 ;
  bool arg2 ;
  bool result;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (bool)ASX::isASXdate((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_ASX_isASXdate__SWIG_1(void * jarg1) {
  unsigned int jresult ;
  Date *arg1 = 0 ;
  bool result;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (bool)ASX::isASXdate((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_ASX_isASXcode__SWIG_0(char * jarg1, unsigned int jarg2) {
  unsigned int jresult ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  bool result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (bool)ASX::isASXcode((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_ASX_isASXcode__SWIG_1(char * jarg1) {
  unsigned int jresult ;
  std::string *arg1 = 0 ;
  bool result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  {
    try {
      result = (bool)ASX::isASXcode((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_ASX_code(void * jarg1) {
  char * jresult ;
  Date *arg1 = 0 ;
  std::string result;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = ASX::code((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_ASX_date__SWIG_0(char * jarg1, void * jarg2) {
  void * jresult ;
  std::string *arg1 = 0 ;
  Date *arg2 = 0 ;
  Date result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = ASX::date((std::string const &)*arg1,(Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_ASX_date__SWIG_1(char * jarg1) {
  void * jresult ;
  std::string *arg1 = 0 ;
  Date result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  {
    try {
      result = ASX::date((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_ASX_nextDate__SWIG_0(void * jarg1, unsigned int jarg2) {
  void * jresult ;
  Date *arg1 = 0 ;
  bool arg2 ;
  Date result;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = ASX::nextDate((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_ASX_nextDate__SWIG_1(void * jarg1) {
  void * jresult ;
  Date *arg1 = 0 ;
  Date result;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = ASX::nextDate((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_ASX_nextDate__SWIG_2() {
  void * jresult ;
  Date result;
  
  {
    try {
      result = ASX::nextDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_ASX_nextDate__SWIG_3(char * jarg1, unsigned int jarg2, void * jarg3) {
  void * jresult ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date *arg3 = 0 ;
  Date result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  arg2 = jarg2 ? true : false; 
  arg3 = (Date *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = ASX::nextDate((std::string const &)*arg1,arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_ASX_nextDate__SWIG_4(char * jarg1, unsigned int jarg2) {
  void * jresult ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = ASX::nextDate((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_ASX_nextDate__SWIG_5(char * jarg1) {
  void * jresult ;
  std::string *arg1 = 0 ;
  Date result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  {
    try {
      result = ASX::nextDate((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_ASX_nextCode__SWIG_0(void * jarg1, unsigned int jarg2) {
  char * jresult ;
  Date *arg1 = 0 ;
  bool arg2 ;
  std::string result;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = ASX::nextCode((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_ASX_nextCode__SWIG_1(void * jarg1) {
  char * jresult ;
  Date *arg1 = 0 ;
  std::string result;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = ASX::nextCode((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_ASX_nextCode__SWIG_2() {
  char * jresult ;
  std::string result;
  
  {
    try {
      result = ASX::nextCode();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_ASX_nextCode__SWIG_3(char * jarg1, unsigned int jarg2, void * jarg3) {
  char * jresult ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date *arg3 = 0 ;
  std::string result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  arg2 = jarg2 ? true : false; 
  arg3 = (Date *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = ASX::nextCode((std::string const &)*arg1,arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_ASX_nextCode__SWIG_4(char * jarg1, unsigned int jarg2) {
  char * jresult ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  std::string result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = ASX::nextCode((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_ASX_nextCode__SWIG_5(char * jarg1) {
  char * jresult ;
  std::string *arg1 = 0 ;
  std::string result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  {
    try {
      result = ASX::nextCode((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_ASX() {
  void * jresult ;
  ASX *result = 0 ;
  
  {
    try {
      result = (ASX *)new ASX();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_ASX(void * jarg1) {
  ASX *arg1 = (ASX *) 0 ;
  
  arg1 = (ASX *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_IntVector_Clear(void * jarg1) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  
  arg1 = (std::vector< int > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_IntVector_Add(void * jarg1, int jarg2) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int *arg2 = 0 ;
  int temp2 ;
  
  arg1 = (std::vector< int > *)jarg1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  {
    try {
      (arg1)->push_back((int const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_IntVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int >::size_type result;
  
  arg1 = (std::vector< int > *)jarg1; 
  {
    try {
      result = ((std::vector< int > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_IntVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int >::size_type result;
  
  arg1 = (std::vector< int > *)jarg1; 
  {
    try {
      result = ((std::vector< int > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_IntVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int >::size_type arg2 ;
  
  arg1 = (std::vector< int > *)jarg1; 
  arg2 = (std::vector< int >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_IntVector__SWIG_0() {
  void * jresult ;
  std::vector< int > *result = 0 ;
  
  {
    try {
      result = (std::vector< int > *)new std::vector< int >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_IntVector__SWIG_1(void * jarg1) {
  void * jresult ;
  std::vector< int > *arg1 = 0 ;
  std::vector< int > *result = 0 ;
  
  arg1 = (std::vector< int > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< int > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (std::vector< int > *)new std::vector< int >((std::vector< int > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_IntVector__SWIG_2(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector< int > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector< int > *)new_std_vector_Sl_int_Sg___SWIG_2(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_IntVector_getitemcopy(void * jarg1, int jarg2) {
  int jresult ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int arg2 ;
  int result;
  
  arg1 = (std::vector< int > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (int)std_vector_Sl_int_Sg__getitemcopy(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_IntVector_getitem(void * jarg1, int jarg2) {
  int jresult ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int arg2 ;
  std::vector< int >::value_type *result = 0 ;
  
  arg1 = (std::vector< int > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< int >::value_type *) &std_vector_Sl_int_Sg__getitem(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = *result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_IntVector_setitem(void * jarg1, int jarg2, int jarg3) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int arg2 ;
  int *arg3 = 0 ;
  int temp3 ;
  
  arg1 = (std::vector< int > *)jarg1; 
  arg2 = (int)jarg2; 
  temp3 = (int)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_int_Sg__setitem(arg1,arg2,(int const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_IntVector_AddRange(void * jarg1, void * jarg2) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int > *arg2 = 0 ;
  
  arg1 = (std::vector< int > *)jarg1; 
  arg2 = (std::vector< int > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< int > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_int_Sg__AddRange(arg1,(std::vector< int > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_IntVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector< int > *result = 0 ;
  
  arg1 = (std::vector< int > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector< int > *)std_vector_Sl_int_Sg__GetRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_IntVector_Insert(void * jarg1, int jarg2, int jarg3) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int arg2 ;
  int *arg3 = 0 ;
  int temp3 ;
  
  arg1 = (std::vector< int > *)jarg1; 
  arg2 = (int)jarg2; 
  temp3 = (int)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_int_Sg__Insert(arg1,arg2,(int const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_IntVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int arg2 ;
  std::vector< int > *arg3 = 0 ;
  
  arg1 = (std::vector< int > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< int > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< int > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_int_Sg__InsertRange(arg1,arg2,(std::vector< int > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_IntVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector< int > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_int_Sg__RemoveAt(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_IntVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< int > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_int_Sg__RemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_IntVector_Repeat(int jarg1, int jarg2) {
  void * jresult ;
  int *arg1 = 0 ;
  int arg2 ;
  int temp1 ;
  std::vector< int > *result = 0 ;
  
  temp1 = (int)jarg1; 
  arg1 = &temp1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< int > *)std_vector_Sl_int_Sg__Repeat((int const &)*arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_IntVector_Reverse__SWIG_0(void * jarg1) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  
  arg1 = (std::vector< int > *)jarg1; 
  {
    try {
      std_vector_Sl_int_Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_IntVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< int > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_int_Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_IntVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int arg2 ;
  std::vector< int > *arg3 = 0 ;
  
  arg1 = (std::vector< int > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< int > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< int > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_int_Sg__SetRange(arg1,arg2,(std::vector< int > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_IntVector_Contains(void * jarg1, int jarg2) {
  unsigned int jresult ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int *arg2 = 0 ;
  int temp2 ;
  bool result;
  
  arg1 = (std::vector< int > *)jarg1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  {
    try {
      result = (bool)std_vector_Sl_int_Sg__Contains(arg1,(int const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_IntVector_IndexOf(void * jarg1, int jarg2) {
  int jresult ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int *arg2 = 0 ;
  int temp2 ;
  int result;
  
  arg1 = (std::vector< int > *)jarg1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  {
    try {
      result = (int)std_vector_Sl_int_Sg__IndexOf(arg1,(int const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_IntVector_LastIndexOf(void * jarg1, int jarg2) {
  int jresult ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int *arg2 = 0 ;
  int temp2 ;
  int result;
  
  arg1 = (std::vector< int > *)jarg1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  {
    try {
      result = (int)std_vector_Sl_int_Sg__LastIndexOf(arg1,(int const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_IntVector_Remove(void * jarg1, int jarg2) {
  unsigned int jresult ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int *arg2 = 0 ;
  int temp2 ;
  bool result;
  
  arg1 = (std::vector< int > *)jarg1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  {
    try {
      result = (bool)std_vector_Sl_int_Sg__Remove(arg1,(int const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_IntVector(void * jarg1) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  
  arg1 = (std::vector< int > *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_Clear(void * jarg1) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_Add(void * jarg1, unsigned int jarg2) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  unsigned int *arg2 = 0 ;
  unsigned int temp2 ;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  temp2 = (unsigned int)jarg2; 
  arg2 = &temp2; 
  {
    try {
      (arg1)->push_back((unsigned int const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  std::vector< unsigned int >::size_type result;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  {
    try {
      result = ((std::vector< unsigned int > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  std::vector< unsigned int >::size_type result;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  {
    try {
      result = ((std::vector< unsigned int > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  std::vector< unsigned int >::size_type arg2 ;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  arg2 = (std::vector< unsigned int >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_UnsignedIntVector__SWIG_0() {
  void * jresult ;
  std::vector< unsigned int > *result = 0 ;
  
  {
    try {
      result = (std::vector< unsigned int > *)new std::vector< unsigned int >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_UnsignedIntVector__SWIG_1(void * jarg1) {
  void * jresult ;
  std::vector< unsigned int > *arg1 = 0 ;
  std::vector< unsigned int > *result = 0 ;
  
  arg1 = (std::vector< unsigned int > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< unsigned int > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (std::vector< unsigned int > *)new std::vector< unsigned int >((std::vector< unsigned int > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_UnsignedIntVector__SWIG_2(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector< unsigned int > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector< unsigned int > *)new_std_vector_Sl_unsigned_SS_int_Sg___SWIG_2(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_getitemcopy(void * jarg1, int jarg2) {
  unsigned int jresult ;
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  int arg2 ;
  unsigned int result;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (unsigned int)std_vector_Sl_unsigned_SS_int_Sg__getitemcopy(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_getitem(void * jarg1, int jarg2) {
  unsigned int jresult ;
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  int arg2 ;
  std::vector< unsigned int >::value_type *result = 0 ;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< unsigned int >::value_type *) &std_vector_Sl_unsigned_SS_int_Sg__getitem(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = *result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_setitem(void * jarg1, int jarg2, unsigned int jarg3) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  int arg2 ;
  unsigned int *arg3 = 0 ;
  unsigned int temp3 ;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  arg2 = (int)jarg2; 
  temp3 = (unsigned int)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_unsigned_SS_int_Sg__setitem(arg1,arg2,(unsigned int const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_AddRange(void * jarg1, void * jarg2) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  std::vector< unsigned int > *arg2 = 0 ;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  arg2 = (std::vector< unsigned int > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< unsigned int > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_unsigned_SS_int_Sg__AddRange(arg1,(std::vector< unsigned int > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector< unsigned int > *result = 0 ;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector< unsigned int > *)std_vector_Sl_unsigned_SS_int_Sg__GetRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_Insert(void * jarg1, int jarg2, unsigned int jarg3) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  int arg2 ;
  unsigned int *arg3 = 0 ;
  unsigned int temp3 ;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  arg2 = (int)jarg2; 
  temp3 = (unsigned int)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_unsigned_SS_int_Sg__Insert(arg1,arg2,(unsigned int const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  int arg2 ;
  std::vector< unsigned int > *arg3 = 0 ;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< unsigned int > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< unsigned int > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_unsigned_SS_int_Sg__InsertRange(arg1,arg2,(std::vector< unsigned int > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_unsigned_SS_int_Sg__RemoveAt(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_unsigned_SS_int_Sg__RemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_Repeat(unsigned int jarg1, int jarg2) {
  void * jresult ;
  unsigned int *arg1 = 0 ;
  int arg2 ;
  unsigned int temp1 ;
  std::vector< unsigned int > *result = 0 ;
  
  temp1 = (unsigned int)jarg1; 
  arg1 = &temp1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< unsigned int > *)std_vector_Sl_unsigned_SS_int_Sg__Repeat((unsigned int const &)*arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_Reverse__SWIG_0(void * jarg1) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  {
    try {
      std_vector_Sl_unsigned_SS_int_Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_unsigned_SS_int_Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  int arg2 ;
  std::vector< unsigned int > *arg3 = 0 ;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< unsigned int > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< unsigned int > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_unsigned_SS_int_Sg__SetRange(arg1,arg2,(std::vector< unsigned int > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_Contains(void * jarg1, unsigned int jarg2) {
  unsigned int jresult ;
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  unsigned int *arg2 = 0 ;
  unsigned int temp2 ;
  bool result;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  temp2 = (unsigned int)jarg2; 
  arg2 = &temp2; 
  {
    try {
      result = (bool)std_vector_Sl_unsigned_SS_int_Sg__Contains(arg1,(unsigned int const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_IndexOf(void * jarg1, unsigned int jarg2) {
  int jresult ;
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  unsigned int *arg2 = 0 ;
  unsigned int temp2 ;
  int result;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  temp2 = (unsigned int)jarg2; 
  arg2 = &temp2; 
  {
    try {
      result = (int)std_vector_Sl_unsigned_SS_int_Sg__IndexOf(arg1,(unsigned int const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_LastIndexOf(void * jarg1, unsigned int jarg2) {
  int jresult ;
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  unsigned int *arg2 = 0 ;
  unsigned int temp2 ;
  int result;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  temp2 = (unsigned int)jarg2; 
  arg2 = &temp2; 
  {
    try {
      result = (int)std_vector_Sl_unsigned_SS_int_Sg__LastIndexOf(arg1,(unsigned int const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_UnsignedIntVector_Remove(void * jarg1, unsigned int jarg2) {
  unsigned int jresult ;
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  unsigned int *arg2 = 0 ;
  unsigned int temp2 ;
  bool result;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  temp2 = (unsigned int)jarg2; 
  arg2 = &temp2; 
  {
    try {
      result = (bool)std_vector_Sl_unsigned_SS_int_Sg__Remove(arg1,(unsigned int const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_UnsignedIntVector(void * jarg1) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  
  arg1 = (std::vector< unsigned int > *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoubleVector_Clear(void * jarg1) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  
  arg1 = (std::vector< double > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoubleVector_Add(void * jarg1, double jarg2) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  double *arg2 = 0 ;
  double temp2 ;
  
  arg1 = (std::vector< double > *)jarg1; 
  temp2 = (double)jarg2; 
  arg2 = &temp2; 
  {
    try {
      (arg1)->push_back((double const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_DoubleVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  std::vector< double >::size_type result;
  
  arg1 = (std::vector< double > *)jarg1; 
  {
    try {
      result = ((std::vector< double > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_DoubleVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  std::vector< double >::size_type result;
  
  arg1 = (std::vector< double > *)jarg1; 
  {
    try {
      result = ((std::vector< double > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoubleVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  std::vector< double >::size_type arg2 ;
  
  arg1 = (std::vector< double > *)jarg1; 
  arg2 = (std::vector< double >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_DoubleVector__SWIG_0() {
  void * jresult ;
  std::vector< double > *result = 0 ;
  
  {
    try {
      result = (std::vector< double > *)new std::vector< double >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_DoubleVector__SWIG_1(void * jarg1) {
  void * jresult ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *result = 0 ;
  
  arg1 = (std::vector< double > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< double > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (std::vector< double > *)new std::vector< double >((std::vector< double > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_DoubleVector__SWIG_2(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector< double > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector< double > *)new_std_vector_Sl_double_Sg___SWIG_2(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_DoubleVector_getitemcopy(void * jarg1, int jarg2) {
  double jresult ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  int arg2 ;
  double result;
  
  arg1 = (std::vector< double > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (double)std_vector_Sl_double_Sg__getitemcopy(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_DoubleVector_getitem(void * jarg1, int jarg2) {
  double jresult ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  int arg2 ;
  std::vector< double >::value_type *result = 0 ;
  
  arg1 = (std::vector< double > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< double >::value_type *) &std_vector_Sl_double_Sg__getitem(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = *result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoubleVector_setitem(void * jarg1, int jarg2, double jarg3) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  int arg2 ;
  double *arg3 = 0 ;
  double temp3 ;
  
  arg1 = (std::vector< double > *)jarg1; 
  arg2 = (int)jarg2; 
  temp3 = (double)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_double_Sg__setitem(arg1,arg2,(double const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoubleVector_AddRange(void * jarg1, void * jarg2) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  std::vector< double > *arg2 = 0 ;
  
  arg1 = (std::vector< double > *)jarg1; 
  arg2 = (std::vector< double > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< double > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_double_Sg__AddRange(arg1,(std::vector< double > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_DoubleVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector< double > *result = 0 ;
  
  arg1 = (std::vector< double > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector< double > *)std_vector_Sl_double_Sg__GetRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoubleVector_Insert(void * jarg1, int jarg2, double jarg3) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  int arg2 ;
  double *arg3 = 0 ;
  double temp3 ;
  
  arg1 = (std::vector< double > *)jarg1; 
  arg2 = (int)jarg2; 
  temp3 = (double)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_double_Sg__Insert(arg1,arg2,(double const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoubleVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  int arg2 ;
  std::vector< double > *arg3 = 0 ;
  
  arg1 = (std::vector< double > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< double > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< double > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_double_Sg__InsertRange(arg1,arg2,(std::vector< double > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoubleVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector< double > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_double_Sg__RemoveAt(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoubleVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< double > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_double_Sg__RemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_DoubleVector_Repeat(double jarg1, int jarg2) {
  void * jresult ;
  double *arg1 = 0 ;
  int arg2 ;
  double temp1 ;
  std::vector< double > *result = 0 ;
  
  temp1 = (double)jarg1; 
  arg1 = &temp1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< double > *)std_vector_Sl_double_Sg__Repeat((double const &)*arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoubleVector_Reverse__SWIG_0(void * jarg1) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  
  arg1 = (std::vector< double > *)jarg1; 
  {
    try {
      std_vector_Sl_double_Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoubleVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< double > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_double_Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoubleVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  int arg2 ;
  std::vector< double > *arg3 = 0 ;
  
  arg1 = (std::vector< double > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< double > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< double > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_double_Sg__SetRange(arg1,arg2,(std::vector< double > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_DoubleVector_Contains(void * jarg1, double jarg2) {
  unsigned int jresult ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  double *arg2 = 0 ;
  double temp2 ;
  bool result;
  
  arg1 = (std::vector< double > *)jarg1; 
  temp2 = (double)jarg2; 
  arg2 = &temp2; 
  {
    try {
      result = (bool)std_vector_Sl_double_Sg__Contains(arg1,(double const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_DoubleVector_IndexOf(void * jarg1, double jarg2) {
  int jresult ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  double *arg2 = 0 ;
  double temp2 ;
  int result;
  
  arg1 = (std::vector< double > *)jarg1; 
  temp2 = (double)jarg2; 
  arg2 = &temp2; 
  {
    try {
      result = (int)std_vector_Sl_double_Sg__IndexOf(arg1,(double const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_DoubleVector_LastIndexOf(void * jarg1, double jarg2) {
  int jresult ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  double *arg2 = 0 ;
  double temp2 ;
  int result;
  
  arg1 = (std::vector< double > *)jarg1; 
  temp2 = (double)jarg2; 
  arg2 = &temp2; 
  {
    try {
      result = (int)std_vector_Sl_double_Sg__LastIndexOf(arg1,(double const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_DoubleVector_Remove(void * jarg1, double jarg2) {
  unsigned int jresult ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  double *arg2 = 0 ;
  double temp2 ;
  bool result;
  
  arg1 = (std::vector< double > *)jarg1; 
  temp2 = (double)jarg2; 
  arg2 = &temp2; 
  {
    try {
      result = (bool)std_vector_Sl_double_Sg__Remove(arg1,(double const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_DoubleVector(void * jarg1) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  
  arg1 = (std::vector< double > *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_StrVector_Clear(void * jarg1) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_StrVector_Add(void * jarg1, char * jarg2) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::string *arg2 = 0 ;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  if (!jarg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return ;
  }
  std::string arg2_str(jarg2);
  arg2 = &arg2_str; 
  {
    try {
      (arg1)->push_back((std::string const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_StrVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::size_type result;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  {
    try {
      result = ((std::vector< std::string > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_StrVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::size_type result;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  {
    try {
      result = ((std::vector< std::string > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_StrVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::size_type arg2 ;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  arg2 = (std::vector< std::string >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_StrVector__SWIG_0() {
  void * jresult ;
  std::vector< std::string > *result = 0 ;
  
  {
    try {
      result = (std::vector< std::string > *)new std::vector< std::string >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_StrVector__SWIG_1(void * jarg1) {
  void * jresult ;
  std::vector< std::string > *arg1 = 0 ;
  std::vector< std::string > *result = 0 ;
  
  arg1 = (std::vector< std::string > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::string > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (std::vector< std::string > *)new std::vector< std::string >((std::vector< std::string > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_StrVector__SWIG_2(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector< std::string > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector< std::string > *)new_std_vector_Sl_std_string_Sg___SWIG_2(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_StrVector_getitemcopy(void * jarg1, int jarg2) {
  char * jresult ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  int arg2 ;
  std::string result;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_std_string_Sg__getitemcopy(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_StrVector_getitem(void * jarg1, int jarg2) {
  char * jresult ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  int arg2 ;
  std::vector< std::string >::value_type *result = 0 ;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< std::string >::value_type *) &std_vector_Sl_std_string_Sg__getitem(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback(result->c_str()); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_StrVector_setitem(void * jarg1, int jarg2, char * jarg3) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  int arg2 ;
  std::string *arg3 = 0 ;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  arg2 = (int)jarg2; 
  if (!jarg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return ;
  }
  std::string arg3_str(jarg3);
  arg3 = &arg3_str; 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__setitem(arg1,arg2,(std::string const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_StrVector_AddRange(void * jarg1, void * jarg2) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string > *arg2 = 0 ;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  arg2 = (std::vector< std::string > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::string > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_std_string_Sg__AddRange(arg1,(std::vector< std::string > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_StrVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector< std::string > *result = 0 ;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector< std::string > *)std_vector_Sl_std_string_Sg__GetRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_StrVector_Insert(void * jarg1, int jarg2, char * jarg3) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  int arg2 ;
  std::string *arg3 = 0 ;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  arg2 = (int)jarg2; 
  if (!jarg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return ;
  }
  std::string arg3_str(jarg3);
  arg3 = &arg3_str; 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__Insert(arg1,arg2,(std::string const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_StrVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  int arg2 ;
  std::vector< std::string > *arg3 = 0 ;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< std::string > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::string > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__InsertRange(arg1,arg2,(std::vector< std::string > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_StrVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__RemoveAt(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_StrVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__RemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_StrVector_Repeat(char * jarg1, int jarg2) {
  void * jresult ;
  std::string *arg1 = 0 ;
  int arg2 ;
  std::vector< std::string > *result = 0 ;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< std::string > *)std_vector_Sl_std_string_Sg__Repeat((std::string const &)*arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_StrVector_Reverse__SWIG_0(void * jarg1) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  {
    try {
      std_vector_Sl_std_string_Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_StrVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_StrVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  int arg2 ;
  std::vector< std::string > *arg3 = 0 ;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< std::string > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::string > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__SetRange(arg1,arg2,(std::vector< std::string > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_StrVector_Contains(void * jarg1, char * jarg2) {
  unsigned int jresult ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  if (!jarg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg2_str(jarg2);
  arg2 = &arg2_str; 
  {
    try {
      result = (bool)std_vector_Sl_std_string_Sg__Contains(arg1,(std::string const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_StrVector_IndexOf(void * jarg1, char * jarg2) {
  int jresult ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::string *arg2 = 0 ;
  int result;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  if (!jarg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg2_str(jarg2);
  arg2 = &arg2_str; 
  {
    try {
      result = (int)std_vector_Sl_std_string_Sg__IndexOf(arg1,(std::string const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_StrVector_LastIndexOf(void * jarg1, char * jarg2) {
  int jresult ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::string *arg2 = 0 ;
  int result;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  if (!jarg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg2_str(jarg2);
  arg2 = &arg2_str; 
  {
    try {
      result = (int)std_vector_Sl_std_string_Sg__LastIndexOf(arg1,(std::string const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_StrVector_Remove(void * jarg1, char * jarg2) {
  unsigned int jresult ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  if (!jarg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg2_str(jarg2);
  arg2 = &arg2_str; 
  {
    try {
      result = (bool)std_vector_Sl_std_string_Sg__Remove(arg1,(std::string const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_StrVector(void * jarg1) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  
  arg1 = (std::vector< std::string > *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_BoolVector_Clear(void * jarg1) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  
  arg1 = (std::vector< bool > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_BoolVector_Add(void * jarg1, unsigned int jarg2) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  bool *arg2 = 0 ;
  bool temp2 ;
  
  arg1 = (std::vector< bool > *)jarg1; 
  temp2 = jarg2 ? true : false; 
  arg2 = &temp2; 
  {
    try {
      (arg1)->push_back((bool const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_BoolVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  std::vector< bool >::size_type result;
  
  arg1 = (std::vector< bool > *)jarg1; 
  {
    try {
      result = ((std::vector< bool > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_BoolVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  std::vector< bool >::size_type result;
  
  arg1 = (std::vector< bool > *)jarg1; 
  {
    try {
      result = ((std::vector< bool > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_BoolVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  std::vector< bool >::size_type arg2 ;
  
  arg1 = (std::vector< bool > *)jarg1; 
  arg2 = (std::vector< bool >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_BoolVector__SWIG_0() {
  void * jresult ;
  std::vector< bool > *result = 0 ;
  
  {
    try {
      result = (std::vector< bool > *)new std::vector< bool >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_BoolVector__SWIG_1(void * jarg1) {
  void * jresult ;
  std::vector< bool > *arg1 = 0 ;
  std::vector< bool > *result = 0 ;
  
  arg1 = (std::vector< bool > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< bool > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (std::vector< bool > *)new std::vector< bool >((std::vector< bool > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_BoolVector__SWIG_2(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector< bool > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector< bool > *)new_std_vector_Sl_bool_Sg___SWIG_2(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_BoolVector_getitemcopy(void * jarg1, int jarg2) {
  unsigned int jresult ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  int arg2 ;
  bool result;
  
  arg1 = (std::vector< bool > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (bool)std_vector_Sl_bool_Sg__getitemcopy(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_BoolVector_getitem(void * jarg1, int jarg2) {
  unsigned int jresult ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  int arg2 ;
  bool result;
  
  arg1 = (std::vector< bool > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (bool)std_vector_Sl_bool_Sg__getitem(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_BoolVector_setitem(void * jarg1, int jarg2, unsigned int jarg3) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  int arg2 ;
  bool *arg3 = 0 ;
  bool temp3 ;
  
  arg1 = (std::vector< bool > *)jarg1; 
  arg2 = (int)jarg2; 
  temp3 = jarg3 ? true : false; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_bool_Sg__setitem(arg1,arg2,(bool const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_BoolVector_AddRange(void * jarg1, void * jarg2) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  std::vector< bool > *arg2 = 0 ;
  
  arg1 = (std::vector< bool > *)jarg1; 
  arg2 = (std::vector< bool > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< bool > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_bool_Sg__AddRange(arg1,(std::vector< bool > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_BoolVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector< bool > *result = 0 ;
  
  arg1 = (std::vector< bool > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector< bool > *)std_vector_Sl_bool_Sg__GetRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_BoolVector_Insert(void * jarg1, int jarg2, unsigned int jarg3) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  int arg2 ;
  bool *arg3 = 0 ;
  bool temp3 ;
  
  arg1 = (std::vector< bool > *)jarg1; 
  arg2 = (int)jarg2; 
  temp3 = jarg3 ? true : false; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_bool_Sg__Insert(arg1,arg2,(bool const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_BoolVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  int arg2 ;
  std::vector< bool > *arg3 = 0 ;
  
  arg1 = (std::vector< bool > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< bool > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< bool > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_bool_Sg__InsertRange(arg1,arg2,(std::vector< bool > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_BoolVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector< bool > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_bool_Sg__RemoveAt(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_BoolVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< bool > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_bool_Sg__RemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_BoolVector_Repeat(unsigned int jarg1, int jarg2) {
  void * jresult ;
  bool *arg1 = 0 ;
  int arg2 ;
  bool temp1 ;
  std::vector< bool > *result = 0 ;
  
  temp1 = jarg1 ? true : false; 
  arg1 = &temp1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< bool > *)std_vector_Sl_bool_Sg__Repeat((bool const &)*arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_BoolVector_Reverse__SWIG_0(void * jarg1) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  
  arg1 = (std::vector< bool > *)jarg1; 
  {
    try {
      std_vector_Sl_bool_Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_BoolVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< bool > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_bool_Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_BoolVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  int arg2 ;
  std::vector< bool > *arg3 = 0 ;
  
  arg1 = (std::vector< bool > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< bool > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< bool > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_bool_Sg__SetRange(arg1,arg2,(std::vector< bool > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_BoolVector_Contains(void * jarg1, unsigned int jarg2) {
  unsigned int jresult ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  bool *arg2 = 0 ;
  bool temp2 ;
  bool result;
  
  arg1 = (std::vector< bool > *)jarg1; 
  temp2 = jarg2 ? true : false; 
  arg2 = &temp2; 
  {
    try {
      result = (bool)std_vector_Sl_bool_Sg__Contains(arg1,(bool const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_BoolVector_IndexOf(void * jarg1, unsigned int jarg2) {
  int jresult ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  bool *arg2 = 0 ;
  bool temp2 ;
  int result;
  
  arg1 = (std::vector< bool > *)jarg1; 
  temp2 = jarg2 ? true : false; 
  arg2 = &temp2; 
  {
    try {
      result = (int)std_vector_Sl_bool_Sg__IndexOf(arg1,(bool const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_BoolVector_LastIndexOf(void * jarg1, unsigned int jarg2) {
  int jresult ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  bool *arg2 = 0 ;
  bool temp2 ;
  int result;
  
  arg1 = (std::vector< bool > *)jarg1; 
  temp2 = jarg2 ? true : false; 
  arg2 = &temp2; 
  {
    try {
      result = (int)std_vector_Sl_bool_Sg__LastIndexOf(arg1,(bool const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_BoolVector_Remove(void * jarg1, unsigned int jarg2) {
  unsigned int jresult ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  bool *arg2 = 0 ;
  bool temp2 ;
  bool result;
  
  arg1 = (std::vector< bool > *)jarg1; 
  temp2 = jarg2 ? true : false; 
  arg2 = &temp2; 
  {
    try {
      result = (bool)std_vector_Sl_bool_Sg__Remove(arg1,(bool const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_BoolVector(void * jarg1) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  
  arg1 = (std::vector< bool > *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_DoublePair__SWIG_0() {
  void * jresult ;
  std::pair< double,double > *result = 0 ;
  
  {
    try {
      result = (std::pair< double,double > *)new std::pair< double,double >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_DoublePair__SWIG_1(double jarg1, double jarg2) {
  void * jresult ;
  double arg1 ;
  double arg2 ;
  std::pair< double,double > *result = 0 ;
  
  arg1 = (double)jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      result = (std::pair< double,double > *)new std::pair< double,double >(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_DoublePair__SWIG_2(void * jarg1) {
  void * jresult ;
  std::pair< double,double > *arg1 = 0 ;
  std::pair< double,double > *result = 0 ;
  
  arg1 = (std::pair< double,double > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::pair< double,double > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (std::pair< double,double > *)new std::pair< double,double >((std::pair< double,double > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoublePair_first_set(void * jarg1, double jarg2) {
  std::pair< double,double > *arg1 = (std::pair< double,double > *) 0 ;
  double arg2 ;
  
  arg1 = (std::pair< double,double > *)jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->first = arg2;
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_DoublePair_first_get(void * jarg1) {
  double jresult ;
  std::pair< double,double > *arg1 = (std::pair< double,double > *) 0 ;
  double result;
  
  arg1 = (std::pair< double,double > *)jarg1; 
  result = (double) ((arg1)->first);
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoublePair_second_set(void * jarg1, double jarg2) {
  std::pair< double,double > *arg1 = (std::pair< double,double > *) 0 ;
  double arg2 ;
  
  arg1 = (std::pair< double,double > *)jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->second = arg2;
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_DoublePair_second_get(void * jarg1) {
  double jresult ;
  std::pair< double,double > *arg1 = (std::pair< double,double > *) 0 ;
  double result;
  
  arg1 = (std::pair< double,double > *)jarg1; 
  result = (double) ((arg1)->second);
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_DoublePair(void * jarg1) {
  std::pair< double,double > *arg1 = (std::pair< double,double > *) 0 ;
  
  arg1 = (std::pair< double,double > *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoublePairVector_Clear(void * jarg1) {
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  
  arg1 = (std::vector< std::pair< double,double > > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoublePairVector_Add(void * jarg1, void * jarg2) {
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  std::pair< double,double > *arg2 = 0 ;
  
  arg1 = (std::vector< std::pair< double,double > > *)jarg1; 
  arg2 = (std::pair< double,double > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::pair< double,double > const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::pair< double,double > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_DoublePairVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  std::vector< std::pair< double,double > >::size_type result;
  
  arg1 = (std::vector< std::pair< double,double > > *)jarg1; 
  {
    try {
      result = ((std::vector< std::pair< double,double > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_DoublePairVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  std::vector< std::pair< double,double > >::size_type result;
  
  arg1 = (std::vector< std::pair< double,double > > *)jarg1; 
  {
    try {
      result = ((std::vector< std::pair< double,double > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoublePairVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  std::vector< std::pair< double,double > >::size_type arg2 ;
  
  arg1 = (std::vector< std::pair< double,double > > *)jarg1; 
  arg2 = (std::vector< std::pair< double,double > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_DoublePairVector__SWIG_0() {
  void * jresult ;
  std::vector< std::pair< double,double > > *result = 0 ;
  
  {
    try {
      result = (std::vector< std::pair< double,double > > *)new std::vector< std::pair< double,double > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_DoublePairVector__SWIG_1(void * jarg1) {
  void * jresult ;
  std::vector< std::pair< double,double > > *arg1 = 0 ;
  std::vector< std::pair< double,double > > *result = 0 ;
  
  arg1 = (std::vector< std::pair< double,double > > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::pair< double,double > > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (std::vector< std::pair< double,double > > *)new std::vector< std::pair< double,double > >((std::vector< std::pair< double,double > > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_DoublePairVector__SWIG_2(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector< std::pair< double,double > > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector< std::pair< double,double > > *)new_std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg___SWIG_2(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_DoublePairVector_getitemcopy(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  int arg2 ;
  std::pair< double,double > result;
  
  arg1 = (std::vector< std::pair< double,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__getitemcopy(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new std::pair< double,double >((const std::pair< double,double > &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_DoublePairVector_getitem(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  int arg2 ;
  std::vector< std::pair< double,double > >::value_type *result = 0 ;
  
  arg1 = (std::vector< std::pair< double,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< std::pair< double,double > >::value_type *) &std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__getitem(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoublePairVector_setitem(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  int arg2 ;
  std::pair< double,double > *arg3 = 0 ;
  
  arg1 = (std::vector< std::pair< double,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::pair< double,double > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::pair< double,double > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__setitem(arg1,arg2,(std::pair< double,double > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoublePairVector_AddRange(void * jarg1, void * jarg2) {
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  std::vector< std::pair< double,double > > *arg2 = 0 ;
  
  arg1 = (std::vector< std::pair< double,double > > *)jarg1; 
  arg2 = (std::vector< std::pair< double,double > > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::pair< double,double > > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__AddRange(arg1,(std::vector< std::pair< double,double > > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_DoublePairVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector< std::pair< double,double > > *result = 0 ;
  
  arg1 = (std::vector< std::pair< double,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector< std::pair< double,double > > *)std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__GetRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoublePairVector_Insert(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  int arg2 ;
  std::pair< double,double > *arg3 = 0 ;
  
  arg1 = (std::vector< std::pair< double,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::pair< double,double > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::pair< double,double > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__Insert(arg1,arg2,(std::pair< double,double > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoublePairVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  int arg2 ;
  std::vector< std::pair< double,double > > *arg3 = 0 ;
  
  arg1 = (std::vector< std::pair< double,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< std::pair< double,double > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::pair< double,double > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__InsertRange(arg1,arg2,(std::vector< std::pair< double,double > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoublePairVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector< std::pair< double,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__RemoveAt(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoublePairVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< std::pair< double,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__RemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_DoublePairVector_Repeat(void * jarg1, int jarg2) {
  void * jresult ;
  std::pair< double,double > *arg1 = 0 ;
  int arg2 ;
  std::vector< std::pair< double,double > > *result = 0 ;
  
  arg1 = (std::pair< double,double > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::pair< double,double > const & type is null", 0);
    return 0;
  } 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< std::pair< double,double > > *)std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__Repeat((std::pair< double,double > const &)*arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoublePairVector_Reverse__SWIG_0(void * jarg1) {
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  
  arg1 = (std::vector< std::pair< double,double > > *)jarg1; 
  {
    try {
      std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoublePairVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< std::pair< double,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_DoublePairVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  int arg2 ;
  std::vector< std::pair< double,double > > *arg3 = 0 ;
  
  arg1 = (std::vector< std::pair< double,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< std::pair< double,double > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::pair< double,double > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_double_Sc_double_Sg__Sg__SetRange(arg1,arg2,(std::vector< std::pair< double,double > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_DoublePairVector(void * jarg1) {
  std::vector< std::pair< double,double > > *arg1 = (std::vector< std::pair< double,double > > *) 0 ;
  
  arg1 = (std::vector< std::pair< double,double > > *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_NodePair__SWIG_0() {
  void * jresult ;
  std::pair< Date,double > *result = 0 ;
  
  {
    try {
      result = (std::pair< Date,double > *)new std::pair< Date,double >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_NodePair__SWIG_1(void * jarg1, double jarg2) {
  void * jresult ;
  Date arg1 ;
  double arg2 ;
  Date *argp1 ;
  std::pair< Date,double > *result = 0 ;
  
  argp1 = (Date *)jarg1; 
  if (!argp1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Attempt to dereference null Date", 0);
    return 0;
  }
  arg1 = *argp1; 
  arg2 = (double)jarg2; 
  {
    try {
      result = (std::pair< Date,double > *)new std::pair< Date,double >(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_NodePair__SWIG_2(void * jarg1) {
  void * jresult ;
  std::pair< Date,double > *arg1 = 0 ;
  std::pair< Date,double > *result = 0 ;
  
  arg1 = (std::pair< Date,double > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::pair< Date,double > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (std::pair< Date,double > *)new std::pair< Date,double >((std::pair< Date,double > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_NodePair_first_set(void * jarg1, void * jarg2) {
  std::pair< Date,double > *arg1 = (std::pair< Date,double > *) 0 ;
  Date *arg2 = (Date *) 0 ;
  
  arg1 = (std::pair< Date,double > *)jarg1; 
  arg2 = (Date *)jarg2; 
  if (arg1) (arg1)->first = *arg2;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_NodePair_first_get(void * jarg1) {
  void * jresult ;
  std::pair< Date,double > *arg1 = (std::pair< Date,double > *) 0 ;
  Date *result = 0 ;
  
  arg1 = (std::pair< Date,double > *)jarg1; 
  result = (Date *)& ((arg1)->first);
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_NodePair_second_set(void * jarg1, double jarg2) {
  std::pair< Date,double > *arg1 = (std::pair< Date,double > *) 0 ;
  double arg2 ;
  
  arg1 = (std::pair< Date,double > *)jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->second = arg2;
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_NodePair_second_get(void * jarg1) {
  double jresult ;
  std::pair< Date,double > *arg1 = (std::pair< Date,double > *) 0 ;
  double result;
  
  arg1 = (std::pair< Date,double > *)jarg1; 
  result = (double) ((arg1)->second);
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_NodePair(void * jarg1) {
  std::pair< Date,double > *arg1 = (std::pair< Date,double > *) 0 ;
  
  arg1 = (std::pair< Date,double > *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_NodeVector_Clear(void * jarg1) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_NodeVector_Add(void * jarg1, void * jarg2) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  std::pair< Date,double > *arg2 = 0 ;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  arg2 = (std::pair< Date,double > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::pair< Date,double > const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::pair< Date,double > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_NodeVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  std::vector< std::pair< Date,double > >::size_type result;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  {
    try {
      result = ((std::vector< std::pair< Date,double > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_NodeVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  std::vector< std::pair< Date,double > >::size_type result;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  {
    try {
      result = ((std::vector< std::pair< Date,double > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_NodeVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  std::vector< std::pair< Date,double > >::size_type arg2 ;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  arg2 = (std::vector< std::pair< Date,double > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_NodeVector__SWIG_0() {
  void * jresult ;
  std::vector< std::pair< Date,double > > *result = 0 ;
  
  {
    try {
      result = (std::vector< std::pair< Date,double > > *)new std::vector< std::pair< Date,double > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_NodeVector__SWIG_1(void * jarg1) {
  void * jresult ;
  std::vector< std::pair< Date,double > > *arg1 = 0 ;
  std::vector< std::pair< Date,double > > *result = 0 ;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::pair< Date,double > > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (std::vector< std::pair< Date,double > > *)new std::vector< std::pair< Date,double > >((std::vector< std::pair< Date,double > > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_NodeVector__SWIG_2(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector< std::pair< Date,double > > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector< std::pair< Date,double > > *)new_std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg___SWIG_2(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_NodeVector_getitemcopy(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  int arg2 ;
  std::pair< Date,double > result;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__getitemcopy(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new std::pair< Date,double >((const std::pair< Date,double > &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_NodeVector_getitem(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  int arg2 ;
  std::vector< std::pair< Date,double > >::value_type *result = 0 ;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< std::pair< Date,double > >::value_type *) &std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__getitem(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_NodeVector_setitem(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  int arg2 ;
  std::pair< Date,double > *arg3 = 0 ;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::pair< Date,double > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::pair< Date,double > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__setitem(arg1,arg2,(std::pair< Date,double > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_NodeVector_AddRange(void * jarg1, void * jarg2) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  std::vector< std::pair< Date,double > > *arg2 = 0 ;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  arg2 = (std::vector< std::pair< Date,double > > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::pair< Date,double > > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__AddRange(arg1,(std::vector< std::pair< Date,double > > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_NodeVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector< std::pair< Date,double > > *result = 0 ;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector< std::pair< Date,double > > *)std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__GetRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_NodeVector_Insert(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  int arg2 ;
  std::pair< Date,double > *arg3 = 0 ;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::pair< Date,double > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::pair< Date,double > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Insert(arg1,arg2,(std::pair< Date,double > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_NodeVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  int arg2 ;
  std::vector< std::pair< Date,double > > *arg3 = 0 ;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< std::pair< Date,double > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::pair< Date,double > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__InsertRange(arg1,arg2,(std::vector< std::pair< Date,double > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_NodeVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__RemoveAt(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_NodeVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__RemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_NodeVector_Repeat(void * jarg1, int jarg2) {
  void * jresult ;
  std::pair< Date,double > *arg1 = 0 ;
  int arg2 ;
  std::vector< std::pair< Date,double > > *result = 0 ;
  
  arg1 = (std::pair< Date,double > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::pair< Date,double > const & type is null", 0);
    return 0;
  } 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< std::pair< Date,double > > *)std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Repeat((std::pair< Date,double > const &)*arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_NodeVector_Reverse__SWIG_0(void * jarg1) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  {
    try {
      std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_NodeVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_NodeVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  int arg2 ;
  std::vector< std::pair< Date,double > > *arg3 = 0 ;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< std::pair< Date,double > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::pair< Date,double > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__SetRange(arg1,arg2,(std::vector< std::pair< Date,double > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_NodeVector_Contains(void * jarg1, void * jarg2) {
  unsigned int jresult ;
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  std::pair< Date,double > *arg2 = 0 ;
  bool result;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  arg2 = (std::pair< Date,double > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::pair< Date,double > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (bool)std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Contains(arg1,(std::pair< Date,double > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_NodeVector_IndexOf(void * jarg1, void * jarg2) {
  int jresult ;
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  std::pair< Date,double > *arg2 = 0 ;
  int result;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  arg2 = (std::pair< Date,double > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::pair< Date,double > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (int)std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__IndexOf(arg1,(std::pair< Date,double > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_NodeVector_LastIndexOf(void * jarg1, void * jarg2) {
  int jresult ;
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  std::pair< Date,double > *arg2 = 0 ;
  int result;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  arg2 = (std::pair< Date,double > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::pair< Date,double > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (int)std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__LastIndexOf(arg1,(std::pair< Date,double > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_NodeVector_Remove(void * jarg1, void * jarg2) {
  unsigned int jresult ;
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  std::pair< Date,double > *arg2 = 0 ;
  bool result;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  arg2 = (std::pair< Date,double > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::pair< Date,double > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (bool)std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Remove(arg1,(std::pair< Date,double > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_NodeVector(void * jarg1) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  
  arg1 = (std::vector< std::pair< Date,double > > *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Exercise(int jarg1) {
  void * jresult ;
  Exercise::Type arg1 ;
  Exercise *result = 0 ;
  
  arg1 = (Exercise::Type)jarg1; 
  {
    try {
      result = (Exercise *)new Exercise(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  jresult = result ? new boost::shared_ptr<  Exercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_Exercise_type(void * jarg1) {
  int jresult ;
  Exercise *arg1 = (Exercise *) 0 ;
  boost::shared_ptr< Exercise const > *smartarg1 = 0 ;
  Exercise::Type result;
  
  
  smartarg1 = (boost::shared_ptr< const Exercise > *)jarg1;
  arg1 = (Exercise *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      result = (Exercise::Type)((Exercise const *)arg1)->type();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (int)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Exercise_date(void * jarg1, unsigned long jarg2) {
  void * jresult ;
  Exercise *arg1 = (Exercise *) 0 ;
  Size arg2 ;
  boost::shared_ptr< Exercise > *smartarg1 = 0 ;
  Date result;
  
  
  smartarg1 = (boost::shared_ptr<  Exercise > *)jarg1;
  arg1 = (Exercise *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (Size)jarg2; 
  {
    try {
      result = (arg1)->date(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Exercise_dateAt(void * jarg1, unsigned long jarg2) {
  void * jresult ;
  Exercise *arg1 = (Exercise *) 0 ;
  Size arg2 ;
  boost::shared_ptr< Exercise > *smartarg1 = 0 ;
  Date result;
  
  
  smartarg1 = (boost::shared_ptr<  Exercise > *)jarg1;
  arg1 = (Exercise *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (Size)jarg2; 
  {
    try {
      result = (arg1)->dateAt(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Exercise_dates(void * jarg1) {
  void * jresult ;
  Exercise *arg1 = (Exercise *) 0 ;
  boost::shared_ptr< Exercise > *smartarg1 = 0 ;
  std::vector< Date > *result = 0 ;
  
  
  smartarg1 = (boost::shared_ptr<  Exercise > *)jarg1;
  arg1 = (Exercise *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      result = (std::vector< Date > *) &(arg1)->dates();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Exercise_lastDate(void * jarg1) {
  void * jresult ;
  Exercise *arg1 = (Exercise *) 0 ;
  boost::shared_ptr< Exercise const > *smartarg1 = 0 ;
  Date result;
  
  
  smartarg1 = (boost::shared_ptr< const Exercise > *)jarg1;
  arg1 = (Exercise *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      result = ((Exercise const *)arg1)->lastDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Exercise(void * jarg1) {
  Exercise *arg1 = (Exercise *) 0 ;
  boost::shared_ptr< Exercise > *smartarg1 = 0 ;
  
  
  smartarg1 = (boost::shared_ptr<  Exercise > *)jarg1;
  arg1 = (Exercise *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      (void)arg1; delete smartarg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_EuropeanExercise(void * jarg1) {
  void * jresult ;
  Date *arg1 = 0 ;
  EuropeanExercise *result = 0 ;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (EuropeanExercise *)new EuropeanExercise((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  jresult = result ? new boost::shared_ptr<  EuropeanExercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_EuropeanExercise(void * jarg1) {
  EuropeanExercise *arg1 = (EuropeanExercise *) 0 ;
  boost::shared_ptr< EuropeanExercise > *smartarg1 = 0 ;
  
  
  smartarg1 = (boost::shared_ptr<  EuropeanExercise > *)jarg1;
  arg1 = (EuropeanExercise *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      (void)arg1; delete smartarg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_AmericanExercise__SWIG_0(void * jarg1, void * jarg2, unsigned int jarg3) {
  void * jresult ;
  Date *arg1 = 0 ;
  Date *arg2 = 0 ;
  bool arg3 ;
  AmericanExercise *result = 0 ;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (AmericanExercise *)new AmericanExercise((Date const &)*arg1,(Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  jresult = result ? new boost::shared_ptr<  AmericanExercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_AmericanExercise__SWIG_1(void * jarg1, void * jarg2) {
  void * jresult ;
  Date *arg1 = 0 ;
  Date *arg2 = 0 ;
  AmericanExercise *result = 0 ;
  
  arg1 = (Date *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (AmericanExercise *)new AmericanExercise((Date const &)*arg1,(Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  jresult = result ? new boost::shared_ptr<  AmericanExercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_AmericanExercise(void * jarg1) {
  AmericanExercise *arg1 = (AmericanExercise *) 0 ;
  boost::shared_ptr< AmericanExercise > *smartarg1 = 0 ;
  
  
  smartarg1 = (boost::shared_ptr<  AmericanExercise > *)jarg1;
  arg1 = (AmericanExercise *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      (void)arg1; delete smartarg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_BermudanExercise__SWIG_0(void * jarg1, unsigned int jarg2) {
  void * jresult ;
  std::vector< Date > *arg1 = 0 ;
  bool arg2 ;
  BermudanExercise *result = 0 ;
  
  arg1 = (std::vector< Date > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< Date > const & type is null", 0);
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (BermudanExercise *)new BermudanExercise((std::vector< Date > const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  jresult = result ? new boost::shared_ptr<  BermudanExercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_BermudanExercise__SWIG_1(void * jarg1) {
  void * jresult ;
  std::vector< Date > *arg1 = 0 ;
  BermudanExercise *result = 0 ;
  
  arg1 = (std::vector< Date > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< Date > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (BermudanExercise *)new BermudanExercise((std::vector< Date > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  jresult = result ? new boost::shared_ptr<  BermudanExercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_BermudanExercise(void * jarg1) {
  BermudanExercise *arg1 = (BermudanExercise *) 0 ;
  boost::shared_ptr< BermudanExercise > *smartarg1 = 0 ;
  
  
  smartarg1 = (boost::shared_ptr<  BermudanExercise > *)jarg1;
  arg1 = (BermudanExercise *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      (void)arg1; delete smartarg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_RebatedExercise__SWIG_0(void * jarg1, void * jarg2, unsigned int jarg3, void * jarg4, int jarg5) {
  void * jresult ;
  Exercise *arg1 = 0 ;
  std::vector< Real > arg2 ;
  Natural arg3 ;
  Calendar *arg4 = 0 ;
  BusinessDayConvention arg5 ;
  std::vector< Real > const *argp2 ;
  RebatedExercise *result = 0 ;
  
  
  arg1 = (Exercise *)(((boost::shared_ptr< const Exercise > *)jarg1) ? ((boost::shared_ptr< const Exercise > *)jarg1)->get() : 0);
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Exercise const & reference is null", 0);
    return 0;
  } 
  argp2 = (std::vector< Real > *)jarg2; 
  if (!argp2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Attempt to dereference null std::vector< Real > const", 0);
    return 0;
  }
  arg2 = *argp2; 
  arg3 = (Natural)jarg3; 
  arg4 = (Calendar *)jarg4;
  if (!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg5 = (BusinessDayConvention)jarg5; 
  {
    try {
      result = (RebatedExercise *)new RebatedExercise((Exercise const &)*arg1,arg2,arg3,(Calendar const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  jresult = result ? new boost::shared_ptr<  RebatedExercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_RebatedExercise__SWIG_1(void * jarg1, void * jarg2, unsigned int jarg3, void * jarg4) {
  void * jresult ;
  Exercise *arg1 = 0 ;
  std::vector< Real > arg2 ;
  Natural arg3 ;
  Calendar *arg4 = 0 ;
  std::vector< Real > const *argp2 ;
  RebatedExercise *result = 0 ;
  
  
  arg1 = (Exercise *)(((boost::shared_ptr< const Exercise > *)jarg1) ? ((boost::shared_ptr< const Exercise > *)jarg1)->get() : 0);
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Exercise const & reference is null", 0);
    return 0;
  } 
  argp2 = (std::vector< Real > *)jarg2; 
  if (!argp2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Attempt to dereference null std::vector< Real > const", 0);
    return 0;
  }
  arg2 = *argp2; 
  arg3 = (Natural)jarg3; 
  arg4 = (Calendar *)jarg4;
  if (!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (RebatedExercise *)new RebatedExercise((Exercise const &)*arg1,arg2,arg3,(Calendar const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  jresult = result ? new boost::shared_ptr<  RebatedExercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_RebatedExercise__SWIG_2(void * jarg1, void * jarg2, unsigned int jarg3) {
  void * jresult ;
  Exercise *arg1 = 0 ;
  std::vector< Real > arg2 ;
  Natural arg3 ;
  std::vector< Real > const *argp2 ;
  RebatedExercise *result = 0 ;
  
  
  arg1 = (Exercise *)(((boost::shared_ptr< const Exercise > *)jarg1) ? ((boost::shared_ptr< const Exercise > *)jarg1)->get() : 0);
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Exercise const & reference is null", 0);
    return 0;
  } 
  argp2 = (std::vector< Real > *)jarg2; 
  if (!argp2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Attempt to dereference null std::vector< Real > const", 0);
    return 0;
  }
  arg2 = *argp2; 
  arg3 = (Natural)jarg3; 
  {
    try {
      result = (RebatedExercise *)new RebatedExercise((Exercise const &)*arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  jresult = result ? new boost::shared_ptr<  RebatedExercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_RebatedExercise__SWIG_3(void * jarg1, void * jarg2) {
  void * jresult ;
  Exercise *arg1 = 0 ;
  std::vector< Real > arg2 ;
  std::vector< Real > const *argp2 ;
  RebatedExercise *result = 0 ;
  
  
  arg1 = (Exercise *)(((boost::shared_ptr< const Exercise > *)jarg1) ? ((boost::shared_ptr< const Exercise > *)jarg1)->get() : 0);
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Exercise const & reference is null", 0);
    return 0;
  } 
  argp2 = (std::vector< Real > *)jarg2; 
  if (!argp2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Attempt to dereference null std::vector< Real > const", 0);
    return 0;
  }
  arg2 = *argp2; 
  {
    try {
      result = (RebatedExercise *)new RebatedExercise((Exercise const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  jresult = result ? new boost::shared_ptr<  RebatedExercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_RebatedExercise(void * jarg1) {
  RebatedExercise *arg1 = (RebatedExercise *) 0 ;
  boost::shared_ptr< RebatedExercise > *smartarg1 = 0 ;
  
  
  smartarg1 = (boost::shared_ptr<  RebatedExercise > *)jarg1;
  arg1 = (RebatedExercise *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      (void)arg1; delete smartarg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_SwingExercise(void * jarg1) {
  void * jresult ;
  std::vector< Date > *arg1 = 0 ;
  SwingExercise *result = 0 ;
  
  arg1 = (std::vector< Date > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< Date > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (SwingExercise *)new SwingExercise((std::vector< Date > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  jresult = result ? new boost::shared_ptr<  SwingExercise >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_SwingExercise(void * jarg1) {
  SwingExercise *arg1 = (SwingExercise *) 0 ;
  boost::shared_ptr< SwingExercise > *smartarg1 = 0 ;
  
  
  smartarg1 = (boost::shared_ptr<  SwingExercise > *)jarg1;
  arg1 = (SwingExercise *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      (void)arg1; delete smartarg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Observable() {
  void * jresult ;
  Observable *result = 0 ;
  
  {
    try {
      result = (Observable *)new Observable();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  jresult = result ? new boost::shared_ptr<  Observable >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Observable(void * jarg1) {
  Observable *arg1 = (Observable *) 0 ;
  boost::shared_ptr< Observable > *smartarg1 = 0 ;
  
  
  smartarg1 = (boost::shared_ptr<  Observable > *)jarg1;
  arg1 = (Observable *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      (void)arg1; delete smartarg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_QlArray__SWIG_0() {
  void * jresult ;
  Array *result = 0 ;
  
  {
    try {
      result = (Array *)new Array();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_QlArray__SWIG_1(unsigned long jarg1, double jarg2) {
  void * jresult ;
  Size arg1 ;
  Real arg2 ;
  Array *result = 0 ;
  
  arg1 = (Size)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Array *)new Array(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_QlArray__SWIG_2(unsigned long jarg1) {
  void * jresult ;
  Size arg1 ;
  Array *result = 0 ;
  
  arg1 = (Size)jarg1; 
  {
    try {
      result = (Array *)new Array(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_QlArray__SWIG_3(void * jarg1) {
  void * jresult ;
  Array *arg1 = 0 ;
  Array *result = 0 ;
  
  arg1 = (Array *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (Array *)new Array((Array const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_QlArray_size(void * jarg1) {
  unsigned long jresult ;
  Array *arg1 = (Array *) 0 ;
  Size result;
  
  arg1 = (Array *)jarg1; 
  {
    try {
      result = ((Array const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_QlArray___str__(void * jarg1) {
  char * jresult ;
  Array *arg1 = (Array *) 0 ;
  std::string result;
  
  arg1 = (Array *)jarg1; 
  {
    try {
      result = Array___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_QlArray_get(void * jarg1, unsigned long jarg2) {
  double jresult ;
  Array *arg1 = (Array *) 0 ;
  Size arg2 ;
  Real result;
  
  arg1 = (Array *)jarg1; 
  arg2 = (Size)jarg2; 
  {
    try {
      result = (Real)Array_get(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QlArray_set(void * jarg1, unsigned long jarg2, double jarg3) {
  Array *arg1 = (Array *) 0 ;
  Size arg2 ;
  Real arg3 ;
  
  arg1 = (Array *)jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      Array_set(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_QlArray(void * jarg1) {
  Array *arg1 = (Array *) 0 ;
  
  arg1 = (Array *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_LexicographicalView_xSize(void * jarg1) {
  unsigned long jresult ;
  DefaultLexicographicalView *arg1 = (DefaultLexicographicalView *) 0 ;
  Size result;
  
  arg1 = (DefaultLexicographicalView *)jarg1; 
  {
    try {
      result = ((DefaultLexicographicalView const *)arg1)->xSize();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_LexicographicalView_ySize(void * jarg1) {
  unsigned long jresult ;
  DefaultLexicographicalView *arg1 = (DefaultLexicographicalView *) 0 ;
  Size result;
  
  arg1 = (DefaultLexicographicalView *)jarg1; 
  {
    try {
      result = ((DefaultLexicographicalView const *)arg1)->ySize();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_LexicographicalView(void * jarg1, unsigned long jarg2) {
  void * jresult ;
  Array *arg1 = 0 ;
  Size arg2 ;
  DefaultLexicographicalView *result = 0 ;
  
  arg1 = (Array *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array & type is null", 0);
    return 0;
  } 
  arg2 = (Size)jarg2; 
  {
    try {
      result = (DefaultLexicographicalView *)new_DefaultLexicographicalView(*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_LexicographicalView___str__(void * jarg1) {
  char * jresult ;
  DefaultLexicographicalView *arg1 = (DefaultLexicographicalView *) 0 ;
  std::string result;
  
  arg1 = (DefaultLexicographicalView *)jarg1; 
  {
    try {
      result = DefaultLexicographicalView___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_LexicographicalView(void * jarg1) {
  DefaultLexicographicalView *arg1 = (DefaultLexicographicalView *) 0 ;
  
  arg1 = (DefaultLexicographicalView *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Matrix__SWIG_0() {
  void * jresult ;
  Matrix *result = 0 ;
  
  {
    try {
      result = (Matrix *)new Matrix();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Matrix__SWIG_1(unsigned long jarg1, unsigned long jarg2, double jarg3) {
  void * jresult ;
  Size arg1 ;
  Size arg2 ;
  Real arg3 ;
  Matrix *result = 0 ;
  
  arg1 = (Size)jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Matrix *)new Matrix(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Matrix__SWIG_2(unsigned long jarg1, unsigned long jarg2) {
  void * jresult ;
  Size arg1 ;
  Size arg2 ;
  Matrix *result = 0 ;
  
  arg1 = (Size)jarg1; 
  arg2 = (Size)jarg2; 
  {
    try {
      result = (Matrix *)new Matrix(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Matrix__SWIG_3(void * jarg1) {
  void * jresult ;
  Matrix *arg1 = 0 ;
  Matrix *result = 0 ;
  
  arg1 = (Matrix *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Matrix const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (Matrix *)new Matrix((Matrix const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_Matrix_rows(void * jarg1) {
  unsigned long jresult ;
  Matrix *arg1 = (Matrix *) 0 ;
  Size result;
  
  arg1 = (Matrix *)jarg1; 
  {
    try {
      result = ((Matrix const *)arg1)->rows();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_Matrix_columns(void * jarg1) {
  unsigned long jresult ;
  Matrix *arg1 = (Matrix *) 0 ;
  Size result;
  
  arg1 = (Matrix *)jarg1; 
  {
    try {
      result = ((Matrix const *)arg1)->columns();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_Matrix___str__(void * jarg1) {
  char * jresult ;
  Matrix *arg1 = (Matrix *) 0 ;
  std::string result;
  
  arg1 = (Matrix *)jarg1; 
  {
    try {
      result = Matrix___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_Matrix_get(void * jarg1, unsigned long jarg2, unsigned long jarg3) {
  double jresult ;
  Matrix *arg1 = (Matrix *) 0 ;
  Size arg2 ;
  Size arg3 ;
  Real result;
  
  arg1 = (Matrix *)jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Size)jarg3; 
  {
    try {
      result = (Real)Matrix_get(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_Matrix_set(void * jarg1, unsigned long jarg2, unsigned long jarg3, double jarg4) {
  Matrix *arg1 = (Matrix *) 0 ;
  Size arg2 ;
  Size arg3 ;
  Real arg4 ;
  
  arg1 = (Matrix *)jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Size)jarg3; 
  arg4 = (Real)jarg4; 
  {
    try {
      Matrix_set(arg1,arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Matrix(void * jarg1) {
  Matrix *arg1 = (Matrix *) 0 ;
  
  arg1 = (Matrix *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_SalvagingAlgorithm() {
  void * jresult ;
  SalvagingAlgorithm *result = 0 ;
  
  {
    try {
      result = (SalvagingAlgorithm *)new SalvagingAlgorithm();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_SalvagingAlgorithm(void * jarg1) {
  SalvagingAlgorithm *arg1 = (SalvagingAlgorithm *) 0 ;
  
  arg1 = (SalvagingAlgorithm *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_transpose(void * jarg1) {
  void * jresult ;
  Matrix *arg1 = 0 ;
  Matrix result;
  
  arg1 = (Matrix *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Matrix const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = transpose((Matrix const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Matrix((const Matrix &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_outerProduct(void * jarg1, void * jarg2) {
  void * jresult ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  Matrix result;
  
  arg1 = (Array *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  arg2 = (Array *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = outerProduct((Array const &)*arg1,(Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Matrix((const Matrix &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_pseudoSqrt(void * jarg1, int jarg2) {
  void * jresult ;
  Matrix *arg1 = 0 ;
  SalvagingAlgorithm::Type arg2 ;
  Matrix result;
  
  arg1 = (Matrix *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Matrix const & type is null", 0);
    return 0;
  } 
  arg2 = (SalvagingAlgorithm::Type)jarg2; 
  {
    try {
      result = pseudoSqrt((Matrix const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Matrix((const Matrix &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_SVD(void * jarg1) {
  void * jresult ;
  Matrix *arg1 = 0 ;
  SVD *result = 0 ;
  
  arg1 = (Matrix *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Matrix const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (SVD *)new SVD((Matrix const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_SVD_U(void * jarg1) {
  void * jresult ;
  SVD *arg1 = (SVD *) 0 ;
  Matrix *result = 0 ;
  
  arg1 = (SVD *)jarg1; 
  {
    try {
      result = (Matrix *) &((SVD const *)arg1)->U();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_SVD_V(void * jarg1) {
  void * jresult ;
  SVD *arg1 = (SVD *) 0 ;
  Matrix *result = 0 ;
  
  arg1 = (SVD *)jarg1; 
  {
    try {
      result = (Matrix *) &((SVD const *)arg1)->V();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_SVD_S(void * jarg1) {
  void * jresult ;
  SVD *arg1 = (SVD *) 0 ;
  Matrix result;
  
  arg1 = (SVD *)jarg1; 
  {
    try {
      result = ((SVD const *)arg1)->S();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Matrix((const Matrix &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_SVD_singularValues(void * jarg1) {
  void * jresult ;
  SVD *arg1 = (SVD *) 0 ;
  Array *result = 0 ;
  
  arg1 = (SVD *)jarg1; 
  {
    try {
      result = (Array *) &((SVD const *)arg1)->singularValues();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_SVD(void * jarg1) {
  SVD *arg1 = (SVD *) 0 ;
  
  arg1 = (SVD *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_UnaryFunction(void * jarg1) {
  void * jresult ;
  UnaryFunctionDelegate *arg1 = (UnaryFunctionDelegate *) 0 ;
  UnaryFunction *result = 0 ;
  
  arg1 = (UnaryFunctionDelegate *)jarg1; 
  {
    try {
      result = (UnaryFunction *)new UnaryFunction(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_UnaryFunction_call(void * jarg1, double jarg2) {
  double jresult ;
  UnaryFunction *arg1 = (UnaryFunction *) 0 ;
  Real arg2 ;
  Real result;
  
  arg1 = (UnaryFunction *)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)((UnaryFunction const *)arg1)->operator ()(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_UnaryFunction(void * jarg1) {
  UnaryFunction *arg1 = (UnaryFunction *) 0 ;
  
  arg1 = (UnaryFunction *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_UnaryFunctionDelegate(void * jarg1) {
  UnaryFunctionDelegate *arg1 = (UnaryFunctionDelegate *) 0 ;
  
  arg1 = (UnaryFunctionDelegate *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_UnaryFunctionDelegate_value(void * jarg1, double jarg2) {
  double jresult ;
  UnaryFunctionDelegate *arg1 = (UnaryFunctionDelegate *) 0 ;
  Real arg2 ;
  Real result;
  
  arg1 = (UnaryFunctionDelegate *)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)((UnaryFunctionDelegate const *)arg1)->value(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_UnaryFunctionDelegate_valueSwigExplicitUnaryFunctionDelegate(void * jarg1, double jarg2) {
  double jresult ;
  UnaryFunctionDelegate *arg1 = (UnaryFunctionDelegate *) 0 ;
  Real arg2 ;
  Real result;
  
  arg1 = (UnaryFunctionDelegate *)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)((UnaryFunctionDelegate const *)arg1)->UnaryFunctionDelegate::value(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_UnaryFunctionDelegate() {
  void * jresult ;
  UnaryFunctionDelegate *result = 0 ;
  
  {
    try {
      result = (UnaryFunctionDelegate *)new SwigDirector_UnaryFunctionDelegate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_UnaryFunctionDelegate_director_connect(void *objarg, SwigDirector_UnaryFunctionDelegate::SWIG_Callback0_t callback0) {
  UnaryFunctionDelegate *obj = (UnaryFunctionDelegate *)objarg;
  SwigDirector_UnaryFunctionDelegate *director = static_cast<SwigDirector_UnaryFunctionDelegate *>(obj);
  director->swig_connect_director(callback0);
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_DotNetCostFunction(void * jarg1) {
  void * jresult ;
  CostFunctionDelegate *arg1 = (CostFunctionDelegate *) 0 ;
  DotNetCostFunction *result = 0 ;
  
  arg1 = (CostFunctionDelegate *)jarg1; 
  {
    try {
      result = (DotNetCostFunction *)new DotNetCostFunction(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_DotNetCostFunction(void * jarg1) {
  DotNetCostFunction *arg1 = (DotNetCostFunction *) 0 ;
  
  arg1 = (DotNetCostFunction *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_DotNetCostFunction_value(void * jarg1, void * jarg2) {
  double jresult ;
  DotNetCostFunction *arg1 = (DotNetCostFunction *) 0 ;
  Array *arg2 = 0 ;
  Real result;
  
  arg1 = (DotNetCostFunction *)jarg1; 
  arg2 = (Array *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (Real)((DotNetCostFunction const *)arg1)->value((Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_DotNetCostFunction_values(void * jarg1, void * jarg2) {
  void * jresult ;
  DotNetCostFunction *arg1 = (DotNetCostFunction *) 0 ;
  Array *arg2 = 0 ;
  SwigValueWrapper< Disposable< Array > > result;
  
  arg1 = (DotNetCostFunction *)jarg1; 
  arg2 = (Array *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = ((DotNetCostFunction const *)arg1)->values((Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Disposable< Array >((const Disposable< Array > &)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_CostFunctionDelegate(void * jarg1) {
  CostFunctionDelegate *arg1 = (CostFunctionDelegate *) 0 ;
  
  arg1 = (CostFunctionDelegate *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_CostFunctionDelegate_value(void * jarg1, void * jarg2) {
  double jresult ;
  CostFunctionDelegate *arg1 = (CostFunctionDelegate *) 0 ;
  Array *arg2 = 0 ;
  Real result;
  
  arg1 = (CostFunctionDelegate *)jarg1; 
  arg2 = (Array *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (Real)((CostFunctionDelegate const *)arg1)->value((Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_CostFunctionDelegate_valueSwigExplicitCostFunctionDelegate(void * jarg1, void * jarg2) {
  double jresult ;
  CostFunctionDelegate *arg1 = (CostFunctionDelegate *) 0 ;
  Array *arg2 = 0 ;
  Real result;
  
  arg1 = (CostFunctionDelegate *)jarg1; 
  arg2 = (Array *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (Real)((CostFunctionDelegate const *)arg1)->CostFunctionDelegate::value((Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_CostFunctionDelegate_values(void * jarg1, void * jarg2) {
  void * jresult ;
  CostFunctionDelegate *arg1 = (CostFunctionDelegate *) 0 ;
  Array *arg2 = 0 ;
  Array result;
  
  arg1 = (CostFunctionDelegate *)jarg1; 
  arg2 = (Array *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = ((CostFunctionDelegate const *)arg1)->values((Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Array((const Array &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_CostFunctionDelegate_valuesSwigExplicitCostFunctionDelegate(void * jarg1, void * jarg2) {
  void * jresult ;
  CostFunctionDelegate *arg1 = (CostFunctionDelegate *) 0 ;
  Array *arg2 = 0 ;
  Array result;
  
  arg1 = (CostFunctionDelegate *)jarg1; 
  arg2 = (Array *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = ((CostFunctionDelegate const *)arg1)->CostFunctionDelegate::values((Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Array((const Array &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_CostFunctionDelegate() {
  void * jresult ;
  CostFunctionDelegate *result = 0 ;
  
  {
    try {
      result = (CostFunctionDelegate *)new SwigDirector_CostFunctionDelegate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_CostFunctionDelegate_director_connect(void *objarg, SwigDirector_CostFunctionDelegate::SWIG_Callback0_t callback0, SwigDirector_CostFunctionDelegate::SWIG_Callback1_t callback1) {
  CostFunctionDelegate *obj = (CostFunctionDelegate *)objarg;
  SwigDirector_CostFunctionDelegate *director = static_cast<SwigDirector_CostFunctionDelegate *>(obj);
  director->swig_connect_director(callback0, callback1);
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_Quote_value(void * jarg1) {
  double jresult ;
  Quote *arg1 = (Quote *) 0 ;
  boost::shared_ptr< Quote const > *smartarg1 = 0 ;
  Real result;
  
  
  smartarg1 = (boost::shared_ptr< const Quote > *)jarg1;
  arg1 = (Quote *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      result = (Real)((Quote const *)arg1)->value();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_Quote_isValid(void * jarg1) {
  unsigned int jresult ;
  Quote *arg1 = (Quote *) 0 ;
  boost::shared_ptr< Quote const > *smartarg1 = 0 ;
  bool result;
  
  
  smartarg1 = (boost::shared_ptr< const Quote > *)jarg1;
  arg1 = (Quote *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      result = (bool)((Quote const *)arg1)->isValid();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Quote(void * jarg1) {
  Quote *arg1 = (Quote *) 0 ;
  boost::shared_ptr< Quote > *smartarg1 = 0 ;
  
  
  smartarg1 = (boost::shared_ptr<  Quote > *)jarg1;
  arg1 = (Quote *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      (void)arg1; delete smartarg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_QuoteHandle__SWIG_0(void * jarg1) {
  void * jresult ;
  boost::shared_ptr< Quote > *arg1 = 0 ;
  boost::shared_ptr< Quote > tempnull1 ;
  Handle< Quote > *result = 0 ;
  
  arg1 = jarg1 ? (boost::shared_ptr< Quote > *)jarg1 : &tempnull1; 
  {
    try {
      result = (Handle< Quote > *)new Handle< Quote >((boost::shared_ptr< Quote > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_QuoteHandle__SWIG_1() {
  void * jresult ;
  Handle< Quote > *result = 0 ;
  
  {
    try {
      result = (Handle< Quote > *)new Handle< Quote >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_QuoteHandle___deref__(void * jarg1) {
  void * jresult ;
  Handle< Quote > *arg1 = (Handle< Quote > *) 0 ;
  boost::shared_ptr< Quote > result;
  
  arg1 = (Handle< Quote > *)jarg1; 
  {
    try {
      result = (arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result ? new boost::shared_ptr< Quote >(result) : 0; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_QuoteHandle_empty(void * jarg1) {
  unsigned int jresult ;
  Handle< Quote > *arg1 = (Handle< Quote > *) 0 ;
  bool result;
  
  arg1 = (Handle< Quote > *)jarg1; 
  {
    try {
      result = (bool)(arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_QuoteHandle_asObservable(void * jarg1) {
  void * jresult ;
  Handle< Quote > *arg1 = (Handle< Quote > *) 0 ;
  boost::shared_ptr< Observable > result;
  
  arg1 = (Handle< Quote > *)jarg1; 
  {
    try {
      result = Handle_Sl_Quote_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result ? new boost::shared_ptr< Observable >(result) : 0; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_QuoteHandle(void * jarg1) {
  Handle< Quote > *arg1 = (Handle< Quote > *) 0 ;
  
  arg1 = (Handle< Quote > *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_QuoteHandle_value(void * jarg1) {
  double jresult ;
  Handle< Quote > *arg1 = (Handle< Quote > *) 0 ;
  Real result;
  
  arg1 = (Handle< Quote > *)jarg1; 
  {
    try {
      result = (Real)(*arg1)->value();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_QuoteHandle_isValid(void * jarg1) {
  unsigned int jresult ;
  Handle< Quote > *arg1 = (Handle< Quote > *) 0 ;
  bool result;
  
  arg1 = (Handle< Quote > *)jarg1; 
  {
    try {
      result = (bool)(*arg1)->isValid();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_RelinkableQuoteHandle__SWIG_0(void * jarg1) {
  void * jresult ;
  boost::shared_ptr< Quote > *arg1 = 0 ;
  boost::shared_ptr< Quote > tempnull1 ;
  RelinkableHandle< Quote > *result = 0 ;
  
  arg1 = jarg1 ? (boost::shared_ptr< Quote > *)jarg1 : &tempnull1; 
  {
    try {
      result = (RelinkableHandle< Quote > *)new RelinkableHandle< Quote >((boost::shared_ptr< Quote > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_RelinkableQuoteHandle__SWIG_1() {
  void * jresult ;
  RelinkableHandle< Quote > *result = 0 ;
  
  {
    try {
      result = (RelinkableHandle< Quote > *)new RelinkableHandle< Quote >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandle_linkTo(void * jarg1, void * jarg2) {
  RelinkableHandle< Quote > *arg1 = (RelinkableHandle< Quote > *) 0 ;
  boost::shared_ptr< Quote > *arg2 = 0 ;
  boost::shared_ptr< Quote > tempnull2 ;
  
  arg1 = (RelinkableHandle< Quote > *)jarg1; 
  arg2 = jarg2 ? (boost::shared_ptr< Quote > *)jarg2 : &tempnull2; 
  {
    try {
      (arg1)->linkTo((boost::shared_ptr< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandle_reset(void * jarg1) {
  RelinkableHandle< Quote > *arg1 = (RelinkableHandle< Quote > *) 0 ;
  
  arg1 = (RelinkableHandle< Quote > *)jarg1; 
  {
    try {
      RelinkableHandle_Sl_Quote_Sg__reset(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_RelinkableQuoteHandle(void * jarg1) {
  RelinkableHandle< Quote > *arg1 = (RelinkableHandle< Quote > *) 0 ;
  
  arg1 = (RelinkableHandle< Quote > *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_SimpleQuote(double jarg1) {
  void * jresult ;
  Real arg1 ;
  SimpleQuote *result = 0 ;
  
  arg1 = (Real)jarg1; 
  {
    try {
      result = (SimpleQuote *)new SimpleQuote(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  
  jresult = result ? new boost::shared_ptr<  SimpleQuote >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_SimpleQuote_setValue(void * jarg1, double jarg2) {
  SimpleQuote *arg1 = (SimpleQuote *) 0 ;
  Real arg2 ;
  boost::shared_ptr< SimpleQuote > *smartarg1 = 0 ;
  
  
  smartarg1 = (boost::shared_ptr<  SimpleQuote > *)jarg1;
  arg1 = (SimpleQuote *)(smartarg1 ? smartarg1->get() : 0); 
  arg2 = (Real)jarg2; 
  {
    try {
      (arg1)->setValue(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_SimpleQuote(void * jarg1) {
  SimpleQuote *arg1 = (SimpleQuote *) 0 ;
  boost::shared_ptr< SimpleQuote > *smartarg1 = 0 ;
  
  
  smartarg1 = (boost::shared_ptr<  SimpleQuote > *)jarg1;
  arg1 = (SimpleQuote *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try {
      (void)arg1; delete smartarg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVector_Clear(void * jarg1) {
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVector_Add(void * jarg1, void * jarg2) {
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  boost::shared_ptr< Quote > *arg2 = 0 ;
  boost::shared_ptr< Quote > tempnull2 ;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  arg2 = jarg2 ? (boost::shared_ptr< Quote > *)jarg2 : &tempnull2; 
  {
    try {
      (arg1)->push_back((boost::shared_ptr< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_QuoteVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  std::vector< boost::shared_ptr< Quote > >::size_type result;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  {
    try {
      result = ((std::vector< boost::shared_ptr< Quote > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_QuoteVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  std::vector< boost::shared_ptr< Quote > >::size_type result;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  {
    try {
      result = ((std::vector< boost::shared_ptr< Quote > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  std::vector< boost::shared_ptr< Quote > >::size_type arg2 ;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  arg2 = (std::vector< boost::shared_ptr< Quote > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_QuoteVector__SWIG_0() {
  void * jresult ;
  std::vector< boost::shared_ptr< Quote > > *result = 0 ;
  
  {
    try {
      result = (std::vector< boost::shared_ptr< Quote > > *)new std::vector< boost::shared_ptr< Quote > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_QuoteVector__SWIG_1(void * jarg1) {
  void * jresult ;
  std::vector< boost::shared_ptr< Quote > > *arg1 = 0 ;
  std::vector< boost::shared_ptr< Quote > > *result = 0 ;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< boost::shared_ptr< Quote > > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (std::vector< boost::shared_ptr< Quote > > *)new std::vector< boost::shared_ptr< Quote > >((std::vector< boost::shared_ptr< Quote > > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_QuoteVector__SWIG_2(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector< boost::shared_ptr< Quote > > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector< boost::shared_ptr< Quote > > *)new_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg___SWIG_2(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_QuoteVector_getitemcopy(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  int arg2 ;
  boost::shared_ptr< Quote > result;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__getitemcopy(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result ? new boost::shared_ptr< Quote >(result) : 0; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_QuoteVector_getitem(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  int arg2 ;
  std::vector< boost::shared_ptr< Quote > >::value_type *result = 0 ;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< boost::shared_ptr< Quote > >::value_type *) &std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__getitem(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = *result ? new std::vector< boost::shared_ptr< Quote > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVector_setitem(void * jarg1, int jarg2, void * jarg3) {
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  int arg2 ;
  boost::shared_ptr< Quote > *arg3 = 0 ;
  boost::shared_ptr< Quote > tempnull3 ;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = jarg3 ? (boost::shared_ptr< Quote > *)jarg3 : &tempnull3; 
  {
    try {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__setitem(arg1,arg2,(boost::shared_ptr< Quote > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVector_AddRange(void * jarg1, void * jarg2) {
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  std::vector< boost::shared_ptr< Quote > > *arg2 = 0 ;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  arg2 = (std::vector< boost::shared_ptr< Quote > > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< boost::shared_ptr< Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__AddRange(arg1,(std::vector< boost::shared_ptr< Quote > > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_QuoteVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector< boost::shared_ptr< Quote > > *result = 0 ;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector< boost::shared_ptr< Quote > > *)std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__GetRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVector_Insert(void * jarg1, int jarg2, void * jarg3) {
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  int arg2 ;
  boost::shared_ptr< Quote > *arg3 = 0 ;
  boost::shared_ptr< Quote > tempnull3 ;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = jarg3 ? (boost::shared_ptr< Quote > *)jarg3 : &tempnull3; 
  {
    try {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Insert(arg1,arg2,(boost::shared_ptr< Quote > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  int arg2 ;
  std::vector< boost::shared_ptr< Quote > > *arg3 = 0 ;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< boost::shared_ptr< Quote > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< boost::shared_ptr< Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__InsertRange(arg1,arg2,(std::vector< boost::shared_ptr< Quote > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__RemoveAt(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__RemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_QuoteVector_Repeat(void * jarg1, int jarg2) {
  void * jresult ;
  boost::shared_ptr< Quote > *arg1 = 0 ;
  int arg2 ;
  boost::shared_ptr< Quote > tempnull1 ;
  std::vector< boost::shared_ptr< Quote > > *result = 0 ;
  
  arg1 = jarg1 ? (boost::shared_ptr< Quote > *)jarg1 : &tempnull1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< boost::shared_ptr< Quote > > *)std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Repeat((boost::shared_ptr< Quote > const &)*arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVector_Reverse__SWIG_0(void * jarg1) {
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  {
    try {
      std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  int arg2 ;
  std::vector< boost::shared_ptr< Quote > > *arg3 = 0 ;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< boost::shared_ptr< Quote > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< boost::shared_ptr< Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__SetRange(arg1,arg2,(std::vector< boost::shared_ptr< Quote > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_QuoteVector_Contains(void * jarg1, void * jarg2) {
  unsigned int jresult ;
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  boost::shared_ptr< Quote > *arg2 = 0 ;
  boost::shared_ptr< Quote > tempnull2 ;
  bool result;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  arg2 = jarg2 ? (boost::shared_ptr< Quote > *)jarg2 : &tempnull2; 
  {
    try {
      result = (bool)std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Contains(arg1,(boost::shared_ptr< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_QuoteVector_IndexOf(void * jarg1, void * jarg2) {
  int jresult ;
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  boost::shared_ptr< Quote > *arg2 = 0 ;
  boost::shared_ptr< Quote > tempnull2 ;
  int result;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  arg2 = jarg2 ? (boost::shared_ptr< Quote > *)jarg2 : &tempnull2; 
  {
    try {
      result = (int)std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__IndexOf(arg1,(boost::shared_ptr< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_QuoteVector_LastIndexOf(void * jarg1, void * jarg2) {
  int jresult ;
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  boost::shared_ptr< Quote > *arg2 = 0 ;
  boost::shared_ptr< Quote > tempnull2 ;
  int result;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  arg2 = jarg2 ? (boost::shared_ptr< Quote > *)jarg2 : &tempnull2; 
  {
    try {
      result = (int)std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__LastIndexOf(arg1,(boost::shared_ptr< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_QuoteVector_Remove(void * jarg1, void * jarg2) {
  unsigned int jresult ;
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  boost::shared_ptr< Quote > *arg2 = 0 ;
  boost::shared_ptr< Quote > tempnull2 ;
  bool result;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  arg2 = jarg2 ? (boost::shared_ptr< Quote > *)jarg2 : &tempnull2; 
  {
    try {
      result = (bool)std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Remove(arg1,(boost::shared_ptr< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_QuoteVector(void * jarg1) {
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVectorVector_Clear(void * jarg1) {
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  
  arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVectorVector_Add(void * jarg1, void * jarg2) {
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  std::vector< boost::shared_ptr< Quote > > *arg2 = 0 ;
  
  arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg1; 
  arg2 = (std::vector< boost::shared_ptr< Quote > > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< boost::shared_ptr< Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector< boost::shared_ptr< Quote > > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_QuoteVectorVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > >::size_type result;
  
  arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg1; 
  {
    try {
      result = ((std::vector< std::vector< boost::shared_ptr< Quote > > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_QuoteVectorVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > >::size_type result;
  
  arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg1; 
  {
    try {
      result = ((std::vector< std::vector< boost::shared_ptr< Quote > > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVectorVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > >::size_type arg2 ;
  
  arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg1; 
  arg2 = (std::vector< std::vector< boost::shared_ptr< Quote > > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_QuoteVectorVector__SWIG_0() {
  void * jresult ;
  std::vector< std::vector< boost::shared_ptr< Quote > > > *result = 0 ;
  
  {
    try {
      result = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)new std::vector< std::vector< boost::shared_ptr< Quote > > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_QuoteVectorVector__SWIG_1(void * jarg1) {
  void * jresult ;
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = 0 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > > *result = 0 ;
  
  arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::vector< boost::shared_ptr< Quote > > > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)new std::vector< std::vector< boost::shared_ptr< Quote > > >((std::vector< std::vector< boost::shared_ptr< Quote > > > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_QuoteVectorVector__SWIG_2(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)new_std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg___SWIG_2(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_QuoteVectorVector_getitemcopy(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< boost::shared_ptr< Quote > > result;
  
  arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__getitemcopy(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new std::vector< boost::shared_ptr< Quote > >((const std::vector< boost::shared_ptr< Quote > > &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_QuoteVectorVector_getitem(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > >::value_type *result = 0 ;
  
  arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< std::vector< boost::shared_ptr< Quote > > >::value_type *) &std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__getitem(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVectorVector_setitem(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< boost::shared_ptr< Quote > > *arg3 = 0 ;
  
  arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< boost::shared_ptr< Quote > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< boost::shared_ptr< Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__setitem(arg1,arg2,(std::vector< boost::shared_ptr< Quote > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVectorVector_AddRange(void * jarg1, void * jarg2) {
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg2 = 0 ;
  
  arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg1; 
  arg2 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::vector< boost::shared_ptr< Quote > > > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__AddRange(arg1,(std::vector< std::vector< boost::shared_ptr< Quote > > > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_QuoteVectorVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > > *result = 0 ;
  
  arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__GetRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVectorVector_Insert(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< boost::shared_ptr< Quote > > *arg3 = 0 ;
  
  arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< boost::shared_ptr< Quote > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< boost::shared_ptr< Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__Insert(arg1,arg2,(std::vector< boost::shared_ptr< Quote > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVectorVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg3 = 0 ;
  
  arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::vector< boost::shared_ptr< Quote > > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__InsertRange(arg1,arg2,(std::vector< std::vector< boost::shared_ptr< Quote > > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVectorVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__RemoveAt(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVectorVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__RemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_QuoteVectorVector_Repeat(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< boost::shared_ptr< Quote > > *arg1 = 0 ;
  int arg2 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > > *result = 0 ;
  
  arg1 = (std::vector< boost::shared_ptr< Quote > > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< boost::shared_ptr< Quote > > const & type is null", 0);
    return 0;
  } 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__Repeat((std::vector< boost::shared_ptr< Quote > > const &)*arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVectorVector_Reverse__SWIG_0(void * jarg1) {
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  
  arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg1; 
  {
    try {
      std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVectorVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteVectorVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg3 = 0 ;
  
  arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::vector< boost::shared_ptr< Quote > > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__SetRange(arg1,arg2,(std::vector< std::vector< boost::shared_ptr< Quote > > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_QuoteVectorVector(void * jarg1) {
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  
  arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_Clear(void * jarg1) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_Add(void * jarg1, void * jarg2) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  Handle< Quote > *arg2 = 0 ;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  arg2 = (Handle< Quote > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle< Quote > const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->push_back((Handle< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  std::vector< Handle< Quote > >::size_type result;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  {
    try {
      result = ((std::vector< Handle< Quote > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  std::vector< Handle< Quote > >::size_type result;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  {
    try {
      result = ((std::vector< Handle< Quote > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  std::vector< Handle< Quote > >::size_type arg2 ;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  arg2 = (std::vector< Handle< Quote > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_QuoteHandleVector__SWIG_0() {
  void * jresult ;
  std::vector< Handle< Quote > > *result = 0 ;
  
  {
    try {
      result = (std::vector< Handle< Quote > > *)new std::vector< Handle< Quote > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_QuoteHandleVector__SWIG_1(void * jarg1) {
  void * jresult ;
  std::vector< Handle< Quote > > *arg1 = 0 ;
  std::vector< Handle< Quote > > *result = 0 ;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< Handle< Quote > > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (std::vector< Handle< Quote > > *)new std::vector< Handle< Quote > >((std::vector< Handle< Quote > > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_QuoteHandleVector__SWIG_2(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector< Handle< Quote > > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector< Handle< Quote > > *)new_std_vector_Sl_Handle_Sl_Quote_Sg__Sg___SWIG_2(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_getitemcopy(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  int arg2 ;
  Handle< Quote > result;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_Handle_Sl_Quote_Sg__Sg__getitemcopy(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Handle< Quote >((const Handle< Quote > &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_getitem(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  int arg2 ;
  std::vector< Handle< Quote > >::value_type *result = 0 ;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< Handle< Quote > >::value_type *) &std_vector_Sl_Handle_Sl_Quote_Sg__Sg__getitem(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_setitem(void * jarg1, int jarg2, void * jarg3) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  int arg2 ;
  Handle< Quote > *arg3 = 0 ;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (Handle< Quote > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle< Quote > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Handle_Sl_Quote_Sg__Sg__setitem(arg1,arg2,(Handle< Quote > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_AddRange(void * jarg1, void * jarg2) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  std::vector< Handle< Quote > > *arg2 = 0 ;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  arg2 = (std::vector< Handle< Quote > > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< Handle< Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_Handle_Sl_Quote_Sg__Sg__AddRange(arg1,(std::vector< Handle< Quote > > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector< Handle< Quote > > *result = 0 ;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector< Handle< Quote > > *)std_vector_Sl_Handle_Sl_Quote_Sg__Sg__GetRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_Insert(void * jarg1, int jarg2, void * jarg3) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  int arg2 ;
  Handle< Quote > *arg3 = 0 ;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (Handle< Quote > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle< Quote > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Insert(arg1,arg2,(Handle< Quote > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  int arg2 ;
  std::vector< Handle< Quote > > *arg3 = 0 ;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< Handle< Quote > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< Handle< Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Handle_Sl_Quote_Sg__Sg__InsertRange(arg1,arg2,(std::vector< Handle< Quote > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_Handle_Sl_Quote_Sg__Sg__RemoveAt(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_Handle_Sl_Quote_Sg__Sg__RemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_Repeat(void * jarg1, int jarg2) {
  void * jresult ;
  Handle< Quote > *arg1 = 0 ;
  int arg2 ;
  std::vector< Handle< Quote > > *result = 0 ;
  
  arg1 = (Handle< Quote > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle< Quote > const & type is null", 0);
    return 0;
  } 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< Handle< Quote > > *)std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Repeat((Handle< Quote > const &)*arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_Reverse__SWIG_0(void * jarg1) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  {
    try {
      std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  int arg2 ;
  std::vector< Handle< Quote > > *arg3 = 0 ;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< Handle< Quote > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< Handle< Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Handle_Sl_Quote_Sg__Sg__SetRange(arg1,arg2,(std::vector< Handle< Quote > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_Contains(void * jarg1, void * jarg2) {
  unsigned int jresult ;
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  Handle< Quote > *arg2 = 0 ;
  bool result;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  arg2 = (Handle< Quote > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle< Quote > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (bool)std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Contains(arg1,(Handle< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_IndexOf(void * jarg1, void * jarg2) {
  int jresult ;
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  Handle< Quote > *arg2 = 0 ;
  int result;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  arg2 = (Handle< Quote > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle< Quote > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (int)std_vector_Sl_Handle_Sl_Quote_Sg__Sg__IndexOf(arg1,(Handle< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_LastIndexOf(void * jarg1, void * jarg2) {
  int jresult ;
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  Handle< Quote > *arg2 = 0 ;
  int result;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  arg2 = (Handle< Quote > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle< Quote > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (int)std_vector_Sl_Handle_Sl_Quote_Sg__Sg__LastIndexOf(arg1,(Handle< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_QuoteHandleVector_Remove(void * jarg1, void * jarg2) {
  unsigned int jresult ;
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  Handle< Quote > *arg2 = 0 ;
  bool result;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  arg2 = (Handle< Quote > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle< Quote > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (bool)std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Remove(arg1,(Handle< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_QuoteHandleVector(void * jarg1) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVectorVector_Clear(void * jarg1) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  
  arg1 = (std::vector< std::vector< Handle< Quote > > > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVectorVector_Add(void * jarg1, void * jarg2) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  std::vector< Handle< Quote > > *arg2 = 0 ;
  
  arg1 = (std::vector< std::vector< Handle< Quote > > > *)jarg1; 
  arg2 = (std::vector< Handle< Quote > > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< Handle< Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector< Handle< Quote > > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_QuoteHandleVectorVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  std::vector< std::vector< Handle< Quote > > >::size_type result;
  
  arg1 = (std::vector< std::vector< Handle< Quote > > > *)jarg1; 
  {
    try {
      result = ((std::vector< std::vector< Handle< Quote > > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_QuoteHandleVectorVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  std::vector< std::vector< Handle< Quote > > >::size_type result;
  
  arg1 = (std::vector< std::vector< Handle< Quote > > > *)jarg1; 
  {
    try {
      result = ((std::vector< std::vector< Handle< Quote > > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVectorVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  std::vector< std::vector< Handle< Quote > > >::size_type arg2 ;
  
  arg1 = (std::vector< std::vector< Handle< Quote > > > *)jarg1; 
  arg2 = (std::vector< std::vector< Handle< Quote > > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_QuoteHandleVectorVector__SWIG_0() {
  void * jresult ;
  std::vector< std::vector< Handle< Quote > > > *result = 0 ;
  
  {
    try {
      result = (std::vector< std::vector< Handle< Quote > > > *)new std::vector< std::vector< Handle< Quote > > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_QuoteHandleVectorVector__SWIG_1(void * jarg1) {
  void * jresult ;
  std::vector< std::vector< Handle< Quote > > > *arg1 = 0 ;
  std::vector< std::vector< Handle< Quote > > > *result = 0 ;
  
  arg1 = (std::vector< std::vector< Handle< Quote > > > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::vector< Handle< Quote > > > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (std::vector< std::vector< Handle< Quote > > > *)new std::vector< std::vector< Handle< Quote > > >((std::vector< std::vector< Handle< Quote > > > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_QuoteHandleVectorVector__SWIG_2(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector< std::vector< Handle< Quote > > > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector< std::vector< Handle< Quote > > > *)new_std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg___SWIG_2(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_QuoteHandleVectorVector_getitemcopy(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< Handle< Quote > > result;
  
  arg1 = (std::vector< std::vector< Handle< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__getitemcopy(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new std::vector< Handle< Quote > >((const std::vector< Handle< Quote > > &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_QuoteHandleVectorVector_getitem(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< std::vector< Handle< Quote > > >::value_type *result = 0 ;
  
  arg1 = (std::vector< std::vector< Handle< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< std::vector< Handle< Quote > > >::value_type *) &std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__getitem(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVectorVector_setitem(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< Handle< Quote > > *arg3 = 0 ;
  
  arg1 = (std::vector< std::vector< Handle< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< Handle< Quote > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< Handle< Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__setitem(arg1,arg2,(std::vector< Handle< Quote > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVectorVector_AddRange(void * jarg1, void * jarg2) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  std::vector< std::vector< Handle< Quote > > > *arg2 = 0 ;
  
  arg1 = (std::vector< std::vector< Handle< Quote > > > *)jarg1; 
  arg2 = (std::vector< std::vector< Handle< Quote > > > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::vector< Handle< Quote > > > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__AddRange(arg1,(std::vector< std::vector< Handle< Quote > > > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_QuoteHandleVectorVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector< std::vector< Handle< Quote > > > *result = 0 ;
  
  arg1 = (std::vector< std::vector< Handle< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector< std::vector< Handle< Quote > > > *)std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__GetRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVectorVector_Insert(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< Handle< Quote > > *arg3 = 0 ;
  
  arg1 = (std::vector< std::vector< Handle< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< Handle< Quote > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< Handle< Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__Insert(arg1,arg2,(std::vector< Handle< Quote > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVectorVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< std::vector< Handle< Quote > > > *arg3 = 0 ;
  
  arg1 = (std::vector< std::vector< Handle< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< std::vector< Handle< Quote > > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::vector< Handle< Quote > > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__InsertRange(arg1,arg2,(std::vector< std::vector< Handle< Quote > > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVectorVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector< std::vector< Handle< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__RemoveAt(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVectorVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< std::vector< Handle< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__RemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_QuoteHandleVectorVector_Repeat(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< Handle< Quote > > *arg1 = 0 ;
  int arg2 ;
  std::vector< std::vector< Handle< Quote > > > *result = 0 ;
  
  arg1 = (std::vector< Handle< Quote > > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< Handle< Quote > > const & type is null", 0);
    return 0;
  } 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< std::vector< Handle< Quote > > > *)std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__Repeat((std::vector< Handle< Quote > > const &)*arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVectorVector_Reverse__SWIG_0(void * jarg1) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  
  arg1 = (std::vector< std::vector< Handle< Quote > > > *)jarg1; 
  {
    try {
      std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVectorVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< std::vector< Handle< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_QuoteHandleVectorVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< std::vector< Handle< Quote > > > *arg3 = 0 ;
  
  arg1 = (std::vector< std::vector< Handle< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< std::vector< Handle< Quote > > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::vector< Handle< Quote > > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__SetRange(arg1,arg2,(std::vector< std::vector< Handle< Quote > > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_QuoteHandleVectorVector(void * jarg1) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  
  arg1 = (std::vector< std::vector< Handle< Quote > > > *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_Clear(void * jarg1) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_Add(void * jarg1, void * jarg2) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  RelinkableHandle< Quote > *arg2 = 0 ;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  arg2 = (RelinkableHandle< Quote > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "RelinkableHandle< Quote > const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->push_back((RelinkableHandle< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  std::vector< RelinkableHandle< Quote > >::size_type result;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  {
    try {
      result = ((std::vector< RelinkableHandle< Quote > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  std::vector< RelinkableHandle< Quote > >::size_type result;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  {
    try {
      result = ((std::vector< RelinkableHandle< Quote > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  std::vector< RelinkableHandle< Quote > >::size_type arg2 ;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  arg2 = (std::vector< RelinkableHandle< Quote > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_RelinkableQuoteHandleVector__SWIG_0() {
  void * jresult ;
  std::vector< RelinkableHandle< Quote > > *result = 0 ;
  
  {
    try {
      result = (std::vector< RelinkableHandle< Quote > > *)new std::vector< RelinkableHandle< Quote > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_RelinkableQuoteHandleVector__SWIG_1(void * jarg1) {
  void * jresult ;
  std::vector< RelinkableHandle< Quote > > *arg1 = 0 ;
  std::vector< RelinkableHandle< Quote > > *result = 0 ;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< RelinkableHandle< Quote > > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (std::vector< RelinkableHandle< Quote > > *)new std::vector< RelinkableHandle< Quote > >((std::vector< RelinkableHandle< Quote > > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_RelinkableQuoteHandleVector__SWIG_2(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector< RelinkableHandle< Quote > > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector< RelinkableHandle< Quote > > *)new_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg___SWIG_2(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_getitemcopy(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  int arg2 ;
  RelinkableHandle< Quote > result;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__getitemcopy(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new RelinkableHandle< Quote >((const RelinkableHandle< Quote > &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_getitem(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  int arg2 ;
  std::vector< RelinkableHandle< Quote > >::value_type *result = 0 ;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< RelinkableHandle< Quote > >::value_type *) &std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__getitem(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_setitem(void * jarg1, int jarg2, void * jarg3) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  int arg2 ;
  RelinkableHandle< Quote > *arg3 = 0 ;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (RelinkableHandle< Quote > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "RelinkableHandle< Quote > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__setitem(arg1,arg2,(RelinkableHandle< Quote > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_AddRange(void * jarg1, void * jarg2) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  std::vector< RelinkableHandle< Quote > > *arg2 = 0 ;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  arg2 = (std::vector< RelinkableHandle< Quote > > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< RelinkableHandle< Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__AddRange(arg1,(std::vector< RelinkableHandle< Quote > > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector< RelinkableHandle< Quote > > *result = 0 ;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector< RelinkableHandle< Quote > > *)std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__GetRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_Insert(void * jarg1, int jarg2, void * jarg3) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  int arg2 ;
  RelinkableHandle< Quote > *arg3 = 0 ;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (RelinkableHandle< Quote > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "RelinkableHandle< Quote > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Insert(arg1,arg2,(RelinkableHandle< Quote > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  int arg2 ;
  std::vector< RelinkableHandle< Quote > > *arg3 = 0 ;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< RelinkableHandle< Quote > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< RelinkableHandle< Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__InsertRange(arg1,arg2,(std::vector< RelinkableHandle< Quote > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__RemoveAt(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__RemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_Repeat(void * jarg1, int jarg2) {
  void * jresult ;
  RelinkableHandle< Quote > *arg1 = 0 ;
  int arg2 ;
  std::vector< RelinkableHandle< Quote > > *result = 0 ;
  
  arg1 = (RelinkableHandle< Quote > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "RelinkableHandle< Quote > const & type is null", 0);
    return 0;
  } 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< RelinkableHandle< Quote > > *)std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Repeat((RelinkableHandle< Quote > const &)*arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_Reverse__SWIG_0(void * jarg1) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  {
    try {
      std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  int arg2 ;
  std::vector< RelinkableHandle< Quote > > *arg3 = 0 ;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< RelinkableHandle< Quote > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< RelinkableHandle< Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__SetRange(arg1,arg2,(std::vector< RelinkableHandle< Quote > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_Contains(void * jarg1, void * jarg2) {
  unsigned int jresult ;
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  RelinkableHandle< Quote > *arg2 = 0 ;
  bool result;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  arg2 = (RelinkableHandle< Quote > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "RelinkableHandle< Quote > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (bool)std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Contains(arg1,(RelinkableHandle< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_IndexOf(void * jarg1, void * jarg2) {
  int jresult ;
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  RelinkableHandle< Quote > *arg2 = 0 ;
  int result;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  arg2 = (RelinkableHandle< Quote > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "RelinkableHandle< Quote > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (int)std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__IndexOf(arg1,(RelinkableHandle< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_LastIndexOf(void * jarg1, void * jarg2) {
  int jresult ;
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  RelinkableHandle< Quote > *arg2 = 0 ;
  int result;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  arg2 = (RelinkableHandle< Quote > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "RelinkableHandle< Quote > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (int)std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__LastIndexOf(arg1,(RelinkableHandle< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVector_Remove(void * jarg1, void * jarg2) {
  unsigned int jresult ;
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  RelinkableHandle< Quote > *arg2 = 0 ;
  bool result;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  arg2 = (RelinkableHandle< Quote > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "RelinkableHandle< Quote > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (bool)std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Remove(arg1,(RelinkableHandle< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_RelinkableQuoteHandleVector(void * jarg1) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVectorVector_Clear(void * jarg1) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  
  arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVectorVector_Add(void * jarg1, void * jarg2) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  std::vector< RelinkableHandle< Quote > > *arg2 = 0 ;
  
  arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg1; 
  arg2 = (std::vector< RelinkableHandle< Quote > > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< RelinkableHandle< Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector< RelinkableHandle< Quote > > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVectorVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > >::size_type result;
  
  arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg1; 
  {
    try {
      result = ((std::vector< std::vector< RelinkableHandle< Quote > > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVectorVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > >::size_type result;
  
  arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg1; 
  {
    try {
      result = ((std::vector< std::vector< RelinkableHandle< Quote > > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (unsigned long)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVectorVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > >::size_type arg2 ;
  
  arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg1; 
  arg2 = (std::vector< std::vector< RelinkableHandle< Quote > > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_RelinkableQuoteHandleVectorVector__SWIG_0() {
  void * jresult ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *result = 0 ;
  
  {
    try {
      result = (std::vector< std::vector< RelinkableHandle< Quote > > > *)new std::vector< std::vector< RelinkableHandle< Quote > > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_RelinkableQuoteHandleVectorVector__SWIG_1(void * jarg1) {
  void * jresult ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *result = 0 ;
  
  arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::vector< RelinkableHandle< Quote > > > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (std::vector< std::vector< RelinkableHandle< Quote > > > *)new std::vector< std::vector< RelinkableHandle< Quote > > >((std::vector< std::vector< RelinkableHandle< Quote > > > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_RelinkableQuoteHandleVectorVector__SWIG_2(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector< std::vector< RelinkableHandle< Quote > > > *)new_std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg___SWIG_2(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVectorVector_getitemcopy(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< RelinkableHandle< Quote > > result;
  
  arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__getitemcopy(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new std::vector< RelinkableHandle< Quote > >((const std::vector< RelinkableHandle< Quote > > &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVectorVector_getitem(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< std::vector< RelinkableHandle< Quote > > >::value_type *result = 0 ;
  
  arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< std::vector< RelinkableHandle< Quote > > >::value_type *) &std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__getitem(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVectorVector_setitem(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< RelinkableHandle< Quote > > *arg3 = 0 ;
  
  arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< RelinkableHandle< Quote > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< RelinkableHandle< Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__setitem(arg1,arg2,(std::vector< RelinkableHandle< Quote > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVectorVector_AddRange(void * jarg1, void * jarg2) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg2 = 0 ;
  
  arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg1; 
  arg2 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::vector< RelinkableHandle< Quote > > > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__AddRange(arg1,(std::vector< std::vector< RelinkableHandle< Quote > > > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVectorVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *result = 0 ;
  
  arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector< std::vector< RelinkableHandle< Quote > > > *)std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__GetRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVectorVector_Insert(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< RelinkableHandle< Quote > > *arg3 = 0 ;
  
  arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< RelinkableHandle< Quote > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< RelinkableHandle< Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__Insert(arg1,arg2,(std::vector< RelinkableHandle< Quote > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVectorVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg3 = 0 ;
  
  arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::vector< RelinkableHandle< Quote > > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__InsertRange(arg1,arg2,(std::vector< std::vector< RelinkableHandle< Quote > > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVectorVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__RemoveAt(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVectorVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__RemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVectorVector_Repeat(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector< RelinkableHandle< Quote > > *arg1 = 0 ;
  int arg2 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *result = 0 ;
  
  arg1 = (std::vector< RelinkableHandle< Quote > > *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< RelinkableHandle< Quote > > const & type is null", 0);
    return 0;
  } 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< std::vector< RelinkableHandle< Quote > > > *)std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__Repeat((std::vector< RelinkableHandle< Quote > > const &)*arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVectorVector_Reverse__SWIG_0(void * jarg1) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  
  arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg1; 
  {
    try {
      std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVectorVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      } catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_RelinkableQuoteHandleVectorVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg3 = 0 ;
  
  arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector< std::vector< RelinkableHandle< Quote > > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__SetRange(arg1,arg2,(std::vector< std::vector< RelinkableHandle< Quote > > > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_RelinkableQuoteHandleVectorVector(void * jarg1) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  
  arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_Calendar_isWeekend(void * jarg1, int jarg2) {
  unsigned int jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Weekday arg2 ;
  bool result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Weekday)jarg2; 
  {
    try {
      result = (bool)(arg1)->isWeekend(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Calendar_endOfMonth(void * jarg1, void * jarg2) {
  void * jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (arg1)->endOfMonth((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_Calendar_isBusinessDay(void * jarg1, void * jarg2) {
  unsigned int jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  bool result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (bool)(arg1)->isBusinessDay((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_Calendar_isHoliday(void * jarg1, void * jarg2) {
  unsigned int jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  bool result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (bool)(arg1)->isHoliday((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuantLib_Calendar_isEndOfMonth(void * jarg1, void * jarg2) {
  unsigned int jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  bool result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (bool)(arg1)->isEndOfMonth((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_Calendar_addHoliday(void * jarg1, void * jarg2) {
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->addHoliday((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_Calendar_removeHoliday(void * jarg1, void * jarg2) {
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->removeHoliday((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Calendar_adjust__SWIG_0(void * jarg1, void * jarg2, int jarg3) {
  void * jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  BusinessDayConvention arg3 ;
  Date result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (BusinessDayConvention)jarg3; 
  {
    try {
      result = (arg1)->adjust((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Calendar_adjust__SWIG_1(void * jarg1, void * jarg2) {
  void * jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (arg1)->adjust((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Calendar_advance__SWIG_0(void * jarg1, void * jarg2, int jarg3, int jarg4, int jarg5, unsigned int jarg6) {
  void * jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Integer arg3 ;
  TimeUnit arg4 ;
  BusinessDayConvention arg5 ;
  bool arg6 ;
  Date result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Integer)jarg3; 
  arg4 = (TimeUnit)jarg4; 
  arg5 = (BusinessDayConvention)jarg5; 
  arg6 = jarg6 ? true : false; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,arg3,arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Calendar_advance__SWIG_1(void * jarg1, void * jarg2, int jarg3, int jarg4, int jarg5) {
  void * jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Integer arg3 ;
  TimeUnit arg4 ;
  BusinessDayConvention arg5 ;
  Date result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Integer)jarg3; 
  arg4 = (TimeUnit)jarg4; 
  arg5 = (BusinessDayConvention)jarg5; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Calendar_advance__SWIG_2(void * jarg1, void * jarg2, int jarg3, int jarg4) {
  void * jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Integer arg3 ;
  TimeUnit arg4 ;
  Date result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Integer)jarg3; 
  arg4 = (TimeUnit)jarg4; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Calendar_advance__SWIG_3(void * jarg1, void * jarg2, void * jarg3, int jarg4, unsigned int jarg5) {
  void * jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Period *arg3 = 0 ;
  BusinessDayConvention arg4 ;
  bool arg5 ;
  Date result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Period *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Period const & type is null", 0);
    return 0;
  } 
  arg4 = (BusinessDayConvention)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Calendar_advance__SWIG_4(void * jarg1, void * jarg2, void * jarg3, int jarg4) {
  void * jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Period *arg3 = 0 ;
  BusinessDayConvention arg4 ;
  Date result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Period *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Period const & type is null", 0);
    return 0;
  } 
  arg4 = (BusinessDayConvention)jarg4; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Calendar_advance__SWIG_5(void * jarg1, void * jarg2, void * jarg3) {
  void * jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Period *arg3 = 0 ;
  Date result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Period *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Period const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT long SWIGSTDCALL CSharp_QuantLib_Calendar_businessDaysBetween__SWIG_0(void * jarg1, void * jarg2, void * jarg3, unsigned int jarg4, unsigned int jarg5) {
  long jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  bool arg4 ;
  bool arg5 ;
  BigInteger result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = jarg4 ? true : false; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (BigInteger)(arg1)->businessDaysBetween((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT long SWIGSTDCALL CSharp_QuantLib_Calendar_businessDaysBetween__SWIG_1(void * jarg1, void * jarg2, void * jarg3, unsigned int jarg4) {
  long jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  bool arg4 ;
  BigInteger result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (BigInteger)(arg1)->businessDaysBetween((Date const &)*arg2,(Date const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT long SWIGSTDCALL CSharp_QuantLib_Calendar_businessDaysBetween__SWIG_2(void * jarg1, void * jarg2, void * jarg3) {
  long jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  BigInteger result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (BigInteger)(arg1)->businessDaysBetween((Date const &)*arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Calendar_holidayList__SWIG_0(void * jarg1, void * jarg2, void * jarg3, unsigned int jarg4) {
  void * jresult ;
  Calendar *arg1 = 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  bool arg4 ;
  std::vector< Date > result;
  
  arg1 = (Calendar *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = Calendar::holidayList((Calendar const &)*arg1,(Date const &)*arg2,(Date const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new std::vector< Date >((const std::vector< Date > &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_Calendar_holidayList__SWIG_1(void * jarg1, void * jarg2, void * jarg3) {
  void * jresult ;
  Calendar *arg1 = 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  std::vector< Date > result;
  
  arg1 = (Calendar *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = Calendar::holidayList((Calendar const &)*arg1,(Date const &)*arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new std::vector< Date >((const std::vector< Date > &)result); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_Calendar_name(void * jarg1) {
  char * jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  std::string result;
  
  arg1 = (Calendar *)jarg1; 
  {
    try {
      result = (arg1)->name();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_Calendar___str__(void * jarg1) {
  char * jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  std::string result;
  
  arg1 = (Calendar *)jarg1; 
  {
    try {
      result = Calendar___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Calendar(void * jarg1) {
  Calendar *arg1 = (Calendar *) 0 ;
  
  arg1 = (Calendar *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Argentina__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Argentina::Market arg1 ;
  QuantLib::Argentina *result = 0 ;
  
  arg1 = (QuantLib::Argentina::Market)jarg1; 
  {
    try {
      result = (QuantLib::Argentina *)new QuantLib::Argentina(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Argentina__SWIG_1() {
  void * jresult ;
  QuantLib::Argentina *result = 0 ;
  
  {
    try {
      result = (QuantLib::Argentina *)new QuantLib::Argentina();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Argentina(void * jarg1) {
  QuantLib::Argentina *arg1 = (QuantLib::Argentina *) 0 ;
  
  arg1 = (QuantLib::Argentina *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Australia() {
  void * jresult ;
  QuantLib::Australia *result = 0 ;
  
  {
    try {
      result = (QuantLib::Australia *)new QuantLib::Australia();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Australia(void * jarg1) {
  QuantLib::Australia *arg1 = (QuantLib::Australia *) 0 ;
  
  arg1 = (QuantLib::Australia *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Brazil__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Brazil::Market arg1 ;
  QuantLib::Brazil *result = 0 ;
  
  arg1 = (QuantLib::Brazil::Market)jarg1; 
  {
    try {
      result = (QuantLib::Brazil *)new QuantLib::Brazil(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Brazil__SWIG_1() {
  void * jresult ;
  QuantLib::Brazil *result = 0 ;
  
  {
    try {
      result = (QuantLib::Brazil *)new QuantLib::Brazil();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Brazil(void * jarg1) {
  QuantLib::Brazil *arg1 = (QuantLib::Brazil *) 0 ;
  
  arg1 = (QuantLib::Brazil *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Canada__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Canada::Market arg1 ;
  QuantLib::Canada *result = 0 ;
  
  arg1 = (QuantLib::Canada::Market)jarg1; 
  {
    try {
      result = (QuantLib::Canada *)new QuantLib::Canada(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Canada__SWIG_1() {
  void * jresult ;
  QuantLib::Canada *result = 0 ;
  
  {
    try {
      result = (QuantLib::Canada *)new QuantLib::Canada();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Canada(void * jarg1) {
  QuantLib::Canada *arg1 = (QuantLib::Canada *) 0 ;
  
  arg1 = (QuantLib::Canada *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_China__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::China::Market arg1 ;
  QuantLib::China *result = 0 ;
  
  arg1 = (QuantLib::China::Market)jarg1; 
  {
    try {
      result = (QuantLib::China *)new QuantLib::China(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_China__SWIG_1() {
  void * jresult ;
  QuantLib::China *result = 0 ;
  
  {
    try {
      result = (QuantLib::China *)new QuantLib::China();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_China(void * jarg1) {
  QuantLib::China *arg1 = (QuantLib::China *) 0 ;
  
  arg1 = (QuantLib::China *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_CzechRepublic__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::CzechRepublic::Market arg1 ;
  QuantLib::CzechRepublic *result = 0 ;
  
  arg1 = (QuantLib::CzechRepublic::Market)jarg1; 
  {
    try {
      result = (QuantLib::CzechRepublic *)new QuantLib::CzechRepublic(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_CzechRepublic__SWIG_1() {
  void * jresult ;
  QuantLib::CzechRepublic *result = 0 ;
  
  {
    try {
      result = (QuantLib::CzechRepublic *)new QuantLib::CzechRepublic();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_CzechRepublic(void * jarg1) {
  QuantLib::CzechRepublic *arg1 = (QuantLib::CzechRepublic *) 0 ;
  
  arg1 = (QuantLib::CzechRepublic *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Denmark() {
  void * jresult ;
  QuantLib::Denmark *result = 0 ;
  
  {
    try {
      result = (QuantLib::Denmark *)new QuantLib::Denmark();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Denmark(void * jarg1) {
  QuantLib::Denmark *arg1 = (QuantLib::Denmark *) 0 ;
  
  arg1 = (QuantLib::Denmark *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Finland() {
  void * jresult ;
  QuantLib::Finland *result = 0 ;
  
  {
    try {
      result = (QuantLib::Finland *)new QuantLib::Finland();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Finland(void * jarg1) {
  QuantLib::Finland *arg1 = (QuantLib::Finland *) 0 ;
  
  arg1 = (QuantLib::Finland *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Germany__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Germany::Market arg1 ;
  QuantLib::Germany *result = 0 ;
  
  arg1 = (QuantLib::Germany::Market)jarg1; 
  {
    try {
      result = (QuantLib::Germany *)new QuantLib::Germany(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Germany__SWIG_1() {
  void * jresult ;
  QuantLib::Germany *result = 0 ;
  
  {
    try {
      result = (QuantLib::Germany *)new QuantLib::Germany();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Germany(void * jarg1) {
  QuantLib::Germany *arg1 = (QuantLib::Germany *) 0 ;
  
  arg1 = (QuantLib::Germany *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_HongKong__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::HongKong::Market arg1 ;
  QuantLib::HongKong *result = 0 ;
  
  arg1 = (QuantLib::HongKong::Market)jarg1; 
  {
    try {
      result = (QuantLib::HongKong *)new QuantLib::HongKong(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_HongKong__SWIG_1() {
  void * jresult ;
  QuantLib::HongKong *result = 0 ;
  
  {
    try {
      result = (QuantLib::HongKong *)new QuantLib::HongKong();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_HongKong(void * jarg1) {
  QuantLib::HongKong *arg1 = (QuantLib::HongKong *) 0 ;
  
  arg1 = (QuantLib::HongKong *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Hungary() {
  void * jresult ;
  QuantLib::Hungary *result = 0 ;
  
  {
    try {
      result = (QuantLib::Hungary *)new QuantLib::Hungary();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Hungary(void * jarg1) {
  QuantLib::Hungary *arg1 = (QuantLib::Hungary *) 0 ;
  
  arg1 = (QuantLib::Hungary *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Iceland__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Iceland::Market arg1 ;
  QuantLib::Iceland *result = 0 ;
  
  arg1 = (QuantLib::Iceland::Market)jarg1; 
  {
    try {
      result = (QuantLib::Iceland *)new QuantLib::Iceland(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Iceland__SWIG_1() {
  void * jresult ;
  QuantLib::Iceland *result = 0 ;
  
  {
    try {
      result = (QuantLib::Iceland *)new QuantLib::Iceland();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Iceland(void * jarg1) {
  QuantLib::Iceland *arg1 = (QuantLib::Iceland *) 0 ;
  
  arg1 = (QuantLib::Iceland *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_India__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::India::Market arg1 ;
  QuantLib::India *result = 0 ;
  
  arg1 = (QuantLib::India::Market)jarg1; 
  {
    try {
      result = (QuantLib::India *)new QuantLib::India(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_India__SWIG_1() {
  void * jresult ;
  QuantLib::India *result = 0 ;
  
  {
    try {
      result = (QuantLib::India *)new QuantLib::India();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_India(void * jarg1) {
  QuantLib::India *arg1 = (QuantLib::India *) 0 ;
  
  arg1 = (QuantLib::India *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Indonesia__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Indonesia::Market arg1 ;
  QuantLib::Indonesia *result = 0 ;
  
  arg1 = (QuantLib::Indonesia::Market)jarg1; 
  {
    try {
      result = (QuantLib::Indonesia *)new QuantLib::Indonesia(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Indonesia__SWIG_1() {
  void * jresult ;
  QuantLib::Indonesia *result = 0 ;
  
  {
    try {
      result = (QuantLib::Indonesia *)new QuantLib::Indonesia();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Indonesia(void * jarg1) {
  QuantLib::Indonesia *arg1 = (QuantLib::Indonesia *) 0 ;
  
  arg1 = (QuantLib::Indonesia *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Israel__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Israel::Market arg1 ;
  QuantLib::Israel *result = 0 ;
  
  arg1 = (QuantLib::Israel::Market)jarg1; 
  {
    try {
      result = (QuantLib::Israel *)new QuantLib::Israel(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Israel__SWIG_1() {
  void * jresult ;
  QuantLib::Israel *result = 0 ;
  
  {
    try {
      result = (QuantLib::Israel *)new QuantLib::Israel();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Israel(void * jarg1) {
  QuantLib::Israel *arg1 = (QuantLib::Israel *) 0 ;
  
  arg1 = (QuantLib::Israel *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Italy__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Italy::Market arg1 ;
  QuantLib::Italy *result = 0 ;
  
  arg1 = (QuantLib::Italy::Market)jarg1; 
  {
    try {
      result = (QuantLib::Italy *)new QuantLib::Italy(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Italy__SWIG_1() {
  void * jresult ;
  QuantLib::Italy *result = 0 ;
  
  {
    try {
      result = (QuantLib::Italy *)new QuantLib::Italy();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Italy(void * jarg1) {
  QuantLib::Italy *arg1 = (QuantLib::Italy *) 0 ;
  
  arg1 = (QuantLib::Italy *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Japan() {
  void * jresult ;
  QuantLib::Japan *result = 0 ;
  
  {
    try {
      result = (QuantLib::Japan *)new QuantLib::Japan();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Japan(void * jarg1) {
  QuantLib::Japan *arg1 = (QuantLib::Japan *) 0 ;
  
  arg1 = (QuantLib::Japan *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Mexico__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Mexico::Market arg1 ;
  QuantLib::Mexico *result = 0 ;
  
  arg1 = (QuantLib::Mexico::Market)jarg1; 
  {
    try {
      result = (QuantLib::Mexico *)new QuantLib::Mexico(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Mexico__SWIG_1() {
  void * jresult ;
  QuantLib::Mexico *result = 0 ;
  
  {
    try {
      result = (QuantLib::Mexico *)new QuantLib::Mexico();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Mexico(void * jarg1) {
  QuantLib::Mexico *arg1 = (QuantLib::Mexico *) 0 ;
  
  arg1 = (QuantLib::Mexico *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_NewZealand() {
  void * jresult ;
  QuantLib::NewZealand *result = 0 ;
  
  {
    try {
      result = (QuantLib::NewZealand *)new QuantLib::NewZealand();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_NewZealand(void * jarg1) {
  QuantLib::NewZealand *arg1 = (QuantLib::NewZealand *) 0 ;
  
  arg1 = (QuantLib::NewZealand *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Norway() {
  void * jresult ;
  QuantLib::Norway *result = 0 ;
  
  {
    try {
      result = (QuantLib::Norway *)new QuantLib::Norway();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Norway(void * jarg1) {
  QuantLib::Norway *arg1 = (QuantLib::Norway *) 0 ;
  
  arg1 = (QuantLib::Norway *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Poland() {
  void * jresult ;
  QuantLib::Poland *result = 0 ;
  
  {
    try {
      result = (QuantLib::Poland *)new QuantLib::Poland();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Poland(void * jarg1) {
  QuantLib::Poland *arg1 = (QuantLib::Poland *) 0 ;
  
  arg1 = (QuantLib::Poland *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Russia__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Russia::Market arg1 ;
  QuantLib::Russia *result = 0 ;
  
  arg1 = (QuantLib::Russia::Market)jarg1; 
  {
    try {
      result = (QuantLib::Russia *)new QuantLib::Russia(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Russia__SWIG_1() {
  void * jresult ;
  QuantLib::Russia *result = 0 ;
  
  {
    try {
      result = (QuantLib::Russia *)new QuantLib::Russia();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Russia(void * jarg1) {
  QuantLib::Russia *arg1 = (QuantLib::Russia *) 0 ;
  
  arg1 = (QuantLib::Russia *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Romania() {
  void * jresult ;
  QuantLib::Romania *result = 0 ;
  
  {
    try {
      result = (QuantLib::Romania *)new QuantLib::Romania();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Romania(void * jarg1) {
  QuantLib::Romania *arg1 = (QuantLib::Romania *) 0 ;
  
  arg1 = (QuantLib::Romania *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_SaudiArabia__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::SaudiArabia::Market arg1 ;
  QuantLib::SaudiArabia *result = 0 ;
  
  arg1 = (QuantLib::SaudiArabia::Market)jarg1; 
  {
    try {
      result = (QuantLib::SaudiArabia *)new QuantLib::SaudiArabia(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_SaudiArabia__SWIG_1() {
  void * jresult ;
  QuantLib::SaudiArabia *result = 0 ;
  
  {
    try {
      result = (QuantLib::SaudiArabia *)new QuantLib::SaudiArabia();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_SaudiArabia(void * jarg1) {
  QuantLib::SaudiArabia *arg1 = (QuantLib::SaudiArabia *) 0 ;
  
  arg1 = (QuantLib::SaudiArabia *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Singapore__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Singapore::Market arg1 ;
  QuantLib::Singapore *result = 0 ;
  
  arg1 = (QuantLib::Singapore::Market)jarg1; 
  {
    try {
      result = (QuantLib::Singapore *)new QuantLib::Singapore(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Singapore__SWIG_1() {
  void * jresult ;
  QuantLib::Singapore *result = 0 ;
  
  {
    try {
      result = (QuantLib::Singapore *)new QuantLib::Singapore();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Singapore(void * jarg1) {
  QuantLib::Singapore *arg1 = (QuantLib::Singapore *) 0 ;
  
  arg1 = (QuantLib::Singapore *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Slovakia__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Slovakia::Market arg1 ;
  QuantLib::Slovakia *result = 0 ;
  
  arg1 = (QuantLib::Slovakia::Market)jarg1; 
  {
    try {
      result = (QuantLib::Slovakia *)new QuantLib::Slovakia(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Slovakia__SWIG_1() {
  void * jresult ;
  QuantLib::Slovakia *result = 0 ;
  
  {
    try {
      result = (QuantLib::Slovakia *)new QuantLib::Slovakia();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Slovakia(void * jarg1) {
  QuantLib::Slovakia *arg1 = (QuantLib::Slovakia *) 0 ;
  
  arg1 = (QuantLib::Slovakia *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_SouthAfrica() {
  void * jresult ;
  QuantLib::SouthAfrica *result = 0 ;
  
  {
    try {
      result = (QuantLib::SouthAfrica *)new QuantLib::SouthAfrica();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_SouthAfrica(void * jarg1) {
  QuantLib::SouthAfrica *arg1 = (QuantLib::SouthAfrica *) 0 ;
  
  arg1 = (QuantLib::SouthAfrica *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_SouthKorea__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::SouthKorea::Market arg1 ;
  QuantLib::SouthKorea *result = 0 ;
  
  arg1 = (QuantLib::SouthKorea::Market)jarg1; 
  {
    try {
      result = (QuantLib::SouthKorea *)new QuantLib::SouthKorea(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_SouthKorea__SWIG_1() {
  void * jresult ;
  QuantLib::SouthKorea *result = 0 ;
  
  {
    try {
      result = (QuantLib::SouthKorea *)new QuantLib::SouthKorea();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_SouthKorea(void * jarg1) {
  QuantLib::SouthKorea *arg1 = (QuantLib::SouthKorea *) 0 ;
  
  arg1 = (QuantLib::SouthKorea *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Sweden() {
  void * jresult ;
  QuantLib::Sweden *result = 0 ;
  
  {
    try {
      result = (QuantLib::Sweden *)new QuantLib::Sweden();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Sweden(void * jarg1) {
  QuantLib::Sweden *arg1 = (QuantLib::Sweden *) 0 ;
  
  arg1 = (QuantLib::Sweden *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Switzerland() {
  void * jresult ;
  QuantLib::Switzerland *result = 0 ;
  
  {
    try {
      result = (QuantLib::Switzerland *)new QuantLib::Switzerland();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Switzerland(void * jarg1) {
  QuantLib::Switzerland *arg1 = (QuantLib::Switzerland *) 0 ;
  
  arg1 = (QuantLib::Switzerland *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Taiwan__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Taiwan::Market arg1 ;
  QuantLib::Taiwan *result = 0 ;
  
  arg1 = (QuantLib::Taiwan::Market)jarg1; 
  {
    try {
      result = (QuantLib::Taiwan *)new QuantLib::Taiwan(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Taiwan__SWIG_1() {
  void * jresult ;
  QuantLib::Taiwan *result = 0 ;
  
  {
    try {
      result = (QuantLib::Taiwan *)new QuantLib::Taiwan();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Taiwan(void * jarg1) {
  QuantLib::Taiwan *arg1 = (QuantLib::Taiwan *) 0 ;
  
  arg1 = (QuantLib::Taiwan *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_TARGET() {
  void * jresult ;
  QuantLib::TARGET *result = 0 ;
  
  {
    try {
      result = (QuantLib::TARGET *)new QuantLib::TARGET();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_TARGET(void * jarg1) {
  QuantLib::TARGET *arg1 = (QuantLib::TARGET *) 0 ;
  
  arg1 = (QuantLib::TARGET *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Thailand() {
  void * jresult ;
  QuantLib::Thailand *result = 0 ;
  
  {
    try {
      result = (QuantLib::Thailand *)new QuantLib::Thailand();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Thailand(void * jarg1) {
  QuantLib::Thailand *arg1 = (QuantLib::Thailand *) 0 ;
  
  arg1 = (QuantLib::Thailand *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Turkey() {
  void * jresult ;
  QuantLib::Turkey *result = 0 ;
  
  {
    try {
      result = (QuantLib::Turkey *)new QuantLib::Turkey();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Turkey(void * jarg1) {
  QuantLib::Turkey *arg1 = (QuantLib::Turkey *) 0 ;
  
  arg1 = (QuantLib::Turkey *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Ukraine__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Ukraine::Market arg1 ;
  QuantLib::Ukraine *result = 0 ;
  
  arg1 = (QuantLib::Ukraine::Market)jarg1; 
  {
    try {
      result = (QuantLib::Ukraine *)new QuantLib::Ukraine(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Ukraine__SWIG_1() {
  void * jresult ;
  QuantLib::Ukraine *result = 0 ;
  
  {
    try {
      result = (QuantLib::Ukraine *)new QuantLib::Ukraine();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Ukraine(void * jarg1) {
  QuantLib::Ukraine *arg1 = (QuantLib::Ukraine *) 0 ;
  
  arg1 = (QuantLib::Ukraine *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_UnitedKingdom__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::UnitedKingdom::Market arg1 ;
  QuantLib::UnitedKingdom *result = 0 ;
  
  arg1 = (QuantLib::UnitedKingdom::Market)jarg1; 
  {
    try {
      result = (QuantLib::UnitedKingdom *)new QuantLib::UnitedKingdom(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_UnitedKingdom__SWIG_1() {
  void * jresult ;
  QuantLib::UnitedKingdom *result = 0 ;
  
  {
    try {
      result = (QuantLib::UnitedKingdom *)new QuantLib::UnitedKingdom();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_UnitedKingdom(void * jarg1) {
  QuantLib::UnitedKingdom *arg1 = (QuantLib::UnitedKingdom *) 0 ;
  
  arg1 = (QuantLib::UnitedKingdom *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_UnitedStates__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::UnitedStates::Market arg1 ;
  QuantLib::UnitedStates *result = 0 ;
  
  arg1 = (QuantLib::UnitedStates::Market)jarg1; 
  {
    try {
      result = (QuantLib::UnitedStates *)new QuantLib::UnitedStates(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_UnitedStates__SWIG_1() {
  void * jresult ;
  QuantLib::UnitedStates *result = 0 ;
  
  {
    try {
      result = (QuantLib::UnitedStates *)new QuantLib::UnitedStates();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_UnitedStates(void * jarg1) {
  QuantLib::UnitedStates *arg1 = (QuantLib::UnitedStates *) 0 ;
  
  arg1 = (QuantLib::UnitedStates *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_NullCalendar() {
  void * jresult ;
  QuantLib::NullCalendar *result = 0 ;
  
  {
    try {
      result = (QuantLib::NullCalendar *)new QuantLib::NullCalendar();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_NullCalendar(void * jarg1) {
  QuantLib::NullCalendar *arg1 = (QuantLib::NullCalendar *) 0 ;
  
  arg1 = (QuantLib::NullCalendar *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_WeekendsOnly() {
  void * jresult ;
  QuantLib::WeekendsOnly *result = 0 ;
  
  {
    try {
      result = (QuantLib::WeekendsOnly *)new QuantLib::WeekendsOnly();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_WeekendsOnly(void * jarg1) {
  QuantLib::WeekendsOnly *arg1 = (QuantLib::WeekendsOnly *) 0 ;
  
  arg1 = (QuantLib::WeekendsOnly *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_JointCalendar__SWIG_0(void * jarg1, void * jarg2, int jarg3) {
  void * jresult ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  JointCalendarRule arg3 ;
  QuantLib::JointCalendar *result = 0 ;
  
  arg1 = (Calendar *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg2 = (Calendar *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg3 = (JointCalendarRule)jarg3; 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_JointCalendar__SWIG_1(void * jarg1, void * jarg2) {
  void * jresult ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  QuantLib::JointCalendar *result = 0 ;
  
  arg1 = (Calendar *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg2 = (Calendar *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_JointCalendar__SWIG_2(void * jarg1, void * jarg2, void * jarg3, int jarg4) {
  void * jresult ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  Calendar *arg3 = 0 ;
  JointCalendarRule arg4 ;
  QuantLib::JointCalendar *result = 0 ;
  
  arg1 = (Calendar *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg2 = (Calendar *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg3 = (Calendar *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg4 = (JointCalendarRule)jarg4; 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_JointCalendar__SWIG_3(void * jarg1, void * jarg2, void * jarg3) {
  void * jresult ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  Calendar *arg3 = 0 ;
  QuantLib::JointCalendar *result = 0 ;
  
  arg1 = (Calendar *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg2 = (Calendar *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg3 = (Calendar *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_JointCalendar__SWIG_4(void * jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5) {
  void * jresult ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  Calendar *arg3 = 0 ;
  Calendar *arg4 = 0 ;
  JointCalendarRule arg5 ;
  QuantLib::JointCalendar *result = 0 ;
  
  arg1 = (Calendar *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg2 = (Calendar *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg3 = (Calendar *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg4 = (Calendar *)jarg4;
  if (!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg5 = (JointCalendarRule)jarg5; 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,(Calendar const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_JointCalendar__SWIG_5(void * jarg1, void * jarg2, void * jarg3, void * jarg4) {
  void * jresult ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  Calendar *arg3 = 0 ;
  Calendar *arg4 = 0 ;
  QuantLib::JointCalendar *result = 0 ;
  
  arg1 = (Calendar *)jarg1;
  if (!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg2 = (Calendar *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg3 = (Calendar *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg4 = (Calendar *)jarg4;
  if (!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,(Calendar const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_JointCalendar(void * jarg1) {
  QuantLib::JointCalendar *arg1 = (QuantLib::JointCalendar *) 0 ;
  
  arg1 = (QuantLib::JointCalendar *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_BespokeCalendar(char * jarg1) {
  void * jresult ;
  std::string *arg1 = 0 ;
  QuantLib::BespokeCalendar *result = 0 ;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  {
    try {
      result = (QuantLib::BespokeCalendar *)new QuantLib::BespokeCalendar((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_BespokeCalendar_addWeekend(void * jarg1, int jarg2) {
  QuantLib::BespokeCalendar *arg1 = (QuantLib::BespokeCalendar *) 0 ;
  Weekday arg2 ;
  
  arg1 = (QuantLib::BespokeCalendar *)jarg1; 
  arg2 = (Weekday)jarg2; 
  {
    try {
      (arg1)->addWeekend(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_BespokeCalendar(void * jarg1) {
  QuantLib::BespokeCalendar *arg1 = (QuantLib::BespokeCalendar *) 0 ;
  
  arg1 = (QuantLib::BespokeCalendar *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuantLib_nullInt() {
  int jresult ;
  int result;
  
  {
    try {
      result = (int)nullInt();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_nullDouble() {
  double jresult ;
  double result;
  
  {
    try {
      result = (double)nullDouble();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT long SWIGSTDCALL CSharp_QuantLib_DayCounter_dayCount(void * jarg1, void * jarg2, void * jarg3) {
  long jresult ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  BigInteger result;
  
  arg1 = (DayCounter *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (BigInteger)((DayCounter const *)arg1)->dayCount((Date const &)*arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_DayCounter_yearFraction__SWIG_0(void * jarg1, void * jarg2, void * jarg3, void * jarg4, void * jarg5) {
  double jresult ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Date *arg4 = 0 ;
  Date *arg5 = 0 ;
  Time result;
  
  arg1 = (DayCounter *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (Date *)jarg4;
  if (!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg5 = (Date *)jarg5;
  if (!arg5) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (Time)((DayCounter const *)arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4,(Date const &)*arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_DayCounter_yearFraction__SWIG_1(void * jarg1, void * jarg2, void * jarg3, void * jarg4) {
  double jresult ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Date *arg4 = 0 ;
  Time result;
  
  arg1 = (DayCounter *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (Date *)jarg4;
  if (!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (Time)((DayCounter const *)arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuantLib_DayCounter_yearFraction__SWIG_2(void * jarg1, void * jarg2, void * jarg3) {
  double jresult ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Time result;
  
  arg1 = (DayCounter *)jarg1; 
  arg2 = (Date *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if (!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (Time)((DayCounter const *)arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_DayCounter_name(void * jarg1) {
  char * jresult ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  std::string result;
  
  arg1 = (DayCounter *)jarg1; 
  {
    try {
      result = ((DayCounter const *)arg1)->name();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QuantLib_DayCounter___str__(void * jarg1) {
  char * jresult ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  std::string result;
  
  arg1 = (DayCounter *)jarg1; 
  {
    try {
      result = DayCounter___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_DayCounter(void * jarg1) {
  DayCounter *arg1 = (DayCounter *) 0 ;
  
  arg1 = (DayCounter *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Actual360__SWIG_0(unsigned int jarg1) {
  void * jresult ;
  bool arg1 ;
  QuantLib::Actual360 *result = 0 ;
  
  arg1 = jarg1 ? true : false; 
  {
    try {
      result = (QuantLib::Actual360 *)new QuantLib::Actual360(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Actual360__SWIG_1() {
  void * jresult ;
  QuantLib::Actual360 *result = 0 ;
  
  {
    try {
      result = (QuantLib::Actual360 *)new QuantLib::Actual360();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Actual360(void * jarg1) {
  QuantLib::Actual360 *arg1 = (QuantLib::Actual360 *) 0 ;
  
  arg1 = (QuantLib::Actual360 *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Actual365Fixed__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Actual365Fixed::Convention arg1 ;
  QuantLib::Actual365Fixed *result = 0 ;
  
  arg1 = (QuantLib::Actual365Fixed::Convention)jarg1; 
  {
    try {
      result = (QuantLib::Actual365Fixed *)new QuantLib::Actual365Fixed(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Actual365Fixed__SWIG_1() {
  void * jresult ;
  QuantLib::Actual365Fixed *result = 0 ;
  
  {
    try {
      result = (QuantLib::Actual365Fixed *)new QuantLib::Actual365Fixed();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Actual365Fixed(void * jarg1) {
  QuantLib::Actual365Fixed *arg1 = (QuantLib::Actual365Fixed *) 0 ;
  
  arg1 = (QuantLib::Actual365Fixed *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Thirty360__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Thirty360::Convention arg1 ;
  QuantLib::Thirty360 *result = 0 ;
  
  arg1 = (QuantLib::Thirty360::Convention)jarg1; 
  {
    try {
      result = (QuantLib::Thirty360 *)new QuantLib::Thirty360(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_Thirty360__SWIG_1() {
  void * jresult ;
  QuantLib::Thirty360 *result = 0 ;
  
  {
    try {
      result = (QuantLib::Thirty360 *)new QuantLib::Thirty360();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_Thirty360(void * jarg1) {
  QuantLib::Thirty360 *arg1 = (QuantLib::Thirty360 *) 0 ;
  
  arg1 = (QuantLib::Thirty360 *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_ActualActual__SWIG_0(int jarg1, void * jarg2) {
  void * jresult ;
  QuantLib::ActualActual::Convention arg1 ;
  Schedule *arg2 = 0 ;
  QuantLib::ActualActual *result = 0 ;
  
  arg1 = (QuantLib::ActualActual::Convention)jarg1; 
  arg2 = (Schedule *)jarg2;
  if (!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Schedule const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (QuantLib::ActualActual *)new QuantLib::ActualActual(arg1,(Schedule const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_ActualActual__SWIG_1(int jarg1) {
  void * jresult ;
  QuantLib::ActualActual::Convention arg1 ;
  QuantLib::ActualActual *result = 0 ;
  
  arg1 = (QuantLib::ActualActual::Convention)jarg1; 
  {
    try {
      result = (QuantLib::ActualActual *)new QuantLib::ActualActual(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuantLib_new_ActualActual__SWIG_2() {
  void * jresult ;
  QuantLib::ActualActual *result = 0 ;
  
  {
    try {
      result = (QuantLib::ActualActual *)new QuantLib::ActualActual();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuantLib_delete_ActualActual(void * jarg1) {
  QuantLib::ActualActual *arg1 = (QuantLib::ActualActual *) 0 ;
  
  arg1 = (QuantLib::ActualActual *)jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch 