// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/bindings/modules/v8/module_bindings_initializer.h"

#include "third_party/blink/renderer/bindings/modules/v8/origin_trial_features_for_modules.h"
#include "third_party/blink/renderer/bindings/modules/v8/serialization/serialized_script_value_for_modules_factory.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {

// initPartialInterfacesInModules is generated by
// generate_init_partial_interfaces.py.
void InitPartialInterfacesInModules();

void ModuleBindingsInitializer::Init() {
  RegisterInstallOriginTrialFeaturesForModules();
  InitPartialInterfacesInModules();
  SerializedScriptValueFactory::Initialize(
      new SerializedScriptValueForModulesFactory);
}

}  // namespace blink
