// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Protocol Buffer 2 Copyright 2008 Google Inc.
// All other code copyright its respective owners.

/**
 * @fileoverview Generated Protocol Buffer code for file
 * third_party/sketchology/proto/elements.proto.
 * Generated by //net/proto2/compiler/public:protocol_compiler.
 * @suppress {messageConventions} 
 */

goog.provide('sketchology.proto.CallbackFlags');
goog.provide('sketchology.proto.SourceDetails');
goog.provide('sketchology.proto.SourceDetails.Origin');
goog.provide('sketchology.proto.BackgroundImageInfo');
goog.provide('sketchology.proto.Border');
goog.provide('sketchology.proto.LOD');
goog.provide('sketchology.proto.Stroke');
goog.provide('sketchology.proto.UncompressedStroke');
goog.provide('sketchology.proto.AffineTransform');
goog.provide('sketchology.proto.Element');
goog.provide('sketchology.proto.ElementAttributes');
goog.provide('sketchology.proto.UncompressedElement');
goog.provide('sketchology.proto.ElementMutation');
goog.provide('sketchology.proto.ElementIdList');
goog.provide('sketchology.proto.Point');
goog.provide('sketchology.proto.ElementBundle');
goog.provide('sketchology.proto.Path');
goog.provide('sketchology.proto.Path.SegmentType');
goog.provide('sketchology.proto.Path.EndCapType');
goog.provide('sketchology.proto.ShaderType');

goog.require('goog.proto2.Message');
goog.require('sketchology.proto.Rect');


/**
 * Enumeration ShaderType.
 * @enum {number}
 */
sketchology.proto.ShaderType = {
  NONE: 0,
  VERTEX_COLORED: 1,
  SOLID_COLORED: 2,
  ERASE: 3,
  VERTEX_TEXTURED: 4
};



/**
 * Message CallbackFlags.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.CallbackFlags = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.CallbackFlags, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.CallbackFlags.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.CallbackFlags} The cloned message.
 * @override
 */
sketchology.proto.CallbackFlags.prototype.clone;


/**
 * Gets the value of the mesh_data_ctm field.
 * @return {?boolean} The value.
 */
sketchology.proto.CallbackFlags.prototype.getMeshDataCtm = function() {
  return /** @type {?boolean} */ (this.get$Value(1));
};


/**
 * Gets the value of the mesh_data_ctm field or the default value if not set.
 * @return {boolean} The value.
 */
sketchology.proto.CallbackFlags.prototype.getMeshDataCtmOrDefault = function() {
  return /** @type {boolean} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the mesh_data_ctm field.
 * @param {boolean} value The value.
 */
sketchology.proto.CallbackFlags.prototype.setMeshDataCtm = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the mesh_data_ctm field has a value.
 */
sketchology.proto.CallbackFlags.prototype.hasMeshDataCtm = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the mesh_data_ctm field.
 */
sketchology.proto.CallbackFlags.prototype.meshDataCtmCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the mesh_data_ctm field.
 */
sketchology.proto.CallbackFlags.prototype.clearMeshDataCtm = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the uncompressed_outline field.
 * @return {?boolean} The value.
 */
sketchology.proto.CallbackFlags.prototype.getUncompressedOutline = function() {
  return /** @type {?boolean} */ (this.get$Value(2));
};


/**
 * Gets the value of the uncompressed_outline field or the default value if not set.
 * @return {boolean} The value.
 */
sketchology.proto.CallbackFlags.prototype.getUncompressedOutlineOrDefault = function() {
  return /** @type {boolean} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the uncompressed_outline field.
 * @param {boolean} value The value.
 */
sketchology.proto.CallbackFlags.prototype.setUncompressedOutline = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the uncompressed_outline field has a value.
 */
sketchology.proto.CallbackFlags.prototype.hasUncompressedOutline = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the uncompressed_outline field.
 */
sketchology.proto.CallbackFlags.prototype.uncompressedOutlineCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the uncompressed_outline field.
 */
sketchology.proto.CallbackFlags.prototype.clearUncompressedOutline = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the compressed_input_points field.
 * @return {?boolean} The value.
 */
sketchology.proto.CallbackFlags.prototype.getCompressedInputPoints = function() {
  return /** @type {?boolean} */ (this.get$Value(3));
};


/**
 * Gets the value of the compressed_input_points field or the default value if not set.
 * @return {boolean} The value.
 */
sketchology.proto.CallbackFlags.prototype.getCompressedInputPointsOrDefault = function() {
  return /** @type {boolean} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the compressed_input_points field.
 * @param {boolean} value The value.
 */
sketchology.proto.CallbackFlags.prototype.setCompressedInputPoints = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the compressed_input_points field has a value.
 */
sketchology.proto.CallbackFlags.prototype.hasCompressedInputPoints = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the compressed_input_points field.
 */
sketchology.proto.CallbackFlags.prototype.compressedInputPointsCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the compressed_input_points field.
 */
sketchology.proto.CallbackFlags.prototype.clearCompressedInputPoints = function() {
  this.clear$Field(3);
};



/**
 * Message SourceDetails.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.SourceDetails = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.SourceDetails, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.SourceDetails.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.SourceDetails} The cloned message.
 * @override
 */
sketchology.proto.SourceDetails.prototype.clone;


/**
 * Gets the value of the origin field.
 * @return {?sketchology.proto.SourceDetails.Origin} The value.
 */
sketchology.proto.SourceDetails.prototype.getOrigin = function() {
  return /** @type {?sketchology.proto.SourceDetails.Origin} */ (this.get$Value(1));
};


/**
 * Gets the value of the origin field or the default value if not set.
 * @return {!sketchology.proto.SourceDetails.Origin} The value.
 */
sketchology.proto.SourceDetails.prototype.getOriginOrDefault = function() {
  return /** @type {!sketchology.proto.SourceDetails.Origin} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the origin field.
 * @param {!sketchology.proto.SourceDetails.Origin} value The value.
 */
sketchology.proto.SourceDetails.prototype.setOrigin = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the origin field has a value.
 */
sketchology.proto.SourceDetails.prototype.hasOrigin = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the origin field.
 */
sketchology.proto.SourceDetails.prototype.originCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the origin field.
 */
sketchology.proto.SourceDetails.prototype.clearOrigin = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the host_source_details field.
 * @return {?number} The value.
 */
sketchology.proto.SourceDetails.prototype.getHostSourceDetails = function() {
  return /** @type {?number} */ (this.get$Value(2));
};


/**
 * Gets the value of the host_source_details field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.SourceDetails.prototype.getHostSourceDetailsOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the host_source_details field.
 * @param {number} value The value.
 */
sketchology.proto.SourceDetails.prototype.setHostSourceDetails = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the host_source_details field has a value.
 */
sketchology.proto.SourceDetails.prototype.hasHostSourceDetails = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the host_source_details field.
 */
sketchology.proto.SourceDetails.prototype.hostSourceDetailsCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the host_source_details field.
 */
sketchology.proto.SourceDetails.prototype.clearHostSourceDetails = function() {
  this.clear$Field(2);
};


/**
 * Enumeration Origin.
 * @enum {number}
 */
sketchology.proto.SourceDetails.Origin = {
  UNKNOWN: 0,
  ENGINE: 1,
  HOST: 2
};



/**
 * Message BackgroundImageInfo.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.BackgroundImageInfo = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.BackgroundImageInfo, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.BackgroundImageInfo.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.BackgroundImageInfo} The cloned message.
 * @override
 */
sketchology.proto.BackgroundImageInfo.prototype.clone;


/**
 * Gets the value of the uri field.
 * @return {?string} The value.
 */
sketchology.proto.BackgroundImageInfo.prototype.getUri = function() {
  return /** @type {?string} */ (this.get$Value(1));
};


/**
 * Gets the value of the uri field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.BackgroundImageInfo.prototype.getUriOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the uri field.
 * @param {string} value The value.
 */
sketchology.proto.BackgroundImageInfo.prototype.setUri = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the uri field has a value.
 */
sketchology.proto.BackgroundImageInfo.prototype.hasUri = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the uri field.
 */
sketchology.proto.BackgroundImageInfo.prototype.uriCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the uri field.
 */
sketchology.proto.BackgroundImageInfo.prototype.clearUri = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the bounds field.
 * @return {?sketchology.proto.Rect} The value.
 */
sketchology.proto.BackgroundImageInfo.prototype.getBounds = function() {
  return /** @type {?sketchology.proto.Rect} */ (this.get$Value(3));
};


/**
 * Gets the value of the bounds field or the default value if not set.
 * @return {!sketchology.proto.Rect} The value.
 */
sketchology.proto.BackgroundImageInfo.prototype.getBoundsOrDefault = function() {
  return /** @type {!sketchology.proto.Rect} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the bounds field.
 * @param {!sketchology.proto.Rect} value The value.
 */
sketchology.proto.BackgroundImageInfo.prototype.setBounds = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the bounds field has a value.
 */
sketchology.proto.BackgroundImageInfo.prototype.hasBounds = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the bounds field.
 */
sketchology.proto.BackgroundImageInfo.prototype.boundsCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the bounds field.
 */
sketchology.proto.BackgroundImageInfo.prototype.clearBounds = function() {
  this.clear$Field(3);
};



/**
 * Message Border.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.Border = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.Border, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.Border.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.Border} The cloned message.
 * @override
 */
sketchology.proto.Border.prototype.clone;


/**
 * Gets the value of the uri field.
 * @return {?string} The value.
 */
sketchology.proto.Border.prototype.getUri = function() {
  return /** @type {?string} */ (this.get$Value(1));
};


/**
 * Gets the value of the uri field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.Border.prototype.getUriOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the uri field.
 * @param {string} value The value.
 */
sketchology.proto.Border.prototype.setUri = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the uri field has a value.
 */
sketchology.proto.Border.prototype.hasUri = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the uri field.
 */
sketchology.proto.Border.prototype.uriCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the uri field.
 */
sketchology.proto.Border.prototype.clearUri = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the scale field.
 * @return {?number} The value.
 */
sketchology.proto.Border.prototype.getScale = function() {
  return /** @type {?number} */ (this.get$Value(2));
};


/**
 * Gets the value of the scale field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.Border.prototype.getScaleOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the scale field.
 * @param {number} value The value.
 */
sketchology.proto.Border.prototype.setScale = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the scale field has a value.
 */
sketchology.proto.Border.prototype.hasScale = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the scale field.
 */
sketchology.proto.Border.prototype.scaleCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the scale field.
 */
sketchology.proto.Border.prototype.clearScale = function() {
  this.clear$Field(2);
};



/**
 * Message LOD.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.LOD = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.LOD, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.LOD.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.LOD} The cloned message.
 * @override
 */
sketchology.proto.LOD.prototype.clone;


/**
 * Gets the value of the max_coverage field.
 * @return {?number} The value.
 */
sketchology.proto.LOD.prototype.getMaxCoverage = function() {
  return /** @type {?number} */ (this.get$Value(1));
};


/**
 * Gets the value of the max_coverage field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.LOD.prototype.getMaxCoverageOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the max_coverage field.
 * @param {number} value The value.
 */
sketchology.proto.LOD.prototype.setMaxCoverage = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the max_coverage field has a value.
 */
sketchology.proto.LOD.prototype.hasMaxCoverage = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the max_coverage field.
 */
sketchology.proto.LOD.prototype.maxCoverageCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the max_coverage field.
 */
sketchology.proto.LOD.prototype.clearMaxCoverage = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the ctm_blob field.
 * @return {?string} The value.
 */
sketchology.proto.LOD.prototype.getCtmBlob = function() {
  return /** @type {?string} */ (this.get$Value(2));
};


/**
 * Gets the value of the ctm_blob field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.LOD.prototype.getCtmBlobOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the ctm_blob field.
 * @param {string} value The value.
 */
sketchology.proto.LOD.prototype.setCtmBlob = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the ctm_blob field has a value.
 */
sketchology.proto.LOD.prototype.hasCtmBlob = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the ctm_blob field.
 */
sketchology.proto.LOD.prototype.ctmBlobCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the ctm_blob field.
 */
sketchology.proto.LOD.prototype.clearCtmBlob = function() {
  this.clear$Field(2);
};



/**
 * Message Stroke.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.Stroke = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.Stroke, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.Stroke.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.Stroke} The cloned message.
 * @override
 */
sketchology.proto.Stroke.prototype.clone;


/**
 * Gets the value of the shader_type field.
 * @return {?sketchology.proto.ShaderType} The value.
 */
sketchology.proto.Stroke.prototype.getShaderType = function() {
  return /** @type {?sketchology.proto.ShaderType} */ (this.get$Value(1));
};


/**
 * Gets the value of the shader_type field or the default value if not set.
 * @return {!sketchology.proto.ShaderType} The value.
 */
sketchology.proto.Stroke.prototype.getShaderTypeOrDefault = function() {
  return /** @type {!sketchology.proto.ShaderType} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the shader_type field.
 * @param {!sketchology.proto.ShaderType} value The value.
 */
sketchology.proto.Stroke.prototype.setShaderType = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the shader_type field has a value.
 */
sketchology.proto.Stroke.prototype.hasShaderType = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the shader_type field.
 */
sketchology.proto.Stroke.prototype.shaderTypeCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the shader_type field.
 */
sketchology.proto.Stroke.prototype.clearShaderType = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the lod field at the index given.
 * @param {number} index The index to lookup.
 * @return {?sketchology.proto.LOD} The value.
 */
sketchology.proto.Stroke.prototype.getLod = function(index) {
  return /** @type {?sketchology.proto.LOD} */ (this.get$Value(3, index));
};


/**
 * Gets the value of the lod field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {!sketchology.proto.LOD} The value.
 */
sketchology.proto.Stroke.prototype.getLodOrDefault = function(index) {
  return /** @type {!sketchology.proto.LOD} */ (this.get$ValueOrDefault(3, index));
};


/**
 * Adds a value to the lod field.
 * @param {!sketchology.proto.LOD} value The value to add.
 */
sketchology.proto.Stroke.prototype.addLod = function(value) {
  this.add$Value(3, value);
};


/**
 * Returns the array of values in the lod field.
 * @return {!Array<!sketchology.proto.LOD>} The values in the field.
 */
sketchology.proto.Stroke.prototype.lodArray = function() {
  return /** @type {!Array<!sketchology.proto.LOD>} */ (this.array$Values(3));
};


/**
 * @return {boolean} Whether the lod field has a value.
 */
sketchology.proto.Stroke.prototype.hasLod = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the lod field.
 */
sketchology.proto.Stroke.prototype.lodCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the lod field.
 */
sketchology.proto.Stroke.prototype.clearLod = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the abgr field.
 * @return {?number} The value.
 */
sketchology.proto.Stroke.prototype.getAbgr = function() {
  return /** @type {?number} */ (this.get$Value(4));
};


/**
 * Gets the value of the abgr field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.Stroke.prototype.getAbgrOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the abgr field.
 * @param {number} value The value.
 */
sketchology.proto.Stroke.prototype.setAbgr = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the abgr field has a value.
 */
sketchology.proto.Stroke.prototype.hasAbgr = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the abgr field.
 */
sketchology.proto.Stroke.prototype.abgrCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the abgr field.
 */
sketchology.proto.Stroke.prototype.clearAbgr = function() {
  this.clear$Field(4);
};


/**
 * Gets the value of the point_x field at the index given.
 * @param {number} index The index to lookup.
 * @return {?number} The value.
 */
sketchology.proto.Stroke.prototype.getPointX = function(index) {
  return /** @type {?number} */ (this.get$Value(5, index));
};


/**
 * Gets the value of the point_x field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {number} The value.
 */
sketchology.proto.Stroke.prototype.getPointXOrDefault = function(index) {
  return /** @type {number} */ (this.get$ValueOrDefault(5, index));
};


/**
 * Adds a value to the point_x field.
 * @param {number} value The value to add.
 */
sketchology.proto.Stroke.prototype.addPointX = function(value) {
  this.add$Value(5, value);
};


/**
 * Returns the array of values in the point_x field.
 * @return {!Array<number>} The values in the field.
 */
sketchology.proto.Stroke.prototype.pointXArray = function() {
  return /** @type {!Array<number>} */ (this.array$Values(5));
};


/**
 * @return {boolean} Whether the point_x field has a value.
 */
sketchology.proto.Stroke.prototype.hasPointX = function() {
  return this.has$Value(5);
};


/**
 * @return {number} The number of values in the point_x field.
 */
sketchology.proto.Stroke.prototype.pointXCount = function() {
  return this.count$Values(5);
};


/**
 * Clears the values in the point_x field.
 */
sketchology.proto.Stroke.prototype.clearPointX = function() {
  this.clear$Field(5);
};


/**
 * Gets the value of the point_y field at the index given.
 * @param {number} index The index to lookup.
 * @return {?number} The value.
 */
sketchology.proto.Stroke.prototype.getPointY = function(index) {
  return /** @type {?number} */ (this.get$Value(6, index));
};


/**
 * Gets the value of the point_y field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {number} The value.
 */
sketchology.proto.Stroke.prototype.getPointYOrDefault = function(index) {
  return /** @type {number} */ (this.get$ValueOrDefault(6, index));
};


/**
 * Adds a value to the point_y field.
 * @param {number} value The value to add.
 */
sketchology.proto.Stroke.prototype.addPointY = function(value) {
  this.add$Value(6, value);
};


/**
 * Returns the array of values in the point_y field.
 * @return {!Array<number>} The values in the field.
 */
sketchology.proto.Stroke.prototype.pointYArray = function() {
  return /** @type {!Array<number>} */ (this.array$Values(6));
};


/**
 * @return {boolean} Whether the point_y field has a value.
 */
sketchology.proto.Stroke.prototype.hasPointY = function() {
  return this.has$Value(6);
};


/**
 * @return {number} The number of values in the point_y field.
 */
sketchology.proto.Stroke.prototype.pointYCount = function() {
  return this.count$Values(6);
};


/**
 * Clears the values in the point_y field.
 */
sketchology.proto.Stroke.prototype.clearPointY = function() {
  this.clear$Field(6);
};


/**
 * Gets the value of the point_t_ms field at the index given.
 * @param {number} index The index to lookup.
 * @return {?number} The value.
 */
sketchology.proto.Stroke.prototype.getPointTMs = function(index) {
  return /** @type {?number} */ (this.get$Value(7, index));
};


/**
 * Gets the value of the point_t_ms field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {number} The value.
 */
sketchology.proto.Stroke.prototype.getPointTMsOrDefault = function(index) {
  return /** @type {number} */ (this.get$ValueOrDefault(7, index));
};


/**
 * Adds a value to the point_t_ms field.
 * @param {number} value The value to add.
 */
sketchology.proto.Stroke.prototype.addPointTMs = function(value) {
  this.add$Value(7, value);
};


/**
 * Returns the array of values in the point_t_ms field.
 * @return {!Array<number>} The values in the field.
 */
sketchology.proto.Stroke.prototype.pointTMsArray = function() {
  return /** @type {!Array<number>} */ (this.array$Values(7));
};


/**
 * @return {boolean} Whether the point_t_ms field has a value.
 */
sketchology.proto.Stroke.prototype.hasPointTMs = function() {
  return this.has$Value(7);
};


/**
 * @return {number} The number of values in the point_t_ms field.
 */
sketchology.proto.Stroke.prototype.pointTMsCount = function() {
  return this.count$Values(7);
};


/**
 * Clears the values in the point_t_ms field.
 */
sketchology.proto.Stroke.prototype.clearPointTMs = function() {
  this.clear$Field(7);
};


/**
 * Gets the value of the deprecated_transform field.
 * @return {?sketchology.proto.AffineTransform} The value.
 */
sketchology.proto.Stroke.prototype.getDeprecatedTransform = function() {
  return /** @type {?sketchology.proto.AffineTransform} */ (this.get$Value(8));
};


/**
 * Gets the value of the deprecated_transform field or the default value if not set.
 * @return {!sketchology.proto.AffineTransform} The value.
 */
sketchology.proto.Stroke.prototype.getDeprecatedTransformOrDefault = function() {
  return /** @type {!sketchology.proto.AffineTransform} */ (this.get$ValueOrDefault(8));
};


/**
 * Sets the value of the deprecated_transform field.
 * @param {!sketchology.proto.AffineTransform} value The value.
 */
sketchology.proto.Stroke.prototype.setDeprecatedTransform = function(value) {
  this.set$Value(8, value);
};


/**
 * @return {boolean} Whether the deprecated_transform field has a value.
 */
sketchology.proto.Stroke.prototype.hasDeprecatedTransform = function() {
  return this.has$Value(8);
};


/**
 * @return {number} The number of values in the deprecated_transform field.
 */
sketchology.proto.Stroke.prototype.deprecatedTransformCount = function() {
  return this.count$Values(8);
};


/**
 * Clears the values in the deprecated_transform field.
 */
sketchology.proto.Stroke.prototype.clearDeprecatedTransform = function() {
  this.clear$Field(8);
};


/**
 * Gets the value of the start_time_ms field.
 * @return {?string} The value.
 */
sketchology.proto.Stroke.prototype.getStartTimeMs = function() {
  return /** @type {?string} */ (this.get$Value(9));
};


/**
 * Gets the value of the start_time_ms field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.Stroke.prototype.getStartTimeMsOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(9));
};


/**
 * Sets the value of the start_time_ms field.
 * @param {string} value The value.
 */
sketchology.proto.Stroke.prototype.setStartTimeMs = function(value) {
  this.set$Value(9, value);
};


/**
 * @return {boolean} Whether the start_time_ms field has a value.
 */
sketchology.proto.Stroke.prototype.hasStartTimeMs = function() {
  return this.has$Value(9);
};


/**
 * @return {number} The number of values in the start_time_ms field.
 */
sketchology.proto.Stroke.prototype.startTimeMsCount = function() {
  return this.count$Values(9);
};


/**
 * Clears the values in the start_time_ms field.
 */
sketchology.proto.Stroke.prototype.clearStartTimeMs = function() {
  this.clear$Field(9);
};



/**
 * Message UncompressedStroke.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.UncompressedStroke = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.UncompressedStroke, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.UncompressedStroke.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.UncompressedStroke} The cloned message.
 * @override
 */
sketchology.proto.UncompressedStroke.prototype.clone;


/**
 * Gets the value of the outline field at the index given.
 * @param {number} index The index to lookup.
 * @return {?sketchology.proto.Point} The value.
 */
sketchology.proto.UncompressedStroke.prototype.getOutline = function(index) {
  return /** @type {?sketchology.proto.Point} */ (this.get$Value(1, index));
};


/**
 * Gets the value of the outline field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {!sketchology.proto.Point} The value.
 */
sketchology.proto.UncompressedStroke.prototype.getOutlineOrDefault = function(index) {
  return /** @type {!sketchology.proto.Point} */ (this.get$ValueOrDefault(1, index));
};


/**
 * Adds a value to the outline field.
 * @param {!sketchology.proto.Point} value The value to add.
 */
sketchology.proto.UncompressedStroke.prototype.addOutline = function(value) {
  this.add$Value(1, value);
};


/**
 * Returns the array of values in the outline field.
 * @return {!Array<!sketchology.proto.Point>} The values in the field.
 */
sketchology.proto.UncompressedStroke.prototype.outlineArray = function() {
  return /** @type {!Array<!sketchology.proto.Point>} */ (this.array$Values(1));
};


/**
 * @return {boolean} Whether the outline field has a value.
 */
sketchology.proto.UncompressedStroke.prototype.hasOutline = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the outline field.
 */
sketchology.proto.UncompressedStroke.prototype.outlineCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the outline field.
 */
sketchology.proto.UncompressedStroke.prototype.clearOutline = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the rgba field.
 * @return {?number} The value.
 */
sketchology.proto.UncompressedStroke.prototype.getRgba = function() {
  return /** @type {?number} */ (this.get$Value(2));
};


/**
 * Gets the value of the rgba field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.UncompressedStroke.prototype.getRgbaOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the rgba field.
 * @param {number} value The value.
 */
sketchology.proto.UncompressedStroke.prototype.setRgba = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the rgba field has a value.
 */
sketchology.proto.UncompressedStroke.prototype.hasRgba = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the rgba field.
 */
sketchology.proto.UncompressedStroke.prototype.rgbaCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the rgba field.
 */
sketchology.proto.UncompressedStroke.prototype.clearRgba = function() {
  this.clear$Field(2);
};



/**
 * Message AffineTransform.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.AffineTransform = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.AffineTransform, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.AffineTransform.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.AffineTransform} The cloned message.
 * @override
 */
sketchology.proto.AffineTransform.prototype.clone;


/**
 * Gets the value of the tx field.
 * @return {?number} The value.
 */
sketchology.proto.AffineTransform.prototype.getTx = function() {
  return /** @type {?number} */ (this.get$Value(1));
};


/**
 * Gets the value of the tx field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.AffineTransform.prototype.getTxOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the tx field.
 * @param {number} value The value.
 */
sketchology.proto.AffineTransform.prototype.setTx = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the tx field has a value.
 */
sketchology.proto.AffineTransform.prototype.hasTx = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the tx field.
 */
sketchology.proto.AffineTransform.prototype.txCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the tx field.
 */
sketchology.proto.AffineTransform.prototype.clearTx = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the ty field.
 * @return {?number} The value.
 */
sketchology.proto.AffineTransform.prototype.getTy = function() {
  return /** @type {?number} */ (this.get$Value(2));
};


/**
 * Gets the value of the ty field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.AffineTransform.prototype.getTyOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the ty field.
 * @param {number} value The value.
 */
sketchology.proto.AffineTransform.prototype.setTy = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the ty field has a value.
 */
sketchology.proto.AffineTransform.prototype.hasTy = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the ty field.
 */
sketchology.proto.AffineTransform.prototype.tyCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the ty field.
 */
sketchology.proto.AffineTransform.prototype.clearTy = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the scale_x field.
 * @return {?number} The value.
 */
sketchology.proto.AffineTransform.prototype.getScaleX = function() {
  return /** @type {?number} */ (this.get$Value(3));
};


/**
 * Gets the value of the scale_x field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.AffineTransform.prototype.getScaleXOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the scale_x field.
 * @param {number} value The value.
 */
sketchology.proto.AffineTransform.prototype.setScaleX = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the scale_x field has a value.
 */
sketchology.proto.AffineTransform.prototype.hasScaleX = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the scale_x field.
 */
sketchology.proto.AffineTransform.prototype.scaleXCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the scale_x field.
 */
sketchology.proto.AffineTransform.prototype.clearScaleX = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the scale_y field.
 * @return {?number} The value.
 */
sketchology.proto.AffineTransform.prototype.getScaleY = function() {
  return /** @type {?number} */ (this.get$Value(4));
};


/**
 * Gets the value of the scale_y field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.AffineTransform.prototype.getScaleYOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the scale_y field.
 * @param {number} value The value.
 */
sketchology.proto.AffineTransform.prototype.setScaleY = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the scale_y field has a value.
 */
sketchology.proto.AffineTransform.prototype.hasScaleY = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the scale_y field.
 */
sketchology.proto.AffineTransform.prototype.scaleYCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the scale_y field.
 */
sketchology.proto.AffineTransform.prototype.clearScaleY = function() {
  this.clear$Field(4);
};


/**
 * Gets the value of the rotation_radians field.
 * @return {?number} The value.
 */
sketchology.proto.AffineTransform.prototype.getRotationRadians = function() {
  return /** @type {?number} */ (this.get$Value(5));
};


/**
 * Gets the value of the rotation_radians field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.AffineTransform.prototype.getRotationRadiansOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(5));
};


/**
 * Sets the value of the rotation_radians field.
 * @param {number} value The value.
 */
sketchology.proto.AffineTransform.prototype.setRotationRadians = function(value) {
  this.set$Value(5, value);
};


/**
 * @return {boolean} Whether the rotation_radians field has a value.
 */
sketchology.proto.AffineTransform.prototype.hasRotationRadians = function() {
  return this.has$Value(5);
};


/**
 * @return {number} The number of values in the rotation_radians field.
 */
sketchology.proto.AffineTransform.prototype.rotationRadiansCount = function() {
  return this.count$Values(5);
};


/**
 * Clears the values in the rotation_radians field.
 */
sketchology.proto.AffineTransform.prototype.clearRotationRadians = function() {
  this.clear$Field(5);
};



/**
 * Message Element.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.Element = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.Element, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.Element.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.Element} The cloned message.
 * @override
 */
sketchology.proto.Element.prototype.clone;


/**
 * Gets the value of the deprecated_uuid field.
 * @return {?string} The value.
 */
sketchology.proto.Element.prototype.getDeprecatedUuid = function() {
  return /** @type {?string} */ (this.get$Value(4));
};


/**
 * Gets the value of the deprecated_uuid field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.Element.prototype.getDeprecatedUuidOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the deprecated_uuid field.
 * @param {string} value The value.
 */
sketchology.proto.Element.prototype.setDeprecatedUuid = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the deprecated_uuid field has a value.
 */
sketchology.proto.Element.prototype.hasDeprecatedUuid = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the deprecated_uuid field.
 */
sketchology.proto.Element.prototype.deprecatedUuidCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the deprecated_uuid field.
 */
sketchology.proto.Element.prototype.clearDeprecatedUuid = function() {
  this.clear$Field(4);
};


/**
 * Gets the value of the minimum_serializer_version field.
 * @return {?number} The value.
 */
sketchology.proto.Element.prototype.getMinimumSerializerVersion = function() {
  return /** @type {?number} */ (this.get$Value(5));
};


/**
 * Gets the value of the minimum_serializer_version field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.Element.prototype.getMinimumSerializerVersionOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(5));
};


/**
 * Sets the value of the minimum_serializer_version field.
 * @param {number} value The value.
 */
sketchology.proto.Element.prototype.setMinimumSerializerVersion = function(value) {
  this.set$Value(5, value);
};


/**
 * @return {boolean} Whether the minimum_serializer_version field has a value.
 */
sketchology.proto.Element.prototype.hasMinimumSerializerVersion = function() {
  return this.has$Value(5);
};


/**
 * @return {number} The number of values in the minimum_serializer_version field.
 */
sketchology.proto.Element.prototype.minimumSerializerVersionCount = function() {
  return this.count$Values(5);
};


/**
 * Clears the values in the minimum_serializer_version field.
 */
sketchology.proto.Element.prototype.clearMinimumSerializerVersion = function() {
  this.clear$Field(5);
};


/**
 * Gets the value of the stroke field.
 * @return {?sketchology.proto.Stroke} The value.
 */
sketchology.proto.Element.prototype.getStroke = function() {
  return /** @type {?sketchology.proto.Stroke} */ (this.get$Value(6));
};


/**
 * Gets the value of the stroke field or the default value if not set.
 * @return {!sketchology.proto.Stroke} The value.
 */
sketchology.proto.Element.prototype.getStrokeOrDefault = function() {
  return /** @type {!sketchology.proto.Stroke} */ (this.get$ValueOrDefault(6));
};


/**
 * Sets the value of the stroke field.
 * @param {!sketchology.proto.Stroke} value The value.
 */
sketchology.proto.Element.prototype.setStroke = function(value) {
  this.set$Value(6, value);
};


/**
 * @return {boolean} Whether the stroke field has a value.
 */
sketchology.proto.Element.prototype.hasStroke = function() {
  return this.has$Value(6);
};


/**
 * @return {number} The number of values in the stroke field.
 */
sketchology.proto.Element.prototype.strokeCount = function() {
  return this.count$Values(6);
};


/**
 * Clears the values in the stroke field.
 */
sketchology.proto.Element.prototype.clearStroke = function() {
  this.clear$Field(6);
};


/**
 * Gets the value of the path field.
 * @return {?sketchology.proto.Path} The value.
 */
sketchology.proto.Element.prototype.getPath = function() {
  return /** @type {?sketchology.proto.Path} */ (this.get$Value(9));
};


/**
 * Gets the value of the path field or the default value if not set.
 * @return {!sketchology.proto.Path} The value.
 */
sketchology.proto.Element.prototype.getPathOrDefault = function() {
  return /** @type {!sketchology.proto.Path} */ (this.get$ValueOrDefault(9));
};


/**
 * Sets the value of the path field.
 * @param {!sketchology.proto.Path} value The value.
 */
sketchology.proto.Element.prototype.setPath = function(value) {
  this.set$Value(9, value);
};


/**
 * @return {boolean} Whether the path field has a value.
 */
sketchology.proto.Element.prototype.hasPath = function() {
  return this.has$Value(9);
};


/**
 * @return {number} The number of values in the path field.
 */
sketchology.proto.Element.prototype.pathCount = function() {
  return this.count$Values(9);
};


/**
 * Clears the values in the path field.
 */
sketchology.proto.Element.prototype.clearPath = function() {
  this.clear$Field(9);
};


/**
 * Gets the value of the attributes field.
 * @return {?sketchology.proto.ElementAttributes} The value.
 */
sketchology.proto.Element.prototype.getAttributes = function() {
  return /** @type {?sketchology.proto.ElementAttributes} */ (this.get$Value(10));
};


/**
 * Gets the value of the attributes field or the default value if not set.
 * @return {!sketchology.proto.ElementAttributes} The value.
 */
sketchology.proto.Element.prototype.getAttributesOrDefault = function() {
  return /** @type {!sketchology.proto.ElementAttributes} */ (this.get$ValueOrDefault(10));
};


/**
 * Sets the value of the attributes field.
 * @param {!sketchology.proto.ElementAttributes} value The value.
 */
sketchology.proto.Element.prototype.setAttributes = function(value) {
  this.set$Value(10, value);
};


/**
 * @return {boolean} Whether the attributes field has a value.
 */
sketchology.proto.Element.prototype.hasAttributes = function() {
  return this.has$Value(10);
};


/**
 * @return {number} The number of values in the attributes field.
 */
sketchology.proto.Element.prototype.attributesCount = function() {
  return this.count$Values(10);
};


/**
 * Clears the values in the attributes field.
 */
sketchology.proto.Element.prototype.clearAttributes = function() {
  this.clear$Field(10);
};



/**
 * Message ElementAttributes.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.ElementAttributes = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.ElementAttributes, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.ElementAttributes.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.ElementAttributes} The cloned message.
 * @override
 */
sketchology.proto.ElementAttributes.prototype.clone;


/**
 * Gets the value of the selectable field.
 * @return {?boolean} The value.
 */
sketchology.proto.ElementAttributes.prototype.getSelectable = function() {
  return /** @type {?boolean} */ (this.get$Value(1));
};


/**
 * Gets the value of the selectable field or the default value if not set.
 * @return {boolean} The value.
 */
sketchology.proto.ElementAttributes.prototype.getSelectableOrDefault = function() {
  return /** @type {boolean} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the selectable field.
 * @param {boolean} value The value.
 */
sketchology.proto.ElementAttributes.prototype.setSelectable = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the selectable field has a value.
 */
sketchology.proto.ElementAttributes.prototype.hasSelectable = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the selectable field.
 */
sketchology.proto.ElementAttributes.prototype.selectableCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the selectable field.
 */
sketchology.proto.ElementAttributes.prototype.clearSelectable = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the magic_erasable field.
 * @return {?boolean} The value.
 */
sketchology.proto.ElementAttributes.prototype.getMagicErasable = function() {
  return /** @type {?boolean} */ (this.get$Value(2));
};


/**
 * Gets the value of the magic_erasable field or the default value if not set.
 * @return {boolean} The value.
 */
sketchology.proto.ElementAttributes.prototype.getMagicErasableOrDefault = function() {
  return /** @type {boolean} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the magic_erasable field.
 * @param {boolean} value The value.
 */
sketchology.proto.ElementAttributes.prototype.setMagicErasable = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the magic_erasable field has a value.
 */
sketchology.proto.ElementAttributes.prototype.hasMagicErasable = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the magic_erasable field.
 */
sketchology.proto.ElementAttributes.prototype.magicErasableCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the magic_erasable field.
 */
sketchology.proto.ElementAttributes.prototype.clearMagicErasable = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the is_sticker field.
 * @return {?boolean} The value.
 */
sketchology.proto.ElementAttributes.prototype.getIsSticker = function() {
  return /** @type {?boolean} */ (this.get$Value(3));
};


/**
 * Gets the value of the is_sticker field or the default value if not set.
 * @return {boolean} The value.
 */
sketchology.proto.ElementAttributes.prototype.getIsStickerOrDefault = function() {
  return /** @type {boolean} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the is_sticker field.
 * @param {boolean} value The value.
 */
sketchology.proto.ElementAttributes.prototype.setIsSticker = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the is_sticker field has a value.
 */
sketchology.proto.ElementAttributes.prototype.hasIsSticker = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the is_sticker field.
 */
sketchology.proto.ElementAttributes.prototype.isStickerCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the is_sticker field.
 */
sketchology.proto.ElementAttributes.prototype.clearIsSticker = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the is_text field.
 * @return {?boolean} The value.
 */
sketchology.proto.ElementAttributes.prototype.getIsText = function() {
  return /** @type {?boolean} */ (this.get$Value(4));
};


/**
 * Gets the value of the is_text field or the default value if not set.
 * @return {boolean} The value.
 */
sketchology.proto.ElementAttributes.prototype.getIsTextOrDefault = function() {
  return /** @type {boolean} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the is_text field.
 * @param {boolean} value The value.
 */
sketchology.proto.ElementAttributes.prototype.setIsText = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the is_text field has a value.
 */
sketchology.proto.ElementAttributes.prototype.hasIsText = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the is_text field.
 */
sketchology.proto.ElementAttributes.prototype.isTextCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the is_text field.
 */
sketchology.proto.ElementAttributes.prototype.clearIsText = function() {
  this.clear$Field(4);
};



/**
 * Message UncompressedElement.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.UncompressedElement = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.UncompressedElement, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.UncompressedElement.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.UncompressedElement} The cloned message.
 * @override
 */
sketchology.proto.UncompressedElement.prototype.clone;


/**
 * Gets the value of the uncompressed_stroke field.
 * @return {?sketchology.proto.UncompressedStroke} The value.
 */
sketchology.proto.UncompressedElement.prototype.getUncompressedStroke = function() {
  return /** @type {?sketchology.proto.UncompressedStroke} */ (this.get$Value(1));
};


/**
 * Gets the value of the uncompressed_stroke field or the default value if not set.
 * @return {!sketchology.proto.UncompressedStroke} The value.
 */
sketchology.proto.UncompressedElement.prototype.getUncompressedStrokeOrDefault = function() {
  return /** @type {!sketchology.proto.UncompressedStroke} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the uncompressed_stroke field.
 * @param {!sketchology.proto.UncompressedStroke} value The value.
 */
sketchology.proto.UncompressedElement.prototype.setUncompressedStroke = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the uncompressed_stroke field has a value.
 */
sketchology.proto.UncompressedElement.prototype.hasUncompressedStroke = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the uncompressed_stroke field.
 */
sketchology.proto.UncompressedElement.prototype.uncompressedStrokeCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the uncompressed_stroke field.
 */
sketchology.proto.UncompressedElement.prototype.clearUncompressedStroke = function() {
  this.clear$Field(1);
};



/**
 * Message ElementMutation.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.ElementMutation = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.ElementMutation, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.ElementMutation.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.ElementMutation} The cloned message.
 * @override
 */
sketchology.proto.ElementMutation.prototype.clone;


/**
 * Gets the value of the uuid field at the index given.
 * @param {number} index The index to lookup.
 * @return {?string} The value.
 */
sketchology.proto.ElementMutation.prototype.getUuid = function(index) {
  return /** @type {?string} */ (this.get$Value(1, index));
};


/**
 * Gets the value of the uuid field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {string} The value.
 */
sketchology.proto.ElementMutation.prototype.getUuidOrDefault = function(index) {
  return /** @type {string} */ (this.get$ValueOrDefault(1, index));
};


/**
 * Adds a value to the uuid field.
 * @param {string} value The value to add.
 */
sketchology.proto.ElementMutation.prototype.addUuid = function(value) {
  this.add$Value(1, value);
};


/**
 * Returns the array of values in the uuid field.
 * @return {!Array<string>} The values in the field.
 */
sketchology.proto.ElementMutation.prototype.uuidArray = function() {
  return /** @type {!Array<string>} */ (this.array$Values(1));
};


/**
 * @return {boolean} Whether the uuid field has a value.
 */
sketchology.proto.ElementMutation.prototype.hasUuid = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the uuid field.
 */
sketchology.proto.ElementMutation.prototype.uuidCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the uuid field.
 */
sketchology.proto.ElementMutation.prototype.clearUuid = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the transform field at the index given.
 * @param {number} index The index to lookup.
 * @return {?sketchology.proto.AffineTransform} The value.
 */
sketchology.proto.ElementMutation.prototype.getTransform = function(index) {
  return /** @type {?sketchology.proto.AffineTransform} */ (this.get$Value(2, index));
};


/**
 * Gets the value of the transform field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {!sketchology.proto.AffineTransform} The value.
 */
sketchology.proto.ElementMutation.prototype.getTransformOrDefault = function(index) {
  return /** @type {!sketchology.proto.AffineTransform} */ (this.get$ValueOrDefault(2, index));
};


/**
 * Adds a value to the transform field.
 * @param {!sketchology.proto.AffineTransform} value The value to add.
 */
sketchology.proto.ElementMutation.prototype.addTransform = function(value) {
  this.add$Value(2, value);
};


/**
 * Returns the array of values in the transform field.
 * @return {!Array<!sketchology.proto.AffineTransform>} The values in the field.
 */
sketchology.proto.ElementMutation.prototype.transformArray = function() {
  return /** @type {!Array<!sketchology.proto.AffineTransform>} */ (this.array$Values(2));
};


/**
 * @return {boolean} Whether the transform field has a value.
 */
sketchology.proto.ElementMutation.prototype.hasTransform = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the transform field.
 */
sketchology.proto.ElementMutation.prototype.transformCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the transform field.
 */
sketchology.proto.ElementMutation.prototype.clearTransform = function() {
  this.clear$Field(2);
};



/**
 * Message ElementIdList.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.ElementIdList = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.ElementIdList, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.ElementIdList.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.ElementIdList} The cloned message.
 * @override
 */
sketchology.proto.ElementIdList.prototype.clone;


/**
 * Gets the value of the uuid field at the index given.
 * @param {number} index The index to lookup.
 * @return {?string} The value.
 */
sketchology.proto.ElementIdList.prototype.getUuid = function(index) {
  return /** @type {?string} */ (this.get$Value(1, index));
};


/**
 * Gets the value of the uuid field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {string} The value.
 */
sketchology.proto.ElementIdList.prototype.getUuidOrDefault = function(index) {
  return /** @type {string} */ (this.get$ValueOrDefault(1, index));
};


/**
 * Adds a value to the uuid field.
 * @param {string} value The value to add.
 */
sketchology.proto.ElementIdList.prototype.addUuid = function(value) {
  this.add$Value(1, value);
};


/**
 * Returns the array of values in the uuid field.
 * @return {!Array<string>} The values in the field.
 */
sketchology.proto.ElementIdList.prototype.uuidArray = function() {
  return /** @type {!Array<string>} */ (this.array$Values(1));
};


/**
 * @return {boolean} Whether the uuid field has a value.
 */
sketchology.proto.ElementIdList.prototype.hasUuid = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the uuid field.
 */
sketchology.proto.ElementIdList.prototype.uuidCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the uuid field.
 */
sketchology.proto.ElementIdList.prototype.clearUuid = function() {
  this.clear$Field(1);
};



/**
 * Message Point.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.Point = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.Point, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.Point.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.Point} The cloned message.
 * @override
 */
sketchology.proto.Point.prototype.clone;


/**
 * Gets the value of the x field.
 * @return {?number} The value.
 */
sketchology.proto.Point.prototype.getX = function() {
  return /** @type {?number} */ (this.get$Value(1));
};


/**
 * Gets the value of the x field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.Point.prototype.getXOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the x field.
 * @param {number} value The value.
 */
sketchology.proto.Point.prototype.setX = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the x field has a value.
 */
sketchology.proto.Point.prototype.hasX = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the x field.
 */
sketchology.proto.Point.prototype.xCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the x field.
 */
sketchology.proto.Point.prototype.clearX = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the y field.
 * @return {?number} The value.
 */
sketchology.proto.Point.prototype.getY = function() {
  return /** @type {?number} */ (this.get$Value(2));
};


/**
 * Gets the value of the y field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.Point.prototype.getYOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the y field.
 * @param {number} value The value.
 */
sketchology.proto.Point.prototype.setY = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the y field has a value.
 */
sketchology.proto.Point.prototype.hasY = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the y field.
 */
sketchology.proto.Point.prototype.yCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the y field.
 */
sketchology.proto.Point.prototype.clearY = function() {
  this.clear$Field(2);
};



/**
 * Message ElementBundle.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.ElementBundle = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.ElementBundle, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.ElementBundle.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.ElementBundle} The cloned message.
 * @override
 */
sketchology.proto.ElementBundle.prototype.clone;


/**
 * Gets the value of the uuid field.
 * @return {?string} The value.
 */
sketchology.proto.ElementBundle.prototype.getUuid = function() {
  return /** @type {?string} */ (this.get$Value(1));
};


/**
 * Gets the value of the uuid field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.ElementBundle.prototype.getUuidOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the uuid field.
 * @param {string} value The value.
 */
sketchology.proto.ElementBundle.prototype.setUuid = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the uuid field has a value.
 */
sketchology.proto.ElementBundle.prototype.hasUuid = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the uuid field.
 */
sketchology.proto.ElementBundle.prototype.uuidCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the uuid field.
 */
sketchology.proto.ElementBundle.prototype.clearUuid = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the element field.
 * @return {?sketchology.proto.Element} The value.
 */
sketchology.proto.ElementBundle.prototype.getElement = function() {
  return /** @type {?sketchology.proto.Element} */ (this.get$Value(2));
};


/**
 * Gets the value of the element field or the default value if not set.
 * @return {!sketchology.proto.Element} The value.
 */
sketchology.proto.ElementBundle.prototype.getElementOrDefault = function() {
  return /** @type {!sketchology.proto.Element} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the element field.
 * @param {!sketchology.proto.Element} value The value.
 */
sketchology.proto.ElementBundle.prototype.setElement = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the element field has a value.
 */
sketchology.proto.ElementBundle.prototype.hasElement = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the element field.
 */
sketchology.proto.ElementBundle.prototype.elementCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the element field.
 */
sketchology.proto.ElementBundle.prototype.clearElement = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the transform field.
 * @return {?sketchology.proto.AffineTransform} The value.
 */
sketchology.proto.ElementBundle.prototype.getTransform = function() {
  return /** @type {?sketchology.proto.AffineTransform} */ (this.get$Value(3));
};


/**
 * Gets the value of the transform field or the default value if not set.
 * @return {!sketchology.proto.AffineTransform} The value.
 */
sketchology.proto.ElementBundle.prototype.getTransformOrDefault = function() {
  return /** @type {!sketchology.proto.AffineTransform} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the transform field.
 * @param {!sketchology.proto.AffineTransform} value The value.
 */
sketchology.proto.ElementBundle.prototype.setTransform = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the transform field has a value.
 */
sketchology.proto.ElementBundle.prototype.hasTransform = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the transform field.
 */
sketchology.proto.ElementBundle.prototype.transformCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the transform field.
 */
sketchology.proto.ElementBundle.prototype.clearTransform = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the uncompressed_element field.
 * @return {?sketchology.proto.UncompressedElement} The value.
 */
sketchology.proto.ElementBundle.prototype.getUncompressedElement = function() {
  return /** @type {?sketchology.proto.UncompressedElement} */ (this.get$Value(4));
};


/**
 * Gets the value of the uncompressed_element field or the default value if not set.
 * @return {!sketchology.proto.UncompressedElement} The value.
 */
sketchology.proto.ElementBundle.prototype.getUncompressedElementOrDefault = function() {
  return /** @type {!sketchology.proto.UncompressedElement} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the uncompressed_element field.
 * @param {!sketchology.proto.UncompressedElement} value The value.
 */
sketchology.proto.ElementBundle.prototype.setUncompressedElement = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the uncompressed_element field has a value.
 */
sketchology.proto.ElementBundle.prototype.hasUncompressedElement = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the uncompressed_element field.
 */
sketchology.proto.ElementBundle.prototype.uncompressedElementCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the uncompressed_element field.
 */
sketchology.proto.ElementBundle.prototype.clearUncompressedElement = function() {
  this.clear$Field(4);
};



/**
 * Message Path.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.Path = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.Path, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.Path.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.Path} The cloned message.
 * @override
 */
sketchology.proto.Path.prototype.clone;


/**
 * Gets the value of the segment_types field at the index given.
 * @param {number} index The index to lookup.
 * @return {?sketchology.proto.Path.SegmentType} The value.
 */
sketchology.proto.Path.prototype.getSegmentTypes = function(index) {
  return /** @type {?sketchology.proto.Path.SegmentType} */ (this.get$Value(1, index));
};


/**
 * Gets the value of the segment_types field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {!sketchology.proto.Path.SegmentType} The value.
 */
sketchology.proto.Path.prototype.getSegmentTypesOrDefault = function(index) {
  return /** @type {!sketchology.proto.Path.SegmentType} */ (this.get$ValueOrDefault(1, index));
};


/**
 * Adds a value to the segment_types field.
 * @param {!sketchology.proto.Path.SegmentType} value The value to add.
 */
sketchology.proto.Path.prototype.addSegmentTypes = function(value) {
  this.add$Value(1, value);
};


/**
 * Returns the array of values in the segment_types field.
 * @return {!Array<!sketchology.proto.Path.SegmentType>} The values in the field.
 */
sketchology.proto.Path.prototype.segmentTypesArray = function() {
  return /** @type {!Array<!sketchology.proto.Path.SegmentType>} */ (this.array$Values(1));
};


/**
 * @return {boolean} Whether the segment_types field has a value.
 */
sketchology.proto.Path.prototype.hasSegmentTypes = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the segment_types field.
 */
sketchology.proto.Path.prototype.segmentTypesCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the segment_types field.
 */
sketchology.proto.Path.prototype.clearSegmentTypes = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the segment_counts field at the index given.
 * @param {number} index The index to lookup.
 * @return {?number} The value.
 */
sketchology.proto.Path.prototype.getSegmentCounts = function(index) {
  return /** @type {?number} */ (this.get$Value(2, index));
};


/**
 * Gets the value of the segment_counts field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {number} The value.
 */
sketchology.proto.Path.prototype.getSegmentCountsOrDefault = function(index) {
  return /** @type {number} */ (this.get$ValueOrDefault(2, index));
};


/**
 * Adds a value to the segment_counts field.
 * @param {number} value The value to add.
 */
sketchology.proto.Path.prototype.addSegmentCounts = function(value) {
  this.add$Value(2, value);
};


/**
 * Returns the array of values in the segment_counts field.
 * @return {!Array<number>} The values in the field.
 */
sketchology.proto.Path.prototype.segmentCountsArray = function() {
  return /** @type {!Array<number>} */ (this.array$Values(2));
};


/**
 * @return {boolean} Whether the segment_counts field has a value.
 */
sketchology.proto.Path.prototype.hasSegmentCounts = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the segment_counts field.
 */
sketchology.proto.Path.prototype.segmentCountsCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the segment_counts field.
 */
sketchology.proto.Path.prototype.clearSegmentCounts = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the segment_args field at the index given.
 * @param {number} index The index to lookup.
 * @return {?number} The value.
 */
sketchology.proto.Path.prototype.getSegmentArgs = function(index) {
  return /** @type {?number} */ (this.get$Value(3, index));
};


/**
 * Gets the value of the segment_args field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {number} The value.
 */
sketchology.proto.Path.prototype.getSegmentArgsOrDefault = function(index) {
  return /** @type {number} */ (this.get$ValueOrDefault(3, index));
};


/**
 * Adds a value to the segment_args field.
 * @param {number} value The value to add.
 */
sketchology.proto.Path.prototype.addSegmentArgs = function(value) {
  this.add$Value(3, value);
};


/**
 * Returns the array of values in the segment_args field.
 * @return {!Array<number>} The values in the field.
 */
sketchology.proto.Path.prototype.segmentArgsArray = function() {
  return /** @type {!Array<number>} */ (this.array$Values(3));
};


/**
 * @return {boolean} Whether the segment_args field has a value.
 */
sketchology.proto.Path.prototype.hasSegmentArgs = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the segment_args field.
 */
sketchology.proto.Path.prototype.segmentArgsCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the segment_args field.
 */
sketchology.proto.Path.prototype.clearSegmentArgs = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the radius field.
 * @return {?number} The value.
 */
sketchology.proto.Path.prototype.getRadius = function() {
  return /** @type {?number} */ (this.get$Value(4));
};


/**
 * Gets the value of the radius field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.Path.prototype.getRadiusOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the radius field.
 * @param {number} value The value.
 */
sketchology.proto.Path.prototype.setRadius = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the radius field has a value.
 */
sketchology.proto.Path.prototype.hasRadius = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the radius field.
 */
sketchology.proto.Path.prototype.radiusCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the radius field.
 */
sketchology.proto.Path.prototype.clearRadius = function() {
  this.clear$Field(4);
};


/**
 * Gets the value of the rgba field.
 * @return {?number} The value.
 */
sketchology.proto.Path.prototype.getRgba = function() {
  return /** @type {?number} */ (this.get$Value(5));
};


/**
 * Gets the value of the rgba field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.Path.prototype.getRgbaOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(5));
};


/**
 * Sets the value of the rgba field.
 * @param {number} value The value.
 */
sketchology.proto.Path.prototype.setRgba = function(value) {
  this.set$Value(5, value);
};


/**
 * @return {boolean} Whether the rgba field has a value.
 */
sketchology.proto.Path.prototype.hasRgba = function() {
  return this.has$Value(5);
};


/**
 * @return {number} The number of values in the rgba field.
 */
sketchology.proto.Path.prototype.rgbaCount = function() {
  return this.count$Values(5);
};


/**
 * Clears the values in the rgba field.
 */
sketchology.proto.Path.prototype.clearRgba = function() {
  this.clear$Field(5);
};


/**
 * Gets the value of the end_cap field.
 * @return {?sketchology.proto.Path.EndCapType} The value.
 */
sketchology.proto.Path.prototype.getEndCap = function() {
  return /** @type {?sketchology.proto.Path.EndCapType} */ (this.get$Value(6));
};


/**
 * Gets the value of the end_cap field or the default value if not set.
 * @return {!sketchology.proto.Path.EndCapType} The value.
 */
sketchology.proto.Path.prototype.getEndCapOrDefault = function() {
  return /** @type {!sketchology.proto.Path.EndCapType} */ (this.get$ValueOrDefault(6));
};


/**
 * Sets the value of the end_cap field.
 * @param {!sketchology.proto.Path.EndCapType} value The value.
 */
sketchology.proto.Path.prototype.setEndCap = function(value) {
  this.set$Value(6, value);
};


/**
 * @return {boolean} Whether the end_cap field has a value.
 */
sketchology.proto.Path.prototype.hasEndCap = function() {
  return this.has$Value(6);
};


/**
 * @return {number} The number of values in the end_cap field.
 */
sketchology.proto.Path.prototype.endCapCount = function() {
  return this.count$Values(6);
};


/**
 * Clears the values in the end_cap field.
 */
sketchology.proto.Path.prototype.clearEndCap = function() {
  this.clear$Field(6);
};


/**
 * Gets the value of the fill_rgba field.
 * @return {?number} The value.
 */
sketchology.proto.Path.prototype.getFillRgba = function() {
  return /** @type {?number} */ (this.get$Value(7));
};


/**
 * Gets the value of the fill_rgba field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.Path.prototype.getFillRgbaOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(7));
};


/**
 * Sets the value of the fill_rgba field.
 * @param {number} value The value.
 */
sketchology.proto.Path.prototype.setFillRgba = function(value) {
  this.set$Value(7, value);
};


/**
 * @return {boolean} Whether the fill_rgba field has a value.
 */
sketchology.proto.Path.prototype.hasFillRgba = function() {
  return this.has$Value(7);
};


/**
 * @return {number} The number of values in the fill_rgba field.
 */
sketchology.proto.Path.prototype.fillRgbaCount = function() {
  return this.count$Values(7);
};


/**
 * Clears the values in the fill_rgba field.
 */
sketchology.proto.Path.prototype.clearFillRgba = function() {
  this.clear$Field(7);
};


/**
 * Enumeration SegmentType.
 * @enum {number}
 */
sketchology.proto.Path.SegmentType = {
  UNKNOWN: 0,
  MOVE_TO: 1,
  LINE_TO: 2,
  CURVE_TO: 3,
  QUAD_TO: 4,
  CLOSE: 5
};


/**
 * Enumeration EndCapType.
 * @enum {number}
 */
sketchology.proto.Path.EndCapType = {
  BUTT: 1,
  ROUND: 2,
  SQUARE: 3
};


/** @override */
sketchology.proto.CallbackFlags.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.CallbackFlags.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'CallbackFlags',
        fullName: 'sketchology.proto.CallbackFlags'
      },
      1: {
        name: 'mesh_data_ctm',
        fieldType: goog.proto2.Message.FieldType.BOOL,
        type: Boolean
      },
      2: {
        name: 'uncompressed_outline',
        fieldType: goog.proto2.Message.FieldType.BOOL,
        type: Boolean
      },
      3: {
        name: 'compressed_input_points',
        fieldType: goog.proto2.Message.FieldType.BOOL,
        type: Boolean
      }
    };
    sketchology.proto.CallbackFlags.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.CallbackFlags, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.CallbackFlags.getDescriptor =
    sketchology.proto.CallbackFlags.prototype.getDescriptor;


/** @override */
sketchology.proto.SourceDetails.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.SourceDetails.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'SourceDetails',
        fullName: 'sketchology.proto.SourceDetails'
      },
      1: {
        name: 'origin',
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: sketchology.proto.SourceDetails.Origin.UNKNOWN,
        type: sketchology.proto.SourceDetails.Origin
      },
      2: {
        name: 'host_source_details',
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      }
    };
    sketchology.proto.SourceDetails.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.SourceDetails, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.SourceDetails.getDescriptor =
    sketchology.proto.SourceDetails.prototype.getDescriptor;


/** @override */
sketchology.proto.BackgroundImageInfo.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.BackgroundImageInfo.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'BackgroundImageInfo',
        fullName: 'sketchology.proto.BackgroundImageInfo'
      },
      1: {
        name: 'uri',
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      },
      3: {
        name: 'bounds',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Rect
      }
    };
    sketchology.proto.BackgroundImageInfo.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.BackgroundImageInfo, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.BackgroundImageInfo.getDescriptor =
    sketchology.proto.BackgroundImageInfo.prototype.getDescriptor;


/** @override */
sketchology.proto.Border.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.Border.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'Border',
        fullName: 'sketchology.proto.Border'
      },
      1: {
        name: 'uri',
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      },
      2: {
        name: 'scale',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        defaultValue: 1,
        type: Number
      }
    };
    sketchology.proto.Border.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.Border, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.Border.getDescriptor =
    sketchology.proto.Border.prototype.getDescriptor;


/** @override */
sketchology.proto.LOD.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.LOD.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'LOD',
        fullName: 'sketchology.proto.LOD'
      },
      1: {
        name: 'max_coverage',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      2: {
        name: 'ctm_blob',
        fieldType: goog.proto2.Message.FieldType.BYTES,
        type: String
      }
    };
    sketchology.proto.LOD.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.LOD, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.LOD.getDescriptor =
    sketchology.proto.LOD.prototype.getDescriptor;


/** @override */
sketchology.proto.Stroke.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.Stroke.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'Stroke',
        fullName: 'sketchology.proto.Stroke'
      },
      1: {
        name: 'shader_type',
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: sketchology.proto.ShaderType.NONE,
        type: sketchology.proto.ShaderType
      },
      3: {
        name: 'lod',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.LOD
      },
      4: {
        name: 'abgr',
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      },
      5: {
        name: 'point_x',
        repeated: true,
        packed: true,
        fieldType: goog.proto2.Message.FieldType.SINT32,
        type: Number
      },
      6: {
        name: 'point_y',
        repeated: true,
        packed: true,
        fieldType: goog.proto2.Message.FieldType.SINT32,
        type: Number
      },
      7: {
        name: 'point_t_ms',
        repeated: true,
        packed: true,
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      },
      8: {
        name: 'deprecated_transform',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.AffineTransform
      },
      9: {
        name: 'start_time_ms',
        fieldType: goog.proto2.Message.FieldType.UINT64,
        type: String
      }
    };
    sketchology.proto.Stroke.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.Stroke, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.Stroke.getDescriptor =
    sketchology.proto.Stroke.prototype.getDescriptor;


/** @override */
sketchology.proto.UncompressedStroke.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.UncompressedStroke.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'UncompressedStroke',
        fullName: 'sketchology.proto.UncompressedStroke'
      },
      1: {
        name: 'outline',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Point
      },
      2: {
        name: 'rgba',
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      }
    };
    sketchology.proto.UncompressedStroke.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.UncompressedStroke, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.UncompressedStroke.getDescriptor =
    sketchology.proto.UncompressedStroke.prototype.getDescriptor;


/** @override */
sketchology.proto.AffineTransform.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.AffineTransform.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'AffineTransform',
        fullName: 'sketchology.proto.AffineTransform'
      },
      1: {
        name: 'tx',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      2: {
        name: 'ty',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      3: {
        name: 'scale_x',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        defaultValue: 1,
        type: Number
      },
      4: {
        name: 'scale_y',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        defaultValue: 1,
        type: Number
      },
      5: {
        name: 'rotation_radians',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      }
    };
    sketchology.proto.AffineTransform.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.AffineTransform, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.AffineTransform.getDescriptor =
    sketchology.proto.AffineTransform.prototype.getDescriptor;


/** @override */
sketchology.proto.Element.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.Element.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'Element',
        fullName: 'sketchology.proto.Element'
      },
      4: {
        name: 'deprecated_uuid',
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      },
      5: {
        name: 'minimum_serializer_version',
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      },
      6: {
        name: 'stroke',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Stroke
      },
      9: {
        name: 'path',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Path
      },
      10: {
        name: 'attributes',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.ElementAttributes
      }
    };
    sketchology.proto.Element.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.Element, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.Element.getDescriptor =
    sketchology.proto.Element.prototype.getDescriptor;


/** @override */
sketchology.proto.ElementAttributes.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.ElementAttributes.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'ElementAttributes',
        fullName: 'sketchology.proto.ElementAttributes'
      },
      1: {
        name: 'selectable',
        fieldType: goog.proto2.Message.FieldType.BOOL,
        defaultValue: true,
        type: Boolean
      },
      2: {
        name: 'magic_erasable',
        fieldType: goog.proto2.Message.FieldType.BOOL,
        defaultValue: true,
        type: Boolean
      },
      3: {
        name: 'is_sticker',
        fieldType: goog.proto2.Message.FieldType.BOOL,
        defaultValue: false,
        type: Boolean
      },
      4: {
        name: 'is_text',
        fieldType: goog.proto2.Message.FieldType.BOOL,
        defaultValue: false,
        type: Boolean
      }
    };
    sketchology.proto.ElementAttributes.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.ElementAttributes, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.ElementAttributes.getDescriptor =
    sketchology.proto.ElementAttributes.prototype.getDescriptor;


/** @override */
sketchology.proto.UncompressedElement.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.UncompressedElement.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'UncompressedElement',
        fullName: 'sketchology.proto.UncompressedElement'
      },
      1: {
        name: 'uncompressed_stroke',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.UncompressedStroke
      }
    };
    sketchology.proto.UncompressedElement.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.UncompressedElement, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.UncompressedElement.getDescriptor =
    sketchology.proto.UncompressedElement.prototype.getDescriptor;


/** @override */
sketchology.proto.ElementMutation.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.ElementMutation.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'ElementMutation',
        fullName: 'sketchology.proto.ElementMutation'
      },
      1: {
        name: 'uuid',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      },
      2: {
        name: 'transform',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.AffineTransform
      }
    };
    sketchology.proto.ElementMutation.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.ElementMutation, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.ElementMutation.getDescriptor =
    sketchology.proto.ElementMutation.prototype.getDescriptor;


/** @override */
sketchology.proto.ElementIdList.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.ElementIdList.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'ElementIdList',
        fullName: 'sketchology.proto.ElementIdList'
      },
      1: {
        name: 'uuid',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      }
    };
    sketchology.proto.ElementIdList.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.ElementIdList, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.ElementIdList.getDescriptor =
    sketchology.proto.ElementIdList.prototype.getDescriptor;


/** @override */
sketchology.proto.Point.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.Point.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'Point',
        fullName: 'sketchology.proto.Point'
      },
      1: {
        name: 'x',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      2: {
        name: 'y',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      }
    };
    sketchology.proto.Point.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.Point, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.Point.getDescriptor =
    sketchology.proto.Point.prototype.getDescriptor;


/** @override */
sketchology.proto.ElementBundle.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.ElementBundle.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'ElementBundle',
        fullName: 'sketchology.proto.ElementBundle'
      },
      1: {
        name: 'uuid',
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      },
      2: {
        name: 'element',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Element
      },
      3: {
        name: 'transform',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.AffineTransform
      },
      4: {
        name: 'uncompressed_element',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.UncompressedElement
      }
    };
    sketchology.proto.ElementBundle.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.ElementBundle, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.ElementBundle.getDescriptor =
    sketchology.proto.ElementBundle.prototype.getDescriptor;


/** @override */
sketchology.proto.Path.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.Path.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'Path',
        fullName: 'sketchology.proto.Path'
      },
      1: {
        name: 'segment_types',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: sketchology.proto.Path.SegmentType.UNKNOWN,
        type: sketchology.proto.Path.SegmentType
      },
      2: {
        name: 'segment_counts',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      },
      3: {
        name: 'segment_args',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.DOUBLE,
        type: Number
      },
      4: {
        name: 'radius',
        fieldType: goog.proto2.Message.FieldType.DOUBLE,
        defaultValue: 1,
        type: Number
      },
      5: {
        name: 'rgba',
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      },
      6: {
        name: 'end_cap',
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: sketchology.proto.Path.EndCapType.ROUND,
        type: sketchology.proto.Path.EndCapType
      },
      7: {
        name: 'fill_rgba',
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      }
    };
    sketchology.proto.Path.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.Path, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.Path.getDescriptor =
    sketchology.proto.Path.prototype.getDescriptor;
