/*
 * Copyright (C) 2013-2015 Canonical, Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License version 3, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranties of MERCHANTABILITY,
 * SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "display.h"

#include "screen.h"
#include "mirserver.h"

#include <mir/graphics/display.h>
#include <mir/graphics/display_configuration.h>

namespace mg = mir::graphics;

// TODO: Listen for display changes and update the list accordingly

Display::Display(const std::shared_ptr<mir::graphics::DisplayConfiguration> &displayConfig)
{
    displayConfig->for_each_output([this](mg::DisplayConfigurationOutput const& output) {
        if (output.used) {
            auto screen = new Screen(output);
            m_screens.push_back(screen);
        }
    });
}

Display::~Display()
{
    for (auto screen : m_screens)
        delete screen;
    m_screens.clear();
}
