/**************************************************************************
**
** This file is part of Qt Creator
**
** Copyright (c) 2011 Nokia Corporation and/or its subsidiary(-ies).
**
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** No Commercial Usage
**
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
**
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**************************************************************************/

#ifndef MAEMOMANAGER_H
#define MAEMOMANAGER_H

#include <QtCore/QObject>

namespace ProjectExplorer {
    class ToolChain;
}
using ProjectExplorer::ToolChain;

namespace Qt4ProjectManager {
    class QtVersion;
namespace Internal {

class MaemoDeployStepFactory;
class MaemoPackageCreationFactory;
class MaemoRunControlFactory;
class MaemoRunConfigurationFactory;
class MaemoSettingsPage;
class MaemoQemuManager;

class MaemoManager : public QObject
{
    Q_OBJECT

public:
    MaemoManager();
    ~MaemoManager();
    static MaemoManager &instance();

    bool isValidMaemoQtVersion(const Qt4ProjectManager::QtVersion *version) const;
    ToolChain *maemoToolChain(const Qt4ProjectManager::QtVersion *version) const;

    MaemoSettingsPage *settingsPage() const { return m_settingsPage; }

private:
    static MaemoManager *m_instance;

    MaemoRunControlFactory *m_runControlFactory;
    MaemoRunConfigurationFactory *m_runConfigurationFactory;
    MaemoPackageCreationFactory *m_packageCreationFactory;
    MaemoDeployStepFactory *m_deployStepFactory;
    MaemoSettingsPage *m_settingsPage;
    MaemoQemuManager *m_qemuRuntimeManager;
};

    } // namespace Internal
} // namespace Qt4ProjectManager

#endif // MAEMOMANAGER_H
