/*
* qgo.cpp
*/

#include "qgo.h"
#include "helpviewer.h"
#include "board.h"
#include "mainwindow.h"
#include "setting.h"

#include "config.h"
#include <qmessagebox.h>
#include <qsound.h>
#include <qdir.h>
#include <qmessagebox.h>
#include <qlineedit.h>

#ifdef Q_OS_MACX
#include <CoreFoundation/CFString.h>
#include <CoreFoundation/CFBundle.h>
#endif //Q_OS_MACX

qGo::qGo() : QObject()
{
	boardList = new QPtrList<MainWindow>;
	boardList->setAutoDelete(false);
	helpViewer = NULL;
	clickSound = NULL;
	talkSound = NULL;
	matchSound = NULL;
	passSound = NULL;
	gameEndSound = NULL;
	timeSound = NULL;
	saySound = NULL;
	enterSound = NULL;
	leaveSound = NULL;
	connectSound = NULL;
}

qGo::~qGo()
{
	boardList->clear();
	delete boardList;
	
	delete helpViewer;
	delete clickSound;

	//	settings = 0;
	boardList = 0;
	helpViewer = 0;
}

void qGo::quit()
{
	emit signal_leave_qgo();
	int check;
	if ((check = checkModified()) == 1 ||
		(!check &&
		!QMessageBox::warning(0, PACKAGE,
		tr("At least one board is modified.\n"
		"If you exit the application now, all changes will be lost!"
		"\nExit anyways?"),
		tr("Yes"), tr("No"), QString::null,
		1, 0)))
	{
		//	qApp->quit();
		qDebug("Program quits now...");
	}
	
	//    emit signal_leave_qgo();
}

MainWindow* qGo::addBoardWindow(MainWindow *w)
{
	if (w == NULL)
	{
		qWarning("*** BOARD HAS NO PARENT");
		w = new MainWindow(0, PACKAGE);
		w->getInterfaceHandler()->toggleMode();
		w->getInterfaceHandler()->toggleMode();
	}
	w->show();
	boardList->append(w);
	
	return w;
}

void qGo::removeBoardWindow(MainWindow *w)
{
	if (w == NULL)
	{
		qWarning("qGo::removeBoardWindow(QWidget *w) - paramter w is 0!");
		return;
	}
	
	if (!boardList->removeRef(w))
		qWarning("Failed to remove board from list.");
}

void qGo::openManual()
{
	if (helpViewer == NULL)
		helpViewer = new HelpViewer(0, "helpviewer");
	helpViewer->show();
	helpViewer->raise();
}


int qGo::checkModified()
{
	// Just closed the last board?
	if (boardList->isEmpty())
		return 1;
	
	// One board, same as closing a single window
	if (boardList->count() == 1)
		return ((MainWindow*)(boardList->first()))->checkModified(true);
    
	// Several boards. Check if one is modified.
	QWidget *b;
	for (b=boardList->first(); b != 0; b=boardList->next())
		if (!((MainWindow*)b)->checkModified(false))
			return 0;
		
	return 1;
}

void qGo::updateAllBoardSettings()
{
	for (QWidget *w=boardList->first(); w != 0; w=boardList->next())
		((MainWindow*)w)->updateBoard();
}

void qGo::updateFont()
{
	for (QWidget *w=boardList->first(); w != 0; w=boardList->next())
		((MainWindow*)w)->updateFont();

	emit signal_updateFont();
}

bool qGo::testSound(bool showmsg)
{
	// qDebug("qGo::testSound()");
	
	// Sound system supported?
	if (!QSound::available())
	{
		if (showmsg)
		{
#ifdef Q_WS_WIN
			QMessageBox::information(0, PACKAGE, tr("No sound available."));
			clickSound = NULL;
			return false;
#elif defined (Q_OS_MACX) 
			QMessageBox::information(0, PACKAGE, tr("No sound available. Qt on Mac uses QuickTime sound."));
#else
			QMessageBox::information(0, PACKAGE, tr("You are not running the Network Audio sytem.\n"
				"If you have the `au' command, run it in the background before this program. The latest release of the Network Audio System can be obtained from:\n\n"
				"ftp.ncd.com:/pub/ncd/technology/src/nas\n"
				"ftp.x.org:/contrib/audio/nas\n\n"
				"Release 1.2 of NAS is also included with the X11R6 contrib distribution. After installing NAS, you will then need to reconfigure Qt with NAS sound support.\n\n"
				"Nevertheless, if you have oss, sound should be working and directed to /dev/dsp"));
#endif
		}
	}
	else if (showmsg)
	{
		QMessageBox::information(0, PACKAGE, tr("Sound available."));
		return true;
	}
	
	//    qDebug("Sound available, checking for sound files...");

	// Sound files found?
	QStringList list;

	ASSERT(setting->program_dir);

#ifdef Q_WS_WIN
	list << applicationPath + "/sounds"
		<< setting->program_dir + "/sounds"
		<< "C:/Program Files/qGo/sounds"
		<< "D:/Program Files/qGo/sounds"
		<< "E:/Program Files/qGo/sounds"
		<< "C:/Programme/qGo/sounds"
		<< "D:/Programme/qGo/sounds"
		<< "E:/Programme/qGo/sounds"
		<< "./sounds";
#elif defined(Q_OS_MACX)
	//get the bundle path and find our resources like sounds
	CFURLRef bundleRef = CFBundleCopyBundleURL(CFBundleGetMainBundle());
	CFStringRef bundlePath = CFURLCopyFileSystemPath(bundleRef, kCFURLPOSIXPathStyle);
	list << (QString)CFStringGetCStringPtr(bundlePath, CFStringGetSystemEncoding())		
		+ "/Contents/Resources";
#else
	list << setting->program_dir + "/sounds"
		<< "./share/" PACKAGE "/sounds"
		<< "/usr/share/" PACKAGE "/sounds"
		<< "/usr/local/share/" PACKAGE "/sounds"
		<< "/sounds"
		<< "./sounds"
		<< "./src/sounds";                           //SL added eb 7
#endif

	for (QStringList::Iterator it = list.begin(); it != list.end(); ++it)
	{
		QDir d(*it);
		if (d.exists())
		{
			QString s = (QString)(*it);
			s.append("/stone.wav");
			if (QFile::exists(s))
				clickSound = new QSound(s);
			else
				qDebug("stone.wav not found...");

			s = (QString)(*it);
			s.append("/talk.wav");
			if (QFile::exists(s))
				talkSound = new QSound(s);
			else
				qDebug("talk.wav not found...");

			s = (QString)(*it);
			s.append("/match.wav");
			if (QFile::exists(s))
				matchSound = new QSound(s);
			else
				qDebug("match.wav not found...");

			s = (QString)(*it);
			s.append("/pass.wav");
			if (QFile::exists(s))
				passSound = new QSound(s);
			else
				qDebug("pass.wav not found...");

			s = (QString)(*it);
			s.append("/gameend.wav");
			if (QFile::exists(s))
				gameEndSound = new QSound(s);
			else
				qDebug("gameend.wav not found...");

			s = (QString)(*it);
			s.append("/tictoc.wav");
			if (QFile::exists(s))
				timeSound = new QSound(s);
			else
				qDebug("tictoc.wav not found...");

			s = (QString)(*it);
			s.append("/say.wav");
			if (QFile::exists(s))
				saySound = new QSound(s);
			else
				qDebug("say.wav not found...");
			
			s = (QString)(*it);
			s.append("/enter.wav");
			if (QFile::exists(s))
				enterSound = new QSound(s);
			else
				qDebug("enter.wav not found...");
			
			s = (QString)(*it);
			s.append("/leave.wav");
			if (QFile::exists(s))
				leaveSound = new QSound(s);
			else
				qDebug("leave.wav not found...");
			
			s = (QString)(*it);
			s.append("/connect.wav");
			if (QFile::exists(s))
				connectSound = new QSound(s);
			else
				qDebug("connect.wav not found...");
			
			// QMessageBox::information(0, "SOUND OK", s);
			//	    qDebug("Sound Ok. Soundfile: %s", s.latin1());
#ifdef Q_WS_WIN
			if (!applicationPath)
				applicationPath = s.left(s.find("/sounds"));
			// QMessageBox::information(0, "SAVING", applicationPath);
#endif
			return true;
		}
	}

#ifdef Q_OS_MACX
	QMessageBox::information(0, PACKAGE, tr("No sound files in bundle, strange.\n"));
#elif ! defined(Q_WS_WIN)
	QMessageBox::information(0, PACKAGE, tr("Sound files not found.") + "\n" +
		tr("Please check for the directories") + " /usr/local/share/" + PACKAGE + "/sounds/ " + tr("or") +
		" /usr/share/" + PACKAGE + "/sounds/, " + tr("depending on your installation."));
#else

	if (applicationPath = setting->readEntry("PATH_SOUND"))
		return testSound(false);

	QMessageBox::information(0, PACKAGE, tr("Sound files not found.") + "\n" +
			     tr("You can navigate to the main qGo directory (for example:") + " C:\\Program Files\\" + PACKAGE + " .\n" +
				 tr("If the directory was given correctly, this data will be saved and you won't"
				 "be asked\nanymore except you install qGo again into a different directory.\n"
				 "To abort this procedure, click 'Cancel' in the following dialog."));
    
	applicationPath = QFileDialog::getExistingDirectory(NULL, NULL, "appdir", tr("qGo directory"), true);
	
	if (applicationPath.isNull() || applicationPath.isEmpty())
	{
		QMessageBox::warning(0, PACKAGE, tr("No valid directory was given. Sound is not available."));
		return false;
	}

	// save path
   	setting->writeEntry("PATH_SOUND", applicationPath);

	// QMessageBox::information(0, "TRYING AGAIN", applicationPath);
	return testSound(false);
#endif
	return false;
}

void qGo::playClick()
{
	if (setting->readBoolEntry("SOUND_STONE") && clickSound)
	{                                                                      //added eb 7
#ifdef Q_OS_LINUX
		if (!clickSound->isAvailable())
			play(clickSound->fileName().latin1());
		else
#endif
			clickSound->play();
	}                                                                      //end add eb 7
}

void qGo::playAutoPlayClick()
{
	if (setting->readBoolEntry("SOUND_AUTOPLAY") && clickSound)
	{                                                                      //added eb 7
#ifdef Q_OS_LINUX
		if (!clickSound->isAvailable())
			play(clickSound->fileName().latin1());
		else
#endif
			clickSound->play();
	}                                                                      //end add eb 7
}

void qGo::playTalkSound()
{
	if (setting->readBoolEntry("SOUND_TALK") && talkSound)
	{                                                                      //added eb 7
#ifdef Q_OS_LINUX
		if (!talkSound->isAvailable())
			play(talkSound->fileName().latin1());
		else
#endif
			talkSound->play();
	}                                                                      //end add eb 7
}

void qGo::playMatchSound()
{
	if (setting->readBoolEntry("SOUND_MATCH") && matchSound)
	{                                                                      //added eb 7
#ifdef Q_OS_LINUX
		if (!matchSound->isAvailable())
			play(matchSound->fileName().latin1());
		else
#endif
			matchSound->play();
	}                                                                      //end add eb 7
}

void qGo::playPassSound()
{
	if (setting->readBoolEntry("SOUND_PASS") && passSound)
	{                                                                      //added eb 7
#ifdef Q_OS_LINUX
		if (!passSound->isAvailable())
			play(passSound->fileName().latin1());
		else
#endif
			passSound->play();
	}                                                                      //end add eb 7
}

void qGo::playGameEndSound()
{
	if (setting->readBoolEntry("SOUND_GAMEEND") && gameEndSound)
	{                                                                      //added eb 7
#ifdef Q_OS_LINUX
		if (!gameEndSound->isAvailable())
			play(gameEndSound->fileName().latin1());
		else
#endif
			gameEndSound->play();
	}                                                                      //end add eb 7
}

void qGo::playTimeSound()
{
	if (setting->readBoolEntry("SOUND_TIME") && timeSound)
	{                                                                      //added eb 7
#ifdef Q_OS_LINUX
		if (!timeSound->isAvailable())
			play(timeSound->fileName().latin1());
		else
#endif
			timeSound->play();
	}                                                                      //end add eb 7
}

void qGo::playSaySound()
{
	if (setting->readBoolEntry("SOUND_SAY") && saySound)
	{                                                                      //added eb 7
#ifdef Q_OS_LINUX
		if (!saySound->isAvailable())
			play(saySound->fileName().latin1());
		else
#endif
			saySound->play();
	}                                                                      //end add eb 7
}

void qGo::playEnterSound()
{
	if (setting->readBoolEntry("SOUND_ENTER") && enterSound)
	{                                                                      //added eb 7
#ifdef Q_OS_LINUX
		if (!enterSound->isAvailable())
			play(enterSound->fileName().latin1());
		else
#endif
			enterSound->play();
	}                                                                      //end add eb 7
}

void qGo::playLeaveSound()
{
	if (setting->readBoolEntry("SOUND_LEAVE") && leaveSound)
	{                                                                      //added eb 7
#ifdef Q_OS_LINUX
		if (!leaveSound->isAvailable())
			play(leaveSound->fileName().latin1());
		else
#endif
			leaveSound->play();
	}                                                                      //end add eb 7
}

void qGo::playConnectSound()
{


	if (setting->readBoolEntry("SOUND_CONNECT") && connectSound)
	{                                                                      //added eb 7
#ifdef Q_OS_LINUX
		if (!connectSound->isAvailable())
			play(connectSound->fileName().latin1());
		else
#endif
			connectSound->play();
	}                                                                      //end add eb 7
}

void qGo::playDisConnectSound()
{
	if (setting->readBoolEntry("SOUND_DISCONNECT") && connectSound)
	{                                                                      //added eb 7
#ifdef Q_OS_LINUX
		if (!connectSound->isAvailable())
			play(connectSound->fileName().latin1());
		else
#endif
			connectSound->play();
	}                                                                      //end add eb 7
}

void qGo::slotHelpAbout()
{
	QString txt = PACKAGE " " VERSION
		"\n\nCopyright (c) 2001-2004\nPeter Strempel <pstrempel@t-online.de>\nJohannes Mesa <frosla@gmx.at>\nEmmanuel Beranger <e2@beranger.com.fr>\n\n" +
		tr("GTP code from Goliath, thanks to:") + "\nPALM Thomas\nDINTILHAC Florian\nHIVERT Anthony\nPIOC Sebastien";
	
	QString translation = tr("English translation by:\nPeter Strempel\nJohannes Mesa\nEmmanuel Beranger", "Please set your own language and your name! Use your own language!");
	if (translation != "English translation by:\nPeter Strempel\nJohannes Mesa\nEmmanuel Beranger")
		txt += "\n\n" + translation;
	
	QMessageBox::about(0, tr("About..."), txt);
}
