/*
 * QIconOptions.h
 *
 * Copyright (C) 2001 Thomas Woerner, Michael Meissner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */


// Qt
///////
#include <qlayout.h>
#include <qlabel.h>

// Own
////////
#include "QIconOptions.h"



QIconOptions::QIconOptions(QWidget* parent, const char* name,
			   bool modal, WFlags fl)
    : QDialog(parent, name, modal, fl)
/****************************************************************/
{
   QGridLayout *pLayout;
   QLabel      *pLabel;

   resize(120, 60);

   if (!name)
      setName("QIconOptions");
   setSizeGripEnabled(TRUE);
   setSizePolicy(QSizePolicy((QSizePolicy::SizeType)7,
                             (QSizePolicy::SizeType)7,
                             sizePolicy().hasHeightForWidth()));

   pLayout = new QGridLayout(this, 5, 3, 10, 10);
   pLayout->setSpacing(10);
   pLayout->setMargin(10);

   pLabel = new QLabel(this, "arrowLabel");
   pLabel->setText(tr("Arrow size"));
   pLayout->addWidget(pLabel, 0, 0);

   m_pArrowSize = new QLineEdit("0.1", this);
   pLayout->addWidget(m_pArrowSize, 0, 1);

   pLabel = new QLabel(this, "frustumLabel");
   pLabel->setText(tr("Frustum size"));
   pLayout->addWidget(pLabel, 1, 0);

   m_pFrustumSize= new QLineEdit("0.1", this);
   pLayout->addWidget(m_pFrustumSize, 1, 1);
    
   connect(m_pArrowSize, SIGNAL(textChanged(const QString &)), SLOT(sltArrowSize(const QString &)));
   connect(m_pFrustumSize, SIGNAL(textChanged(const QString &)), SLOT(sltFrustumSize(const QString &)));
}
