/*
	Author: Marco Costalba (C) 2005-2006

	Copyright: See COPYING file that comes with this distribution
*/
#include <qapplication.h>
#include <qregexp.h>
#include "common.h"
#include "domain.h"
#include "revdesc.h"

RevDesc::RevDesc(Domain* dm, QTextBrowser* t) :
		QObject(dm), d(dm), tb(t) {

	st = &(d->st);

	connect(tb, SIGNAL(linkClicked(const QString&)),
		this, SLOT(linkClicked(const QString&)));
}

void RevDesc::clear() {

	tb->clear();
}

void RevDesc::setText(SCRef desc) {

	tb->setText(desc);
	tb->setCursorPosition(0, 0);
}

void RevDesc::linkClicked(const QString& link) {

	QRegExp reSHA("[0-9a-f]{40}", false);
	if (link.find(reSHA) != -1) {

		// without this Qt warns on missing MIME source
		tb->setText(tb->text());

		st->setSha(link);
		UPDATE_DOMAIN(d);
	}
}
