/*
	Author: Marco Costalba (C) 2005-2006

	Copyright: See COPYING file that comes with this distribution

*/
#ifndef MYPROCESS_H
#define MYPROCESS_H

#include <qprocess.h>
#include "git.h"

class Git;

//custom process used to run shell commands in parallel

class MyProcess : public QProcess {
Q_OBJECT
public:
	MyProcess(QObject *go, Git* g, const QString& wd, bool reportErrors);
	bool runSync(SCRef runCmd, QString* runOutput, SCRef buf);
	bool runAsync(SCRef rc, QObject* rcv, SCRef buf);

signals:
	void procDataReady(const QString&);
	void eof();

public slots:
	void cancel();
	void myReadFromStdout();
	void myProcExited();

private:
	void setupSignals();
	bool launchMe(SCRef runCmd, SCRef buf);
	void restoreSpaces(QString& newCmd, SCRef sepChar);
	const QStringList splitArgList(SCRef cmd);

	QObject* guiObject;
	Git* git;
	QString runCmd;
	QString* runOutput;
	QString workDir;
	QObject* receiver;
	bool errorReportingEnabled;
	bool canceling;
	bool busy;
	bool exitStatus;
};

#endif
