/*
	Author: Marco Costalba (C) 2005-2006

	Copyright: See COPYING file that comes with this distribution

*/
#ifndef MAINIMPL_H
#define MAINIMPL_H

#include <qguardedptr.h>
#include <qregexp.h>
#include <qprocess.h>
#include <qptrvector.h>
#include "exceptionmanager.h"
#include "common.h"
#include "mainbase.h"

class Git;
class Rev;
class Domain;
class CommitImpl;
class QProcess;
class QPopupMenu;
class QCustomEvent;
class QAccel;
class QTextEdit;
class ListViewItem;
class TreeView;
class PatchView;
class FileView;
class RevsView;

class MainImpl : public MainBase {
Q_OBJECT
public:
	MainImpl(const QString& curDir = "", QWidget* parent = 0, const char* name = 0);

signals:
	void highlightPatch(const QString&, bool);

public slots:
	void buttonGroupDiff_clicked(int); // workaround: direct connection does not work
	void tabWdg_currentChanged(QWidget*);
	void on_newRevsAdded();

protected:
	void customEvent(QCustomEvent* e);

private slots:
	void on_listViewLog_doubleClicked(QListViewItem*);
	void on_fileList_doubleClicked(QListBoxItem*);
	void on_treeView_doubleClicked(QListViewItem*);
	void on_histListView_doubleClicked(QListViewItem* item);
	void setRepositoryStartup();
	void slotCommitViewerClosed();
	void lineEditSHA_returnPressed();
	void lineEditFilter_returnPressed();
	void pushButtonCloseTab_clicked();
	void toolButtonFilter_toggled(bool);
	void accelActivated(int);
	void ActBack_activated();
	void ActForward_activated();
	void ActFind_activated();
	void ActFindNext_activated();
	void ActViewRev_activated();
	void ActViewFile_activated();
	void ActViewDiff_activated();
	void ActExternalDiff_activated();
	void ActSplitView_activated();
	void ActOpenRepo_activated();
	void ActOpenRepoNewWindow_activated();
	void ActRefresh_activated();
	void ActSaveFile_activated();
	void ActMailFormatPatch_activated();
	void ActMailApplyPatch_activated();
	void ActSettings_activated();
	void ActCommit_activated();
	void ActTag_activated();
	void ActTagDelete_activated();
	void ActPush_activated();
	void ActPop_activated();
	void ActClose_activated();
	void ActExit_activated();
	void ActCheckWorkDir_toggled(bool);
	void ActShowTree_toggled(bool);
	void ActFilterTree_toggled(bool);
	void ActAbout_activated();
	void ActHelp_activated();
	void goRef_Activated(int id);
	void openRecent_Activated(int id);
	void closeEvent(QCloseEvent* ce);

private:
	friend class FileView;
	friend class RevsView;
	friend class ListView;

	bool eventFilter(QObject* obj, QEvent* ev);
	void updateGlobalActions(bool b);
	void updateContextActions(SCRef newRevSha, SCRef newFileName, bool isDir, bool found);
	void refreshRepo(bool setCurRevAfterLoad = false);
	void setupPixmaps(int h);
	void setupAccelerator(QAccel* accel);
	int tabType(QWidget* tb);
	bool passFilter(ListViewItem* i, SCRef f, int cn, const QMap<QString,bool>& sm);
	void setRepository(SCRef wd, bool r, bool ks, QStringList* fl = NULL);
	void diffViewerUpdate(QListViewItem* item, bool newDiff);
	void getExternalDiffArgs(QStringList* args);
	void lineEditSHASetText(SCRef text);
	void updateCommitMenu(bool isStGITStack);
	void updateRecentRepoMenu(SCRef newEntry = "");
	void doUpdateRecentRepoMenu(SCRef newEntry);
	void ActCommit_setEnabled(bool b);
	void doContexPopup(SCRef sha);
	void doFileContexPopup(SCRef fileName, int type);
	void adjustFontSize(int delta);
	void scrollTextEdit(int delta);
	void scrollListView(int delta);
	QTextEdit* getCurrentTextEdit();

	EM_DECLARE(exSetRepositoryCalled);
	EM_DECLARE(exExiting);

	Git* git;
	RevsView* rv;
	QGuardedPtr<FileView> fv;
	QAccel* accel;
	QWidget* revTab;
	QWidget* patchTab;
	QGuardedPtr<QWidget> fileTab;

	// curDir is the repository working dir, could be different from qgit running
	// directory QDir::current(). Note that qgit could be run from subdirectory
	// so only after git->isArchive() that updates curDir to point to working dir
	// we are sure is correct.
	QString curDir;
	QRegExp shortLogRE;
	QRegExp longLogRE;
	QGuardedPtr<CommitImpl> commitViewer;
	QGuardedPtr<QPopupMenu> contextMenu;
	QGuardedPtr<QPopupMenu> contextSubMenu;
	QPtrVector<QPixmap> pixmaps;
	QString startUpDir;
	QString textToFind;
	bool changesCommitted;
	int ph; // pixmaps height
	int pw; // pixmaps width
	unsigned long secs;
	bool setRepositoryBusy;
	int recentRepoMenuPos;
};

class ExternalDiffProc : public QProcess {
Q_OBJECT
public:
	ExternalDiffProc(const QStringList& args, QObject* p) : QProcess(args, p) {
		connect(this, SIGNAL(processExited()), this, SLOT(exit()));
	}
	~ExternalDiffProc() {
		tryTerminate();
		removeFiles();
	}
public slots:
	void exit() { deleteLater(); }

private:
	void removeFiles() {
		if (!arguments().empty()) {
			QDir d; // remove temporary files to diff on
			d.remove(arguments()[1]);
			d.remove(arguments()[2]);
		}
	}
};

#endif
