/*
	Author: Marco Costalba (C) 2005-2006

	Copyright: See COPYING file that comes with this distribution

*/
#ifndef FILEVIEW_H
#define FILEVIEW_H

#include <qguardedptr.h>
#include "exceptionmanager.h"
#include "common.h"
#include "domain.h"

class QListViewItem;
class ListView;
class FileContent;
class MainImpl;
class Git;

class FileView: public Domain {
Q_OBJECT
public:
	FileView(MainImpl* m, Git* git, QWidget* t);
	virtual ~FileView();
	void append(SCRef data);
	void clear(bool complete = true);
	void historyReady();
	void updateHistViewer(SCRef revSha, SCRef fileName, bool fromUpstream = true);
	void eof();

public slots:
	void on_toolButtonCopy_clicked();
	void on_toolButtonShowAnnotate_toggled(bool);
	void on_toolButtonFindAnnotate_toggled(bool);
	void toolButtonRangeFilter_toggled(bool);
	void on_toolButtonPin_toggled(bool);
	void on_spinBoxRevision_valueChanged(int);
	void on_histLoadCompleted();
	void on_annotationAvailable(bool);
	void on_fileAvailable(bool);
	void on_revIdSelected(int);

protected:
	virtual void customEvent(QCustomEvent* e);

private:
	friend class MainImpl;
	friend class FileHighlighter;

	virtual bool doUpdate();
	void addAnnotation();
	bool goToCurrentAnnotation();
	void updateProgressBar(int annotatedNum);
	void filterOnRange(bool b);
	void updateSpinBoxValue();

	EM_DECLARE(exDtorCalled);

	QWidget* tabPage;
	ListView* histListView;
	FileContent* textEditFile;
};

#endif
