/*
	Author: Marco Costalba (C) 2005-2006

	Copyright: See COPYING file that comes with this distribution

*/
#ifndef DOMAIN_H
#define DOMAIN_H

#include <qobject.h>
#include "common.h"

#define UPDATE_DOMAIN(x) QApplication::postEvent(x, new UpdateDomainEvent())

class Domain;
class MainImpl;
class Git;

class UpdateDomainEvent : public QCustomEvent {
public:
	UpdateDomainEvent() : QCustomEvent(QGit::UPD_DOMAIN_EV) {}
};

class StateInfo {
public:
	StateInfo() { clear(); }
	StateInfo& operator=(const StateInfo& newState);
	bool operator==(const StateInfo& newState);
	bool operator!=(const StateInfo& newState);
	void clear();
	void commit() { curS = newS; };
	void rollBack() { newS = curS; };
	const QString sha(bool n = true) const { return (n ? newS.sha : curS.sha); };
	const QString fileName(bool n = true) const { return (n ? newS.fn : curS.fn); };
	const QString diffToSha(bool n = true) const {return(n ? newS.dtSha : curS.dtSha); };
	bool selectItem(bool n = true) const { return( n ? newS.sel : curS.sel); };
	bool isMerge(bool n = true) const { return( n ? newS.isM : curS.isM); };
	bool allMergeFiles(bool n = true) const { return( n ? newS.allM : curS.allM); };
	void setSha(const QString& s) { newS.sha = s; };
	void setFileName(const QString& s) { newS.fn = s; };
	void setDiffToSha(const QString& s) { newS.dtSha = s; };
	void setSelectItem(bool b) { newS.sel = b; };
	void setIsMerge(bool b) { newS.isM = b; };
	void setAllMergeFiles(bool b) { newS.allM = b; };

private:
	class S {
	public:
		S() { clear(); }
		~S() { clear(); } // FIXME
		void clear();
		S& operator=(const S& newState);
		bool operator==(const S& newState);
		bool operator!=(const S& newState);

		QString sha;
		QString fn;
		QString dtSha;
		bool sel;
		bool isM;
		bool allM;
	};
	S newS;
	S curS;
};

class Domain: public QObject {
Q_OBJECT
public:
	Domain(MainImpl* m, Git* git);
	MainImpl* m() const;
	bool isReadyToDrag() const { return readyToDrag; }
	bool setReadyToDrag(bool b);
	bool isDragging() const { return dragging; }
	bool setDragging(bool b);
	bool isDropping() const { return dropping; }
	void setDropping(bool b) { dropping = b; }

	StateInfo st;

protected slots:
	void on_contextMenu(const QString&, int);

protected:
	virtual void customEvent(QCustomEvent* e);
	virtual bool doUpdate() = 0;

	Domain* d; // to use UPDATE_DOMAIN() macro
	Git* git;
	bool busy;

private:
	void populateState();
	bool requestPending();
	void update();
	bool flushQueue();
	void sendPopupEvent();

	StateInfo queuedSt;
	bool readyToDrag;
	bool dragging;
	bool dropping;
	int popupType;
	QString popupData;
	QString statusBarRequest;
};

#endif
