/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: editeutransaction.cpp 410 2007-09-04 07:07:26Z martin $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "editeutransaction.h"
#include "kbanking.h"
#include "refpointer.h"
#include "selectpayee.h"
#include "payee.h"
#include <qbanking/qbselectbank.h>

#include <qcombobox.h>
#include <qtextedit.h>
#include <qlineedit.h>
#include <qregexp.h>
#include <qvalidator.h>
#include <qmessagebox.h>
#include <qradiobutton.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtimer.h>
#include <qpushbutton.h>

#include <list>
#include <string>

#include <gwenhywfar/debug.h>
#include <gwenhywfar/text.h>

#include <aqbanking/jobeutransfer.h>


#ifdef WIN32
# define strcasecmp stricmp
#endif


EditEuTransaction::EditEuTransaction(KBanking *app,
                                     RefPointer<Transfer> t,
                                     QWidget* parent,
                                     const char* name,
                                     bool modal,
                                     WFlags fl)
:EditEuTransactionUi(parent, name, modal, fl)
,_app(app)
,_transfer(t)
,_maxPurpose(1)
,_maxLenPurpose(27)
,_maxOtherNameLines(1)
,_maxLenOtherName(27)
,_ibanAllowed(false){
  int found;
  std::list<Account*>::const_iterator ait;
  int i;
  QString recipientName;
  QString s, cs;
  std::list<std::string>::const_iterator sit;
  std::list<RefPointer<Transfer> >::iterator xit;
  const AB_VALUE *v;
  //QRegExp valueRx("^[0-9]{1,12}.[0-9]{1,2}$");
  QRegExp bankCodeRx(QString("^[0-9]{1,8}$"));
  //QValidator *valueValidator=new QRegExpValidator(valueRx, this);
  QValidator *bankCodeValidator=new QRegExpValidator(bankCodeRx, this);
  uint64_t an;

  QLayout *lo=layout();
  if (lo) {
    QSize csi;
    QSize nsi;

    csi=size();
    nsi=lo->sizeHint();
    if (csi.width()>nsi.width())
      nsi.setWidth(csi.width());
    if (csi.height()>nsi.height())
      nsi.setWidth(csi.height());
    DBG_ERROR(0, "Resizing dialog.");
    resize(nsi);
  }

  _nullCountryName=tr("--- select country ---");

  /* set validators */
  //valueEdit->setValidator(valueValidator);
  remoteBankCodeEdit->setValidator(bankCodeValidator);
  //localAccountCombo->lineEdit()->
  // setValidator(new QRegExpValidator(QRegExp("^[0-9,A-Z,a-z]{1,12}$"),this));
  // -- unfortunately setting this on the localAccountCombo crashes
  // the dialog, therefore it is commented out for now

  _countryCode=t.ref().getRemoteCountry();

  // setup account combo
  found=0;
  i=0;
  an=App::char2uint64(t.ref().getLocalAccountNumber().c_str());
  localAccountCombo->insertItem(tr("Select Account"), -1);
  for (ait=app->getAppAccounts().begin();
       ait!=app->getAppAccounts().end();
       ait++) {
    uint64_t lan;

    i++;
    cs="";

    lan=App::char2uint64((*ait)->getAccountNumber().c_str());
    s=QString::fromUtf8((*ait)->getBankName().c_str());
    if (s.isEmpty())
      s=QString::fromUtf8((*ait)->getBankCode().c_str());
    cs+=s;
    cs+=" / ";
    s=QString::fromUtf8((*ait)->getAccountNumber().c_str());
    cs+=s;
    cs+=" - ";
    s=QString::fromUtf8((*ait)->getAccountName().c_str());
    cs+=s;
    cs+=" (";
    cs+=QString::number((*ait)->getBankingId());
    cs+=")";

    _setComboTextNoDup(localAccountCombo, cs);
    if ((strcasecmp((*ait)->getBankCode().c_str(),
                    t.ref().getLocalBankCode().c_str())==0) &&
        (strcasecmp((*ait)->getAccountNumber().c_str(),
                    t.ref().getLocalAccountNumber().c_str())==0))
      found=i;
    else if (an && lan && an==lan &&
             (strcasecmp((*ait)->getBankCode().c_str(),
                         t.ref().getLocalBankCode().c_str())==0))
      found=i;
  } // for
  localAccountCombo->setCurrentItem(found);
  if (found)
    slotAccountChanged(found);

  remoteNameEdit->setMaxLength(27);

  remoteAccountIdEdit
    ->setText(QString::fromUtf8(t.ref().getRemoteAccountNumber().c_str()));
  remoteBankCodeEdit
    ->setText(QString::fromUtf8(t.ref().getRemoteBankCode().c_str()));

  remoteBankNameEdit
    ->setText(QString::fromUtf8(t.ref().getRemoteBankName().c_str()));
  remoteBankLocationEdit
    ->setText(QString::fromUtf8(t.ref().getRemoteBankLocation().c_str()));
  remoteIbanEdit
    ->setText(QString::fromUtf8(t.ref().getRemoteIban().c_str()));


  // set recipient name(s)
  for (sit=t.ref().getRemoteName().begin();
       sit!=t.ref().getRemoteName().end();
       sit++) {
    s=QString::fromUtf8(sit->c_str());
    if (!s.isEmpty()) {
      if (!recipientName.isEmpty())
        recipientName+=" ";
      recipientName+=s;
    }
  } // for
  remoteNameEdit->setText(recipientName);

  // setup purpose
  cs="";
  for (sit=t.ref().getPurpose().begin();
       sit!=t.ref().getPurpose().end();
       sit++) {
    i++;
    s = QString::fromUtf8(sit->c_str());
    if (!s.isEmpty()) {
      if (!cs.isEmpty())
        cs+="\n";
      cs+=s;
    }
  } // for
  purposeEdit->setText(cs);

  // set value
  v=t.ref().getValue();
  if (v) {
    const char *st;

    valueEdit->setText(QString::number(AB_Value_GetValueAsDouble(v), 'f', 2));
    st=AB_Value_GetCurrency(v);
    if (!st)
      st="EUR";
    _setComboTextNoDup(currencyCombo, QString::fromUtf8(st));
  }

  cs=QString::fromUtf8(t.ref().getRemoteCountry().c_str());
  if (!cs.isEmpty()) {
    if (!_selectCountry(cs, false)) {
      QMessageBox::critical(this,
                            tr("Job not Supported"),
                            QString(tr("<qt>"
                                       "<p>"
                                       "This account does not support "
                                       "EU-Transactions to %1."
                                       "</p>"
                                       "</qt>"
                                      ))
                            .arg(cs),
                            tr("Dismiss"), QString::null);
    }
  }

  // connect buttons
  QObject::connect(bankCodeButton, SIGNAL(clicked()),
                   this, SLOT(slotBankCode()));
  QObject::connect(payeeButton, SIGNAL(clicked()),
                   this, SLOT(slotGetPayee()));
  QObject::connect(bankCodeButton, SIGNAL(clicked()),
                   this, SLOT(slotGetBankCode()));

  QObject::connect(localAccountCombo, SIGNAL(activated(int)),
                   this, SLOT(slotAccountChanged(int)));
  QObject::connect(countryCombo, SIGNAL(activated(const QString &)),
                   this, SLOT(slotCountryChanged(const QString &)));

  QObject::connect(accountRadio, SIGNAL(toggled(bool)),
                   this, SLOT(slotAccountIdToggled(bool)));
  QObject::connect(ibanRadio, SIGNAL(toggled(bool)),
                   this, SLOT(slotIbanToggled(bool)));

  QObject::connect(remoteBankCodeEdit, SIGNAL(lostFocus()),
                   this, SLOT(slotBankCodeLostFocus()));
  QObject::connect(remoteIbanEdit,
                   SIGNAL(textChanged(const QString &)),
                   this, SLOT(slotIbanChanged(const QString &)));

  QTimer::singleShot(0, this, SLOT(adjustSize()));
}



EditEuTransaction::~EditEuTransaction(){
}



void EditEuTransaction::_setComboTextNoDup(QComboBox *qb, const QString &s){
  int i;

  for (i=0; i<qb->count(); i++) {
    if (qb->text(i)==s)
      return;
  }
  qb->insertItem(s, -1);
}



void EditEuTransaction::accept(){
  int pos;
  QString qs;
  std::list<Account*>::const_iterator ait;
  int i;
  Account *a;
  AB_VALUE *value;
  QCString utfData;
  QRegExp valueRx(QString("^[0-9]{1,12}.[0-9]{1,2}$"));
  QRegExpValidator qv(valueRx, this);

  pos=0;

  qs=valueEdit->text();
  if (qv.validate(qs, pos)!=
      QValidator::Acceptable) {
    QMessageBox::critical(this,
                          tr("Bad Value"),
                          tr("<qt>"
                             "<p>"
                             "The value needs to be in the following "
                             "format: "
                             "\"<b>XX,YY</b>\".<br>"
                             "<b>XX</b> are between 1 and 12 digits before "
                             "the comma, <b>YY</b> are 1 or 2 digits "
                             "after it"
                             "</p>"
                             "<p>"
                             "Examples:"
                             "<ul>"
                             "<li>123,45</li>"
                             "<li>0,12</li>"
                             "<li>123,00</li>"
                             "</ul>"
                             "</p>"
                             "<p>"
                             "Please correct the value."
                             "</p>"
                             "</qt>"
                            ),
                          tr("Dismiss"), QString::null);
    return;
  }

  if (localAccountCombo->currentItem()==0) {
    QMessageBox::critical(this,
                          tr("No Source Account"),
                          tr("<qt>"
                             "<p>"
                             "Please select the source account."
                             "</p>"
                             "</qt>"
                            ),
                          tr("Dismiss"), QString::null);
    return;
  }

  if (_countryCode.empty() || countryCombo->currentItem()==0) {
    QMessageBox::critical(this,
                          tr("No Valid Country"),
                          tr("<qt>"
                             "<p>"
                             "Please select a <b>valid</b> country,"
                             "</p>"
                             "</qt>"
                            ),
                          tr("Dismiss"), QString::null);
    return;
  }

  if (remoteNameEdit->text().isEmpty() ||

      (
       accountRadio->isChecked() &&
       (remoteAccountIdEdit->text().isEmpty() ||
        remoteBankCodeEdit->text().isEmpty())
      ) ||
      (
       ibanRadio->isChecked() &&
       (remoteIbanEdit->text().isEmpty() ||
	remoteBankNameEdit->text().isEmpty())
      ) ||
      purposeEdit->text().isEmpty()) {
    QMessageBox::critical(this,
                          tr("Empty Fields"),
                          tr("<qt>"
                             "<p>"
                             "Please fill out all fields."
                             "</p>"
                             "</qt>"
                            ),
                          tr("Dismiss"), QString::null);
    return;
  }

  qs=purposeEdit->text();
  DBG_NOTICE(0, "Got this string (%d lines):",
             purposeEdit->lines());
#ifndef WIN32
  // In MSVC this function crashes
  GWEN_Text_DumpString(qs.latin1(), qs.length(), stderr, 2);
#endif
  if (_maxPurpose!=-1) {
    int lines;

    lines=purposeEdit->lines();
    if (qs.endsWith("\n"))
      lines--;
    if (lines>_maxPurpose) {
      QString qs=QString(tr("<qt>"
                            "<p>"
                            "Your purpose input exceeds the limit of "
                            "%1 lines."
                            "</p>"
                            "<p>"
                            "Please remove %2 lines."
                            "</p>"
                            "</qt>"
                           )
                         )
        .arg(_maxPurpose)
        .arg(lines-_maxPurpose);
      QMessageBox::critical(this,
                            tr("Field Error"),
                            qs,
                            tr("Dismiss"), QString::null);
      return;
    }
    if (lines<1) {
      QMessageBox::critical(this,
                            tr("Field Error"),
                            tr("Please enter the purpose."),
                            tr("Dismiss"), QString::null);
      return;
    }
  }

  // all checks performed, now copy data back to transaction

  // find account
  i=localAccountCombo->currentItem();
  a=0;
  for (ait=_app->getAppAccounts().begin();
       ait!=_app->getAppAccounts().end();
       ait++) {
    if (!--i) {
      a=*ait;
      break;
    }
  } // for
  assert(a);

  _transfer.ref().setLocalBankCode(a->getBankCode());
  _transfer.ref().setLocalAccountNumber(a->getAccountNumber());
  _transfer.ref().setLocalName(a->getOwnerName());

  _transfer.ref().setRemoteCountry(_countryCode);
  _transfer.ref().setRemoteBankCode
    (KBanking::QStringToUtf8String(remoteBankCodeEdit->text()));

  _transfer.ref().setRemoteAccountNumber
    (KBanking::QStringToUtf8String(remoteAccountIdEdit->text()));

  _transfer.ref().setRemoteIban
    (KBanking::QStringToUtf8String(remoteIbanEdit->text()));

  _transfer.ref().setRemoteBankName
    (KBanking::QStringToUtf8String(remoteBankNameEdit->text()));
  _transfer.ref().setRemoteBankLocation
    (KBanking::QStringToUtf8String(remoteBankLocationEdit->text()));

  _transfer.ref().clearRemoteName();
  _transfer.ref().addRemoteName
    (KBanking::QStringToUtf8String(remoteNameEdit->text()));

  qs=valueEdit->text();
  qs+=":";
  qs+=currencyCombo->currentText();
  value=AB_Value_fromString(qs.latin1());
  _transfer.ref().setValue(value);
  AB_Value_free(value);

  // get purpose
  _transfer.ref().clearPurpose();
  qs=purposeEdit->text();
  if (!qs.isEmpty()) {
    QString currLine;
    unsigned int i;
    int lastBlank;

    lastBlank=-1;
    // In qt4 QString::length() will return a signed int
    for (i=0; i < unsigned(qs.length()); i++) {
      if (qs.at(i)=='\n') {
        // next line
        if (!currLine.isEmpty()) {
          _transfer.ref().addPurpose
            (KBanking::QStringToUtf8String(currLine.upper()));
        }
        currLine="";
        lastBlank=-1;
      }
      else {
        if (qs.at(i).isSpace())
          lastBlank=i;
        if (currLine.length()>=27) {
          // wrap word at word boundary
          if (lastBlank==-1)
            // force word wrap here if no preceeding blank
            lastBlank=i;
          _transfer.ref().addPurpose
            (KBanking::QStringToUtf8String(currLine.left(lastBlank).upper()));
          currLine=currLine.mid(lastBlank+1);
          if (!qs.at(i).isSpace())
	    currLine+=qs.at(i);
          lastBlank=-1;
        }
        else
          currLine+=qs.at(i);
      }
    } // for
    if (!currLine.isEmpty()) {
      _transfer.ref().addPurpose
        (KBanking::QStringToUtf8String(currLine.upper()));
    }
  }

  return QDialog::accept();
}



void EditEuTransaction::reject(){
  return QDialog::reject();
}



void EditEuTransaction::slotBankCode(){
  AB_BANKINFO *bi;

  bi=QBSelectBank::selectBank(_app,
                              0,
                              tr("Select a Bank"),
                              QString::fromUtf8(_countryCode.c_str()),
                              remoteBankCodeEdit->text());
  if (bi) {
    const char *s;

    s=AB_BankInfo_GetBankId(bi);
    if (s)
      remoteBankCodeEdit->setText(QString::fromUtf8(s));
    s=AB_BankInfo_GetBankName(bi);
    if (s)
      remoteBankNameEdit->setText(QString::fromUtf8(s));
    s=AB_BankInfo_GetLocation(bi);
    if (s)
      remoteBankLocationEdit->setText(QString::fromUtf8(s));
    AB_BankInfo_free(bi);
  }
}



void EditEuTransaction::slotAccountIdToggled(bool on){
  DBG_NOTICE(0, "Account id toggled (%s)", on?"ON":"OFF");
  if (!on && !_ibanAllowed) {
    on=true;
    accountRadio->setChecked(on);
  }
  ibanRadio->setChecked(!on);
  remoteAccountIdLabel->setEnabled(on);
  remoteAccountIdEdit->setEnabled(on);
  remoteBankCodeLabel->setEnabled(on);
  remoteBankCodeEdit->setEnabled(on);

  remoteIbanLabel->setEnabled(!on);
  remoteIbanEdit->setEnabled(!on);
}



void EditEuTransaction::slotIbanToggled(bool on){
  DBG_NOTICE(0, "Iban toggled (%s)", on?"ON":"OFF");
  accountRadio->setChecked(!on);
  if (on && !_ibanAllowed) {
    on=false;
    ibanRadio->setChecked(on);
  }
  remoteAccountIdLabel->setEnabled(!on);
  remoteAccountIdEdit->setEnabled(!on);
  remoteBankCodeLabel->setEnabled(!on);
  remoteBankCodeEdit->setEnabled(!on);

  remoteIbanLabel->setEnabled(on);
  remoteIbanEdit->setEnabled(on);
}



void EditEuTransaction::slotAccountChanged(int i){
  std::list<Account*>::const_iterator ait;
  Account *a;
  QString qs;

  if (countryCombo->currentItem()!=0)
    qs=countryCombo->currentText();
  fprintf(stderr, "Current country: %s\n", qs.latin1());
  countryCombo->clear();
  countryCombo->insertItem(_nullCountryName);

  a=0;
  for (ait=_app->getAppAccounts().begin();
       ait!=_app->getAppAccounts().end();
       ait++) {
    if (!--i) {
      a=*ait;
      break;
    }
  } // for
  if (a) {
    AB_ACCOUNT *ba;

    ba=AB_Banking_GetAccount(_app->getCInterface(),
                             a->getBankingId());
    if (ba) {
      AB_JOB *j=0;
      const AB_EUTRANSFER_INFO_LIST *eil=0;

      j=AB_JobEuTransfer_new(ba);
      if (AB_Job_CheckAvailability(j, 0)==0) {
        /* get job parameters */
        eil=AB_JobEuTransfer_GetCountryInfoList(j);
        _ibanAllowed=AB_JobEuTransfer_GetIbanAllowed(j);
        DBG_ERROR(0, "IBAN-Allowed: %s", _ibanAllowed?"Yes":"No");
       if (!_ibanAllowed) {
         if (ibanRadio->isChecked()) {
           ibanRadio->setChecked(false);
           slotIbanToggled(false);
         }
         ibanRadio->setEnabled(false);
       }
       else {
         ibanRadio->setEnabled(true);
       }
      }
      else {
        DBG_ERROR(0, "Job not supported with this account");
        QMessageBox::critical(this,
                              tr("Job not Supported"),
                              tr("<qt>"
                                 "<p>"
                                 "This account does not support this job."
                                 "</p>"
                                 "</qt>"
                                ),
                              tr("Dismiss"), QString::null);
        countryCombo->setCurrentItem(0);
        qs="";
      }

      if (eil) {
        const AB_EUTRANSFER_INFO *ei;
        std::list<std::string> sl;
        std::list<std::string>::iterator sit;

        ei=AB_EuTransferInfo_List_First(eil);
        while(ei) {
          const char *cc;

          cc=AB_EuTransferInfo_GetCountryCode(ei);
          if (cc) {
            const AB_COUNTRY *cnt;

            DBG_ERROR(0, "Checking country \"%s\"", cc);
            cnt=AB_Banking_FindCountryByCode(_app->getCInterface(), cc);
            if (cnt) {
              sl.push_back(AB_Country_GetLocalName(cnt));
            }
            else {
              DBG_ERROR(0, "No country code");
            }
          }
          else {
            DBG_ERROR(0, "Bad country settings");
          }
          ei=AB_EuTransferInfo_List_Next(ei);
        } // while
        sl.sort();
        for (sit=sl.begin(); sit!=sl.end(); sit++) {
          fprintf(stderr, "Adding country \"%s\"\n",
                  (*sit).c_str());
          _setComboTextNoDup(countryCombo, QString::fromUtf8((*sit).c_str()));
        }
      } // if eil
      else {
        DBG_ERROR(0, "No country info found");
      }

      if (!qs.isEmpty()) {
        fprintf(stderr, "Setting back to country %s\n",
                qs.latin1());
        _setComboTextNoDup(countryCombo, qs);
        countryCombo->setCurrentText(qs);
        slotCountryChanged(qs);
      }
      else {
        countryCombo->setCurrentItem(0);
      }
    } // if account
  } // if account
}



bool EditEuTransaction::_selectCountry(const QString &qs, bool byLong,
                                       bool withCombo){
  int i;
  Account *a;
  std::list<Account*>::const_iterator ait;

  DBG_NOTICE(0, "Selecting country %s", qs.latin1());
  /*if (byLong && qs==_nullCountryName)
    return true; */

  _countryCode="";
  _maxPurpose=1;
  _maxLenPurpose=27;
  _maxOtherNameLines=1;
  _maxLenOtherName=27;

  currencyCombo->clear();
  currencyCombo->insertItem(QString("EUR"));

  i=localAccountCombo->currentItem();
  a=0;
  for (ait=_app->getAppAccounts().begin();
       ait!=_app->getAppAccounts().end();
       ait++) {
    if (!--i) {
      a=*ait;
      break;
    }
  } // for
  if (a) {
    AB_ACCOUNT *ba;
    const AB_TRANSACTION_LIMITS *lim;

    ba=AB_Banking_GetAccount(_app->getCInterface(),
                             a->getBankingId());
    if (ba) {
      AB_JOB *j=0;
      const AB_COUNTRY *cnt=0;
      const AB_EUTRANSFER_INFO *ei=0;

      j=AB_JobEuTransfer_new(ba);
      if (AB_Job_CheckAvailability(j, 0)==0) {
        std::string name;

        name=KBanking::QStringToUtf8String(qs);
        if (byLong)
          cnt=AB_Banking_FindCountryByLocalName(_app->getCInterface(),
                                                name.c_str());
        else
          cnt=AB_Banking_FindCountryByCode(_app->getCInterface(),
                                           name.c_str());
        if (cnt) {
          const char *p;

          if (withCombo) {
            DBG_ERROR(0, "Updating country combo");
            p=AB_Country_GetLocalName(cnt);
            if (p)
              countryCombo->setCurrentText(QString::fromUtf8(p));
            else {
              DBG_ERROR(0, "No local country name...");
            }
          }
          p=AB_Country_GetCurrencyCode(cnt);
          if (p)
            _setComboTextNoDup(currencyCombo, QString::fromUtf8(p));

          ei=AB_JobEuTransfer_FindCountryInfo(j, AB_Country_GetCode(cnt));
        }
      }
      else {
        DBG_ERROR(0, "Job not supported with this account");
        AB_Job_free(j);
        return false;
      }

      // set country-specific limits
      if (!ei) {
        DBG_ERROR(0, "Job not supported with this account and country");
        AB_Job_free(j);
        return false;
      }

      DBG_NOTICE(0, "Country successfully selected");
      /* get limits */
      lim=AB_EuTransferInfo_GetFieldLimits(ei);
      _maxPurpose=1;
      _maxLenPurpose=27;
      _maxOtherNameLines=1;

      if (lim) {
	_maxPurpose=AB_TransactionLimits_GetMaxLinesPurpose(lim);
	_maxLenPurpose=AB_TransactionLimits_GetMaxLenPurpose(lim);
	_maxOtherNameLines=AB_TransactionLimits_GetMaxLinesRemoteName(lim);
	_maxLenOtherName=AB_TransactionLimits_GetMaxLenRemoteName(lim);
      }
      if (_maxPurpose==-1)
	_maxPurpose=1;
      if (_maxLenPurpose==-1)
        _maxLenPurpose=27;
      if (_maxOtherNameLines==-1)
        _maxOtherNameLines=1;
      if (_maxLenOtherName==-1)
	_maxLenOtherName=27;

      if (AB_Country_GetCode(cnt))
        _countryCode=AB_Country_GetCode(cnt);

    } // if banking account
  } // if account
  return true;
}


void EditEuTransaction::slotCountryChanged(const QString &qs){
  if (!_selectCountry(qs, true, false)) {
    QMessageBox::critical(this,
                          tr("Job not Supported"),
                          QString(tr("<qt>"
                                     "<p>"
                                     "This account does not support "
                                     "EU-Transactions to %1."
                                     "</p>"
                                     "</qt>"
                                    ))
                          .arg(qs),
                          tr("Dismiss"), QString::null);
    countryCombo->setCurrentItem(0);
  }
}



void EditEuTransaction::slotGetBankCode(){
}



void EditEuTransaction::slotGetPayee(){
  Payee *p;

  p=SelectPayee::selectPayee(_app,
                             tr("Select Payee"),
                             tr("Select the payee from the list below"),
                             this);
  if (p) {
    std::string s;

    s=p->accountNumber();
    if (!s.empty())
      remoteAccountIdEdit
        ->setText(QString::fromUtf8(s.c_str()));
    s=p->bankCode();
    if (!s.empty())
      remoteBankCodeEdit
        ->setText(QString::fromUtf8(s.c_str()));
    s=p->name();
    if (!s.empty())
      remoteNameEdit
        ->setText(QString::fromUtf8(s.c_str()));
    s=p->country();
    if (!s.empty()) {
      QString qs;

      qs=QString::fromUtf8(s.c_str());
      if (!_selectCountry(qs, false)) {
        QMessageBox::critical(this,
                              tr("Job not Supported"),
                              QString(tr("<qt>"
                                         "<p>"
                                         "This account does not support "
                                         "EU-Transactions to the country of "
                                         "the selected payee (%1)."
                                         "</p>"
                                         "</qt>"
                                        ))
                              .arg(qs),
                              tr("Dismiss"), QString::null);
      }
      countryCombo->setCurrentItem(0);
      return;
    }
    slotBankCodeLostFocus();
  }
}



void EditEuTransaction::slotIbanChanged(const QString &qs){
}



void EditEuTransaction::slotBankCodeLostFocus(){
  std::string s;

  s=KBanking::QStringToUtf8String(remoteBankCodeEdit->text());
  if (!s.empty() && !_countryCode.empty()) {
    AB_BANKINFO *bi;

    bi=AB_Banking_GetBankInfo(_app->getCInterface(),
                              _countryCode.c_str(),
                              0,
                              s.c_str());
    if (bi) {
      const char *p;

      if (remoteBankNameEdit->text().isEmpty()) {
        p=AB_BankInfo_GetBankName(bi);
        if (p)
          remoteBankNameEdit->setText(QString::fromUtf8(p));
      }
      if (remoteBankLocationEdit->text().isEmpty()) {
        p=AB_BankInfo_GetCity(bi);
        if (p)
          remoteBankLocationEdit->setText(QString::fromUtf8(p));
      }
      AB_BankInfo_free(bi);
    }
    else {
      DBG_NOTICE(0, "No info about the given bank");
    }
  }
}





bool EditEuTransaction::editEuTransfer(KBanking *app,
                                       RefPointer<Transfer> t,
                                       const QString &title,
                                       QWidget* parent,
                                       bool modal,
                                       WFlags fl) {
  EditEuTransaction w(app, t, parent, 0, modal, fl);

  t.ref().setTransferType(Transfer::TransferType_EuTransfer);
  if (t.ref().getTextKey()==0)
    t.ref().setTextKey(51);

  if (!title.isEmpty())
    w.setCaption(title);
  w.titleLabel->setText(tr("<qt>"
                           "<h3>Euro Transfer</h3>"
                           "Transfer money from your account "
                           "to someone elses' (within the European Union)."
                           "</qt>"));
  return (w.exec()==QDialog::Accepted);
}










