/***************************************************************************
 $RCSfile: stoview.h,v $
                             -------------------
    cvs         : $Id: stoview.h,v 1.4 2005/08/24 16:52:02 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/



#ifndef KBANKING_STANDINGORDERVIEW_H
#define KBANKING_STANDINGORDERVIEW_H

#include "stoview.ui.h"

#include <qwidget.h>

#include <aqbanking/job.h>

class StandingOrderView;
class KBanking;


#include "stolist.h"


class StandingOrderView: public StandingOrderViewUi {
  Q_OBJECT
public:
  StandingOrderView(KBanking *app,
                    QWidget* parent=0, const char* name=0, WFlags fl=0);
  virtual ~StandingOrderView();

  bool init();
  bool fini();

protected:
  void closeEvent(QCloseEvent *e);

private:
  KBanking *_app;
  StandingOrderListView *_xaList;

  AB_JOB *_newStoJob(AB_JOB_TYPE jt,
                     RefPointer<StandingOrder> tmpl=0);
  void _createStandingOrder(RefPointer<StandingOrder> tmpl=0);
  void _modifyStandingOrder(RefPointer<StandingOrder> tmpl=0);

public slots:
  void slotUpdated();
  void slotDetails();
  void slotNewStandingOrder();
  void slotModifyStandingOrder();
  void slotDeleteStandingOrder();
};










#endif /* KBANKING_STANDINGORDERVIEW_H */



