/***************************************************************************
 $RCSfile: reportview.cpp,v $
                             -------------------
    cvs         : $Id: reportview.cpp,v 1.7 2005/11/25 16:49:41 cstim Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "reportview.h"
#include "report.h"
#include "kbanking.h"

#include <qcombobox.h>
#include <qlistview.h>
#include <qmessagebox.h>
#include <qsplitter.h>
#include <qtextbrowser.h>
#include <qpushbutton.h>



ReportView::ReportView(KBanking *app,
                       QWidget* parent,
                       const char* name,
                       WFlags fl)
:ReportViewUi(parent, name, fl), _app(app), _currentReport(0) {

  QObject::connect((typeCombo),
                   SIGNAL(activated(int)),
                   this,
                   SLOT(slotReportTypeChanged(int)));
  QObject::connect((profileList),
                   SIGNAL(selectionChanged()),
                   this,
                   SLOT(slotProfileSectionChanged()));

  QObject::connect((useButton),
                   SIGNAL(clicked()),
                   this,
                   SLOT(slotUseProfile()));
  QObject::connect((newButton),
                   SIGNAL(clicked()),
                   this,
                   SLOT(slotNewProfile()));
  QObject::connect((copyButton),
                   SIGNAL(clicked()),
                   this,
                   SLOT(slotCopyProfile()));
  QObject::connect((editButton),
                   SIGNAL(clicked()),
                   this,
                   SLOT(slotEditProfile()));
  QObject::connect((deleteButton),
                   SIGNAL(clicked()),
                   this,
                   SLOT(slotDeleteProfile()));




}



ReportView::~ReportView(){
}



bool ReportView::init(){
  GWEN_DB_NODE *dbReportView;

  dbReportView=_app->getAppData();
  assert(dbReportView);
  dbReportView=GWEN_DB_GetGroup(dbReportView, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
                                "gui/views/reportview/dynamic");
  if (dbReportView) {
    GWEN_DB_NODE *dbT;

    dbT=GWEN_DB_GetGroup(dbReportView, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
                         "profileList");
    if (dbT) {
      int i, j;
      const char *p;

      p=GWEN_DB_GetCharValue(dbT, "sortOrder", 0, "ascending");
      if (p) {
        if (strcasecmp(p, "ascending")==0)
          profileList->setSortOrder(Qt::Ascending);
        else
          if (strcasecmp(p, "descending")==0)
            profileList->setSortOrder(Qt::Descending);
      }
      i=GWEN_DB_GetIntValue(dbT, "sortColumn", 0, -1);
      if (i!=-1)
        profileList->setSortColumn(i);

      /* found settings */
      for (i=0; i<profileList->columns(); i++) {
        profileList->setColumnWidthMode(i, QListView::Manual);
        j=GWEN_DB_GetIntValue(dbT, "columns", i, -1);
        if (j!=-1)
          profileList->setColumnWidth(i, j);
        else
          break;
      } /* for */
    } // if profileList settings

    dbT=GWEN_DB_GetGroup(dbReportView, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
                         "splitter");
    if (dbT) {
      int i, j;
      QValueList<int> sizes;

      /* found settings */
      for (i=0; ; i++) {
        j=GWEN_DB_GetIntValue(dbT, "sizes", i, -1);
        if (j!=-1)
          sizes.push_back(j);
        else
          break;
      } /* for */

      if (!sizes.empty())
        splitter->setSizes(sizes);
    } // if splitter settings
  } /* if settings */

  update();
  return true;
}



bool ReportView::fini(){
  GWEN_DB_NODE *dbReportView;
  GWEN_DB_NODE *dbT;
  int i, j;
  QValueList<int> sizes;

  dbReportView=_app->getAppData();
  assert(dbReportView);
  dbReportView=GWEN_DB_GetGroup(dbReportView,
                                GWEN_DB_FLAGS_OVERWRITE_GROUPS,
                                "gui/views/reportview/dynamic");

  dbT=GWEN_DB_GetGroup(dbReportView,
                       GWEN_DB_FLAGS_OVERWRITE_GROUPS,
                       "profileList");

  switch(profileList->sortOrder()) {
  case Qt::Ascending:
    GWEN_DB_SetCharValue(dbT, GWEN_DB_FLAGS_DEFAULT,
                         "sortOrder", "ascending");
    break;
  case Qt::Descending:
    GWEN_DB_SetCharValue(dbT, GWEN_DB_FLAGS_DEFAULT,
                         "sortOrder", "descending");
    break;
  default:
    break;
  }

  GWEN_DB_SetIntValue(dbT, GWEN_DB_FLAGS_DEFAULT,
                      "sortColumn", profileList->sortColumn());

  for (i=0; i<profileList->columns(); i++) {
    j=profileList->columnWidth(i);
    GWEN_DB_SetIntValue(dbT, GWEN_DB_FLAGS_DEFAULT,
                        "columns", j);
  } /* for */

  /* save splitter settings */
  dbT=GWEN_DB_GetGroup(dbReportView,
                       GWEN_DB_FLAGS_OVERWRITE_GROUPS,
                       "splitter");
  sizes=splitter->sizes();
  QValueList<int>::Iterator it=sizes.begin();
  while(it!=sizes.end()) {
    GWEN_DB_SetIntValue(dbT, GWEN_DB_FLAGS_DEFAULT,
                        "sizes", *it);
    ++it;
  }

  return true;
}



void ReportView::update() {
  std::list<Report*> reports;
  std::list<Report*>::iterator it;

  typeCombo->clear();
  typeCombo->insertItem(tr("--- Select a report type ---"));
  reports=_app->getReports();
  for (it=reports.begin(); it!=reports.end(); it++) {
    QString s;

    s=(*it)->shortDescription();
    if (s.isEmpty())
      s=(*it)->name();
    if (s.isEmpty()) {
      s=tr("(unnamed report module)");
    }

    typeCombo->insertItem(s);
  }
  typeCombo->setCurrentItem(0);
  _currentReport=0;
  slotReportTypeChanged(0);
}



void ReportView::updateProfiles() {
  GWEN_DB_NODE *dbProfiles;
  GWEN_DB_NODE *dbT;

  profileList->clear();
  slotProfileSectionChanged();

  if (_currentReport) {
    dbProfiles=_app->getReportProfiles(_currentReport);
    assert(dbProfiles);
    dbT=GWEN_DB_FindFirstGroup(dbProfiles, "profile");
    while(dbT) {
      const char *id;
      const char *name;
      const char *descr;

      id=GWEN_DB_GetCharValue(dbT, "id", 0, 0);
      name=GWEN_DB_GetCharValue(dbT, "name", 0, 0);
      descr=GWEN_DB_GetCharValue(dbT, "shortDescr", 0, "");
      if (id && name) {
        QListViewItem *lvi;

        lvi=new QListViewItem(profileList,
                              QString::fromUtf8(id),
                              QString::fromUtf8(name),
                              QString::fromUtf8(descr));
      }
      dbT=GWEN_DB_FindNextGroup(dbT, "profile");
    }
  }
}



void ReportView::slotReportTypeChanged(int idx) {
  profileList->clear();
  _currentReport=0;
  useButton->setEnabled(false);
  newButton->setEnabled(false);
  copyButton->setEnabled(false);
  editButton->setEnabled(false);
  deleteButton->setEnabled(false);
  detailsButton->setEnabled(false);

  if (idx) {
    std::list<Report*> reports;
    std::list<Report*>::iterator it;
    int i;
    Report *r=0;

    reports=_app->getReports();
    i=idx;
    for (it=reports.begin(); it!=reports.end(); it++) {
      if (--i==0) {
        r=*it;
        break;
      }
    }
    if (r) {
      _currentReport=r;
      newButton->setEnabled(true);
      typeBrowser->setText(r->longDescription());
      updateProfiles();
    }
  } // if idx
}



void ReportView::slotProfileSectionChanged() {
  bool on;

  on=(_currentReport!=0 && getSelectedProfile()!=0);
  useButton->setEnabled(on);
  copyButton->setEnabled(on);
  editButton->setEnabled(on);
  deleteButton->setEnabled(on);
  detailsButton->setEnabled(on);

}



GWEN_DB_NODE *ReportView::getSelectedProfile() {
  if (_currentReport==0)
    return 0;

  // Create an iterator and give the listview as argument
  QListViewItemIterator it(profileList);
  // iterate through all items of the listview
  for (;it.current();++it) {
    if (it.current()->isSelected()) {
      std::string s;
      GWEN_DB_NODE *db;

      // get id
      s=KBanking::QStringToUtf8String(it.current()->text(0));
      if (s.empty())
        return 0;
      db=_app->findReportProfile(_currentReport, s.c_str());
      return db;
    }
  } // for

  return 0;
}


void ReportView::slotUseProfile() {
  GWEN_DB_NODE *dbProfile;

  if (_currentReport==0) {
    QMessageBox::warning(this,
                         tr("Error"),
                         tr("<qt>"
                            "No report module selected."
                            "</qt>"),
                         tr("Dismiss"), QString::null);
    return;
  }

  dbProfile=getSelectedProfile();
  if (!dbProfile) {
    QMessageBox::warning(this,
                         tr("Error"),
                         tr("<qt>"
                            "No profile selected."
                            "</qt>"),
                         tr("Dismiss"), QString::null);
    return;
  }

  _currentReport->useProfile(dbProfile, this);
}



void ReportView::slotNewProfile() {
  GWEN_DB_NODE *dbProfile;

  if (_currentReport==0) {
    QMessageBox::warning(this,
                         tr("Error"),
                         tr("<qt>"
                            "No report module selected."
                            "</qt>"),
                         tr("Dismiss"), QString::null);
    return;
  }

  dbProfile=GWEN_DB_Group_new("profile");
  if (_currentReport->initProfile(dbProfile, this)){
    if (!_app->addReportProfile(_currentReport, dbProfile))
      updateProfiles();
    else
      GWEN_DB_Group_free(dbProfile);
  }
}



void ReportView::slotCopyProfile() {
  GWEN_DB_NODE *dbProfile;
  GWEN_DB_NODE *db;
  const char *p;

  if (_currentReport==0) {
    QMessageBox::warning(this,
                         tr("Error"),
                         tr("<qt>"
                            "No report module selected."
                            "</qt>"),
                         tr("Dismiss"), QString::null);
    return;
  }

  db=getSelectedProfile();
  if (!db) {
    QMessageBox::warning(this,
                         tr("Error"),
                         tr("<qt>"
                            "No profile selected."
                            "</qt>"),
                         tr("Dismiss"), QString::null);
    return;
  }

  dbProfile=GWEN_DB_Group_dup(db);
  p=GWEN_DB_GetCharValue(db, "name", 0, 0);
  if (p) {
    QString qs;
    std::string s;

    qs=tr("Copy of %1").arg(QString::fromUtf8(p));
    s=KBanking::QStringToUtf8String(qs);
    if (!s.empty())
      GWEN_DB_SetCharValue(dbProfile, GWEN_DB_FLAGS_OVERWRITE_VARS,
                           "name", s.c_str());
  }

  if (_currentReport->editProfile(dbProfile, this)){
    if (!_app->addReportProfile(_currentReport, dbProfile))
      updateProfiles();
    else {
      DBG_ERROR(0, "Could not add profile");
      GWEN_DB_Group_free(dbProfile);
    }
  }
}



void ReportView::slotEditProfile() {
  GWEN_DB_NODE *dbProfile;

  if (_currentReport==0) {
    QMessageBox::warning(this,
                         tr("Error"),
                         tr("<qt>"
                            "No report module selected."
                            "</qt>"),
                         tr("Dismiss"), QString::null);
    return;
  }

  dbProfile=getSelectedProfile();
  if (!dbProfile) {
    QMessageBox::warning(this,
                         tr("Error"),
                         tr("<qt>"
                            "No profile selected."
                            "</qt>"),
                         tr("Dismiss"), QString::null);
    return;
  }

  if (_currentReport->editProfile(dbProfile, this))
    updateProfiles();
}



void ReportView::slotDeleteProfile() {
  GWEN_DB_NODE *dbProfile;

  if (_currentReport==0) {
    QMessageBox::warning(this,
                         tr("Error"),
                         tr("<qt>"
                            "No report module selected."
                            "</qt>"),
                         tr("Dismiss"), QString::null);
    return;
  }

  dbProfile=getSelectedProfile();
  if (!dbProfile) {
    QMessageBox::warning(this,
                         tr("Error"),
                         tr("<qt>"
                            "No profile selected."
                            "</qt>"),
                         tr("Dismiss"), QString::null);
    return;
  }

  int res = QMessageBox::warning(this,
                           tr("Deleting Profile"),
                           tr("<qt>"
                              "Do you really want to remove "
                              "the selected profile?"
                              "</qt>"),
                           QMessageBox::Yes,QMessageBox::No);
  if (res != 0 && res != QMessageBox::Yes)
    return;
  _app->removeReportProfile(_currentReport, dbProfile);
  updateProfiles();
}



void ReportView::slotDetailsProfile() {
}















