/***************************************************************************
 $RCSfile: introview.cpp,v $
                             -------------------
    cvs         : $Id: introview.cpp,v 1.14 2005/10/02 14:05:27 cstim Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "introview.h"

#include "kbanking.h"
#include "settings.h"
#include "mainwindow.h"

#include <qevent.h>
#include <qpushbutton.h>
#include <qtextbrowser.h>
#include <qtextcodec.h>
#include <qmime.h>
#include <qfile.h>
#include <qmessagebox.h>

#include <gwenhywfar/debug.h>


#define BUTTON_WIDTH 110



IntroViewTextBrowser::IntroViewTextBrowser(QWidget *parent, const char *name)
:QTextBrowser(parent, name)
{
}



IntroViewTextBrowser::~IntroViewTextBrowser(){
}



void IntroViewTextBrowser::setSource(const QString &name){
  if (name.find(QString("cmd://"), 0, false)==0) {
    DBG_DEBUG(0, "New source is a from a command link, ignoring.");
  }
  else {
    QTextBrowser::setSource(name);
  }
}






IntroView::IntroView(KBanking *kb,
                     QWidget* parent,
                     const char* name,
                     WFlags fl)
:IntroViewUi(parent, name, fl), _app(kb) {
  QObject::connect(setupButton, SIGNAL(clicked()),
                   this, SLOT(slotSetup()));
  QObject::connect(textBrowser, SIGNAL(linkClicked(const QString&)),
                   this, SLOT(slotLinkClicked(const QString&)));

}



IntroView::~IntroView(){
}



bool IntroView::init(){
  QMimeSourceFactory *mf;
  QString qs;
  GWEN_DB_NODE *db;

  mf=textBrowser->mimeSourceFactory();

  qs=QTextCodec::locale();
  if (!QFile(QString(HOMEDATA_PATH)+"/"+qs+"/index.html").exists()){
    int i;

    i=qs.find('_');
    if (!i) {
      qs="c";
    }
    else {
      qs=qs.left(i);
      if (!QFile(QString(HOMEDATA_PATH)+"/"+qs+"/index.html").exists())
	qs="c";
    }
  }
  qs=QString(HOMEDATA_PATH)+"/"+qs;
  DBG_INFO(0, "Adding home data path \"%s\"", qs.latin1());
  mf->addFilePath(qs);
  if (qs.lower()!=QString("c"))
    mf->addFilePath(QString(HOMEDATA_PATH)+"/c");

  db=_app->getAppData();
  assert(db);
  db=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
		      "gui/views/introview/dynamic");
  if (db) {
    const char *s;
    int first;

    first=GWEN_DB_GetIntValue(db, "firstStart", 0, 1);
    if (first) {
      s="first.html";
      GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
			  "firstStart", 0);
    }
    else {
      if (_app->getLastVersion()<
	  ((AQBANKING_KDE_VERSION_MAJOR<<24)+
	   (AQBANKING_KDE_VERSION_MINOR<<16)+
	   (AQBANKING_KDE_VERSION_PATCHLEVEL<<8))) {
	if (QFile(QString(HOMEDATA_PATH)+"/"+qs+"/update.html").exists())
	  s="update.html";
	else
	  s=GWEN_DB_GetCharValue(db, "startPage", 0, "index.html");
      }
      else
	s=GWEN_DB_GetCharValue(db, "startPage", 0, "index.html");
    }
    textBrowser->setSource(QString::fromUtf8(s));
  }
  else {
    db=_app->getAppData();
    assert(db);
    db=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_DEFAULT,
                        "gui/views/introview/dynamic");
    GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                        "firstStart", 0);
    GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                         "startPage", "index.html");
    textBrowser->setSource("first.html");
  }

  return true;
}



bool IntroView::fini(){
  return true;
}



void IntroView::slotSetup(){
  KBankingSettings *dlg;

  dlg=new KBankingSettings(_app);
  dlg->setModal(true);
  if (dlg->init()) {
    DBG_ERROR(0, "Could not init settings dialog");
    return;
  }
  dlg->exec();
  _app->flagStaff()->accountsUpdated();

  if (dlg->fini()) {
    DBG_ERROR(0, "Could not deinit settings dialog");
    return;
  }

}


void IntroView::slotLinkClicked(const QString &link){
  DBG_ERROR(0, "Link \"%s\" clicked.", link.latin1());

  if (link.find("cmd://", 0, false)==0) {
    if (link.lower()=="cmd://setup/")
      slotSetup();
    else if (link.find("cmd://page", 0, false)==0) {
      int i1=-1, i2=-1;

      i1=link.find('(');
      if (i1!=-1)
        i2=link.find(')', i1);
      if (i1==-1 || i2==-1) {
        QMessageBox::critical(this,
                              tr("Documentation Error"),
                              tr("The document %1 uses the malformed "
                                 "command \"%2\" in a HTML link."
                                )
                              .arg(textBrowser->source())
                              .arg(link),
                              tr("Dismiss"), QString::null);
      }
      else {
        QString qs;

        qs=link.mid(i1+1, i2-i1-1);
        if (!_app->getMainWindow()->setTabWidget(qs)) {
          DBG_ERROR(0, "Error setting tab \"%s\"", qs.latin1());
          QMessageBox::critical(this,
                                tr("Documentation Error"),
                                tr("The document %1 tries to select the "
                                   "unknown page \"%2\" in a HTML link."
                                  )
                                .arg(textBrowser->source())
                                .arg(qs),
                                tr("Dismiss"), QString::null);
        }
      }
    }
    else {
      QMessageBox::critical(this,
                            tr("Documentation Error"),
                            tr("The document %1 uses the unknown "
                               "command \"%2\" in a HTML link."
                              )
                            .arg(textBrowser->source())
                            .arg(link),
                            tr("Dismiss"), QString::null);
    }
  }
  else
    textBrowser->setSource(link);
}



