/***************************************************************************
 $RCSfile: app.h,v $
                             -------------------
    cvs         : $Id: app.h,v 1.32 2006/03/08 15:38:34 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef KBANKING_APP_H
#define KBANKING_APP_H

#ifdef FRONTEND_QT
# define FRONTEND_CLASS QBanking
# include <qbanking/qbanking.h>
#endif

#ifdef FRONTEND_KDE
# define FRONTEND_CLASS KBanking
# include <kbanking/kbanking.h>
#endif

#ifdef FRONTEND_CONSOLE
# define FRONTEND_CLASS CBanking
# include <cbanking/cbanking.h>
#endif


#define APP_LAST_VERSION_NONE 0xffffffff



typedef enum {
  TMatcherDateRange_All=0,
  TMatcherDateRange_UntilToday,
  TMatcherDateRange_CurrentMonth,
  TMatcherDateRange_CurrentYear,
  TMatcherDateRange_MonthToDate,
  TMatcherDateRange_YearToDate,
  TMatcherDateRange_LastMonth,
  TMatcherDateRange_LastYear,
  TMatcherDateRange_Last30Days,
  TMatcherDateRange_Last3Months,
  TMatcherDateRange_Last6Months,
  TMatcherDateRange_Last12Months,
  TMatcherDateRange_UserDefined
} TMATCHER_DATERANGE;


typedef enum {
  TMatcherAmountRange_All=0,
  TMatcherAmountRange_Exactly,
  TMatcherAmountRange_Range,
  TMatcherAmountRange_Less,
  TMatcherAmountRange_More
} TMATCHER_AMOUNTRANGE;



typedef enum {
  TextMatcherOperation_Unknown=-1,
  TextMatcherOperation_Equals=0,
  TextMatcherOperation_EqualsNot,
  TextMatcherOperation_Contains,
  TextMatcherOperation_ContainsNot,
  TextMatcherOperation_MatchesRegExp,
  TextMatcherOperation_MatchesRegExpNot
} TEXTMATCHER_OPERATION;


//#include <qbanking/banking.h> use this for non-qt programs
#include <qbanking/qbanking.h> // use this for qt-programs

class App;



#include "account.h"
#include "refpointer.h"
#include "transaction.h"
#include "transfer.h"
#include "standingorder.h"
#include "payee.h"
#include "category.h"


#include <gwenhywfar/gwentime.h>
#include <gwenhywfar/types.h>


/**
 * Change the heritage of QBanking to Banking for non-qt programs.
 */
class App: public FRONTEND_CLASS {
public:
  App(const char *appname,
      const char *fname=0);
  virtual ~App();

  int init();
  int fini();

  bool updateAccountList();
  virtual void appInfoTransactionsChanged(Account *a);

  void addAccount(Account *a);
  Account *findAccount(const char *bankCode,
                       const char *accountNumber);
  std::list<Account*> &getAppAccounts();

  Payee *findPayeeById(const char *id);
  Payee *findPayeeByName(const char *name);
  Payee *findPayeeByTransactionMatch(const Transaction *t);
  const std::list<Payee*> &getPayees();
  bool addPayee(Payee *p);
  bool removePayee(Payee *p);

  Category *findCategoryById(const char *id);
  Category *findCategoryByName(const char *name);
  Category *findCategoryByTransactionMatch(const Transaction *t);
  const std::list<Category*> &getCategories();
  bool addCategory(Category *cat, Category *parent);
  bool removeCategory(Category *cat);
  void reparentCategory(Category *cat, Category *newParent);

  void sortCategories();

  virtual bool importContext(AB_IMEXPORTER_CONTEXT *ctx,
                             GWEN_TYPE_UINT32 flags);

  int exportTransactions(GWEN_DB_NODE *dbRule,
                         const std::list<RefPointer<Transaction> > &tl);


  std::list<RefPointer<Transfer> > getTransfers();
  void addTransfer(RefPointer<Transfer> t);

  std::list<RefPointer<StandingOrder> > getStandingOrders();
  void addStandingOrder(RefPointer<StandingOrder> t);

  std::list<RefPointer<Transfer> > getDatedTransfers();
  void addDatedTransfer(RefPointer<Transfer> t);

  RefPointer<Transfer> findTransferByTransactionId(GWEN_TYPE_UINT32 id);

  GWEN_TYPE_UINT32 getNextUniqueId();

  void nextSession();
  GWEN_TYPE_UINT32 getLastSessionId();

  void scanJobList(AB_JOB_LIST2 *jl);
  void scanAllJobs();

  GWEN_DB_NODE *getTransactionMatcherRules();
  /* takes over the db */
  void setTransactionMatcherRules(GWEN_DB_NODE *db);

  GWEN_DB_NODE *getExportRules();
  void setExportRules(GWEN_DB_NODE *db);

  bool getMatchingTransactions(GWEN_DB_NODE *dbRule,
                               std::list<RefPointer<Transaction> > &tl);
  bool ruleAppliesToTransaction(GWEN_DB_NODE *dbRule,
                                const Transaction *t);

  bool optionAutoAssignPayee();
  void setOptionAutoAssignPayee(bool b);

  bool optionAutoAskForPayee();
  void setOptionAutoAskForPayee(bool b);

  bool optionAutoAssignCategory();
  void setOptionAutoAssignCategory(bool b);

  bool optionAutoAskForCategory();
  void setOptionAutoAskForCategory(bool b);

  GWEN_TYPE_UINT32 getLastVersion() const;

  GWEN_TYPE_UINT32 getFuzzyThreshold() const;
  void setFuzzyThreshold(GWEN_TYPE_UINT32 i);

  GWEN_TYPE_UINT32 getSensitiveFuzzyThreshold() const;
  void setSensitiveFuzzyThreshold(GWEN_TYPE_UINT32 i);

  static GWEN_TIME *adjustedDate(const GWEN_TIME *pt);

  static TEXTMATCHER_OPERATION string2TextMatcherOperation(const char *s);
  static const char *textMatcherOperation2String(TEXTMATCHER_OPERATION op);

  int loadPayees();
  int savePayees();

  int loadCategories();
  int saveCategories();

  static GWEN_TYPE_UINT64 char2uint64(const char *str);

  virtual std::string tr(const char *s);

private:
  GWEN_TYPE_UINT32 _lastUniqueId;
  GWEN_TYPE_UINT32 _lastSessionId;
  GWEN_TYPE_UINT32 _fuzzyThreshold;
  GWEN_TYPE_UINT32 _sensitiveFuzzyThreshold;
  GWEN_TYPE_UINT32 _lastVersion;
  std::list<Account*> _accounts;
  std::list<Payee*> _payees;
  std::list<Category*> _categories;
  GWEN_DB_NODE *_xaMatcherRules;
  GWEN_DB_NODE *_exportRules;
  GWEN_TYPE_UINT32 _lastPayeeId;
  GWEN_TYPE_UINT32 _lastCategoryId;
  bool _optionAutoAssignPayee;
  bool _optionAutoAskForPayee;
  bool _optionAutoAssignCategory;
  bool _optionAutoAskForCategory;

  int _getPayeesFileName(GWEN_BUFFER *bdir);
  int _getCategoriesFileName(GWEN_BUFFER *bdir);
  bool _textMatches(const std::string &text, GWEN_DB_NODE *dbR);
  void _adjustRules(GWEN_DB_NODE *db);
  bool _ruleAppliesToTransaction(GWEN_DB_NODE *dbRule,
                                 const Transaction *t,
                                 bool prematched);
  Category *_findCategoryById(Category *where, const char *id);
  Category *_findCategoryByName(Category *where, const char *name);
  Category *_findCategoryByTransactionMatch(Category *where,
                                            const Transaction *t);
  static void _sortCategories(std::list<Category*> &cl);

  int _loadCategoryFile(const char *fname);

  std::string _stringToLower(const char *s);

};



#define APP_FUZZY_SHIFT 10
#define APP_FUZZY_THRESHOLD 850
#define APP_FUZZY_SENSITIVE_THRESHOLD 650

/**
 * Returns the similarity of two strings as a value between 0 and
 * 1 << APP_FUZZY_SHIFT (currently that is between 0 and 1024).
 *
 * The algorithm has been copied and adapted from fuzzy.c of
 * gtk-gnutella (Copyright (c) 2002, Vidar Madsen).
 * Gtk-Gnutella is licensed under the GPL.
 */
GWEN_TYPE_UINT32 App_FuzzyCompare(const char *str1, const char *str2);



#endif /* KBANKING_APP_H */
