/***************************************************************************
 $RCSfile: selecttransfers.h,v $
                             -------------------
    cvs         : $Id: selecttransfers.h,v 1.1 2005/09/07 15:38:38 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef AQBANKING_KDE_SELECTTRANSFERS_H
#define AQBANKING_KDE_SELECTTRANSFERS_H

class KBanking;


#include "selecttransfers.ui.h"
#include "transfer.h"
#include "refpointer.h"

#include <gwenhywfar/db.h>


class SelectTransfers: public SelectTransfersUi {
  Q_OBJECT
private:
  KBanking *_app;
  std::list<RefPointer<Transfer> > _transfers;

public:
  SelectTransfers(KBanking *kb,
                  const QString &title,
                  std::list<RefPointer<Transfer> > tl,
                  QWidget* parent=0,
                  const char* name=0,
                  bool modal=FALSE,
                  WFlags fl=0);
  ~SelectTransfers();

  bool init();
  bool fini();

  std::list<RefPointer<Transfer> > getSelectedTransfers();

  static bool selectTransfers(KBanking *kb,
                              std::list<RefPointer<Transfer> > tl,
                              std::list<RefPointer<Transfer> > &selected,
                              QWidget* parent=0);

};


#endif


