/***************************************************************************
 $RCSfile: askdate.cpp,v $
                             -------------------
    cvs         : $Id: askdate.cpp,v 1.6 2006/01/07 09:30:29 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "askdate.h"
#include "kbanking.h"

#include <qdatetime.h>
#include <qdatetimeedit.h>
#include <qmessagebox.h>
#include <qtextbrowser.h>
#include <qpushbutton.h>

#include <gwenhywfar/debug.h>



AskDate::AskDate(KBanking *kb,
                 const Transaction *t,
                 const GWEN_TIME *lastTime,
                 QWidget* parent,
                 const char* name,
                 bool modal,
                 WFlags fl)
:AskDateUi(parent, name, modal, fl)
,_app(kb) {
  std::string tx;

  if (!lastTime)
    dateEdit->setDate(QDate::currentDate());
  else {
    int year, month, day;

    if (!GWEN_Time_GetBrokenDownDate(lastTime,
                                     &day, &month, &year)) {
      DBG_ERROR(0, "Internal error: could not break down date");
      dateEdit->setDate(QDate::currentDate());
    }
    else {
      dateEdit->setDate(QDate(year, month, day));
    }
  }
  dateEdit->setRange(QDate::currentDate().addDays(-365*10),
                     QDate::currentDate());

  tx=t->toHtmlInfo();
  tx="<qt>"+tx+"</qt>";
  transactionEdit->setText(QString::fromUtf8(tx.c_str()));

  QObject::connect(helpButton, SIGNAL(clicked()),
                   this, SLOT(slotHelp()));
  QObject::connect(todayButton, SIGNAL(clicked()),
                   this, SLOT(slotToday()));
}


AskDate::~AskDate(){
}



void AskDate::slotHelp(){
  _app->invokeHelp("AskDate", "dialog/askdate");
}



void AskDate::slotToday(){
  dateEdit->setDate(QDate::currentDate());
}



void AskDate::accept(){
  GWEN_TIME *ti;

  ti=selectedDate();
  if (!ti) {
    QMessageBox::critical(this,
                          tr("No Date Selected"),
                          tr("Please select the transaction date."),
                          tr("Dismiss"), QString::null);
    return;
  }

  GWEN_Time_free(ti);
  QDialog::accept();

}



void AskDate::reject(){
  QDialog::reject();
}



GWEN_TIME *AskDate::selectedDate(){
  QDate d=dateEdit->date();
  GWEN_TIME *ti;

  if (d.isNull()) {
    DBG_INFO(0, "Bad date");
    return 0;
  }
  ti=GWEN_Time_new(d.year(),
                   d.month()-1,
                   d.day(),
                   0, 0, 0,
                   0); // local time representation
  assert(ti);
  return ti;
}










