/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson   *
 *   nq@altern.org   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATECONVERTUNITSDIALOG_H
#define QALCULATECONVERTUNITSDIALOG_H

#include <kdialogbase.h>
#include <qmap.h>

class KLineEdit;
class Unit;
class KListView;
class QListViewItem;

/**
@author Niklas Knutsson
*/
class QalculateConvertUnitsDialog : public KDialogBase {

	Q_OBJECT

public:

	QalculateConvertUnitsDialog(QWidget *parent = 0, const char *name = 0);
	virtual ~QalculateConvertUnitsDialog();

	KLineEdit *unitExpressionEdit;
	
	void addUnitTreeItem(Unit *f);
	QMap<QListViewItem*, Unit*> unitItems;
	QMap<QListViewItem*, QString> categoryItems;

	KListView *categoryView;
	KListView *unitView;
	
	QString selected_category;
	bool block_unit_convert;

public slots:

	void updateUnitTree();
	void unitSelected();
	void categorySelected();

signals:

	void unitsChanged();

};

#endif
