#! /usr/bin/python
#
# File: test.py
# Author: Toshio Kuratomi <toshio@tiki-lounge.com>
# Date: 24 September, 2004
# Copyright: Toshio Kuratomi
# License: GPL
# Id: $Id: test.py 163 2005-02-21 13:30:39Z badger $
'''Automated testing harness to drive the unittests for QA Assistant.
'''
__revision__ = '$Rev: 163 $'

import sys
import os
import unittest

if os.environ.has_key('srcdir'):
    srcdir = os.environ['srcdir']
else:
    srcdir = '.'

sys.path.extend((os.path.join(srcdir, '..', 'src'),
    os.path.join('..', 'src')))

import creationtest
import checklisttest
import treetipstest
import propertiestest

if __name__ == '__main__':
    createSuite = creationtest.suite()
    propertiesSuite = propertiestest.suite()
    checkSuite = checklisttest.suite()
    treetipSuite = treetipstest.suite()
    suite = unittest.TestSuite((createSuite, treetipSuite, propertiesSuite,
        checkSuite))
    result = unittest.TextTestRunner(verbosity=2).run(suite)
    if result.wasSuccessful():
        sys.exit(0)
    else:
        sys.exit(1)
