#
# Copyright (c) 2002, 2003 Art Haas
#
# This file is part of PythonCAD.
#
# PythonCAD is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# PythonCAD is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with PythonCAD; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# menu code
#
# the menu things below should remain interface neutral
#

primary_menus = [('_File', 'FILE_MENU', 'file_menu_init'),
                 ('_Edit', 'EDIT_MENU', 'edit_menu_init'),
                 ('_Draw', 'DRAW_MENU', 'draw_menu_init'),
                 ('_Modify', 'MODIFY_MENU', 'modify_menu_init'),
                 ('D_imensions', 'DIMENSION_MENU', 'dimension_menu_init'),
                 ('De_bug', 'DEBUG_MENU', 'debug_menu_init'),
                 ]
submenus = {}

file_menu = [ ['_New', 'file_new', 'NEW', 'N' ],
              ['_Open', 'file_open', 'OPEN', 'O'],
              ['_Close', 'file_close', 'CLOSE', 'W'],
              [None],
              ['_Save', 'file_save', 'SAVE', 'S'],
              ['Save As ...', 'file_save_as', 'SAVE_AS', None],
              ['Save Layer As ...', 'file_save_layer', None, None],
              [None],
              ['_Quit', 'file_quit', 'QUIT', 'Q'],
              ]

submenus['FILE_MENU'] = file_menu

edit_menu = [ ['Undo', 'edit_undo', 'UNDO', 'Z'],
              ['Redo', 'edit_redo', 'REDO', None],
              [None],
              ['Cut', 'edit_cut', 'CUT', 'X'],
              ['Copy', 'edit_copy', 'COPY', 'C'],
              ['Paste', 'edit_paste', 'PASTE', 'V'],
              [None],
              ['Select', 'select_cb', None, None],
              ['Select All ...', 'EDIT_SELECT_ALL_MENU', 'select_all_init'],
              [None],
              ['Preferences', 'prefs', 'PREFS', None]
              ]

submenus['EDIT_MENU'] = edit_menu

edit_select_all_menu = [ ['Points', 'select_all_points', None, None],
                         ['Segments', 'select_all_segments', None, None],
                         ['Circles', 'select_all_circles', None, None],
                         ['Arcs', 'select_all_arcs', None, None],
                         ['HCLines', 'select_all_hclines', None, None],
                         ['VCLines', 'select_all_vclines', None, None],
                         ['ACLines', 'select_all_aclines', None, None],
                         ['CLines', 'select_all_clines', None, None],
                         ['CCircles', 'select_all_ccircles', None, None],
                         ['Linear Dims', 'select_all_ldims', None, None],
                         ['Horiz. Dims', 'select_all_hdims', None, None],
                         ['Vert. Dims', 'select_all_vdims', None, None],
                         ['Radial Dims.', 'select_all_rdims', None, None],
                         ['Angular Dims.', 'select_all_adims', None, None],
                         ]

submenus['EDIT_SELECT_ALL_MENU'] = edit_select_all_menu

draw_menu = [ ['Basic', 'DRAW_BASIC_MENU', 'draw_basic_init'],
              ['Con. Lines', 'DRAW_CONLINES_MENU', 'draw_conlines_init'],
              ['Con. Circles', 'DRAW_CONCIRCS_MENU', 'draw_concircs_init'],
              ['Chamfer', 'draw_chamfer', None, None],
              ['Fillet', 'draw_fillet', None, None],
              [None],
              ['Leader', 'draw_leader', None, None],
              [None],
              ['Polyline', 'draw_polyline', None, None],
              [None],
              ['Polygon', 'draw_polygon', None, None],
              ['Polygon (ext)', 'draw_ext_polygon', None, None],
              [None],
              ['Text', 'draw_text', None, None],
              [None],
              ['Set ...', 'DRAW_SET_MENU', 'draw_set_init'],
              [None],
              ['Add New ...', 'DRAW_ADD_MENU', 'draw_add_init']
              ]

submenus['DRAW_MENU'] = draw_menu

draw_basic_menu = [ ['Points', 'draw_point' , None, None],
                    ['Segments', 'draw_segment', None, None],
                    ['Rectangles', 'draw_rectangle', None, None],
                    ['Circle (cen)', 'draw_circle_center', None, None],
                    ['Circle (2 pts)', 'draw_circle_tp', None, None],
                    ['Arc', 'draw_arc_center', None, None],
                    ]

submenus['DRAW_BASIC_MENU'] = draw_basic_menu

draw_conlines_menu = [ ['Horizontal', 'draw_hcl', None, None],
                       ['Vertical', 'draw_vcl', None, None],
                       ['Angled', 'draw_acl', None, None],
                       ['Two-Point', 'draw_cl', None, None],
                       ['Perpendicular', 'draw_perpendicular_cline', None, None],
                       ['Tangent', 'draw_tangent_cline', None, None],
                       ['Tangent 2 Circs', 'draw_tangent_two_ccircles', None, None],
                       ['Parallel', 'draw_poffset_cline', None, None],
                       ]

submenus['DRAW_CONLINES_MENU'] = draw_conlines_menu

draw_concircs_menu = [ ['Center Point', 'draw_ccirc_cp', None, None],
                       ['Two-Point', 'draw_ccirc_tp', None, None],
                       ['Tangent', 'DRAW_TANGENT_CCIRCLE_MENU', 'draw_tangent_ccircle_menu_init']
                       ]

submenus['DRAW_CONCIRCS_MENU'] = draw_concircs_menu

draw_tangent_ccircle_menu = [ ['One object', 'draw_tangent_single_conobj', None, None],
                              ['Two objects', 'draw_tangent_two_conobjs', None, None],
                              ]

submenus['DRAW_TANGENT_CCIRCLE_MENU'] = draw_tangent_ccircle_menu

draw_set_menu = [ ['Style', 'draw_set_style', None, None],
                  ['Linetype', 'draw_set_linetype', None, None],
                  ['Color', 'draw_set_color', None, None],
                  ['Thickness', 'draw_set_thickness', None, None],
                  ]

submenus['DRAW_SET_MENU'] = draw_set_menu

draw_add_menu = [ ['Style', 'cb', None, None],
                  ['Linetype', 'cb', None, None],
                  ['Color', 'cb', None, None],
                  ]

submenus['DRAW_ADD_MENU'] = draw_add_menu

modify_menu =  [ ['Move ...', 'MODIFY_MOVE_MENU', 'modify_move_init'],
                 ['Stretch ...', 'MODIFY_STRETCH_MENU', 'modify_stretch_init'],
                 ['Split', 'split', None, None],
                 ['Mirror', 'mirror', None, None],
                 ['Transfer', 'transfer', None, None],
                 [None],
                 ['Delete', 'delete', 'DELETE', None],
                 [None],
                 ['Change ...', 'MODIFY_CHANGE_MENU', 'modify_change_init'],
                 [None],
                 ['Zoom', 'zoom', None, None],
                 ['Zoom In', 'zoom_in', 'ZOOM_IN', None],
                 ['Zoom Out', 'zoom_out', 'ZOOM_OUT', None],
                 ['Zoom Fit', 'zoom_fit', 'ZOOM_FIT', None],
                 ]
submenus['MODIFY_MENU'] = modify_menu

modify_move_menu = [ ['Horizontal' ,'move_horiz', None, None],
                     ['Vertical', 'move_vert', None, None],
                     ['Both', 'move_twopoint', None, None],
                     ]

submenus['MODIFY_MOVE_MENU'] = modify_move_menu

modify_stretch_menu = [ ['Horizontal', 'stretch_horiz', None, None],
                        ['Vertical', 'stretch_vert', None, None],
                        ['Both', 'stretch_twopoint', None, None],
                        ]

submenus['MODIFY_STRETCH_MENU'] = modify_stretch_menu

modify_change_menu = [ ['Style', 'change_style', None, None],
                       ['Linetype', 'change_linetype', None, None],
                       ['Color', 'change_color', None, None],
                       ['Thickness', 'change_thickness', None, None],
                       ]

submenus['MODIFY_CHANGE_MENU'] = modify_change_menu

dimension_menu = [ ['Linear', 'dimension_linear' , None, None ],
                   ['Horizontal', 'dimension_horiz', None, None ],
                   ['Vertical', 'dimension_vert', None, None ],
                   ['Radial', 'dimension_rad', None, None],
                   ['Angular', 'dimension_ang', None, None ],
                   ]

submenus['DIMENSION_MENU'] = dimension_menu

debug_menu = [ ['Focus', 'get_focus_widget', None, None],
               ['UndoStack', 'undo_stack', None, None],
               ['RedoStack', 'redo_stack', None, None],
               ['ImageUndo', 'image_undo', None, None],
               ['ImageRedo', 'image_redo', None, None],
               ]

submenus['DEBUG_MENU'] = debug_menu
