// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.
#include "ring.h"
#include GL_INCLUDE    // see platform.h

namespace visual {

vector
ring::getScale()
{
	return vector( radius, radius, radius);
}

void
ring::glRender( rView& view)
{
	if (degenerate)
		return;

	float cR = thickness ? thickness / radius : 0.1;

      /*double brect[] = {  cR,  1.0+cR,  1.0+cR,
                         -cR, -1.0-cR, -1.0-cR };
      view.ext_brect(mwt, brect);*/
 
	view.ext_circle(mwt*vector(-cR,0,0), wlt[0], (1.0+cR)*radius);
	view.ext_circle(mwt*vector( cR,0,0), wlt[0], (1.0+cR)*radius);

	lighting lt(view.lights, wlt);
	tmatrix mct(mwt, view.wct);

	// Level-of-detail heuristic.
	//   xxx Figure out how this should actually work!
	vector a = mct*vector(0,0,0) / mct.w(vector(0,0,0));
	vector b = mct*vector(0.5,0,0) / mct.w(vector(0.5,0,0));
	vector c = mct*vector(0,0.5,0) / mct.w(vector(0,0.5,0));
	vector d = mct*vector(0,0,0.5) / mct.w(vector(0,0,0.5));
	float size = std::sqrt((a-b).mag2() + (a-c).mag2() + (a-d).mag2());

	int turns = int(size * 100);
	if (turns<5)
		turns=5;
	else if (turns>25)
		turns=25;

	int around = int(size * 250 * cR);
	if (around<4)
		around=4;
	else if (around>16)
		around=16;

	// Projection and lighting loop
	static vertex proj[40*16];
	static float  colarr[40*16*4];
	static int index[40*16*2 + 2];
	vertex* pr = proj;
	float* col = colarr;

	int nv = turns*around;
	index[nv*2] = 0;
	index[nv*2+1] = around;

	for(int v=0;v<nv;v++) {
		index[v*2] = v;
		index[v*2+1] = v + around;
		if (v+around >= nv)
			index[v*2+1] -= nv;

		float theta = v * 2*pi / nv;
		float phi = v * 2*pi / around;
		float cosPhi = std::cos(phi);

		vector r(0, std::cos(theta), std::sin(theta));
		vector n( std::sin(phi), r.y*cosPhi, r.z*cosPhi);
		vector p = n*cR + r;

		double illum = lt.illuminate(n);

		col[0] = color.r*illum;
		col[1] = color.g*illum;
		col[2] = color.b*illum;
		col[3] = 1.0;
		col += 4;

		mct.project(p, *pr++);
	}

	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_COLOR_ARRAY);
	glVertexPointer(4, GL_DOUBLE, sizeof(vertex), &proj[0].x);
	glColorPointer(4, GL_FLOAT, 4*sizeof(float), colarr);
	glShadeModel(GL_SMOOTH);

	glDrawArrays(GL_TRIANGLE_STRIP, 0, nv);
	glDrawElements(GL_TRIANGLE_STRIP, 2*nv+2, GL_UNSIGNED_INT, index);
}

} // !namespace visual
