/*!

@authors Andrei Novikov (pyclustering@yandex.ru)
@date 2014-2020
@copyright GNU Public License

@cond GNU_PUBLIC_LICENSE
    pyclustering is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    pyclustering is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
@endcond

*/

#pragma once


#include <pyclustering/interface/pyclustering_package.hpp>

#include <pyclustering/definitions.hpp>


/*!

@brief   Clustering algorithm Agglomerative returns allocated clusters.
@details Caller should destroy returned result in 'pyclustering_package'.

@param[in] p_sample: input data for clustering.
@param[in] p_number_clusters: amount of clusters that should be allocated.
@param[in] p_link: type of links for merging clusters.

@return  Returns result of clustering - array of allocated clusters. The last cluster in the
          array is noise.

*/
extern "C" DECLARATION pyclustering_package * agglomerative_algorithm(const pyclustering_package * const p_sample, const std::size_t p_number_clusters, const std::size_t p_link);
