import re
import sys

pats = (
    ("theme.get_options()", "Options"),
    ("area.T", "area"), 
    ("interval_bar_plot.T", "interval-bar-plot"),
    ("bar_plot.T", "bar-plot"),
    ("line_plot.T", "line-plot"),
    ("range_plot.T", "range-plot"),
    ("pie_plot.T", "pie-plot"),
    ("color\\.", "color"),
    ("line_style\\.", "line-style"),
    ("fill_style\\.", "fill-style"),
    ("tick_mark\\.", "tick-mark"),
    ("log_coord\\.T", "coord"),
    ("linear_coord\\.T", "coord"),
    ("category_coord\\.T", "coord"),
    ("error_bar\\.", "error-bar"),
    ("text_box\\.T", "text-box"),
    ("arrow\\.T", "arrow"),
    ("axis\\.", "axis"),
    ("chart_data\\.", "chart-data"),
    ("legend\\.", "legend"),
    ("theme\\.", "Options"),
    ("canvas\\.", "canvas"),
    ("zap\\.", "zap"),
    )

re_pats = {}
for pat, repl in pats:
    re_pats[re.compile("(" + pat + ")")] = repl

def hackimgref(mo):
    path = mo.group(1)
    i = path.rfind("/")
    path2 = path[(i+1):]
    print >>sys.stderr, "PATH=", path, path2
    return 'SRC="%s"' % path2
    
in_example = False
for l in sys.stdin.readlines():
    l = re.sub('SRC="(/nfs[^\"]+)"', hackimgref, l)
               
    if re.match(".*<pre[^>]*>", l):
        in_example = True
    elif l.find("</pre>") >= 0:
        in_example = False
        
    if not in_example:
        l = re.sub("<head>", """<head><style type="text/css">\npre {background-color: #e0e0e0}\n</style>\n""", l)
        print l,
        continue

    for str, ref in pats:
        l = re.sub("(" + str + ")", "<a href=\"%s.html\">\\1</a>" % ref, l)
        #l = re.sub(str, "<a href=\"%s.html\">\\1</a>" % ref, l)
    print l,
    
        

        
        
