#!/usr/bin/python

from bug_tasks                   import BugTasks
from milestone                   import Milestone

# DistributionSourcePackage
#
class DistributionSourcePackage(object):
    # __init__
    #
    def __init__(self, service, lp_distribution):
        self.__service         = service
        self.__lp_distribution = lp_distribution
        self.__display_name    = None
        self.__name            = None
        self.__title           = None

    # display_name
    #
    @property
    def display_name(self):
        if self.__display_name == None:
            self.__display_name = self.__lp_distribution.display_name
        return self.__display_name

    # name
    #
    @property
    def name(self):
        if self.__name == None:
            self.__name = self.__lp_distribution.name
        return self.__name

    # title
    #
    @property
    def title(self):
        if self.__title == None:
            self.__title = self.__lp_distribution.title
        return self.__title

    # searchTasks
    #
    def search_tasks(self, **params):
        if 'milestone' in params and isinstance(params['milestone'], Milestone):
            params['milestone'] = params['milestone'].raw
        bt = BugTasks(self.__service, self.__lp_distribution.searchTasks(**params))
        return bt

# vi:set ts=4 sw=4 expandtab:
