/* glpkpi.c (C functions for setting/canceling printing in the stdout) */

/*----------------------------------------------------------------------
-- This code is part of the Python-GLPK interface.
--
-- Copyright (C) 2005-2009, Joao Pedro Pedroso
-- Faculdade de Ciencias, Universidade do Porto
-- Porto, Portugal. All rights reserved. E-mail: <jpp@fc.up.pt>.
--
-- GLPK is free software; you can redistribute it and/or modify it
-- under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2, or (at your option)
-- any later version.
--
-- GLPK is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public
-- License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with GLPK; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
-- 02110-1301, USA.
----------------------------------------------------------------------*/

#include <stdlib.h>
#include <glpk.h>


/*
  written by jpp
*/
static int no_print_hook(void *info, const char *s) {
  return 1;
}

void glp_no_print() {
  glp_term_hook(no_print_hook, NULL);
}

void glp_do_print() {
  glp_term_hook(NULL, NULL);
}

/* !!! not defined in glpk's library !!! */
_glp_data *_glp_sds_open(const char *fname) {}
void _glp_sds_jump(_glp_data *data, void *jump) {}
void _glp_sds_error(_glp_data *data, const char *fmt, ...) {}
void _glp_sds_warning(_glp_data *data, const char *fmt, ...) {}
int _glp_sds_int(_glp_data *data) {}
double _glp_sds_num(_glp_data *data) {}
const char *_glp_sds_item(_glp_data *data) {}
const char *_glp_sds_text(_glp_data *data) {}
int _glp_sds_line(_glp_data *data) {}
void _glp_sds_close(_glp_data *data) {}

