# Copyright (C) 2007-2008 Gustavo Sverzut Barbieri, Carsten Haitzler
#
# This file is part of Python-Ecore.
#
# Python-Ecore is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# Python-Ecore is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this Python-Ecore.  If not, see <http://www.gnu.org/licenses/>.

#!/usr/bin/env python2

from c_ecore_x import *

ECORE_X_CURSOR_X = 0
ECORE_X_CURSOR_ARROW = 2
ECORE_X_CURSOR_BASED_ARROW_DOWN = 4
ECORE_X_CURSOR_UP = 6
ECORE_X_CURSOR_BOAT = 8
ECORE_X_CURSOR_BOTTOM_LEFT_CORNER = 12
ECORE_X_CURSOR_BOTTOM_RIGHT_CORNER = 14
ECORE_X_CURSOR_BOTTOM_SIDE = 16
ECORE_X_CURSOR_BOTTOM_TEE = 18
ECORE_X_CURSOR_BOX_SPIRAL = 20
ECORE_X_CURSOR_CENTER_PTR = 22
ECORE_X_CURSOR_CIRCLE = 24
ECORE_X_CURSOR_CLOCK = 26
ECORE_X_CURSOR_COFFEE_MUG = 28
ECORE_X_CURSOR_CROSS = 30
ECORE_X_CURSOR_CROSS_REVERSE = 32
ECORE_X_CURSOR_CROSSHAIR = 34
ECORE_X_CURSOR_DIAMOND_CROSS = 36
ECORE_X_CURSOR_DOT = 38
ECORE_X_CURSOR_DOT_BOX_MASK = 40
ECORE_X_CURSOR_DOUBLE_ARROW = 42
ECORE_X_CURSOR_DRAFT_LARGE = 44
ECORE_X_CURSOR_DRAFT_SMALL = 46
ECORE_X_CURSOR_DRAPED_BOX = 48
ECORE_X_CURSOR_EXCHANGE = 50
ECORE_X_CURSOR_FLEUR = 52
ECORE_X_CURSOR_GOBBLER = 54
ECORE_X_CURSOR_GUMBY = 56
ECORE_X_CURSOR_HAND1 = 58
ECORE_X_CURSOR_HAND2 = 60
ECORE_X_CURSOR_HEART = 62
ECORE_X_CURSOR_ICON = 64
ECORE_X_CURSOR_IRON_CROSS = 66
ECORE_X_CURSOR_LEFT_PTR = 68
ECORE_X_CURSOR_LEFT_SIDE = 70
ECORE_X_CURSOR_LEFT_TEE = 72
ECORE_X_CURSOR_LEFTBUTTON = 74
ECORE_X_CURSOR_LL_ANGLE = 76
ECORE_X_CURSOR_LR_ANGLE = 78
ECORE_X_CURSOR_MAN = 80
ECORE_X_CURSOR_MIDDLEBUTTON = 82
ECORE_X_CURSOR_MOUSE = 84
ECORE_X_CURSOR_PENCIL = 86
ECORE_X_CURSOR_PIRATE = 88
ECORE_X_CURSOR_PLUS = 90
ECORE_X_CURSOR_QUESTION_ARROW = 92
ECORE_X_CURSOR_RIGHT_PTR = 94
ECORE_X_CURSOR_RIGHT_SIDE = 96
ECORE_X_CURSOR_RIGHT_TEE = 98
ECORE_X_CURSOR_RIGHTBUTTON = 100
ECORE_X_CURSOR_RTL_LOGO = 102
ECORE_X_CURSOR_SAILBOAT = 104
ECORE_X_CURSOR_SB_DOWN_ARROW = 106
ECORE_X_CURSOR_SB_H_DOUBLE_ARROW = 108
ECORE_X_CURSOR_SB_LEFT_ARROW = 110
ECORE_X_CURSOR_SB_RIGHT_ARROW = 112
ECORE_X_CURSOR_SB_UP_ARROW = 114
ECORE_X_CURSOR_SB_V_DOUBLE_ARROW = 116
ECORE_X_CURSOR_SHUTTLE = 118
ECORE_X_CURSOR_SIZING = 120
ECORE_X_CURSOR_SPIDER = 122
ECORE_X_CURSOR_SPRAYCAN = 124
ECORE_X_CURSOR_STAR = 126
ECORE_X_CURSOR_TARGET = 128
ECORE_X_CURSOR_TCROSS = 130
ECORE_X_CURSOR_TOP_LEFT_ARROW = 132
ECORE_X_CURSOR_TOP_LEFT_CORNER = 134
ECORE_X_CURSOR_TOP_RIGHT_CORNER = 136
ECORE_X_CURSOR_TOP_SIDE = 138
ECORE_X_CURSOR_TOP_TEE = 140
ECORE_X_CURSOR_TREK = 142
ECORE_X_CURSOR_UL_ANGLE = 144
ECORE_X_CURSOR_UMBRELLA = 146
ECORE_X_CURSOR_UR_ANGLE = 148
ECORE_X_CURSOR_WATCH = 150
ECORE_X_CURSOR_XTERM = 152

ECORE_X_WINDOW_CONFIGURE_MASK_X = 1
ECORE_X_WINDOW_CONFIGURE_MASK_Y = 2
ECORE_X_WINDOW_CONFIGURE_MASK_W = 4
ECORE_X_WINDOW_CONFIGURE_MASK_H = 8
ECORE_X_WINDOW_CONFIGURE_MASK_BORDER_WIDTH = 16
ECORE_X_WINDOW_CONFIGURE_MASK_SIBLING = 32
ECORE_X_WINDOW_CONFIGURE_MASK_STACK_MODE = 64

ECORE_X_EVENT_MASK_NONE = 0L                         # 0L
ECORE_X_EVENT_MASK_KEY_DOWN = 1L                     # (1L << 0)
ECORE_X_EVENT_MASK_KEY_UP = 2L                       # (1L << 1)
ECORE_X_EVENT_MASK_MOUSE_DOWN = 4L                   # (1L << 2)
ECORE_X_EVENT_MASK_MOUSE_UP = 8L                     # (1L << 3)
ECORE_X_EVENT_MASK_MOUSE_IN = 16L                    # (1L << 4)
ECORE_X_EVENT_MASK_MOUSE_OUT = 32L                   # (1L << 5)
ECORE_X_EVENT_MASK_MOUSE_MOVE = 64L                  # (1L << 6)
ECORE_X_EVENT_MASK_WINDOW_DAMAGE = 32768L            # (1L << 15)
ECORE_X_EVENT_MASK_WINDOW_VISIBILITY = 65536L        # (1L << 16)
ECORE_X_EVENT_MASK_WINDOW_CONFIGURE = 131072L        # (1L << 17)
ECORE_X_EVENT_MASK_WINDOW_RESIZE_MANAGE = 262144L    # (1L << 18)
ECORE_X_EVENT_MASK_WINDOW_MANAGE = 524288L           # (1L << 19)
ECORE_X_EVENT_MASK_WINDOW_CHILD_CONFIGURE = 1048576L # (1L << 20)
ECORE_X_EVENT_MASK_WINDOW_FOCUS_CHANGE = 2097152L    # (1L << 21)
ECORE_X_EVENT_MASK_WINDOW_PROPERTY = 4194304L        # (1L << 22)
ECORE_X_EVENT_MASK_WINDOW_COLORMAP = 8388608L        # (1L << 23)
ECORE_X_EVENT_MASK_WINDOW_GRAB = 16777216L           # (1L << 24)
ECORE_X_EVENT_MASK_MOUSE_WHEEL = 536870912L          # (1L << 29)
ECORE_X_EVENT_MASK_WINDOW_FOCUS_IN = 1073741824L     # (1L << 30)
ECORE_X_EVENT_MASK_WINDOW_FOCUS_OUT = 2147483648L    # (1L << 31)

ECORE_X_GRAVITY_FORGET = 0
ECORE_X_GRAVITY_UNMAP = 0
ECORE_X_GRAVITY_NW = 1
ECORE_X_GRAVITY_N = 2
ECORE_X_GRAVITY_NE = 3
ECORE_X_GRAVITY_W = 4
ECORE_X_GRAVITY_CENTER = 5
ECORE_X_GRAVITY_E = 6
ECORE_X_GRAVITY_SW = 7
ECORE_X_GRAVITY_S = 8
ECORE_X_GRAVITY_SE = 9
ECORE_X_GRAVITY_STATIC = 10

ECORE_X_WINDOW_STATE_ICONIFIED = 0
ECORE_X_WINDOW_STATE_MODAL = 1
ECORE_X_WINDOW_STATE_STICKY = 2
ECORE_X_WINDOW_STATE_MAXIMIZED_VERT = 3
ECORE_X_WINDOW_STATE_MAXIMIZED_HORZ = 4
ECORE_X_WINDOW_STATE_SHADED = 5
ECORE_X_WINDOW_STATE_SKIP_TASKBAR = 6
ECORE_X_WINDOW_STATE_SKIP_PAGER = 7
ECORE_X_WINDOW_STATE_HIDDEN = 8
ECORE_X_WINDOW_STATE_FULLSCREEN = 9
ECORE_X_WINDOW_STATE_ABOVE = 10
ECORE_X_WINDOW_STATE_BELOW = 11
ECORE_X_WINDOW_STATE_DEMANDS_ATTENTION = 12
ECORE_X_WINDOW_STATE_UNKNOWN = 13

ECORE_X_WINDOW_STATE_ACTION_REMOVE = 0
ECORE_X_WINDOW_STATE_ACTION_ADD = 1
ECORE_X_WINDOW_STATE_ACTION_TOGGLE = 2

ECORE_X_WINDOW_STACK_ABOVE = 0
ECORE_X_WINDOW_STACK_BELOW = 1
ECORE_X_WINDOW_STACK_TOP_IF = 2
ECORE_X_WINDOW_STACK_BOTTOM_IF = 3
ECORE_X_WINDOW_STACK_OPPOSITE = 4

ECORE_X_RANDR_ROT_0 = 1
ECORE_X_RANDR_ROT_90 = 2
ECORE_X_RANDR_ROT_180 = 4
ECORE_X_RANDR_ROT_270 = 8,
ECORE_X_RANDR_FLIP_X = 16,
ECORE_X_RANDR_FLIP_Y = 32

ECORE_X_SHAPE_BOUNDING = 0
ECORE_X_SHAPE_CLIP = 1

ECORE_X_WM_PROTOCOL_DELETE_REQUEST = 0
ECORE_X_WM_PROTOCOL_TAKE_FOCUS = 1
ECORE_X_NET_WM_PROTOCOL_PING = 2
ECORE_X_NET_WM_PROTOCOL_SYNC_REQUEST = 3
ECORE_X_WM_PROTOCOL_NUM = 4

ECORE_X_WINDOW_INPUT_MODE_NONE = 0
ECORE_X_WINDOW_INPUT_MODE_PASSIVE = 1
ECORE_X_WINDOW_INPUT_MODE_ACTIVE_LOCAL = 2
ECORE_X_WINDOW_INPUT_MODE_ACTIVE_GLOBAL = 3

ECORE_X_WINDOW_STATE_HINT_NONE = -1
ECORE_X_WINDOW_STATE_HINT_WITHDRAWN = 0
ECORE_X_WINDOW_STATE_HINT_NORMAL = 1
ECORE_X_WINDOW_STATE_HINT_ICONIC = 2

ECORE_X_WINDOW_TYPE_DESKTOP = 0
ECORE_X_WINDOW_TYPE_DOCK = 1
ECORE_X_WINDOW_TYPE_TOOLBAR = 2
ECORE_X_WINDOW_TYPE_MENU = 3
ECORE_X_WINDOW_TYPE_UTILITY = 4
ECORE_X_WINDOW_TYPE_SPLASH = 5
ECORE_X_WINDOW_TYPE_DIALOG = 6
ECORE_X_WINDOW_TYPE_NORMAL = 7
ECORE_X_WINDOW_TYPE_UNKNOWN = 8

ECORE_X_ACTION_MOVE = 0
ECORE_X_ACTION_RESIZE = 1
ECORE_X_ACTION_MINIMIZE = 2
ECORE_X_ACTION_SHADE = 3
ECORE_X_ACTION_STICK = 4
ECORE_X_ACTION_MAXIMIZE_HORZ = 5
ECORE_X_ACTION_MAXIMIZE_VERT = 6
ECORE_X_ACTION_FULLSCREEN = 7
ECORE_X_ACTION_CHANGE_DESKTOP = 8
ECORE_X_ACTION_CLOSE = 9

ECORE_X_WINDOW_CONFIGURE_MASK_X = 1
ECORE_X_WINDOW_CONFIGURE_MASK_Y = 2
ECORE_X_WINDOW_CONFIGURE_MASK_W = 4
ECORE_X_WINDOW_CONFIGURE_MASK_H = 8
ECORE_X_WINDOW_CONFIGURE_MASK_BORDER_WIDTH = 16
ECORE_X_WINDOW_CONFIGURE_MASK_SIBLING = 32
ECORE_X_WINDOW_CONFIGURE_MASK_STACK_MODE = 64

ECORE_X_WINDOW_LAYER_BELOW = 2
ECORE_X_WINDOW_LAYER_NORMAL = 4
ECORE_X_WINDOW_LAYER_ABOVE = 6

ECORE_X_PROP_LIST_REMOVE = 0
ECORE_X_PROP_LIST_ADD = 1
ECORE_X_PROP_LIST_TOGGLE = 2

ECORE_X_MWM_HINT_FUNC_ALL = 1
ECORE_X_MWM_HINT_FUNC_RESIZE = 2
ECORE_X_MWM_HINT_FUNC_MOVE = 4
ECORE_X_MWM_HINT_FUNC_MINIMIZE = 8
ECORE_X_MWM_HINT_FUNC_MAXIMIZE = 16
ECORE_X_MWM_HINT_FUNC_CLOSE = 32

ECORE_X_MWM_HINT_DECOR_ALL = 1
ECORE_X_MWM_HINT_DECOR_BORDER = 2
ECORE_X_MWM_HINT_DECOR_RESIZEH = 4
ECORE_X_MWM_HINT_DECOR_TITLE = 8
ECORE_X_MWM_HINT_DECOR_MENU = 16
ECORE_X_MWM_HINT_DECOR_MINIMIZE = 32
ECORE_X_MWM_HINT_DECOR_MAXIMIZE = 64

ECORE_X_MWM_HINT_INPUT_MODELESS = 0
ECORE_X_MWM_HINT_INPUT_PRIMARY_APPLICATION_MODAL = 1
ECORE_X_MWM_HINT_INPUT_SYSTEM_MODAL = 2
ECORE_X_MWM_HINT_INPUT_FULL_APPLICATION_MODAL = 3

ECORE_X_DAMAGE_REPORT_RAW_RECTANGLES = 0
ECORE_X_DAMAGE_REPORT_DELTA_RECTANGLES = 1
ECORE_X_DAMAGE_REPORT_BOUNDING_BOX = 2
ECORE_X_DAMAGE_REPORT_NON_EMPTY = 3

ECORE_X_VIRTUAL_KEYBOARD_STATE_UNKNOWN = 0
ECORE_X_VIRTUAL_KEYBOARD_STATE_OFF = 1
ECORE_X_VIRTUAL_KEYBOARD_STATE_ON = 2
ECORE_X_VIRTUAL_KEYBOARD_STATE_ALPHA = 3
ECORE_X_VIRTUAL_KEYBOARD_STATE_NUMERIC = 4
ECORE_X_VIRTUAL_KEYBOARD_STATE_PIN = 5
ECORE_X_VIRTUAL_KEYBOARD_STATE_PHONE_NUMBER = 6
ECORE_X_VIRTUAL_KEYBOARD_STATE_HEX = 7
ECORE_X_VIRTUAL_KEYBOARD_STATE_TERMINAL = 8
ECORE_X_VIRTUAL_KEYBOARD_STATE_PASSWORD = 9

init()
