/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __HEXAGGREGATEINSERTGENERATOR2D_H
#define __HEXAGGREGATEINSERTGENERATOR2D_H

// --- Project includes ---
#include "InsertGenerator2D.h"

/*!
  \class InsertGenerator2D

  Packing generator using Place et al. insertion based algorithm. 
*/
class HexAggregateInsertGenerator2D : public InsertGenerator2D
{
 protected:

  virtual void seedParticles(AVolume2D* ,MNTable2D* ,int,int);

 public:
  HexAggregateInsertGenerator2D();
  HexAggregateInsertGenerator2D(double,double,int,int,double);
  virtual ~HexAggregateInsertGenerator2D(){};

  virtual void fillIn(AVolume2D* ,MNTable2D* ,int,int);
};

#endif // __HEXAGGREGATEINSERTGENERATOR2D_H
