/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __HGRAINGENERATOR2D_H
#define __HGRAINGENERATOR2D_H

// --- Project includes ---
#include "AVolume2D.h"
#include "MNTable2D.h"
#include "AGenerator2D.h"

/*!
  \class HGrainGenerator2D

  class the generate hexagonal grains on a regular base lattice
*/
class HGrainGenerator2D : public AGenerator2D
{
 protected:
  double m_rad;

 public:
  HGrainGenerator2D();
  HGrainGenerator2D(double);
  virtual ~HGrainGenerator2D();

  virtual void generatePacking (AVolume2D*,MNTable2D*,int,int);

  friend ostream& operator << (ostream&,const HGrainGenerator2D&);
};


#endif // __HGRAINGENERATOR2D_H
