/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __TRIANGLE_3D
#define __TRIANGLE_3D

// project includes
#include "vector3.h"
#include "AGeometricObject.h"

/*!
  class for a triagle in 3D.
*/
class Triangle3D : public AGeometricObject
{
 private:
  Vector3 m_p1,m_p2,m_p3;
  int m_tag;

 public:
  Triangle3D(const Vector3&,const Vector3&,const Vector3&,int);

  virtual double getDist(const Vector3&) const;
  bool crosses(const Vector3&, const Vector3&) const;
  int getTag() const {return m_tag;};
  Vector3 getMinPoint() const;
  Vector3 getMaxPoint() const;
};

#endif // __TRIANGLE_3D
